### Code for Example 6.1 in 
### Ascent with Quadratic Assistance for the Construction of Exact Experimental Designs
### Lenka Filova, Radoslav Harman

library(OptimalDesign) #needed for functions F.simplex, F.IVtoA, od.infmat, od.plot

# the Scheffe model (may take several minutes on some computers)
F.scheffe <- F.simplex(~x1+x2+x3+x4+x5+I(x1*x2)+I(x1*x3)+I(x1*x4)+I(x1*x5)+I(x2*x3)+I(x2*x4)+
                       I(x2*x5)+I(x3*x4)+I(x3*x5)+I(x4*x5)-1, 5, 101)
F.scheffe <- F.scheffe[apply(F.scheffe[,1:5],1,max) <= 0.3, ]
F.scheffe <- F.scheffe[apply(F.scheffe[,1:5],1,min) >= 0.1, ]
n <- dim(F.scheffe)[1]
m <- dim(F.scheffe)[2]

# conversion of the model (for details, run ?F.IVtoA)
F <- F.IVtoA(F.scheffe)

# I-optimal approximate design
appI <- od.REX.A(F, supp.ini=sample(1:n, m), t.max=300)

# the exact design for N=30
M <- od.infmat(F, 30 * appI$w.best)
Qp30I <- od.AQuA.A(F, 30, M, t.max=200) #the positive version
cbind(F.scheffe[Qp30I$w.best > 0, 1:5], reps=Qp30I$w.best[Qp30I$w.best > 0])
od.plot(Qp30I$w.best, F.scheffe[,1:5])

Qm30I <- od.AQuA.A(F, 30, M, plus=FALSE, t.max=200) #the negative version
cbind(F.scheffe[Qm30I$w.best > 0, 1:5], reps=Qm30I$w.best[Qm30I$w.best > 0])
od.plot(Qm30I$w.best, F.scheffe[,1:5])


# the exact design for N=100
N <- 100
M <- od.infmat(F, 100 * appI$w.best)
Qp100I <- od.AQuA.A(F, 100, M, t.max=200) #the positive version
cbind(F.scheffe[Qp100I$w.best > 0, 1:5], reps=Qp100I$w.best[Qp100I$w.best > 0])
od.plot(Qp100I$w.best, F.scheffe[,1:5])

Qm100I <- od.AQuA.A(F, 100, M, plus=FALSE, t.max=200) #the negative version
cbind(F.scheffe[Qm100I$w.best > 0, 1:5], reps=Qm100I$w.best[Qm100I$w.best > 0])
od.plot(Qm100I$w.best, F.scheffe[,1:5])


#--------------------------------------------------------------------------------------------------

### Code for Example 6.2 in 
### Ascent with Quadratic Assistance for the Construction of Exact Experimental Designs
### Lenka Filova, Radoslav Harman

# the random models
F.r1 <- matrix(rnorm(6*10000), ncol=6)
F.r2 <- matrix(rnorm(15*10000), ncol=15)
F.r3 <- matrix(rnorm(6*100000), ncol=6)
F.r4 <- matrix(rnorm(15*100000), ncol=15)

# $D$-optimal approximate designs
appR1 <- od.REX.D(F.r1, supp.ini=sample(1:10000, 6))
appR2 <- od.REX.D(F.r2, supp.ini=sample(1:10000, 15))
appR3 <- od.REX.D(F.r3, supp.ini=sample(1:100000, 6))
appR4 <- od.REX.D(F.r4, supp.ini=sample(1:100000, 15))

# the exact designs for N=30 (positive versions) and their efficiencies
Qp.R1.30.D <- od.AQuA.D(F.r1, 30, od.infmat(F.r1, 30 * appR1$w.best), t.max=5)
Qp.R1.30.D$eff.best
Qp.R2.30.D <- od.AQuA.D(F.r2, 30, od.infmat(F.r2, 30 * appR2$w.best), t.max=20)
Qp.R2.30.D$eff.best
Qp.R3.30.D <- od.AQuA.D(F.r3, 30, od.infmat(F.r3, 30 * appR3$w.best), t.max=50)
Qp.R3.30.D$eff.best
Qp.R4.30.D <- od.AQuA.D(F.r4, 30, od.infmat(F.r4, 30 * appR4$w.best), t.max=100)
Qp.R4.30.D$eff.best

# the exact designs for N=30 (negative versions) and their efficiencies
Qm.R1.30.D <- od.AQuA.D(F.r1, 30, od.infmat(F.r1, 30 * appR1$w.best), plus=FALSE, t.max=5)
Qm.R1.30.D$eff.best
Qm.R2.30.D <- od.AQuA.D(F.r2, 30, od.infmat(F.r2, 30 * appR2$w.best), plus=FALSE, t.max=20)
Qm.R2.30.D$eff.best
Qm.R3.30.D <- od.AQuA.D(F.r3, 30, od.infmat(F.r3, 30 * appR3$w.best), plus=FALSE, t.max=50)
Qm.R3.30.D$eff.best
Qm.R4.30.D <- od.AQuA.D(F.r4, 30, od.infmat(F.r4, 30 * appR4$w.best), plus=FALSE, t.max=100)
Qm.R4.30.D$eff.best

# the exact designs for N=100 (positive versions) and their efficiencies
Qp.R1.100.D <- od.AQuA.D(F.r1, 100, od.infmat(F.r1, 100 * appR1$w.best), t.max=5)
Qp.R1.100.D$eff.best
Qp.R2.100.D <- od.AQuA.D(F.r2, 100, od.infmat(F.r2, 100 * appR2$w.best), t.max=20)
Qp.R2.100.D$eff.best
Qp.R3.100.D <- od.AQuA.D(F.r3, 100, od.infmat(F.r3, 100 * appR3$w.best), t.max=50)
Qp.R3.100.D$eff.best
Qp.R4.100.D <- od.AQuA.D(F.r4, 100, od.infmat(F.r4, 100 * appR4$w.best), t.max=100)
Qp.R4.100.D$eff.best

# the exact designs for N=30 (negative versions) and their efficiencies
Qm.R1.100.D <- od.AQuA.D(F.r1, 100, od.infmat(F.r1, 100 * appR1$w.best), plus=FALSE, t.max=5)
Qm.R1.100.D$eff.best
Qm.R2.100.D <- od.AQuA.D(F.r2, 100, od.infmat(F.r2, 100 * appR2$w.best), plus=FALSE, t.max=20)
Qm.R2.100.D$eff.best
Qm.R3.100.D <- od.AQuA.D(F.r3, 100, od.infmat(F.r3, 100 * appR3$w.best), plus=FALSE, t.max=50)
Qm.R3.100.D$eff.best
Qm.R4.100.D <- od.AQuA.D(F.r4, 100, od.infmat(F.r4, 100 * appR4$w.best), plus=FALSE, t.max=100)
Qm.R4.100.D$eff.best













