library(plotly)

x <- seq(from=1,to=10,by=0.1)
y <- 3*x+2+rnorm(length(x))

############################################################

# scatter plot

plot_ly(x=~x, y=~y, type="scatter", mode="markers")
plot_ly(x=~x, y=~y, type="scatter", mode="lines")
plot_ly(x=~x, y=~y, type="scatter", mode="lines+markers")

############################################################

# nastavenia

plot_ly(
  x=~x ,y=~y, type="scatter", mode="markers+lines", 
  marker = list(size=10, color="RED", line = list(color = "BLUE", width = 1)),
  line = list(color = "BLUE", width = 1)
)###

plot_ly(
  x=~x ,y=~y, type="scatter", mode="markers+lines", 
  marker = list(size=10, color="RED", line = list(color = "BLUE", width = 1)),
  line = list(color = "BLUE", width = 1)
)%>%
layout(title = "Nazov grafu", xaxis = list(title="x-ova os"), yaxis = list(title="y-ova os")) ###


### viac o nastaveniach x-ovej/y-ovej osi na https://plot.ly/r/axes/

############################################################

# pridanie dalsieho grafu

z <- 3*x+2

plot_ly(x=~x, y=~y, type="scatter", mode="markers")%>%
  add_trace(x=~x, y=~z, type="scatter", mode="lines") ###

plot_ly(x=~x, y=~y, type="scatter", mode="markers", name="Data")%>%
  add_trace(x=~x, y=~z, type="scatter", mode="lines", name="Priamka") ###

plot_ly(x=~x, y=~y, type="scatter", mode="markers", name="Data")%>%
  add_trace(x=~x, y=~z, type="scatter", mode="lines", name="Priamka")%>% 
  add_trace(x=~x, y=~lm(y~x)$fitted.values, type="scatter", mode="lines", name="MNS") ###

############################################################

# pridanie textu

plot_ly(x=~x, y=~y, type="scatter", mode="markers", name="Data")%>%
  add_trace(x=~x, y=~z, type="scatter", mode="lines", name="Priamka")%>% 
  add_trace(x=~x, y=~lm(y~x)$fitted.values, type="scatter", mode="lines", name="MNS")%>%
  add_trace(x=~5, y=~20, type="scatter", mode="text", text="nahodny text", name="Text") ###


plot_ly(x=~x, y=~y, type="scatter", mode="markers", name="Data")%>%
  add_trace(x=~x, y=~z, type="scatter", mode="lines", name="Priamka")%>% 
  add_trace(x=~x, y=~lm(y~x)$fitted.values, type="scatter", mode="lines", name="MNS")%>%
  add_trace(x=~5, y=~20, type="scatter", mode="text", text="<i>\u03B2</i>\u2080+<i>\u03B2</i>\u2081<i>x</i>", textfont = list(color = '#000000', size = 16), showlegend=FALSE) ###


############################################################

