library(plotly)

x <- rnorm(50)
y <- rnorm(50)
z <- 3*x-2*y+rnorm(50)

############################################################

###scatter plot

plot_ly(x=~x, y=~y, z=~z, type="scatter3d", mode="markers")
plot_ly(x=~x, y=~y, z=~z, type="scatter3d", mode="markers+lines")


plot_ly(
  x=~x, y=~y, z=~z, type="scatter3d", mode="markers", color=rep("data",50), colors="RED"
)


farby <- c(rep("data0",20), rep("data1",20), rep("data2",10))
plot_ly(
  x=~x, y=~y, z=~z, type="scatter3d", mode="markers", color=farby, colors=c("RED","BLUE", "GREEN")
)


plot_ly(
  x=~x, y=~y, z=~z, type="scatter3d", mode="markers", 
  marker = list(color=~z, colorscale=c("RED","BLUE"), showscale=TRUE, size=5)
)%>%
layout(scene = list(xaxis = list(title = "x-ova os"),
                    yaxis = list(title = "y-ova os"),
                    zaxis = list(title = "z-ova os")))

############################################################

### 3D nahodna prechadzka

suradnice <- matrix(0, ncol=3, nrow=100)

for(i in 2:100)
{
  posun <- rep(0,3)
  posun[sample(1:3,1)] <- sample(c(1,-1),1) 
  suradnice[i,] <- suradnice[i-1,] + posun
}

plot_ly(x=~suradnice[,1], y=~suradnice[,2], z=~suradnice[,3], type="scatter3d", mode="markers+lines")

plot_ly(
  x=~suradnice[,1], y=~suradnice[,2], z=~suradnice[,3], type="scatter3d", mode="markers+lines",
  marker = list(color=~1:100, showscale=TRUE, size=5)
)

### animacia 1

data <- data.frame(suradnice,F=1:100)

plot_ly(data, x = ~X1, y = ~X2, z = ~X3, frame = ~F, type = 'scatter3d', mode = 'markers+lines',
  marker = list(color=~1:100, showscale=TRUE, size=5))%>%
   layout(
     scene=list(
       xaxis = list(range = c(-10, 10)),
       yaxis = list(range = c(-10, 10)),
       zaxis = list(range = c(-10, 10))
     )
   )%>%
animation_opts(
    frame = 100
  )



### animacia 2

accumulate_by <- function(dat, var) {
  var <- lazyeval::f_eval(var, dat)
  lvls <- plotly:::getLevels(var)
  dats <- lapply(seq_along(lvls), function(x) {
    cbind(dat[var %in% lvls[seq(1, x)], ], frame = lvls[[x]])
  })
  dplyr::bind_rows(dats)
}

d <- accumulate_by(data,~F)

plot_ly(d, x = ~X1, y = ~X2, z = ~X3, frame = ~frame, type = 'scatter3d', mode = 'markers+lines',
  marker = list(color=~1:100, showscale=TRUE, size=5))%>%
animation_opts(
    frame = 100, 
    redraw = FALSE
  )


############################################################

### output

p <- plot_ly(d, x = ~X1, y = ~X2, z = ~X3, frame = ~frame, type = 'scatter3d', mode = 'markers+lines',
  marker = list(color=~1:100, showscale=TRUE, size=5))%>%
animation_opts(
    frame = 100, 
    redraw = FALSE
  )

htmlwidgets::saveWidget(p, "RandomWalk.html", selfcontained =FALSE)  

############################################################

### surface plot

#hustota normalneho

x <- seq(-5,5,0.1)
y <- seq(-5,5,0.1)

f <- function(x,y) dnorm(x)*dnorm(y)

z <- matrix(0, nrow = length(x), ncol = length(y))
for(i in 1:length(x)) for(j in 1:length(y)) z[i,j] <- f(x[i],y[j])

plot_ly(x=~x, y=~y, z=~z, type="surface")
	

#####################

# d.f. diskretneho nahodneho vektora

z <- matrix(0, nrow = length(x), ncol = length(y))
z[y>1,x>1] <- 1
plot_ly(x=~x, y=~y, z=~z, type="surface")


z <- matrix(0, nrow = length(x), ncol = length(y))
z[y>1,x>1] <- 1
z[y==1,x>=1] <- NA
z[y>=1,x==1] <- NA
plot_ly(x=~x, y=~y, z=~z, type="surface")


#inak
x1 <- seq(-5,1,0.1)
x2 <- seq(1,5,0.1)
y1 <- seq(-5,1,0.1)
y2 <- seq(1,5,0.1)

z11 <- matrix(0, nrow=length(x1), ncol=length(y1))
z21 <- matrix(0, nrow=length(x1), ncol=length(y2))
z12 <- matrix(0, nrow=length(x2), ncol=length(y1))
z22 <- matrix(1, nrow=length(x2), ncol=length(y2))

plot_ly(x=~x1, y=~y1, z=~z11, type="surface", showscale=FALSE)%>%
  add_trace(x=~x1, y=~y2, z=~z12, type="surface")%>%
  add_trace(x=~x2, y=~y1, z=~z21, type="surface")%>%
  add_trace(x=~x2, y=~y2, z=~z22, type="surface")%>%
   layout(
     scene=list(
       xaxis = list(range = c(-5, 5)),
       yaxis = list(range = c(-5, 5)),
       zaxis = list(range = c(-0.2, 1.2))
     )
   )


#####################

# regresia

x <- rnorm(50)
y <- rnorm(50)
z <- 3*x-2*y+rnorm(50)

beta <- lm(z~x+y)$coeff

x1 <- seq(min(x),max(x),length=100)
y1 <- seq(min(y),max(y),length=100)
f <- function(x1,y1) beta[1] + beta[2]*x1 + beta[3]*y1

z1 <- matrix(0, nrow=100, ncol=100)
for(i in 1:100) for(j in 1:100) z1[j,i] <- f(x1[i],y1[j])

plot_ly(x=~x1, y=~y1, z=~z1, type="surface")%>%
  add_trace(x=~x, y=~y, z=~z, type="scatter3d", mode="markers")



