library(shiny)

ui <- bootstrapPage(
  numericInput('n', 'Number of obs', 200),
  plotOutput('plot')
)

server <- function(input, output) {
  output$plot <- renderPlot({
    hist(rnorm(input$n))
  })
}

shinyApp(ui = ui, server = server)

