function(input, output, session) {
  withMathJax()
  values <- reactiveValues(matica=matrix(0,ncol=2,nrow=2))
  Est <<- matrix(0,ncol=2,nrow=2)
  
  
  output$plot <- renderPlot({
    req(input$file)
    data <- read.table(input$file$datapath, header=TRUE, sep=",")
    plot(data[,1]~data[,2], pch=19, lwd=3)
    model <- lm(data[,1]~data[,2])
    abline(model$coefficients, col="RED", lwd=2)
    Est <<- summary(model)$coefficients[,-c(2,3)]
    values$matica <- zaokruhli(Est,input$dig)
  })
  
  output$table <- renderUI({
    withMathJax(vyrobTabulku(values$matica))
  })
  
  vyrobTabulku <- function(odhady)
  {
    sprintf(
      "\\begin{array}{c|c|c}
      \t\\text{Parameter} & \\text{Estimation} & \\text{p-value}\\\\
      \t\\hline
      \t\\beta_0 & %s & %s \\\\
      \t\\hline
      \t\\beta_1 & %s & %s \\\\
      \\end{array}",
      odhady[1,1],  
      odhady[1,2],  
      odhady[2,1],  
      odhady[2,2])
  }
  
  zaokruhli <- function(matica,dig)
  {
    novaMatica <- matrix("", ncol = 2, nrow = 2)
    for(i in 1:2) for(j in 1:2) novaMatica[i,j] <- sprintf(paste0("%.", dig, "f"),matica[i,j])
    novaMatica
  }
  
}
