library(shiny)
library(plotly)
options(encoding = "UTF-8")
function(input, output) {

  output$plot <- renderPlotly({
    sig1 <- input$sigma1
    sig2 <- input$sigma2
    rho <- input$rho

    sigma <- rbind(c(sig1^2,rho*sig1*sig2),c(rho*sig1*sig2,sig2^2)) 
    x <- seq(-5,5,by=0.1)
    y <- seq(-5,5,by=0.1)

    n <- length(x)
    z <- matrix(0,ncol=n, nrow=n)
    for(i in 1:n) for(j in 1:n) z[j,i] <- (1/(2*pi*sqrt(det(sigma))))*exp(-0.5*(t(c(x[i],y[j]))%*%solve(sigma)%*%c(x[i],x[j])))
    
    scene = list(camera = list(eye = list(x = -0.5, y = -2.3, z = 1)))

    p <- plot_ly(z = ~z,y= ~y,x= ~x, showscale = FALSE, type="surface")%>%
    layout(scene = scene)	
    p 
  })
}