library(shiny)
library(plotly)
options(encoding = "UTF-8")
fluidPage(

  withMathJax(),
  titlePanel(h4("Hustota normálneho náhodného vektora")),
  titlePanel("
  \\(
  \\tiny
  (X,Y)^T\\sim N\\left(
  \\begin{pmatrix}
  0 \\\\
  0 
  \\end{pmatrix},
  \\begin{pmatrix}
  \\sigma_1^2 & \\rho\\sigma_1\\sigma_2 \\\\
  \\rho\\sigma_1\\sigma_2 & \\sigma_2^2
  \\end{pmatrix}
  \\right)
  \\)
  "),

 

   sidebarPanel(
    sliderInput("sigma1", "$$\\sigma_1$$", min = 0.5, max = 2, value = 1),
    sliderInput("sigma2", "$$\\sigma_2$$", min = 0.5, max = 2, value = 1),
    sliderInput("rho", "$$\\rho$$", min = -0.95, max = 0.95, value = 0, step= 0.05)
  ),
  mainPanel(
    plotlyOutput("plot")
  )
)