(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6231,        141]*)
(*NotebookOutlinePosition[      6882,        164]*)
(*  CellTagsIndexPosition[      6838,        160]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(NormalCDF[u_] := \((1/2)\)*\((1 + Erf[u/Sqrt[2]])\); \n
    BSEuroCall[S_, \ X_, \ sigma_, \ r_, \ tau_] := 
      Module[{d1, d2}, \ 
        d1 = \((Log[S/X] + \((r + sigma^2/2)\)*tau)\)/\((sigma*Sqrt[tau])\); 
        \ d2 = d1 - sigma*Sqrt[tau]; \ 
        Return[S*NormalCDF[d1] - X*Exp[\(-r\)*tau]*NormalCDF[d2]]]; \n
    BSEuroCallG[S_, \ X_, \ sigma_, \ r_, \ tau_] = \n\t\ 
      Simplify[D[BSEuroCall[S, X, sigma, r, tau], {S, 2}]*S]; \n
    ThirdRoot[x_] := Abs[x]^\((1/3)\)*Sign[x]; \n
    Needs["\<LinearAlgebra`Tridiagonal`\>"]; \)], "Input"],

Cell[BoxData[
    \(SIRAPMS[\[Sigma]_, r_, R_, k_, H0_, U0_, Hl_, Ul_, Hr_, Ur_, m_, n_, 
        Smax_, Smin_, tau_] := 
      Module[\n\ \t{h, l, \[Lambda], Hol, Hnew, Uol, Unew, xi}, \n\t\ 
        h = N[\((Log[Smax/Smin])\)/\((n + 1)\)]; \n\t\ l = \((tau/m)\); \n\t\ 
        xi = Table[N[Log[Smin] + i*h], {i, 1, n}]; \n\ \ \ 
        Hol = Table[N[H0[xi[\([i]\)]]], {i, 1, n}]; \n\ \t
        Uold = Table[N[U0[xi[\([i]\)]]], {i, 1, n}]; \n\ \t
        For[j = 1, j <= m, \(j++\), \n\t\t\t
          Print["\<casovy krok \>", j, "\< z \>", m]; \n\ \t\t\ 
          \[Lambda] = 
            Table[N[\((1 - 4*R*k^2  ThirdRoot[Hol[\([i]\)]])\)*l\/\(2  h\)*
                  \[Sigma]^2], {i, 1, n}]; \n\t\ \ \ \ 
          a = Table[N[1 + 2  \[Lambda][\([i]\)]/h], {i, 1, n}]; \n\t\ \ \ \ 
          b = Table[
              N[\(-\[Lambda][\([i]\)]\)/h + \[Lambda][\([i]\)]/2 - 
                  r*l/\((2  h)\)], {i, 2, n}]; \n\ \ \t\t
          c = Table[
              N[\(-\[Lambda][\([i]\)]\)/h - \[Lambda][\([i]\)]/2 + 
                  r*l/\((2  h)\)], {i, 1, n - 1}]; \n\t\ \ \ \ 
          Hol[\([1]\)] -= 
            Hl[j*l]*\((
                \(-\[Lambda][\([1]\)]\)/h + \[Lambda][\([1]\)]/2 - 
                  r*l/\((2  h)\))\); \n\t\ \ \ \ 
          Hol[\([n]\)] -= 
            Hr[j*l]*\((
                \(-\[Lambda][\([n]\)]\)/h - \[Lambda][\([n]\)]/2 + 
                  r*l/\((2  h)\))\); \n\ \ \ \ \ \ 
          Hnew = TridiagonalSolve[b, a, c, Hol]; \n\ \ \t\ \ 
          \[Lambda] = 
            Table[N[\((1 - 3  R*k^2  ThirdRoot[Hnew[\([i]\)]])\)*l\/\(2  h\)*
                  \[Sigma]^2], {i, 1, n}]; \t\n\t\ \ \ \ 
          a = Table[N[1 + r*l + 2  \[Lambda][\([i]\)]/h], {i, 1, n}]; \n
          \t\ \ \ \ 
          b = Table[
              N[\(-\[Lambda][\([i]\)]\)/h - \[Lambda][\([i]\)]/2 + 
                  r*l/\((2  h)\)], {i, 2, n}]; \n\ \ \t\t
          c = Table[
              N[\(-\[Lambda][\([i]\)]\)/h + \[Lambda][\([i]\)]/2 - 
                  r*l/\((2  h)\)], {i, 1, n - 1}]; \n\t\ \ \ \ 
          Uold[\([1]\)] -= 
            Ul[j*l]*\((
                \(-\[Lambda][\([1]\)]\)/h - \[Lambda][\([1]\)]/2 + 
                  r*l/\((2  h)\))\); \n\t\ \ \ \ 
          Uold[\([n]\)] -= 
            Ur[j*l]*\((
                \(-\[Lambda][\([n]\)]\)/h + \[Lambda][\([n]\)]/2 - 
                  r*l/\((2  h)\))\); \n\ \ \ \ \ \ 
          Unew = TridiagonalSolve[b, a, c, Uold]; \n\t\ \ \ \ Hol = Hnew; \n
          \ \ \ \ \ \ Uold = Unew; \n\t\ ]; \n\t\ 
        Return[Table[{Exp[xi[\([i]\)]], Uold[\([i]\)]}, {i, 1, n}]]; \n]\)], 
  "Input"],

Cell[BoxData[
    \(EuropeanCall[X_, r_, R_, k_, \[Sigma]_, Smin_, Smax_, tau_, m_, n_, 
        \[Epsilon]_] := 
      Module[\n\t\t{tswitch, H0, U0, Hr, Ur, Hl, Ul}, \n\t\t
        tswitch = 
          \(1\/\(2  \[Pi]*\[Sigma]\^2\)\) 
            \((\(4  R*k\^2\)\/\(1 - \[Epsilon]\))\)\^6; \n\t\t
        Print[tswitch, "\< \>", tau]; \n\t\t
        If[tswitch >= tau, \n\t\t\t
          Return[Table[{Smin + i*\((Smax - Smin)\)/n, 
                BSEuroCall[Smin + i*\((Smax - Smin)\)/n, X, \[Sigma], r, tau]}
                \n\t\t\t, {i, 0, n}]], \n\t\t\ \ 
          H0[u_] := BSEuroCallG[Exp[u], X, \[Sigma], r, tswitch]; \n\t\t\ \ 
          Hr[t_] := 0; Hl[t_] := 0; \n\t\t\ \ 
          U0[u_] := BSEuroCall[Exp[u], X, \[Sigma], r, tswitch]; \n\t\t\ \ 
          Ur[t_] := Smax - X*Exp[\(-r\)*\((t + tswitch)\)]; Ul[t_] := 0; \n
          \t\t\ \ Return[
            SIRAPMS[\[Sigma], r, R, k, H0, U0, Hl, Ul, Hr, Ur, m, n, Smax, 
              Smin, tau - tswitch]]; \n\t\t]\n]\)], "Input"],

Cell[BoxData[
    \(vysl = EuropeanCall[1, 0.1, 0.1, 0.5, 0.3, 0.05, 3, 10, 50, 100, 0.1]; 
    \na = ListPlot[vysl, PlotJoined -> True, PlotStyle -> Thickness[0.009], 
        PlotRange -> {0, 2}]; \n
    b = Plot[BSEuroCall[S, 1, 0.3, 0.1, 10], {S, 0.05, 3}, 
        PlotRange \[Rule] {0, 2}]; \nShow[b, a]; \)], "Input"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{735, 521},
WindowMargins->{{-8, Automatic}, {Automatic, 106}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 576, 10, 170, "Input"],
Cell[2288, 61, 2606, 51, 602, "Input"],
Cell[4897, 114, 1003, 18, 311, "Input"],
Cell[5903, 134, 324, 5, 90, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

