int cg(Matica A, Vektor b, Vektor x, int &maxiter, double toll)
// Funkcia cg spocita riesenie - vektor x
// Vstupuju do nej : A - matica symetricka, kladne definitna
//                   b - vektor pravej strany
//                   maxiter - ohranicenie na pocet iteracii
//                   toll - ohranicenie na reziduum iterovanych rieseni
//                          (presnost)
// Vracia hodnotu : 0 - ak bola dosiahnuta pozadovana presnost
//                  1 - ak bol dosiahnuty povoleny pocet iteracii

{
 float resid, alfa, beta, rho, rho1, normb;
 Vektor p,p1,r,q,z;
 int pi;

 p=(double *)calloc(dim+1,sizeof(double));
 p1=(double *)calloc(dim+1,sizeof(double));
 r=(double *)calloc(dim+1,sizeof(double));
 q=(double *)calloc(dim+1,sizeof(double));
 z=(double *)calloc(dim+1,sizeof(double));

 normb = norm(b,rozmer);
 MaticaVektor(A,x,p1,rozmer);
 for(i=1;i<=rozmer;i++) r[i]=b[i]-p1[i];
 if (normb == 0) normb = 1;
 if ((resid = norm(r,rozmer) / normb) <= toll)
  {
   toll = resid;
   maxiter = 0;
   return(0);
  }

 rho1 = 1;
 for(pi=1;pi<=maxiter;pi++)
  {
   // solve M.z=r - kde M je prekondicioner = symetricka, +definitna
   // "Zrusenie" pouzivanie premennej r, ak nepouzivame prekodicioner
   for(i=1;i<=rozmer;i++) z[i] = r[i];
   rho = VektorVektor(r,z,rozmer);
   if (pi == 1) for(i=1;i<=rozmer;i++) p[i] = z[i];
		else
		 {
		   beta = rho / rho1;
		   for(i=1;i<=rozmer;i++) p[i] = z[i] + beta * p[i];
		 }
   MaticaVektor(A,p,q,rozmer);
   alfa = rho / VektorVektor(p,q,rozmer);
   for(i=1;i<=rozmer;i++) x[i] += alfa * p[i];
   for(i=1;i<=rozmer;i++) r[i] -= alfa * q[i];
   if (( resid = norm(r,rozmer) / normb) <= toll)
	{
	  toll = resid;
	  maxiter = pi;
	  return(0);
	}
   rho1 = rho;
  }
 toll = resid;
 maxiter=pi;
 free(p);free(p1);free(r);free(q);free(z);
 return(1);
}