/*				Hlavny program

Algoritmus metody vnutorneho bodu (Newtonova metoda)
Min F(y) = xQx - mi*SUM( ln(xi-ai)-ln(bi-xi) )+lam1(SUM(xi)-1)+lam2(x.r-E(r))
 y = (x,lam1,lam2)

*/

	// Pripojenie potrebnych C++ kniznic
# include <stdio.h>
# include <math.h>
# include <stdlib.h>
# include <string.h>

	// Maximalna mozna velkost matice = dim
const int dim = 30,
	// Maximalna mozna dlzka cisla citaneho zo suborov s datami
	  maxdc = 25;

	// Definovanie smernikov
typedef double *Vektor, **Matica;
double **ohr;

	// Matice
Matica KM, H;
	// KM - Korelacna matica Q obsahujuca korelacie n nahodnych velicin
	//    - symetricka, +definitna
	// H  - Hessian, matica druhych derivacii funkcie Fy

	// Vektory
Vektor r,y,ynn,Fy,z,d,suma,pomv,pomv2;
	// r   - Navratnosti
	// y   - Riesenie funkie F(y)
	// ymm - Nove riesenie funkcie F(y)
	// Fy  - Vektor pravej strany v linearnom systeme rovnic H.z = Fy
	// z   - Riesenie linearneho systemu H.z = Fy
	// d   - Diagonalne prvky matice H
	// suma, pomv, pomv2 - Pomone vektory

	// Skalare
double keps,cgeps,sigma,hu,mi,th,Er,tol,norma;
	// cgeps - Absolutna (relativna) presnost pri rieseni linearneho systemu
	//         H.z = Fy rieseneho funkciou cg()
	// sigma - Sucin xQx
	// hu    - Hodnota ucelovej funkcie F(y)
	// mi    - Transformacny parameter
	// Er    - Pozadovana navratnost
	// tol   - Miera tolerancie odchylky pri splneni podmienky
	//         Suma(xi) = 1
	// tol   - Miera tolerancie odchylky pri splneni podmienky
	//         Suma(xi*ri) = 1
	// norma - Drzitel hodnoty Euklidovskej normy vektora

double psigma,srozd,phu,hurozd,pom1,pom2;
	// - pomocne premenne

	// Celociselne premenne
int rozmer,niiter,cgiter,co,cgco,i,j, ni, cgi, kstop;
	// rozmer - Rozmer matice KM
	// niiter - Maximalny povoleny pocet Newton iteracii
	// cgiter - Maximalny povoleny pocet cg() iteracii
	// co     - Nositel chybovych hlaseni
	// cgco   - Nostiel chybovych hlaseni z funkcie cg()
	// i,j    - Premenne v cykloch for()
	// ni     - Pocitadlo Newtonovych iteracii
	// cgi    - Pocitadlo cg() iteracii
	// kstop  - Nositel hodnoty volby kriteria zastavenia

	// Definovanie znakovych retazcov
char *mnazov,*onazov,*vystup;
	// mnazov - Cesta a meno suboru s kovariancnou maticou
	// onazov - Cesta a meno suboru s ostatnymi udajmi
	// vystup - Cesta a meno suboru pre vystup.

FILE *s;
	// Pripojenie kniznic
# include "algebra.h"         // Nasobenie vektorov a vektora s maticou
# include "read.h"            // Nacitavanie dat zo suborov
# include "rest.h"            // Ostatne pomocne funkcie (Testovanie, Vypisy)
# include "set.h"             // Vypocet Hessianu H a vektora Fy
# include "cg.h"              // Solver riesiaci linearny system A.x = b

int main()
{
	// Vyhradenie pamate pre kovariancnu maticu KM
KM = (double**)calloc(dim+1,sizeof(double*)+1);
for(i=1;i<=dim;i++)
 { KM[i]=(double *) calloc (dim+1, sizeof(double)+1);
   if (KM[i]==NULL) {printf("Nedostatok pamate. Koniec.\n");exit(1);}
 }

	// Vyhradenie pamate pre Hessian H
H = (double**)calloc(dim+2+1,sizeof(double*)+1);
for(i=1;i<=dim+2;i++)
 { H[i]=(double *) calloc (dim+2+1, sizeof(double)+1);
   if (H[i]==NULL) {printf("Nedostatok pamate. Koniec.\n");exit(1);}
 }

	// Definovanie matice 2 x dim predstavujucej ohranicenia pre x[i]
ohr = (double**)calloc(2+1,sizeof(double*));
ohr[1] = (double *)calloc(dim+1,sizeof(double)+1);
ohr[2] = (double *)calloc(dim+1,sizeof(double)+1);

	// Vyhradenie pamate pre vektory
r = (double *)calloc( dim+1, sizeof(double)+1);
y = (double *)calloc( dim+1, sizeof(double)+1);
ynn = (double *)calloc( dim+1, sizeof(double)+1);
Fy = (double *)calloc( dim+1, sizeof(double)+1);
z = (double *)calloc( dim+1, sizeof(double)+1);
d = (double *)calloc( dim+1, sizeof(double)+1);
suma = (double *)calloc( dim+1, sizeof(double)+1);
pomv = (double *)calloc( dim+1, sizeof(double)+1);

	// Vyhradenie pamate pre nazov suborov s datami
	// a vystupneho suboru
mnazov = (char *) calloc(50, sizeof(char));
onazov = (char *) calloc(50, sizeof(char));
vystup = (char *) calloc(50, sizeof(char));

	// Nacitanie mena suboru s kovariancnou maticou KM
printf("\nCesta a nazov suboru s kovariancnou maticou : "); scanf("%s",mnazov);
	// Nacitanie mena suboru s ostatnymi udajmi
printf("\nCesta a nazov suboru s ostatnymi udajmi : "); scanf("%s",onazov);
	// Nacitanie mena vystupoveho suboru
printf("\nCesta a nazov suboru, do ktoreho ide vystup  : "); scanf("%s",vystup);

	// Testovanie vytvorenia a vytvorenie vystupneho suboru
if ((s = fopen(vystup,"wt"))==NULL) Koniec(11);

	// Nacitanie matice KM zo suboru
co = Nacitaj_Maticu(mnazov,KM,rozmer);

	// Testovanie nacitania
if (co!=0) Koniec(co);

	// Nacitanie ostatnych udajov zo suboru
co = Nacitaj_Udaje(onazov);

	// Testovanie nacitania
if (co!=0) Koniec(co);

	// Mame dve ohranienia => dva lagrangeove parametre
rozmer = rozmer+2;

	// Vypis nastaveni
Vypis();

	// Testovanie splenia podmienok a nastavenie startovacich hodnot
	// potrebnych pre Newtnove iteracie
co = Test_Start();
if (co!=0) Koniec(co);
 else fprintf(s,"\n\nStartovacie podmienky splnene.");

	// Vonkajsie (Newtonove) iteracie
for(ni=1;ni<=niiter;ni++)
 {
	// Kriteria zastavenia (podla nacitanej hodnoty kstop) :
	// AK Euklidovska norma rozdielu poslednych dvoch po sebe
	// iducich rieseni je mensia ako zadana presnost
  if (kstop==1) { if ( norma < keps ) Koniec(6); }

	// Ak rozdiel dvoch po sebe iducich hodnout sigma je mansi
	// ako zadana presnost
   else if (kstop==2) { if ( fabs(srozd) < keps ) Koniec(7); }

	// Ak rozdiel dvoch po sebe iducich hodnout ucelovej funkcie je
	// mensi ako zadana presnost
	 else if ( fabs(hurozd) < keps ) Koniec(8);

  fprintf(s,"\n\n%d. Newton Iteracia : \n",ni);

	// Vypocet novej matice H a vektora Fy
  set_H(y);
  set_Fy(y);

	// Riesenie linearneho systemu H.z = Fy
  cgi = cgiter;
  cgco = cg(H,Fy,z,cgi,cgeps);

	// Vypocet noveho Newtonovho bodu - nove riesenie ynn
  for (i=1;i<=rozmer;i++) ynn[i] = y[i] - z[i];


	// Vypocet Euklidovskej normy rozdielu poslednych dvoch po sebe
	// iducich rieseni
  for(i=1;i<=rozmer;i++) pomv[i] = ynn[i] - y[i];
  norma = norm(pomv,rozmer-2);

	// Vypocet hodnoty ucelovej funkcie s novym riesenim ynn
  hu = hoduc(ynn);

	// Vypis vysledkov iteraie do suboru
  Vypis_iter();

	// Testovanie noveho bodu na splnenie podmienok
  co = Test(ynn);
  if (co!=0) Koniec(co);
   else
    {
	// Vypocet noveho mi a zapametanie si aktualneho riesenia
      mi = mi*th;
      for(i=1;i<=rozmer;i++) y[i] = ynn[i];
    }
 }

if (ni-1 == niiter) Koniec(9);
 else Koniec(0);

return(0);
}