%DP0000 Simple machine replacement problem computation.
%
%	Profit function equals A * K ^ theta. We have NS number of shocks
%	and NK number of kapital states. Maximal kapital is normalized
%	to 1. DELTA is depreciation rate of capital, BETA is discount
%	factor of a future and LAMBDA is production discount factor,
%	when machine is replaced. Period is three months. Price of a
%	new machine is P. THETA is the curvature of a profit function.

clear all;

% profitability discretization
A = exp(-1:0.5:1);
NS = length(A);

NK = 60

BETA = 0.9875
DELTA = 0.00625
LAMBDA = 0.5
THETA = 2;

PI = mark00(NS, 4)

% capital discretization
P = 1.3;
K(NK) = 1;
for i = (NK - 1):-1:1
   K(i) = K(i + 1) * (1 - DELTA);
end

% the capital matrix
MK = repmat(0, NK, NK);
MK(NK,:) = K;
for i = 1:(NK - 1)
   MK(i,i+1) = K(i);
end

for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK .^ THETA;
end
INDEXES = (BMK == 0);
BMK(INDEXES) = -inf;
BMK(NK,:) = BMK(NK,:) .* LAMBDA - P;

[DR, V] = iter00(BMK, PI, BETA);
M = dist00(DR, PI, 0.0001, 10000);

test03;

try
   delete(1);
   delete(2);
end

figure(1);
hold on;
plot(K, sum(M));
plot(K, NM, ':');
figure(2);
hold on;
plot(SS);
plot(NX,':');