%DP0002 Computes transition matrix for DOW-JONES process

% read data, if not previosly done
if (exist('DDAT','var') == 0)
   [DATA, N1, N2] = TBLREAD('../data/ticks/daily/DJI.csv',',');
   DATA = flipud(DATA);
   aDATA = sum(DATA') ./ 4;
   sDATA = length(aDATA);
   DDAT = log(aDATA(2:sDATA) ./ aDATA(1:(sDATA - 1)));
end

figure(8);
set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[PI,VAL,CNT] = hest00(DDAT,31);
h = plot(VAL,CNT./sum(CNT));
set(h,'LineWidth',2);
flab00('$\log A$','$p_j$','Stacion\char225rne rozdelenie');
epsw00('Adist08.eps','small');

figure(9);
[PI,VAL,CNT] = hest00(DDAT,9);
[c, h, cc] = contourf(VAL',VAL,PI,24);
set(get(gcf,'CurrentAxes'),'Position',[0.17 0.15 0.72 0.8]);
colormap(flipud(gray));
colorbar;
set(h,'LineStyle','none');
flab00('stav $j$','','Matica $p_{ij}$ pre $\log A$');
ylabel('\tex[t][b]{\textpic{stav $i$}}','Interpreter','none')
epsw00('Adist09.eps','small');

figure(10);
set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
h = plot(DDAT(1:1200));
set(h,'LineWidth',1);
flab00('\char232as','$\log A$');
epsw00('Adist10.eps','wide');
