%DP0007 Multipe random proceses simulations.

clear all;

% profitability discretization
meanlA = 0.3;
lA = meanlA * (1.1 .^ (-4:4));
lPI = mark01(length(lA),4,0.2);

meangA = 1.0;
gA = meangA * (3 .^ (0:1));
gPI = mark00(length(gA),1.45);

lgA = length(gA);
llA = length(lA);

A = zeros(1,llA * lgA);
for i = 1:lgA
   for j = 1:llA
      A(((i-1)*llA)+j) = lA(j) * gA(i);
   end
end

PI = repmat(lPI,lgA,lgA);
for i = 1:lgA
   for j = 1:lgA
      PI(((i-1)*llA+1):(i*llA),((j-1)*llA+1):(j*llA)) = ...
         PI(((i-1)*llA+1):(i*llA),((j-1)*llA+1):(j*llA)) * gPI(i,j);
   end
end


NS = length(A);

NK = 20

BETA = 0.95
DELTA = 0.1
LAMBDA = 0.5;
THETA = 0.5;

% capital discretization
P = 0.1;
K(NK) = 1;
for i = (NK - 1):-1:1
   K(i) = K(i + 1) * (1 - DELTA);
end

% the capital matrix
MK = repmat(0, NK, NK);
MK(NK,:) = K;
for i = 1:(NK - 1)
   MK(i,i+1) = K(i);
end

for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK .^ THETA;
end
INDEXES = (BMK == 0);
BMK(INDEXES) = -inf;
BMK(NK,:) = BMK(NK,:) .* LAMBDA - P;

[DR, V] = iter00(BMK, PI, BETA);

% up shock
GS = [repmat(1,1,499),2,repmat(1,1,500)];
GSUP = GS;
test09;
SIMDUP = SIMD;

%down shock
GS = [repmat(2,1,499),1,repmat(2,1,500)];
GSDOWN = GS;
test09;
SIMDDOWN = SIMD;

%total random
[XD, GS] = simp00(ones(length(gPI),1),gPI,1,1,1000);
GSR = GS;
test09;
SIMDR = SIMD;

test10;