%DP0008 No adjustment costs.
%
%	Profit function equals A * K ^ theta. We have NS number of shocks
%	and NK number of kapital states. Maximal kapital is normalized
%	to 1. DELTA is depreciation rate of capital, BETA is discount
%	factor of a future and LAMBDA is production discount factor,
%	when machine is replaced. Period is three months. Price of a
%	new machine is P. THETA is the curvature of a profit function.

clear all;

% profitability discretization
meanA = 1;
A = meanA * (1.05 .^ (-15:15));
NS = length(A);

NK = 40
K(NK) = 50;

BETA = 0.99
DELTA = 0.02
THETA = 0.32;

P = 1;
PI = mark01(NS,4,0.2);

% capital discretization
for i = (NK - 1):-1:1
   K(i) = K(i + 1) * (1 - DELTA);
end

% the capital matrix
MK = repmat(K, NK, 1);

% investment
IM = zeros(NK,NK);
for i = 1:NK
   for j = 1:NK
      IM(i,j) = K(i) - (1 - DELTA)*K(j);
   end
end

IM = IM * P;
      
% utility
for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK .^ THETA - IM;
end


[DR, V] = iter00(BMK, PI, BETA);

% break
M = dist00(DR, PI, 0.0001, 500);

% test03;

figure(1);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',V,24);
set(h,'LineStyle','none');
colormap(flipud(gray));
colorbar;
flab00('$K$','$A$','$\mathrm{V}(A,K)$');
% epsw00('R01.eps','small');

figure(2);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',K(DR),24);
set(h,'LineStyle','none');
colormap(gray);
colorbar;
flab00('$K$','$A$','Optim\char225lne $K''$');
epsw00('G01.eps','small');

KK = repmat(K,NS,1);
II = K(DR) - (1 - DELTA) * KK;

% investicie
figure(3);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',II,24);
set(h,'LineStyle','none');
colormap(gray);
colorbar;
flab00('$K$','$A$','Optim\char225lne $I$');
epsw00('G03.eps','small');

figure(4);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
h = plot(A, K(DR(:,1)));
set(h,'LineWidth',2);
flab00('$A$','Optim\char225lne $K''$');
epsw00('G02.eps', 'small');

% investicie
figure(5);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',100 * (II ./ KK),24);
set(h,'LineStyle','none');
colormap(gray);
colorbar;
flab00('$K$','$A$','Optim\char225lne $i$ [%]');
epsw00('G04.eps','small');
