%DP0008 Transaction costs.
%
%	Profit function equals A * K ^ theta. We have NS number of shocks
%	and NK number of kapital states. Maximal kapital is normalized
%	to 1. DELTA is depreciation rate of capital, BETA is discount
%	factor of a future and LAMBDA is production discount factor,
%	when machine is replaced. Period is three months. Price of a
%	new machine is P. THETA is the curvature of a profit function.

clear all;

% profitability discretization
meanA = 1;
A = meanA * (1.05 .^ (-15:15));
NS = length(A);

NK = 40
K(NK) = 50;

BETA = 0.99
DELTA = 0.02
THETA = 0.32;

PI = mark01(NS,4,0.2);

% capital discretization
Pbid = 1.01;
Pask = .98;

for i = (NK - 1):-1:1
   K(i) = K(i + 1) * (1 - DELTA);
end

% the capital matrix
MK = repmat(K, NK, 1);

% investment
IM = zeros(NK,NK);
for i = 1:NK
   for j = 1:NK
      IM(i,j) = K(i) - (1 - DELTA)*K(j);
   end
end

% transaction costs
IM(IM > 0) = IM(IM > 0) * Pbid;
IM(IM < 0) = IM(IM < 0) * Pask;

      
% utility
for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK .^ THETA - IM;
end


[DR, V] = iter00(BMK, PI, BETA);

% break
M = dist00(DR, PI, 0.0001, 500);

% test03;
KK = repmat(K,NS,1);
II = K(DR) - (1 - DELTA) * KK;

figure(1);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',V,24);
set(h,'LineStyle','none');
colormap(flipud(hot));
colorbar;
flab00('$K$','$A$','$\mathrm{V}(A,K)$');
% epsw00('R01.eps','small');

figure(2);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',K(DR),24);
set(h,'LineStyle','none');
colormap(hot);
colorbar;
flab00('$K$','$A$','Optim\char225lne $K''$');
epsw00('G05.eps','small');

% investicie
figure(3);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',100 * (II ./ KK),24);
set(h,'LineStyle','none');
colormap(cool);
colorbar;
flab00('$K$','$A$','Optim\char225lne $i$ [%]');
epsw00('G06.eps','small');

figure(4);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
h = plot(K, sum(M));
set(h,'LineWidth',2);
flab00('$K$','podiel','Stacion\char225rne rozdelenie pod\char181a $K$');
% epsw00('Agr01.eps');

