%DP0010 Convex adjustment costs.

clear all;

% profitability discretization
meanA = 1;
A = meanA * (1.05 .^ (-15:15));
NS = length(A);

% adjustment costs
GM = 0.01;

NK = 40
K(NK) = 50;

BETA = 0.99
DELTA = 0.02
THETA = 0.32;

PI = mark01(NS,4,0.2);

% capital discretization
P = 1.0;

for i = (NK - 1):-1:1
   K(i) = K(i + 1) * (1 - DELTA);
end

% the capital matrix
MK = repmat(K, NK, 1);

% investment
IM = zeros(NK,NK);
for i = 1:NK
   for j = 1:NK
      IM(i,j) = K(i) - (1 - DELTA)*K(j);
   end
end

% adjustment costs
KKM = repmat(K,NK,1);
AC = (GM ./ 2) * (IM ./ KKM) .^ 2 .* KKM;
      
% utility
for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK .^ THETA - IM - AC;
end


[DR, V] = iter00(BMK, PI, BETA);

% break
M = dist00(DR, PI, 0.0001, 500);


KK = repmat(K,NS,1);
II = K(DR) - (1 - DELTA) * KK;


figure(1);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',V,24);
set(h,'LineStyle','none');
colormap(flipud(gray));
colorbar;
flab00('$K$','$A$','$\mathrm{V}(A,K)$');
% epsw00('R01.eps','small');

figure(2);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',K(DR),24);
set(h,'LineStyle','none');
colormap(gray);
colorbar;
flab00('$K$','$A$','Optim\char225lne $K''$');
epsw00('G09.eps','small');

% investicie
figure(3);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',100 * (II ./ KK),24);
set(h,'LineStyle','none');
colormap(gray);
colorbar;
flab00('$K$','$A$','Optim\char225lne $i$ [%]');
epsw00('G10.eps','small');

figure(4);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
h = plot(K, sum(M));
set(h,'LineWidth',2);
flab00('$K$','podiel','Stacion\char225rne rozdelenie pod\char181a $K$');
% epsw00('Agr01.eps');

