%DP0010 Mixed adjustment costs. For investment rate.

clear all;

% profitability discretization
meanA = 1;
A = meanA * (1.005 .^ (-15:15));
NS = length(A);

% adjustment costs
GM = 0.01;
F = 0.001;
Pbid = .91;
Pask = .9075;

NK = 40
K(NK) = 50;

BETA = 0.99
DELTA = 0.02
THETA = 0.32;

PI = mark01(NS,4,0.2);

% capital discretization

for i = (NK - 1):-1:1
   K(i) = K(i + 1) * (1 - DELTA);
end

% the capital matrix
MK = repmat(K, NK, 1);

imac00;

% utility
for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK .^ THETA - IM - AC;
end


[DR, V] = iter00(BMK, PI, BETA);

% break
M = dist00(DR, PI, 0.0001, 500);
   
% test03;

figure(1);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',V,24);
set(h,'LineStyle','none');
colormap(flipud(gray));
colorbar;
flab00('$K$','$A$','$\mathrm{V}(A,K)$');
% epsw00('R01.eps','small');

figure(2);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',K(DR),24);
set(h,'LineStyle','none');
colormap(gray);
colorbar;
flab00('$K$','$A$','Optim\char225lne $K''$');
% epsw00('R02.eps','small');

% investicie
figure(3);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',K(DR) - (1 - DELTA) * repmat(K,NS,1),24);
set(h,'LineStyle','none');
colormap(gray);
colorbar;
flab00('$K$','$A$','Optim\char225lne $I$');
% epsw00('R02.eps','small');

figure(4);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
h = plot(K, sum(M));
set(h,'LineWidth',2);
flab00('$K$','podiel','Stacion\char225rne rozdelenie pod\char181a $K$');
% epsw00('Agr01.eps');

