%DP0010 Mixed adjustment costs. For investment rate.

clear all;

% profitability discretization
meanlA = 1;
lA = meanlA * (1.1 .^ (-4:4));
lPI = mark01(length(lA),4,0.2);

meangA = 1.0;
gA = meangA * (1.5 .^ [-1 1]);
gPI = mark00(length(gA),1.45);

lgA = length(gA);
llA = length(lA);

A = zeros(1,llA * lgA);
for i = 1:lgA
   for j = 1:llA
      A(((i-1)*llA)+j) = lA(j) * gA(i);
   end
end

PI = repmat(lPI,lgA,lgA);
for i = 1:lgA
   for j = 1:lgA
      PI(((i-1)*llA+1):(i*llA),((j-1)*llA+1):(j*llA)) = ...
         PI(((i-1)*llA+1):(i*llA),((j-1)*llA+1):(j*llA)) * gPI(i,j);
   end
end


NS = length(A);

% adjustment costs
GM = 0.01;
F = 0.001;
Pbid = .91;
Pask = .9075;

NK = 40
K(NK) = 50;

BETA = 0.99
DELTA = 0.02
THETA = 0.32;

% capital discretization

for i = (NK - 1):-1:1
   K(i) = K(i + 1) * (1 - DELTA);
end

% the capital matrix
MK = repmat(K, NK, 1);

imac00;

% utility
for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK .^ THETA - IM - AC;
end

[DR, V] = iter00(BMK, PI, BETA);
M = dist00(DR, PI, 0.0001, 500);

% up shock
GS = [repmat(1,1,499),2,repmat(1,1,500)];
GSUP = GS;
test13;
SIMDUP = SIMD;

%down shock
GS = [repmat(2,1,499),1,repmat(2,1,500)];
GSDOWN = GS;
test13;
SIMDDOWN = SIMD;

%total random
[XD, GS] = simp00(ones(length(gPI),1),gPI,1,1,1000);
GSR = GS;
test13;
SIMDR = SIMD;

test15;