%DP0030 Capital investment problem

if (exist('inim','var') == 0)
   clear all;
   test30;
   inim = 1;
end


% profitability discretization
% meanA = 1;
% A = meanA * (1.005 .^ (-5:5));
NS = length(A);

K = 0:2:100;
NK = length(K);

% future discount factor
BETA = 0.992;
% interest rate

%PI = mark01(NS,4,0.2);

% transaction costs
Pbid = 1.005;
Pask = 1.0;

PPA = 1.015;
RPA = 1.05;

PPW =(PPA - 1)/52 + 1;
RPW =(RPA - 1)/52 + 1;


% the capital matrix
MK = repmat(K, NK, 1);

% investment
IM = MK - MK';

% transaction costs
IM(IM > 0) = IM(IM > 0) * Pbid - IM(IM > 0);
IM(IM < 0) = IM(IM < 0) * Pask - IM(IM < 0);

      
% utility
for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK / PPW - RPW * MK - IM;
end


[DR, V] = iter01(BMK, PI, BETA);

try
   delete(1);
   delete(2);
end


figure(1);
[c,h,cc] = contourf(K,A',V,24);
set(h,'LineStyle','none');
colormap(flipud(hot));
colorbar;
flab00('$K$','$A$','$\mathrm{V}(A,K)$');
% epsw00('R01.eps','small');

figure(2);
pcolor(K,A',K(DR))
%[c,h,cc] = contourf(K,A',K(DR),24);
% set(h,'LineStyle','none');
shading flat;
colormap(jet);
colorbar;
flab00('podiel DJ [\%]','$A$','Optim\char225lny nov\char253{} podiel DJ [\%]');
epsw01('fig.20','big');

% investicie
% figure(3);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
% [c,h,cc] = contourf(K,A',100 * (II ./ KK),24);
% set(h,'LineStyle','none');
% colormap(gray);
% colorbar;
% flab00('$K$','$A$','Optim\char225lne $i$ [%]');
% epsw00('G06.eps','small');

% figure(4);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
% h = plot(K, sum(M));
% set(h,'LineWidth',2);
% flab00('$K$','podiel','Stacion\char225rne rozdelenie pod\char181a $K$');
% epsw00('Agr01.eps');

