%DP0030 Capital investment problem

if (exist('inim','var') == 0)
   clear all;
   test32	;
   inim = 1;
end


% profitability discretization
% meanA = 1;
% A = meanA * (1.005 .^ (-5:5));
NS = length(A);

K = 0:20:100;
NK = length(K);

% future discount factor
BETA = 0.992;
% interest rate
R = 1.04;

%PI = mark01(NS,4,0.2);

% transaction costs
Pbid = 1;
Pask = 1/Pbid;


% the capital matrix
MK = repmat(K, NK, 1);

% investment
IM = MK - MK';

% transaction costs
IM(IM > 0) = IM(IM > 0) * Pbid - IM(IM > 0);
IM(IM < 0) = IM(IM < 0) * Pask - IM(IM < 0);

      
% utility
for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK - MK - IM;
end


[DR, V] = iter01(BMK, PI, BETA);

% break
% M = dist00(DR, PI, 0.0001, 500);

% test03;
% KK = repmat(K,NS,1);
% II = K(DR) - (1 - DELTA) * KK;

figure(1);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',V,24);
set(h,'LineStyle','none');
colormap(flipud(hot));
colorbar;
flab00('$K$','$A$','$\mathrm{V}(A,K)$');
% epsw00('R01.eps','small');

figure(2);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[c,h,cc] = contourf(K,A',K(DR),24);
set(h,'LineStyle','none');
colormap(cool);
colorbar;
flab00('$K$','$A$','Optim\char225lne $K''$');
% epsw00('G05.eps','small');

% investicie
% figure(3);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
% [c,h,cc] = contourf(K,A',100 * (II ./ KK),24);
% set(h,'LineStyle','none');
% colormap(gray);
% colorbar;
% flab00('$K$','$A$','Optim\char225lne $i$ [%]');
% epsw00('G06.eps','small');

% figure(4);
% set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
% h = plot(K, sum(M));
% set(h,'LineWidth',2);
% flab00('$K$','podiel','Stacion\char225rne rozdelenie pod\char181a $K$');
% epsw00('Agr01.eps');

