%DP0031 Index counter

% aDATA - original index
% iDATA - my index

nmi = 0;nx= 0;
iDATA = aDATA;
myDR = K(DR(:,round(NK/2)));
Iown = iDATA(1);
Cown = 0;
tMAX = length(aDATA);
pPodiel = 1.0;
AAT = A';
for t = 2:tMAX;
    tCost = 0;
    Ichange = aDATA(t) / aDATA(t-1);
    iDATA(t) = Iown * Ichange / 1.0002 + Cown * 1.0009;
    if (t < tMAX) % let's make investment
       [x,i] = min(abs(AAT - Ichange));
       nPodiel = myDR(i)/100;
       if (nPodiel < pPodiel) % let's by cash
          CC = iDATA(t) * (pPodiel - nPodiel);
          iDATA(t) = iDATA(t) - (CC * Pbid - CC); % bid
          nmi = nmi + 1;
          nx = 0;
       else
          if (nPodiel > pPodiel) % let's by stock
             CC = iDATA(t) * (nPodiel - pPodiel);
             tCost = CC - CC * Pask; % ask
             nmi = nmi + 1;
             nx = 0;
          end
       end
       Iown = nPodiel * iDATA(t) - tCost;
       Cown = (1 - nPodiel) * iDATA(t);
       pPodiel = nPodiel;
    end % of making investment 
end % of life cycle

try
    delete(3)
end

figure(3);
h = plot(DDATES,aDATA,'b',DDATES,iDATA,'r');
set(h,'LineWidth',2);
grid on;
datetick('x');
legend(h,'AAPL','SM Index',2)
flab00('\char232as','hodnota');
epsw01('I.eps','wide');