%DP0002 Computes transition matrix for DOW-JONES process

% read data, if not previosly done
if (exist('DDAT','var') == 0)
   [DATA, N1, N2] = TBLREAD('../data/ticks/daily/DJI.csv',',');
   DATA = flipud(DATA);
   aDATA = sum(DATA') ./ 4;
   sDATA = length(aDATA);
   DDAT = log(aDATA(2:sDATA) ./ aDATA(1:(sDATA - 1)));
end

try
   delete(5,6,7);
end


figure(5);
%set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
[PI,VAL,CNT] = hest00(DDAT,31);
h = plot(VAL*100,CNT./sum(CNT));
set(h,'LineWidth',2);
flab00('$\log A$ [\%]','$p$','Stacion\char225rne rozdelenie');
epsw01('fig.3','small');

figure(6);
[PI,VAL,CNT] = hest00(DDAT,9);
[c, h, cc] = contourf(VAL(2:8)'*100,VAL(2:8)*100,PI(2:8,2:8),24);
%set(get(gcf,'CurrentAxes'),'Position',[0.17 0.15 0.72 0.8]);
colormap(flipud(hot));
colorbar;
set(h,'LineStyle','none');
flab00('stav $j$ [\%]','stav $i$ [\%]','Matica $\mathbf{\Pi}$ pre $\log A$');
epsw01('fig.4','small');

figure(7);
set(get(gcf,'CurrentAxes'),'Position',[0.2 0.15 0.75 0.8]);
h = plot(DDAT(101:200)*100);
set(h,'LineWidth',2);
flab00('\char232as','$\log A$ [\%]');
grid on;
epsw01('fig.5','wide');
