%DP0000 Simple machine replacement problem computation.
%
%	Profit function equals A * K ^ theta. We have NS number of shocks
%	and NK number of kapital states. Maximal kapital is normalized
%	to 1. DELTA is depreciation rate of capital, BETA is discount
%	factor of a future and LAMBDA is production discount factor,
%	when machine is replaced. Period is three months. Price of a
%	new machine is P. THETA is the curvature of a profit function.

clear all;

% profitability discretization
meanA = .4;
A = meanA * (1.1 .^ (-4:4));
NS = length(A);

NK = 20

BETA = 0.95
DELTA = 0.1
LAMBDA = 0.3;
THETA = 0.5;

PI = mark01(NS,4,0.2);

% capital discretization
P = .1;
K(NK) = 1;
for i = (NK - 1):-1:1
   K(i) = K(i + 1) * (1 - DELTA);
end

% the capital matrix
MK = repmat(0, NK, NK);
MK(NK,:) = K;
for i = 1:(NK - 1)
   MK(i,i+1) = K(i);
end

for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK .^ THETA;
end
INDEXES = (BMK == 0);
BMK(INDEXES) = -inf;
BMK(NK,:) = BMK(NK,:) .* LAMBDA - P;

[DR, V] = iter00(BMK, PI, BETA);

try
   delete(1,2);
end


figure(1);
[c,h,cc] = contourf(K,A',V,24);
set(h,'LineStyle','none');
colormap(flipud(hot));
colorbar;
flab00('$K$','$A$','$\mathrm{V}(A,K)$');
epsw01('fig.6','small');

figure(2);
[c,h,cc] = contourf(K,A',K(DR),24);
set(h,'LineStyle','none');
colormap(flipud(cool));
colorbar;
flab00('$K$','$A$','Optim\char225lne $K''$');
epsw01('fig.7','small');