%DP0000 Simple machine replacement problem computation.
%
%	Profit function equals A * K ^ theta. We have NS number of shocks
%	and NK number of kapital states. Maximal kapital is normalized
%	to 1. DELTA is depreciation rate of capital, BETA is discount
%	factor of a future and LAMBDA is production discount factor,
%	when machine is replaced. Period is three months. Price of a
%	new machine is P. THETA is the curvature of a profit function.

clear all;

% profitability discretization
meanA = 0.3;
A = meanA * (1.05 .^ (-12:12));
NS = length(A);

NK = 20

BETA = 0.95
DELTA = 0.1
LAMBDA = 0.5;
THETA = 0.5;

PI = mark01(NS,4,0.2);

% capital discretization
P = 0.1;
K(NK) = 1;
for i = (NK - 1):-1:1
   K(i) = K(i + 1) * (1 - DELTA);
end

% the capital matrix
MK = repmat(0, NK, NK);
MK(NK,:) = K;
for i = 1:(NK - 1)
   MK(i,i+1) = K(i);
end

for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK .^ THETA;
end
INDEXES = (BMK == 0);
BMK(INDEXES) = -inf;
BMK(NK,:) = BMK(NK,:) .* LAMBDA - P;

[DR, V] = iter00(BMK, PI, BETA);

% break
% M = dist00(DR, PI, 0.0001, 500);

try
   load 'dp0054';
catch
   test08;
   save 'dp0054' SIMD;
end

try
   delete(3,4);
end

figure(3);
h = plot(K(SIMD(1,1:200)));
flab00('\char232as','$K$','V\char253voj $K$ pre 1 podnik');
set(h,'LineWidth',2);
grid on;
epsw01('fig.8','wide');

figure(4);
h = plot(sum(K(SIMD(:,801:1000))));
flab00('\char232as','agregovan\char233{} $K$','V\char253voj agregovan\char233ho $K$ pre 100 podnikov');
set(h,'LineWidth',2);
grid on;
epsw01('fig.9','wide');
