%DP0010 Mixed adjustment costs.

clear all;

% profitability discretization
meanA = 1;
A = meanA * (1.05 .^ (-15:15));
NS = length(A);

% adjustment costs
GM = 0.01;
F = 0.001;
Pbid = 1;
Pask = .99;

NK = 40
K(NK) = 50;

BETA = 0.99
DELTA = 0.02
THETA = 0.32;

PI = mark01(NS,4,0.2);

% capital discretization

for i = (NK - 1):-1:1
   K(i) = K(i + 1) * (1 - DELTA);
end

% the capital matrix
MK = repmat(K, NK, 1);

imac00;

% utility
for i = 1:NS
   BMK(:,(((i - 1) * NK) + 1):(i * NK)) = A(i) * MK .^ THETA - IM - AC;
end


[DR, V] = iter00(BMK, PI, BETA);

% break
M = dist00(DR, PI, 0.0001, 500);

KK = repmat(K,NS,1);
II = K(DR) - (1 - DELTA) * KK;

try
   delete(1,2);
end

figure(1);
[c,h,cc] = contourf(K,A',K(DR),24);
set(h,'LineStyle','none');
colormap(flipud(hot));
colorbar;
flab00('$K$','$A$','Optim\char225lne $K''$');
epsw01('fig.14','small');

% investicie
figure(2);
[c,h,cc] = contourf(K,A',100 * (II ./ KK),24);
set(h,'LineStyle','none');
colormap(jet);
colorbar;
flab00('$K$','$A$','Optim\char225lne $i$ [\%]');
epsw01('fig.15','small');