function epsw00(FNAME,FTYPE,FNUM)
%epsw00 Write figure to EPS file
%
%	EPSW(FNAME,FTYPE,FNUM) write figure FNUM (default set to GCF)
%	to file FNAME. FTYPE is one of the following
%
%	'big' -- 8 x 6 cm (the default)
%	'small' -- 6 x 4.5 cm
%	'wide' -- 12 x 6 cm

if nargin < 1
   FNAME = 'figXX.eps';
end

if nargin < 2
   FTYPE = 'big';
end

if nargin < 3
   FNUM = gcf;
end      

set(FNUM,'PaperUnits','centimeters');
switch FTYPE
case 'small'
   set(FNUM,'PaperPosition',[0 0 6 4.5]);
case 'wide'
   set(FNUM,'PaperPosition',[0 0 12 6]);
otherwise
   set(FNUM,'PaperPosition',[0 0 8 6]);
end

print(FNUM,'-deps',FNAME);

return