function epsw01(FNAME,FTYPE,FNUM)
%epsw00 Write figure to EPS file
%
%	EPSW(FNAME,FTYPE,FNUM) write figure FNUM (default set to GCF)
%	to file FNAME. FTYPE is one of the following
%
%	'big' -- 8 x 6 cm (the default)
%	'small' -- 9 x 9 cm
%	'wide' -- 20 x 15 cm

if nargin < 1
   FNAME = 'figXX.eps';
end

if nargin < 2
   FTYPE = 'big';
end

if nargin < 3
   FNUM = gcf;
end      

set(FNUM,'PaperUnits','centimeters');
switch FTYPE
case 'small'
   set(FNUM,'PaperPosition',[0 0 7.8 6]);
case 'wide'
   set(FNUM,'PaperPosition',[0 0 16.5 8.2]);
otherwise
   set(FNUM,'PaperPosition',[0 0 13.3 8.2]);
end

print(FNUM,'-depsc2',FNAME);

return