function flab00(XLABS,YLABS,TITS)
%FLAB00 Labels current figure with tex strings.
%
%	FLAB00(XLABS,YLABS,TITS) write labels to figure in TeX format.
%
%	XLABS -- X label TeX string
%	YLABS -- Y label TeX string
%	TITS -- Figure title TeX string

if (nargin > 2) & (length(TITS) > 0)
   title(strcat('\tex[B][B]{\textpic{',TITS,'}}'),'Interpreter','none')
end

if (nargin > 1) & (length(YLABS) > 0)
   ylabel(strcat('\tex[B][B]{\textpic{',YLABS,'}}'),'Interpreter','none')
end

if (nargin > 0) & (length(XLABS) > 0)
   xlabel(strcat('\tex[t][t]{\textpic{',XLABS,'}}'),'Interpreter','none')
end

   