function [PI, VAL, COUNTS, EDGES] = hest01(DATA, N, EDGES)
%HEST00 Estimates markov process from given historical data.
%
%	[PI, VAL, COUNTS] = HEST00(DATA, N) calculates transition
%	matrix PI and representative values VAL for firs-order N - state
%	markov process, given by vector of its realizations DATA.
%	It stores histogram of data into COUNTS.

if ((nargin < 2) | (N < 1))
   N = 7;
end

% create bins
maxD = max(DATA);
minD = min(DATA);
delt = (maxD - minD) / N;
if nargin < 3
    EDGES = minD:delt:maxD;
end

if (length(EDGES) ~= (N + 1))
   error('Invalid input data !');
end
VAL = (EDGES(1:N) + EDGES(2:(N+1))) ./ 2;

% count histogram
[H, BIN] = histc(DATA, EDGES);
COUNTS = H(1:N);
COUNTS(N) = COUNTS(N) + H(N+1);
BIN(BIN == N + 1) = N;

% calculates transition matrix
NBIN = length(BIN);
PI = zeros(N);
y = BIN(1);
for i = 2:NBIN
   x = y;
   y = BIN(i);
   PI(x,y) = PI(x,y) + 1;
end

for i = 1:N
   if sum(PI(i,:)) ~= 0
      PI(i,:) = PI(i,:) ./ sum(PI(i,:));
   end
end

return