function PI = mark00(N, sigma)
%MARK00 Create transition matrix for markov process.
%
%	PI = MARK00(N, sigma) computes transition matrix for
%	firs-order N - state markov process, with steady state
%	normal distribution with approximately sigma
%	standard deviation.

ro = 0.7;
bulg = 2 / 1.152;

% check parameters
if (ro <= 0)
   error('Invalid ro.');
end
if (nargin < 2)
   sigma =1.152;
end
if (sigma <= 0)
   error('Invalid sigma.');
end
if ((nargin < 1) | (N < 2))
   error('Invalid number of stages.')
end

sigma = sigma / bulg;

for i = 1:N
   shift = fix(i - N/2 + 0.5 - 1);
   s2 = 2 * sigma * (ro ^ abs(shift));
   vec = (0:N-1)./(N - 1) * s2  - ((i - 1)/(N - 1) * s2);
   PI(i,:) = normpdf(vec);
   PI(i,:) = PI(i,:) ./ sum(PI(i,:));
end   

return