function PI = mark00(N, sigma, slope)
%MARK00 Create transition matrix for markov process.
%
%	PI = MARK00(N, sigma, slope) computes transition matrix for
%	firs-order N - state markov process, with steady state
%	normal distribution with approximately sigma standard
%	deviation. The SLOPE means the slope of dominant direction
%	of the rows.

ro = 0.7;
bulg = 2 / 1.152;

% check parameters
if (ro <= 0)
   error('Invalid ro.');
end
if (nargin < 2)
   sigma =1.152;
end
if (sigma <= 0)
   error('Invalid sigma.');
end
if ((nargin < 1) | (N < 2))
   error('Invalid number of stages.')
end

for i = 1:N
   shift = fix(i - N/2 + 0.5 - 1) ;
   vec = (0:N-1)./(N - 1) - slope * (i - 1)/(N - 1) ...
      - (1 - slope) * 0.5;
   PI(i,:) = normpdf(2 * sigma * vec);
   PI(i,:) = PI(i,:) ./ sum(PI(i,:));
end   

return