function [D, S] = simp00(DR, PI, D1, S1, GS)
%SIMP00 Return one realization of combined random process
%
%	[D, S] = SIMP00(DR, PI, D0, S0, GD)

TIME = length(GS);
SPI = size(PI);
SDR = size(DR);
GN = SDR(1) / SPI(1);
D = zeros(1, TIME);
S = zeros(1, TIME);
D(1) = D1;
S(1) = S1;

for i = 2:TIME
   D(i) = DR(S(i-1) + ((GS(i-1) - 1) * GN),D(i-1));
   S(i) = drnd00(PI(S(i-1),:));
end

return