function [D, S] = simp00(DR, PI, D1, S1, TIME)
%SIMP00 Return one realization of random process
%
%	[D, S] = SIMP00(DR, PI, D0, S0, TIME) simulates firs-order
%	N - state markov process with transition matrix PI and
%	starting state S0, where each agent is making also its
%	own decisions, starting with decision variable set to D0.
%	These decisions are described by decision rule DR.
%
%	This funcion fist calculates D2 thrue DR, then S2 simulating
%	markov process and so on. The result is vector of made decisions D
%	and realizations of markov process S. Each of these vectors
%	has size TIME (TIME > 1).

if nargin < 5
   error('Not enought input arguments.');
end

D = zeros(1, TIME);
S = zeros(1, TIME);
D(1) = D1;
S(1) = S1;

for i = 2:TIME
   D(i) = DR(S(i-1),D(i-1));
   S(i) = drnd00(PI(S(i-1),:));
end

return