function S = stst00(PI, eps, maxit)
%STST00 Return steady state distrbution for markov process.
%
%	S = STST00(PI, EPS, MAXIT) return vector of probabilities
%	of a steady state distribution for markov process given by
%	transition matrix PI.
%
%	EPS gives the desired precision, MAXIT the maximal number
%	of iterations.

T = PI;
S = T(1,:);

if nargin < 3
   maxit = 100;
end
if nargin < 2
   eps = 0.00001;
end

for i = 1:maxit
   SP = S;
   T = PI * T;
   S = T(1,:);
   
   % check if precision is not reached
   DF = [(abs(S-SP)+eps)./(1+abs(SP))];
   check = max(DF');   
   if check < (eps + eps * eps);
      break      
   end
   
end


return