function [Y,S,PI] = test00(N, sigma)
%TEST00 Test MARK00 function.
%
%	[Y,S,PI] = test00(N, sigma) calculates steady state and returns
%	it (Y), with expected steady state (S) and transition matrix PI.
%
%	See also MARK00.

PI = mark00(N,sigma);
S = normpdf((0:(N - 1))./(N - 1) .* 2 .* sigma - sigma);
S = S ./ sum(S);
X = PI;

for i = 1:100
   X = PI * X;
end

Y = X(1,:);