%TEST04 Test HEST00.
%
%	Calculate transition matrix for given data.

N = 31;

% read data, if not previosly done
if (exist('DDAT','var') == 0)
   [DATA, N1, N2] = TBLREAD('../data/ticks/weekly/DJI.csv',',');
   DATA = flipud(DATA);
   aDATA = sum(DATA') ./ 4;
   sDATA = length(aDATA);
   DDAT = log(aDATA(2:sDATA) ./ aDATA(1:(sDATA - 1)));
end


% DDAT now contains log of profitability
[PI, VAL, COUNT] = hest00(DDAT,N);
STST = stst00(PI);
meanV = log(sum(exp(VAL) .* STST));
XDAT = DDAT - meanV;
[PI, VAL, COUNT] = hest00(XDAT,N);
STST = stst00(PI);
CTST = COUNT / sum(COUNT);
VAL = exp(VAL);

try
   delete(1)
end

figure(1);
hold on;
MEAN = sum(STST .* VAL)
plot(VAL,CTST,':');
plot(VAL,STST);

