%TEST05 Test distribution of given data.
%
%	Calculate histograms of given data.

N = 31;

% read data, if not previosly done
if (exist('DDAT','var') == 0)
   [DATA, N1, N2] = TBLREAD('../data/ticks/daily/DJI.csv',',');
   DATA = flipud(DATA);
   aDATA = sum(DATA') ./ 4;
   sDATA = length(aDATA);
   DDAT = log(aDATA(2:sDATA) ./ aDATA(1:(sDATA - 1)));
end

maxD = max(DDAT);
minD = min(DDAT);
delt = (maxD - minD) / N;
EDGES = minD:delt:maxD;
if (length(EDGES) ~= (N + 1))
   error('Invalid input data !');
end
VAL = (EDGES(1:N) + EDGES(2:(N+1))) ./ 2;

% calculates histograms
try
   delete(1)
end

figure(1);
hold on;

NDATA = length(DDAT);
STEP = 100;
LEN = 200;
for i = LEN:STEP:NDATA
   [H] = histc(DDAT((i - LEN + 1):i), EDGES);
   COUNTS = H(1:N);
   COUNTS(N) = COUNTS(N) + H(N+1);
   CTCT = COUNTS ./ sum(COUNTS);
   plot(exp(VAL),CTCT);
end


