%TEST03 Test SIMP00 with DIST00.
%
%	Simulate random processes for given PI and DR, and calculates
%	distribution from simulations. First should be run DP0000.
%
%	At the end NM should equal to sum(M), and NX to SS.
%
%	See also SIMP00, DIST00, DP0000

NM = zeros(1,NK);
NX = zeros(1,NS);
SS = stst00(lPI);

TIME = length(GS);
NUMBER = 500;
SIMD = zeros(NUMBER,TIME);

for i = 1:NUMBER
   disp(sprintf('Simulation %d of %d.',i,NUMBER));
   [D, S] = simm00(DR, lPI, NK, drnd00(SS), GS);
   for j = 1:TIME
      NM(D(j)) = NM(D(j)) + 1;
      NX(S(j)) = NX(S(j)) + 1;
   end
   SIMD(i,:) = D;
end

NM = NM ./ sum(NM);
NX = NX ./ sum(NX);