%TEST03 Test SIMP00 with DIST00.
%
%	Simulate random processes for given PI and DR, and calculates
%	distribution from simulations. First should be run DP0000.
%
%	At the end NM should equal to sum(M), and NX to SS.
%
%	See also SIMP00, DIST00, DP0000

NM = zeros(1,NK);
NX = zeros(1,NS);
SS = stst00(PI);

% investment rate
IR = zeros(1,NS);
IRN = zeros(1,NS);
STK = sum(M);
MM = M;
for i = 1:NS
   MM(i,:) = MM(i,:) ./ sum(MM(i,:));
end


TIME = 1000;
NUMBER = 500;
SIMS = zeros(NUMBER,TIME);
SIMD = zeros(NUMBER,TIME);

for i = 1:NUMBER
   disp(sprintf('Simulation %d of %d.',i,NUMBER));
   S0 = drnd00(SS);
   D0 = drnd00(MM(S0,:));
   [D, S] = simp00(DR, PI, D0, S0, TIME);
   for j = 1:TIME
      NM(D(j)) = NM(D(j)) + 1;
      NX(S(j)) = NX(S(j)) + 1;
      if (j > 1)
         I = K(D(j)) - (1 - DELTA)*K(D(j-1));
         if (I > 0) 
            IR(S(j-1)) = IR(S(j-1)) + I/K(D(j-1));
            IRN(S(j-1)) = IRN(S(j-1)) + 1;
         end
      end
      PREVD = D(j);
   end
   SIMS(i,:) = S;
   SIMD(i,:) = D;
end

NM = NM ./ sum(NM);
NX = NX ./ sum(NX);
IR = IR ./ IRN;