(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     51322,       1438]*)
(*NotebookOutlinePosition[     52018,       1463]*)
(*  CellTagsIndexPosition[     51974,       1459]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
<<c:\\math\\kniz\\linearal\\tridiago.m
<<c:\\math\\kniz\\options\\optvalue.m\
\>", "Input"],

Cell["\<\
EuroPut[X_,sigma_,r_,D_,t_,m_,n_,trans_,time_]:=
Module[
{doldiag,diag,hordiag},

xright=Log[Slarge/X];
xleft=-xright;
k1=N[r/(0.5*sigma^2)];
k2=N[(r-D)/(0.5*sigma^2)];
k3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
k4=N[0.25*(k1^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

TransfCallPayoff[x_]:=N[Max[0,Exp[0.5*(k2-1)*x]-Exp[0.5*(k2+1)*x]]];
Do[u[i,0]=TransfCallPayoff[i*h],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
 Do[
      der1=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      der2=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
ClenAbs[i]=Abs[N[k4*u[i,j-1]-k2*der1+der2]],{i,-m+1,m-1}];

op1=Exp[0.5*(k2-1)*xleft+0.25*(k2-1)^2*k*j]-
    Exp[0.5*(k2+1)*xleft+0.25*(k2+1)^2*k*j];
op2=0;

ps = Join[{u[-m+1,j-1]-k3*k*ClenAbs[-m+1]-a*op1},
          Table[u[i,j-1]-k3*k*ClenAbs[i],{i,-m+2,m-2}],
          {u[m-1,j-1] -k3*k*ClenAbs[m-1] -c*op2}];
          
hordiag=Table[c,{i,-m+1,m-2}];
diag=Table[b,{i,-m+1,m-1}];
doldiag=Table[a,{i,-m+2,m-1}];

riesenie=TridiagonalSolve[N[doldiag],N[diag],N[hordiag],N[ps]];
 
u[-m,j]=op1;
Do[u[i,j]=riesenie[[i+m]],{i,-m+1,m-1}];
u[m,j]=op2;

xs=Table[X*Exp[i*h],{i,-m,m}];
ys=Table[X*Exp[-0.5*(k2-1)*i*h-(0.25*(k2-1)^2+k1)*j*k]*u[i,j],{i,-m,m}];
graf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
{j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X=60;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=10;
n=10;
Slarge=150;
trans=0.0;
time=0.03;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["EuroPut[X,sigma,r,DD,t,m,n,trans,time]", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[EuropeanPutDiv[S,X,str,r,DD,t],{S,0,150},PlotRange->All,PlotStyle->\
RGBColor[0,1,0], DisplayFunction->Identity];
g1=ListPlot[graf[n],PlotStyle->{PointSize[0.02],RGBColor[1,0,1]},\
DisplayFunction->Identity];
g2=Plot[EuropeanPutDiv[S,X,sigma,r,DD,t],{S,0,150},PlotRange->All, \
DisplayFunction->Identity];

Show[g2,g1,g,DisplayFunction->$DisplayFunction,PlotRange->{{20,90},{0,40}}]
\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.285714 0.0142857 0 0.0154508 [
[.14286 -0.0125 -6 -9 ]
[.14286 -0.0125 6 0 ]
[.28571 -0.0125 -6 -9 ]
[.28571 -0.0125 6 0 ]
[.42857 -0.0125 -6 -9 ]
[.42857 -0.0125 6 0 ]
[.57143 -0.0125 -6 -9 ]
[.57143 -0.0125 6 0 ]
[.71429 -0.0125 -6 -9 ]
[.71429 -0.0125 6 0 ]
[.85714 -0.0125 -6 -9 ]
[.85714 -0.0125 6 0 ]
[1 -0.0125 -6 -9 ]
[1 -0.0125 6 0 ]
[-0.0125 .07725 -6 -4.5 ]
[-0.0125 .07725 0 4.5 ]
[-0.0125 .15451 -12 -4.5 ]
[-0.0125 .15451 0 4.5 ]
[-0.0125 .23176 -12 -4.5 ]
[-0.0125 .23176 0 4.5 ]
[-0.0125 .30902 -12 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .38627 -12 -4.5 ]
[-0.0125 .38627 0 4.5 ]
[-0.0125 .46353 -12 -4.5 ]
[-0.0125 .46353 0 4.5 ]
[-0.0125 .54078 -12 -4.5 ]
[-0.0125 .54078 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.14286 0 m
.14286 .00625 L
s
[(30)] .14286 -0.0125 0 1 Mshowa
.28571 0 m
.28571 .00625 L
s
[(40)] .28571 -0.0125 0 1 Mshowa
.42857 0 m
.42857 .00625 L
s
[(50)] .42857 -0.0125 0 1 Mshowa
.57143 0 m
.57143 .00625 L
s
[(60)] .57143 -0.0125 0 1 Mshowa
.71429 0 m
.71429 .00625 L
s
[(70)] .71429 -0.0125 0 1 Mshowa
.85714 0 m
.85714 .00625 L
s
[(80)] .85714 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(90)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.02857 0 m
.02857 .00375 L
s
.05714 0 m
.05714 .00375 L
s
.08571 0 m
.08571 .00375 L
s
.11429 0 m
.11429 .00375 L
s
.17143 0 m
.17143 .00375 L
s
.2 0 m
.2 .00375 L
s
.22857 0 m
.22857 .00375 L
s
.25714 0 m
.25714 .00375 L
s
.31429 0 m
.31429 .00375 L
s
.34286 0 m
.34286 .00375 L
s
.37143 0 m
.37143 .00375 L
s
.4 0 m
.4 .00375 L
s
.45714 0 m
.45714 .00375 L
s
.48571 0 m
.48571 .00375 L
s
.51429 0 m
.51429 .00375 L
s
.54286 0 m
.54286 .00375 L
s
.6 0 m
.6 .00375 L
s
.62857 0 m
.62857 .00375 L
s
.65714 0 m
.65714 .00375 L
s
.68571 0 m
.68571 .00375 L
s
.74286 0 m
.74286 .00375 L
s
.77143 0 m
.77143 .00375 L
s
.8 0 m
.8 .00375 L
s
.82857 0 m
.82857 .00375 L
s
.88571 0 m
.88571 .00375 L
s
.91429 0 m
.91429 .00375 L
s
.94286 0 m
.94286 .00375 L
s
.97143 0 m
.97143 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .07725 m
.00625 .07725 L
s
[(5)] -0.0125 .07725 1 0 Mshowa
0 .15451 m
.00625 .15451 L
s
[(10)] -0.0125 .15451 1 0 Mshowa
0 .23176 m
.00625 .23176 L
s
[(15)] -0.0125 .23176 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(20)] -0.0125 .30902 1 0 Mshowa
0 .38627 m
.00625 .38627 L
s
[(25)] -0.0125 .38627 1 0 Mshowa
0 .46353 m
.00625 .46353 L
s
[(30)] -0.0125 .46353 1 0 Mshowa
0 .54078 m
.00625 .54078 L
s
[(35)] -0.0125 .54078 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(40)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .01545 m
.00375 .01545 L
s
0 .0309 m
.00375 .0309 L
s
0 .04635 m
.00375 .04635 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .10816 m
.00375 .10816 L
s
0 .12361 m
.00375 .12361 L
s
0 .13906 m
.00375 .13906 L
s
0 .16996 m
.00375 .16996 L
s
0 .18541 m
.00375 .18541 L
s
0 .20086 m
.00375 .20086 L
s
0 .21631 m
.00375 .21631 L
s
0 .24721 m
.00375 .24721 L
s
0 .26266 m
.00375 .26266 L
s
0 .27812 m
.00375 .27812 L
s
0 .29357 m
.00375 .29357 L
s
0 .32447 m
.00375 .32447 L
s
0 .33992 m
.00375 .33992 L
s
0 .35537 m
.00375 .35537 L
s
0 .37082 m
.00375 .37082 L
s
0 .40172 m
.00375 .40172 L
s
0 .41717 m
.00375 .41717 L
s
0 .43262 m
.00375 .43262 L
s
0 .44807 m
.00375 .44807 L
s
0 .47898 m
.00375 .47898 L
s
0 .49443 m
.00375 .49443 L
s
0 .50988 m
.00375 .50988 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .57168 m
.00375 .57168 L
s
0 .58713 m
.00375 .58713 L
s
0 .60258 m
.00375 .60258 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .60698 m
.07068 .53053 L
.16183 .43195 L
.24956 .33713 L
.34281 .23767 L
.43266 .14942 L
.51909 .0822 L
.56372 .05672 L
.61104 .03656 L
.63221 .02959 L
.65499 .02334 L
.69617 .01483 L
.7189 .0114 L
.74372 .00846 L
.76716 .00633 L
.78892 .0048 L
.8127 .00352 L
.8351 .00261 L
.85521 .00198 L
.87696 .00146 L
.89835 .00108 L
.92182 .00077 L
.94634 .00054 L
.96922 .00038 L
.99274 .00027 L
s
.99274 .00027 m
1 .00024 L
s
1 0 1 r
.02 w
.05714 .54517 Mdot
.09004 .50959 Mdot
.1261 .47059 Mdot
.16562 .42786 Mdot
.20893 .38106 Mdot
.25639 .3299 Mdot
.30841 .27428 Mdot
.36542 .21474 Mdot
.4279 .15346 Mdot
.49638 .09563 Mdot
.57143 .0495 Mdot
.65368 .02141 Mdot
.74382 .00795 Mdot
.84261 .0026 Mdot
.95089 .00077 Mdot
0 1 0 r
.5 Mabswid
0 .60698 m
.07068 .53053 L
.16183 .43195 L
.24956 .33713 L
.34281 .23767 L
.43266 .14942 L
.51909 .0822 L
.56372 .05672 L
.61104 .03656 L
.63221 .02959 L
.65499 .02334 L
.69617 .01483 L
.7189 .0114 L
.74372 .00846 L
.76716 .00633 L
.78892 .0048 L
.8127 .00352 L
.8351 .00261 L
.85521 .00198 L
.87696 .00146 L
.89835 .00108 L
.92182 .00077 L
.94634 .00054 L
.96922 .00038 L
.99274 .00027 L
s
.99274 .00027 m
1 .00024 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{371.563, 229.563},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005c0000iB000`400?l00000o`00003oo`3ooomd
0?ooo`00@03oool2@00000@0oooo00=000000?ooo`3oool0:@3oool3@0000080oooo00=000000?oo
o`3oool0:@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo02L0oooo0T0000040?oo
o`03@000003oool0oooo02T0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0Y0?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool09`3oool2@00000@0oooo00=000000?oo
o`3oool01P3oool00480oooo00I000000?ooo`3ooom000000?oood00000[0?ooo`06@000003oool0
oooo@000003ooom00000:@3oool00d000000oooo@00000020?ooo`03@000003ooom0000002P0oooo
00=000000?oood0000000P3oool00d000000oooo@000000Z0?ooo`07@000003oool0oooo0?oood00
0000oooo@000000Y0?ooo`03@000003ooom000000080oooo00=000000?oood000000:P3oool01T00
0000oooo0?oood000000oooo@00000L0oooo00110?ooo`07@000003oool0oooo0?oood000000oooo
@000000Y0?ooo`A0000000@0oooo@000003ooom00000:`3oool01T000000oooo0?oood000000oooo
@00002P0oooo00=000000?oood0000000P3oool00d000000oooo@000000Z0?ooo`07@000003oool0
oooo0?oood000000oooo@000000Y0?ooo`03@000003ooom000000080oooo00=000000?oood000000
:@3oool2@0000080oooo00=000000?oood0000001`3oool00480oooo00I000000?ooo`3ooom00000
0?oood00000Y0?ooo`03@000003ooom000000080oooo00=000000?oood000000:@3oool2@00000<0
oooo00=000000?oood000000:03oool2@00000<0oooo00=000000?oood000000:`3oool01T000000
oooo0?oood000000oooo@00002X0oooo00M000000?ooo`3oool0oooo@000003ooom0000002P0oooo
00=000000?oood0000000P3oool00d000000oooo@00000070?ooo`00@03oool00d000000oooo@000
00020?ooo`03@000003ooom0000002X0oooo0T0000020?ooo`03@000003ooom0000002T0oooo00=0
00000?ooo`3oool00P3oool00d000000oooo@000000X0?ooo`03@000003oool0oooo0080oooo00=0
00000?oood000000:@3oool00d000000oooo@00000020?ooo`03@000003ooom0000002T0oooo00=0
00000?oood0000000P3oool00d000000oooo@000000X0?ooo`03@000003ooom000000080oooo00=0
00000?oood0000001`3oool00440oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0Z
0?ooo`05@000003oool0oooo0?oood000000:P3oool3@00000<0oooo00=000000?ooo`3oool0:03o
ool2@00000<0oooo00=000000?ooo`3oool0:03oool3@00000<0oooo00=000000?ooo`3oool0:@3o
ool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo02P0oooo0T0000030?ooo`03@000003o
ool0oooo00H0oooo003o0?ooog@0oooo003o0?ooog@0oooo003o0?ooog@0oooo003o0?ooog@0oooo
003o0?ooog@0oooo003o0?oooeH0oooo1@3o0?lI0?ooo`004`3ooooo000001h000001@3o0?lF0000
01h00?l02P3oool001<0oooo00<000000?ooo`3oool01`3oool00d000000oooo0?ooo`070?ooo`03
@000003oool0oooo00L0oooo00=000000?ooo`3oool01P3oool00d000000oooo0?ooo`070?ooo`03
0000003oool0oooo00L0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`060?ooo`03
@000003oool0oooo00L0oooo00=000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`03
@000003oool0oooo00H0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`070?ooo`03
@000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00d000000oooo0?ooo`070?ooo`03
@000003oool0oooo00L0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`060?ooo`03
0000003oool0oooo00L0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`070?ooo`03
@000003oool0oooo00H0oooo00=000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`03
@000003oool0oooo00H0oooo00=000000?ooo`3oool01`3oool00d0000000?l0003o000T003o0003
@000003oool0oooo00L0oooo1@3o0?l50?ooo`03@000003oool0oooo00H0oooo00<000000?ooo`3o
ool0203oool001<0oooo00<000000?ooo`3oool0;P3oool00d000000oooo0?ooo`0^0?ooo`03@000
003oool0oooo02h0oooo00=000000?ooo`3oool0;@3oool00d000000oooo0?ooo`0^0?ooo`03@000
003oool0oooo00@0oooo1@3o0?l30?ooo`l00?l02`3oool50?l0o`<0oooo00=000000?ooo`3oool0
6P3oool50?l0o`h0oooo00=000000?ooo`3oool0203oool001<0oooo00<000000?ooo`3oool0n03o
ool8003o01X0oooo1@3o0?lQ0?ooo`<0o`3o6P3oool001<0oooo00<000000?ooo`3oool0l03oool8
003o00D0o`3o7P3oool30?l0ocl0oooo000C0?ooo`80000000=000000?ooo`3oool0i`3oool7003o
00P0oooo1@3o0?mP0?ooo`004`3oool00`000000oooo0?ooo`3I0?ooo`D0o`3o1`3oool4003o0100
oooo0`3o0?mQ0?ooo`004`3oool00`000000oooo0?ooo`3I0?ooo`D0o`3o0P3oool5003o07P0oooo
000C0?ooo`030000003oool0oooo0=T0oooo0`3o0?l4003o07d0oooo000C0?ooo`030000003oool0
oooo0=P0oooo1000o`020?l0ogl0oooo000C0?ooo`030000003oool0oooo0=@0oooo1000o`020?oo
o`<0o`3oP03oool001<0oooo0P0000000d000000oooo0?ooo`3@0?ooo`800?l0R@3oool001<0oooo
00<000000?ooo`3oool0d03oool2003o08/0oooo000C0?ooo`030000003oool0oooo0<d0oooo0`00
o`2=0?ooo`004`3oool00`000000oooo0?ooo`3;0?ooo`800?l0T03oool001<0oooo00<000000?oo
o`3oool0b@3oool2003o0980oooo000C0?ooo`80000000=000000?ooo`3oool0^`3oool50?l0o`D0
oooo0P00o`2D0?ooo`004`3oool00`000000oooo0?ooo`2m0?ooo`D0o`3o0P3oool3003o09H0oooo
000C0?ooo`030000003oool0oooo0;d0oooo1@3o0?l2003o09T0oooo000C0?ooo`030000003oool0
oooo0;d0oooo0`3o0?l2003o09/0oooo000C0?ooo`030000003oool0oooo0;h0oooo0P00o`000`3o
0?l0oooo0?ooo`2J0?ooo`004`3oool200000003@000003oool0oooo0;X0oooo0P00o`2O0?ooo`00
4`3oool00`000000oooo0?ooo`2j0?ooo`800?l0X@3oool001<0oooo00<000000?ooo`3oool0^03o
ool2003o0:<0oooo000C0?ooo`030000003oool0oooo0;H0oooo0P00o`2U0?ooo`00303oool00d00
0000oooo0?ooo`040?ooo`030000003oool0oooo0;@0oooo0P00o`2W0?ooo`002`3oool00d000000
oooo@00000050?ooo`030000003oool0oooo0;80oooo0P00o`2Y0?ooo`003@3oool00d000000oooo
0?ooo`030?ooo`<0000000=000000?ooo`3oool0[@3oool2003o0:/0oooo000;0?ooo`9000001P3o
ool00`000000oooo0?ooo`2^0?ooo`800?l0[@3oool000/0oooo00=000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`2]0?ooo`03003o003oool0oooo0:d0oooo000;0?ooo`=000001@3oool00`00
0000oooo0?ooo`2[0?ooo`800?l0/03oool001<0oooo00<000000?ooo`3oool0ZP3oool00`00o`00
oooo0?ooo`2`0?ooo`004`3oool200000003@000003oool0oooo0:80oooo1@3o0?l00`00o`00oooo
0?ooo`2a0?ooo`004`3oool00`000000oooo0?ooo`2T0?ooo`@0o`3o00<00?l00?ooo`3oool0/P3o
ool001<0oooo00<000000?ooo`3oool0Y03oool20?l0o`800?l000<0o`3o0?ooo`3oool0/P3oool0
01<0oooo00<000000?ooo`3oool0Y03oool00`3o0?l00?l00?l0o`020?l0ok@0oooo000C0?ooo`03
0000003oool0oooo0:@0oooo00@00?l00?l0o`3o0?l0o`3o]@3oool001<0oooo0P0000000d000000
oooo0?ooo`2Q0?ooo`03003o003oool0oooo0;L0oooo000C0?ooo`030000003oool0oooo0:40oooo
0P00o`2j0?ooo`004`3oool00`000000oooo0?ooo`2P0?ooo`03003o003oool0oooo0;X0oooo000C
0?ooo`030000003oool0oooo09l0oooo00<00?l00?ooo`3oool0^`3oool001<0oooo00<000000?oo
o`3oool0W@3oool2003o0;h0oooo000C0?ooo`80000000=000000?ooo`3oool0VP3oool00`00o`00
oooo0?ooo`2n0?ooo`004`3oool00`000000oooo0?ooo`2K0?ooo`03003o003oool0oooo0;l0oooo
000C0?ooo`030000003oool0oooo09X0oooo00<00?l00?ooo`3oool0`03oool001<0oooo00<00000
0?ooo`3oool0V03oool2003o0<<0oooo000C0?ooo`030000003oool0oooo09L0oooo00<00?l00?oo
o`3oool0``3oool001<0oooo00<000000?ooo`3oool0UP3oool00`00o`00oooo0?ooo`340?ooo`00
4`3oool200000003@000003oool0oooo09<0oooo00<00?l00?ooo`3oool0a@3oool001<0oooo00<0
00000?ooo`3oool0T`3oool2003o0<P0oooo000C0?ooo`030000003oool0oooo0980oooo00<00?l0
0?ooo`3oool0b03oool000D0oooo1D0000020?ooo`03@000003oool0oooo00@0oooo00<000000?oo
o`3oool0S03oool50?l0o`03003o003oool0oooo0<T0oooo00070?ooo`07@000003oool0oooo0?oo
od000000oooo@00000050?ooo`030000003oool0oooo08`0oooo103o0?l00`00o`00oooo0?ooo`3:
0?ooo`001`3oool01d000000oooo0?ooo`3ooom000000?oood0000001@3oool300000003@000003o
ool0oooo08T0oooo0`3o0?l00`00o`00o`3o0?ooo`3;0?ooo`001`3oool01d000000oooo0?ooo`3o
oom000000?oood0000001@3oool00`000000oooo0?ooo`2<0?ooo`80o`3o00<00?l00?l0o`3o0?l0
c03oool000L0oooo00M000000?ooo`3oool0oooo@000003ooom0000000D0oooo00<000000?ooo`3o
ool0S@3oool00`00o`00o`3o0?l0o`3=0?ooo`001P3oool2@00000@0oooo00=000000?ooo`3oool0
103oool00`000000oooo0?ooo`2<0?ooo`03003o003oool0oooo0<h0oooo000C0?ooo`030000003o
ool0oooo08/0oooo00<00?l00?ooo`3oool0c`3oool001<0oooo0P0000000d000000oooo0?ooo`28
0?ooo`03003o003oool0oooo0=00oooo000C0?ooo`030000003oool0oooo08T0oooo00<00?l00?oo
o`3oool0d@3oool001<0oooo00<000000?ooo`3oool0R03oool00`00o`00oooo0?ooo`3B0?ooo`00
4`3oool00`000000oooo0?ooo`270?ooo`03003o003oool0oooo0=<0oooo000C0?ooo`030000003o
ool0oooo08H0oooo00<00?l00?ooo`3oool0e03oool001<0oooo0P0000000d000000oooo0?ooo`23
0?ooo`03003o003oool0oooo0=D0oooo000C0?ooo`030000003oool0oooo08@0oooo00<00?l00?oo
o`3oool0eP3oool001<0oooo00<000000?ooo`3oool0P`3oool00`00o`00oooo0?ooo`3G0?ooo`00
4`3oool00`000000oooo0?ooo`210?ooo`800?l0fP3oool001<0oooo00<000000?ooo`3oool0P03o
ool00`00o`00oooo0?ooo`3J0?ooo`004`3oool00`000000oooo0?ooo`1o0?ooo`03003o003oool0
oooo0=/0oooo000C0?ooo`80000000=000000?ooo`3oool0O03oool00`00o`00oooo0?ooo`3L0?oo
o`004`3oool00`000000oooo0?ooo`1m0?ooo`03003o003oool0oooo0=d0oooo000C0?ooo`030000
003oool0oooo07`0oooo00<00?l00?ooo`3oool0gP3oool001<0oooo00<000000?ooo`3oool0M`3o
ool40?l0o`03003o003oool0oooo0=l0oooo000C0?ooo`030000003oool0oooo07L0oooo0`3o0?l0
0`00o`00o`3o0?ooo`3P0?ooo`004`3oool200000003@000003oool0oooo07D0oooo0P3o0?l00`00
o`00o`3o0?l0o`3Q0?ooo`004`3oool00`000000oooo0?ooo`1g0?ooo`030?l0o`00o`00o`3o0080
o`3oh@3oool001<0oooo00<000000?ooo`3oool0M`3oool01000o`00o`3o0?l0o`3o0?oR0?ooo`00
1@3oool5@0000080oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`1f0?ooo`03003o
003oool0oooo0>@0oooo00070?ooo`07@000003oool0oooo0?oood000000oooo@00000050?ooo`03
0000003oool0oooo07D0oooo00<00?l00?ooo`3oool0i@3oool000L0oooo00=000000?ooo`3oool0
0`3oool00d000000oooo0?ooo`030?ooo`<0000000=000000?ooo`3oool0L@3oool00`00o`00oooo
0?ooo`3V0?ooo`001`3oool014000000oooo0?ooo`3oool2@00000H0oooo00<000000?ooo`3oool0
L`3oool00`00o`00oooo0?ooo`3W0?ooo`001`3oool01D000000oooo0?ooo`3ooom0000000L0oooo
00<000000?ooo`3oool0LP3oool00`00o`00oooo0?ooo`3X0?ooo`001P3oool2@00000<0oooo0d00
00050?ooo`030000003oool0oooo0740oooo00<00?l00?ooo`3oool0j@3oool001<0oooo00<00000
0?ooo`3oool0L03oool00`00o`00oooo0?ooo`3Z0?ooo`004`3oool00`000000oooo0?ooo`1_0?oo
o`03003o003oool0oooo0>/0oooo000C0?ooo`80000000=000000?ooo`3oool0K03oool00`00o`00
oooo0?ooo`3/0?ooo`004`3oool00`000000oooo0?ooo`1]0?ooo`03003o003oool0oooo0>d0oooo
000C0?ooo`030000003oool0oooo06`0oooo00<00?l00?ooo`3oool0kP3oool001<0oooo00<00000
0?ooo`3oool0J`3oool00`00o`00oooo0?ooo`3_0?ooo`004`3oool00`000000oooo0?ooo`1Z0?oo
o`03003o003oool0oooo0?00oooo000C0?ooo`80000000=000000?ooo`3oool0J03oool00`00o`00
oooo0?ooo`3`0?ooo`004`3oool00`000000oooo0?ooo`1Y0?ooo`03003o003oool0oooo0?40oooo
000C0?ooo`030000003oool0oooo06P0oooo00<00?l00?ooo`3oool0lP3oool001<0oooo00<00000
0?ooo`3oool0I03oool30?l0o`03003o003o0?l0oooo0?<0oooo000C0?ooo`030000003oool0oooo
06@0oooo0P3o0?l00`00o`00o`3o0?l0o`3d0?ooo`004`3oool200000003@000003oool0oooo0680
oooo00<0o`3o003o003o0?l00P3o0?od0?ooo`004`3oool00`000000oooo0?ooo`1T0?ooo`03003o
003o0?l0o`3o0080o`3om03oool001<0oooo00<000000?ooo`3oool0H`3oool00`00o`00oooo0?l0
o`020?l0ooD0oooo000C0?ooo`030000003oool0oooo0680oooo00<00?l00?ooo`3oool0n03oool0
01<0oooo00<000000?ooo`3oool0H@3oool00`00o`00oooo0?ooo`3i0?ooo`004`3oool200000003
@000003oool0oooo05h0oooo00<00?l00?ooo`3oool0nP3oool001<0oooo00<000000?ooo`3oool0
G`3oool00`00o`00oooo0?ooo`3k0?ooo`004`3oool00`000000oooo0?ooo`1N0?ooo`03003o003o
ool0oooo0?`0oooo000C0?ooo`030000003oool0oooo05d0oooo00<00?l00?ooo`3oool0o@3oool0
00H0oooo0d0000030?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0G03oool00`00
o`00oooo0?ooo`3n0?ooo`001P3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000000D0
oooo00<000000?ooo`3oool0F`3oool00`00o`00oooo0?ooo`3o0?ooo`001`3oool01d000000oooo
0?ooo`3ooom000000?oood0000001@3oool300000003@000003oool0oooo05L0oooo00<00?l00?oo
o`3oool0o`3oool10?ooo`001`3oool01d000000oooo0?ooo`3ooom000000?oood0000001@3oool0
0`000000oooo0?ooo`1J0?ooo`03003o003oool0oooo0?l0oooo0@3oool000H0oooo00=000000?oo
od0000000P3oool00d000000oooo@00000050?ooo`030000003oool0oooo05T0oooo00<00?l00?oo
o`3oool0o`3oool20?ooo`001`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00@0
oooo00<000000?ooo`3oool0F03oool00`00o`00oooo0?ooo`3o0?ooo`<0oooo000C0?ooo`030000
003oool0oooo05L0oooo00<00?l00?ooo`3oool0o`3oool40?ooo`004`3oool200000003@000003o
ool0oooo05@0oooo00<00?l00?ooo`3oool0o`3oool50?ooo`004`3oool00`000000oooo0?ooo`1B
0?ooo`<0o`3o00<00?l00?l0o`3oool0o`3oool60?ooo`004`3oool00`000000oooo0?ooo`1B0?oo
o`80o`3o00<00?l00?l0o`3o0?l0o`3oool70?ooo`004`3oool00`000000oooo0?ooo`1B0?ooo`03
0?l0o`00o`00o`3o0080o`3oo`3oool70?ooo`004`3oool00`000000oooo0?ooo`1B0?ooo`03003o
003o0?l0o`3o0080o`3oo`3oool70?ooo`004`3oool200000003@000003oool0oooo04l0oooo00<0
0?l00?ooo`3o0?l00P3o0?oo0?ooo`P0oooo000C0?ooo`030000003oool0oooo0500oooo00<00?l0
0?ooo`3oool0o`3oool;0?ooo`004`3oool00`000000oooo0?ooo`1?0?ooo`03003o003oool0oooo
0?l0oooo303oool001<0oooo00<000000?ooo`3oool0CP3oool00`00o`00oooo0?ooo`3o0?ooo`d0
oooo000C0?ooo`030000003oool0oooo04h0oooo00<00?l00?ooo`3oool0o`3oool=0?ooo`004`3o
ool200000003@000003oool0oooo04/0oooo00<00?l00?ooo`3oool0o`3oool>0?ooo`004`3oool0
0`000000oooo0?ooo`1<0?ooo`03003o003oool0oooo0?l0oooo3`3oool001<0oooo00<000000?oo
o`3oool0B`3oool00`00o`00oooo0?ooo`3o0?oooa00oooo000C0?ooo`030000003oool0oooo04X0
oooo00<00?l00?ooo`3oool0o`3ooolA0?ooo`004`3oool00`000000oooo0?ooo`190?ooo`03003o
003oool0oooo0?l0oooo4P3oool001<0oooo00<000000?ooo`3oool0B03oool00`00o`00oooo0?oo
o`3o0?oooa<0oooo000C0?ooo`80000000=000000?ooo`3oool0A@3oool00`00o`00oooo0?ooo`3o
0?oooa@0oooo000C0?ooo`030000003oool0oooo04L0oooo00<00?l00?ooo`3oool0o`3ooolD0?oo
o`004`3oool00`000000oooo0?ooo`120?ooo`@0o`3o00<00?l00?ooo`3oool0o`3ooolE0?ooo`00
1P3oool3@00000<0oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`120?ooo`<0o`3o
00<00?l00?l0o`3oool0o`3ooolF0?ooo`001P3oool00d000000oooo0?ooo`020?ooo`03@000003o
oom0000000D0oooo00<000000?ooo`3oool0@P3oool20?l0o`03003o003o0?l0o`3o0?l0oooo5`3o
ool000L0oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`030?ooo`<0000000=00000
0?ooo`3oool0?`3oool00`3o0?l00?l00?l0o`020?l0ool0oooo5`3oool000L0oooo00A000000?oo
o`3oool0oooo0T0000060?ooo`030000003oool0oooo0480oooo00@00?l00?l0o`3o0?l0o`3oo`3o
oolH0?ooo`001P3oool00d000000oooo@00000020?ooo`03@000003oool0oooo00D0oooo00<00000
0?ooo`3oool0@@3oool00`00o`00oooo0?ooo`3o0?oooaX0oooo00070?ooo`04@000003oool0oooo
0?ooo`=000001@3oool00`000000oooo0?ooo`100?ooo`03003o003oool0oooo0?l0oooo6`3oool0
01<0oooo00<000000?ooo`3oool0@03oool00`00o`00oooo0?ooo`3o0?oooa/0oooo000C0?ooo`80
000000=000000?ooo`3oool0?@3oool00`00o`00oooo0?ooo`3o0?oooa`0oooo000C0?ooo`030000
003oool0oooo03h0oooo00<00?l00?ooo`3oool0o`3ooolM0?ooo`004`3oool00`000000oooo0?oo
o`0m0?ooo`03003o003oool0oooo0?l0oooo7P3oool001<0oooo00<000000?ooo`3oool0?03oool0
0`00o`00oooo0?ooo`3o0?oooal0oooo000C0?ooo`030000003oool0oooo03/0oooo00<00?l00?oo
o`3oool0o`3ooolP0?ooo`004`3oool200000003@000003oool0oooo03P0oooo00<00?l00?ooo`3o
ool0o`3ooolQ0?ooo`004`3oool00`000000oooo0?ooo`0i0?ooo`03003o003oool0oooo0?l0oooo
8P3oool001<0oooo00<000000?ooo`3oool0>@3oool00`00o`00oooo0?ooo`3o0?ooob80oooo000C
0?ooo`030000003oool0oooo03<0oooo1@3o0?l00`00o`00oooo0?ooo`3o0?ooob<0oooo000C0?oo
o`030000003oool0oooo03<0oooo103o0?l00`00o`00oooo0?ooo`3o0?ooob@0oooo000C0?ooo`03
0000003oool0oooo03<0oooo0`3o0?l00`00o`00o`3o0?ooo`3o0?ooobD0oooo000C0?ooo`800000
00=000000?ooo`3oool0<@3oool20?l0o`03003o003o0?l0o`3o0?l0oooo9P3oool001<0oooo00<0
00000?ooo`3oool0=03oool00`00o`00o`3o0?l0o`3o0?ooobL0oooo000C0?ooo`030000003oool0
oooo03<0oooo00<00?l00?ooo`3oool0o`3ooolX0?ooo`004`3oool00`000000oooo0?ooo`0b0?oo
o`03003o003oool0oooo0?l0oooo:@3oool001<0oooo00<000000?ooo`3oool0<@3oool00`00o`00
oooo0?ooo`3o0?ooobX0oooo000C0?ooo`80000000=000000?ooo`3oool0;P3oool00`00o`00oooo
0?ooo`3o0?ooob/0oooo000C0?ooo`030000003oool0oooo02l0oooo00<00?l00?ooo`3oool0o`3o
ool/0?ooo`004`3oool00`000000oooo0?ooo`0^0?ooo`03003o003oool0oooo0?l0oooo;@3oool0
00H0oooo0T0000040?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0;@3oool00`00
o`00oooo0?ooo`3o0?ooobh0oooo00080?ooo`06@000003oool0oooo@000003ooom000001@3oool0
0`000000oooo0?ooo`0/0?ooo`03003o003oool0oooo0?l0oooo;`3oool000L0oooo00M000000?oo
o`3oool0oooo@000003ooom0000000D0oooo0`0000000d000000oooo0?ooo`0X0?ooo`03003o003o
ool0oooo0?l0oooo<03oool000P0oooo00I000000?ooo`3ooom000000?oood0000050?ooo`030000
003oool0oooo02X0oooo00<00?l00?ooo`3oool0o`3ooola0?ooo`001P3oool00d000000oooo@000
00020?ooo`03@000003ooom0000000D0oooo00<000000?ooo`3oool09P3oool30?l0o`03003o003o
0?l0oooo0?l0oooo<P3oool000L0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`04
0?ooo`030000003oool0oooo02H0oooo0P3o0?l00`00o`00o`3o0?l0o`3o0?oooc<0oooo000C0?oo
o`030000003oool0oooo02H0oooo00<0o`3o003o003o0?l00P3o0?oo0?oooc<0oooo000C0?ooo`03
0000003oool0oooo02H0oooo00<00?l00?l0o`3o0?l00P3o0?oo0?oooc<0oooo000C0?ooo`800000
00=000000?ooo`3oool08`3oool00`00o`00oooo0?l0o`020?l0ool0oooo=03oool001<0oooo00<0
00000?ooo`3oool09@3oool00`00o`00oooo0?ooo`3o0?ooocH0oooo000C0?ooo`030000003oool0
oooo02@0oooo00<00?l00?ooo`3oool0o`3ooolg0?ooo`004`3oool00`000000oooo0?ooo`0S0?oo
o`03003o003oool0oooo0?l0oooo>03oool001<0oooo00<000000?ooo`3oool08P3oool00`00o`00
oooo0?ooo`3o0?ooocT0oooo000C0?ooo`80000000=000000?ooo`3oool07`3oool00`00o`00oooo
0?ooo`3o0?ooocX0oooo000C0?ooo`030000003oool0oooo0200oooo00<00?l00?ooo`3oool0o`3o
oolk0?ooo`004`3oool00`000000oooo0?ooo`0O0?ooo`03003o003oool0oooo0?l0oooo?03oool0
01<0oooo00<000000?ooo`3oool07P3oool00`00o`00oooo0?ooo`3o0?ooocd0oooo000C0?ooo`03
0000003oool0oooo01T0oooo103o0?l00`00o`00oooo0?ooo`3o0?oooch0oooo000C0?ooo`800000
00=000000?ooo`3oool05`3oool30?l0o`03003o003o0?l0oooo0?l0oooo?`3oool001<0oooo00<0
00000?ooo`3oool06@3oool20?l0o`03003o003o0?l0o`3o0?l0oooo@03oool001<0oooo00<00000
0?ooo`3oool06@3oool00`3o0?l00?l00?l0o`020?l0ool0oooo@03oool001<0oooo00<000000?oo
o`3oool06@3oool01000o`00o`3o0?l0o`3o0?oo0?oood40oooo000C0?ooo`030000003oool0oooo
01P0oooo00<00?l00?ooo`3oool0o`3ooom30?ooo`004`3oool200000003@000003oool0oooo01D0
oooo00<00?l00?ooo`3oool0o`3ooom40?ooo`004`3oool00`000000oooo0?ooo`0F0?ooo`03003o
003oool0oooo0?l0ooooA@3oool001<0oooo00<000000?ooo`3oool05@3oool00`00o`00oooo0?oo
o`3o0?ooodH0oooo000C0?ooo`030000003oool0oooo01@0oooo00<00?l00?ooo`3oool0o`3ooom7
0?ooo`001P3oool2@00000@0oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`0C0?oo
o`03003o003oool0oooo0?l0ooooB03oool000P0oooo00I000000?ooo`3ooom000000?oood000005
0?ooo`030000003oool0oooo0180oooo00<00?l00?ooo`3oool0o`3ooom90?ooo`001`3oool00d00
0000oooo0?ooo`030?ooo`03@000003oool0oooo00<0oooo0`0000000d000000oooo0?ooo`0;0?oo
o`<0o`3o00<00?l00?l0o`3oool0o`3ooom:0?ooo`00203oool00d000000oooo0?ooo`02@00000H0
oooo00<000000?ooo`3oool03P3oool20?l0o`03003o003o0?l0o`3o0?l0ooooB`3oool000H0oooo
00=000000?oood0000000P3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo00h0oooo
00<0o`3o003o003o0?l00P3o0?oo0?oood/0oooo00070?ooo`04@000003oool0oooo0?ooo`=00000
1@3oool00`000000oooo0?ooo`0>0?ooo`030?l0o`00o`00o`3o0080o`3oo`3ooom;0?ooo`004`3o
ool00`000000oooo0?ooo`0>0?ooo`04003o003o0?l0o`3o0?l0ool0ooooC03oool001<0oooo0P00
00000d000000oooo0?ooo`0;0?ooo`03003o003oool0oooo0?l0ooooCP3oool001<0oooo00<00000
0?ooo`3oool0303oool00`00o`00oooo0?ooo`3o0?ooodl0oooo000C0?ooo`030000003oool0oooo
00/0oooo00<00?l00?ooo`3oool0o`3ooom@0?ooo`004`3oool00`000000oooo0?ooo`0:0?ooo`03
003o003oool0oooo0?l0ooooD@3oool001<0oooo00<000000?ooo`3oool02@3oool00`00o`00oooo
0?ooo`3o0?oooe80oooo000C0?ooo`80000000=000000?ooo`3oool01P3oool00`00o`00oooo0?oo
o`3o0?oooe<0oooo000C0?ooo`030000003oool0oooo00L0oooo00<00?l00?ooo`3oool0o`3ooomD
0?ooo`004`3oool00`000000oooo0?ooo`060?ooo`03003o003oool0oooo0?l0ooooE@3oool001<0
oooo00<000000?ooo`3oool01@3oool00`00o`00oooo0?ooo`3o0?oooeH0oooo000C0?ooo`030000
003oool0oooo00@0oooo00<00?l00?ooo`3oool0o`3ooomG0?ooo`004`3oool200000005@000003o
ool0oooo0?ooo`00o`00o`3ooomJ0?ooo`004`3oool00`000000oooo0?ooo`030?ooo`03003o003o
ool0oooo0?l0ooooF03oool001<0oooo00<000000?ooo`3oool00P3oool00`00o`00oooo0?ooo`3o
0?oooeT0oooo000C0?ooo`050000003oool0oooo0?ooo`00o`00o`3ooomL0?ooo`004`3oool01000
0000oooo0?ooo`00o`3o0?oooed0oooo000C0?ooo`030000003oool00?l00?l0ooooGP3oool001<0
oooo00<00000003o04000000o`3ooomN0?ooo`004`3oool00`00o`00oooo0?ooo`3o0?oooeh0oooo
000C0?ooo`030000003oool0oooo0?l0ooooGP3oool000L0oooo0d0000020?ooo`03@000003oool0
oooo00@0oooo00<000000?ooo`3oool0o`3ooomN0?ooo`00203oool01T000000oooo0?oood000000
oooo@00000D0oooo00<000000?ooo`3oool0o`3ooomN0?ooo`001P3oool4@00000040?oood000000
oooo@00000D0oooo00A000000000000000100000o`3ooomM0?ooo`001P3oool00d000000oooo@000
00020?ooo`03@000003ooom000000?l0ooooIP3oool000L0oooo0T0000020?ooo`03@000003ooom0
00000?l0ooooIP3oool000P0oooo00E000000?ooo`3oool0oooo@000003o0?ooofL0oooo003o0?oo
og@0oooo0000\
\>"],
  ImageRangeCache->{{{0, 370.563}, {228.563, 0}} -> {15.9213, -2.51702, 
  0.205231, 0.189756}}]
}, Open  ]],

Cell[TextData[
"\"Err : rozdiel medzi BS a nasim vysledkom\n tr1 : chyba nasho vysledku \
oproti explicitnemu rieseniu  -  tabu\:017eka\""], "Text"],

Cell["\<\
Err[i_,sgm_]:=EuropeanPutDiv[xs[[i]],X,sgm,r,DD,t]-ys[[i]];
tr1:=Table[{xs[[i]],Err[i,str]},{i,2m+1}];\
\>", "Input"],

Cell["\"Graf chyby pribli\.9en\[EAcute]ho rie\.9aenia\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=ListPlot[tr1,PlotStyle->{PointSize[0.02],RGBColor[1,0,1]},DisplayFunction->\
Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->All]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.157596 0.00755858 0.193964 26.617 [
[.14475 .18146 -6 -9 ]
[.14475 .18146 6 0 ]
[.29592 .18146 -6 -9 ]
[.29592 .18146 6 0 ]
[.44709 .18146 -6 -9 ]
[.44709 .18146 6 0 ]
[.59826 .18146 -9 -9 ]
[.59826 .18146 9 0 ]
[.74943 .18146 -9 -9 ]
[.74943 .18146 9 0 ]
[.9006 .18146 -9 -9 ]
[.9006 .18146 9 0 ]
[-0.01892 .06088 -36 -4.5 ]
[-0.01892 .06088 0 4.5 ]
[-0.01892 .32705 -30 -4.5 ]
[-0.01892 .32705 0 4.5 ]
[-0.01892 .46013 -24 -4.5 ]
[-0.01892 .46013 0 4.5 ]
[-0.01892 .59322 -30 -4.5 ]
[-0.01892 .59322 0 4.5 ]
[ -0.00642 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.14475 .19396 m
.14475 .20021 L
s
[(40)] .14475 .18146 0 1 Mshowa
.29592 .19396 m
.29592 .20021 L
s
[(60)] .29592 .18146 0 1 Mshowa
.44709 .19396 m
.44709 .20021 L
s
[(80)] .44709 .18146 0 1 Mshowa
.59826 .19396 m
.59826 .20021 L
s
[(100)] .59826 .18146 0 1 Mshowa
.74943 .19396 m
.74943 .20021 L
s
[(120)] .74943 .18146 0 1 Mshowa
.9006 .19396 m
.9006 .20021 L
s
[(140)] .9006 .18146 0 1 Mshowa
.125 Mabswid
.03137 .19396 m
.03137 .19771 L
s
.06916 .19396 m
.06916 .19771 L
s
.10695 .19396 m
.10695 .19771 L
s
.18254 .19396 m
.18254 .19771 L
s
.22033 .19396 m
.22033 .19771 L
s
.25813 .19396 m
.25813 .19771 L
s
.33371 .19396 m
.33371 .19771 L
s
.3715 .19396 m
.3715 .19771 L
s
.4093 .19396 m
.4093 .19771 L
s
.48488 .19396 m
.48488 .19771 L
s
.52268 .19396 m
.52268 .19771 L
s
.56047 .19396 m
.56047 .19771 L
s
.63605 .19396 m
.63605 .19771 L
s
.67385 .19396 m
.67385 .19771 L
s
.71164 .19396 m
.71164 .19771 L
s
.78723 .19396 m
.78723 .19771 L
s
.82502 .19396 m
.82502 .19771 L
s
.86281 .19396 m
.86281 .19771 L
s
.9384 .19396 m
.9384 .19771 L
s
.97619 .19396 m
.97619 .19771 L
s
.25 Mabswid
0 .19396 m
1 .19396 L
s
-0.00642 .06088 m
-0.00017 .06088 L
s
[(-0.005)] -0.01892 .06088 1 0 Mshowa
-0.00642 .32705 m
-0.00017 .32705 L
s
[(0.005)] -0.01892 .32705 1 0 Mshowa
-0.00642 .46013 m
-0.00017 .46013 L
s
[(0.01)] -0.01892 .46013 1 0 Mshowa
-0.00642 .59322 m
-0.00017 .59322 L
s
[(0.015)] -0.01892 .59322 1 0 Mshowa
.125 Mabswid
-0.00642 .0875 m
-0.00267 .0875 L
s
-0.00642 .11411 m
-0.00267 .11411 L
s
-0.00642 .14073 m
-0.00267 .14073 L
s
-0.00642 .16735 m
-0.00267 .16735 L
s
-0.00642 .22058 m
-0.00267 .22058 L
s
-0.00642 .2472 m
-0.00267 .2472 L
s
-0.00642 .27382 m
-0.00267 .27382 L
s
-0.00642 .30043 m
-0.00267 .30043 L
s
-0.00642 .35367 m
-0.00267 .35367 L
s
-0.00642 .38028 m
-0.00267 .38028 L
s
-0.00642 .4069 m
-0.00267 .4069 L
s
-0.00642 .43352 m
-0.00267 .43352 L
s
-0.00642 .48675 m
-0.00267 .48675 L
s
-0.00642 .51337 m
-0.00267 .51337 L
s
-0.00642 .53999 m
-0.00267 .53999 L
s
-0.00642 .5666 m
-0.00267 .5666 L
s
-0.00642 .03426 m
-0.00267 .03426 L
s
-0.00642 .00765 m
-0.00267 .00765 L
s
.25 Mabswid
-0.00642 0 m
-0.00642 .61803 L
s
1 0 1 r
.02 w
.02381 .19396 Mdot
.02548 .19405 Mdot
.02716 .19413 Mdot
.02887 .19419 Mdot
.03058 .19425 Mdot
.03231 .1943 Mdot
.03406 .19435 Mdot
.03583 .19438 Mdot
.03761 .19442 Mdot
.0394 .19445 Mdot
.04122 .19447 Mdot
.04305 .19449 Mdot
.04489 .19451 Mdot
.04676 .19453 Mdot
.04864 .19454 Mdot
.05054 .19456 Mdot
.05245 .19457 Mdot
.05439 .19458 Mdot
.05634 .19459 Mdot
.05831 .1946 Mdot
.06029 .19461 Mdot
.0623 .19462 Mdot
.06432 .19462 Mdot
.06637 .19463 Mdot
.06843 .19464 Mdot
.07051 .19464 Mdot
.07261 .19465 Mdot
.07473 .19466 Mdot
.07687 .19466 Mdot
.07903 .19467 Mdot
.0812 .19468 Mdot
.0834 .19468 Mdot
.08562 .19469 Mdot
.08786 .1947 Mdot
.09012 .1947 Mdot
.0924 .19471 Mdot
.0947 .19472 Mdot
.09702 .19472 Mdot
.09937 .19473 Mdot
.10173 .19474 Mdot
.10412 .19474 Mdot
.10653 .19474 Mdot
.10896 .19475 Mdot
.11141 .19475 Mdot
.11389 .19475 Mdot
.11639 .19474 Mdot
.11891 .19473 Mdot
.12145 .19471 Mdot
.12402 .19468 Mdot
.12662 .19464 Mdot
.12923 .19457 Mdot
.13187 .19448 Mdot
.13454 .19435 Mdot
.13723 .19418 Mdot
.13994 .19393 Mdot
.14268 .19361 Mdot
.14544 .19317 Mdot
.14823 .19258 Mdot
.15105 .19182 Mdot
.15389 .19082 Mdot
.15676 .18953 Mdot
.15965 .18788 Mdot
.16257 .1858 Mdot
.16552 .18319 Mdot
.16849 .17995 Mdot
.17149 .17598 Mdot
.17452 .17118 Mdot
.17758 .16543 Mdot
.18066 .15863 Mdot
.18378 .15071 Mdot
.18692 .14161 Mdot
.19009 .13132 Mdot
.19329 .11989 Mdot
.19652 .10742 Mdot
.19978 .09411 Mdot
.20307 .08025 Mdot
.20639 .06626 Mdot
.20974 .05263 Mdot
.21312 .03998 Mdot
.21653 .02905 Mdot
.21998 .02062 Mdot
.22345 .01555 Mdot
.22696 .01472 Mdot
.2305 .01893 Mdot
.23407 .02893 Mdot
.23768 .04528 Mdot
.24132 .06835 Mdot
.24499 .09822 Mdot
.2487 .13463 Mdot
.25244 .17701 Mdot
.25621 .2244 Mdot
.26002 .27548 Mdot
.26386 .32864 Mdot
.26774 .38204 Mdot
.27166 .43366 Mdot
.27561 .48147 Mdot
.2796 .52348 Mdot
.28362 .55792 Mdot
.28768 .58334 Mdot
.29178 .59867 Mdot
.29592 .60332 Mdot
.30009 .59722 Mdot
.30431 .58079 Mdot
.30856 .55495 Mdot
.31285 .52102 Mdot
.31718 .48063 Mdot
.32155 .43563 Mdot
.32596 .38796 Mdot
.33041 .33955 Mdot
.3349 .29218 Mdot
.33944 .24744 Mdot
.34401 .20662 Mdot
.34863 .1707 Mdot
.35329 .14032 Mdot
.35799 .1158 Mdot
.36274 .09714 Mdot
.36753 .08412 Mdot
.37236 .07629 Mdot
.37724 .07303 Mdot
.38216 .07367 Mdot
.38713 .07747 Mdot
.39215 .0837 Mdot
.39721 .09167 Mdot
.40231 .10075 Mdot
.40747 .1104 Mdot
.41267 .12017 Mdot
.41792 .12971 Mdot
.42322 .13874 Mdot
.42856 .14709 Mdot
.43396 .15465 Mdot
.4394 .16136 Mdot
.4449 .16721 Mdot
.45044 .17224 Mdot
.45604 .1765 Mdot
.46169 .18006 Mdot
.46739 .183 Mdot
.47314 .18539 Mdot
.47895 .18732 Mdot
.48481 .18886 Mdot
.49072 .19007 Mdot
.49669 .19102 Mdot
.50271 .19175 Mdot
.50879 .19232 Mdot
.51492 .19275 Mdot
.52111 .19307 Mdot
.52736 .19331 Mdot
.53367 .19349 Mdot
.54003 .19362 Mdot
.54645 .19372 Mdot
.55293 .19379 Mdot
.55947 .19384 Mdot
.56607 .19388 Mdot
.57274 .1939 Mdot
.57946 .19392 Mdot
.58624 .19393 Mdot
.59309 .19394 Mdot
.6 .19395 Mdot
.60697 .19395 Mdot
.61401 .19396 Mdot
.62111 .19396 Mdot
.62828 .19396 Mdot
.63552 .19396 Mdot
.64282 .19396 Mdot
.65018 .19396 Mdot
.65762 .19396 Mdot
.66512 .19396 Mdot
.6727 .19396 Mdot
.68034 .19396 Mdot
.68805 .19396 Mdot
.69584 .19396 Mdot
.70369 .19396 Mdot
.71162 .19396 Mdot
.71962 .19396 Mdot
.7277 .19396 Mdot
.73585 .19396 Mdot
.74407 .19396 Mdot
.75237 .19396 Mdot
.76075 .19396 Mdot
.7692 .19396 Mdot
.77773 .19396 Mdot
.78634 .19396 Mdot
.79503 .19396 Mdot
.8038 .19396 Mdot
.81265 .19396 Mdot
.82158 .19396 Mdot
.83059 .19396 Mdot
.83969 .19396 Mdot
.84887 .19396 Mdot
.85813 .19396 Mdot
.86748 .19396 Mdot
.87692 .19396 Mdot
.88644 .19396 Mdot
.89605 .19396 Mdot
.90575 .19396 Mdot
.91554 .19396 Mdot
.92542 .19396 Mdot
.93539 .19396 Mdot
.94545 .19396 Mdot
.9556 .19396 Mdot
.96585 .19396 Mdot
.97619 .19396 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo
0?ooo`3f0?ooo`009`3oool00`00001000000?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`0d
0?ooo`<0o`3o_`3oool002L0oooo00<000000?ooo`3oool0<`3oool40?l0okl0oooo000W0?ooo`03
0000003oool0oooo0380oooo1P3o0?nn0?ooo`009`3oool00`000000oooo0?ooo`0b0?ooo`H0o`3o
_P3oool002L0oooo00<000000?ooo`3oool0<P3oool30?l0o`040?ooo`3o0?l0o`3o0?l0okd0oooo
000W0?ooo`03000004000000oooo0380oooo0`3o0?l0103oool0o`3o0?l0o`3o0?nm0?ooo`009`3o
ool00`000000oooo0?ooo`0c0?ooo`050?l0o`3oool0oooo0?ooo`3o0?l0_P3oool002L0oooo00<0
00000?ooo`3oool0<@3oool30?l0ol80oooo000W0?ooo`030000003oool0oooo0340oooo0`3o0?l3
0?ooo`<0o`3o_03oool002L0oooo00<000000?ooo`3oool0<P3oool00`3o0?l0oooo0?ooo`020?oo
o`<0o`3o_03oool000d0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`030?ooo`03
0000003oool0oooo0300oooo0`3o0?l50?ooo`030?l0o`3oool0oooo0;/0oooo000<0?ooo`03@000
003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000
003ooom0000000@0oooo00<000000?ooo`3oool0<03oool30?l0ol<0oooo00070?ooo`=000000P3o
ool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood000000103o
ool00d000000oooo0?ooo`020?ooo`03000004000000oooo0340oooo00<0o`3o0?ooo`3oool0`P3o
ool000`0oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom0
00000080oooo0T0000050?ooo`030000003oool0oooo02l0oooo0`3o0?o40?ooo`00303oool00d00
0000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood0000000P3oool00d00
0000oooo0?ooo`040?ooo`030000003oool0oooo02l0oooo0`3o0?l60?ooo`<0o`3o^`3oool000d0
oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo0?oo
o`=00000103oool00`000000oooo0?ooo`0`0?ooo`030?l0o`3oool0oooo00D0oooo0`3o0?lN0?oo
o`@0o`3oV@3oool002L0oooo00<000000?ooo`3oool0>@3oool00`3o0?l0oooo0?ooo`0L0?ooo`L0
o`3oU`3oool002L0oooo00<000000?ooo`3oool0;P3oool30?l0obL0oooo203o0?nF0?ooo`009`3o
ool00`00001000000?ooo`0^0?ooo`<0o`3o9P3oool30?l0o`<0oooo0`3o0?nF0?ooo`009`3oool0
0`000000oooo0?ooo`0_0?ooo`030?l0o`3oool0oooo02D0oooo0`3o0?l40?ooo`<0o`3oU@3oool0
02L0oooo00<000000?ooo`3oool0;@3oool30?l0obP0oooo00<0o`3o0?ooo`3oool00`3oool30?l0
oiD0oooo000W0?ooo`030000003oool0oooo02d0oooo0`3o0?l90?ooo`<0o`3o6P3oool30?l0o`H0
oooo00<0o`3o0?ooo`3oool0U03oool002L0oooo00<000000?ooo`3oool0;P3oool00`3o0?l0oooo
0?ooo`080?ooo`<0o`3o6P3oool30?l0o`H0oooo0`3o0?nD0?ooo`009`3oool00`000000oooo0?oo
o`0]0?ooo`<0o`3o2P3oool00`3o0?l0oooo0?ooo`0J0?ooo`030?l0o`3oool0oooo00D0oooo0`3o
0?nD0?ooo`009`3oool00`000000oooo0?ooo`0]0?ooo`<0o`3o<03oool40?l0oi80oooo000W0?oo
o`03000004000000oooo02h0oooo00<0o`3o0?ooo`3oool08`3oool30?l0o`X0oooo0`3o0?nB0?oo
o`009`3oool00`000000oooo0?ooo`0/0?ooo`<0o`3o9@3oool30?l0o`/0oooo0`3o0?nA0?ooo`00
9`3oool00`000000oooo0?ooo`0/0?ooo`<0o`3o9P3oool00`3o0?l0oooo0?ooo`0:0?ooo`<0o`3o
T@3oool002L0oooo00<000000?ooo`3oool0;@3oool00`3o0?l0oooo0?ooo`0c0?ooo`030?l0o`3o
ool0oooo0900oooo000W0?ooo`030000003oool0oooo02/0oooo0`3o0?le0?ooo`<0o`3oT03oool0
02L0oooo00<000000?ooo`3oool0:`3oool30?l0o`/0oooo0`3o0?lW0?ooo`<0o`3oT03oool002L0
oooo00<000000?ooo`3oool0;03oool00`3o0?l0oooo0?ooo`0:0?ooo`<0o`3o5`3oool30?l0o`h0
oooo0`3o0?n?0?ooo`009`3oool00`00001000000?ooo`0Z0?ooo`<0o`3o3@3oool00`3o0?l0oooo
0?ooo`0F0?ooo`<0o`3o3P3oool30?l0ohl0oooo000W0?ooo`030000003oool0oooo02X0oooo0`3o
0?lW0?ooo`030?l0o`3oool0oooo00h0oooo103o0?n=0?ooo`009`3oool00`000000oooo0?ooo`0O
0?ooo`=000000P3oool00d000000oooo0?ooo`020?ooo`<0o`3o5`3oool2@00000@0oooo00=00000
0?ooo`3oool06P3oool30?l0o`03@000003oool0oooo0080oooo00=000000?ooo`3oool06@3oool5
@0000080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0F0?ooo`E0000000@0oooo
@0000400001000000`3oool00d000000oooo0?ooo`0G0?ooo`E000000P3oool3@0000080oooo00=0
00000?ooo`3oool04P3oool002L0oooo00<000000?ooo`3oool0803oool01T000000oooo0?oood00
0000oooo@00000<0oooo0`3o0?lG0?ooo`03@000003ooom000000080oooo00=000000?oood000000
703oool30?l0o`06@000003oool0oooo@000003ooom00000703oool01d000000oooo0?ooo`3ooom0
00000?oood0000000P3oool00d000000oooo@000000I0?ooo`05@000003oool0oooo0?oood000000
103oool00d000000oooo@000000J0?ooo`03@000003oool0oooo00<0oooo00I000000?ooo`3ooom0
00000?oood00000C0?ooo`009`3oool00`000000oooo0?ooo`0N0?ooo`A0000000@0oooo@000003o
oom000000`3oool30?l0oaL0oooo00=000000?oood0000000P3oool00d000000oooo@000000L0?oo
o`<0o`3o00I000000?ooo`3ooom000000?oood00000L0?ooo`07@000003oool0oooo0?oood000000
oooo@00000020?ooo`03@000003ooom0000001T0oooo00=000000?ooo`3oool00P3oool01d000000
oooo0?ooo`3ooom000000?oood0000006P3oool014000000oooo0?ooo`3oool4@00000040?oood00
0000oooo@00001<0oooo000W0?ooo`030000003oool0oooo01h0oooo00=000000?oood0000000P3o
ool00d000000oooo@00000030?ooo`<0o`3o5`3oool2@00000<0oooo00=000000?oood0000007@3o
ool30?l0o`80oooo00=000000?oood000000703oool01d000000oooo0?ooo`3ooom000000?oood00
00000P3oool00d000000oooo@000000I0?ooo`03@000003oool0oooo0080oooo00M000000?ooo`3o
ool0oooo@000003ooom0000001X0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo
00=000000?oood0000004`3oool002L0oooo00<00000@000003oool07`3oool2@0000080oooo00=0
00000?oood0000000P3oool30?l0oaP0oooo00=000000?ooo`3oool00P3oool00d000000oooo@000
000M0?ooo`D0o`3o00=000000?oood000000703oool01d000000oooo0?ooo`3ooom000000?oood00
00000P3oool00d000000oooo@000000I0?ooo`07@000003oool0oooo0?oood000000oooo@0000002
0?ooo`03@000003ooom0000001X0oooo00=000000?ooo`3oool00P3oool2@0000080oooo00=00000
0?oood0000004`3oool002L0oooo00<000000?ooo`3oool0803oool01D000000oooo0?ooo`3ooom0
00000080oooo103o0?lI0?ooo`9000000`3oool00d000000oooo0?ooo`060?ooo`<0o`3o503oool5
0?l0o`03@000003oool0oooo01X0oooo0T0000040?ooo`03@000003oool0oooo0080oooo00=00000
0?ooo`3oool05`3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0H
0?ooo`9000001@3oool01D000000oooo0?ooo`3ooom0000001@0oooo000W0?ooo`030000003oool0
oooo02H0oooo103o0?l@0?ooo`<0o`3o5@3oool30?l0oaH0oooo1@3o0?n60?ooo`009`3oool00`00
0000oooo0?ooo`0V0?ooo`<0o`3o4@3oool30?l0oaH0oooo00<0o`3o0?ooo`3oool05P3oool50?l0
ohD0oooo000W0?ooo`030000003oool0oooo02D0oooo103o0?lB0?ooo`030?l0o`3oool0oooo0300
oooo103o0?n40?ooo`009`3oool00`000000oooo0?ooo`0T0?ooo`@0o`3oA`3oool80?l0ogl0oooo
000W0?ooo`030000003oool0oooo0200oooo1`3o0?m90?oooa40o`3oM@3oool002L0oooo1@00000T
0?l0od`000000P3o0?l00`000000o`3o0?l0o`1i0?l0o`D000000D00000002L0oooo00<000000?oo
o`3oool00P3ooolS0?l0o`H0oooo00=000000?ooo`3oool01P3oool00d000000oooo0?ooo`070?oo
o`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool00d000000oooo0?ooo`070?oo
o`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool00d000000oooo0?ooo`070?oo
o`050?l0o`3oool0o`3o0?l0o`3oool00P3o0?l00`3oool0o`3o0?l0o`1`0?l0o`H0oooo000W0?oo
o`030000003oool0oooo00<0oooo7P3o0?mP0?ooo`80o`3o00H0oooo0?l0o`3o0?l0oooo0?l0o`3o
ool20?l0o`030?ooo`3o0?l0oooo0080o`3o00<0oooo0?l0o`3oool00P3o0?l01`3oool0o`3o0?oo
o`3o0?l0oooo0?l0o`3oool00P3o0?l03`3oool0o`3o0?ooo`3o0?l0oooo0?l0o`3oool0o`3o0?oo
o`3o0?l0oooo0?l0o`3oool0o`3o0?ooo`020?l0o`040?ooo`3o0?l0oooo0?l0o`80oooo0140o`3o
0?ooo`3o0?l0oooo0?l0o`3oool0o`3o0?ooo`3o0?l0oooo0?l0o`3oool0o`3o0?ooo`3o0?l0oooo
0?l0o`020?ooo`070?l0o`3oool0o`3o0?ooo`3o0?l0oooo0?l0o`020?ooo`050?l0o`3oool0o`3o
0?ooo`3o0?l00P3oool01@3o0?l0oooo0?l0o`3oool0o`3o0080oooo00<0o`3o0?ooo`3o0?l00P3o
ool00`3o0?l0oooo0?l0o`020?ooo`030?l0o`3oool0o`3o0080oooo00<0o`3o0?ooo`3oool01@3o
ool002L0oooo00<000000?ooo`3oool0D@3oool30?l0oj80oooo000W0?ooo`030000003oool0oooo
0540oooo0`3o0?nR0?ooo`009`3oool00`000000oooo0?ooo`1B0?ooo`030?l0o`3oool0oooo0:40
oooo000W0?ooo`03000004000000oooo0?H0oooo000W0?ooo`030000003oool0oooo03/0oooo0`3o
0?nh0?ooo`009`3oool00`000000oooo0?ooo`0k0?ooo`<0o`3o^03oool002L0oooo00<000000?oo
o`3oool0?03oool00`3o0?l0oooo0?ooo`2g0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`00
9`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool0
0`00001000000?ooo`1@0?ooo`<0o`3oX`3oool002L0oooo00<000000?ooo`3oool0D03oool30?l0
oj<0oooo000W0?ooo`030000003oool0oooo0540oooo00<0o`3o0?ooo`3oool0XP3oool002L0oooo
00<000000?ooo`3oool0mP3oool002L0oooo00<000000?ooo`3oool0mP3oool002L0oooo00<00000
0?ooo`3oool0mP3oool002L0oooo00<00000@000003oool0mP3oool002L0oooo00<000000?ooo`3o
ool0?03oool30?l0okL0oooo000W0?ooo`030000003oool0oooo03`0oooo0`3o0?ng0?ooo`009`3o
ool00`000000oooo0?ooo`0m0?ooo`030?l0o`3oool0oooo0;H0oooo000W0?ooo`030000003oool0
oooo0?H0oooo000W0?ooo`030000003oool0oooo04l0oooo0`3o0?nT0?ooo`009`3oool00`000000
oooo0?ooo`1?0?ooo`<0o`3oY03oool002L0oooo00<00000@000003oool0D03oool00`3o0?l0oooo
0?ooo`2S0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f
0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`003@3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo00<0oooo00<000000?ooo`3oool0mP3oool000`0oooo00=000000?oood000000
1`3oool00d000000oooo@00000020?ooo`03@000003ooom000000080oooo00=000000?oood000000
103oool00`000000oooo0?ooo`3f0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003o
oom000000080oooo00=000000?oood000000103oool00d000000oooo0?ooo`020?ooo`0300000400
0000oooo0?H0oooo000<0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool0
0d000000oooo@00000020?ooo`9000001@3oool00`000000oooo0?ooo`0m0?ooo`<0o`3o]P3oool0
00`0oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom00000
0080oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`0m0?ooo`<0o`3o]P3oool000d0
oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo0?oo
o`=00000103oool00`000000oooo0?ooo`0n0?ooo`030?l0o`3oool0oooo00d0oooo0`3o0?nU0?oo
o`009`3oool00`000000oooo0?ooo`1>0?ooo`<0o`3oY@3oool002L0oooo00<000000?ooo`3oool0
C`3oool00`3o0?l0oooo0?ooo`2T0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool0
0`00001000000?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000
oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?oo
o`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?oo
o`009`3oool00`00001000000?ooo`0n0?ooo`<0o`3o]@3oool002L0oooo00<000000?ooo`3oool0
?P3oool30?l0o``0oooo0`3o0?nV0?ooo`009`3oool00`000000oooo0?ooo`0o0?ooo`030?l0o`3o
ool0oooo00/0oooo0`3o0?nV0?ooo`009`3oool00`000000oooo0?ooo`1>0?ooo`030?l0o`3oool0
oooo0:D0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`030000003oool0oooo0?H0
oooo000W0?ooo`03000004000000oooo0?H0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W
0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`03
0000003oool0oooo0?H0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`030000003o
ool0oooo0?H0oooo000W0?ooo`03000004000000oooo03l0oooo0`3o0?l90?ooo`<0o`3oZ03oool0
02L0oooo00<000000?ooo`3oool0?`3oool30?l0o`T0oooo0`3o0?nX0?ooo`009`3oool00`000000
oooo0?ooo`100?ooo`030?l0o`3oool0oooo00T0oooo00<0o`3o0?ooo`3oool0Y`3oool002L0oooo
00<000000?ooo`3oool0mP3oool00180oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`020?ooo`03@000003oool0oooo00E000000`3oool00`000000oooo0?ooo`3f0?ooo`004@3oool0
0d000000oooo@00000070?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`3f0?ooo`004@3oool00d000000oooo@00000070?ooo`03@000003ooom00000
00<0oooo00=000000?ooo`3oool00`3oool00`00001000000?ooo`3f0?ooo`004@3oool00d000000
oooo@00000070?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3oool00`3oool00`000000
oooo0?ooo`3f0?ooo`004@3oool00d000000oooo@00000070?ooo`03@000003ooom0000000<0oooo
00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`3f0?ooo`004P3oool00d000000oooo0?oo
o`070?ooo`04@000003oool0oooo0?ooo`9000001@3oool00`000000oooo0?ooo`3f0?ooo`009`3o
ool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`100?ooo`<0o`3o1`3oool3
0?l0ojT0oooo000W0?ooo`030000003oool0oooo0400oooo0`3o0?l70?ooo`<0o`3oZ@3oool002L0
oooo00<00000@000003oool0@@3oool00`3o0?l0oooo0?ooo`070?ooo`030?l0o`3oool0oooo0:P0
oooo000W0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W
0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`03
0000003oool0oooo0?H0oooo000W0?ooo`03000004000000oooo0?H0oooo000W0?ooo`030000003o
ool0oooo0?H0oooo000W0?ooo`030000003oool0oooo04T0oooo0`3o0?nZ0?ooo`009`3oool00`00
0000oooo0?ooo`110?ooo`<0o`3o1@3oool30?l0ojX0oooo000W0?ooo`030000003oool0oooo0440
oooo0`3o0?l60?ooo`030?l0o`3oool0oooo0:T0oooo000W0?ooo`030000003oool0oooo0480oooo
00<0o`3o0?ooo`3oool0/@3oool002L0oooo00<000000?ooo`3oool0mP3oool002L0oooo00<00000
@000003oool0mP3oool002L0oooo00<000000?ooo`3oool0mP3oool002L0oooo00<000000?ooo`3o
ool0mP3oool002L0oooo00<000000?ooo`3oool0mP3oool002L0oooo00<000000?ooo`3oool0@P3o
ool30?l0o`<0oooo0`3o0?n[0?ooo`009`3oool00`000000oooo0?ooo`120?ooo`<0o`3o0`3oool3
0?l0oj/0oooo000W0?ooo`03000004000000oooo04<0oooo00<0o`3o0?ooo`3oool00`3oool00`3o
0?l0oooo0?ooo`2Z0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo
0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`17
0?ooo`<0o`3o[03oool000d0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?oo
o`03@000003oool0oooo00E000000P3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo
04<0oooo0`3o0?l0103oool0o`3o0?l0o`3o0?n/0?ooo`00303oool00d000000oooo@00000070?oo
o`03@000003ooom0000000<0oooo00M000000?ooo`3oool0oooo@000003ooom0000000@0oooo00<0
00000?ooo`3oool0@`3oool30?l0o`80oooo00<0o`3o0?ooo`3oool0Z`3oool000`0oooo00=00000
0?oood0000001`3oool00d000000oooo@00000030?ooo`03@000003oool0oooo00<0oooo00=00000
0?ooo`3oool00P3oool00`00001000000?ooo`140?ooo`030?l0o`3oool0oooo0:l0oooo000<0?oo
o`03@000003ooom0000000L0oooo00=000000?oood0000000`3oool014000000oooo0?ooo`3oool2
@00000D0oooo00<000000?ooo`3oool0A03oool50?l0ojd0oooo000<0?ooo`03@000003ooom00000
00L0oooo00=000000?oood0000000`3oool01D000000oooo0?ooo`3ooom0000000H0oooo00<00000
0?ooo`3oool0A03oool50?l0ojd0oooo000=0?ooo`03@000003oool0oooo00L0oooo00A000000?oo
o`3oool0oooo0T0000030?ooo`=00000103oool00`000000oooo0?ooo`150?ooo`<0o`3o[P3oool0
02L0oooo00<000000?ooo`3oool0AP3oool00`3o0?l0oooo0?ooo`2]0?ooo`009`3oool00`000000
oooo0?ooo`3f0?ooo`009`3oool00d000000oooo0?ooo`3f0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.988344, -0.00917032, 
  0.537069, 0.000152515}}]
}, Open  ]],

Cell["\"Maximova chyba\"", "Text"],

Cell["\<\
Print[\"m = \",m,\" n = \",n,\" trans = \",trans,\" Max.chyba \
\",Max[Table[Abs[Err[i,str]],{i,2m+1}]]]\
\>", "Input"],

Cell["\<\
\"Porovnanie hodnoty payoff diagramu, explicitn\[EAcute]ho rie\.9aenia a \
pribli\.9en\[EAcute]ho rie\.9aenia.\"\
\>", "Text"],

Cell["\<\
Table[{xs[[i]],Max[X-xs[[i]],0],EuropeanPutDiv[xs[[i]],X,sigma,r,DD,t],ys[[i]]\
},{i,1,2m+1,5}]\
\>", "Input"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{514, 383},
WindowMargins->{{-16, Automatic}, {Automatic, 6}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 101, 3, 48, "Input"],
Cell[1813, 54, 1266, 52, 966, "Input"],
Cell[3082, 108, 44, 0, 33, "Text"],
Cell[3129, 110, 111, 11, 192, "Input"],
Cell[3243, 123, 47, 0, 33, "Text"],
Cell[3293, 125, 73, 0, 30, "Input"],
Cell[3369, 127, 55, 0, 30, "Input"],
Cell[3427, 129, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[3476, 133, 415, 10, 192, "Input"],
Cell[3894, 145, 24999, 644, 238, 5137, 394, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[28908, 792, 148, 2, 52, "Text"],
Cell[29059, 796, 127, 3, 48, "Input"],
Cell[29189, 801, 65, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[29279, 805, 172, 5, 84, "Input"],
Cell[29454, 812, 21421, 606, 186, 6990, 423, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[50890, 1421, 34, 0, 33, "Text"],
Cell[50927, 1423, 129, 3, 48, "Input"],
Cell[51059, 1428, 136, 3, 33, "Text"],
Cell[51198, 1433, 120, 3, 48, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

