(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2514,         75]*)
(*NotebookOutlinePosition[      3164,         98]*)
(*  CellTagsIndexPosition[      3120,         94]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[
"\"Definovan\[EAcute] funkcie Eur\[OAcute]pskej call a put opcie -\n skript\
\[AAcute] Komorn\[IAcute]k, Komorn\[IAcute]kov\[AAcute], Mikula -\n  \
Modelovanie ekonomick\[YAcute]ch a finan\[CHacek]n\[YAcute]ch procesov,\n  \
strana 112.\""], "Text"],

Cell[TextData[
"\"Je potrebn\[EAcute] spusti\.9d obe funkcie, ak pou\.9e\[IAcute]vame ktor\
\[YAcute]ko\:017evek z programov.\""], "Text"],

Cell["\<\
NormalCDF[u_]:=0.5+0.5*Erf[u/Sqrt[2]];
EuropeanCallDiv[S_,X_,sigma_,r_,D_,t_]:=
  Module[{d1,d2},
  d1=(Log[S/X]+
   (r-D+sigma^2/2)*t)/(sigma*Sqrt[t]);
  d2=d1-sigma*Sqrt[t];
  Return[S*Exp[-D*t]*NormalCDF[d1]-
   X*Exp[-r*t]*NormalCDF[d2]]];\
\>", "Input"],

Cell["\<\
EuropeanPutDiv[S_,X_,sigma_,r_,D_,t_]:=EuropeanCallDiv[S,X,sigma,r,D,t]-S*Exp[\
-D*t]+X*Exp[-r*t]\
\>", "Input"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{450, 337},
WindowMargins->{{41, Automatic}, {66, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 264, 4, 90, "Text"],
Cell[1976, 55, 138, 2, 33, "Text"],
Cell[2117, 59, 268, 9, 156, "Input"],
Cell[2388, 70, 122, 3, 66, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

