(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     66013,       1791]*)
(*NotebookOutlinePosition[     66709,       1816]*)
(*  CellTagsIndexPosition[     66665,       1812]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
<<c:\\math\\kniz\\linearal\\tridiago.m
<<c:\\math\\kniz\\options\\optvalue.m\
\>", "Input"],

Cell["\"Bearish vertical spread : 1 call short + 1 call long\"", "Text"],

Cell["\<\
BearishSpread[X1_,X2_,sigma_,r_,D_,t_,m_,n_,trans_,time_]:=
Module[
{doldiag,diag,hordiag},

X=(X1+X2)/2;
xright=Log[Slarge/X];

k1=N[r/(0.5*sigma^2)];
k2=N[(r-D)/(0.5*sigma^2)];
k3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
k4=N[0.25*(k2^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

TransfBearSpreadPayoff[x_]:=N[Exp[0.5*(k2-1)*x]*(-Max[Exp[x]-X1/X,0]+Max[Exp[\
x]-X2/X,0])];
Do[u[i,0]=TransfBearSpreadPayoff[i*h],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
 Do[
      grad=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      kriv=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
ClenAbs[i]=Abs[N[k4*u[i,j-1]-k2*grad+kriv]],{i,-m+1,m-1}];

op1=0;
op2=Exp[0.5*(k2-1)*xright+0.25*(k2-1)^2*k*j]*(X1-X2)/X;

ps = Join[{u[-m+1,j-1]-k3*k*ClenAbs[-m+1]-a*op1},
          Table[u[i,j-1]-k3*k*ClenAbs[i],{i,-m+2,m-2}],
          {u[m-1,j-1]-k3*k*ClenAbs[m-1]-c*op2}];

hordiag=Table[c,{i,-m+1,m-2}];
diag=Table[b,{i,-m+1,m-1}];
doldiag=Table[a,{i,-m+2,m-1}];

riesenie=TridiagonalSolve[N[doldiag],N[diag],N[hordiag],N[ps]];
 
u[-m,j]=op1;
Do[u[i,j]=riesenie[[i+m]],{i,-m+1,m-1}];
u[m,j] =op2;

xs=Table[X*Exp[i*h],{i,-m,m}];
ys=Table[X*Exp[-0.5*(k2-1)*i*h-(0.25*(k2-1)^2+k1)*j*k]*u[i,j],{i,-m,m}];
grf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
{j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X1=55;
X2=65;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=100;
n=100;
Slarge=150;
trans=0.02;
time=0.03;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["BearishSpread[X1,X2,sigma,r,DD,t,m,n,trans,time]", "Input"],

Cell["\"Explicitn\[EAcute] rie\.9aenie\"", "Text"],

Cell["\<\
SpreadBear[S_,X1_,X2_,sigma_,r_,DD_,t_]:=
N[-EuropeanCallDiv[S,X1,sigma,r,DD,t]+EuropeanCallDiv[S,X2,sigma,r,DD,t]]\
\>", "Input"],

Cell["\"Payoff diagram\"", "Text"],

Cell["Payoff[S_,X1_,X2_]:=N[-Max[S-X1,0]+Max[S-X2,0]]", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[SpreadBear[S,X1,X2,sigma,r,DD,t],{S,0,150},PlotRange->All,PlotStyle->\
RGBColor[0,1,0], DisplayFunction->Identity];
g1=ListPlot[grf[n],PlotStyle->{PointSize[0.015],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];
g2=Plot[Payoff[S,X1,X2],{S,0,150},PlotRange->All, DisplayFunction->Identity];

Show[g2,g1,g,AxesLabel -> \
{\"S\",\"V\"},DisplayFunction->$DisplayFunction,PlotRange->{{20,120},{-11,1}}]\

\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.2 0.01 0.566531 0.0515028 [
[.2 .55403 -6 -9 ]
[.2 .55403 6 0 ]
[.4 .55403 -6 -9 ]
[.4 .55403 6 0 ]
[.6 .55403 -6 -9 ]
[.6 .55403 6 0 ]
[.8 .55403 -9 -9 ]
[.8 .55403 9 0 ]
[1 .55403 -9 -9 ]
[1 .55403 9 0 ]
[1.025 .56653 0 -7.5 ]
[1.025 .56653 10 7.5 ]
[-0.0125 .0515 -18 -4.5 ]
[-0.0125 .0515 0 4.5 ]
[-0.0125 .15451 -12 -4.5 ]
[-0.0125 .15451 0 4.5 ]
[-0.0125 .25751 -12 -4.5 ]
[-0.0125 .25751 0 4.5 ]
[-0.0125 .36052 -12 -4.5 ]
[-0.0125 .36052 0 4.5 ]
[-0.0125 .46353 -12 -4.5 ]
[-0.0125 .46353 0 4.5 ]
[0 .64303 -5.5 0 ]
[0 .64303 5.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2 .56653 m
.2 .57278 L
s
[(40)] .2 .55403 0 1 Mshowa
.4 .56653 m
.4 .57278 L
s
[(60)] .4 .55403 0 1 Mshowa
.6 .56653 m
.6 .57278 L
s
[(80)] .6 .55403 0 1 Mshowa
.8 .56653 m
.8 .57278 L
s
[(100)] .8 .55403 0 1 Mshowa
1 .56653 m
1 .57278 L
s
[(120)] 1 .55403 0 1 Mshowa
.125 Mabswid
.05 .56653 m
.05 .57028 L
s
.1 .56653 m
.1 .57028 L
s
.15 .56653 m
.15 .57028 L
s
.25 .56653 m
.25 .57028 L
s
.3 .56653 m
.3 .57028 L
s
.35 .56653 m
.35 .57028 L
s
.45 .56653 m
.45 .57028 L
s
.5 .56653 m
.5 .57028 L
s
.55 .56653 m
.55 .57028 L
s
.65 .56653 m
.65 .57028 L
s
.7 .56653 m
.7 .57028 L
s
.75 .56653 m
.75 .57028 L
s
.85 .56653 m
.85 .57028 L
s
.9 .56653 m
.9 .57028 L
s
.95 .56653 m
.95 .57028 L
s
.25 Mabswid
0 .56653 m
1 .56653 L
s
gsave
1.025 .56653 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .0515 m
.00625 .0515 L
s
[(-10)] -0.0125 .0515 1 0 Mshowa
0 .15451 m
.00625 .15451 L
s
[(-8)] -0.0125 .15451 1 0 Mshowa
0 .25751 m
.00625 .25751 L
s
[(-6)] -0.0125 .25751 1 0 Mshowa
0 .36052 m
.00625 .36052 L
s
[(-4)] -0.0125 .36052 1 0 Mshowa
0 .46353 m
.00625 .46353 L
s
[(-2)] -0.0125 .46353 1 0 Mshowa
.125 Mabswid
0 .07725 m
.00375 .07725 L
s
0 .10301 m
.00375 .10301 L
s
0 .12876 m
.00375 .12876 L
s
0 .18026 m
.00375 .18026 L
s
0 .20601 m
.00375 .20601 L
s
0 .23176 m
.00375 .23176 L
s
0 .28327 m
.00375 .28327 L
s
0 .30902 m
.00375 .30902 L
s
0 .33477 m
.00375 .33477 L
s
0 .38627 m
.00375 .38627 L
s
0 .41202 m
.00375 .41202 L
s
0 .43777 m
.00375 .43777 L
s
0 .48928 m
.00375 .48928 L
s
0 .51503 m
.00375 .51503 L
s
0 .54078 m
.00375 .54078 L
s
0 .02575 m
.00375 .02575 L
s
0 .59228 m
.00375 .59228 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(V) show
69.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .56653 m
.04948 .56653 L
.11328 .56653 L
.17469 .56653 L
.23997 .56653 L
.27267 .56653 L
.30286 .56653 L
.33223 .56653 L
.33936 .56653 L
.3433 .56653 L
.34704 .56653 L
.34806 .56653 L
.34915 .56653 L
.35034 .5648 L
.35144 .5591 L
.35547 .53837 L
.36336 .49772 L
.39482 .33569 L
.41137 .25046 L
.42885 .16042 L
.43641 .12147 L
.44452 .07972 L
.44691 .06742 L
.44809 .06136 L
.44917 .05576 L
.45121 .0515 L
.45228 .0515 L
.45342 .0515 L
.46172 .0515 L
.49196 .0515 L
.55141 .0515 L
.61473 .0515 L
.67567 .0515 L
.74046 .0515 L
.80287 .0515 L
.86289 .0515 L
.92678 .0515 L
.98827 .0515 L
s
.98827 .0515 m
1 .0515 L
s
.25 .25 1 r
.015 w
.04 .56653 Mdot
.04221 .56653 Mdot
.04444 .56653 Mdot
.04669 .56653 Mdot
.04896 .56653 Mdot
.05125 .56652 Mdot
.05356 .56652 Mdot
.0559 .56652 Mdot
.05825 .56652 Mdot
.06063 .56652 Mdot
.06303 .56651 Mdot
.06545 .56651 Mdot
.06789 .5665 Mdot
.07036 .5665 Mdot
.07285 .56649 Mdot
.07536 .56649 Mdot
.0779 .56648 Mdot
.08045 .56647 Mdot
.08304 .56646 Mdot
.08564 .56644 Mdot
.08827 .56643 Mdot
.09092 .56641 Mdot
.0936 .56638 Mdot
.0963 .56636 Mdot
.09903 .56633 Mdot
.10178 .56629 Mdot
.10456 .56625 Mdot
.10737 .56621 Mdot
.11019 .56615 Mdot
.11305 .56609 Mdot
.11593 .56602 Mdot
.11884 .56594 Mdot
.12177 .56585 Mdot
.12474 .56574 Mdot
.12773 .56562 Mdot
.13074 .56548 Mdot
.13379 .56533 Mdot
.13686 .56515 Mdot
.13996 .56495 Mdot
.14309 .56472 Mdot
.14625 .56447 Mdot
.14944 .56418 Mdot
.15265 .56385 Mdot
.1559 .56349 Mdot
.15917 .56308 Mdot
.16248 .56263 Mdot
.16582 .56212 Mdot
.16918 .56155 Mdot
.17258 .56093 Mdot
.17601 .56023 Mdot
.17947 .55946 Mdot
.18297 .5586 Mdot
.18649 .55766 Mdot
.19005 .55662 Mdot
.19364 .55548 Mdot
.19726 .55423 Mdot
.20092 .55286 Mdot
.20461 .55136 Mdot
.20833 .54973 Mdot
.21209 .54795 Mdot
.21589 .54601 Mdot
.21972 .54391 Mdot
.22358 .54163 Mdot
.22748 .53916 Mdot
.23141 .53651 Mdot
.23538 .53364 Mdot
.23939 .53056 Mdot
.24344 .52725 Mdot
.24752 .52371 Mdot
.25164 .51992 Mdot
.25579 .51587 Mdot
.25999 .51156 Mdot
.26422 .50697 Mdot
.2685 .5021 Mdot
.27281 .49694 Mdot
.27716 .49147 Mdot
.28155 .4857 Mdot
.28599 .47962 Mdot
.29046 .47322 Mdot
.29498 .4665 Mdot
.29953 .45945 Mdot
.30413 .45208 Mdot
.30877 .44437 Mdot
.31345 .43634 Mdot
.31818 .42798 Mdot
.32295 .41929 Mdot
.32776 .41027 Mdot
.33262 .40094 Mdot
.33752 .3913 Mdot
.34247 .38134 Mdot
.34747 .3711 Mdot
.35251 .36056 Mdot
.35759 .34976 Mdot
.36272 .33868 Mdot
.3679 .32736 Mdot
.37313 .3158 Mdot
.37841 .30403 Mdot
.38373 .29205 Mdot
.3891 .27989 Mdot
.39453 .26756 Mdot
.4 .25508 Mdot
.40552 .24248 Mdot
.4111 .22981 Mdot
.41672 .21716 Mdot
.4224 .20464 Mdot
.42813 .19235 Mdot
.43391 .18039 Mdot
.43975 .16884 Mdot
.44563 .15778 Mdot
.45158 .14728 Mdot
.45757 .13739 Mdot
.46363 .12816 Mdot
.46974 .11961 Mdot
.4759 .11176 Mdot
.48212 .10461 Mdot
.4884 .09814 Mdot
.49474 .09235 Mdot
.50113 .0872 Mdot
.50759 .08266 Mdot
.5141 .07868 Mdot
.52067 .07522 Mdot
.52731 .07225 Mdot
.534 .0697 Mdot
.54076 .06754 Mdot
.54758 .06571 Mdot
.55446 .06419 Mdot
.5614 .06292 Mdot
.56841 .06187 Mdot
.57549 .06101 Mdot
.58263 .06031 Mdot
.58983 .05975 Mdot
.5971 .05929 Mdot
.60444 .05893 Mdot
.61184 .05864 Mdot
.61931 .05841 Mdot
.62686 .05824 Mdot
.63447 .0581 Mdot
.64215 .05799 Mdot
.6499 .0579 Mdot
.65772 .05784 Mdot
.66562 .05779 Mdot
.67359 .05775 Mdot
.68163 .05773 Mdot
.68974 .05771 Mdot
.69793 .05769 Mdot
.7062 .05768 Mdot
.71454 .05767 Mdot
.72296 .05766 Mdot
.73146 .05766 Mdot
.74003 .05766 Mdot
.74868 .05765 Mdot
.75742 .05765 Mdot
.76623 .05765 Mdot
.77512 .05765 Mdot
.7841 .05765 Mdot
.79316 .05765 Mdot
.8023 .05765 Mdot
.81153 .05765 Mdot
.82084 .05765 Mdot
.83023 .05765 Mdot
.83972 .05765 Mdot
.84929 .05765 Mdot
.85895 .05765 Mdot
.86869 .05765 Mdot
.87853 .05765 Mdot
.88846 .05765 Mdot
.89848 .05765 Mdot
.90859 .05765 Mdot
.91879 .05765 Mdot
.92909 .05765 Mdot
.93949 .05765 Mdot
.94998 .05765 Mdot
.96056 .05765 Mdot
.97124 .05765 Mdot
.98203 .05765 Mdot
.99291 .05765 Mdot
0 1 0 r
.5 Mabswid
0 .56653 m
.00082 .56653 L
.00263 .56653 L
.00457 .56653 L
.00663 .56653 L
.0078 .56653 L
.00888 .56653 L
.01086 .56653 L
.01196 .56653 L
.01296 .56653 L
.01486 .56653 L
.01691 .56653 L
.01885 .56653 L
.02063 .56653 L
.02231 .56653 L
.02411 .56653 L
.0258 .56653 L
.02735 .56653 L
.02916 .56653 L
.03113 .56653 L
.03299 .56653 L
.03471 .56653 L
.03648 .56653 L
.03814 .56653 L
.03996 .56653 L
.04191 .56653 L
.04386 .56653 L
.04591 .56653 L
.04765 .56653 L
.04956 .56653 L
.05165 .56653 L
.05357 .56653 L
.05568 .56653 L
.05791 .56653 L
.05985 .56653 L
.06166 .56653 L
.06378 .56653 L
.06578 .56653 L
.06756 .56653 L
.0695 .56653 L
.07289 .56653 L
.0748 .56653 L
.07684 .56653 L
.08051 .56653 L
.08254 .56653 L
.0844 .56653 L
.0864 .56653 L
.0886 .56653 L
.0923 .56653 L
.0962 .56653 L
Mistroke
.10053 .56652 L
.10296 .56652 L
.10517 .56652 L
.10947 .56651 L
.11353 .56651 L
.11728 .5665 L
.1208 .56649 L
.12466 .56648 L
.12881 .56646 L
.13315 .56643 L
.13727 .5664 L
.14097 .56637 L
.14501 .56632 L
.1523 .56619 L
.15638 .5661 L
.16008 .566 L
.16728 .56574 L
.17406 .56541 L
.1814 .56492 L
.18945 .56418 L
.19786 .56313 L
.20571 .56182 L
.21306 .56026 L
.21975 .55849 L
.23481 .5531 L
.24239 .54951 L
.25044 .54496 L
.26489 .53466 L
.28044 .52023 L
.2976 .50005 L
.32809 .45352 L
.36095 .39155 L
.42577 .26065 L
.45813 .20414 L
.48821 .16125 L
.51726 .12915 L
.54827 .10407 L
.56441 .09421 L
.58191 .0856 L
.59703 .07964 L
.61366 .07441 L
.62984 .07041 L
.64498 .06748 L
.66097 .06507 L
.67813 .06309 L
.69411 .0617 L
.71151 .06057 L
.72794 .05978 L
.74318 .05924 L
.75988 .05879 L
Mistroke
.77559 .05848 L
.78969 .05828 L
.80492 .05811 L
.81994 .05798 L
.83641 .05789 L
.8536 .05781 L
.86961 .05777 L
.88613 .05773 L
.90175 .05771 L
.91578 .05769 L
.93101 .05768 L
.94587 .05767 L
.96224 .05766 L
.97047 .05766 L
.97933 .05766 L
.98764 .05766 L
.99535 .05765 L
Mfstroke
.99535 .05765 m
1 .05765 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{435.188, 268.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006c000132000`400?l00000o`00003o5P3oool0
0`000000oooo0?ooo`3o0?oooi/0oooo000F0?ooo`030000003oool0oooo0?l0ooooV`3oool001H0
oooo00<000000?ooo`3oool0o`3ooonK0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooi/0oooo
000F0?ooo`030000003oool0oooo0?l0ooooV`3oool001H0oooo00<000000?ooo`3oool0o`3ooonK
0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooi/0oooo000F0?ooo`030000003oool0oooo0?l0
ooooV`3oool001H0oooo00<000000?ooo`3oool0o`3ooonK0?ooo`005P3oool00`000000oooo0?oo
o`3o0?oooi/0oooo000F0?ooo`80000000=000000?ooo`3oool0o`3ooonI0?ooo`005P3oool00`00
0000oooo0?ooo`3o0?oooi/0oooo000F0?ooo`030000003oool0oooo0?l0ooooV`3oool001H0oooo
00<000000?ooo`3oool0o`3ooonK0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooi/0oooo000F
0?ooo`030000003oool0oooo0?l0ooooV`3oool001H0oooo00<000000?ooo`3oool0o`3ooonK0?oo
o`005P3oool00`000000oooo0?ooo`3o0?oooi/0oooo00080?ooo`E000000P3oool00d000000oooo
0?ooo`040?ooo`030000003oool0oooo0?l0ooooV`3oool000X0oooo00M000000?ooo`3oool0oooo
@000003ooom0000000D0oooo00<000000?ooo`3oool0o`3ooonK0?ooo`00103oool3@00000<0oooo
00M000000?ooo`3oool0oooo@000003ooom0000000D0oooo0`0000000d000000oooo0?ooo`2[0?oo
omL0000000=000000?ooo`3oool04P3oool000X0oooo00M000000?ooo`3oool0oooo@000003ooom0
000000D0oooo00<000000?ooo`3oool0[@3oool00`000000oooo0?ooo`3Z0?ooo`002P3oool01d00
0000oooo0?ooo`3ooom000000?oood0000001@3oool00`000000oooo0?ooo`2]0?ooo`030000003o
ool0oooo03/0ooooU00o?ol00`3oool0?coo03loo`0203looaH0oooo00090?ooo`900000103oool0
0d000000oooo0?ooo`040?ooo`030000003oool0oooo0:d0oooo00<000000?ooo`3oool0;03ooom2
03loofP00?l0503oool001H0oooo00<000000?ooo`3oool0[@3oool00`000000oooo0?ooo`0W0?oo
oc@0?coo4`00o`1Q03loo`030?ooo`0o?ol0?coo0080?coo5P3oool001H0oooo00<000000?ooo`3o
ool0[@3oool00`000000oooo0?ooo`0Q0?oooal0?coo00@0oooo03loo`0o?ol0oooo0P0o?ol0103o
ool0?coo03loo`3oool203loo`80oooo0P0o?ol0103oool0?coo03loo`3oool7003o000403loo`3o
ool0?coo03loo`80oooo0P0o?ol0103oool0?coo03loo`3oool203loo`030?ooo`0o?ol0?coo0080
oooo0P0o?ol00`3oool0?coo03loo`020?ooo`80?coo00@0oooo03loo`0o?ol0oooo0P0o?ol20?oo
o`80?coo0P3oool203loo`030?ooo`0o?ol0?coo0080oooo0P0o?ol00`3oool0?coo03loo`020?oo
o`80?coo0P3oool203loo`80oooo0P0o?ol00`3oool0?coo03loo`020?ooo`80?coo0P3oool203lo
o`80oooo0P0o?ol20?ooo`80?coo0P3oool203loo`80oooo0P0o?ol20?ooo`80?coo0P3oool203lo
o`80oooo0P0o?ol20?ooo`80?coo0P3oool203loo`80oooo0P0o?ol30?ooo`80?coo5`3oool001H0
oooo00<000000?ooo`3oool0[03oool00`000000oooo0?ooo`0P0?oooa00?coo00@0oooo03loo`0o
?ol0oooo0P0o?ol0103oool0?coo03loo`3oool203looa<0oooo1P00o`2F0?ooo`005P3oool00`00
0000oooo0?ooo`2/0?ooo`030000003oool0oooo01d0oooo3P0o?ol00`3oool0?coo03loo`0K0?oo
o`H00?l0W03oool001H0oooo00<000000?ooo`3oool0[03oool00`000000oooo0?ooo`0J0?ooo`/0
?coo00<0oooo03loo`0o?ol06`3oool6003o0:80oooo000F0?ooo`030000003oool0oooo0:/0oooo
00<000000?ooo`3oool06@3oool;03looa/0oooo1@00o`2X0?ooo`005P3oool200000003@000003o
ool0oooo0:T0oooo00<000000?ooo`3oool05P3oool;03looaX0oooo1000o`2]0?ooo`005P3oool0
0`000000oooo0?ooo`2[0?ooo`030000003oool0oooo01H0oooo200o?olK0?ooo`800?l0/@3oool0
01H0oooo00<000000?ooo`3oool0Z`3oool00`000000oooo0?ooo`0D0?ooo`P0?coo6`3oool2003o
0;<0oooo000F0?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`3oool0503oool503looa`0
oooo0P00o`2e0?ooo`005P3oool00`000000oooo0?ooo`2Z0?ooo`030000003oool0oooo0180oooo
1`0o?olJ0?ooo`<00?l0]`3oool001H0oooo00<000000?ooo`3oool0ZP3oool00`000000oooo0?oo
o`0B0?ooo`H0?coo6@3oool2003o0;X0oooo000F0?ooo`030000003oool0oooo0:X0oooo00<00000
0?ooo`3oool0403oool603looaT0oooo0P00o`2l0?ooo`005P3oool00`000000oooo0?ooo`2Z0?oo
o`030000003oool0oooo0100oooo1@0o?olH0?ooo`800?l0_P3oool001H0oooo00<000000?ooo`3o
ool0ZP3oool00`000000oooo0?ooo`0=0?ooo`L0?coo5`3oool2003o0<00oooo000F0?ooo`030000
003oool0oooo0:X0oooo00<000000?ooo`3oool03@3oool603looaL0oooo00<00?l00?ooo`3oool0
`03oool001H0oooo0P0000000d000000oooo0?ooo`2W0?ooo`030000003oool0oooo00`0oooo1P0o
?olG0?ooo`800?l0``3oool001H0oooo00<000000?ooo`3oool0Z@3oool00`000000oooo0?ooo`0<
0?ooo`D0?coo5`3oool00`00o`00oooo0?ooo`330?ooo`005P3oool00`000000oooo0?ooo`2Y0?oo
o`030000003oool0oooo00`0oooo100o?olG0?ooo`03003o003oool0oooo0<@0oooo000F0?ooo`03
0000003oool0oooo0:T0oooo00<000000?ooo`3oool02@3oool603looaL0oooo00<00?l00?ooo`3o
ool0a@3oool001H0oooo00<000000?ooo`3oool0Z@3oool00`000000oooo0?ooo`090?ooo`@0?coo
5`3oool2003o0<P0oooo000F0?ooo`030000003oool0oooo0:T0oooo00<000000?ooo`3oool02@3o
ool403looaH0oooo00<00?l00?ooo`3oool0b03oool001H0oooo00<000000?ooo`3oool0Z03oool0
0`000000oooo0?ooo`080?ooo`D0?coo5P3oool00`00o`00oooo0?ooo`390?ooo`005P3oool00`00
0000oooo0?ooo`2X0?ooo`030000003oool0oooo00P0oooo100o?olF0?ooo`03003o003oool0oooo
0<X0oooo000F0?ooo`030000003oool0oooo0:P0oooo00<000000?ooo`3oool0203oool403looaD0
oooo00<00?l00?ooo`3oool0b`3oool001H0oooo00<000000?ooo`3oool0Z03oool00`000000oooo
0?ooo`090?ooo`80?coo503oool2003o0<h0oooo000F0?ooo`030000003oool0oooo0:P0oooo00<0
00000?ooo`3oool01P3oool403looa@0oooo00<00?l00?ooo`3oool0cP3oool001H0oooo0P000000
0d000000oooo0?ooo`2U0?ooo`030000003oool0oooo00L0oooo100o?olC0?ooo`03003o003oool0
oooo0<l0oooo000F0?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool01`3oool403lo
oa80oooo00<00?l00?ooo`3oool0d03oool001H0oooo00<000000?ooo`3oool0Y`3oool00`000000
oooo0?ooo`040?ooo`H0?coo4P3oool00`00o`00oooo0?ooo`3A0?ooo`005P3oool00`000000oooo
0?ooo`2W0?ooo`030000003oool0oooo00@0oooo100o?olC0?ooo`03003o003oool0oooo0=80oooo
000F0?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool0103oool403looa80oooo00<0
0?l00?ooo`3oool0d`3oool001H0oooo00<000000?ooo`3oool0YP3oool00`000000oooo0?ooo`06
0?ooo`80?coo4P3oool00`00o`00oooo0?ooo`3D0?ooo`005P3oool00`000000oooo0?ooo`2V0?oo
o`030000003oool0oooo00<0oooo100o?olB0?ooo`03003o003oool0oooo0=D0oooo000F0?ooo`03
0000003oool0oooo0:H0oooo00<000000?ooo`3oool00`3oool403looa80oooo00<00?l00?ooo`3o
ool0e@3oool000l0oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`2V0?ooo`030000
003oool0oooo00<0oooo100o?olA0?ooo`03003o003oool0oooo0=H0oooo000>0?ooo`03@000003o
oom0000000D0oooo00<000000?ooo`3oool0YP3oool00`000000oooo0?ooo`040?ooo`80?coo4@3o
ool00`00o`00oooo0?ooo`3G0?ooo`002@3oool3@0000080oooo00=000000?oood0000001@3oool3
00000003@000003oool0oooo0:80oooo00@000000?ooo`3oool0oooo100o?olB0?ooo`03003o003o
ool0oooo0=P0oooo000?0?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0Y@3oool0
10000000oooo0?ooo`3oool403looa40oooo00<00?l00?ooo`3oool0f@3oool000h0oooo00=00000
0?oood0000001@3oool00`000000oooo0?ooo`2U0?ooo`040000003oool0oooo0?ooo`@0?coo403o
ool00`00o`00oooo0?ooo`3J0?ooo`003`3oool00d000000oooo0?ooo`040?ooo`030000003oool0
oooo0:D0oooo00<000000?ooo`3oool00P3oool203looa00oooo00<00?l00?ooo`3oool0f`3oool0
01H0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?ooo`0D0?ooo`03003o003oool0oooo
0=/0oooo000F0?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3oool0100o?ol@0?ooo`03
003o003oool0oooo0=`0oooo000F0?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3oool0
100o?ol?0?ooo`03003o003oool0oooo0=d0oooo000F0?ooo`030000003oool0oooo0:@0oooo00<0
00000?ooo`3oool0100o?ol>0?ooo`03003o003oool0oooo0=h0oooo000F0?ooo`030000003oool0
oooo0:@0oooo00@000000?ooo`3oool0oooo0P0o?ol?0?ooo`03003o003oool0oooo0=h0oooo000F
0?ooo`030000003oool0oooo0:@0oooo00<0000003loo`0o?ol00P0o?ol?0?ooo`03003o003oool0
oooo0=l0oooo000F0?ooo`80000000=000000?ooo`3oool0X@3oool00`000000oooo03loo`0303lo
o`h0oooo00<00?l00?ooo`3oool0h03oool001H0oooo00<000000?ooo`3oool0X`3oool00`000000
oooo03loo`0303loo`h0oooo00<00?l00?ooo`3oool0h03oool001H0oooo00<000000?ooo`3oool0
X`3oool00`000000oooo0?ooo`0203loo`h0oooo00<00?l00?ooo`3oool0h@3oool001H0oooo00<0
00000?ooo`3oool0X`3oool00`000000oooo0?ooo`0?0?ooo`03003o003oool0oooo0>80oooo000F
0?ooo`030000003oool0oooo0:<0oooo100o?ol>0?ooo`03003o003oool0oooo0>80oooo000F0?oo
o`030000003oool0oooo0:80oooo00<0000003loo`0o?ol00P0o?ol=0?ooo`03003o003oool0oooo
0><0oooo000F0?ooo`030000003oool0oooo0:80oooo00<0000003loo`0o?ol00P0o?ol<0?ooo`03
003o003oool0oooo0>@0oooo000F0?ooo`030000003oool0oooo0:80oooo00@000000?ooo`0o?ol0
?coo303oool00`00o`00oooo0?ooo`3U0?ooo`005P3oool00`000000oooo0?ooo`2R0?ooo`030000
003oool0oooo00d0oooo00<00?l00?ooo`3oool0i@3oool001H0oooo00<000000?ooo`3oool0X03o
ool403loo`d0oooo00<00?l00?ooo`3oool0iP3oool001H0oooo0P0000000d000000oooo0?ooo`2N
0?ooo`@0?coo303oool00`00o`00oooo0?ooo`3W0?ooo`005P3oool00`000000oooo0?ooo`2P0?oo
o`@0?coo303oool00`00o`00oooo0?ooo`3W0?ooo`005P3oool00`000000oooo0?ooo`2Q0?ooo`80
?coo303oool00`00o`00oooo0?ooo`3X0?ooo`005P3oool00`000000oooo0?ooo`2Q0?ooo`030000
003oool0oooo00/0oooo00<00?l00?ooo`3oool0j03oool001H0oooo00<000000?ooo`3oool0WP3o
ool403loo``0oooo00<00?l00?ooo`3oool0j@3oool001H0oooo00<000000?ooo`3oool0WP3oool4
03loo`/0oooo00<00?l00?ooo`3oool0jP3oool001H0oooo00<000000?ooo`3oool0WP3oool403lo
o`/0oooo00<00?l00?ooo`3oool0jP3oool001H0oooo00<000000?ooo`3oool0W`3oool203loo`/0
oooo00<00?l00?ooo`3oool0j`3oool001H0oooo00<000000?ooo`3oool0X03oool00`000000oooo
0?ooo`090?ooo`03003o003oool0oooo0>/0oooo000F0?ooo`030000003oool0oooo09`0oooo100o
?ol00`000000oooo0?ooo`080?ooo`03003o003oool0oooo0>`0oooo000F0?ooo`80000000=00000
0?ooo`3oool0VP3oool403loo`X0oooo00<00?l00?ooo`3oool0k@3oool001H0oooo00<000000?oo
o`3oool0W03oool403loo`X0oooo00<00?l00?ooo`3oool0k@3oool001H0oooo00<000000?ooo`3o
ool0W@3oool203loo`030000003oool0oooo00L0oooo00<00?l00?ooo`3oool0kP3oool001H0oooo
00<000000?ooo`3oool0VP3oool403loo`030?ooo`000000oooo00P0oooo00<00?l00?ooo`3oool0
kP3oool001H0oooo00<000000?ooo`3oool0VP3oool403loo`030?ooo`000000oooo00L0oooo00<0
0?l00?ooo`3oool0k`3oool001H0oooo00<000000?ooo`3oool0VP3oool403loo`030000003oool0
oooo00L0oooo00<00?l00?ooo`3oool0k`3oool001H0oooo00<000000?ooo`3oool0V`3oool203lo
o`030?ooo`000000oooo00L0oooo00<00?l00?ooo`3oool0l03oool001H0oooo00<000000?ooo`3o
ool0WP3oool00`000000oooo0?ooo`050?ooo`03003o003oool0oooo0?40oooo000>0?ooo`900000
1P3oool00`000000oooo0?ooo`2H0?ooo`@0?coo0P3oool00`000000oooo0?ooo`050?ooo`03003o
003oool0oooo0?40oooo000>0?ooo`03@000003ooom0000000D0oooo00<000000?ooo`3oool0V03o
ool403loo`80oooo00<000000?ooo`3oool0103oool00`00o`00oooo0?ooo`3b0?ooo`002@3oool3
@0000080oooo00=000000?oood0000001@3oool300000003@000003oool0oooo09D0oooo100o?ol0
0`3oool000000?ooo`060?ooo`03003o003oool0oooo0?80oooo000>0?ooo`9000001P3oool00`00
0000oooo0?ooo`2I0?ooo`80?coo0P3oool00`000000oooo0?ooo`040?ooo`03003o003oool0oooo
0?<0oooo000>0?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool0W@3oool00`000000
oooo0?ooo`040?ooo`03003o003oool0oooo0?<0oooo000?0?ooo`9000001@3oool00`000000oooo
0?ooo`2E0?ooo`@0?coo103oool00`000000oooo0?ooo`030?ooo`03003o003oool0oooo0?@0oooo
000F0?ooo`030000003oool0oooo09D0oooo100o?ol40?ooo`030000003oool0oooo00<0oooo00<0
0?l00?ooo`3oool0m03oool001H0oooo00<000000?ooo`3oool0U@3oool403loo`@0oooo00<00000
0?ooo`3oool00P3oool00`00o`00oooo0?ooo`3e0?ooo`005P3oool00`000000oooo0?ooo`2F0?oo
o`80?coo103oool00`000000oooo0?ooo`030?ooo`03003o003oool0oooo0?D0oooo000F0?ooo`03
0000003oool0oooo09`0oooo00<000000?ooo`3oool00P3oool00`00o`00oooo0?ooo`3f0?ooo`00
5P3oool00`000000oooo0?ooo`2C0?ooo`@0?coo1@3oool00`000000oooo0?ooo`020?ooo`03003o
003oool0oooo0?H0oooo000F0?ooo`030000003oool0oooo09<0oooo100o?ol50?ooo`050000003o
ool0oooo0?ooo`00o`00n@3oool001H0oooo0P0000000d000000oooo0?ooo`2A0?ooo`@0?coo1@3o
ool01@000000oooo0?ooo`3oool00?l00?T0oooo000F0?ooo`030000003oool0oooo09@0oooo0P0o
?ol60?ooo`040000003oool0oooo003o0?X0oooo000F0?ooo`030000003oool0oooo09/0oooo00D0
00000?ooo`3oool0oooo003o003j0?ooo`005P3oool00`000000oooo0?ooo`2A0?ooo`@0?coo1P3o
ool010000000oooo0?ooo`00o`3k0?ooo`005P3oool00`000000oooo0?ooo`2A0?ooo`@0?coo1P3o
ool010000000oooo0?ooo`00o`3k0?ooo`005P3oool00`000000oooo0?ooo`2A0?ooo`@0?coo1P3o
ool00`000000oooo003o003l0?ooo`005P3oool00`000000oooo0?ooo`2B0?ooo`80?coo1`3oool0
0`000000oooo003o003l0?ooo`005P3oool00`000000oooo0?ooo`2J0?ooo`030000003oool00?l0
0?d0oooo000F0?ooo`030000003oool0oooo08l0oooo100o?ol70?ooo`030000003oool00?l00?d0
oooo000F0?ooo`030000003oool0oooo08l0oooo100o?ol70?ooo`0300000000o`00oooo0?d0oooo
000F0?ooo`80000000=000000?ooo`3oool0S@3oool403loo`L0oooo00<00000003o003oool0o@3o
ool001H0oooo00<000000?ooo`3oool0T03oool203loo`P0oooo00<00?l00?ooo`3oool0o@3oool0
01H0oooo00<000000?ooo`3oool0S@3oool403loo`T0oooo00<00?l00?ooo`3oool0o@3oool001H0
oooo00<000000?ooo`3oool0S@3oool403loo`P0oooo00<00?l00?ooo`3oool0oP3oool001H0oooo
00<000000?ooo`3oool0S@3oool403loo`P0oooo00<00?l00?ooo`3oool0oP3oool001H0oooo00<0
00000?ooo`3oool0SP3oool203loo`P0oooo00<00?l00000003oool0o`3oool001H0oooo00<00000
0?ooo`3oool0V03oool00`00o`0000000?ooo`3o0?ooo`005P3oool00`000000oooo0?ooo`2;0?oo
o`@0?coo203oool00`00o`00oooo0000003o0?ooo`40oooo000F0?ooo`030000003oool0oooo08/0
oooo100o?ol80?ooo`03003o003oool000000?l0oooo0@3oool001H0oooo00<000000?ooo`3oool0
R`3oool403loo`L0oooo00<00?l00?ooo`000000o`3oool20?ooo`005P3oool200000003@000003o
ool0oooo08X0oooo0P0o?ol80?ooo`03003o003oool000000?l0oooo0P3oool001H0oooo00<00000
0?ooo`3oool0R@3oool403loo`P0oooo00@00?l00?ooo`3oool00000o`3oool20?ooo`005P3oool0
0`000000oooo0?ooo`290?ooo`@0?coo203oool01000o`00oooo0?ooo`00003o0?ooo`80oooo000F
0?ooo`030000003oool0oooo08T0oooo100o?ol70?ooo`05003o003oool0oooo0?ooo`000000o`3o
ool20?ooo`005P3oool00`000000oooo0?ooo`2:0?ooo`80?coo203oool01000o`00oooo0?ooo`00
003o0?ooo`<0oooo000F0?ooo`030000003oool0oooo08L0oooo100o?ol80?ooo`05003o003oool0
oooo0?ooo`000000o`3oool30?ooo`005P3oool00`000000oooo0?ooo`270?ooo`@0?coo203oool0
1@00o`00oooo0?ooo`3oool000000?l0oooo0`3oool001H0oooo00<000000?ooo`3oool0Q`3oool4
03loo`L0oooo00<00?l00?ooo`3oool00P3oool00`000000oooo0?ooo`3o0?ooo`40oooo000?0?oo
o`=00000103oool00`000000oooo0?ooo`280?ooo`80?coo203oool00`00o`00oooo0?ooo`020?oo
o`030000003oool0oooo0?l0oooo0@3oool00100oooo00=000000?ooo`3oool00`3oool00`000000
oooo0?ooo`2A0?ooo`03003o003oool0oooo0080oooo00<000000?ooo`3oool0o`3oool20?ooo`00
2@3oool3@0000080oooo140000040?ooo`<0000000=000000?ooo`3oool0PP3oool403loo`P0oooo
00<00?l00?ooo`3oool00P3oool00`000000oooo0?ooo`3o0?ooo`80oooo000>0?ooo`03@000003o
oom0000000D0oooo00<000000?ooo`3oool0Q@3oool403loo`L0oooo00<00?l00?ooo`3oool00`3o
ool00`000000oooo0?ooo`3o0?ooo`80oooo000?0?ooo`9000001@3oool00`000000oooo0?ooo`25
0?ooo`@0?coo1`3oool00`00o`00oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo0P3oool0
0100oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`260?ooo`80?coo1`3oool00`00
o`00oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo0P3oool001H0oooo00<000000?ooo`3o
ool0P`3oool403loo`P0oooo00<00?l00?ooo`3oool0103oool00`000000oooo0?ooo`3o0?ooo`80
oooo000F0?ooo`030000003oool0oooo08<0oooo100o?ol70?ooo`03003o003oool0oooo00@0oooo
00<000000?ooo`3oool0o`3oool30?ooo`005P3oool00`000000oooo0?ooo`230?ooo`@0?coo1`3o
ool00`00o`00oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo0`3oool001H0oooo00<00000
0?ooo`3oool0Q03oool203loo`L0oooo00<00?l00?ooo`3oool01@3oool00`000000oooo0?ooo`3o
0?ooo`<0oooo000F0?ooo`030000003oool0oooo0840oooo100o?ol80?ooo`03003o003oool0oooo
00D0oooo00<000000?ooo`3oool0o`3oool30?ooo`005P3oool00`000000oooo0?ooo`210?ooo`@0
?coo1`3oool00`00o`00oooo0?ooo`060?ooo`030000003oool0oooo0?l0oooo0`3oool001H0oooo
0P0000000d000000oooo0?ooo`1o0?ooo`@0?coo1`3oool00`00o`00oooo0?ooo`050?ooo`030000
003oool0oooo0?l0oooo103oool001H0oooo00<000000?ooo`3oool0PP3oool203loo`L0oooo00<0
0?l00?ooo`3oool01P3oool00`000000oooo0?ooo`3o0?ooo`@0oooo000F0?ooo`030000003oool0
oooo07l0oooo100o?ol80?ooo`03003o003oool0oooo00H0oooo00<000000?ooo`3oool0o`3oool4
0?ooo`005P3oool00`000000oooo0?ooo`1o0?ooo`@0?coo1`3oool00`00o`00oooo0?ooo`070?oo
o`030000003oool0oooo0?l0oooo103oool001H0oooo00<000000?ooo`3oool0O`3oool403loo`L0
oooo00<00?l00?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?ooo`@0oooo000F0?ooo`030000
003oool0oooo07d0oooo1@0o?ol70?ooo`03003o003oool0oooo00L0oooo00<000000?ooo`3oool0
o`3oool50?ooo`005P3oool00`000000oooo0?ooo`1m0?ooo`@0?coo203oool00`00o`00oooo0?oo
o`070?ooo`030000003oool0oooo0?l0oooo1@3oool001H0oooo00<000000?ooo`3oool0O@3oool4
03loo`L0oooo00<00?l00?ooo`3oool0203oool00`000000oooo0?ooo`3o0?ooo`D0oooo000F0?oo
o`030000003oool0oooo07h0oooo0P0o?ol80?ooo`03003o003oool0oooo00P0oooo00<000000?oo
o`3oool0o`3oool50?ooo`005P3oool00`000000oooo0?ooo`1k0?ooo`@0?coo203oool00`00o`00
oooo0?ooo`090?ooo`030000003oool0oooo0?l0oooo1@3oool001H0oooo0P0000000d000000oooo
0?ooo`1i0?ooo`@0?coo203oool00`00o`00oooo0?ooo`080?ooo`030000003oool0oooo0?l0oooo
1P3oool001H0oooo00<000000?ooo`3oool0N`3oool403loo`L0oooo00<00?l00?ooo`3oool02@3o
ool00`000000oooo0?ooo`3o0?ooo`H0oooo000F0?ooo`030000003oool0oooo07`0oooo0P0o?ol8
0?ooo`03003o003oool0oooo00T0oooo00<000000?ooo`3oool0o`3oool60?ooo`005P3oool00`00
0000oooo0?ooo`1i0?ooo`@0?coo203oool00`00o`00oooo0?ooo`0:0?ooo`030000003oool0oooo
0?l0oooo1P3oool001H0oooo00<000000?ooo`3oool0N@3oool403loo`P0oooo00<00?l00?ooo`3o
ool02P3oool00`000000oooo0?ooo`3o0?ooo`H0oooo000F0?ooo`030000003oool0oooo07T0oooo
100o?ol70?ooo`03003o003oool0oooo00/0oooo00<000000?ooo`3oool0o`3oool60?ooo`005P3o
ool00`000000oooo0?ooo`1h0?ooo`@0?coo203oool00`00o`00oooo0?ooo`0:0?ooo`030000003o
ool0oooo0?l0oooo1`3oool001H0oooo00<000000?ooo`3oool0N03oool403loo`L0oooo00<00?l0
0?ooo`3oool02`3oool00`000000oooo0?ooo`3o0?ooo`L0oooo000F0?ooo`030000003oool0oooo
07P0oooo100o?ol70?ooo`03003o003oool0oooo00/0oooo00<000000?ooo`3oool0o`3oool70?oo
o`005P3oool00`000000oooo0?ooo`1f0?ooo`D0?coo1`3oool00`00o`00oooo0?ooo`0<0?ooo`03
0000003oool0oooo0?l0oooo1`3oool001H0oooo00<000000?ooo`3oool0MP3oool403loo`P0oooo
00<00?l00?ooo`3oool0303oool00`000000oooo0?ooo`3o0?ooo`L0oooo000F0?ooo`80000000=0
00000?ooo`3oool0M03oool403loo`L0oooo00<00?l00?ooo`3oool0303oool00`000000oooo0?oo
o`3o0?ooo`P0oooo000F0?ooo`030000003oool0oooo07L0oooo0P0o?ol80?ooo`03003o003oool0
oooo00`0oooo00<000000?ooo`3oool0o`3oool80?ooo`005P3oool00`000000oooo0?ooo`1d0?oo
o`@0?coo203oool00`00o`00oooo0?ooo`0=0?ooo`030000003oool0oooo0?l0oooo203oool001H0
oooo00<000000?ooo`3oool0M03oool403loo`P0oooo00<00?l00?ooo`3oool03@3oool00`000000
oooo0?ooo`3o0?ooo`P0oooo000F0?ooo`030000003oool0oooo07@0oooo100o?ol70?ooo`03003o
003oool0oooo00h0oooo00<000000?ooo`3oool0o`3oool80?ooo`005P3oool00`000000oooo0?oo
o`1b0?ooo`D0?coo203oool00`00o`00oooo0?ooo`0=0?ooo`030000003oool0oooo0?l0oooo2@3o
ool001H0oooo00<000000?ooo`3oool0LP3oool403loo`P0oooo00<00?l00?ooo`3oool03P3oool0
0`000000oooo0?ooo`3o0?ooo`T0oooo000F0?ooo`030000003oool0oooo0700oooo1P0o?ol70?oo
o`03003o003oool0oooo00l0oooo00<000000?ooo`3oool0o`3oool90?ooo`003P3oool3@00000D0
oooo00<000000?ooo`3oool0L03oool503loo`P0oooo00<00?l00?ooo`3oool03`3oool00`000000
oooo0?ooo`3o0?ooo`T0oooo000>0?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool0
L03oool403loo`P0oooo00<00?l00?ooo`3oool0403oool00`000000oooo0?ooo`3o0?ooo`T0oooo
00090?ooo`=000000`3oool00d000000oooo0?ooo`040?ooo`<0000000=000000?ooo`3oool0K03o
ool403loo`P0oooo00<00?l00?ooo`3oool0403oool00`000000oooo0?ooo`3o0?ooo`X0oooo000?
0?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0K`3oool403loo`P0oooo00<00?l0
0?ooo`3oool0403oool00`000000oooo0?ooo`3o0?ooo`X0oooo000>0?ooo`03@000003ooom00000
00D0oooo00<000000?ooo`3oool0K`3oool403loo`L0oooo00<00?l00?ooo`3oool04@3oool00`00
0000oooo0?ooo`3o0?ooo`X0oooo000?0?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3o
ool0K@3oool503loo`L0oooo00<00?l00?ooo`3oool04P3oool00`000000oooo0?ooo`3o0?ooo`X0
oooo000F0?ooo`030000003oool0oooo06d0oooo100o?ol80?ooo`03003o003oool0oooo0180oooo
00<000000?ooo`3oool0o`3oool:0?ooo`005P3oool00`000000oooo0?ooo`1[0?ooo`H0?coo1`3o
ool00`00o`00oooo0?ooo`0C0?ooo`030000003oool0oooo0?l0oooo2P3oool001H0oooo00<00000
0?ooo`3oool0J`3oool503loo`L0oooo00<00?l00?ooo`3oool04`3oool00`000000oooo0?ooo`3o
0?ooo`/0oooo000F0?ooo`030000003oool0oooo06/0oooo100o?ol80?ooo`03003o003oool0oooo
01<0oooo00<000000?ooo`3oool0o`3oool;0?ooo`005P3oool00`000000oooo0?ooo`1Y0?ooo`D0
?coo203oool00`00o`00oooo0?ooo`0D0?ooo`030000003oool0oooo0?l0oooo2`3oool001H0oooo
00<000000?ooo`3oool0J@3oool403loo`P0oooo00<00?l00?ooo`3oool05@3oool00`000000oooo
0?ooo`3o0?ooo`/0oooo000F0?ooo`80000000=000000?ooo`3oool0IP3oool503loo`P0oooo00<0
0?l00?ooo`3oool05@3oool00`000000oooo0?ooo`3o0?ooo`/0oooo000F0?ooo`030000003oool0
oooo06P0oooo100o?ol80?ooo`03003o003oool0oooo01D0oooo00<000000?ooo`3oool0o`3oool<
0?ooo`005P3oool00`000000oooo0?ooo`1V0?ooo`H0?coo1`3oool00`00o`00oooo0?ooo`0F0?oo
o`030000003oool0oooo0?l0oooo303oool001H0oooo00<000000?ooo`3oool0IP3oool503loo`P0
oooo00<00?l00?ooo`3oool05P3oool00`000000oooo0?ooo`3o0?ooo``0oooo000F0?ooo`030000
003oool0oooo06@0oooo1P0o?ol80?ooo`03003o003oool0oooo01L0oooo00<000000?ooo`3oool0
o`3oool<0?ooo`005P3oool00`000000oooo0?ooo`1T0?ooo`D0?coo203oool00`00o`00oooo0?oo
o`0H0?ooo`030000003oool0oooo0?l0oooo303oool001H0oooo00<000000?ooo`3oool0HP3oool6
03loo`P0oooo00<00?l00?ooo`3oool0603oool00`000000oooo0?ooo`3o0?ooo`d0oooo000F0?oo
o`030000003oool0oooo0680oooo1@0o?ol80?ooo`03003o003oool0oooo01T0oooo00<000000?oo
o`3oool0o`3oool=0?ooo`005P3oool00`000000oooo0?ooo`1Q0?ooo`D0?coo203oool00`00o`00
oooo0?ooo`0J0?ooo`030000003oool0oooo0?l0oooo3@3oool001H0oooo00<000000?ooo`3oool0
G`3oool603loo`T0oooo00<00?l00?ooo`3oool06P3oool00`000000oooo0?ooo`3o0?ooo`d0oooo
000F0?ooo`80000000=000000?ooo`3oool0G@3oool603loo`P0oooo00<00?l00?ooo`3oool06`3o
ool00`000000oooo0?ooo`3o0?ooo`d0oooo000F0?ooo`030000003oool0oooo05h0oooo1P0o?ol8
0?ooo`03003o003oool0oooo01/0oooo00<000000?ooo`3oool0o`3oool>0?ooo`005P3oool00`00
0000oooo0?ooo`1N0?ooo`@0?coo2@3oool00`00o`00oooo0?ooo`0L0?ooo`030000003oool0oooo
0?l0oooo3P3oool001H0oooo00<000000?ooo`3oool0G03oool603loo`P0oooo00<00?l00?ooo`3o
ool07@3oool00`000000oooo0?ooo`3o0?ooo`h0oooo000F0?ooo`030000003oool0oooo05X0oooo
1`0o?ol80?ooo`03003o003oool0oooo01h0oooo00<000000?ooo`3oool0o`3oool>0?ooo`005P3o
ool00`000000oooo0?ooo`1I0?ooo`L0?coo1`3oool2003o0240oooo00<000000?ooo`3oool0o`3o
ool>0?ooo`005P3oool00`000000oooo0?ooo`1G0?ooo`P0?coo1`3oool00`00o`00oooo0?ooo`0Q
0?ooo`030000003oool0oooo0?l0oooo3P3oool001H0oooo00<000000?ooo`3oool0B@3oool3@000
0080oooo00=000000?ooo`3oool01P3oool603loo`P0oooo00<00?l00?ooo`3oool08@3oool00`00
0000oooo0?ooo`0:0?ooo`900000103oool00d000000oooo0?ooo`160?ooo`03@000003oool0oooo
0080oooo00=000000?ooo`3oool0@P3oool5@0000080oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`0o0?ooo`E0000000@0oooo@0000400001000000`3oool00d000000oooo0?ooo`0>
0?ooo`005P3oool00`000000oooo0?ooo`1:0?ooo`06@000003oool0oooo@000003ooom000001P3o
ool603loo`P0oooo00<00?l00?ooo`3oool08P3oool00`000000oooo0?ooo`0:0?ooo`03@000003o
oom000000080oooo00=000000?oood000000AP3oool00d000000oooo@00000020?ooo`03@000003o
oom0000004D0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood00
0000@P3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oood0000003`3oool001H0
oooo00<000000?ooo`3oool0B03oool4@00000040?oood000000oooo@00000@0oooo1P0o?ol90?oo
o`03003o003oool0oooo02<0oooo00<000000?ooo`3oool02P3oool00d000000oooo@00000020?oo
o`03@000003ooom0000004H0oooo00=000000?oood0000000P3oool00d000000oooo@00000150?oo
o`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom000000480oooo00=0
00000?ooo`3oool00P3oool01d000000oooo0?ooo`3ooom000000?oood0000003`3oool001H0oooo
0P0000000d000000oooo0?ooo`160?ooo`03@000003ooom000000080oooo00A000000?oood000000
oooo2@0o?ol70?ooo`800?l09P3oool00`000000oooo0?ooo`0:0?ooo`9000000`3oool00d000000
oooo@00000170?ooo`07@000003oool0oooo0?oood000000oooo@00000150?ooo`07@000003oool0
oooo0?oood000000oooo@00000020?ooo`03@000003ooom000000480oooo00=000000?ooo`3oool0
0P3oool01d000000oooo0?ooo`3ooom000000?oood0000003`3oool001H0oooo00<000000?ooo`3o
ool0B@3oool2@0000080oooo00=000000?oood0000002@0o?ol70?ooo`03003o003oool0oooo02D0
oooo00<000000?ooo`3oool02`3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000004H0
oooo00=000000?oood0000000P3oool00d000000oooo@00000150?ooo`07@000003oool0oooo0?oo
od000000oooo@00000020?ooo`03@000003ooom000000480oooo00M000000?ooo`3oool0oooo@000
003ooom000000080oooo00=000000?oood0000003`3oool001H0oooo00<000000?ooo`3oool0BP3o
ool014000000oooo0?ooo`3oool903loo`L0oooo0P00o`0X0?ooo`030000003oool0oooo00`0oooo
0T0000030?ooo`03@000003oool0oooo04H0oooo00=000000?ooo`3oool00P3oool00d000000oooo
0?ooo`130?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0400oooo
0T0000040?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool03P3oool001H0oooo00<0
00000?ooo`3oool0B`3oool;03loo`H0oooo0P00o`0Z0?ooo`030000003oool0oooo0?l0oooo403o
ool001H0oooo00<000000?ooo`3oool0BP3oool903loo`L0oooo0P00o`0/0?ooo`030000003oool0
oooo0?l0oooo403oool001H0oooo00<000000?ooo`3oool0A@3oool<03loo`L0oooo0P00o`0]0?oo
o`030000003oool0oooo0?l0oooo4@3oool001H0oooo00<000000?ooo`3oool0@`3oool=03loo`D0
oooo0`00o`0_0?ooo`030000003oool0oooo0?l0oooo4@3oool001H0oooo00<000000?ooo`3oool0
?@3oool@03loo`<0oooo1@00o`0b0?ooo`030000003oool0oooo0?l0oooo4@3oool001H0oooo00<0
00000?ooo`3oool0=P3ooolE03loo`80oooo0`00o`0g0?ooo`030000003oool0oooo0?l0oooo2@3o
ool3@00000D0oooo000F0?ooo`030000003oool0oooo00/0oooo>@0o?ol9003o03X0oooo00<00000
0?ooo`3oool0o`3oool90?ooo`03@000003ooom0000000D0oooo000F0?ooodL00?l0o`0000120000
0003@000003oool0oooo00`0oooo00=000000?ooo`3oool00`3oool001H0oooo00<000000?ooo`3o
ool02`3ooold03loo`d0oooo00<000000?ooo`3oool0403oool00d000000oooo0?ooo`0A0?ooo`03
@000003oool0oooo0100oooo00=000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`03
@000003oool0oooo0100oooo00=000000?ooo`3oool04@3oool00d000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0140oooo00=000000?ooo`3oool0403oool00d000000oooo0?ooo`0A0?ooo`03
@000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00d000000oooo0?ooo`0A0?ooo`03
@000003oool0oooo0100oooo00=000000?ooo`3oool04@3oool00`000000oooo0?ooo`0;0?ooo`03
@000003oool0oooo00@0oooo000F0?ooo`030000003oool0oooo00`0oooo:`0o?olE0?ooo`03@000
003oool0oooo04/0oooo00=000000?ooo`3oool0B`3oool00d000000oooo0?ooo`1<0?ooo`03@000
003oool0oooo04/0oooo00=000000?ooo`3oool02P3oool00d000000oooo@00000050?ooo`005P3o
ool00`000000oooo0?ooo`3o0?oooi<0oooo0d0000050?ooo`005P3oool00`000000oooo0?ooo`3o
0?oooi/0oooo000F0?ooo`030000003oool0oooo0?l0ooooV`3oool001H0oooo00<000000?ooo`3o
ool0o`3ooonK0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooi/0oooo000F0?ooo`030000003o
ool0oooo0?l0ooooV`3oool001H0oooo00<000000?ooo`3oool0o`3ooonK0?ooo`005P3oool20000
0003@000003oool0oooo0?l0ooooV@3oool001H0oooo00<000000?ooo`3oool0o`3ooonK0?ooo`00
5P3oool00`000000oooo0?ooo`3o0?oooi/0oooo000F0?ooo`030000003oool0oooo0?l0ooooV`3o
ool001H0oooo00<000000?ooo`3oool0o`3ooonK0?ooo`005P3oool00`000000oooo0?ooo`3o0?oo
oi/0oooo000F0?ooo`030000003oool0oooo0?l0ooooV`3oool001H0oooo00<000000?ooo`3oool0
o`3ooonK0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooi/0oooo000F0?ooo`030000003oool0
oooo0?l0ooooV`3oool001H0oooo00=000000?ooo`3oool0o`3ooonK0?ooo`00o`3ooond0?ooo`00
o`3ooond0?ooo`00o`3ooond0?ooo`00o`3ooond0?ooo`00o`3ooond0?ooo`00o`3ooond0?ooo`00
o`3ooond0?ooo`00o`3ooond0?ooo`00o`3ooond0?ooo`00o`3ooond0?ooo`00o`3ooond0?ooo`00
o`3ooond0?ooo`00o`3ooond0?ooo`00o`3ooond0?ooo`005@3oool2@0000?l0ooooW@3oool001@0
oooo00=000000?oood000000o`3ooonM0?ooo`00503oool00d000000oooo@000003o0?oooid0oooo
000D0?ooo`04@000003oool0oooo@0000?l0ooooW03oool001<0oooo00E000000?ooo`3oool0oooo
@000003o0?oooi`0oooo000C0?ooo`90000000<0oooo@00004000000o`3ooonL0?ooo`00o`3ooond
0?ooo`00o`3ooond0?ooo`00o`3ooond0?ooo`00o`3ooond0?ooo`00o`3ooond0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 434.188}, {267.938, 0}} -> {14.1518, -11.0295, 
  0.255426, 0.0495947}}]
}, Open  ]],

Cell[TextData[
"\"Err - rozdiel medzi explicitn\[YAcute]m rie\.9aen\[IAcute]m a na\.9aim v\
\[YAcute]sledkom\ntr1: tabu\:017eka chyby pribli\.9en\[EAcute]ho \
rie\.9aenia\""], "Text"],

Cell["\<\
Err[i_,sgm_]:=SpreadBear[xs[[i]],X1,X2,sgm,r,DD,t]-ys[[i]];
tr1:=Table[{xs[[i]],Err[i,sigma]},{i,2m+1}];\
\>", "Input"],

Cell["\"Maximov\[AAcute] chyba\"", "Text"],

Cell["\<\
Print[\"m = \",m,\" n = \",n,\" trans = \",trans,\" Max.chyba = \
\",Max[Table[Abs[Err[i,str]],{i,2m+1}]]]\
\>", "Input"],

Cell["\"Graf chyby pri delen\[IAcute] m=100 , n=100\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=ListPlot[tr1,PlotStyle->{PointSize[0.02],RGBColor[1,0,1]},DisplayFunction->\
Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->All]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.157596 0.00755858 0.297729 48.2769 [
[.14475 .28523 -6 -9 ]
[.14475 .28523 6 0 ]
[.29592 .28523 -6 -9 ]
[.29592 .28523 6 0 ]
[.44709 .28523 -6 -9 ]
[.44709 .28523 6 0 ]
[.59826 .28523 -9 -9 ]
[.59826 .28523 9 0 ]
[.74943 .28523 -9 -9 ]
[.74943 .28523 9 0 ]
[.9006 .28523 -9 -9 ]
[.9006 .28523 9 0 ]
[-0.01892 .00807 -36 -4.5 ]
[-0.01892 .00807 0 4.5 ]
[-0.01892 .10462 -36 -4.5 ]
[-0.01892 .10462 0 4.5 ]
[-0.01892 .20117 -36 -4.5 ]
[-0.01892 .20117 0 4.5 ]
[-0.01892 .39428 -30 -4.5 ]
[-0.01892 .39428 0 4.5 ]
[-0.01892 .49084 -30 -4.5 ]
[-0.01892 .49084 0 4.5 ]
[-0.01892 .58739 -30 -4.5 ]
[-0.01892 .58739 0 4.5 ]
[ -0.00642 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.14475 .29773 m
.14475 .30398 L
s
[(40)] .14475 .28523 0 1 Mshowa
.29592 .29773 m
.29592 .30398 L
s
[(60)] .29592 .28523 0 1 Mshowa
.44709 .29773 m
.44709 .30398 L
s
[(80)] .44709 .28523 0 1 Mshowa
.59826 .29773 m
.59826 .30398 L
s
[(100)] .59826 .28523 0 1 Mshowa
.74943 .29773 m
.74943 .30398 L
s
[(120)] .74943 .28523 0 1 Mshowa
.9006 .29773 m
.9006 .30398 L
s
[(140)] .9006 .28523 0 1 Mshowa
.125 Mabswid
.03137 .29773 m
.03137 .30148 L
s
.06916 .29773 m
.06916 .30148 L
s
.10695 .29773 m
.10695 .30148 L
s
.18254 .29773 m
.18254 .30148 L
s
.22033 .29773 m
.22033 .30148 L
s
.25813 .29773 m
.25813 .30148 L
s
.33371 .29773 m
.33371 .30148 L
s
.3715 .29773 m
.3715 .30148 L
s
.4093 .29773 m
.4093 .30148 L
s
.48488 .29773 m
.48488 .30148 L
s
.52268 .29773 m
.52268 .30148 L
s
.56047 .29773 m
.56047 .30148 L
s
.63605 .29773 m
.63605 .30148 L
s
.67385 .29773 m
.67385 .30148 L
s
.71164 .29773 m
.71164 .30148 L
s
.78723 .29773 m
.78723 .30148 L
s
.82502 .29773 m
.82502 .30148 L
s
.86281 .29773 m
.86281 .30148 L
s
.9384 .29773 m
.9384 .30148 L
s
.97619 .29773 m
.97619 .30148 L
s
.25 Mabswid
0 .29773 m
1 .29773 L
s
-0.00642 .00807 m
-0.00017 .00807 L
s
[(-0.006)] -0.01892 .00807 1 0 Mshowa
-0.00642 .10462 m
-0.00017 .10462 L
s
[(-0.004)] -0.01892 .10462 1 0 Mshowa
-0.00642 .20117 m
-0.00017 .20117 L
s
[(-0.002)] -0.01892 .20117 1 0 Mshowa
-0.00642 .39428 m
-0.00017 .39428 L
s
[(0.002)] -0.01892 .39428 1 0 Mshowa
-0.00642 .49084 m
-0.00017 .49084 L
s
[(0.004)] -0.01892 .49084 1 0 Mshowa
-0.00642 .58739 m
-0.00017 .58739 L
s
[(0.006)] -0.01892 .58739 1 0 Mshowa
.125 Mabswid
-0.00642 .03221 m
-0.00267 .03221 L
s
-0.00642 .05634 m
-0.00267 .05634 L
s
-0.00642 .08048 m
-0.00267 .08048 L
s
-0.00642 .12876 m
-0.00267 .12876 L
s
-0.00642 .1529 m
-0.00267 .1529 L
s
-0.00642 .17704 m
-0.00267 .17704 L
s
-0.00642 .22531 m
-0.00267 .22531 L
s
-0.00642 .24945 m
-0.00267 .24945 L
s
-0.00642 .27359 m
-0.00267 .27359 L
s
-0.00642 .32187 m
-0.00267 .32187 L
s
-0.00642 .34601 m
-0.00267 .34601 L
s
-0.00642 .37014 m
-0.00267 .37014 L
s
-0.00642 .41842 m
-0.00267 .41842 L
s
-0.00642 .44256 m
-0.00267 .44256 L
s
-0.00642 .4667 m
-0.00267 .4667 L
s
-0.00642 .51498 m
-0.00267 .51498 L
s
-0.00642 .53911 m
-0.00267 .53911 L
s
-0.00642 .56325 m
-0.00267 .56325 L
s
-0.00642 .61153 m
-0.00267 .61153 L
s
.25 Mabswid
-0.00642 0 m
-0.00642 .61803 L
s
1 0 1 r
.02 w
.02381 .29772 Mdot
.02548 .29773 Mdot
.02716 .29774 Mdot
.02887 .29774 Mdot
.03058 .29775 Mdot
.03231 .29776 Mdot
.03406 .29777 Mdot
.03583 .29779 Mdot
.03761 .2978 Mdot
.0394 .29782 Mdot
.04122 .29785 Mdot
.04305 .29788 Mdot
.04489 .29792 Mdot
.04676 .29796 Mdot
.04864 .29802 Mdot
.05054 .29809 Mdot
.05245 .29818 Mdot
.05439 .29828 Mdot
.05634 .29841 Mdot
.05831 .29856 Mdot
.06029 .29874 Mdot
.0623 .29896 Mdot
.06432 .29922 Mdot
.06637 .29953 Mdot
.06843 .2999 Mdot
.07051 .30033 Mdot
.07261 .30084 Mdot
.07473 .30143 Mdot
.07687 .30211 Mdot
.07903 .3029 Mdot
.0812 .30382 Mdot
.0834 .30486 Mdot
.08562 .30606 Mdot
.08786 .30741 Mdot
.09012 .30894 Mdot
.0924 .31066 Mdot
.0947 .31258 Mdot
.09702 .31471 Mdot
.09937 .31707 Mdot
.10173 .31965 Mdot
.10412 .32248 Mdot
.10653 .32554 Mdot
.10896 .32883 Mdot
.11141 .33235 Mdot
.11389 .33608 Mdot
.11639 .33999 Mdot
.11891 .34407 Mdot
.12145 .34827 Mdot
.12402 .35254 Mdot
.12662 .35683 Mdot
.12923 .36107 Mdot
.13187 .3652 Mdot
.13454 .36911 Mdot
.13723 .37272 Mdot
.13994 .37592 Mdot
.14268 .37859 Mdot
.14544 .38063 Mdot
.14823 .38191 Mdot
.15105 .38229 Mdot
.15389 .38166 Mdot
.15676 .37989 Mdot
.15965 .37686 Mdot
.16257 .37246 Mdot
.16552 .3666 Mdot
.16849 .35921 Mdot
.17149 .35021 Mdot
.17452 .33958 Mdot
.17758 .32731 Mdot
.18066 .31343 Mdot
.18378 .29799 Mdot
.18692 .28108 Mdot
.19009 .26285 Mdot
.19329 .24345 Mdot
.19652 .2231 Mdot
.19978 .20203 Mdot
.20307 .18053 Mdot
.20639 .15891 Mdot
.20974 .1375 Mdot
.21312 .11666 Mdot
.21653 .09676 Mdot
.21998 .07818 Mdot
.22345 .06131 Mdot
.22696 .0465 Mdot
.2305 .03413 Mdot
.23407 .02452 Mdot
.23768 .01796 Mdot
.24132 .01472 Mdot
.24499 .01498 Mdot
.2487 .01889 Mdot
.25244 .02655 Mdot
.25621 .03796 Mdot
.26002 .05307 Mdot
.26386 .07177 Mdot
.26774 .09385 Mdot
.27166 .11906 Mdot
.27561 .14707 Mdot
.2796 .1775 Mdot
.28362 .20992 Mdot
.28768 .24385 Mdot
.29178 .27878 Mdot
.29592 .31418 Mdot
.30009 .34951 Mdot
.30431 .38424 Mdot
.30856 .41783 Mdot
.31285 .44977 Mdot
.31718 .47961 Mdot
.32155 .5069 Mdot
.32596 .53128 Mdot
.33041 .55243 Mdot
.3349 .57009 Mdot
.33944 .58409 Mdot
.34401 .59431 Mdot
.34863 .60071 Mdot
.35329 .60332 Mdot
.35799 .60223 Mdot
.36274 .59761 Mdot
.36753 .58967 Mdot
.37236 .57867 Mdot
.37724 .56492 Mdot
.38216 .54876 Mdot
.38713 .53056 Mdot
.39215 .5107 Mdot
.39721 .48956 Mdot
.40231 .46755 Mdot
.40747 .44503 Mdot
.41267 .42236 Mdot
.41792 .3999 Mdot
.42322 .37794 Mdot
.42856 .35677 Mdot
.43396 .33664 Mdot
.4394 .31775 Mdot
.4449 .30026 Mdot
.45044 .28431 Mdot
.45604 .26999 Mdot
.46169 .25735 Mdot
.46739 .2464 Mdot
.47314 .23715 Mdot
.47895 .22954 Mdot
.48481 .22352 Mdot
.49072 .219 Mdot
.49669 .21588 Mdot
.50271 .21404 Mdot
.50879 .21337 Mdot
.51492 .21373 Mdot
.52111 .215 Mdot
.52736 .21704 Mdot
.53367 .21973 Mdot
.54003 .22295 Mdot
.54645 .22658 Mdot
.55293 .23051 Mdot
.55947 .23466 Mdot
.56607 .23892 Mdot
.57274 .24323 Mdot
.57946 .24751 Mdot
.58624 .25172 Mdot
.59309 .2558 Mdot
.6 .25971 Mdot
.60697 .26344 Mdot
.61401 .26695 Mdot
.62111 .27023 Mdot
.62828 .27328 Mdot
.63552 .27609 Mdot
.64282 .27866 Mdot
.65018 .281 Mdot
.65762 .28312 Mdot
.66512 .28502 Mdot
.6727 .28672 Mdot
.68034 .28823 Mdot
.68805 .28957 Mdot
.69584 .29074 Mdot
.70369 .29178 Mdot
.71162 .29267 Mdot
.71962 .29345 Mdot
.7277 .29412 Mdot
.73585 .2947 Mdot
.74407 .2952 Mdot
.75237 .29562 Mdot
.76075 .29598 Mdot
.7692 .29628 Mdot
.77773 .29653 Mdot
.78634 .29675 Mdot
.79503 .29692 Mdot
.8038 .29707 Mdot
.81265 .2972 Mdot
.82158 .2973 Mdot
.83059 .29738 Mdot
.83969 .29745 Mdot
.84887 .2975 Mdot
.85813 .29755 Mdot
.86748 .29759 Mdot
.87692 .29762 Mdot
.88644 .29764 Mdot
.89605 .29766 Mdot
.90575 .29767 Mdot
.91554 .29769 Mdot
.92542 .2977 Mdot
.93539 .29771 Mdot
.94545 .29771 Mdot
.9556 .29772 Mdot
.96585 .29773 Mdot
.97619 .29773 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`003@3oool00d000000oooo0?ooo`020?ooo`03@000
003oool0oooo0080oooo00=000000?ooo`3oool00P3oool014000000oooo0?ooo`3oool2@00000D0
oooo00<000000?ooo`3oool0mP3oool000`0oooo00=000000?oood0000001`3oool00d000000oooo
@00000020?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool00`000000oooo
0?ooo`3f0?ooo`001`3oool3@0000080oooo00=000000?oood0000001`3oool00d000000oooo@000
00020?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool00`00001000000?oo
o`3f0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=00000
0?oood0000000P3oool2@00000D0oooo00<000000?ooo`3oool0mP3oool000`0oooo00=000000?oo
od0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom000000080oooo00=000000?oo
o`3oool0103oool00`000000oooo0?ooo`0h0?ooo`@0o`3o^P3oool000d0oooo00=000000?ooo`3o
ool01`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo0T0000040?ooo`03
0000003oool0oooo03L0oooo1@3o0?nj0?ooo`009`3oool00`000000oooo0?ooo`0f0?ooo`H0o`3o
^P3oool002L0oooo00<000000?ooo`3oool0=P3oool30?l0o`040?ooo`3o0?l0o`3o0?l0okT0oooo
000W0?ooo`03000004000000oooo03L0oooo00<0o`3o0?ooo`3oool00`3o0?ni0?ooo`009`3oool0
0`000000oooo0?ooo`0e0?ooo`<0o`3o0`3oool30?l0okP0oooo000W0?ooo`030000003oool0oooo
03D0oooo0`3o0?l30?ooo`<0o`3o^03oool002L0oooo00<000000?ooo`3oool0=P3oool00`3o0?l0
oooo0?ooo`030?ooo`030?l0o`3oool0oooo0;L0oooo000W0?ooo`030000003oool0oooo03@0oooo
0`3o0?no0?ooo`009`3oool00`000000oooo0?ooo`0d0?ooo`<0o`3o1@3oool30?l0okL0oooo000W
0?ooo`03000004000000oooo03D0oooo00<0o`3o0?ooo`3oool0103oool30?l0okL0oooo000W0?oo
o`030000003oool0oooo03<0oooo0`3o0?l70?ooo`030?l0o`3oool0oooo0;H0oooo000W0?ooo`03
0000003oool0oooo03<0oooo0`3o0?o00?ooo`009`3oool00`000000oooo0?ooo`0d0?ooo`030?l0
o`3oool0oooo0;l0oooo000W0?ooo`030000003oool0oooo03d0oooo0`3o0?nf0?ooo`009`3oool0
0`000000oooo0?ooo`0b0?ooo`<0o`3o203oool30?l0okH0oooo000W0?ooo`03000004000000oooo
0380oooo0`3o0?l90?ooo`030?l0o`3oool0oooo0;D0oooo000W0?ooo`030000003oool0oooo03<0
oooo00<0o`3o0?ooo`3oool0`03oool002L0oooo00<000000?ooo`3oool0mP3oool002L0oooo00<0
00000?ooo`3oool0?P3oool30?l0okD0oooo000=0?ooo`03@000003oool0oooo0080oooo00=00000
0?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo0d000003
0?ooo`030000003oool0oooo0380oooo0`3o0?l90?ooo`<0o`3o]@3oool000`0oooo00=000000?oo
od0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000@0oooo00=000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0b0?ooo`<0o`3o2P3oool00`3o0?l0oooo0?ooo`2d0?oo
o`001`3oool3@0000080oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03
@000003ooom000000080oooo140000030?ooo`03000004000000oooo03<0oooo00<0o`3o0?ooo`3o
ool0`03oool000`0oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000
003ooom000000080oooo00=000000?oood000000103oool00`000000oooo0?ooo`3f0?ooo`00303o
ool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood0000000`3o
ool2@00000@0oooo00<000000?ooo`3oool0mP3oool000d0oooo00=000000?ooo`3oool01`3oool0
0d000000oooo0?ooo`020?ooo`03@000003oool0oooo00<0oooo00=000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0a0?ooo`<0o`3o2`3oool30?l0ok@0oooo000W0?ooo`030000003oool0oooo
0340oooo0`3o0?l;0?ooo`<0o`3o]03oool002L0oooo00<000000?ooo`3oool0<P3oool00`3o0?l0
oooo0?ooo`0;0?ooo`030?l0o`3oool0oooo0;<0oooo000W0?ooo`03000004000000oooo0?H0oooo
000W0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`030000003oool0oooo0300oooo0`3o0?o3
0?ooo`009`3oool00`000000oooo0?ooo`0`0?ooo`<0o`3o``3oool002L0oooo00<000000?ooo`3o
ool0<@3oool00`3o0?l0oooo0?ooo`0<0?ooo`<0o`3o/`3oool002L0oooo00<000000?ooo`3oool0
@03oool30?l0ok<0oooo000W0?ooo`03000004000000oooo0440oooo00<0o`3o0?ooo`3oool0/P3o
ool002L0oooo00<000000?ooo`3oool0;`3oool30?l0ol@0oooo000W0?ooo`030000003oool0oooo
02l0oooo0`3o0?o40?ooo`009`3oool00`000000oooo0?ooo`0`0?ooo`030?l0o`3oool0oooo0<<0
oooo000W0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W
0?ooo`03000004000000oooo0440oooo0`3o0?nb0?ooo`009`3oool00`000000oooo0?ooo`0^0?oo
o`<0o`3o403oool30?l0ok80oooo000W0?ooo`030000003oool0oooo02h0oooo0`3o0?lA0?ooo`03
0?l0o`3oool0oooo0;40oooo000W0?ooo`030000003oool0oooo02l0oooo00<0o`3o0?ooo`3oool0
a03oool000d0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003o
ool0oooo0080oooo00A000000?ooo`3oool0oooo0d0000040?ooo`030000003oool0oooo0?H0oooo
000<0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@000
00020?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0mP3oool000L0oooo0d000002
0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@0000003
0?ooo`03@000003oool0oooo00<0oooo00<00000@000003oool0;@3oool30?l0olH0oooo000<0?oo
o`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000030?oo
o`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0;@3oool30?l0olH0oooo000<0?ooo`03
@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03
@000003ooom0000000@0oooo00<000000?ooo`3oool0;P3oool00`3o0?l0oooo0?ooo`0A0?ooo`<0
o`3o/@3oool000d0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`020?ooo`03@000
003oool0oooo0080oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`120?ooo`<0o`3o
<P3oool90?l0ogH0oooo000W0?ooo`030000003oool0oooo04<0oooo00<0o`3o0?ooo`3oool0;`3o
ool>0?l0og<0oooo000W0?ooo`030000003oool0oooo02d0oooo0`3o0?m40?ooo`H0o`3o00@0oooo
0?l0o`3o0?l0oooo1P3o0?mb0?ooo`009`3oool00`00001000000?ooo`0]0?ooo`<0o`3oA03oool3
0?l0o`P0oooo00<0o`3o0?ooo`3o0?l0103o0?m`0?ooo`009`3oool00`000000oooo0?ooo`0^0?oo
o`030?l0o`3oool0oooo0440oooo103o0?l<0?ooo`D0o`3oK`3oool002L0oooo00<000000?ooo`3o
ool0LP3oool30?l0o`l0oooo1@3o0?m]0?ooo`009`3oool00`000000oooo0?ooo`1a0?ooo`<0o`3o
4@3oool60?l0of/0oooo000W0?ooo`030000003oool0oooo02`0oooo0`3o0?lD0?ooo`<0o`3o:`3o
ool30?l0oa<0oooo1@3o0?mZ0?ooo`009`3oool00`000000oooo0?ooo`0/0?ooo`<0o`3o503oool3
0?l0obT0oooo103o0?lF0?ooo`D0o`3oJ03oool002L0oooo00<00000@000003oool07`3oool3@000
0080oooo00=000000?ooo`3oool01P3oool00`3o0?l0oooo0?ooo`0C0?ooo`03@000003o0?l0oooo
00<0oooo00=000000?ooo`3oool07@3oool00d000000oooo0?ooo`020?ooo`04@000003o0?l0o`3o
0?l0oaP0oooo1P3o0?l00`3ooom000000?ooo`030?ooo`03@000003oool0oooo01H0oooo1D000000
103ooom00000@000040000030?ooo`03@000003oool0oooo01L0oooo1D0000020?ooo`=000000P3o
ool00d000000oooo0?ooo`0B0?ooo`009`3oool00`000000oooo0?ooo`0P0?ooo`06@000003oool0
oooo@000003ooom000007@3oool00d000000oooo@00000020?ooo`03@000003ooom0000001d0oooo
00=000000?oood0000000P3oool014000000o`3o0?l0o`3o0?lK0?ooo`D0o`3o00L0oooo@000003o
ool0oooo@000003ooom0000001T0oooo00E000000?ooo`3oool0oooo@00000040?ooo`03@000003o
oom0000001X0oooo00=000000?ooo`3oool00`3oool01T000000oooo0?oood000000oooo@00001<0
oooo000W0?ooo`030000003oool0oooo01h0oooo14000000103ooom000000?oood00000M0?ooo`03
@000003ooom000000080oooo00=000000?oood0000007@3oool00d000000oooo@00000020?ooo`04
@000003o0?l0o`3o0?l0oa/0oooo00=000000?ooo`3o0?l0103o0?l20?ooo`03@000003ooom00000
01T0oooo00=000000?ooo`3oool00P3oool01d000000oooo0?ooo`3ooom000000?oood0000006P3o
ool014000000oooo0?ooo`3oool4@00000040?oood000000oooo@00001<0oooo000W0?ooo`030000
003oool0oooo01h0oooo00=000000?oood0000000P3oool00d000000oooo@00000050?ooo`<0o`3o
5@3oool2@00000<0oooo00=000000?oood0000007P3oool01d000000oooo0?ooo`3ooom000000?oo
o`3o0?l0703oool00d000000oooo0?ooo`060?l0o`03@000003ooom0000001T0oooo00=000000?oo
o`3oool00P3oool01d000000oooo0?ooo`3ooom000000?oood0000006P3oool01d000000oooo0?oo
o`3ooom000000?oood0000000P3oool00d000000oooo@000000C0?ooo`009`3oool00`000000oooo
0?ooo`0O0?ooo`9000000P3oool00d000000oooo@00000050?ooo`<0o`3o5@3oool00d000000oooo
0?ooo`020?ooo`03@000003ooom0000001d0oooo00=000000?oood0000000P3oool00d000000oooo
@000000L0?ooo`05@000003oool0oooo0?oood0000001@3o0?l00`3ooom000000?ooo`0H0?ooo`07
@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom0000001X0oooo00=00000
0?ooo`3oool00P3oool2@0000080oooo00=000000?oood0000004`3oool002L0oooo00<000000?oo
o`3oool0803oool01D000000oooo0?ooo`3ooom0000000L0oooo00<0o`3o0?ooo`3oool05@3oool2
@00000<0oooo00=000000?ooo`3oool07@3oool014000000oooo0?ooo`3oool30?l0oa/0oooo0T00
00040?ooo`03@000003oool0o`3o00H0o`3o5P3oool2@00000@0oooo00=000000?ooo`3oool00P3o
ool00d000000oooo0?ooo`0H0?ooo`9000001@3oool01D000000oooo0?ooo`3ooom0000001@0oooo
000W0?ooo`03000004000000oooo06d0oooo0`3o0?lT0?ooo`P0o`3oFP3oool002L0oooo00<00000
0?ooo`3oool0:P3oool30?l0oaL0oooo0`3o0?lW0?ooo`030?l0o`3oool0oooo02D0oooo00<0o`3o
0?ooo`3o0?l01P3o0?mG0?ooo`009`3oool00`000000oooo0?ooo`0Z0?ooo`<0o`3o5`3oool30?l0
ob@0oooo0`3o0?l/0?ooo`T0o`3oD`3oool002L0oooo00<000000?ooo`3oool0:`3oool00`3o0?l0
oooo0?ooo`0G0?ooo`030?l0o`3oool0oooo02<0oooo0`3o0?l^0?ooo`d0o`3oC@3oool002L0oooo
00<000000?ooo`3oool0K03oool00`3o0?l0oooo0?ooo`0`0?ooo`030?l0o`3oool0o`3o00h0o`3o
AP3oool002L0oooo00<000000?ooo`3oool00P3oool90?l0oiP0oooo00@0o`3o0?ooo`3o0?l0oooo
B@3o0?l60?ooo`009`3oool500000100o`3o5`0000030?l0och000000`3o0?ll000000040?l0o`00
0000o`3o000004<0o`3o1@000001@00000009`3oool00`000000oooo0?ooo`030?oooa40o`3o3P3o
ool00d000000oooo0?ooo`040?ooo`<0o`3o6`3oool00d000000oooo0?ooo`0P0?ooo`<0o`3o9@3o
ool00d000000oooo0?ooo`0K0?ooo`030?l0o`3oool0o`3o0080oooo0140o`3o0?ooo`3o0?l0oooo
0?l0o`3oool0o`3o0?ooo`3o0?l0oooo0?l0o`3oool0o`3o0?ooo`3o0?l0oooo0?l0o`020?ooo`07
0?l0o`3oool0o`3o0?ooo`3o0?l0oooo0?l0o`020?ooo`050?l0o`3oool0o`3o0?ooo`3o0?l00P3o
ool01@3o0?l0oooo0?l0o`3oool0o`3o0080oooo00<0o`3o0?ooo`3o0?l00P3oool00`3o0?l0oooo
0?l0o`020?ooo`030?l0o`3oool0o`3o0080oooo00<0o`3o0?ooo`3oool01@3oool002L0oooo00<0
00000?ooo`3oool02@3oool<0?l0oaD0oooo00<0o`3o0?ooo`3oool0?P3oool00`3o0?l0oooo0?oo
o`280?ooo`009`3oool00`000000oooo0?ooo`0@0?ooo`L0o`3o4P3oool30?l0oaT0oooo0`3o0?n^
0?ooo`009`3oool00`000000oooo0?ooo`0C0?ooo`D0o`3o4@3oool30?l0oaT0oooo0`3o0?lP0?oo
o`<0o`3oR`3oool002L0oooo00<00000@000003oool0503oool40?l0oa80oooo00<0o`3o0?ooo`3o
ool06@3oool00`3o0?l0oooo0?ooo`0O0?ooo`<0o`3oR`3oool002L0oooo00<000000?ooo`3oool0
5@3oool40?l0oe00oooo00<0o`3o0?ooo`3oool0RP3oool002L0oooo00<000000?ooo`3oool05P3o
ool40?l0o`h0oooo0`3o0?o;0?ooo`009`3oool00`000000oooo0?ooo`0G0?ooo`@0o`3o3@3oool3
0?l0ol/0oooo000W0?ooo`030000003oool0oooo01P0oooo0`3o0?l>0?ooo`030?l0o`3oool0oooo
03/0oooo0`3o0?n<0?ooo`009`3oool00`000000oooo0?ooo`0H0?ooo`@0o`3o2`3oool30?l0ocd0
oooo0`3o0?n<0?ooo`009`3oool00`00001000000?ooo`0I0?ooo`@0o`3o2P3oool30?l0och0oooo
00<0o`3o0?ooo`3oool0R`3oool002L0oooo00<000000?ooo`3oool06P3oool30?l0o`T0oooo0`3o
0?lM0?ooo`<0o`3o[@3oool002L0oooo00<000000?ooo`3oool06P3oool40?l0o`P0oooo0`3o0?lM
0?ooo`<0o`3o[@3oool002L0oooo00<000000?ooo`3oool06`3oool30?l0o`T0oooo00<0o`3o0?oo
o`3oool07@3oool00`3o0?l0oooo0?ooo`0L0?ooo`<0o`3oS@3oool002L0oooo00<000000?ooo`3o
ool06`3oool40?l0o`L0oooo0`3o0?lm0?ooo`<0o`3oS@3oool002L0oooo00<000000?ooo`3oool0
703oool40?l0o`D0oooo103o0?ln0?ooo`030?l0o`3oool0oooo08`0oooo000W0?ooo`0300000400
0000oooo01d0oooo0`3o0?l50?ooo`<0o`3ocP3oool002L0oooo00<000000?ooo`3oool07@3oool4
0?l0o`<0oooo0`3o0?o?0?ooo`009`3oool00`000000oooo0?ooo`0N0?ooo`@0o`3o0P3oool30?l0
ocd0oooo0`3o0?n?0?ooo`009`3oool00`000000oooo0?ooo`0O0?ooo`P0o`3o?@3oool30?l0ohl0
oooo000=0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo
0?ooo`020?ooo`04@000003oool0oooo0?ooo`=00000103oool00`000000oooo0?ooo`0P0?ooo`H0
o`3o8@3oool30?l0oa/0oooo00<0o`3o0?ooo`3oool0SP3oool000`0oooo00=000000?oood000000
1`3oool00d000000oooo@00000020?ooo`03@000003ooom000000080oooo00=000000?ooo`3oool0
103oool00`000000oooo0?ooo`0Q0?ooo`@0o`3o8P3oool30?l0oj`0oooo000<0?ooo`03@000003o
oom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000030?ooo`03@000003o
ool0oooo00<0oooo00<00000@000003oool0B03oool00`3o0?l0oooo0?ooo`2[0?ooo`00303oool0
0d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood0000000`3oool0
0d000000oooo0?ooo`030?ooo`030000003oool0oooo0?H0oooo000<0?ooo`03@000003ooom00000
00L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003ooom00000
00@0oooo00<000000?ooo`3oool0H`3oool30?l0oi00oooo000=0?ooo`03@000003oool0oooo00L0
oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00<0
oooo00<000000?ooo`3oool0H`3oool30?l0oi00oooo000W0?ooo`030000003oool0oooo06@0oooo
00<0o`3o0?ooo`3oool0S`3oool002L0oooo00<000000?ooo`3oool0mP3oool002L0oooo00<00000
@000003oool0B03oool30?l0oj/0oooo000W0?ooo`030000003oool0oooo04P0oooo0`3o0?lG0?oo
o`<0o`3oT@3oool002L0oooo00<000000?ooo`3oool0B@3oool00`3o0?l0oooo0?ooo`0F0?ooo`<0
o`3oT@3oool002L0oooo00<000000?ooo`3oool0H`3oool00`3o0?l0oooo0?ooo`2@0?ooo`009`3o
ool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`00
001000000?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`1Q0?ooo`<0o`3oTP3oool002L0oooo
00<000000?ooo`3oool0B@3oool30?l0oaD0oooo0`3o0?nB0?ooo`009`3oool00`000000oooo0?oo
o`190?ooo`<0o`3o5P3oool00`3o0?l0oooo0?ooo`2A0?ooo`009`3oool00`000000oooo0?ooo`1:
0?ooo`030?l0o`3oool0oooo0:T0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`03
000004000000oooo05l0oooo0`3o0?nD0?ooo`009`3oool00`000000oooo0?ooo`1O0?ooo`<0o`3o
U03oool002L0oooo00<000000?ooo`3oool0H03oool00`3o0?l0oooo0?ooo`2C0?ooo`009`3oool0
0`000000oooo0?ooo`1:0?ooo`<0o`3oZ@3oool000d0oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool3@000
00<0oooo00<000000?ooo`3oool0BP3oool30?l0ojT0oooo000<0?ooo`03@000003ooom0000000L0
oooo00=000000?oood0000000P3oool00d000000oooo@00000040?ooo`03@000003oool0oooo0080
oooo00<000000?ooo`3oool0B`3oool00`3o0?l0oooo0?ooo`2X0?ooo`00303oool00d000000oooo
@00000070?ooo`03@000003ooom000000080oooo00=000000?oood0000000P3oool4@00000<0oooo
00<00000@000003oool0GP3oool30?l0oiD0oooo000<0?ooo`03@000003ooom0000000L0oooo00=0
00000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003ooom0000000@0oooo00<0
00000?ooo`3oool0GP3oool30?l0oiD0oooo000<0?ooo`03@000003ooom0000000L0oooo00=00000
0?oood0000000P3oool00d000000oooo@00000030?ooo`900000103oool00`000000oooo0?ooo`1O
0?ooo`030?l0o`3oool0oooo09@0oooo000=0?ooo`03@000003oool0oooo00L0oooo00=000000?oo
o`3oool00P3oool00d000000oooo0?ooo`030?ooo`03@000003oool0oooo0080oooo00<000000?oo
o`3oool0mP3oool002L0oooo00<000000?ooo`3oool0B`3oool30?l0ojP0oooo000W0?ooo`030000
003oool0oooo04/0oooo0`3o0?l?0?ooo`<0o`3oUP3oool002L0oooo00<00000@000003oool0C03o
ool00`3o0?l0oooo0?ooo`0>0?ooo`<0o`3oUP3oool002L0oooo00<000000?ooo`3oool0GP3oool0
0`3o0?l0oooo0?ooo`2E0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000
oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`1=0?ooo`<0o`3o303oool30?l0oiL0oooo
000W0?ooo`030000003oool0oooo04d0oooo0`3o0?l<0?ooo`<0o`3oU`3oool002L0oooo00<00000
@000003oool0CP3oool00`3o0?l0oooo0?ooo`0<0?ooo`030?l0o`3oool0oooo09H0oooo000W0?oo
o`030000003oool0oooo0?H0oooo000W0?ooo`030000003oool0oooo05X0oooo0`3o0?nI0?ooo`00
9`3oool00`000000oooo0?ooo`1>0?ooo`<0o`3o2@3oool30?l0oiT0oooo000W0?ooo`030000003o
ool0oooo04h0oooo0`3o0?l:0?ooo`030?l0o`3oool0oooo09P0oooo000W0?ooo`030000003oool0
oooo04l0oooo00<0o`3o0?ooo`3oool0Y03oool002L0oooo00<00000@000003oool0F@3oool30?l0
oiX0oooo000W0?ooo`030000003oool0oooo05T0oooo0`3o0?nJ0?ooo`009`3oool00`000000oooo
0?ooo`1?0?ooo`<0o`3o203oool00`3o0?l0oooo0?ooo`2I0?ooo`009`3oool00`000000oooo0?oo
o`1?0?ooo`<0o`3oY03oool000d0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`02
0?ooo`03@000003oool0oooo0080oooo00A000000?ooo`3oool0oooo0T0000050?ooo`030000003o
ool0oooo0500oooo00<0o`3o0?ooo`3oool01@3oool30?l0oi/0oooo000<0?ooo`03@000003ooom0
000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003ooom0
000000@0oooo00<000000?ooo`3oool0D03oool30?l0o`D0oooo0`3o0?nK0?ooo`00303oool00d00
0000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood0000000P3oool00d00
0000oooo@00000040?ooo`03000004000000oooo0500oooo0`3o0?l40?ooo`<0o`3oW03oool000`0
oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom000000080
oooo0T0000050?ooo`030000003oool0oooo0540oooo00<0o`3o0?ooo`3oool00`3oool30?l0oi`0
oooo000<0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo
@00000020?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0D@3oool30?l0o`80oooo
0`3o0?nM0?ooo`003@3oool00d000000oooo0?ooo`070?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool00P3oool2@00000@0oooo00<000000?ooo`3oool0D@3oool80?l0oid0oooo000W
0?ooo`030000003oool0oooo0580oooo1P3o0?nN0?ooo`009`3oool00`000000oooo0?ooo`1C0?oo
o`<0o`3oX03oool002L0oooo00<00000@000003oool0E03oool00`3o0?l0oooo0?ooo`2O0?ooo`00
9`3oool00d000000oooo0?ooo`3f0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.988344, -0.00731095, 
  0.537069, 8.40875*^-05}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{251, 351},
WindowMargins->{{Automatic, 23}, {Automatic, 61}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 101, 3, 120, "Input"],
Cell[1813, 54, 72, 0, 52, "Text"],
Cell[1888, 56, 1260, 53, 1434, "Input"],
Cell[3151, 111, 44, 0, 33, "Text"],
Cell[3198, 113, 122, 12, 210, "Input"],
Cell[3323, 127, 47, 0, 33, "Text"],
Cell[3373, 129, 73, 0, 66, "Input"],
Cell[3449, 131, 65, 0, 66, "Input"],
Cell[3517, 133, 50, 0, 33, "Text"],
Cell[3570, 135, 140, 3, 138, "Input"],
Cell[3713, 140, 34, 0, 33, "Text"],
Cell[3750, 142, 64, 0, 48, "Input"],
Cell[3817, 144, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[3866, 148, 437, 11, 408, "Input"],
Cell[4306, 161, 36973, 948, 277, 10246, 614, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[41294, 1112, 183, 3, 71, "Text"],
Cell[41480, 1117, 129, 3, 102, "Input"],
Cell[41612, 1122, 42, 0, 33, "Text"],
Cell[41657, 1124, 131, 3, 102, "Input"],
Cell[41791, 1129, 63, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[41879, 1133, 172, 5, 192, "Input"],
Cell[42054, 1140, 23943, 648, 186, 7280, 438, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

