(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     63591,       1744]*)
(*NotebookOutlinePosition[     64287,       1769]*)
(*  CellTagsIndexPosition[     64243,       1765]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
<<c:\\math\\kniz\\linearal\\tridiago.m
<<c:\\math\\kniz\\options\\optvalue.m\
\>", "Input"],

Cell["\"Bullish vertical spread : 1 call long + 1 call short\"", "Text"],

Cell["\<\
BullishSpread[X1_,X2_,sigma_,r_,D_,t_,m_,n_,trans_,time_]:=
Module[
{doldiag,diag,hordiag},

X=(X1+X2)/2;
xright=Log[Slarge/X];

k1=N[r/(0.5*sigma^2)];
k2=N[(r-D)/(0.5*sigma^2)];
k3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
k4=N[0.25*(k2^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

TransfBullSpreadPayoff[x_]:=N[Exp[0.5*(k2-1)*x]*(Max[Exp[x]-X1/X,0]-Max[Exp[x]\
-X2/X,0])];
Do[u[i,0]=TransfBullSpreadPayoff[i*h],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
 Do[
      grad=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      kriv=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
ClenAbs[i]=Abs[N[k4*u[i,j-1]-k2*grad+kriv]],{i,-m+1,m-1}];

op1=0;
op2=Exp[0.5*(k2-1)*xright+0.25*(k2-1)^2*k*j]*(X2-X1)/X;

ps = Join[{u[-m+1,j-1]-k3*k*ClenAbs[-m+1]-a*op1},
          Table[u[i,j-1]-k3*k*ClenAbs[i],{i,-m+2,m-2}],
          {u[m-1,j-1]-k3*k*ClenAbs[m-1]-c*op2}];

hordiag=Table[c,{i,-m+1,m-2}];
diag=Table[b,{i,-m+1,m-1}];
doldiag=Table[a,{i,-m+2,m-1}];

riesenie=TridiagonalSolve[N[doldiag],N[diag],N[hordiag],N[ps]];
 
u[-m,j]=op1;
Do[u[i,j]=riesenie[[i+m]],{i,-m+1,m-1}];
u[m,j]=op2;

xs=Table[X*Exp[i*h],{i,-m,m}];
ys=Table[X*Exp[-0.5*(k2-1)*i*h-(0.25*(k2-1)^2+k1)*j*k]*u[i,j],{i,-m,m}];
graf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
{j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X1=45;
X2=55;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=100;
n=100;
Slarge=150;
trans=0.02;
time=0.03;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["BullishSpread[X1,X2,sigma,r,DD,t,m,n,trans,time]", "Input"],

Cell["\"Explicitn\[EAcute] rie\.9aenie\"", "Text"],

Cell["\<\
SpreadBull[S_,X1_,X2_,sigma_,r_,DD_,t_]:=
N[EuropeanCallDiv[S,X1,sigma,r,DD,t]-EuropeanCallDiv[S,X2,sigma,r,DD,t]]\
\>", "Input"],

Cell["\"Payoff diagram\"", "Text"],

Cell["Payoff[S_,X1_,X2_]:=N[Max[S-X1,0]-Max[S-X2,0]]", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[SpreadBull[S,X1,X2,sigma,r,DD,t],{S,0,150},PlotRange->All,PlotStyle->\
RGBColor[0,1,0], DisplayFunction->Identity];
g1=ListPlot[graf[n],PlotStyle->{PointSize[0.015],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];
g2=Plot[Payoff[S,X1,X2],{S,0,150},PlotRange->All, DisplayFunction->Identity];
Show[g2,g1,g,AxesLabel -> \
{\"S\",\"V\"},DisplayFunction->$DisplayFunction,PlotRange->{{20,120},{0,11}}]
\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.2 0.01 0 0.0561849 [
[.2 -0.0125 -6 -9 ]
[.2 -0.0125 6 0 ]
[.4 -0.0125 -6 -9 ]
[.4 -0.0125 6 0 ]
[.6 -0.0125 -6 -9 ]
[.6 -0.0125 6 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .11237 -6 -4.5 ]
[-0.0125 .11237 0 4.5 ]
[-0.0125 .22474 -6 -4.5 ]
[-0.0125 .22474 0 4.5 ]
[-0.0125 .33711 -6 -4.5 ]
[-0.0125 .33711 0 4.5 ]
[-0.0125 .44948 -6 -4.5 ]
[-0.0125 .44948 0 4.5 ]
[-0.0125 .56185 -12 -4.5 ]
[-0.0125 .56185 0 4.5 ]
[0 .64303 -5.5 0 ]
[0 .64303 5.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2 0 m
.2 .00625 L
s
[(40)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(60)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(80)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(100)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(120)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .11237 m
.00625 .11237 L
s
[(2)] -0.0125 .11237 1 0 Mshowa
0 .22474 m
.00625 .22474 L
s
[(4)] -0.0125 .22474 1 0 Mshowa
0 .33711 m
.00625 .33711 L
s
[(6)] -0.0125 .33711 1 0 Mshowa
0 .44948 m
.00625 .44948 L
s
[(8)] -0.0125 .44948 1 0 Mshowa
0 .56185 m
.00625 .56185 L
s
[(10)] -0.0125 .56185 1 0 Mshowa
.125 Mabswid
0 .02809 m
.00375 .02809 L
s
0 .05618 m
.00375 .05618 L
s
0 .08428 m
.00375 .08428 L
s
0 .14046 m
.00375 .14046 L
s
0 .16855 m
.00375 .16855 L
s
0 .19665 m
.00375 .19665 L
s
0 .25283 m
.00375 .25283 L
s
0 .28092 m
.00375 .28092 L
s
0 .30902 m
.00375 .30902 L
s
0 .3652 m
.00375 .3652 L
s
0 .39329 m
.00375 .39329 L
s
0 .42139 m
.00375 .42139 L
s
0 .47757 m
.00375 .47757 L
s
0 .50566 m
.00375 .50566 L
s
0 .53376 m
.00375 .53376 L
s
0 .58994 m
.00375 .58994 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(V) show
69.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.04948 0 m
.11328 0 L
.17469 0 L
.20599 0 L
.22249 0 L
.23151 0 L
.23997 0 L
.24381 0 L
.24747 0 L
.24948 0 L
.25062 .00348 L
.25168 .00942 L
.25553 .03107 L
.27267 .12737 L
.30286 .29699 L
.33246 .46332 L
.34057 .50889 L
.34501 .53379 L
.34717 .54595 L
.34914 .55703 L
.35096 .56185 L
.35267 .56185 L
.35646 .56185 L
.36449 .56185 L
.39821 .56185 L
.42998 .56185 L
.49035 .56185 L
.55458 .56185 L
.61643 .56185 L
.67588 .56185 L
.7392 .56185 L
.80014 .56185 L
.86493 .56185 L
.92734 .56185 L
.98736 .56185 L
s
.98736 .56185 m
1 .56185 L
s
.25 .25 1 r
.015 w
.00089 0 Mdot
.00311 0 Mdot
.00535 0 Mdot
.00762 0 Mdot
.00992 0 Mdot
.01223 0 Mdot
.01458 0 Mdot
.01695 0 Mdot
.01935 0 Mdot
.02177 0 Mdot
.02422 0 Mdot
.0267 0 Mdot
.0292 0 Mdot
.03173 0 Mdot
.03429 0 Mdot
.03688 0 Mdot
.0395 0 Mdot
.04214 0 Mdot
.04482 0 Mdot
.04752 0 Mdot
.05026 0 Mdot
.05302 0 Mdot
.05582 0 Mdot
.05864 0 Mdot
.0615 0 Mdot
.06439 0 Mdot
.06731 0 Mdot
.07026 0 Mdot
.07325 0 Mdot
.07626 0 Mdot
.07932 0 Mdot
.0824 0 Mdot
.08552 0 Mdot
.08868 0 Mdot
.09186 0 Mdot
.09509 0 Mdot
.09835 0 Mdot
.10164 0 Mdot
.10498 1e-005 Mdot
.10834 1e-005 Mdot
.11175 1e-005 Mdot
.11519 2e-005 Mdot
.11868 3e-005 Mdot
.1222 4e-005 Mdot
.12576 6e-005 Mdot
.12935 9e-005 Mdot
.13299 .00012 Mdot
.13667 .00018 Mdot
.14039 .00025 Mdot
.14415 .00034 Mdot
.14795 .00047 Mdot
.1518 .00065 Mdot
.15568 .00088 Mdot
.15961 .0012 Mdot
.16358 .00161 Mdot
.1676 .00214 Mdot
.17166 .00283 Mdot
.17577 .00371 Mdot
.17992 .00483 Mdot
.18411 .00624 Mdot
.18836 .00799 Mdot
.19265 .01014 Mdot
.19699 .01277 Mdot
.20137 .01595 Mdot
.2058 .01974 Mdot
.21029 .02423 Mdot
.21482 .02947 Mdot
.2194 .03554 Mdot
.22404 .04248 Mdot
.22872 .05034 Mdot
.23346 .05912 Mdot
.23824 .06883 Mdot
.24308 .07943 Mdot
.24798 .09089 Mdot
.25293 .1031 Mdot
.25793 .11598 Mdot
.26299 .12938 Mdot
.2681 .14316 Mdot
.27328 .15716 Mdot
.2785 .17129 Mdot
.28379 .1855 Mdot
.28913 .19978 Mdot
.29454 .21406 Mdot
.3 .22832 Mdot
.30552 .24252 Mdot
.31111 .25663 Mdot
.31675 .27059 Mdot
.32246 .28439 Mdot
.32823 .29799 Mdot
.33407 .31135 Mdot
.33997 .32444 Mdot
.34593 .33725 Mdot
.35196 .34973 Mdot
.35806 .36187 Mdot
.36423 .37364 Mdot
.37046 .38503 Mdot
.37676 .39602 Mdot
.38313 .4066 Mdot
.38957 .41676 Mdot
.39609 .42648 Mdot
.40267 .43577 Mdot
.40933 .44461 Mdot
.41606 .45302 Mdot
.42287 .46098 Mdot
.42975 .46851 Mdot
.4367 .4756 Mdot
.44374 .48227 Mdot
.45085 .48853 Mdot
.45804 .49438 Mdot
.46531 .49984 Mdot
.47266 .50492 Mdot
.48009 .50963 Mdot
.4876 .51399 Mdot
.49519 .51802 Mdot
.50287 .52173 Mdot
.51064 .52514 Mdot
.51849 .52826 Mdot
.52643 .53111 Mdot
.53445 .53371 Mdot
.54256 .53607 Mdot
.55077 .53821 Mdot
.55906 .54015 Mdot
.56745 .54189 Mdot
.57592 .54346 Mdot
.58449 .54487 Mdot
.59316 .54613 Mdot
.60192 .54725 Mdot
.61078 .54825 Mdot
.61974 .54914 Mdot
.62879 .54993 Mdot
.63795 .55062 Mdot
.6472 .55123 Mdot
.65656 .55177 Mdot
.66603 .55224 Mdot
.67559 .55265 Mdot
.68526 .55301 Mdot
.69504 .55332 Mdot
.70493 .55359 Mdot
.71493 .55382 Mdot
.72503 .55402 Mdot
.73525 .5542 Mdot
.74558 .55434 Mdot
.75603 .55447 Mdot
.76659 .55458 Mdot
.77727 .55467 Mdot
.78806 .55475 Mdot
.79898 .55482 Mdot
.81001 .55487 Mdot
.82117 .55492 Mdot
.83245 .55496 Mdot
.84386 .55499 Mdot
.85539 .55502 Mdot
.86705 .55504 Mdot
.87883 .55506 Mdot
.89075 .55508 Mdot
.9028 .55509 Mdot
.91498 .5551 Mdot
.9273 .55511 Mdot
.93975 .55512 Mdot
.95234 .55512 Mdot
.96507 .55513 Mdot
.97794 .55513 Mdot
.99096 .55513 Mdot
0 1 0 r
.5 Mabswid
0 0 m
.00082 0 L
.00246 0 L
.00426 0 L
.0062 0 L
.00815 0 L
.01027 0 L
.0125 0 L
.01456 0 L
.01651 0 L
.01827 0 L
.0203 0 L
.02222 0 L
.02573 0 L
.0275 0 L
.02945 0 L
.0311 0 L
.03288 0 L
.0361 0 L
.03803 0 L
.04013 0 L
.04198 0 L
.04395 1e-005 L
.04767 1e-005 L
.05112 1e-005 L
.05486 2e-005 L
.0588 3e-005 L
.06217 3e-005 L
.06585 5e-005 L
.06983 7e-005 L
.07408 .0001 L
.0781 .00014 L
.08175 .00019 L
.08544 .00025 L
.08884 .00032 L
.09258 .00042 L
.09654 .00055 L
.1032 .00085 L
.10698 .00108 L
.11052 .00134 L
.11835 .00211 L
.12278 .00269 L
.12689 .00334 L
.13442 .00486 L
.14244 .00707 L
.15032 .00995 L
.15775 .01342 L
.17162 .02232 L
.17896 .02849 L
.18701 .03655 L
Mistroke
.20327 .05724 L
.23237 .10941 L
.29607 .26853 L
.32544 .34276 L
.35738 .41153 L
.37477 .44216 L
.39086 .46606 L
.40721 .4862 L
.42256 .50162 L
.43791 .51409 L
.45198 .52325 L
.4676 .5313 L
.48443 .53791 L
.49989 .54248 L
.51426 .54571 L
.53003 .54837 L
.54687 .55043 L
.56302 .55184 L
.57213 .55245 L
.58052 .55292 L
.59594 .55358 L
.60447 .55386 L
.61226 .55408 L
.62714 .5544 L
.63534 .55453 L
.64312 .55464 L
.65692 .55478 L
.67197 .55489 L
.68037 .55494 L
.68828 .55498 L
.70304 .55503 L
.71132 .55505 L
.71893 .55507 L
.72722 .55508 L
.7361 .5551 L
.74415 .55511 L
.75149 .55511 L
.76583 .55512 L
.77385 .55513 L
.78257 .55513 L
.79074 .55514 L
.7984 .55514 L
.81326 .55514 L
.82115 .55514 L
.82963 .55514 L
.8385 .55514 L
.84692 .55514 L
.85522 .55515 L
.86275 .55515 L
.87784 .55515 L
Mistroke
.88612 .55515 L
.89393 .55515 L
.90783 .55515 L
.91567 .55515 L
.92288 .55515 L
.93028 .55515 L
.93821 .55515 L
.95252 .55515 L
.96126 .55515 L
.96954 .55515 L
.97691 .55515 L
.98506 .55515 L
Mfstroke
.98506 .55515 m
1 .55515 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{413.5, 255.563},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006M0000ob000`400?l00000o`00003oo`3ooonN
0?ooo`00H03oool3@0000080oooo00=000000?ooo`3oool0?@3oool2@00000@0oooo00=000000?oo
o`3oool0?`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo03X0oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0=`3oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool06@3oool00640oooo00I000000?ooo`3ooom000000?oood00
000n0?ooo`03@000003ooom000000080oooo00=000000?oood000000?`3oool00d000000oooo@000
00020?ooo`03@000003ooom0000003d0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood000000>P3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oo
od0000006P3oool005l0oooo14000000103ooom000000?oood00000n0?ooo`03@000003ooom00000
0080oooo00=000000?oood000000?`3oool00d000000oooo@00000020?ooo`03@000003ooom00000
03d0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000>P3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000J0?ooo`00
G`3oool00d000000oooo@00000020?ooo`03@000003ooom0000003h0oooo0T0000030?ooo`03@000
003ooom000000400oooo00M000000?ooo`3oool0oooo@000003ooom0000003d0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood000000>P3oool00d000000oooo0?oo
o`020?ooo`07@000003oool0oooo0?oood000000oooo@000000J0?ooo`00H03oool2@0000080oooo
00=000000?oood000000?P3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000003l0oooo
00=000000?oood0000000P3oool00d000000oooo@000000m0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000020?ooo`03@000003ooom0000003X0oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood0000006P3oool00640oooo00E000000?ooo`3oool0oooo@000
00100?ooo`9000000`3oool00d000000oooo0?ooo`0o0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool0>`3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`0h0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01T0oooo003o
0?oooih0oooo003o0?oooih0oooo003o0?oooih0oooo003o0?oooih0oooo003o0?ooohT0oooo0d00
000B0?ooo`006`3ooola03loool0oooo?@3oool00d000000oooo@000000B0?ooo`006`3oool203lo
ob400?l07@0o?ooo00000280000000=000000?ooo`3oool02`3oool00d000000oooo0?ooo`0@0?oo
o`006`3ooolS03loo`/00?l05@0o?ol50?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool02P3oool00d000000oooo0?ooo`0A0?ooo`00703oool]03loo`D00?l04`0o?ol20?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool03P3oool00d000000oooo0?ooo`0?0?ooo`03@000
003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00d000000oooo0?ooo`0?0?ooo`03@000
003oool0oooo00h0oooo00=000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`03@000
003oool0oooo00l0oooo00=000000?ooo`3oool03P3oool00d000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00l0oooo00=000000?ooo`3oool03P3oool00d000000oooo0?ooo`0?0?ooo`03@000
003oool0oooo00h0oooo00<000000?ooo`3oool02@3oool00d000000oooo@000000B0?ooo`007@3o
ool00`000000oooo0?ooo`0Z0?ooo`@0?coo0`00o`0A03loo`030?oood000000oooo0100oooo00<0
00000?ooo`3oool0<@3oool00d000000oooo0?ooo`140?ooo`03@000003oool0oooo04<0oooo00=0
00000?ooo`3oool0@`3oool00d000000oooo0?ooo`090?ooo`=000004P3oool001d0oooo00<00000
0?ooo`3oool0<@3oool2003o00H0oooo2`0o?olA0?ooo`030000003oool0oooo0?l0oooo9P3oool0
01d0oooo00<000000?ooo`3oool0<`3oool2003o00L0oooo2@0o?ol@0?ooo`030000003oool0oooo
0?l0oooo9P3oool001d0oooo00<000000?ooo`3oool0=@3oool2003o00P0oooo200o?ol?0?ooo`03
0000003oool0oooo0?l0oooo9@3oool001d0oooo00<000000?ooo`3oool0=`3oool2003o00P0oooo
1P0o?ol?0?ooo`030000003oool0oooo0?l0oooo9@3oool001d0oooo00<000000?ooo`3oool0>@3o
ool00`00o`00oooo0?ooo`060?ooo`L0?coo3@3oool00`000000oooo0?ooo`3o0?ooobD0oooo000M
0?ooo`030000003oool0oooo03X0oooo0P00o`080?ooo`D0?coo3@3oool00`000000oooo0?ooo`3o
0?ooobD0oooo000M0?ooo`03000004000000oooo03`0oooo00<00?l00?ooo`3oool01P3oool503lo
o`d0oooo00<000000?ooo`3oool0o`3ooolT0?ooo`007@3oool00`000000oooo0?ooo`0m0?ooo`03
003o003oool0oooo00H0oooo100o?ol=0?ooo`030000003oool0oooo0?l0oooo903oool001d0oooo
00<000000?ooo`3oool0?@3oool00`00o`00oooo0?ooo`060?ooo`H0?coo2`3oool00`000000oooo
0?ooo`3o0?ooob@0oooo000M0?ooo`030000003oool0oooo03h0oooo00<00?l00?ooo`3oool01P3o
ool503loo`/0oooo00<000000?ooo`3oool0o`3ooolT0?ooo`007@3oool00`000000oooo0?ooo`0o
0?ooo`03003o003oool0oooo00H0oooo1@0o?ol;0?ooo`030000003oool0oooo0?l0oooo8`3oool0
01d0oooo00<000000?ooo`3oool0@03oool00`00o`00oooo0?ooo`060?ooo`@0?coo2`3oool00`00
0000oooo0?ooo`3o0?ooob<0oooo000M0?ooo`030000003oool0oooo0440oooo00<00?l00?ooo`3o
ool01@3oool403loo`/0oooo00<000000?ooo`3oool0o`3ooolS0?ooo`007@3oool00`000000oooo
0?ooo`110?ooo`03003o003oool0oooo00H0oooo1@0o?ol90?ooo`030000003oool0oooo0?l0oooo
8`3oool001d0oooo00<000000?ooo`3oool0@P3oool00`00o`00oooo0?ooo`060?ooo`@0?coo2@3o
ool00`000000oooo0?ooo`3o0?ooob<0oooo000M0?ooo`030000003oool0oooo04<0oooo00<00?l0
0?ooo`3oool01@3oool403loo`T0oooo00<000000?ooo`3oool0o`3ooolS0?ooo`007@3oool00`00
001000000?ooo`140?ooo`03003o003oool0oooo00D0oooo1@0o?ol80?ooo`030000003oool0oooo
0?l0oooo8P3oool001d0oooo00<000000?ooo`3oool0A@3oool00`00o`00oooo0?ooo`050?ooo`@0
?coo203oool00`000000oooo0?ooo`3o0?ooob80oooo000M0?ooo`030000003oool0oooo04D0oooo
00<00?l00?ooo`3oool01@3oool403loo`P0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`007@3o
ool00`000000oooo0?ooo`160?ooo`03003o003oool0oooo00D0oooo0P0o?ol90?ooo`030000003o
ool0oooo0?l0oooo8P3oool001d0oooo00<000000?ooo`3oool0AP3oool00`00o`00oooo0?ooo`05
0?ooo`@0?coo1`3oool00`000000oooo0?ooo`3o0?ooob80oooo000M0?ooo`030000003oool0oooo
04L0oooo00<00?l00?ooo`3oool0103oool403loo`L0oooo00<000000?ooo`3oool0o`3ooolR0?oo
o`007@3oool00`000000oooo0?ooo`170?ooo`03003o003oool0oooo00@0oooo100o?ol80?ooo`03
0000003oool0oooo0?l0oooo8@3oool001d0oooo00<000000?ooo`3oool0B03oool00`00o`00oooo
0?ooo`040?ooo`D0?coo1P3oool00`000000oooo0?ooo`3o0?ooob40oooo000M0?ooo`030000003o
ool0oooo04P0oooo00<00?l00?ooo`3oool01@3oool403loo`H0oooo00<000000?ooo`3oool0o`3o
oolQ0?ooo`007@3oool00`000000oooo0?ooo`190?ooo`03003o003oool0oooo00@0oooo100o?ol6
0?ooo`030000003oool0oooo0?l0oooo8@3oool001d0oooo00<00000@000003oool0B@3oool00`00
o`00oooo0?ooo`050?ooo`80?coo1`3oool00`000000oooo0?ooo`3o0?ooob40oooo000M0?ooo`03
0000003oool0oooo04X0oooo00<00?l00?ooo`3oool01@3oool403loo`D0oooo00<000000?ooo`3o
ool0o`3ooolP0?ooo`007@3oool00`000000oooo0?ooo`1:0?ooo`03003o003oool0oooo00D0oooo
100o?ol50?ooo`030000003oool0oooo0?l0oooo803oool001d0oooo00<000000?ooo`3oool0B`3o
ool00`00o`00oooo0?ooo`040?ooo`@0?coo1@3oool00`000000oooo0?ooo`3o0?ooob00oooo000M
0?ooo`030000003oool0oooo04/0oooo00<00?l00?ooo`3oool01@3oool203loo`H0oooo00<00000
0?ooo`3oool0o`3ooolP0?ooo`007@3oool00`000000oooo0?ooo`1<0?ooo`03003o003oool0oooo
00`0oooo00<000000?ooo`3oool0o`3ooolP0?ooo`007@3oool00`000000oooo0?ooo`1<0?ooo`03
003o003oool0oooo00D0oooo100o?ol30?ooo`030000003oool0oooo0?l0oooo803oool001d0oooo
00<000000?ooo`3oool0C@3oool00`00o`00oooo0?ooo`040?ooo`@0?coo103oool00`000000oooo
0?ooo`3o0?oooal0oooo000D0?ooo`=000001P3oool00`000000oooo0?ooo`1=0?ooo`03003o003o
ool0oooo00@0oooo100o?ol40?ooo`030000003oool0oooo0?l0oooo7`3oool001@0oooo00=00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`1>0?ooo`03003o003oool0oooo00@0oooo0P0o?ol5
0?ooo`030000003oool0oooo0?l0oooo7`3oool001D0oooo00=000000?ooo`3oool01@3oool20000
0003@000003oool0oooo04`0oooo00<00?l00?ooo`3oool0103oool403loo`<0oooo00<000000?oo
o`3oool0o`3ooolO0?ooo`005@3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo04l0
oooo00<00?l00?ooo`3oool00`3oool403loo`<0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`00
503oool00d000000oooo@00000060?ooo`030000003oool0oooo04l0oooo00<00?l00?ooo`3oool0
0`3oool403loo`<0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`005@3oool00d000000oooo0?oo
o`050?ooo`030000003oool0oooo0500oooo00<00?l00?ooo`3oool00`3oool203loo`D0oooo00<0
00000?ooo`3oool0o`3ooolN0?ooo`007@3oool00`000000oooo0?ooo`1@0?ooo`03003o003oool0
oooo00X0oooo00<000000?ooo`3oool0o`3ooolN0?ooo`007@3oool00`000000oooo0?ooo`1@0?oo
o`03003o003oool0oooo00@0oooo100o?ol20?ooo`030000003oool0oooo0?l0oooo7P3oool001d0
oooo00<000000?ooo`3oool0D@3oool00`00o`00oooo0?ooo`030?ooo`@0?coo0P3oool00`000000
oooo0?ooo`3o0?oooah0oooo000M0?ooo`030000003oool0oooo0540oooo00<00?l00?ooo`3oool0
0`3oool403loo`80oooo00<000000?ooo`3oool0o`3ooolN0?ooo`007@3oool00`000000oooo0?oo
o`1B0?ooo`03003o003oool0oooo00<0oooo0P0o?ol40?ooo`030000003oool0oooo0?l0oooo7@3o
ool001d0oooo00<000000?ooo`3oool0DP3oool00`00o`00oooo0?ooo`090?ooo`030000003oool0
oooo0?l0oooo7@3oool001d0oooo00<00000@000003oool0D`3oool00`00o`00oooo0?ooo`030?oo
o`@0?coo00<0oooo0000003oool0o`3ooolN0?ooo`007@3oool00`000000oooo0?ooo`1C0?ooo`03
003o003oool0oooo00<0oooo100o?ol00`3oool000000?ooo`3o0?oooah0oooo000M0?ooo`030000
003oool0oooo05<0oooo00<00?l00?ooo`3oool00`3oool403loo`030?ooo`000000oooo0?l0oooo
7P3oool001d0oooo00<000000?ooo`3oool0E03oool00`00o`00oooo0?ooo`030?ooo`80?coo0P3o
ool00`000000oooo0?ooo`3o0?oooad0oooo000M0?ooo`030000003oool0oooo05@0oooo00<00?l0
0?ooo`3oool0203oool00`000000oooo0?ooo`3o0?oooa`0oooo000M0?ooo`030000003oool0oooo
05D0oooo00<00?l00?ooo`3oool00`3oool403loo`030000003oool0oooo0?l0oooo703oool001d0
oooo00<000000?ooo`3oool0E@3oool00`00o`00oooo0?ooo`030?ooo`@0?coo00<000000?ooo`3o
ool0o`3ooolL0?ooo`007@3oool00`000000oooo0?ooo`1E0?ooo`03003o003oool0oooo00<0oooo
100o?ol00`000000oooo0?ooo`3o0?oooa`0oooo000M0?ooo`030000003oool0oooo05H0oooo00<0
0?l00?ooo`3oool00`3oool203loo`030?ooo`000000oooo0?l0oooo7@3oool001d0oooo00<00000
0?ooo`3oool0EP3oool00`00o`00oooo0?ooo`060?ooo`030000003oool0oooo0?l0oooo703oool0
01d0oooo00<00000@000003oool0E`3oool00`00o`00oooo0?ooo`030?ooo`@0?cooo`3ooolM0?oo
o`007@3oool00`000000oooo0?ooo`1G0?ooo`03003o003oool0oooo00<0oooo100o?ooo0?oooad0
oooo000M0?ooo`030000003oool0oooo05L0oooo00<00?l00?ooo`3oool00`3oool403loool0oooo
7@3oool001d0oooo00<000000?ooo`3oool0F03oool00`00o`00oooo0?ooo`030?ooo`80?coo00<0
00000?ooo`3oool0o`3ooolK0?ooo`007@3oool00`000000oooo0?ooo`1H0?ooo`03003o003oool0
oooo00D0oooo00<000000?ooo`3oool0o`3ooolK0?ooo`007@3oool00`000000oooo0?ooo`1I0?oo
o`03003o003oool0oooo0080oooo100o?ooo0?oooa`0oooo000M0?ooo`030000003oool0oooo05T0
oooo00<00?l00?ooo`3oool00P3oool403loool0oooo703oool001d0oooo00<000000?ooo`3oool0
FP3oool01000o`00oooo0?ooo`3oool403loool0oooo703oool001d0oooo00<000000?ooo`3oool0
FP3oool00`00o`00oooo0?ooo`020?ooo`80?coo00<000000?ooo`3oool0o`3ooolJ0?ooo`007@3o
ool00`00001000000?ooo`1J0?ooo`03003o003oool0oooo00@0oooo00<000000?ooo`3oool0o`3o
oolJ0?ooo`007@3oool00`000000oooo0?ooo`1K0?ooo`03003o003oool0oooo0080oooo100o?ooo
0?oooaX0oooo000M0?ooo`030000003oool0oooo05/0oooo00<00?l00?ooo`3oool00P3oool403lo
ool0oooo6P3oool001d0oooo00<000000?ooo`3oool0G03oool01000o`00oooo0?ooo`3oool403lo
ool0oooo6P3oool001d0oooo00<000000?ooo`3oool0G03oool00`00o`00oooo0?ooo`020?ooo`80
?cooo`3ooolK0?ooo`007@3oool00`000000oooo0?ooo`1L0?ooo`03003o003oool0oooo00<0oooo
00<000000?ooo`3oool0o`3ooolI0?ooo`007@3oool00`000000oooo0?ooo`1M0?ooo`03003o003o
ool0oooo0080oooo100o?ooo0?oooaP0oooo000M0?ooo`030000003oool0oooo05d0oooo00<00?l0
0?ooo`3oool00P3oool403loool0oooo603oool001D0oooo0d0000050?ooo`030000003oool0oooo
05h0oooo00@00?l00?ooo`3oool0oooo100o?ooo0?oooaP0oooo000F0?ooo`03@000003oool0oooo
00@0oooo00<000000?ooo`3oool0GP3oool00`00o`00oooo0?ooo`020?ooo`80?cooo`3ooolI0?oo
o`00503oool4@00000D0oooo0P0000000d000000oooo0?ooo`1L0?ooo`03003o003oool0oooo0080
oooo00<000000?ooo`3oool0o`3ooolH0?ooo`00503oool00d000000oooo@00000060?ooo`030000
003oool0oooo05l0oooo00D00?l00?ooo`3oool0oooo0000000403loool0oooo5P3oool001D0oooo
0T0000060?ooo`030000003oool0oooo05l0oooo00D00?l00?ooo`3oool0oooo0000000403loool0
oooo5P3oool001H0oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`1P0?ooo`04003o
003oool0oooo000000@0?cooo`3ooolF0?ooo`007@3oool00`000000oooo0?ooo`1P0?ooo`05003o
003oool0oooo0000003oool00P0o?ooo0?oooaL0oooo000M0?ooo`030000003oool0oooo0600oooo
00D00?l00?ooo`3oool0oooo0000003o0?oooaT0oooo000M0?ooo`030000003oool0oooo0640oooo
00D00?l00?ooo`3oool000000?ooo`0403loool0oooo503oool001d0oooo00<000000?ooo`3oool0
H@3oool01@00o`00oooo0?ooo`000000oooo00@0?cooo`3ooolD0?ooo`007@3oool00`000000oooo
0?ooo`1R0?ooo`04003o003oool000000?ooo`@0?cooo`3ooolD0?ooo`007@3oool00`000000oooo
0?ooo`1R0?ooo`03003o003oool000000080oooo0P0o?ooo0?oooaD0oooo000M0?ooo`0300000400
0000oooo06<0oooo00<00?l00000003oool0o`3ooolH0?ooo`007@3oool00`000000oooo0?ooo`1S
0?ooo`03003o003oool000000080oooo100o?ooo0?oooa80oooo000M0?ooo`030000003oool0oooo
06<0oooo00<00?l00?ooo`0000000P3oool403loool0oooo4P3oool001d0oooo00<000000?ooo`3o
ool0I03oool01000o`0000000?ooo`3oool403loool0oooo4P3oool001d0oooo00<000000?ooo`3o
ool0I03oool00`00o`0000000?ooo`020?ooo`80?cooo`3ooolC0?ooo`007@3oool00`000000oooo
0?ooo`1U0?ooo`03003o003oool0oooo0?l0oooo5P3oool001d0oooo00<000000?ooo`3oool0I@3o
ool00`00o`00oooo0?ooo`020?ooo`@0?cooo`3oool@0?ooo`007@3oool00`000000oooo0?ooo`1U
0?ooo`03003o00000000oooo0080oooo100o?ooo0?oooa00oooo000M0?ooo`030000003oool0oooo
06H0oooo00@00?l00?ooo`3oool0oooo100o?ooo0?oooa00oooo000M0?ooo`030000003oool0oooo
06H0oooo00<00?l00?ooo`3oool00P3oool203loool0oooo4@3oool001d0oooo00<00000@000003o
ool0IP3oool00`0000000?l00?ooo`030?ooo`@0?cooo`3oool>0?ooo`007@3oool00`000000oooo
0?ooo`1V0?ooo`0300000000o`00oooo00<0oooo100o?ooo0?ooo`h0oooo000M0?ooo`030000003o
ool0oooo06H0oooo00<00000003o003oool00`3oool403loool0oooo3P3oool001d0oooo00<00000
0?ooo`3oool0I`3oool00`0000000?l00?ooo`030?ooo`80?cooo`3oool?0?ooo`007@3oool00`00
0000oooo0?ooo`1W0?ooo`0300000000o`00oooo0?l0oooo503oool001d0oooo00<000000?ooo`3o
ool0I`3oool00`0000000?l00?ooo`040?ooo`@0?cooo`3oool<0?ooo`007@3oool00`000000oooo
0?ooo`1W0?ooo`030000003oool00?l000@0oooo100o?ooo0?ooo``0oooo000M0?ooo`030000003o
ool0oooo06L0oooo00<000000?ooo`00o`00103oool403loool0oooo303oool001d0oooo00<00000
0?ooo`3oool0I`3oool010000000oooo0?ooo`00o`040?ooo`80?cooo`3oool=0?ooo`007@3oool0
0`000000oooo0?ooo`1X0?ooo`030000003oool00?l00?l0oooo4`3oool001d0oooo00<00000@000
003oool0J03oool00`000000oooo003o00050?ooo`@0?cooo`3oool:0?ooo`007@3oool00`000000
oooo0?ooo`1X0?ooo`040000003oool0oooo003o00@0oooo100o?ooo0?ooo`X0oooo000M0?ooo`03
0000003oool0oooo06P0oooo00@000000?ooo`3oool00?l0103oool403loool0oooo2P3oool001d0
oooo00<000000?ooo`3oool0J03oool01@000000oooo0?ooo`3oool00?l000@0oooo0P0o?ooo0?oo
o`/0oooo000M0?ooo`030000003oool0oooo06T0oooo00@000000?ooo`3oool00?l0o`3ooolA0?oo
o`007@3oool00`000000oooo0?ooo`1Y0?ooo`040000003oool0oooo003o00D0oooo100o?ooo0?oo
o`P0oooo000M0?ooo`030000003oool0oooo06T0oooo00D000000?ooo`3oool0oooo003o00040?oo
o`@0?cooo`3oool80?ooo`007@3oool00`000000oooo0?ooo`1Y0?ooo`050000003oool0oooo0?oo
o`00o`00103oool403loool0oooo203oool001@0oooo0T0000070?ooo`030000003oool0oooo06T0
oooo00D000000?ooo`3oool0oooo003o00050?ooo`80?cooo`3oool90?ooo`00503oool00d000000
oooo@00000060?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool00P3oool00`00o`00
oooo0?ooo`030?ooo`@0?cooo`3oool60?ooo`00503oool00d000000oooo@00000060?ooo`800000
00=000000?ooo`3oool0J03oool01@000000oooo0?ooo`3oool00?l000D0oooo100o?ooo0?ooo`H0
oooo000D0?ooo`9000001`3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo0080oooo
00<00?l00?ooo`3oool00P3oool403loool0oooo1P3oool001@0oooo00=000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo0080oooo00<00?l00?ooo`3oool00`3o
ool203loool0oooo1`3oool001D0oooo0T0000060?ooo`030000003oool0oooo06X0oooo00<00000
0?ooo`3oool00P3oool00`00o`00oooo0?ooo`040?ooo`@0?cooo`3oool40?ooo`007@3oool00`00
0000oooo0?ooo`1Z0?ooo`030000003oool0oooo00<0oooo00<00?l00?ooo`3oool00`3oool403lo
ool0oooo103oool001d0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`020?ooo`03
003o003oool0oooo00<0oooo100o?ooo0?ooo`@0oooo000M0?ooo`030000003oool0oooo06/0oooo
00<000000?ooo`3oool00`3oool00`00o`00oooo0?ooo`030?ooo`80?cooo`3oool50?ooo`007@3o
ool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo00<0oooo00<00?l00?ooo`3oool0o`3o
ool:0?ooo`007@3oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo00@0oooo00<00?l0
0?ooo`3oool0103oool403loool0oooo0@3oool001d0oooo00<000000?ooo`3oool0J`3oool00`00
0000oooo0?ooo`040?ooo`03003o003oool0oooo00@0oooo100o?ooo0?ooo`40oooo000M0?ooo`03
000004000000oooo06`0oooo00<000000?ooo`3oool0103oool00`00o`00oooo0?ooo`030?ooo`@0
?cooo`3oool10?ooo`007@3oool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo00@0oooo
00<00?l00?ooo`3oool0103oool203loool0oooo0P3oool001d0oooo00<000000?ooo`3oool0K03o
ool00`000000oooo0?ooo`050?ooo`03003o003oool0oooo00@0oooo100o?oon0?ooo`007@3oool0
0`000000oooo0?ooo`1/0?ooo`030000003oool0oooo00D0oooo00<00?l00?ooo`3oool0103oool4
03loooh0oooo000M0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool01P3oool00`00
o`00oooo0?ooo`030?ooo`@0?coooP3oool001d0oooo00<000000?ooo`3oool0K@3oool00`000000
oooo0?ooo`050?ooo`03003o003oool0oooo00@0oooo0P0o?ooo0?ooo`007@3oool00`000000oooo
0?ooo`1]0?ooo`030000003oool0oooo00D0oooo00<00?l00?ooo`3oool01@3oool403looo`0oooo
000M0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool01P3oool00`00o`00oooo0?oo
o`040?ooo`@0?cooo03oool001d0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`06
0?ooo`03003o003oool0oooo00@0oooo100o?ool0?ooo`007@3oool00`000000oooo0?ooo`1]0?oo
o`030000003oool0oooo00L0oooo00<00?l00?ooo`3oool0103oool203loood0oooo000M0?ooo`03
000004000000oooo06d0oooo00<000000?ooo`3oool01`3oool00`00o`00oooo0?ooo`050?ooo`@0
?coonP3oool001d0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?ooo`070?ooo`03003o
003oool0oooo00@0oooo100o?ooj0?ooo`007@3oool00`000000oooo0?ooo`1^0?ooo`030000003o
ool0oooo00L0oooo00<00?l00?ooo`3oool0103oool403loooX0oooo000M0?ooo`030000003oool0
oooo06h0oooo00<000000?ooo`3oool0203oool00`00o`00oooo0?ooo`040?ooo`D0?coon03oool0
01d0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?ooo`080?ooo`03003o003oool0oooo
00D0oooo100o?ooh0?ooo`007@3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo00T0
oooo00<00?l00?ooo`3oool0103oool403loooP0oooo000M0?ooo`030000003oool0oooo06l0oooo
00<000000?ooo`3oool0203oool00`00o`00oooo0?ooo`050?ooo`80?coon@3oool001d0oooo00<0
00000?ooo`3oool0K`3oool00`000000oooo0?ooo`090?ooo`03003o003oool0oooo00H0oooo100o
?ooe0?ooo`007@3oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo00T0oooo00<00?l0
0?ooo`3oool01P3oool403loooD0oooo000M0?ooo`030000003oool0oooo06l0oooo00<000000?oo
o`3oool02P3oool00`00o`00oooo0?ooo`050?ooo`@0?coom@3oool001d0oooo00<00000@000003o
ool0K`3oool00`000000oooo0?ooo`0;0?ooo`03003o003oool0oooo00D0oooo1@0o?ooc0?ooo`00
7@3oool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo00X0oooo00<00?l00?ooo`3oool0
1P3oool403looo<0oooo000M0?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool02`3o
ool00`00o`00oooo0?ooo`050?ooo`@0?cool`3oool001d0oooo00<000000?ooo`3oool0L03oool0
0`000000oooo0?ooo`0;0?ooo`03003o003oool0oooo00H0oooo0P0o?ood0?ooo`007@3oool00`00
0000oooo0?ooo`1`0?ooo`030000003oool0oooo00`0oooo00<00?l00?ooo`3oool01P3oool403lo
oo40oooo000M0?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool03@3oool00`00o`00
oooo0?ooo`050?ooo`@0?cool@3oool001d0oooo00<000000?ooo`3oool0L03oool00`000000oooo
0?ooo`0=0?ooo`03003o003oool0oooo00D0oooo100o?ooa0?ooo`005@3oool00d000000oooo0?oo
o`050?ooo`030000003oool0oooo0740oooo00<000000?ooo`3oool03@3oool00`00o`00oooo0?oo
o`050?ooo`H0?cookP3oool001@0oooo00=000000?oood0000001P3oool00`000000oooo0?ooo`1a
0?ooo`030000003oool0oooo00h0oooo00<00?l00?ooo`3oool01P3oool403loonh0oooo000D0?oo
o`03@000003ooom0000000H0oooo0P0000000d000000oooo0?ooo`1_0?ooo`030000003oool0oooo
00h0oooo00<00?l00?ooo`3oool01P3oool403loonh0oooo000E0?ooo`03@000003oool0oooo00D0
oooo00<000000?ooo`3oool0L@3oool00`000000oooo0?ooo`0?0?ooo`03003o003oool0oooo00H0
oooo1@0o?oo/0?ooo`00503oool00d000000oooo@00000060?ooo`030000003oool0oooo0740oooo
00<000000?ooo`3oool0403oool00`00o`00oooo0?ooo`060?ooo`@0?cook03oool001D0oooo00=0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo00l0oooo00<0
0?l00?ooo`3oool01P3oool403loon`0oooo000M0?ooo`030000003oool0oooo0780oooo00<00000
0?ooo`3oool0403oool00`00o`00oooo0?ooo`060?ooo`D0?coojP3oool001d0oooo00<000000?oo
o`3oool0LP3oool00`000000oooo0?ooo`0@0?ooo`03003o003oool0oooo00L0oooo100o?ooZ0?oo
o`007@3oool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo0140oooo00<00?l00?ooo`3o
ool01P3oool703loonL0oooo000M0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0
4P3oool00`00o`00oooo0?ooo`060?ooo`H0?cooi`3oool001d0oooo00<000000?ooo`3oool0LP3o
ool00`000000oooo0?ooo`0C0?ooo`03003o003oool0oooo00L0oooo100o?ooW0?ooo`007@3oool0
0`000000oooo0?ooo`1c0?ooo`030000003oool0oooo01<0oooo00<00?l00?ooo`3oool01`3oool5
03loonD0oooo000M0?ooo`03000004000000oooo07<0oooo00<000000?ooo`3oool04`3oool00`00
o`00oooo0?ooo`080?ooo`@0?cooi@3oool001d0oooo00<000000?ooo`3oool0L`3oool00`000000
oooo0?ooo`0D0?ooo`03003o003oool0oooo00L0oooo1`0o?ooR0?ooo`007@3oool00`000000oooo
0?ooo`1c0?ooo`030000003oool0oooo01D0oooo00<00?l00?ooo`3oool01`3oool603loon80oooo
000M0?ooo`030000003oool0oooo07<0oooo00<000000?ooo`3oool05P3oool00`00o`00oooo0?oo
o`080?ooo`H0?cooh03oool001d0oooo00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`0G
0?ooo`03003o003oool0oooo00P0oooo1@0o?ooP0?ooo`007@3oool00`000000oooo0?ooo`1c0?oo
o`030000003oool0oooo01P0oooo00<00?l00?ooo`3oool0203oool703loomd0oooo000M0?ooo`03
0000003oool0oooo07<0oooo00<000000?ooo`3oool06@3oool00`00o`00oooo0?ooo`080?ooo`H0
?coog@3oool001d0oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`0H0?ooo`03003o
003oool0oooo00X0oooo1P0o?ooK0?ooo`007@3oool00`000000oooo0?ooo`1d0?ooo`030000003o
ool0oooo01T0oooo00<00?l00?ooo`3oool02P3oool503loom/0oooo000M0?ooo`030000003oool0
oooo07@0oooo00<000000?ooo`3oool06P3oool00`00o`00oooo0?ooo`0:0?ooo`L0?coof03oool0
01d0oooo00<00000@000003oool0M03oool00`000000oooo0?ooo`0K0?ooo`800?l02`3oool603lo
omP0oooo000M0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool07@3oool00`00o`00
oooo0?ooo`0:0?ooo`H0?cooeP3oool001d0oooo00<000000?ooo`3oool0M03oool00`000000oooo
0?ooo`0N0?ooo`800?l02`3oool803loom<0oooo000M0?ooo`030000003oool0oooo07@0oooo00<0
00000?ooo`3oool0803oool00`00o`00oooo0?ooo`090?ooo`L0?cood`3oool001d0oooo00<00000
0?ooo`3oool0M@3oool00`000000oooo0?ooo`0P0?ooo`800?l02P3oool903loom00oooo000M0?oo
o`030000003oool0oooo07D0oooo00<000000?ooo`3oool08P3oool2003o00/0oooo200o?oo>0?oo
o`007@3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo02@0oooo00<00?l00?ooo`3o
ool02P3oool903lool/0oooo000M0?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool0
9@3oool2003o00/0oooo2`0o?oo80?ooo`007@3oool00`000000oooo0?ooo`1f0?ooo`030000003o
ool0oooo02H0oooo0P00o`0;0?ooo``0?cooa@3oool001d0oooo00<000000?ooo`3oool0MP3oool0
0`000000oooo0?ooo`0X0?ooo`03003o003oool0oooo00/0oooo300o?oo20?ooo`007@3oool00`00
001000000?ooo`1f0?ooo`030000003oool0oooo02T0oooo0P00o`0>0?ooo`/0?coo`03oool001d0
oooo00<000000?ooo`3oool0MP3oool00`000000oooo0?ooo`0[0?ooo`800?l03`3oool>03lookX0
oooo000M0?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0;03oool4003o00h0oooo
3P0o?ong0?ooo`007@3oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo0300oooo1P00
o`0:0?oooa80?coo/@3oool001d0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`0f
0?ooo`D00?l0203oool203loo`030?ooo`0o?ol0?coo01<0?cooZ03oool001d0oooo00<000000?oo
o`3oool0M`3oool00`000000oooo0?ooo`0k0?ooo`D00?l02@3ooolO03looi/0oooo000M0?ooo`03
0000003oool0oooo07L0oooo00<000000?ooo`3oool0@03oool;003o00040?ooo`0o?ol0?coo0?oo
ocl0?cooM@3oool001d0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1;0?ooobH0
0?l0@00o?ol00`3oool0?coo03loo`0B03loo`030?ooo`0o?ol0?coo00H0?coo00<0oooo03loo`0o
?ol01P0o?ol00`3oool0?coo03loo`0603loob80oooo000>0?ooo`E000000P3oool00d000000oooo
0?ooo`050?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0G03oool203loo`040?oo
o`0o?ol0?coo0?ooo`80?coo00<0oooo03loo`0o?ol02P0o?omb003o0200oooo000@0?ooo`07@000
003oool0oooo0?oood000000oooo@00000060?ooo`030000003oool0oooo07P0oooo00<000000?oo
o`3oool0I`3oool203loo`80oooo0P0o?ol00`3oool0?coo03loo`020?ooo`80?coo00<0oooo03lo
o`0o?ol00P3oool203loo`030?ooo`0o?ol0?coo0080oooo0P0o?ol00`3oool0?coo03loo`020?oo
o`80?coo00@0oooo03loo`0o?ol0oooo8`0o?ol00`3oool0?coo03loo`0B03loo`030?ooo`0o?ol0
?coo00H0?coo00<0oooo03loo`0o?ol01P0o?ol00`3oool0?coo03loo`0603loob80oooo000@0?oo
o`07@000003oool0oooo0?oood000000oooo@00000060?ooo`80000000=000000?ooo`3oool0MP3o
oonA00000080?coo0P00000203loo`8000000P0o?ol200000080?coo00<0000003loo`0o?ol00P00
000203loo`8000000P0o?ol200000080?coo0P00000203loo`<000000P0o?ol200000080?coo0P00
000203loo`8000000P0o?ol200000080?coo0`00000203loo`8000000P0o?ol300000080?coo0P00
000203loo`<000000P0o?ol200000080?coo0P0000000d000000oooo0?ooo`0N0?ooo`00403oool0
1d000000oooo0?ooo`3ooom000000?oood0000001P3oool00`000000oooo0?ooo`3o0?ooogh0oooo
000@0?ooo`07@000003oool0oooo0?oood000000oooo@00000060?ooo`030000003oool0oooo0?l0
ooooOP3oool000l0oooo0T0000040?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool0
o`3ooomn0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogh0oooo000M0?ooo`030000003oool0
oooo0?l0ooooOP3oool001d0oooo00<000000?ooo`3oool0o`3ooomn0?ooo`007@3oool00`000000
oooo0?ooo`3o0?ooogh0oooo000M0?ooo`030000003oool0oooo0?l0ooooOP3oool001d0oooo00<0
00000?ooo`3oool0o`3ooomn0?ooo`007@3oool00`00001000000?ooo`3o0?ooogh0oooo000M0?oo
o`030000003oool0oooo0?l0ooooOP3oool001d0oooo00<000000?ooo`3oool0o`3ooomn0?ooo`00
7@3oool00`000000oooo0?ooo`3o0?ooogh0oooo000M0?ooo`030000003oool0oooo0?l0ooooOP3o
ool001d0oooo00<000000?ooo`3oool0o`3ooomn0?ooo`007@3oool00`000000oooo0?ooo`3o0?oo
ogh0oooo000M0?ooo`030000003oool0oooo0?l0ooooOP3oool001d0oooo00<000000?ooo`3oool0
o`3ooomn0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogh0oooo000M0?ooo`03@000003oool0
oooo0?l0ooooOP3oool00?l0ooooWP3oool00?l0ooooWP3oool00?l0ooooWP3oool00?l0ooooWP3o
ool00?l0ooooWP3oool00?l0ooooWP3oool00?l0ooooWP3oool00?l0ooooWP3oool00?l0ooooWP3o
ool00?l0ooooWP3oool00?l0ooooWP3oool00?l0ooooWP3oool00?l0ooooWP3oool001/0oooo0T00
003o0?oooh40oooo000J0?ooo`03@000003ooom000000?l0ooooP@3oool001X0oooo00=000000?oo
od000000o`3ooon10?ooo`006P3oool014000000oooo0?oood00003o0?oooh00oooo000I0?ooo`05
@000003oool0oooo0?oood000000o`3ooon00?ooo`006@3oool2@00000030?oood00001000000?l0
ooooP03oool00?l0ooooWP3oool00?l0ooooWP3oool00?l0ooooWP3oool00?l0ooooWP3oool00001
\
\>"],
  ImageRangeCache->{{{0, 412.5}, {254.563, 0}} -> {11.6996, -0.677978, 
  0.284321, 0.0506044}}]
}, Open  ]],

Cell[TextData[
"\"Err - rozdiel medzi explicitn\[YAcute]m rie\.9aen\[IAcute]m a na\.9aim v\
\[YAcute]sledkom\ntr1: tabu\:017eka chyby pribli\.9en\[EAcute]ho \
rie\.9aenia\""], "Text"],

Cell["\<\
Err[i_,sgm_]:=SpreadBull[xs[[i]],X1,X2,sgm,r,DD,t]-ys[[i]];
tr1:=Table[{xs[[i]],Err[i,sigma]},{i,2m+1}];\
\>", "Input"],

Cell["\"Maximov\[AAcute] chyba\"", "Text"],

Cell["\<\
Print[\"m = \",m,\" n = \",n,\" trans = \",trans,\" Max.chyba = \
\",Max[Table[Abs[Err[i,str]],{i,2m+1}]]]\
\>", "Input"],

Cell["\"Graf chyby s delen\[IAcute]m m =100, n=100.\" ", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=ListPlot[tr1,PlotStyle->{PointSize[0.02],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->All]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0952381 0.00714286 0.313552 51.2848 [
[.19048 .30105 -6 -9 ]
[.19048 .30105 6 0 ]
[.33333 .30105 -6 -9 ]
[.33333 .30105 6 0 ]
[.47619 .30105 -6 -9 ]
[.47619 .30105 6 0 ]
[.61905 .30105 -9 -9 ]
[.61905 .30105 9 0 ]
[.7619 .30105 -9 -9 ]
[.7619 .30105 9 0 ]
[.90476 .30105 -9 -9 ]
[.90476 .30105 9 0 ]
[.03512 .00584 -36 -4.5 ]
[.03512 .00584 0 4.5 ]
[.03512 .10841 -36 -4.5 ]
[.03512 .10841 0 4.5 ]
[.03512 .21098 -36 -4.5 ]
[.03512 .21098 0 4.5 ]
[.03512 .41612 -30 -4.5 ]
[.03512 .41612 0 4.5 ]
[.03512 .51869 -30 -4.5 ]
[.03512 .51869 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.19048 .31355 m
.19048 .3198 L
s
[(40)] .19048 .30105 0 1 Mshowa
.33333 .31355 m
.33333 .3198 L
s
[(60)] .33333 .30105 0 1 Mshowa
.47619 .31355 m
.47619 .3198 L
s
[(80)] .47619 .30105 0 1 Mshowa
.61905 .31355 m
.61905 .3198 L
s
[(100)] .61905 .30105 0 1 Mshowa
.7619 .31355 m
.7619 .3198 L
s
[(120)] .7619 .30105 0 1 Mshowa
.90476 .31355 m
.90476 .3198 L
s
[(140)] .90476 .30105 0 1 Mshowa
.125 Mabswid
.08333 .31355 m
.08333 .3173 L
s
.11905 .31355 m
.11905 .3173 L
s
.15476 .31355 m
.15476 .3173 L
s
.22619 .31355 m
.22619 .3173 L
s
.2619 .31355 m
.2619 .3173 L
s
.29762 .31355 m
.29762 .3173 L
s
.36905 .31355 m
.36905 .3173 L
s
.40476 .31355 m
.40476 .3173 L
s
.44048 .31355 m
.44048 .3173 L
s
.5119 .31355 m
.5119 .3173 L
s
.54762 .31355 m
.54762 .3173 L
s
.58333 .31355 m
.58333 .3173 L
s
.65476 .31355 m
.65476 .3173 L
s
.69048 .31355 m
.69048 .3173 L
s
.72619 .31355 m
.72619 .3173 L
s
.79762 .31355 m
.79762 .3173 L
s
.83333 .31355 m
.83333 .3173 L
s
.86905 .31355 m
.86905 .3173 L
s
.0119 .31355 m
.0119 .3173 L
s
.94048 .31355 m
.94048 .3173 L
s
.97619 .31355 m
.97619 .3173 L
s
.25 Mabswid
0 .31355 m
1 .31355 L
s
.04762 .00584 m
.05387 .00584 L
s
[(-0.006)] .03512 .00584 1 0 Mshowa
.04762 .10841 m
.05387 .10841 L
s
[(-0.004)] .03512 .10841 1 0 Mshowa
.04762 .21098 m
.05387 .21098 L
s
[(-0.002)] .03512 .21098 1 0 Mshowa
.04762 .41612 m
.05387 .41612 L
s
[(0.002)] .03512 .41612 1 0 Mshowa
.04762 .51869 m
.05387 .51869 L
s
[(0.004)] .03512 .51869 1 0 Mshowa
.125 Mabswid
.04762 .03149 m
.05137 .03149 L
s
.04762 .05713 m
.05137 .05713 L
s
.04762 .08277 m
.05137 .08277 L
s
.04762 .13406 m
.05137 .13406 L
s
.04762 .1597 m
.05137 .1597 L
s
.04762 .18534 m
.05137 .18534 L
s
.04762 .23663 m
.05137 .23663 L
s
.04762 .26227 m
.05137 .26227 L
s
.04762 .28791 m
.05137 .28791 L
s
.04762 .33919 m
.05137 .33919 L
s
.04762 .36484 m
.05137 .36484 L
s
.04762 .39048 m
.05137 .39048 L
s
.04762 .44176 m
.05137 .44176 L
s
.04762 .46741 m
.05137 .46741 L
s
.04762 .49305 m
.05137 .49305 L
s
.04762 .54433 m
.05137 .54433 L
s
.04762 .56998 m
.05137 .56998 L
s
.04762 .59562 m
.05137 .59562 L
s
.25 Mabswid
.04762 0 m
.04762 .61803 L
s
.25 .25 1 r
.02 w
.02381 .31355 Mdot
.02512 .31355 Mdot
.02645 .31355 Mdot
.0278 .31355 Mdot
.02916 .31355 Mdot
.03053 .31355 Mdot
.03192 .31355 Mdot
.03333 .31355 Mdot
.03475 .31355 Mdot
.03618 .31355 Mdot
.03763 .31355 Mdot
.0391 .31355 Mdot
.04059 .31355 Mdot
.04209 .31355 Mdot
.0436 .31355 Mdot
.04514 .31354 Mdot
.04669 .31354 Mdot
.04826 .31353 Mdot
.04984 .31353 Mdot
.05144 .31352 Mdot
.05306 .31351 Mdot
.0547 .31349 Mdot
.05636 .31347 Mdot
.05803 .31345 Mdot
.05973 .31342 Mdot
.06144 .31338 Mdot
.06317 .31332 Mdot
.06492 .31325 Mdot
.06669 .31317 Mdot
.06848 .31306 Mdot
.07028 .31292 Mdot
.07211 .31274 Mdot
.07396 .31253 Mdot
.07583 .31226 Mdot
.07772 .31193 Mdot
.07963 .31152 Mdot
.08156 .31103 Mdot
.08352 .31043 Mdot
.08549 .30972 Mdot
.08749 .30886 Mdot
.08951 .30785 Mdot
.09155 .30665 Mdot
.09361 .30525 Mdot
.0957 .30362 Mdot
.0978 .30173 Mdot
.09994 .29957 Mdot
.10209 .29711 Mdot
.10427 .29434 Mdot
.10648 .29123 Mdot
.10871 .28778 Mdot
.11096 .28399 Mdot
.11324 .27986 Mdot
.11554 .27541 Mdot
.11787 .27068 Mdot
.12022 .26572 Mdot
.1226 .26057 Mdot
.12501 .25533 Mdot
.12744 .25009 Mdot
.1299 .24497 Mdot
.13239 .24011 Mdot
.1349 .23568 Mdot
.13744 .23183 Mdot
.14002 .22878 Mdot
.14261 .22671 Mdot
.14524 .22584 Mdot
.1479 .22637 Mdot
.15058 .22853 Mdot
.1533 .23249 Mdot
.15604 .23843 Mdot
.15882 .24651 Mdot
.16163 .25683 Mdot
.16446 .26946 Mdot
.16733 .28441 Mdot
.17023 .30163 Mdot
.17317 .321 Mdot
.17613 .34234 Mdot
.17913 .36539 Mdot
.18216 .38983 Mdot
.18522 .41524 Mdot
.18832 .44117 Mdot
.19146 .46709 Mdot
.19462 .49244 Mdot
.19782 .51661 Mdot
.20106 .53898 Mdot
.20433 .55894 Mdot
.20764 .57589 Mdot
.21099 .58926 Mdot
.21437 .59854 Mdot
.21779 .60332 Mdot
.22125 .60325 Mdot
.22475 .59809 Mdot
.22828 .58775 Mdot
.23186 .57223 Mdot
.23547 .55169 Mdot
.23912 .52639 Mdot
.24282 .49677 Mdot
.24655 .46333 Mdot
.25033 .42672 Mdot
.25414 .38766 Mdot
.258 .34694 Mdot
.2619 .30543 Mdot
.26585 .26398 Mdot
.26984 .22346 Mdot
.27387 .18472 Mdot
.27795 .14856 Mdot
.28207 .11569 Mdot
.28624 .08674 Mdot
.29045 .06224 Mdot
.29471 .04258 Mdot
.29902 .02804 Mdot
.30338 .01875 Mdot
.30778 .01472 Mdot
.31223 .0158 Mdot
.31673 .02177 Mdot
.32128 .03225 Mdot
.32589 .04682 Mdot
.33054 .06493 Mdot
.33524 .08601 Mdot
.34 .10944 Mdot
.3448 .13459 Mdot
.34967 .16083 Mdot
.35458 .18754 Mdot
.35955 .21415 Mdot
.36457 .24013 Mdot
.36965 .26501 Mdot
.37479 .28839 Mdot
.37998 .30994 Mdot
.38523 .32943 Mdot
.39054 .34665 Mdot
.3959 .36152 Mdot
.40133 .37399 Mdot
.40681 .38409 Mdot
.41236 .3919 Mdot
.41797 .39754 Mdot
.42364 .40117 Mdot
.42937 .40298 Mdot
.43516 .40316 Mdot
.44102 .40195 Mdot
.44695 .39955 Mdot
.45294 .39619 Mdot
.45899 .39207 Mdot
.46511 .38738 Mdot
.4713 .3823 Mdot
.47756 .377 Mdot
.48389 .3716 Mdot
.49029 .36623 Mdot
.49676 .36099 Mdot
.5033 .35595 Mdot
.50991 .35117 Mdot
.51659 .3467 Mdot
.52335 .34257 Mdot
.53018 .33878 Mdot
.53709 .33535 Mdot
.54408 .33226 Mdot
.55114 .32952 Mdot
.55828 .32709 Mdot
.5655 .32497 Mdot
.5728 .32312 Mdot
.58018 .32153 Mdot
.58764 .32017 Mdot
.59518 .319 Mdot
.60281 .31802 Mdot
.61052 .3172 Mdot
.61832 .31651 Mdot
.6262 .31594 Mdot
.63417 .31547 Mdot
.64223 .31508 Mdot
.65037 .31477 Mdot
.65861 .31451 Mdot
.66694 .31431 Mdot
.67536 .31414 Mdot
.68387 .31401 Mdot
.69248 .31391 Mdot
.70118 .31383 Mdot
.70998 .31376 Mdot
.71887 .31371 Mdot
.72786 .31368 Mdot
.73696 .31365 Mdot
.74615 .31362 Mdot
.75544 .31361 Mdot
.76484 .31359 Mdot
.77434 .31358 Mdot
.78395 .31357 Mdot
.79366 .31357 Mdot
.80348 .31356 Mdot
.81341 .31356 Mdot
.82345 .31356 Mdot
.83359 .31356 Mdot
.84386 .31356 Mdot
.85423 .31355 Mdot
.86472 .31355 Mdot
.87532 .31355 Mdot
.88604 .31355 Mdot
.89688 .31355 Mdot
.90784 .31355 Mdot
.91892 .31355 Mdot
.93013 .31355 Mdot
.94145 .31355 Mdot
.95291 .31355 Mdot
.96448 .31355 Mdot
.97619 .31355 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`003@3oool00d000000oooo0?oo
o`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool014000000oooo0?oo
o`3oool2@00000D0oooo00<000000?ooo`3oool0mP3oool000`0oooo00=000000?oood0000001`3o
ool00d000000oooo@00000020?ooo`03@000003ooom000000080oooo00=000000?oood000000103o
ool00`000000oooo0?ooo`3f0?ooo`001`3oool3@0000080oooo00=000000?oood0000001`3oool0
0d000000oooo@00000020?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool0
0`00001000000?ooo`3f0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003ooom00000
0080oooo00=000000?oood0000000P3oool2@00000D0oooo00<000000?ooo`3oool0?P3oool603lo
ok80oooo000<0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000
oooo@00000020?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0?@3oool703look80
oooo000=0?ooo`03@000003oool0oooo00L0oooo00=000000?ooo`3oool00P3oool00d000000oooo
0?ooo`020?ooo`900000103oool00`000000oooo0?ooo`0m0?ooo`P0?coo/@3oool002L0oooo00<0
00000?ooo`3oool0?03oool903look40oooo000W0?ooo`030000003oool0oooo03`0oooo100o?ol0
0`3oool0?coo03loo`0203look40oooo000W0?ooo`03000004000000oooo03`0oooo100o?ol20?oo
o`@0?coo/03oool002L0oooo00<000000?ooo`3oool0?@3oool203loo`<0oooo100o?on`0?ooo`00
9`3oool00`000000oooo0?ooo`0k0?ooo`@0?coo0`3oool403look00oooo000W0?ooo`030000003o
ool0oooo03/0oooo100o?ol40?ooo`@0?coo[`3oool002L0oooo00<000000?ooo`3oool0>`3oool4
03loo`@0oooo100o?on_0?ooo`009`3oool00`000000oooo0?ooo`0l0?ooo`80?coo1@3oool403lo
ojl0oooo000W0?ooo`030000003oool0oooo04@0oooo0P0o?on`0?ooo`009`3oool00`0000100000
0?ooo`0j0?ooo`@0?coo^03oool002L0oooo00<000000?ooo`3oool0>P3oool403loo`H0oooo100o
?on^0?ooo`009`3oool00`000000oooo0?ooo`0j0?ooo`@0?coo1P3oool403loojh0oooo000W0?oo
o`030000003oool0oooo03/0oooo0P0o?ol70?ooo`@0?coo[P3oool002L0oooo00<000000?ooo`3o
ool0A@3oool203loojl0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`030000003o
ool0oooo0?H0oooo000W0?ooo`03000004000000oooo03T0oooo100o?ol90?ooo`@0?coo[03oool0
02L0oooo00<000000?ooo`3oool0>@3oool403loo`T0oooo100o?on/0?ooo`009`3oool00`000000
oooo0?ooo`0i0?ooo`@0?coo2@3oool403looj`0oooo000W0?ooo`030000003oool0oooo03X0oooo
0P0o?ol;0?ooo`80?coo[@3oool000d0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool3@00000<0oooo00<0
00000?ooo`3oool0mP3oool000`0oooo00=000000?oood0000001`3oool00d000000oooo@0000002
0?ooo`03@000003ooom0000000@0oooo00=000000?ooo`3oool00P3oool00`000000oooo0?ooo`3f
0?ooo`001`3oool3@0000080oooo00=000000?oood0000001`3oool00d000000oooo@00000020?oo
o`03@000003ooom000000080oooo140000030?ooo`03000004000000oooo04L0oooo100o?on[0?oo
o`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood00
00000P3oool00d000000oooo@00000040?ooo`030000003oool0oooo03P0oooo100o?ol;0?ooo`@0
?cooZ`3oool000`0oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000
003ooom0000000<0oooo0T0000040?ooo`030000003oool0oooo03P0oooo100o?ol;0?ooo`@0?coo
Z`3oool000d0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`020?ooo`03@000003o
ool0oooo00<0oooo00=000000?ooo`3oool00P3oool00`000000oooo0?ooo`0h0?ooo`@0?coo303o
ool203looj`0oooo000W0?ooo`030000003oool0oooo03T0oooo0P0o?onk0?ooo`009`3oool00`00
0000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`180?ooo`@0?cooZP3oool002L0oooo
00<00000@000003oool0B03oool403loojX0oooo000W0?ooo`030000003oool0oooo04P0oooo100o
?onZ0?ooo`009`3oool00`000000oooo0?ooo`190?ooo`80?cooZ`3oool002L0oooo00<000000?oo
o`3oool0=`3oool403look/0oooo000W0?ooo`030000003oool0oooo03L0oooo100o?onk0?ooo`00
9`3oool00`000000oooo0?ooo`0g0?ooo`@0?coo^`3oool002L0oooo00<000000?ooo`3oool0>03o
ool203loo`l0oooo100o?onY0?ooo`009`3oool00`00001000000?ooo`190?ooo`@0?cooZ@3oool0
02L0oooo00<000000?ooo`3oool0B@3oool403loojT0oooo000W0?ooo`030000003oool0oooo04X0
oooo0P0o?onZ0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?oo
o`3f0?ooo`009`3oool00`000000oooo0?ooo`0f0?ooo`@0?coo_03oool002L0oooo00<00000@000
003oool0=P3oool403looa40oooo100o?onW0?ooo`009`3oool00`000000oooo0?ooo`0f0?ooo`@0
?coo4@3oool403loojL0oooo000W0?ooo`030000003oool0oooo03L0oooo0P0o?olB0?ooo`@0?coo
Y`3oool002L0oooo00<000000?ooo`3oool0C03oool203loojP0oooo000W0?ooo`030000003oool0
oooo0?H0oooo000=0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`020?ooo`04@000003oool0oooo0?ooo`=00000103oool00`000000oooo0?ooo`3f
0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oo
od0000000P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo0?H0oooo00070?ooo`=0
00000P3oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood00
00000`3oool00d000000oooo0?ooo`030?ooo`03000004000000oooo04`0oooo100o?onV0?ooo`00
303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood000000
0`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo04`0oooo100o?onV0?ooo`00303o
ool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood0000000P3o
ool00d000000oooo@00000040?ooo`030000003oool0oooo03@0oooo100o?olD0?ooo`@0?cooYP3o
ool000d0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0
oooo0080oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`0C0?ooo`H0?coo6`3oool4
03looaD0oooo0P0o?onW0?ooo`009`3oool00`000000oooo0?ooo`0C0?ooo`H0?coo6`3oool403lo
okh0oooo000W0?ooo`030000003oool0oooo0180oooo200o?olK0?ooo`80?coo_`3oool002L0oooo
00<000000?ooo`3oool04@3oool:03loom/0oooo000W0?ooo`03000004000000oooo0140oooo2P0o
?olb0?ooo`@0?cooY@3oool002L0oooo00<000000?ooo`3oool0403oool503loo`80oooo1@0o?ola
0?ooo`@0?cooY@3oool002L0oooo00<000000?ooo`3oool03`3oool603loo`<0oooo100o?ola0?oo
o`@0?cooY@3oool002L0oooo00<000000?ooo`3oool03`3oool503loo`@0oooo100o?olb0?ooo`80
?cooYP3oool002L0oooo00<000000?ooo`3oool03`3oool403loo`D0oooo100o?ooJ0?ooo`009`3o
ool00`000000oooo0?ooo`0>0?ooo`D0?coo1@3oool403loomX0oooo000W0?ooo`03000004000000
oooo00h0oooo1@0o?ol50?ooo`@0?coo5`3oool403looaL0oooo100o?onT0?ooo`009`3oool00`00
0000oooo0?ooo`0>0?ooo`@0?coo1`3oool403looaH0oooo100o?olG0?ooo`@0?cooY03oool002L0
oooo00<000000?ooo`3oool03@3oool503loo`L0oooo100o?ol20?ooo`=000000P3oool00d000000
oooo0?ooo`0<0?ooo`@0?coo303oool2@00000@0oooo00=000000?ooo`3oool00P3oool403looaL0
oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0I0?ooo`E000000P3oool00d000000
oooo0?ooo`020?ooo`03@000003oool0oooo01H0oooo1D000000103ooom00000@000040000030?oo
o`03@000003oool0oooo01H0oooo1D0000020?ooo`=000000P3oool00d000000oooo0?ooo`0C0?oo
o`009`3oool00`000000oooo0?ooo`0<0?ooo`D0?coo203oool403loo`<0oooo00I000000?ooo`3o
oom000000?oood00000>0?ooo`80?coo3@3oool00d000000oooo@00000020?ooo`03@000003ooom0
000000@0oooo0P0o?olG0?ooo`03@000003ooom000000080oooo00=000000?oood000000703oool0
1d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000000I0?ooo`05@000
003oool0oooo0?oood000000103oool00d000000oooo@000000I0?ooo`03@000003oool0oooo00<0
oooo00I000000?ooo`3ooom000000?oood00000D0?ooo`009`3oool00`000000oooo0?ooo`0<0?oo
o`D0?coo2@3oool203loo`80oooo14000000103ooom000000?oood00000M0?ooo`03@000003ooom0
00000080oooo00=000000?oood0000007@3oool00d000000oooo@00000020?ooo`03@000003ooom0
000001`0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000
6@3oool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000I0?oo
o`04@000003oool0oooo0?ooo`A0000000@0oooo@000003ooom00000503oool002L0oooo00<00000
0?ooo`3oool02`3oool503loo`X0oooo100o?ol00d000000oooo@00000020?ooo`03@000003ooom0
000001d0oooo0T0000030?ooo`03@000003ooom0000001h0oooo00M000000?ooo`3oool0oooo@000
003ooom0000001`0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oo
od0000006@3oool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000
000I0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom0000001@0
oooo000W0?ooo`030000003oool0oooo00/0oooo1@0o?ol:0?ooo`@0?coo00<0oooo@00004000000
0P3oool00d000000oooo@000000M0?ooo`03@000003oool0oooo0080oooo00=000000?oood000000
1@3oool403looa@0oooo00=000000?oood0000000P3oool00d000000oooo@000000L0?ooo`07@000
003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom0000001T0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood0000006@3oool00d000000oooo0?oo
o`020?ooo`9000000P3oool00d000000oooo@000000D0?ooo`009`3oool00`00001000000?ooo`0:
0?ooo`D0?coo2`3oool403loo`80oooo00E000000?ooo`3oool0oooo@000000O0?ooo`9000000`3o
ool00d000000oooo0?ooo`040?ooo`@0?coo5@3oool00d000000oooo0?ooo`020?ooo`03@000003o
ool0oooo01X0oooo0T0000040?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool05`3o
ool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0G0?ooo`9000001@3o
ool01D000000oooo0?ooo`3ooom0000001D0oooo000W0?ooo`030000003oool0oooo00T0oooo1P0o
?ol<0?ooo`80?coo<`3oool403looj80oooo000W0?ooo`030000003oool0oooo00P0oooo1P0o?om3
0?ooo`80?cooX`3oool002L0oooo00<000000?ooo`3oool01`3oool603loo`h0oooo100o?ooG0?oo
o`009`3oool00`000000oooo0?ooo`060?ooo`H0?coo3`3oool403looa<0oooo100o?oo00?ooo`00
9`3oool00`000000oooo0?ooo`020?ooo`X0?coo3`3oool403looa<0oooo100o?olK0?ooo`@0?coo
X@3oool001h0oooo5`0o?olA0?ooo`80?coo503oool403looa/0oooo100o?oll0?oooel0?coo1P3o
ool001X0oooo1000000F03loobT000000P0o?olL000000@0?coo<P00001Y03loo`D000000D000000
01d0oooo00=0000003loo`0o?ol04P0o?ol70?ooo`03@000003oool0oooo00L0oooo00=000000?oo
o`0o?ol00`0o?ol30?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool00d00
0000oooo0?ooo`070?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool01400
0000oooo03loo`0o?ol60?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool0
0d000000oooo0?ooo`070?ooo`03@000003oool0oooo00H0oooo00A000000?ooo`3oool0ooooK@0o
?ol60?ooo`007`3oool?03looaL0oooo100o?omQ0?oooaX0?coo00<0oooo03loo`0o?ol0200o?ol0
0`3oool0?coo03loo`0403loo`030?ooo`0o?ol0?coo00@0?coo00<0oooo03loo`0o?ol00P0o?ol0
0`3oool0?coo03loo`0203loo`030?ooo`0o?ol0?coo0080?coo00@0oooo03loo`0o?ol0oooo100o
?ol0103oool0?coo03loo`3oool403loo`040?ooo`0o?ol0?coo0?ooo`80?coo00<0oooo03loo`0o
?ol00P0o?ol0103oool0?coo03loo`3oool203loo`040?ooo`0o?ol0?coo0?ooo`80?coo00@0oooo
03loo`0o?ol0oooo0P0o?ol70?ooo`009`3oool00`000000oooo0?ooo`0K0?ooo`@0?coo=03oool4
03loobL0oooo500o?omT0?ooo`009`3oool00`000000oooo0?ooo`0L0?ooo`80?coo=@3oool403lo
ob<0oooo3P0o?om^0?ooo`009`3oool00`000000oooo0?ooo`1C0?ooo`@0?coo8@3oool<03loog80
oooo000W0?ooo`03000004000000oooo01`0oooo100o?old0?ooo`80?coo803oool;03loogD0oooo
000W0?ooo`030000003oool0oooo01`0oooo100o?olA0?ooo`@0?coo7`3oool403looad0oooo2P0o
?omg0?ooo`009`3oool00`000000oooo0?ooo`0L0?ooo`@0?coo4@3oool403looal0oooo100o?olM
0?ooo`H0?cooN`3oool002L0oooo00<000000?ooo`3oool07@3oool203looa80oooo100o?olO0?oo
o`@0?coo6`3oool603loogd0oooo000W0?ooo`030000003oool0oooo0380oooo0P0o?olQ0?ooo`80
?coo6P3oool703loogh0oooo000W0?ooo`030000003oool0oooo05D0oooo100o?olG0?ooo`L0?coo
O`3oool002L0oooo00<000000?ooo`3oool07@3oool403looc@0oooo100o?olE0?ooo`P0?cooP03o
ool002L0oooo00<00000@000003oool07@3oool403looc@0oooo100o?olE0?ooo`H0?cooPP3oool0
02L0oooo00<000000?ooo`3oool07@3oool403loocD0oooo1@0o?olA0?ooo`L0?cooP`3oool002L0
oooo00<000000?ooo`3oool07P3oool203loocL0oooo100o?ol@0?ooo`H0?cooQ@3oool002L0oooo
00<000000?ooo`3oool0E`3oool403looa00oooo1@0o?on60?ooo`009`3oool00`000000oooo0?oo
o`1H0?ooo`@0?coo3@3oool603loohL0oooo000W0?ooo`030000003oool0oooo0300oooo100o?olT
0?ooo`@0?coo2`3oool703loohP0oooo000W0?ooo`030000003oool0oooo01h0oooo100o?ol>0?oo
o`@0?coo903oool603loo`P0oooo1`0o?on90?ooo`009`3oool00`00001000000?ooo`0N0?ooo`@0
?coo3P3oool403loobD0oooo1@0o?ol60?ooo`P0?cooRP3oool002L0oooo00<000000?ooo`3oool0
7P3oool403loo`l0oooo0P0o?olW0?ooo`D0?coo103oool703looh`0oooo000W0?ooo`030000003o
ool0oooo01l0oooo0P0o?olj0?ooo`h0?cooS@3oool002L0oooo00<000000?ooo`3oool0F`3oool<
03loohl0oooo000=0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`020?ooo`04@000003oool0oooo0?ooo`=00000103oool00`000000oooo0?ooo`1L
0?ooo`X0?cooT03oool000`0oooo00=000000?oood0000001`3oool00d000000oooo@00000020?oo
o`03@000003ooom000000080oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`0N0?oo
o`@0?coo?03oool603looi80oooo000<0?ooo`03@000003ooom0000000L0oooo00=000000?oood00
00000P3oool00d000000oooo@00000030?ooo`03@000003oool0oooo00<0oooo00<00000@000003o
ool07P3oool403loom@0oooo000<0?ooo`03@000003ooom0000000L0oooo00=000000?oood000000
0P3oool00d000000oooo@00000030?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0
7P3oool403loom@0oooo000<0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3o
ool00d000000oooo@00000020?ooo`03@000003ooom0000000@0oooo00<000000?ooo`3oool07`3o
ool203loo`h0oooo100o?oo30?ooo`003@3oool00d000000oooo0?ooo`070?ooo`03@000003oool0
oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`030?ooo`030000003oool0
oooo02l0oooo100o?oo30?ooo`009`3oool00`000000oooo0?ooo`0_0?ooo`@0?coo``3oool002L0
oooo00<000000?ooo`3oool0<03oool203lool@0oooo000W0?ooo`030000003oool0oooo01l0oooo
100o?ooC0?ooo`009`3oool00`00001000000?ooo`0O0?ooo`@0?cood`3oool002L0oooo00<00000
0?ooo`3oool07`3oool403loom<0oooo000W0?ooo`030000003oool0oooo0200oooo0P0o?ooD0?oo
o`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3o
ool00`000000oooo0?ooo`0^0?ooo`@0?cooa03oool002L0oooo00<000000?ooo`3oool0803oool4
03loo`X0oooo100o?oo40?ooo`009`3oool00`00001000000?ooo`0P0?ooo`@0?coo2P3oool403lo
ol@0oooo000W0?ooo`030000003oool0oooo0200oooo100o?ol;0?ooo`80?cooa@3oool002L0oooo
00<000000?ooo`3oool08@3oool203loom<0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W
0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`030000003oool0oooo0240oooo100o?ooA0?oo
o`009`3oool00`00001000000?ooo`0Q0?ooo`@0?coo203oool403loolD0oooo000W0?ooo`030000
003oool0oooo0240oooo100o?ol80?ooo`@0?cooa@3oool002L0oooo00<000000?ooo`3oool08P3o
ool203loo`T0oooo100o?oo50?ooo`009`3oool00`000000oooo0?ooo`0^0?ooo`80?cooaP3oool0
02L0oooo00<000000?ooo`3oool0mP3oool000d0oooo00=000000?ooo`3oool00P3oool00d000000
oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool3@00000<0
oooo00<000000?ooo`3oool0mP3oool000`0oooo00=000000?oood0000001`3oool00d000000oooo
@00000020?ooo`03@000003ooom0000000@0oooo00=000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0R0?ooo`@0?cood03oool000`0oooo00=000000?oood0000001`3oool00d000000oooo@000
00020?ooo`03@000003ooom000000080oooo140000030?ooo`03000004000000oooo0280oooo100o
?oo@0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=00000
0?oood0000000P3oool00d000000oooo@00000040?ooo`030000003oool0oooo0280oooo100o?ol7
0?ooo`@0?cooa@3oool000`0oooo00=000000?oood0000001`3oool00d000000oooo@00000020?oo
o`03@000003ooom0000000<0oooo0T0000040?ooo`030000003oool0oooo02<0oooo0P0o?ol80?oo
o`@0?cooa@3oool000d0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo00<0oooo00=000000?ooo`3oool00P3oool00`000000oooo0?ooo`0]0?ooo`@0
?cooa@3oool002L0oooo00<000000?ooo`3oool08`3oool403loo`L0oooo0P0o?oo60?ooo`009`3o
ool00`000000oooo0?ooo`0S0?ooo`@0?cooc`3oool002L0oooo00<000000?ooo`3oool08`3oool4
03looll0oooo000W0?ooo`03000004000000oooo02@0oooo0P0o?oo@0?ooo`009`3oool00`000000
oooo0?ooo`0/0?ooo`@0?cooaP3oool002L0oooo00<000000?ooo`3oool0;03oool403loolH0oooo
000W0?ooo`030000003oool0oooo02<0oooo100o?ol50?ooo`@0?cooaP3oool002L0oooo00<00000
0?ooo`3oool08`3oool403loo`H0oooo0P0o?oo70?ooo`009`3oool00`000000oooo0?ooo`0S0?oo
o`@0?cooc`3oool002L0oooo00<00000@000003oool0903oool203loo`D0oooo100o?oo70?ooo`00
9`3oool00`000000oooo0?ooo`0T0?ooo`@0?coo0`3oool403loolL0oooo000W0?ooo`030000003o
ool0oooo02@0oooo100o?ol30?ooo`@0?cooa`3oool002L0oooo00<000000?ooo`3oool0903oool4
03loo`@0oooo0P0o?oo80?ooo`009`3oool00`000000oooo0?ooo`0U0?ooo`@0?coo00<0oooo03lo
o`0o?ol00P0o?oo80?ooo`009`3oool00`000000oooo0?ooo`0U0?ooo`@0?coo00<0oooo03loo`0o
?ol00P0o?oo80?ooo`009`3oool00`000000oooo0?ooo`0U0?ooo`@0?coo00<0oooo03loo`0o?ol0
0P0o?oo80?ooo`009`3oool00`00001000000?ooo`0V0?ooo`L0?coob@3oool002L0oooo00<00000
0?ooo`3oool09P3oool703loolT0oooo000W0?ooo`030000003oool0oooo02H0oooo1`0o?oo90?oo
o`009`3oool00`000000oooo0?ooo`0W0?ooo`D0?coobP3oool002L0oooo00<000000?ooo`3oool0
:03oool303lool/0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`03@000003oool0
oooo0?H0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.12522, -0.00683158, 
  0.538185, 7.49575*^-05}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{450, 319},
WindowMargins->{{33, Automatic}, {Automatic, 10}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 101, 3, 48, "Input"],
Cell[1813, 54, 72, 0, 33, "Text"],
Cell[1888, 56, 1259, 53, 1056, "Input"],
Cell[3150, 111, 44, 0, 33, "Text"],
Cell[3197, 113, 122, 12, 210, "Input"],
Cell[3322, 127, 47, 0, 33, "Text"],
Cell[3372, 129, 73, 0, 48, "Input"],
Cell[3448, 131, 65, 0, 30, "Input"],
Cell[3516, 133, 50, 0, 33, "Text"],
Cell[3569, 135, 139, 3, 66, "Input"],
Cell[3711, 140, 34, 0, 33, "Text"],
Cell[3748, 142, 63, 0, 30, "Input"],
Cell[3814, 144, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[3863, 148, 434, 9, 210, "Input"],
Cell[4300, 159, 35250, 914, 264, 9408, 590, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[39565, 1076, 183, 3, 52, "Text"],
Cell[39751, 1081, 129, 3, 66, "Input"],
Cell[39883, 1086, 42, 0, 33, "Text"],
Cell[39928, 1088, 131, 3, 48, "Input"],
Cell[40062, 1093, 64, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[40151, 1097, 178, 5, 102, "Input"],
Cell[40332, 1104, 23243, 637, 186, 7006, 432, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

