(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     62318,       1637]*)
(*NotebookOutlinePosition[     63014,       1662]*)
(*  CellTagsIndexPosition[     62970,       1658]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
<<c:\\math\\kniz\\linearal\\tridiago.m
<<c:\\math\\kniz\\options\\optvalue.m\
\>", "Input"],

Cell["\<\
\"Condor =
 kupa call za vysoku realizacnu cenu,
 predaj call za stredne realizacnou cenou nizku cenu,
 predaj call za stredne vysoku realizacnu cenu,
 kupa call za nizku realizacnu cenu\"\
\>", "Text"],

Cell["\<\
CondorImpl[X1_,X2_,X3_,X4_,sigma_,r_,D_,t_,m_,n_,trans_,time_]:=
Module[
{doldiag,diag,hordiag},

X=(X1+X2+X3+X4)/4;
xright=Log[Slarge/X];

k1=N[r/(0.5*sigma^2)];
k2=N[(r-D)/(0.5*sigma^2)];
k3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
k4=N[0.25*(k2^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

TransfCondorPayoff[x_]:=N[Exp[0.5*(k2-1)*x]*(Max[Exp[x]-X1/X,0]-Max[Exp[x]-X2/\
X,0]-Max[Exp[x]-X3/X,0]+Max[Exp[x]-X4/X,0])];
Do[u[i,0]=TransfCondorPayoff[i*h],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
  Do[
      grad=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      kriv=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
ClenAbs[i]=Abs[N[k4*u[i,j-1]-k2*grad+kriv]],{i,-m+1,m-1}];

op1=0;
op2=Exp[0.5*(k2-1)*i*h+(0.25*(k2-1)^2)*j*k]*(-X1+X2+X3-X4)/X;

ps = Join[{u[-m+1,j-1]-k3*k*ClenAbs[-m+1]-a*op1},
          Table[u[i,j-1]-k3*k*ClenAbs[i],{i,-m+2,m-2}],
          {u[m-1,j-1]-k3*k*ClenAbs[m-1]-c*op2}];

hordiag=Table[c,{i,-m+1,m-2}];
diag=Table[b,{i,-m+1,m-1}];
doldiag=Table[a,{i,-m+2,m-1}];

riesenie=TridiagonalSolve[N[doldiag],N[diag],N[hordiag],N[ps]];
 
u[-m,j]=op1;
Do[u[i,j]=riesenie[[i+m]],{i,-m+1,m-1}];
u[m,j]=op2;

xs=Table[X*Exp[i*h],{i,-m,m}];
ys=Table[X*Exp[-0.5*(k2-1)*i*h-(0.25*(k2-1)^2+k1)*j*k]*u[i,j],{i,-m,m}];
grf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
{j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X1=45;
X2=55;
X3=60;
X4=65;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=50;
n=30;
Slarge=150;
trans=0.02;
time=0.03;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["CondorImpl[X1,X2,X3,X4,sigma,r,DD,t,m,n,trans,time]", "Input"],

Cell["\"Explicitn\[EAcute] rie\.9aenie\"", "Text"],

Cell["\<\
Condor[S_,X1_,X2_,X3_,X4_,sigma_,r_,DD_,t_]:=
N[EuropeanCallDiv[S,X1,sigma,r,DD,t]-EuropeanCallDiv[S,X2,sigma,r,DD,t]-\
EuropeanCallDiv[S,X3,sigma,r,DD,t]+EuropeanCallDiv[S,X4,sigma,r,DD,t]];\
\>", "Input"],

Cell["\"Payoff diagram\"", "Text"],

Cell["\<\
Payoff[S_,X1_,X2_,X3_,X4_]:=N[Max[S-X1,0]-Max[S-X2,0]-Max[S-X3,0]+Max[S-X4,0]]\
\
\>", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[Condor[S,X1,X2,X3,X4,sigma,r,DD,t],{S,0,150},PlotRange->All,PlotStyle->\
RGBColor[0,1,0], DisplayFunction->Identity];
g1=ListPlot[grf[n],PlotStyle->{PointSize[0.015],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];
g2=Plot[Payoff[S,X1,X2,X3,X4],{S,0,150},PlotRange->All, \
DisplayFunction->Identity];

Show[g2,g1,g,AxesLabel -> \
{\"S\",\"V\"},DisplayFunction->$DisplayFunction,PlotRange->{{20,120},{0,12}}]
\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.2 0.01 0 0.0515028 [
[.2 -0.0125 -6 -9 ]
[.2 -0.0125 6 0 ]
[.4 -0.0125 -6 -9 ]
[.4 -0.0125 6 0 ]
[.6 -0.0125 -6 -9 ]
[.6 -0.0125 6 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .10301 -6 -4.5 ]
[-0.0125 .10301 0 4.5 ]
[-0.0125 .20601 -6 -4.5 ]
[-0.0125 .20601 0 4.5 ]
[-0.0125 .30902 -6 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .41202 -6 -4.5 ]
[-0.0125 .41202 0 4.5 ]
[-0.0125 .51503 -12 -4.5 ]
[-0.0125 .51503 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[0 .64303 -5.5 0 ]
[0 .64303 5.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2 0 m
.2 .00625 L
s
[(40)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(60)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(80)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(100)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(120)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .10301 m
.00625 .10301 L
s
[(2)] -0.0125 .10301 1 0 Mshowa
0 .20601 m
.00625 .20601 L
s
[(4)] -0.0125 .20601 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(6)] -0.0125 .30902 1 0 Mshowa
0 .41202 m
.00625 .41202 L
s
[(8)] -0.0125 .41202 1 0 Mshowa
0 .51503 m
.00625 .51503 L
s
[(10)] -0.0125 .51503 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(12)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .02575 m
.00375 .02575 L
s
0 .0515 m
.00375 .0515 L
s
0 .07725 m
.00375 .07725 L
s
0 .12876 m
.00375 .12876 L
s
0 .15451 m
.00375 .15451 L
s
0 .18026 m
.00375 .18026 L
s
0 .23176 m
.00375 .23176 L
s
0 .25751 m
.00375 .25751 L
s
0 .28327 m
.00375 .28327 L
s
0 .33477 m
.00375 .33477 L
s
0 .36052 m
.00375 .36052 L
s
0 .38627 m
.00375 .38627 L
s
0 .43777 m
.00375 .43777 L
s
0 .46353 m
.00375 .46353 L
s
0 .48928 m
.00375 .48928 L
s
0 .54078 m
.00375 .54078 L
s
0 .56653 m
.00375 .56653 L
s
0 .59228 m
.00375 .59228 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(V) show
69.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.04948 0 m
.11328 0 L
.17469 0 L
.20599 0 L
.22249 0 L
.23151 0 L
.23997 0 L
.24381 0 L
.24747 0 L
.24948 0 L
.25062 .00319 L
.25168 .00864 L
.25553 .02848 L
.27267 .11675 L
.30286 .27224 L
.33246 .42471 L
.34057 .46648 L
.34501 .48931 L
.34717 .50045 L
.34914 .51061 L
.35096 .51503 L
.35267 .51503 L
.35646 .51503 L
.36449 .51503 L
.38064 .51503 L
.38916 .51503 L
.39383 .51503 L
.39611 .51503 L
.39712 .51503 L
.39821 .51503 L
.40005 .51477 L
.40199 .5048 L
.40605 .48384 L
.41471 .43925 L
.42998 .36062 L
.4383 .31775 L
.44239 .29669 L
.44616 .27728 L
.44793 .26816 L
.44959 .25963 L
.45132 .25751 L
.45322 .25751 L
.46087 .25751 L
.49386 .25751 L
.55501 .25751 L
.62002 .25751 L
.68265 .25751 L
.74288 .25751 L
.80698 .25751 L
.86869 .25751 L
Mistroke
.93427 .25751 L
.99745 .25751 L
Mfstroke
.99745 .25751 m
1 .25751 L
s
.25 .25 1 r
.015 w
.01094 0 Mdot
.01512 0 Mdot
.01938 0 Mdot
.02372 0 Mdot
.02816 0 Mdot
.03268 0 Mdot
.03728 0 Mdot
.04199 0 Mdot
.04678 0 Mdot
.05167 0 Mdot
.05665 0 Mdot
.06174 0 Mdot
.06692 0 Mdot
.07221 0 Mdot
.0776 0 Mdot
.0831 0 Mdot
.08871 0 Mdot
.09443 1e-005 Mdot
.10026 1e-005 Mdot
.10621 2e-005 Mdot
.11228 4e-005 Mdot
.11846 7e-005 Mdot
.12477 .00012 Mdot
.13121 .00019 Mdot
.13777 .00032 Mdot
.14446 .00051 Mdot
.15128 .00082 Mdot
.15824 .00131 Mdot
.16534 .00205 Mdot
.17258 .00316 Mdot
.17996 .0048 Mdot
.18748 .00718 Mdot
.19516 .01056 Mdot
.20299 .01522 Mdot
.21097 .02152 Mdot
.21911 .02976 Mdot
.22742 .04019 Mdot
.23588 .05293 Mdot
.24452 .06783 Mdot
.25332 .08443 Mdot
.26231 .10191 Mdot
.27146 .11956 Mdot
.2808 .13715 Mdot
.29033 .15443 Mdot
.30004 .17115 Mdot
.30995 .18709 Mdot
.32005 .20204 Mdot
.33035 .21581 Mdot
.34086 .22824 Mdot
.35157 .23922 Mdot
.3625 .24866 Mdot
.37364 .25654 Mdot
.38501 .26284 Mdot
.3966 .26763 Mdot
.40842 .27097 Mdot
.42047 .27299 Mdot
.43276 .27382 Mdot
.44529 .27364 Mdot
.45808 .27261 Mdot
.47111 .27091 Mdot
.48441 .26874 Mdot
.49797 .26627 Mdot
.5118 .26369 Mdot
.5259 .26136 Mdot
.54028 .25944 Mdot
.55494 .25795 Mdot
.5699 .25684 Mdot
.58515 .25605 Mdot
.6007 .2555 Mdot
.61656 .25512 Mdot
.63274 .25487 Mdot
.64924 .25471 Mdot
.66606 .25461 Mdot
.68322 .25454 Mdot
.70072 .2545 Mdot
.71856 .25448 Mdot
.73676 .25446 Mdot
.75531 .25446 Mdot
.77424 .25445 Mdot
.79354 .25445 Mdot
.81322 .25445 Mdot
.83329 .25444 Mdot
.85376 .25444 Mdot
.87464 .25444 Mdot
.89593 .25444 Mdot
.91764 .25445 Mdot
.93978 .25445 Mdot
.96236 .25445 Mdot
.98538 .25445 Mdot
0 1 0 r
.5 Mabswid
0 0 m
.00082 0 L
.00246 0 L
.00426 0 L
.0062 0 L
.00815 0 L
.01027 0 L
.0125 0 L
.01456 0 L
.01651 0 L
.01827 0 L
.0203 0 L
.02222 0 L
.02573 0 L
.0275 0 L
.02945 0 L
.0311 0 L
.03288 0 L
.0361 0 L
.03803 0 L
.04013 0 L
.04198 0 L
.04395 0 L
.04767 1e-005 L
.05112 1e-005 L
.05486 2e-005 L
.0588 2e-005 L
.06217 3e-005 L
.06585 4e-005 L
.06983 6e-005 L
.07408 9e-005 L
.0781 .00013 L
.08175 .00017 L
.08544 .00023 L
.08884 .00029 L
.09258 .00038 L
.09654 .0005 L
.1032 .00078 L
.10698 .00099 L
.11052 .00123 L
.11835 .00193 L
.12278 .00246 L
.12689 .00305 L
.13442 .00445 L
.14244 .00646 L
.15032 .00908 L
.15775 .01224 L
.17162 .02031 L
.17896 .02588 L
.18701 .03314 L
Mistroke
.20327 .05167 L
.23237 .09755 L
.29607 .22714 L
.32544 .27874 L
.34204 .30115 L
.35738 .3169 L
.3651 .32299 L
.37362 .32834 L
.3779 .3305 L
.38251 .33245 L
.3865 .33382 L
.39086 .33502 L
.39288 .33546 L
.39504 .33587 L
.3969 .33616 L
.39892 .33641 L
.40011 .33654 L
.40121 .33663 L
.40223 .3367 L
.40336 .33676 L
.40532 .33683 L
.4074 .33684 L
.40937 .3368 L
.41118 .33671 L
.41326 .33657 L
.41523 .33638 L
.41874 .33594 L
.42256 .3353 L
.43096 .33339 L
.43887 .33104 L
.45363 .32555 L
.48669 .31046 L
.54752 .28398 L
.57901 .27404 L
.59505 .27007 L
.61221 .26657 L
.62845 .26389 L
.64323 .26191 L
.67213 .25906 L
.6878 .25796 L
.70227 .25717 L
.71816 .25649 L
.735 .25594 L
.74981 .25558 L
.76575 .25528 L
.7808 .25507 L
.79457 .25492 L
.81007 .25479 L
.82446 .2547 L
.84025 .25463 L
Mistroke
.85709 .25458 L
.87328 .25454 L
.8818 .25452 L
.8908 .25451 L
.90734 .25449 L
.92257 .25448 L
.93748 .25447 L
.95348 .25446 L
.96858 .25445 L
.98235 .25445 L
.99796 .25445 L
Mfstroke
.99796 .25445 m
1 .25445 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{408.813, 252.563},
  ImageMargins->{{40, 0}, {0, 5}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006H0000o2000`400?l00000o`00003oo`3ooonI
0?ooo`00G`3oool3@0000080oooo00=000000?ooo`3oool0?@3oool2@00000@0oooo00=000000?oo
o`3oool0?@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo03T0oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0=P3oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool06@3oool00600oooo00I000000?ooo`3ooom000000?oood00
000n0?ooo`03@000003ooom000000080oooo00=000000?oood000000?@3oool00d000000oooo@000
00020?ooo`03@000003ooom0000003`0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood000000>@3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oo
od0000006P3oool005h0oooo14000000103ooom000000?oood00000n0?ooo`03@000003ooom00000
0080oooo00=000000?oood000000?@3oool00d000000oooo@00000020?ooo`03@000003ooom00000
03`0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000>@3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000J0?ooo`00
GP3oool00d000000oooo@00000020?ooo`03@000003ooom0000003h0oooo0T0000030?ooo`03@000
003ooom0000003h0oooo00M000000?ooo`3oool0oooo@000003ooom0000003`0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood000000>@3oool00d000000oooo0?oo
o`020?ooo`07@000003oool0oooo0?oood000000oooo@000000J0?ooo`00G`3oool2@0000080oooo
00=000000?oood000000?P3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000003d0oooo
00=000000?oood0000000P3oool00d000000oooo@000000l0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000020?ooo`03@000003ooom0000003T0oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood0000006P3oool00600oooo00E000000?ooo`3oool0oooo@000
00100?ooo`9000000`3oool00d000000oooo0?ooo`0m0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool0>P3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`0g0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01T0oooo003o
0?oooiT0oooo003o0?oooiT0oooo003o0?oooiT0oooo003o0?oooiT0oooo003o0?oooh@0oooo0d00
000B0?ooo`007P3oool`03loool0oooo=P3oool00d000000oooo@000000B0?ooo`007@3ooolR003o
01`0?cooo`00000N00000003@000003oool0oooo00X0oooo00=000000?ooo`3oool0403oool001d0
oooo00<0000003loo`0o?ol07`0o?ol;003o01<0?coo1@3oool00`000000oooo0?ooo`0>0?ooo`80
0000403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool02@3oool00d000000oooo0?ooo`0A0?ooo`007@3oool00`000000oooo03loo`0R03loo`030?oo
o`0o?ol0?coo00D0?coo0`00o`0C03loo`80oooo00=000000?ooo`3oool03P3oool00d0000000000
0?ooo`0?0?ooo`03@000003oool0oooo00h0oooo00=000000?ooo`3oool03`3oool00d000000oooo
0?ooo`0>0?ooo`03@000003oool0oooo00h0oooo00=000000?ooo`3oool03`3oool00d000000oooo
0?ooo`0>0?ooo`03@000003oool0oooo00h0oooo00=000000?ooo`3oool03`3oool00d000000oooo
0?ooo`0>0?ooo`03@000003oool0oooo00h0oooo00=000000?ooo`3oool03`3oool00d000000oooo
0?ooo`0>0?ooo`03@000003oool0oooo00h0oooo00=000000?ooo`3oool03`3oool00d000000oooo
0?ooo`080?ooo`03@000003ooom000000180oooo000M0?ooo`030000003oool0oooo02d0oooo1@00
o`000`3oool0?coo03loo`0203loo`030?ooo`0o?ol0?coo00P0?coo4P3oool00`000000oooo0?oo
o`3o0?ooo`d0oooo0d00000B0?ooo`007@3oool00`000000oooo0?ooo`0b0?ooo`03003o003oool0
oooo00D0oooo200o?olB0?ooo`030000003oool0oooo0?l0oooo8P3oool001d0oooo00<000000?oo
o`3oool0<`3oool2003o00P0oooo200o?ol?0?ooo`030000003oool0oooo0?l0oooo8P3oool001d0
oooo00<000000?ooo`3oool0=@3oool2003o00P0oooo1P0o?ol?0?ooo`030000003oool0oooo0?l0
oooo8P3oool001d0oooo00<000000?ooo`3oool0=`3oool2003o00P0oooo1`0o?ol=0?ooo`030000
003oool0oooo0?l0oooo8@3oool001d0oooo00<000000?ooo`3oool0>@3oool2003o00L0oooo1P0o
?ol=0?ooo`030000003oool0oooo0?l0oooo8@3oool001d0oooo00<00000@000003oool0>`3oool0
0`00o`00oooo0?ooo`060?ooo`@0?coo3@3oool00`000000oooo0?ooo`3o0?ooob40oooo000M0?oo
o`030000003oool0oooo03`0oooo00<00?l00?ooo`3oool01P3oool603loo`X0oooo00<000000?oo
o`3oool0o`3ooolQ0?ooo`007@3oool00`000000oooo0?ooo`0m0?ooo`03003o003oool0oooo00L0
oooo100o?ol:0?ooo`030000003oool0oooo0?l0oooo8@3oool001d0oooo00<000000?ooo`3oool0
?P3oool00`00o`00oooo0?ooo`060?ooo`@0?coo2P3oool00`000000oooo0?ooo`3o0?ooob40oooo
000M0?ooo`030000003oool0oooo03l0oooo00<00?l00?ooo`3oool01P3oool603loo`P0oooo00<0
00000?ooo`3oool0o`3ooolP0?ooo`007@3oool00`000000oooo0?ooo`100?ooo`03003o003oool0
oooo00L0oooo100o?ol80?ooo`030000003oool0oooo0?l0oooo803oool001d0oooo00<000000?oo
o`3oool0@@3oool00`00o`00oooo0?ooo`060?ooo`@0?coo203oool00`000000oooo0?ooo`3o0?oo
ob00oooo000M0?ooo`030000003oool0oooo0440oooo00<00?l00?ooo`3oool01`3oool203loo`T0
oooo00<000000?ooo`3oool0o`3ooolP0?ooo`007@3oool00`000000oooo0?ooo`120?ooo`03003o
003oool0oooo0140oooo00<000000?ooo`3oool0o`3ooolP0?ooo`007@3oool00`00001000000?oo
o`130?ooo`03003o003oool0oooo00H0oooo100o?ol70?ooo`030000003oool0oooo0?l0oooo7`3o
ool001d0oooo00<000000?ooo`3oool0A03oool00`00o`00oooo0?ooo`050?ooo`@0?coo1`3oool0
0`000000oooo0?ooo`3o0?oooal0oooo000M0?ooo`030000003oool0oooo04@0oooo00<00?l00?oo
o`3oool01@3oool403loo`L0oooo00<000000?ooo`3oool0o`3ooolO0?ooo`007@3oool00`000000
oooo0?ooo`150?ooo`03003o003oool0oooo00D0oooo0P0o?ol80?ooo`030000003oool0oooo0?l0
oooo7`3oool001d0oooo00<000000?ooo`3oool0AP3oool00`00o`00oooo0?ooo`0>0?ooo`030000
003oool0oooo0?l0oooo7`3oool001d0oooo00<000000?ooo`3oool0AP3oool00`00o`00oooo0?oo
o`060?ooo`@0?coo1@3oool00`000000oooo0?ooo`3o0?oooah0oooo000M0?ooo`030000003oool0
oooo04L0oooo00<00?l00?ooo`3oool01@3oool403loo`D0oooo00<000000?ooo`3oool0o`3ooolN
0?ooo`007@3oool00`000000oooo0?ooo`170?ooo`03003o003oool0oooo00D0oooo100o?ol50?oo
o`030000003oool0oooo0?l0oooo7P3oool001d0oooo00<000000?ooo`3oool0B03oool00`00o`00
oooo0?ooo`050?ooo`80?coo1P3oool00`000000oooo0?ooo`3o0?oooah0oooo000M0?ooo`030000
04000000oooo04T0oooo00<00?l00?ooo`3oool0303oool00`000000oooo0?ooo`3o0?oooah0oooo
000M0?ooo`030000003oool0oooo04T0oooo00<00?l00?ooo`3oool0303oool00`000000oooo0?oo
o`3o0?oooah0oooo000M0?ooo`030000003oool0oooo04X0oooo00<00?l00?ooo`3oool01P3oool4
03loo`80oooo00<000000?ooo`3oool0o`3ooolM0?ooo`007@3oool00`000000oooo0?ooo`1;0?oo
o`03003o003oool0oooo00D0oooo100o?ol20?ooo`030000003oool0oooo0?l0oooo7@3oool001d0
oooo00<000000?ooo`3oool0B`3oool00`00o`00oooo0?ooo`050?ooo`@0?coo0P3oool00`000000
oooo0?ooo`3o0?oooad0oooo000M0?ooo`030000003oool0oooo04`0oooo00<00?l00?ooo`3oool0
1@3oool203loo`<0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`007@3oool00`000000oooo0?oo
o`1<0?ooo`03003o003oool0oooo00X0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`00503oool3
@00000H0oooo00<000000?ooo`3oool0C@3oool00`00o`00oooo0?ooo`0:0?ooo`030000003oool0
oooo0?l0oooo703oool001@0oooo00=000000?ooo`3oool01P3oool00`000000oooo0?ooo`1=0?oo
o`03003o003oool0oooo00H0oooo100o?ol00`000000oooo0?ooo`3o0?oooa`0oooo000E0?ooo`03
@000003oool0oooo00D0oooo0P0000000d000000oooo0?ooo`1<0?ooo`03003o003oool0oooo00D0
oooo100o?ol00`000000oooo0?ooo`3o0?oooa`0oooo000E0?ooo`03@000003oool0oooo00D0oooo
00<000000?ooo`3oool0CP3oool00`00o`00oooo0?ooo`050?ooo`@0?coo00<000000?ooo`3oool0
o`3ooolL0?ooo`00503oool00d000000oooo@00000060?ooo`030000003oool0oooo04l0oooo00<0
0?l00?ooo`3oool01@3oool203loo`030?ooo`000000oooo0?l0oooo7@3oool001D0oooo00=00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`1?0?ooo`03003o003oool0oooo00T0oooo00<00000
0?ooo`3oool0o`3ooolK0?ooo`007@3oool00`000000oooo0?ooo`1@0?ooo`03003o003oool0oooo
00P0oooo00<000000?ooo`3oool0o`3ooolK0?ooo`007@3oool00`000000oooo0?ooo`1@0?ooo`03
003o003oool0oooo00H0oooo100o?ooo0?oooa`0oooo000M0?ooo`030000003oool0oooo0540oooo
00<00?l00?ooo`3oool01@3oool403loool0oooo703oool001d0oooo00<000000?ooo`3oool0D@3o
ool00`00o`00oooo0?ooo`050?ooo`@0?cooo`3ooolL0?ooo`007@3oool00`000000oooo0?ooo`1B
0?ooo`03003o003oool0oooo00D0oooo0P0o?ol00`000000oooo0?ooo`3o0?oooaX0oooo000M0?oo
o`03000004000000oooo0580oooo00<00?l00?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?oo
oaX0oooo000M0?ooo`030000003oool0oooo05<0oooo00<00?l00?ooo`3oool01P3oool00`000000
oooo0?ooo`3o0?oooaX0oooo000M0?ooo`030000003oool0oooo05<0oooo00<00?l00?ooo`3oool0
1P3oool403loool0oooo6@3oool001d0oooo00<000000?ooo`3oool0E03oool00`00o`00oooo0?oo
o`050?ooo`@0?cooo`3ooolI0?ooo`007@3oool00`000000oooo0?ooo`1D0?ooo`03003o003oool0
oooo00D0oooo100o?ooo0?oooaT0oooo000M0?ooo`030000003oool0oooo05D0oooo00<00?l00?oo
o`3oool01@3oool203loool0oooo6P3oool001d0oooo00<000000?ooo`3oool0E@3oool00`00o`00
oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo6@3oool001d0oooo00<000000?ooo`3oool0
EP3oool00`00o`00oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo6@3oool001d0oooo00<0
00000?ooo`3oool0EP3oool00`00o`00oooo0?ooo`040?ooo`030000003oool0?coo00<0?cooo`3o
oolF0?ooo`007@3oool00`00001000000?ooo`1G0?ooo`03003o003oool0oooo00@0oooo00<00000
03loo`0o?ol00P0o?ooo0?oooaH0oooo000M0?ooo`030000003oool0oooo05L0oooo00<00?l00?oo
o`3oool0103oool00`000000?coo03loo`0203loool0oooo5P3oool001d0oooo00<000000?ooo`3o
ool0F03oool00`00o`00oooo0?ooo`030?ooo`040000003oool0?coo03loool0oooo5`3oool001d0
oooo00<000000?ooo`3oool0F03oool00`00o`00oooo0?ooo`030?ooo`030000003oool0oooo0?l0
oooo603oool001d0oooo00<000000?ooo`3oool0F@3oool00`00o`00oooo0?ooo`020?ooo`030000
003oool0oooo0?l0oooo603oool001d0oooo00<000000?ooo`3oool0F@3oool00`00o`00oooo0?oo
o`030?ooo`040000003oool0oooo0?ooo`@0?cooo`3ooolB0?ooo`007@3oool00`000000oooo0?oo
o`1J0?ooo`03003o003oool0oooo0080oooo00@000000?ooo`3oool0oooo100o?ooo0?oooa80oooo
000M0?ooo`030000003oool0oooo05X0oooo00<00?l00?ooo`3oool00P3oool010000000oooo0?oo
o`3oool403loool0oooo4P3oool001d0oooo00<000000?ooo`3oool0F`3oool01@00o`00oooo0?oo
o`3oool0000000@0oooo0P0o?ooo0?oooa<0oooo000M0?ooo`03000004000000oooo05/0oooo00D0
0?l00?ooo`3oool0oooo0000003o0?oooaT0oooo000M0?ooo`030000003oool0oooo05`0oooo00D0
0?l00?ooo`3oool0oooo000000050?ooo`@0?cooo`3oool?0?ooo`007@3oool00`000000oooo0?oo
o`1L0?ooo`05003o003oool0oooo0?ooo`0000001@3oool403loool0oooo3`3oool001d0oooo00<0
00000?ooo`3oool0G@3oool01000o`00oooo0?ooo`0000050?ooo`@0?cooo`3oool?0?ooo`007@3o
ool00`000000oooo0?ooo`1M0?ooo`04003o003oool0oooo000000H0oooo0P0o?ooo0?oooa00oooo
000M0?ooo`030000003oool0oooo05h0oooo00@00?l00?ooo`3oool00000o`3ooolG0?ooo`007@3o
ool00`000000oooo0?ooo`1N0?ooo`04003o003oool0oooo000000P0oooo100o?ooo0?ooo`/0oooo
000E0?ooo`=000001@3oool00`000000oooo0?ooo`1O0?ooo`03003o003oool0000000P0oooo100o
?ooo0?ooo`/0oooo000F0?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0G`3oool0
0`00o`00oooo000000080?ooo`@0?cooo`3oool;0?ooo`00503oool4@00000D0oooo0P0000000d00
0000oooo0?ooo`1N0?ooo`03003o00000000oooo00P0oooo0P0o?ooo0?ooo``0oooo000D0?ooo`03
@000003ooom0000000H0oooo00<000000?ooo`3oool0H03oool00`00o`00oooo0000003o0?oooaH0
oooo000E0?ooo`9000001P3oool00`000000oooo0?ooo`1Q0?ooo`03003o00000000oooo00T0oooo
100o?ooo0?ooo`P0oooo000F0?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0H@3o
ool00`00o`0000000?ooo`090?ooo`@0?cooo`3oool80?ooo`007@3oool00`000000oooo0?ooo`1R
0?ooo`03003o003oool0oooo00P0oooo100o?ooo0?ooo`P0oooo000M0?ooo`030000003oool0oooo
0680oooo00<00?l00?ooo`3oool02@3oool203loool0oooo2@3oool001d0oooo00<000000?ooo`3o
ool0H`3oool00`00o`00oooo0?ooo`3o0?oooa<0oooo000M0?ooo`030000003oool0oooo06<0oooo
00<00?l00?ooo`3oool02`3oool403loool0oooo103oool001d0oooo00<000000?ooo`3oool0H`3o
ool00`0000000?l00?ooo`0;0?ooo`@0?cooo`3oool40?ooo`007@3oool00`00001000000?ooo`1S
0?ooo`0300000000o`00oooo00/0oooo100o?ooo0?ooo`@0oooo000M0?ooo`030000003oool0oooo
06<0oooo00<000000?ooo`00o`00303oool203loo`030?ooo`0o?ol0?coo0080?cooo`3oool001d0
oooo00<000000?ooo`3oool0I03oool00`0000000?l00?ooo`0>0?ooo`@0?cooo`3oool001d0oooo
00<000000?ooo`3oool0I03oool00`000000oooo003o000>0?ooo`@0?cooo`3oool001d0oooo00<0
00000?ooo`3oool0I03oool010000000oooo0?ooo`00o`0>0?ooo`80?cooo`3oool10?ooo`007@3o
ool00`000000oooo0?ooo`1T0?ooo`040000003oool0oooo003o0100oooo100o?ool0?ooo`007@3o
ool00`000000oooo0?ooo`1T0?ooo`050000003oool0oooo0?ooo`00o`003`3oool403looo`0oooo
000M0?ooo`030000003oool0oooo06D0oooo00D000000?ooo`3oool0oooo003o000>0?ooo`P0?coo
@03oool403loo`80oooo100o?ol00`3oool0?coo03loo`0203loo`80oooo100o?ol00`3oool0?coo
03loo`0203loo`80oooo100o?ol20?ooo`@0?coo0P3oool403loo`80oooo100o?ol20?ooo`@0?coo
0P3oool403loo`<0oooo100o?ol20?ooo`@0?coo0`3oool403loo`<0oooo100o?ol30?ooo`@0?coo
0`3oool403loo`<0oooo100o?ol40?ooo`@0?coo0`3oool403loo`@0oooo100o?ol40?ooo`@0?coo
103oool403loob<0oooo000M0?ooo`030000003oool0oooo06D0oooo00D000000?ooo`3oool0oooo
003o000?0?ooo`80?coo00<0oooo03loo`0o?ol00P0o?olf0?ooo`@0?coo00<0oooo03loo`0o?ol0
0P0o?ol00`3oool0?coo03loo`0203loo`80oooo100o?ol00`3oool0?coo03loo`0203loo`80oooo
100o?ol00`3oool0?coo03loo`0203loo`80oooo100o?ol20?ooo`@0?coo0P3oool403loo`80oooo
100o?ol20?ooofD00?l07`3oool001d0oooo00<00000@000003oool0I@3oool00`000000oooo0?oo
o`020?ooo`03003o003oool0oooo00l0oooo100o?olI0?oooaP00000100o?ol00`000000?coo03lo
o`0203loo`030000000o?ol0?coo0080?coo00<0000003loo`0o?ol00P0o?ol2000000@0?coo00<0
000003loo`0o?ol00P0o?ol2000000@0?coo00<0000003loo`0o?ol00P0o?ol2000000@0?coo0P00
000B003o00@0?coo0P00000403loo`<00000100o?ol2000000@0?coo0`00000403loo`<00000100o
?ol3000000@0?coo0`00000403loo`<00000100o?ol4000000@0?coo0`00000403loo`@00000100o
?ol4000000@0?coo1000000403loo`<0000000=000000?ooo`3oool07@3oool001d0oooo00<00000
0?ooo`3oool0I@3oool00`000000oooo0?ooo`020?ooo`03003o003oool0oooo0100oooo0P0o?ol0
0`3oool0?coo03loo`0203looaD0oooo00<000000?ooo`3oool0403oool403loo`030?ooo`0o?ol0
?coo0080?coo00<0oooo03loo`0o?ol00P0o?ol00`3oool0?coo03loo`0203loo`80oooo0P0o?ol4
0?ooo`80?coo0`3oool203loo`@0oooo0P0o?ol30?ooo`80?coo00<0oooo003o0000o`001P00o`00
0`3oool0?coo03loo`040?ooo`80?coo103oool203loo`@0oooo0P0o?ol40?ooo`80?coo1@3oool2
03loo`@0oooo0P0o?ol50?ooo`80?coo1@3oool203loo`D0oooo0P0o?ol50?ooo`80?coo1@3oool2
03loo`H0oooo0P0o?ol50?ooo`80?coo1P3oool203loo`H0oooo0P0o?ol60?ooo`80?coo903oool0
01d0oooo00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`030?ooo`03003o003oool0oooo
0180oooo200o?ol@0?ooo`030000003oool0oooo00`0oooo100o?ol00`3oool0?coo03loo`0203lo
o`030?ooo`0o?ol0?coo0080?coo0P3oool203loo`<0oooo0P0o?olG0?ooo`D00?l0WP3oool001d0
oooo00<000000?ooo`3oool0IP3oool00`000000oooo0?ooo`030?ooo`03003o003oool0oooo0140
oooo300o?ol<0?ooo`030000003oool0oooo00<0oooo100o?ol00`3oool0?coo03loo`0603loo`03
0?ooo`0o?ol0?coo0080?coo0P3oool203looa/0oooo1P00o`2S0?ooo`007@3oool00`000000oooo
0?ooo`1V0?ooo`030000003oool0oooo00<0oooo00<00?l00?ooo`3oool04P3oool203loo`030?oo
o`0o?ol0?coo00H0?coo00<0oooo03loo`0o?ol02P0o?ol00`3oool0?coo03loo`0603loo`030?oo
o`0o?ol0?coo00H0?coo0P3oool203looaX0oooo1P00o`2Y0?ooo`007@3oool00`000000oooo0?oo
o`1V0?ooo`030000003oool0oooo00@0oooo00<00?l00?ooo`3oool05@3oool203loo`030?ooo`0o
?ol0?coo0080?coo00<0oooo03loo`0o?ol02P0o?ol00`3oool0?coo03loo`0603loo`030?ooo`0o
?ol0?coo0080?coo00<0oooo03loo`0o?ol06`3oool4003o0:l0oooo000M0?ooo`030000003oool0
oooo06H0oooo00<000000?ooo`3oool0103oool00`00o`00oooo0?ooo`0I0?ooo`80?coo0P3oool<
03loo`030?ooo`0o?ol0?coo0080?coo00<0oooo03loo`0o?ol00`3oool203looa`0oooo0`00o`2c
0?ooo`007@3oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo00D0oooo00<00?l00?oo
o`3oool07@3oool203loo`80oooo0P0o?ol20?ooo`80?coo00<000000?ooo`3oool00P0o?olS0?oo
o`800?l0]P3oool001d0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`050?ooo`03
003o003oool0oooo02H0oooo00<000000?ooo`3oool08P3oool3003o0;P0oooo000M0?ooo`030000
04000000oooo06L0oooo00<000000?ooo`3oool01@3oool00`00o`00oooo0?ooo`0U0?ooo`030000
003oool0oooo0200oooo0`00o`2k0?ooo`007@3oool00`000000oooo0?ooo`1W0?ooo`030000003o
ool0oooo00H0oooo00<00?l00?ooo`3oool0903oool00`000000oooo0?ooo`0N0?ooo`800?l0_P3o
ool001d0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`070?ooo`03003o003oool0
oooo02<0oooo00<000000?ooo`3oool0703oool2003o0<00oooo000M0?ooo`030000003oool0oooo
06L0oooo00<000000?ooo`3oool01`3oool00`00o`00oooo0?ooo`0R0?ooo`030000003oool0oooo
01X0oooo0`00o`320?ooo`007@3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00L0
oooo00<00?l00?ooo`3oool08@3oool00`000000oooo0?ooo`0H0?ooo`800?l0a@3oool001d0oooo
00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`070?ooo`03003o003oool0oooo0240oooo
00<000000?ooo`3oool05P3oool2003o0<L0oooo000M0?ooo`030000003oool0oooo06P0oooo00<0
00000?ooo`3oool0203oool00`00o`00oooo0?ooo`0P0?ooo`030000003oool0oooo01<0oooo0`00
o`390?ooo`00503oool2@00000L0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`09
0?ooo`03003o003oool0oooo01l0oooo00<000000?ooo`3oool04@3oool2003o0<`0oooo000D0?oo
o`03@000003ooom0000000H0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`0:0?oo
o`03003o003oool0oooo01d0oooo00<000000?ooo`3oool0403oool2003o0<h0oooo000D0?ooo`03
@000003ooom0000000H0oooo0P0000000d000000oooo0?ooo`1V0?ooo`030000003oool0oooo00/0
oooo0P00o`0M0?ooo`030000003oool0oooo00d0oooo0`00o`3@0?ooo`00503oool2@00000L0oooo
00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0<0?ooo`03003o003oool0oooo01X0oooo
00<000000?ooo`3oool02`3oool2003o0=<0oooo000D0?ooo`03@000003oool0oooo00H0oooo00<0
00000?ooo`3oool0J@3oool00`000000oooo0?ooo`0=0?ooo`03003o003oool0oooo01T0oooo00<0
00000?ooo`3oool02@3oool2003o0=D0oooo000E0?ooo`9000001P3oool00`000000oooo0?ooo`1Y
0?ooo`030000003oool0oooo00h0oooo00<00?l00?ooo`3oool0603oool00`000000oooo0?ooo`06
0?ooo`<00?l0e`3oool001d0oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0?0?oo
o`03003o003oool0oooo01L0oooo00<000000?ooo`3oool0103oool2003o0=X0oooo000M0?ooo`03
0000003oool0oooo06T0oooo00<000000?ooo`3oool0403oool2003o01L0oooo00@000000?ooo`3o
ool0oooo0`00o`3L0?ooo`007@3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo0140
oooo00<00?l00?ooo`3oool04`3oool00`000000oooo0?ooo`02003o0=l0oooo000M0?ooo`030000
003oool0oooo06X0oooo00<000000?ooo`3oool04P3oool2003o01<0oooo0`00o`3Q0?ooo`007@3o
ool00`00001000000?ooo`1Z0?ooo`030000003oool0oooo01@0oooo0`00o`0=0?ooo`<00?l000<0
00000?ooo`3oool0h@3oool001d0oooo00<000000?ooo`3oool0JP3oool00`000000oooo0?ooo`0G
0?ooo`d00?l00`3oool00`000000oooo0?ooo`3Q0?ooo`007@3oool00`000000oooo0?ooo`1Z0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool0hP3oool001d0oooo00<000000?ooo`3o
ool0J`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0>80oooo000M0?ooo`030000
003oool0oooo06/0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`3R0?ooo`007@3o
ool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0hP3o
ool001d0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo0>80oooo000M0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`3S0?ooo`007@3oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo02@0
oooo00<000000?ooo`3oool0h`3oool001d0oooo00<00000@000003oool0K03oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo0><0oooo000M0?ooo`030000003oool0oooo06`0oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`3S0?ooo`007@3oool00`000000oooo0?ooo`1/
0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0h`3oool001d0oooo00<000000?oo
o`3oool0K03oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0>@0oooo000M0?ooo`03
0000003oool0oooo06`0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`3T0?ooo`00
7@3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0
i03oool001d0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`0Q0?ooo`030000003o
ool0oooo0>@0oooo000M0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`3T0?ooo`007@3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool0i03oool001d0oooo00<00000@000003oool0K@3oool00`000000
oooo0?ooo`0P0?ooo`030000003oool0oooo0>D0oooo000M0?ooo`030000003oool0oooo06h0oooo
00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`3U0?ooo`007@3oool00`000000oooo0?oo
o`1^0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0i@3oool001d0oooo00<00000
0?ooo`3oool0KP3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0>D0oooo000M0?oo
o`030000003oool0oooo06h0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`3U0?oo
o`007@3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3o
ool0iP3oool001d0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?ooo`0N0?ooo`030000
003oool0oooo0>H0oooo000E0?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool0K`3o
ool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0>H0oooo000D0?ooo`03@000003ooom0
000000H0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo0>H0oooo000D0?ooo`03@000003ooom0000000H0oooo0P0000000d000000oooo0?ooo`1]0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool0iP3oool001D0oooo00=000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool0iP3oool001@0oooo00=000000?oood0000001P3oool00`000000oooo0?ooo`1_0?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool0i`3oool001D0oooo00=000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0i`3o
ool001d0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo0>L0oooo000M0?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`3W0?ooo`007@3oool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0i`3oool001d0oooo00<000000?ooo`3oool0L03oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo0>L0oooo000M0?ooo`030000003oool0oooo0740oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`3X0?ooo`007@3oool00`00001000000?ooo`1a
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0j03oool001d0oooo00<000000?oo
o`3oool0L@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0>P0oooo000M0?ooo`03
0000003oool0oooo0740oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`3X0?ooo`00
7@3oool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
j03oool001d0oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo0>T0oooo000M0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`3Y0?ooo`007@3oool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool0j@3oool001d0oooo00<000000?ooo`3oool0LP3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo0>T0oooo000M0?ooo`030000003oool0oooo07<0oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`3Y0?ooo`007@3oool00`00001000000?oo
o`1c0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0jP3oool001d0oooo00<00000
0?ooo`3oool0L`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0>X0oooo000M0?oo
o`030000003oool0oooo07<0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`3Z0?oo
o`007@3oool00`000000oooo0?ooo`1c0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool0jP3oool001d0oooo00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo0>X0oooo000M0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`3[0?ooo`007@3oool00`000000oooo0?ooo`1d0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0j`3oool001d0oooo00<000000?ooo`3oool0M03oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo0>/0oooo000M0?ooo`030000003oool0oooo07@0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`3[0?ooo`007@3oool00`0000100000
0?ooo`1d0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0k03oool001d0oooo00<0
00000?ooo`3oool0M03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0>`0oooo000M
0?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`3/
0?ooo`007@3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0k03oool001d0oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0>d0oooo000M0?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`3]0?ooo`007@3oool00`000000oooo0?ooo`1f0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool0k@3oool000h0oooo1D0000020?ooo`03@000003oool0
oooo00D0oooo00<000000?ooo`3oool0MP3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo0>d0oooo000@0?ooo`07@000003oool0oooo0?oood000000oooo@00000060?ooo`030000003o
ool0oooo07H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`3]0?ooo`00403oool0
1d000000oooo0?ooo`3ooom000000?oood0000001P3oool200000003@000003oool0oooo07D0oooo
4P00003_0?ooo`00403oool01d000000oooo0?ooo`3ooom000000?oood0000001P3oool00`000000
oooo0?ooo`3o0?ooogT0oooo000@0?ooo`07@000003oool0oooo0?oood000000oooo@00000060?oo
o`030000003oool0oooo0?l0ooooN@3oool000l0oooo0T0000040?ooo`03@000003oool0oooo00D0
oooo00<000000?ooo`3oool0o`3ooomi0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogT0oooo
000M0?ooo`030000003oool0oooo0?l0ooooN@3oool001d0oooo00<000000?ooo`3oool0o`3ooomi
0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogT0oooo000M0?ooo`030000003oool0oooo0?l0
ooooN@3oool001d0oooo00<00000@000003oool0o`3ooomi0?ooo`007@3oool00`000000oooo0?oo
o`3o0?ooogT0oooo000M0?ooo`030000003oool0oooo0?l0ooooN@3oool001d0oooo00<000000?oo
o`3oool0o`3ooomi0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogT0oooo000M0?ooo`030000
003oool0oooo0?l0ooooN@3oool001d0oooo00<000000?ooo`3oool0o`3ooomi0?ooo`007@3oool0
0`000000oooo0?ooo`3o0?ooogT0oooo000M0?ooo`030000003oool0oooo0?l0ooooN@3oool001d0
oooo00<00000@000003oool0o`3ooomi0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogT0oooo
000M0?ooo`030000003oool0oooo0?l0ooooN@3oool001d0oooo00<000000?ooo`3oool0o`3ooomi
0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogT0oooo000M0?ooo`030000003oool0oooo0?l0
ooooN@3oool001d0oooo00<000000?ooo`3oool0o`3ooomi0?ooo`007@3oool00`000000oooo0?oo
o`3o0?ooogT0oooo000M0?ooo`030000003oool0oooo0?l0ooooN@3oool001d0oooo00<00000@000
003oool0o`3ooomi0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogT0oooo000M0?ooo`030000
003oool0oooo0?l0ooooN@3oool001d0oooo00<000000?ooo`3oool0o`3ooomi0?ooo`007@3oool0
0`000000oooo0?ooo`3o0?ooogT0oooo000M0?ooo`030000003oool0oooo0?l0ooooN@3oool001d0
oooo00<000000?ooo`3oool0o`3ooomi0?ooo`003P3oool5@00000040?oood0000100000@00000H0
oooo00<000000?ooo`3oool0o`3ooomi0?ooo`00403oool01D000000oooo0?ooo`3ooom0000000P0
oooo00<000000?ooo`3oool0o`3ooomi0?ooo`00403oool00d000000oooo0?ooo`020?ooo`03@000
003oool0oooo00D0oooo00=00000000004000000o`3ooomi0?ooo`00403oool00d000000oooo0?oo
o`020?ooo`03@000003oool0oooo0?l0ooooP@3oool00100oooo00M000000?ooo`3oool0oooo@000
003ooom000000?l0ooooPP3oool000l0oooo0T0000040?ooo`03@000003oool0oooo0?l0ooooP@3o
ool00?l0ooooV@3oool00?l0ooooV@3oool00?l0ooooV@3oool00?l0ooooV@3oool00?l0ooooV@3o
ool00?l0ooooV@3oool00?l0ooooV@3oool00?l0ooooV@3oool00?l0ooooV@3oool00?l0ooooV@3o
ool001/0oooo0T00003o0?ooog`0oooo000J0?ooo`03@000003ooom000000?l0ooooO03oool001X0
oooo00=000000?oood000000o`3oooml0?ooo`006P3oool014000000oooo0?oood00003o0?ooog/0
oooo000I0?ooo`05@000003oool0oooo0?oood000000o`3ooomk0?ooo`006@3oool2@00000030?oo
od00001000000?l0ooooN`3oool00?l0ooooV@3oool00?l0ooooV@3oool00?l0ooooV@3oool00?l0
ooooV@3oool00001\
\>"],
  ImageRangeCache->{{{0, 407.813}, {251.563, 0}} -> {11.5979, -0.746163, 
  0.288069, 0.0559326}}]
}, Open  ]],

Cell[TextData[
"\"Err - rozdiel medzi explicitn\[YAcute]m rie\.9aen\[IAcute]m a na\.9aim v\
\[YAcute]sledkom\ntr1: tabu\:017eka chyby pribli\.9en\[EAcute]ho \
rie\.9aenia\""], "Text"],

Cell["\<\
Err[i_,sgm_]:=Condor[xs[[i]],X1,X2,X3,X4,sgm,r,DD,t]-ys[[i]];
tr1:=Table[{xs[[i]],Err[i,sigma]},{i,2m+1}];\
\>", "Input"],

Cell["\"Maximov\[AAcute] chyba\"", "Text"],

Cell["\<\
Print[\"m = \",m,\" n = \",n,\" trans = \",trans,\" Max.chyba = \
\",Max[Table[Abs[Err[i,str]],{i,2m+1}]]]\
\>", "Input"],

Cell["\"Graf chyby pri delen\[IAcute] m=50, n=30\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=ListPlot[tr1,PlotStyle->{PointSize[0.02],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->All]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.132035 0.00738817 0.379119 10.6116 [
[.16349 .36662 -6 -9 ]
[.16349 .36662 6 0 ]
[.31126 .36662 -6 -9 ]
[.31126 .36662 6 0 ]
[.45902 .36662 -6 -9 ]
[.45902 .36662 6 0 ]
[.60678 .36662 -9 -9 ]
[.60678 .36662 9 0 ]
[.75455 .36662 -9 -9 ]
[.75455 .36662 9 0 ]
[.90231 .36662 -9 -9 ]
[.90231 .36662 9 0 ]
[.00323 .06077 -30 -4.5 ]
[.00323 .06077 0 4.5 ]
[.00323 .16689 -30 -4.5 ]
[.00323 .16689 0 4.5 ]
[.00323 .273 -30 -4.5 ]
[.00323 .273 0 4.5 ]
[.00323 .48524 -24 -4.5 ]
[.00323 .48524 0 4.5 ]
[.00323 .59135 -24 -4.5 ]
[.00323 .59135 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.16349 .37912 m
.16349 .38537 L
s
[(40)] .16349 .36662 0 1 Mshowa
.31126 .37912 m
.31126 .38537 L
s
[(60)] .31126 .36662 0 1 Mshowa
.45902 .37912 m
.45902 .38537 L
s
[(80)] .45902 .36662 0 1 Mshowa
.60678 .37912 m
.60678 .38537 L
s
[(100)] .60678 .36662 0 1 Mshowa
.75455 .37912 m
.75455 .38537 L
s
[(120)] .75455 .36662 0 1 Mshowa
.90231 .37912 m
.90231 .38537 L
s
[(140)] .90231 .36662 0 1 Mshowa
.125 Mabswid
.05267 .37912 m
.05267 .38287 L
s
.08961 .37912 m
.08961 .38287 L
s
.12655 .37912 m
.12655 .38287 L
s
.20043 .37912 m
.20043 .38287 L
s
.23737 .37912 m
.23737 .38287 L
s
.27431 .37912 m
.27431 .38287 L
s
.3482 .37912 m
.3482 .38287 L
s
.38514 .37912 m
.38514 .38287 L
s
.42208 .37912 m
.42208 .38287 L
s
.49596 .37912 m
.49596 .38287 L
s
.5329 .37912 m
.5329 .38287 L
s
.56984 .37912 m
.56984 .38287 L
s
.64372 .37912 m
.64372 .38287 L
s
.68066 .37912 m
.68066 .38287 L
s
.7176 .37912 m
.7176 .38287 L
s
.79149 .37912 m
.79149 .38287 L
s
.82843 .37912 m
.82843 .38287 L
s
.86537 .37912 m
.86537 .38287 L
s
.93925 .37912 m
.93925 .38287 L
s
.97619 .37912 m
.97619 .38287 L
s
.25 Mabswid
0 .37912 m
1 .37912 L
s
.01573 .06077 m
.02198 .06077 L
s
[(-0.03)] .00323 .06077 1 0 Mshowa
.01573 .16689 m
.02198 .16689 L
s
[(-0.02)] .00323 .16689 1 0 Mshowa
.01573 .273 m
.02198 .273 L
s
[(-0.01)] .00323 .273 1 0 Mshowa
.01573 .48524 m
.02198 .48524 L
s
[(0.01)] .00323 .48524 1 0 Mshowa
.01573 .59135 m
.02198 .59135 L
s
[(0.02)] .00323 .59135 1 0 Mshowa
.125 Mabswid
.01573 .08199 m
.01948 .08199 L
s
.01573 .10322 m
.01948 .10322 L
s
.01573 .12444 m
.01948 .12444 L
s
.01573 .14566 m
.01948 .14566 L
s
.01573 .18811 m
.01948 .18811 L
s
.01573 .20933 m
.01948 .20933 L
s
.01573 .23056 m
.01948 .23056 L
s
.01573 .25178 m
.01948 .25178 L
s
.01573 .29423 m
.01948 .29423 L
s
.01573 .31545 m
.01948 .31545 L
s
.01573 .33667 m
.01948 .33667 L
s
.01573 .3579 m
.01948 .3579 L
s
.01573 .40034 m
.01948 .40034 L
s
.01573 .42157 m
.01948 .42157 L
s
.01573 .44279 m
.01948 .44279 L
s
.01573 .46401 m
.01948 .46401 L
s
.01573 .50646 m
.01948 .50646 L
s
.01573 .52768 m
.01948 .52768 L
s
.01573 .54891 m
.01948 .54891 L
s
.01573 .57013 m
.01948 .57013 L
s
.01573 .03955 m
.01948 .03955 L
s
.01573 .01832 m
.01948 .01832 L
s
.01573 .61257 m
.01948 .61257 L
s
.25 Mabswid
.01573 0 m
.01573 .61803 L
s
.25 .25 1 r
.02 w
.02381 .37913 Mdot
.0269 .37906 Mdot
.03005 .37898 Mdot
.03326 .37888 Mdot
.03653 .37874 Mdot
.03987 .37854 Mdot
.04328 .37826 Mdot
.04675 .37786 Mdot
.05029 .3773 Mdot
.0539 .37652 Mdot
.05759 .37547 Mdot
.06134 .37408 Mdot
.06517 .37225 Mdot
.06908 .36991 Mdot
.07306 .36697 Mdot
.07713 .36339 Mdot
.08127 .35912 Mdot
.0855 .35419 Mdot
.08981 .3487 Mdot
.0942 .34283 Mdot
.09868 .33689 Mdot
.10325 .33134 Mdot
.10791 .32675 Mdot
.11267 .32382 Mdot
.11751 .32336 Mdot
.12246 .32623 Mdot
.1275 .33325 Mdot
.13264 .3451 Mdot
.13788 .36224 Mdot
.14323 .38476 Mdot
.14868 .41228 Mdot
.15425 .4439 Mdot
.15992 .47811 Mdot
.1657 .51286 Mdot
.1716 .54562 Mdot
.17761 .57355 Mdot
.18375 .5937 Mdot
.19 .60332 Mdot
.19638 .60012 Mdot
.20289 .58255 Mdot
.20952 .55008 Mdot
.21629 .50333 Mdot
.22319 .44417 Mdot
.23023 .37565 Mdot
.2374 .30184 Mdot
.24472 .22753 Mdot
.25219 .15786 Mdot
.2598 .09784 Mdot
.26756 .05191 Mdot
.27548 .02351 Mdot
.28355 .01472 Mdot
.29178 .02604 Mdot
.30018 .05635 Mdot
.30874 .10302 Mdot
.31747 .16213 Mdot
.32638 .22893 Mdot
.33546 .29829 Mdot
.34472 .36518 Mdot
.35416 .42518 Mdot
.3638 .47483 Mdot
.37362 .51187 Mdot
.38364 .53533 Mdot
.39385 .54549 Mdot
.40427 .54367 Mdot
.41489 .53199 Mdot
.42573 .51301 Mdot
.43678 .48946 Mdot
.44805 .46393 Mdot
.45954 .43864 Mdot
.47126 .41534 Mdot
.48321 .39523 Mdot
.4954 .37897 Mdot
.50783 .36675 Mdot
.5205 .35838 Mdot
.53343 .35341 Mdot
.54661 .35125 Mdot
.56006 .35123 Mdot
.57377 .35272 Mdot
.58775 .35514 Mdot
.60201 .358 Mdot
.61655 .36095 Mdot
.63138 .36369 Mdot
.6465 .36606 Mdot
.66193 .36793 Mdot
.67765 .36926 Mdot
.69369 .37001 Mdot
.71005 .37018 Mdot
.72673 .36979 Mdot
.74375 .36884 Mdot
.7611 .36735 Mdot
.77879 .36533 Mdot
.79683 .3628 Mdot
.81523 .35976 Mdot
.834 .35627 Mdot
.85314 .3524 Mdot
.87265 .3483 Mdot
.89256 .34434 Mdot
.91285 .34137 Mdot
.93355 .34147 Mdot
.95466 .34978 Mdot
.97619 .37912 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{318, 196.438},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004n0000a2000`400?l00000o`00003oo`3ooolo
0?ooo`00o`3ooolo0?ooo`00o`3ooolo0?ooo`00o`3ooolo0?ooo`00o`3ooolo0?ooo`00o`3ooolo
0?ooo`00o`3ooolo0?ooo`00o`3ooolo0?ooo`00o`3ooolo0?ooo`008@3oool00`000000oooo0?oo
o`3o0?oooa/0oooo000Q0?ooo`030000003oool0oooo0?l0oooo6`3oool00240oooo00<000000?oo
o`3oool0o`3ooolK0?ooo`008@3oool00`000000oooo0?ooo`180?ooo`@0?coocP3oool00240oooo
00<000000?ooo`3oool0B03oool403loolh0oooo000Q0?ooo`03000004000000oooo04P0oooo100o
?oo>0?ooo`008@3oool00`000000oooo0?ooo`160?ooo`D0?cooc`3oool00240oooo00<000000?oo
o`3oool0AP3oool803lool`0oooo000Q0?ooo`030000003oool0oooo04H0oooo200o?oo<0?ooo`00
8@3oool00`000000oooo0?ooo`170?ooo`80?coo00<0oooo03loo`0o?ol00P0o?oo<0?ooo`008@3o
ool00`000000oooo0?ooo`1;0?ooo`80?cooc@3oool00240oooo00<00000@000003oool0o`3ooolK
0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooa/0oooo000Q0?ooo`030000003oool0oooo0?l0
oooo6`3oool00240oooo00<000000?ooo`3oool0@`3oool403loom<0oooo000<0?ooo`03@000003o
ool0oooo0080oooo00=000000?ooo`3oool00P3oool014000000oooo0?ooo`3oool2@00000D0oooo
00<000000?ooo`3oool0@`3oool403loo`H0oooo100o?oo90?ooo`002`3oool00d000000oooo@000
00070?ooo`03@000003ooom0000000@0oooo00=000000?ooo`3oool00P3oool00`000000oooo0?oo
o`130?ooo`@0?coo1P3oool403loolT0oooo00060?ooo`=000000P3oool00d000000oooo@0000007
0?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3oool00`3oool200000003@000003oool0
oooo0480oooo0P0o?ol70?ooo`@0?coob@3oool000/0oooo00=000000?oood0000001`3oool00d00
0000oooo@00000040?ooo`03@000003oool0oooo0080oooo00<000000?ooo`3oool0CP3oool203lo
olX0oooo000;0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000
oooo@00000040?ooo`030000003oool0oooo0?l0oooo6`3oool000`0oooo00=000000?ooo`3oool0
1`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0
o`3ooolK0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooa/0oooo000Q0?ooo`030000003oool0
oooo0?l0oooo6`3oool00240oooo00<00000@000003oool0o`3ooolK0?ooo`008@3oool00`000000
oooo0?ooo`3o0?oooa/0oooo000Q0?ooo`030000003oool0oooo0?l0oooo6`3oool00240oooo00<0
00000?ooo`3oool0o`3ooolK0?ooo`008@3oool00`000000oooo0?ooo`110?ooo`@0?cooe@3oool0
0240oooo00<000000?ooo`3oool0@@3oool403loomD0oooo000Q0?ooo`030000003oool0oooo0440
oooo100o?ol:0?ooo`@0?cooa`3oool00240oooo00<00000@000003oool0@P3oool203loo`/0oooo
100o?oo70?ooo`008@3oool00`000000oooo0?ooo`1?0?ooo`@0?cooa`3oool00240oooo00<00000
0?ooo`3oool0D03oool203loolP0oooo000Q0?ooo`030000003oool0oooo0?l0oooo6`3oool00240
oooo00<000000?ooo`3oool0o`3ooolK0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooa/0oooo
000Q0?ooo`03000004000000oooo0?l0oooo6`3oool00240oooo00<000000?ooo`3oool0o`3ooolK
0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooa/0oooo000Q0?ooo`030000003oool0oooo0?l0
oooo6`3oool00240oooo00<000000?ooo`3oool0o`3ooolK0?ooo`008@3oool00`000000oooo0?oo
o`3o0?oooa/0oooo000Q0?ooo`03000004000000oooo0?l0oooo6`3oool00240oooo00<000000?oo
o`3oool0o`3ooolK0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooa/0oooo000Q0?ooo`030000
003oool0oooo03l0oooo100o?ooG0?ooo`00303oool00d000000oooo0?ooo`020?ooo`03@000003o
ool0oooo0080oooo00A000000?ooo`3oool0oooo0d0000040?ooo`030000003oool0oooo03l0oooo
100o?ol?0?ooo`@0?cooa03oool000/0oooo00=000000?oood0000001`3oool00d000000oooo@000
00020?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0?`3oool403loo`l0oooo100o
?oo40?ooo`001P3oool3@0000080oooo00=000000?oood0000001`3oool00d000000oooo@0000003
0?ooo`03@000003oool0oooo00<0oooo0P0000000d000000oooo0?ooo`0n0?ooo`80?coo403oool4
03lool@0oooo000;0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000`3oool00d00
0000oooo0?ooo`030?ooo`030000003oool0oooo05<0oooo0P0o?oo50?ooo`002`3oool00d000000
oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool00`000000
oooo0?ooo`3o0?oooa/0oooo000<0?ooo`03@000003oool0oooo00L0oooo00=000000?ooo`3oool0
0P3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo6`3oool00240oooo00<0
00000?ooo`3oool0o`3ooolK0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooa/0oooo000Q0?oo
o`03000004000000oooo0?l0oooo6`3oool00240oooo00<000000?ooo`3oool0o`3ooolK0?ooo`00
8@3oool00`000000oooo0?ooo`3o0?oooa/0oooo000Q0?ooo`030000003oool0oooo0?l0oooo6`3o
ool00240oooo00<000000?ooo`3oool0o`3ooolK0?ooo`008@3oool00`000000oooo0?ooo`3o0?oo
oa/0oooo000Q0?ooo`03000004000000oooo0?l0oooo6`3oool00240oooo00<000000?ooo`3oool0
o`3ooolK0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooa/0oooo000Q0?ooo`030000003oool0
oooo0?l0oooo6`3oool00240oooo00<000000?ooo`3oool0o`3ooolK0?ooo`008@3oool00`000000
oooo0?ooo`0m0?ooo`@0?coo4`3oool403lool80oooo000Q0?ooo`03000004000000oooo03d0oooo
100o?olC0?ooo`@0?coo`P3oool00240oooo00<000000?ooo`3oool0?@3oool403looa<0oooo100o
?oo20?ooo`008@3oool00`000000oooo0?ooo`0n0?ooo`80?coo5@3oool203lool<0oooo000Q0?oo
o`030000003oool0oooo0?l0oooo6`3oool00240oooo00<000000?ooo`3oool0o`3ooolK0?ooo`00
8@3oool00`000000oooo0?ooo`3o0?oooa/0oooo000Q0?ooo`03000004000000oooo0?l0oooo6`3o
ool00240oooo00<000000?ooo`3oool0o`3ooolK0?ooo`008@3oool00`000000oooo0?ooo`3o0?oo
oa/0oooo000Q0?ooo`030000003oool0oooo0?l0oooo6`3oool000`0oooo00=000000?ooo`3oool0
0P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00E000000`3oool00`000000oooo
0?ooo`3o0?oooa/0oooo000;0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000`3o
ool00d000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo6`3oool000H0oooo0d000002
0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000`3oool00d000000oooo0?ooo`03
0?ooo`80000000=000000?ooo`3oool0o`3ooolI0?ooo`002`3oool00d000000oooo@00000070?oo
o`03@000003ooom0000000<0oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?oo
oa/0oooo000;0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000`3oool00d000000
oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo6`3oool000`0oooo00=000000?ooo`3oool0
1`3oool014000000oooo0?ooo`3oool2@00000D0oooo00<000000?ooo`3oool0o`3ooolK0?ooo`00
8@3oool00`000000oooo0?ooo`3o0?oooa/0oooo000Q0?ooo`030000003oool0oooo0?l0oooo6`3o
ool00240oooo00<000000?ooo`3oool0o`3ooolK0?ooo`008@3oool00`00001000000?ooo`1G0?oo
o`@0?coo_`3oool00240oooo00<000000?ooo`3oool0>`3oool403looaP0oooo100o?ono0?ooo`00
8@3oool00`000000oooo0?ooo`0k0?ooo`@0?coo603oool403lookl0oooo000Q0?ooo`030000003o
ool0oooo03/0oooo100o?olI0?ooo`80?coo`03oool00240oooo00<000000?ooo`3oool0?03oool2
03loom`0oooo000Q0?ooo`030000003oool0oooo0?l0oooo6`3oool00240oooo00<00000@000003o
ool0o`3ooolK0?ooo`008@3oool00`000000oooo0?ooo`0G0?ooo`D0?coooP3oool00240oooo00<0
00000?ooo`3oool05@3oool803loood0oooo000Q0?ooo`030000003oool0oooo01D0oooo200o?oom
0?ooo`008@3oool00`000000oooo0?ooo`0D0?ooo`/0?coon`3oool00240oooo00<000000?ooo`3o
ool04`3oool503loo`80oooo1@0o?ook0?ooo`008@3oool00`00001000000?ooo`0C0?ooo`D0?coo
0`3oool403loo`H0oooo0d0000020?ooo`03@000003oool0oooo0240oooo0T0000040?ooo`03@000
003oool0oooo02<0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0N0?ooo`E00000
0P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01/0oooo1D000000103ooom00000
@000040000030?ooo`03@000003oool0oooo01`0oooo1D0000020?ooo`03@000000o?ol0?coo0080
?coo00=000000?ooo`0o?ol00`0o?olC0?ooo`008@3oool00`000000oooo0?ooo`0A0?ooo`H0?coo
1@3oool203loo`P0oooo00I000000?ooo`3ooom000000?oood00000R0?ooo`03@000003ooom00000
0080oooo00=000000?oood0000008`3oool00d000000oooo@00000020?ooo`03@000003ooom00000
0240oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood0000007P3o
ool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oood0000007`3oool403loo`80oooo
100o?ol00`3ooom0000003loo`0303looa<0oooo000Q0?ooo`030000003oool0oooo0140oooo1@0o
?ol60?ooo`@0?coo103oool4@00000040?oood000000oooo@0000280oooo00=000000?oood000000
0P3oool00d000000oooo@000000S0?ooo`03@000003ooom000000080oooo00=000000?oood000000
8@3oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000000N0?oo
o`03@000003oool0oooo0080oooo00M000000?ooo`3oool0oooo@000003ooom0000001T0oooo100o
?ol20?ooo`@0?coo0T00000403loo`030?oood000000?coo00<0?coo4`3oool00240oooo00<00000
0?ooo`3oool0403oool503loo`L0oooo100o?ol40?ooo`03@000003ooom000000080oooo00=00000
0?oood0000008P3oool2@00000<0oooo00=000000?oood000000903oool01d000000oooo0?ooo`3o
oom000000?oood0000004`3oool703loo`L0oooo00M000000?ooo`3oool0oooo@000003ooom00000
0080oooo00=000000?oood0000007P3oool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo
0?oood000000oooo@000000I0?ooo`@0?coo0P3oool403loo`03@000003ooom000000080?coo00A0
00000?oood000000oooo0P0o?ol30?ooo`@0?coo3@3oool00240oooo00<000000?ooo`3oool03`3o
ool503loo`P0oooo100o?ol50?ooo`9000000P3oool00d000000oooo@000000R0?ooo`03@000003o
ool0oooo0080oooo00=000000?oood0000008`3oool00d000000oooo@00000020?ooo`03@000003o
oom0000000l0oooo4`0o?ol30?ooo`03@000003ooom000000080oooo00=000000?oood0000007P3o
ool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000000D0?ooo`@0
?coo00<0oooo03loo`0o?ol00P0o?ol20?ooo`03@000000o?ol0?coo0080oooo0T0000020?ooo`03
@000003ooom0000000H0oooo100o?ol=0?ooo`008@3oool00`000000oooo0?ooo`0?0?ooo`D0?coo
2@3oool203loo`L0oooo00E000000?ooo`3oool0oooo@000000T0?ooo`9000000`3oool00d000000
oooo0?ooo`0S0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool02P3ooolG03loo`03
0?ooo`0o?ol0?coo0080?coo103oool00d000000oooo0?ooo`0L0?ooo`900000103oool00d000000
oooo0?ooo`020?ooo`03@000003oool0oooo00d0oooo100o?ol20?ooo`@0?coo0P3oool203loo`80
oooo0T0000050?ooo`05@000003oool0oooo0?oood0000001`3oool403loo`d0oooo000Q0?ooo`03
000004000000oooo00h0oooo1@0o?ol;0?ooo`@0?cooJP3oool803loo`040?ooo`0o?ol0?coo0?oo
o`80?coo00<0oooo03loo`0o?ol01P0o?ol00`3oool0?coo03loo`0603loocD0oooo100o?ol00`3o
ool0?coo03loo`0203loo`80oooo100o?olJ0?ooo`80?coo3P3oool00240oooo00<000000?ooo`3o
ool0303oool603loo``0oooo100o?olg0?ooo`@0?coo;`3oool403loo`030?ooo`0o?ol0?coo00T0
oooo0P0o?ol20?ooo`80?coo0P3oool<03loobH0oooo100o?ol20?ooo`@0?coo00<0oooo03loo`0o
?ol00P0o?ol00`3oool0?coo03loo`0203loo`<0oooo0P0o?ol[0?ooo`008@3oool00`000000oooo
0?ooo`0;0?ooo`L0?coo303oool403loocL0oooo100o?ol[0?ooo`@0?coo00<0oooo03loo`0o?ol0
5P3oool203loo`030?ooo`0o?ol0?coo00X0?coo00<0oooo03loo`0o?ol00P0o?olC0?ooo`@0?coo
00<0oooo03loo`0o?ol00P0o?ol00`3oool0?coo03loo`0203loo`80oooo100o?ol00`3oool0?coo
03loo`0203loo`80oooo0P0o?ola0?ooo`008@3oool00`000000oooo0?ooo`090?ooo`P0?coo3P3o
ool203loocP0oooo100o?ol[0?ooo`@0?coo7@3oool203loo`030?ooo`0o?ol0?coo00H0?coo00<0
oooo03loo`0o?ol01P0o?ol00`3oool0?coo03loo`0203loo`030?ooo`0o?ol0?coo00H0?coo00<0
oooo03loo`0o?ol00P0o?ol00`3oool0?coo03loo`0203loo`030?ooo`0o?ol0?coo0080?coo0P3o
ool403loo`80oooo0P0o?olf0?ooo`008@3oool00`000000oooo0?ooo`070?ooo`P0?coo:@3oool4
03looah0oooo0P0o?ol/0?ooo`@0?coo8@3oool203loo`030?ooo`0o?ol0?coo0080?coo00<0oooo
03loo`0o?ol01P0o?ol00`3oool0?coo03loo`0203loo`030?ooo`0o?ol0?coo00H0?coo00<0oooo
03loo`0o?ol00P0o?ol00`3oool0?coo03loo`0203loo`80oooo0P0o?ol40?ooo`80?coo>`3oool0
0240oooo4@0o?olZ0?ooo`@0?cooB@3oool603loobH0oooo0P0o?ol30?ooo`80?coo00<0oooo03lo
o`0o?ol00P0o?ol00`3oool0?coo03loo`0203loo`030?ooo`0o?ol0?coo00H0?coo0P3oool203lo
o`<0oooo0P0o?olk0?ooo`@0?coo1`3oool001d0oooo1000000@03loob/00000100o?om9000000@0
?coo<@00000203loo`<000000P0o?ol300000080?coo0P00000203loodD00000100o?ol600000050
0000000Q0?ooo`h0?coo1`3oool00d000000oooo0?ooo`080?ooo`03@000003oool0?coo00<0?coo
1@3oool00`000000oooo0?ooo`070?ooo`03@000003oool0oooo00@0oooo0P0o?ol20?ooo`03@000
003oool0oooo00P0oooo00=000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`03@000
003oool0oooo00L0oooo00=000000?ooo`3oool0203oool00d000000oooo0?ooo`080?ooo`030000
003oool0oooo00D0oooo100o?ol90?ooo`03@000003oool0oooo00P0oooo00=000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`080?ooo`03@000003oool0oooo00P0oooo00=000000?ooo`3oool0
1`3oool00d000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00=000000?ooo`3oool0
203oool00d000000oooo0?ooo`080?ooo`03@000003oool0oooo00L0oooo00<000000?ooo`3oool0
203oool00d000000oooo0?ooo`050?ooo`@0?coo1`3oool00240oooo00<0000003loo`0o?ol02@0o
?olF0?ooo`@0?coo1@3oool00d000000oooo0?ooo`0W0?ooo`03@000003oool0oooo02P0oooo00=0
00000?ooo`3oool01P3oool203looal0oooo00=000000?ooo`3oool0:03oool00d000000oooo0?oo
o`0W0?ooo`03@000003oool0oooo0140oooo0P0o?ol80?ooo`008@3oool00`000000oooo0?ooo`0O
0?ooo`@0?coom`3oool00240oooo00<000000?ooo`3oool0803oool203looel0oooo100o?onE0?oo
o`008@3oool00`000000oooo0?ooo`210?ooo`@0?cooU@3oool00240oooo00<00000@000003oool0
P@3oool403looiD0oooo000Q0?ooo`030000003oool0oooo0880oooo0P0o?onF0?ooo`008@3oool0
0`000000oooo0?ooo`3o0?oooa/0oooo000Q0?ooo`030000003oool0oooo0240oooo100o?ooe0?oo
o`008@3oool00`000000oooo0?ooo`0Q0?ooo`@0?cooF@3oool403looiP0oooo000Q0?ooo`030000
003oool0oooo0240oooo100o?omI0?ooo`@0?cooV03oool00240oooo00<00000@000003oool08P3o
ool203looeX0oooo100o?onH0?ooo`008@3oool00`000000oooo0?ooo`1L0?ooo`@0?coo7`3oool2
03looiT0oooo000Q0?ooo`030000003oool0oooo05`0oooo100o?onj0?ooo`008@3oool00`000000
oooo0?ooo`1L0?ooo`@0?coo^P3oool00240oooo00<000000?ooo`3oool0G@3oool203looa`0oooo
100o?onK0?ooo`008@3oool00`000000oooo0?ooo`1k0?ooo`@0?cooV`3oool00240oooo00<00000
@000003oool08`3oool403loo`l0oooo100o?om10?ooo`@0?cooV`3oool00240oooo00<000000?oo
o`3oool08`3oool403loo`l0oooo100o?om20?ooo`80?cooW03oool00240oooo00<000000?ooo`3o
ool08`3oool403loo`l0oooo100o?ooP0?ooo`008@3oool00`000000oooo0?ooo`0T0?ooo`80?coo
4@3oool203loon40oooo000Q0?ooo`030000003oool0oooo0?l0oooo6`3oool00240oooo00<00000
0?ooo`3oool0o`3ooolK0?ooo`008@3oool00`00001000000?ooo`1g0?ooo`@0?cooW`3oool00240
oooo00<000000?ooo`3oool0M`3oool403looil0oooo000Q0?ooo`030000003oool0oooo07L0oooo
100o?onO0?ooo`008@3oool00`000000oooo0?ooo`1O0?ooo`@0?coo5@3oool203looj00oooo000Q
0?ooo`030000003oool0oooo02@0oooo100o?olg0?ooo`@0?coo]`3oool000`0oooo00=000000?oo
o`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00E000000`3oool00`00
0000oooo0?ooo`0T0?ooo`@0?coo=`3oool403lookL0oooo000;0?ooo`03@000003ooom0000000L0
oooo00=000000?oood0000000`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo02@0
oooo100o?olh0?ooo`80?coo^03oool000/0oooo00=000000?oood0000001`3oool00d000000oooo
@00000030?ooo`03@000003oool0oooo00<0oooo0P0000000d000000oooo0?ooo`0S0?ooo`80?coo
C@3oool403looj80oooo000;0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000`3o
ool00d000000oooo0?ooo`030?ooo`030000003oool0oooo07@0oooo100o?onR0?ooo`002`3oool0
0d000000oooo@00000070?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`1d0?ooo`@0?cooXP3oool000`0oooo00=000000?ooo`3oool01`3oool01400
0000oooo0?ooo`3oool2@00000D0oooo00<000000?ooo`3oool0M@3oool203looj<0oooo000Q0?oo
o`030000003oool0oooo03@0oooo100o?ooR0?ooo`008@3oool00`000000oooo0?ooo`0d0?ooo`@0
?coohP3oool00240oooo00<00000@000003oool0=03oool403loon80oooo000Q0?ooo`030000003o
ool0oooo02H0oooo100o?ol;0?ooo`80?coo:`3oool403loo`/0oooo100o?onU0?ooo`008@3oool0
0`000000oooo0?ooo`0V0?ooo`@0?coo>03oool403loo`/0oooo100o?onU0?ooo`008@3oool00`00
0000oooo0?ooo`0V0?ooo`@0?coo>03oool403loo`/0oooo100o?onU0?ooo`008@3oool00`000000
oooo0?ooo`0W0?ooo`80?coo>P3oool203loo`d0oooo0P0o?onV0?ooo`008@3oool00`000000oooo
0?ooo`3o0?oooa/0oooo000Q0?ooo`03000004000000oooo06h0oooo100o?onX0?ooo`008@3oool0
0`000000oooo0?ooo`1U0?ooo`@0?coo1@3oool403loojP0oooo000Q0?ooo`030000003oool0oooo
06D0oooo100o?ol50?ooo`@0?cooZ03oool00240oooo00<000000?ooo`3oool0I@3oool403loo`H0
oooo0P0o?onY0?ooo`008@3oool00`000000oooo0?ooo`0X0?ooo`@0?coo>P3oool903looj/0oooo
000Q0?ooo`030000003oool0oooo02P0oooo100o?oll0?ooo`L0?cooZ`3oool00240oooo00<00000
@000003oool0:03oool403loo`L0oooo100o?ola0?ooo`L0?cooZ`3oool00240oooo00<000000?oo
o`3oool0:@3oool203loo`P0oooo100o?olb0?ooo`80?coo00<0oooo03loo`0o?ol0[03oool00240
oooo00<000000?ooo`3oool0<`3oool403loon<0oooo000Q0?ooo`030000003oool0oooo03@0oooo
0P0o?ooT0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooa/0oooo000Q0?ooo`030000003oool0
oooo0?l0oooo6`3oool00240oooo00<00000@000003oool0:@3oool403loond0oooo000Q0?ooo`03
0000003oool0oooo02T0oooo100o?oo]0?ooo`008@3oool00`000000oooo0?ooo`0Y0?ooo`@0?coo
k@3oool00240oooo00<000000?ooo`3oool0:P3oool203loo`D0oooo100o?ooU0?ooo`00303oool0
0d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00A000000?ooo`3oool0oooo0d00
00040?ooo`030000003oool0oooo0340oooo100o?ooU0?ooo`002`3oool00d000000oooo@0000007
0?ooo`03@000003ooom000000080oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`0a
0?ooo`@0?cooi@3oool000/0oooo00=000000?oood0000001`3oool00d000000oooo@00000030?oo
o`03@000003oool0oooo00<0oooo0P0000000d000000oooo0?ooo`0Y0?ooo`@0?coo0`3oool203lo
onH0oooo000;0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000`3oool00d000000
oooo0?ooo`030?ooo`030000003oool0oooo02/0oooo100o?oo[0?ooo`002`3oool00d000000oooo
@00000070?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool00`000000oooo
0?ooo`0[0?ooo`P0?cooi`3oool000`0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?oo
o`020?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0;03oool703loonL0oooo000Q
0?ooo`030000003oool0oooo02d0oooo1P0o?ooW0?ooo`008@3oool00`000000oooo0?ooo`0]0?oo
o`D0?cooj03oool00240oooo00<00000@000003oool0;P3oool203loonX0oooo000Q0?ooo`030000
003oool0oooo0?l0oooo6`3oool00240oooo00=000000?ooo`3oool0o`3ooolK0?ooo`00o`3ooolo
0?ooo`00o`3ooolo0?ooo`00o`3ooolo0?ooo`00o`3ooolo0?ooo`00o`3ooolo0?ooo`00o`3ooolo
0?ooo`00o`3ooolo0?ooo`00o`3ooolo0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 317}, {195.438, 0}} -> {4.20496, -0.038589, 0.470089,
   0.000327293}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{466, 385},
WindowMargins->{{97, Automatic}, {Automatic, 10}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 101, 3, 48, "Input"],
Cell[1813, 54, 212, 6, 109, "Text"],
Cell[2028, 62, 1306, 53, 1056, "Input"],
Cell[3337, 117, 44, 0, 33, "Text"],
Cell[3384, 119, 134, 14, 246, "Input"],
Cell[3521, 135, 47, 0, 33, "Text"],
Cell[3571, 137, 73, 0, 30, "Input"],
Cell[3647, 139, 68, 0, 30, "Input"],
Cell[3718, 141, 50, 0, 33, "Text"],
Cell[3771, 143, 216, 4, 84, "Input"],
Cell[3990, 149, 34, 0, 33, "Text"],
Cell[4027, 151, 105, 3, 48, "Input"],
Cell[4135, 156, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[4184, 160, 444, 11, 228, "Input"],
Cell[4631, 173, 34737, 873, 266, 8551, 545, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[39383, 1049, 183, 3, 52, "Text"],
Cell[39569, 1054, 131, 3, 66, "Input"],
Cell[39703, 1059, 42, 0, 33, "Text"],
Cell[39748, 1061, 131, 3, 48, "Input"],
Cell[39882, 1066, 60, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[39967, 1070, 178, 5, 84, "Input"],
Cell[40148, 1077, 22154, 557, 205, 5265, 344, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

