(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     34536,        950]*)
(*NotebookOutlinePosition[     35231,        975]*)
(*  CellTagsIndexPosition[     35187,        971]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["<<c:\\math\\kniz\\options\\optvalue.m", "Input"],

Cell["\"BULL strategia s americkymi call opciami\"", "Text"],

Cell["\<\
PSOR[V_,ps_,g_,a_,b_,c_,m_,eps_,omega_]:=
Module[{error},
error=1;
While
   [error>eps*eps,
    error=0.0;
    V[-m]=g[-m];
    V[m]=g[m];
    
    For[i=-m+1,i<m,i++,
        y= (ps[i]-a*V[i-1]-c*V[i+1])/b;
        y= Max[g[i],V[i]+omega*(y-V[i])];
        error += (y - V[i])^2;
        V[i]= y;];
    
   ];
]       \
\>", "Input"],

Cell[TextData[
"AmericanBull[X1_,X2_,sigma_,r_,D_,t_,m_,n_,trans_,time_,eps_]:=\n\
Module[{omega},\nomega=1.5;\n\nX=(X1+X2)/2;\nxright=Log[Slarge/X];\n\
k1=N[r/(0.5*sigma^2)];\nk2=N[(r-D)/(0.5*sigma^2)];\n\
k3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];\nk4=N[0.25*(k1^2-1)];\n\n\
h=N[xright/m];\nk=N[0.5*sigma^2*t/n];\n\nPrint[\"Pomer k/h^2 je \",k/h^2,\"  \
a \[CHacek]\[IAcute]slo K = \", trans/(sigma*Sqrt[time])];\n\n\
TransfBullPayoff[x_,tau_]:=N[Exp[0.5*(k2-1)*x+(0.25*(k2-1)^2+k1)*tau]*(Max[\
Exp[x]-X1/X,0]-Max[Exp[x]-X2/X,0])];\n\n\
Do[u[i,0]=TransfBullPayoff[i*h,0],{i,-m,m}];\n\na=N[-k/h^2];\n\
b=N[1.+2*k/h^2];\nc=N[-k/h^2];\n\nDo\n[\n Do[  \
g[i]=TransfBullPayoff[i*h,j*k];\n      grad=(u[i+1,j-1]-u[i-1,j-1])/(2*h);\n  \
    kriv=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;\n \
ps[i]=N[u[i,j-1]-k3*k*Abs[k4*u[i,j-1]-k2*grad+kriv]],{i,-m+1,m-1}];\n\n g[-m] \
  =TransfBullPayoff[-m*h,j*k];\n g[m]    =TransfBullPayoff[m*h,j*k];\n\n \
Do[V[i]=Max[g[i],u[i,j-1]],{i,-m+1,m-1}];\n \n \
PSOR[V,ps,g,a,b,c,m,eps,omega]; \n  \n Do[u[i,j]=V[i],{i,-m,m}];  \n\n \
xs=Table[X*Exp[i*h],{i,-m,m}];\n \
ys=Table[X*Exp[-0.5*(k2-1)*i*h-(0.25*(k2-1)^2+k1)*j*k]* u[i,j],{i,- m,m}];\n \
graf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],\n {j,1,n}]\n]"], "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X1=45;
X2=55;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.6;
m=50;
n=50;
Slarge=150;
trans=0.0;
time=0.03;
eps=0.000001;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["AmericanBull[X1,X2,sigma,r,DD,t,m,n,trans,time,eps]", "Input"],

Cell["\"Payoff diagram\"", "Text"],

Cell["PayoffBull[S_]:=N[Max[S-X1,0]-Max[S-X2,0]];", "Input"],

Cell["\<\
gt=ListPlot[graf[n],PlotStyle->{PointSize[0.02],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];\
\>", "Input"],

Cell["\<\
g1=ListPlot[graf[n],PlotStyle->{PointSize[0.015],RGBColor[1,0,0]},\
DisplayFunction->Identity];
g2=Plot[PayoffBull[S],{S,0,150},PlotRange->All, DisplayFunction->Identity];\
\>", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
Show[gt,g1,g2,AxesLabel->{\"S\",\"V\"},DisplayFunction->$DisplayFunction,\
PlotRange->{{20,100},{0,12}}]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.25 0.0125 0 0.0515028 [
[.125 -0.0125 -6 -9 ]
[.125 -0.0125 6 0 ]
[.25 -0.0125 -6 -9 ]
[.25 -0.0125 6 0 ]
[.375 -0.0125 -6 -9 ]
[.375 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.625 -0.0125 -6 -9 ]
[.625 -0.0125 6 0 ]
[.75 -0.0125 -6 -9 ]
[.75 -0.0125 6 0 ]
[.875 -0.0125 -6 -9 ]
[.875 -0.0125 6 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .10301 -6 -4.5 ]
[-0.0125 .10301 0 4.5 ]
[-0.0125 .20601 -6 -4.5 ]
[-0.0125 .20601 0 4.5 ]
[-0.0125 .30902 -6 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .41202 -6 -4.5 ]
[-0.0125 .41202 0 4.5 ]
[-0.0125 .51503 -12 -4.5 ]
[-0.0125 .51503 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[0 .64303 -5.5 0 ]
[0 .64303 5.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.125 0 m
.125 .00625 L
s
[(30)] .125 -0.0125 0 1 Mshowa
.25 0 m
.25 .00625 L
s
[(40)] .25 -0.0125 0 1 Mshowa
.375 0 m
.375 .00625 L
s
[(50)] .375 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(60)] .5 -0.0125 0 1 Mshowa
.625 0 m
.625 .00625 L
s
[(70)] .625 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(80)] .75 -0.0125 0 1 Mshowa
.875 0 m
.875 .00625 L
s
[(90)] .875 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(100)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.025 0 m
.025 .00375 L
s
.05 0 m
.05 .00375 L
s
.075 0 m
.075 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.175 0 m
.175 .00375 L
s
.2 0 m
.2 .00375 L
s
.225 0 m
.225 .00375 L
s
.275 0 m
.275 .00375 L
s
.3 0 m
.3 .00375 L
s
.325 0 m
.325 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.425 0 m
.425 .00375 L
s
.45 0 m
.45 .00375 L
s
.475 0 m
.475 .00375 L
s
.525 0 m
.525 .00375 L
s
.55 0 m
.55 .00375 L
s
.575 0 m
.575 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.675 0 m
.675 .00375 L
s
.7 0 m
.7 .00375 L
s
.725 0 m
.725 .00375 L
s
.775 0 m
.775 .00375 L
s
.8 0 m
.8 .00375 L
s
.825 0 m
.825 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.925 0 m
.925 .00375 L
s
.95 0 m
.95 .00375 L
s
.975 0 m
.975 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .10301 m
.00625 .10301 L
s
[(2)] -0.0125 .10301 1 0 Mshowa
0 .20601 m
.00625 .20601 L
s
[(4)] -0.0125 .20601 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(6)] -0.0125 .30902 1 0 Mshowa
0 .41202 m
.00625 .41202 L
s
[(8)] -0.0125 .41202 1 0 Mshowa
0 .51503 m
.00625 .51503 L
s
[(10)] -0.0125 .51503 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(12)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .02575 m
.00375 .02575 L
s
0 .0515 m
.00375 .0515 L
s
0 .07725 m
.00375 .07725 L
s
0 .12876 m
.00375 .12876 L
s
0 .15451 m
.00375 .15451 L
s
0 .18026 m
.00375 .18026 L
s
0 .23176 m
.00375 .23176 L
s
0 .25751 m
.00375 .25751 L
s
0 .28327 m
.00375 .28327 L
s
0 .33477 m
.00375 .33477 L
s
0 .36052 m
.00375 .36052 L
s
0 .38627 m
.00375 .38627 L
s
0 .43777 m
.00375 .43777 L
s
0 .46353 m
.00375 .46353 L
s
0 .48928 m
.00375 .48928 L
s
0 .54078 m
.00375 .54078 L
s
0 .56653 m
.00375 .56653 L
s
0 .59228 m
.00375 .59228 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(V) show
69.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.25 .25 1 r
.02 w
.00389 0 Mdot
.00953 0 Mdot
.01529 0 Mdot
.02119 0 Mdot
.02721 0 Mdot
.03337 0 Mdot
.03966 0 Mdot
.0461 0 Mdot
.05268 0 Mdot
.0594 1e-005 Mdot
.06627 1e-005 Mdot
.0733 2e-005 Mdot
.08048 3e-005 Mdot
.08783 4e-005 Mdot
.09533 7e-005 Mdot
.103 .00011 Mdot
.11084 .00018 Mdot
.11886 .00027 Mdot
.12705 .00042 Mdot
.13543 .00065 Mdot
.14399 .00098 Mdot
.15275 .00147 Mdot
.16169 .00217 Mdot
.17084 .00318 Mdot
.18019 .00461 Mdot
.18975 .0066 Mdot
.19951 .00934 Mdot
.2095 .01305 Mdot
.21971 .01799 Mdot
.23014 .02448 Mdot
.24081 .03284 Mdot
.25171 .04344 Mdot
.26286 .05663 Mdot
.27425 .07275 Mdot
.2859 .09208 Mdot
.2978 .11483 Mdot
.30997 .14107 Mdot
.32241 .1708 Mdot
.33513 .20384 Mdot
.34813 .2399 Mdot
.36142 .2786 Mdot
.375 .31942 Mdot
.38888 .36179 Mdot
.40308 .40512 Mdot
.41759 .44926 Mdot
.43242 .49408 Mdot
.44758 .51503 Mdot
.46307 .51503 Mdot
.47892 .51503 Mdot
.49511 .51503 Mdot
.51166 .51503 Mdot
.52858 .51503 Mdot
.54588 .51503 Mdot
.56356 .51503 Mdot
.58163 .51503 Mdot
.60011 .51503 Mdot
.61899 .51503 Mdot
.6383 .51503 Mdot
.65803 .51503 Mdot
.6782 .51503 Mdot
.69882 .51503 Mdot
.7199 .51503 Mdot
.74145 .51503 Mdot
.76348 .51503 Mdot
.78599 .51503 Mdot
.80901 .51503 Mdot
.83253 .51503 Mdot
.85658 .51503 Mdot
.88116 .51503 Mdot
.90629 .51503 Mdot
.93198 .51503 Mdot
.95824 .51503 Mdot
.98508 .51503 Mdot
1 0 0 r
.015 w
.00389 4e-005 Mdot
.00953 6e-005 Mdot
.01529 8e-005 Mdot
.02119 .00011 Mdot
.02721 .00016 Mdot
.03337 .00022 Mdot
.03966 .0003 Mdot
.0461 .00041 Mdot
.05268 .00055 Mdot
.0594 .00075 Mdot
.06627 .001 Mdot
.0733 .00134 Mdot
.08048 .00177 Mdot
.08783 .00233 Mdot
.09533 .00305 Mdot
.103 .00396 Mdot
.11084 .0051 Mdot
.11886 .00654 Mdot
.12705 .00833 Mdot
.13543 .01054 Mdot
.14399 .01324 Mdot
.15275 .01652 Mdot
.16169 .02048 Mdot
.17084 .02522 Mdot
.18019 .03085 Mdot
.18975 .03749 Mdot
.19951 .04525 Mdot
.2095 .05426 Mdot
.21971 .06464 Mdot
.23014 .07649 Mdot
.24081 .08993 Mdot
.25171 .10506 Mdot
.26286 .12195 Mdot
.27425 .14066 Mdot
.2859 .16124 Mdot
.2978 .1837 Mdot
.30997 .20801 Mdot
.32241 .23415 Mdot
.33513 .26204 Mdot
.34813 .29157 Mdot
.36142 .32261 Mdot
.375 .355 Mdot
.38888 .38855 Mdot
.40308 .42307 Mdot
.41759 .45832 Mdot
.43242 .49408 Mdot
.44758 .51503 Mdot
.46307 .51503 Mdot
.47892 .51503 Mdot
.49511 .51503 Mdot
.51166 .51503 Mdot
.52858 .51503 Mdot
.54588 .51503 Mdot
.56356 .51503 Mdot
.58163 .51503 Mdot
.60011 .51503 Mdot
.61899 .51503 Mdot
.6383 .51503 Mdot
.65803 .51503 Mdot
.6782 .51503 Mdot
.69882 .51503 Mdot
.7199 .51503 Mdot
.74145 .51503 Mdot
.76348 .51503 Mdot
.78599 .51503 Mdot
.80901 .51503 Mdot
.83253 .51503 Mdot
.85658 .51503 Mdot
.88116 .51503 Mdot
.90629 .51503 Mdot
.93198 .51503 Mdot
.95824 .51503 Mdot
.98508 .51503 Mdot
0 g
.5 Mabswid
.06185 0 m
.1416 0 L
.21837 0 L
.25749 0 L
.27811 0 L
.28939 0 L
.29996 0 L
.30477 0 L
.30933 0 L
.31185 0 L
.31327 .00319 L
.3146 .00864 L
.31941 .02848 L
.34084 .11675 L
.37857 .27224 L
.41558 .42471 L
.42572 .46648 L
.43126 .48931 L
.43396 .50045 L
.43643 .51061 L
.43869 .51503 L
.44084 .51503 L
.44557 .51503 L
.45561 .51503 L
.49776 .51503 L
.53748 .51503 L
.61294 .51503 L
.69323 .51503 L
.77053 .51503 L
.84485 .51503 L
.924 .51503 L
s
.924 .51503 m
1 .51503 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{359.063, 221.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005W0000gB000`400?l00000o`00003oo`3ooomX
0?ooo`00?@3oool2@00000@0oooo00=000000?ooo`3oool07P3oool3@0000080oooo00=000000?oo
o`3oool07@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01d0oooo0T0000040?oo
o`03@000003oool0oooo01d0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0N0?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0703oool2@00000@0oooo00=000000?oo
o`3oool06@3oool5@0000080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0H0?oo
o`00?`3oool01T000000oooo0?oood000000oooo@0000200oooo00I000000?ooo`3ooom000000?oo
od00000M0?ooo`03@000003ooom000000080oooo00=000000?oood0000007P3oool00d000000oooo
@00000020?ooo`03@000003ooom0000001h0oooo00M000000?ooo`3oool0oooo@000003ooom00000
01h0oooo00=000000?oood0000000P3oool00d000000oooo@000000O0?ooo`06@000003oool0oooo
@000003ooom00000703oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000
oooo@000000I0?ooo`00?P3oool01d000000oooo0?ooo`3ooom000000?oood0000007P3oool4@000
00040?oood000000oooo@00001l0oooo00I000000?ooo`3ooom000000?oood00000N0?ooo`03@000
003ooom000000080oooo00=000000?oood0000007P3oool01d000000oooo0?ooo`3ooom000000?oo
od0000007P3oool00d000000oooo@00000020?ooo`03@000003ooom0000001h0oooo0T0000020?oo
o`03@000003ooom0000001`0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=0
00000?oood0000006@3oool003l0oooo00I000000?ooo`3ooom000000?oood00000N0?ooo`03@000
003ooom000000080oooo00=000000?oood0000007@3oool2@00000<0oooo00=000000?oood000000
7P3oool2@00000<0oooo00=000000?oood0000007`3oool01T000000oooo0?oood000000oooo@000
01l0oooo00M000000?ooo`3oool0oooo@000003ooom0000001d0oooo00=000000?oood0000000P3o
ool00d000000oooo@000000L0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03
@000003ooom0000001T0oooo000m0?ooo`03@000003ooom000000080oooo00=000000?oood000000
7`3oool2@0000080oooo00=000000?oood0000007@3oool00d000000oooo0?ooo`020?ooo`03@000
003ooom0000001h0oooo00=000000?ooo`3oool00P3oool00d000000oooo@000000M0?ooo`03@000
003ooom000000080oooo00=000000?oood0000007P3oool00d000000oooo@00000020?ooo`03@000
003ooom0000001d0oooo00=000000?oood0000000P3oool00d000000oooo@000000L0?ooo`07@000
003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom0000001T0oooo000n0?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool07`3oool01D000000oooo0?ooo`3ooom00000
01h0oooo0d0000030?ooo`03@000003oool0oooo01h0oooo0T0000030?ooo`03@000003oool0oooo
01`0oooo0d0000030?ooo`03@000003oool0oooo01h0oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`0M0?ooo`9000000`3oool00d000000oooo0?ooo`0J0?ooo`900000103oool00d00
0000oooo0?ooo`020?ooo`03@000003oool0oooo01P0oooo003o0?ooofP0oooo003o0?ooofP0oooo
003o0?ooofP0oooo003o0?oooe<0oooo0d00000B0?ooo`006P3ooole03loool0oooo103oool00d00
0000oooo@000000B0?ooo`006P3oool00`0o?ol0o`000?l0000A0?l00?l000006`0000000d000000
oooo0?ooo`090?ooo`03@000003oool0oooo0100oooo000J0?ooo`0303loo`3o0000o`0001l0o`00
6`0o?ol00`3ooom000000?ooo`050?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool0
103oool00d000000oooo0?ooo`050?ooo`05@000003oool0oooo0?ooo`0000000P3oool00d000000
oooo0?ooo`050?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00d000000
oooo0?ooo`040?ooo`03@000003oool0oooo00D0oooo00=000000?ooo`3oool0103oool00d000000
oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00=000000?ooo`3oool01@3oool00d000000
oooo0?ooo`040?ooo`03@000003oool0oooo00D0oooo00=000000?ooo`3oool0103oool00`000000
oooo0?ooo`050?ooo`03@000003oool0oooo00@0oooo00=000000?ooo`3oool01@3oool00d000000
oooo0?ooo`040?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00d000000
oooo0?ooo`050?ooo`03@000003oool0oooo00@0oooo00=000000?ooo`3oool01@3oool00d000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00=000000?ooo`3oool0103oool00d000000
oooo0?ooo`050?ooo`03@000003oool0oooo00@0oooo00=000000?ooo`3oool01@3oool00`000000
oooo0?ooo`080?ooo`03@000003oool0oooo0140oooo000J0?ooo`80?coo01D0o`0003loo`3o0000
o`0003loo`3o0000?coo0?l0000o?ol0o`0003loo`3o0000?coo0?l0000o?ol0o`0003loo`3o0000
?coo0?l0000o?ol03`3o000J03loo`d0oooo00=000000?ooo`3oool0403oool00`000000oooo0?oo
o`0?0?ooo`03@000003oool0oooo02<0oooo00=000000?ooo`3oool08P3oool00d000000oooo0?oo
o`0S0?ooo`03@000003oool0oooo0280oooo00=000000?ooo`3oool08`3oool00d000000oooo0?oo
o`070?ooo`03@000003ooom000000180oooo000K0?oooaP0?coo00D0o`0003loo`3o0000?coo0?l0
000203loo`/0o`00600o?olM0?ooo`030000003oool0oooo0=D0oooo0d00000B0?ooo`006`3oool0
0`000000oooo0?ooo`0N0?ooo`040?l0003oool0o`000?ooo`P0o`001@3ooolC03looaX0oooo00<0
00000?ooo`3oool0jP3oool001/0oooo00<000000?ooo`3oool08`3oool0103o0000oooo0?l0003o
ool60?l000P0oooo3@0o?olJ0?ooo`030000003oool0oooo0>X0oooo000K0?ooo`030000003oool0
oooo02P0oooo00<0o`000?ooo`3o0000103o00090?ooo`d0?coo603oool00`000000oooo0?ooo`3Y
0?ooo`006`3oool00`000000oooo0?ooo`0[0?ooo`@0o`00303oool:03looaP0oooo00<000000?oo
o`3oool0j@3oool001/0oooo0P0000000d000000oooo0?ooo`0[0?ooo`030?l0003oool0o`000080
o`00303oool703looaP0oooo00<000000?ooo`3oool0j@3oool001/0oooo00<000000?ooo`3oool0
;`3oool60?l000/0oooo200o?olE0?ooo`030000003oool0oooo0>T0oooo000K0?ooo`030000003o
ool0oooo0300oooo00<0o`000?ooo`3o00000P3o000<0?ooo`L0?coo5@3oool00`000000oooo0?oo
o`3Y0?ooo`006`3oool00`000000oooo0?ooo`0c0?ooo`030?l0003oool0o`000080o`002`3oool5
03looaH0oooo00<000000?ooo`3oool0j03oool001/0oooo00<000000?ooo`3oool0=@3oool30?l0
00/0oooo2@0o?olB0?ooo`030000003oool0oooo0>P0oooo000K0?ooo`030000003oool0oooo03H0
oooo00<0o`000?ooo`3oool02`3oool803looa80oooo00<000000?ooo`3oool0j03oool001/0oooo
00<000000?ooo`3oool0>03oool30?l000`0oooo1@0o?olB0?ooo`030000003oool0oooo0>P0oooo
000K0?ooo`030000003oool0oooo03P0oooo0`3o000<0?ooo`D0?coo4`3oool00`000000oooo0?oo
o`3W0?ooo`006`3oool200000003@000003oool0oooo03L0oooo00<0o`000?ooo`3o00000P3o000:
0?ooo`L0?coo403oool00`000000oooo0?ooo`3W0?ooo`006`3oool00`000000oooo0?ooo`0k0?oo
o`<0o`00303oool503looa00oooo00<000000?ooo`3oool0i`3oool001/0oooo00<000000?ooo`3o
ool0?03oool00`3o0000oooo0?ooo`0;0?ooo`D0?coo403oool00`000000oooo0?ooo`3W0?ooo`00
6`3oool00`000000oooo0?ooo`0n0?ooo`<0o`002@3oool503looa40oooo00<000000?ooo`3oool0
iP3oool001/0oooo00<000000?ooo`3oool0?P3oool30?l000X0oooo0`0o?olB0?ooo`030000003o
ool0oooo0>H0oooo000K0?ooo`030000003oool0oooo03l0oooo00<0o`000?ooo`3oool02`3oool5
03loo`h0oooo00<000000?ooo`3oool0iP3oool001/0oooo00<000000?ooo`3oool0C@3oool503lo
o`l0oooo00<000000?ooo`3oool0i@3oool001/0oooo00<000000?ooo`3oool0@@3oool30?l000T0
oooo1@0o?ol?0?ooo`030000003oool0oooo0>D0oooo000K0?ooo`80000000=000000?ooo`3oool0
?`3oool30?l000T0oooo1@0o?ol?0?ooo`030000003oool0oooo0>D0oooo000K0?ooo`030000003o
ool0oooo0480oooo00<0o`000?ooo`3oool02@3oool303looa00oooo00<000000?ooo`3oool0i@3o
ool001/0oooo00<000000?ooo`3oool0D@3oool503loo``0oooo00<000000?ooo`3oool0i03oool0
01/0oooo00<000000?ooo`3oool0A03oool30?l000X0oooo1@0o?ol<0?ooo`030000003oool0oooo
0>@0oooo000K0?ooo`030000003oool0oooo04@0oooo0`3o000:0?ooo`D0?coo303oool00`000000
oooo0?ooo`3T0?ooo`00503oool3@00000@0oooo00<000000?ooo`3oool0A@3oool00`3o0000oooo
0?ooo`090?ooo`D0?coo303oool00`000000oooo0?ooo`3T0?ooo`00503oool00d000000oooo0?oo
o`040?ooo`030000003oool0oooo0580oooo0`0o?ol>0?ooo`030000003oool0oooo0><0oooo000E
0?ooo`03@000003oool0oooo00<0oooo0P0000000d000000oooo0?ooo`1Q0?ooo`030000003oool0
oooo0><0oooo000E0?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0A`3oool30?l0
01T0oooo00<000000?ooo`3oool0h`3oool001@0oooo00=000000?oood000000103oool00`000000
oooo0?ooo`170?ooo`<0o`002P3oool503loo`X0oooo00<000000?ooo`3oool0h`3oool001D0oooo
00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`180?ooo`030?l0003oool0oooo00T0oooo
1@0o?ol;0?ooo`030000003oool0oooo0>80oooo000K0?ooo`030000003oool0oooo05@0oooo1@0o
?ol;0?ooo`030000003oool0oooo0>80oooo000K0?ooo`030000003oool0oooo05@0oooo1@0o?ol;
0?ooo`030000003oool0oooo0>80oooo000K0?ooo`030000003oool0oooo04/0oooo0`3o00070?oo
o`<0?coo303oool00`000000oooo0?ooo`3R0?ooo`006`3oool00`000000oooo0?ooo`1;0?ooo`<0
o`005`3oool00`000000oooo0?ooo`3Q0?ooo`006`3oool200000003@000003oool0oooo04X0oooo
00<0o`000?ooo`3oool05P3oool00`000000oooo0?ooo`3Q0?ooo`006`3oool00`000000oooo0?oo
o`1U0?ooo`030000003oool0oooo0>40oooo000K0?ooo`030000003oool0oooo05P0oooo1@0o?ol8
0?ooo`030000003oool0oooo0>40oooo000K0?ooo`030000003oool0oooo04h0oooo0`3o00070?oo
o`D0?coo2@3oool00`000000oooo0?ooo`3P0?ooo`006`3oool00`000000oooo0?ooo`1>0?ooo`<0
o`001`3oool503loo`T0oooo00<000000?ooo`3oool0h03oool001/0oooo00<000000?ooo`3oool0
C`3oool00`3o0000oooo0?ooo`060?ooo`D0?coo2@3oool00`000000oooo0?ooo`3P0?ooo`006`3o
ool00`000000oooo0?ooo`1I0?ooo`<0?coo2P3oool00`000000oooo0?ooo`3P0?ooo`006`3oool0
0`000000oooo0?ooo`1W0?ooo`030000003oool0oooo0=l0oooo000K0?ooo`80000000=000000?oo
o`3oool0I@3oool00`000000oooo0?ooo`3O0?ooo`006`3oool00`000000oooo0?ooo`1W0?ooo`03
0000003oool0oooo0=l0oooo000K0?ooo`030000003oool0oooo0580oooo0`3o000B0?ooo`030000
003oool0oooo0=l0oooo000K0?ooo`030000003oool0oooo0580oooo0`3o00070?ooo`D0?coo1`3o
ool00`000000oooo0?ooo`3N0?ooo`006`3oool00`000000oooo0?ooo`1C0?ooo`030?l0003oool0
oooo00H0oooo1@0o?ol70?ooo`030000003oool0oooo0=h0oooo000K0?ooo`030000003oool0oooo
05`0oooo1@0o?ol70?ooo`030000003oool0oooo0=h0oooo000K0?ooo`030000003oool0oooo05`0
oooo1@0o?ol70?ooo`030000003oool0oooo0=h0oooo000K0?ooo`80000000=000000?ooo`3oool0
F`3oool303loo`P0oooo00<000000?ooo`3oool0gP3oool001/0oooo00<000000?ooo`3oool0E@3o
ool30?l00140oooo00<000000?ooo`3oool0g@3oool001/0oooo00<000000?ooo`3oool0E@3oool3
0?l00140oooo00<000000?ooo`3oool0g@3oool001/0oooo00<000000?ooo`3oool0EP3oool00`3o
0000oooo0?ooo`0@0?ooo`030000003oool0oooo0=d0oooo000K0?ooo`030000003oool0oooo06T0
oooo00<000000?ooo`3oool0g@3oool001/0oooo00<000000?ooo`3oool0JP3oool00`000000oooo
0?ooo`3L0?ooo`005@3oool3@00000<0oooo00<000000?ooo`3oool0H03oool503loo`D0oooo00<0
00000?ooo`3oool0g03oool001H0oooo00=000000?ooo`3oool00P3oool00`000000oooo0?ooo`1P
0?ooo`D0?coo1@3oool00`000000oooo0?ooo`3L0?ooo`00503oool4@00000<0oooo0P0000000d00
0000oooo0?ooo`1N0?ooo`D0?coo1@3oool00`000000oooo0?ooo`3L0?ooo`00503oool00d000000
oooo@00000040?ooo`030000003oool0oooo05T0oooo0`3o00040?ooo`D0?coo1P3oool00`000000
oooo0?ooo`3K0?ooo`005@3oool2@00000@0oooo00<000000?ooo`3oool0F@3oool30?l000D0oooo
0`0o?ol70?ooo`030000003oool0oooo0=/0oooo000F0?ooo`03@000003oool0oooo0080oooo00<0
00000?ooo`3oool0FP3oool00`3o0000oooo0?ooo`0>0?ooo`030000003oool0oooo0=/0oooo000K
0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0f`3oool001/0oooo00<000000?oo
o`3oool0J`3oool00`000000oooo0?ooo`3K0?ooo`006`3oool00`000000oooo0?ooo`1/0?ooo`03
0000003oool0oooo0=X0oooo000K0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0
fP3oool001/0oooo0P0000000d000000oooo0?ooo`1K0?ooo`<0o`00303oool00`000000oooo0?oo
o`3J0?ooo`006`3oool00`000000oooo0?ooo`1M0?ooo`<0o`00103oool503loo`<0oooo00<00000
0?ooo`3oool0fP3oool001/0oooo00<000000?ooo`3oool0GP3oool00`3o0000oooo0?ooo`030?oo
o`D0?coo103oool00`000000oooo0?ooo`3I0?ooo`006`3oool00`000000oooo0?ooo`1T0?ooo`D0
?coo103oool00`000000oooo0?ooo`3I0?ooo`006`3oool00`000000oooo0?ooo`1T0?ooo`D0?coo
103oool00`000000oooo0?ooo`3I0?ooo`006`3oool00`000000oooo0?ooo`1U0?ooo`<0?coo1@3o
ool00`000000oooo0?ooo`3I0?ooo`006`3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0
oooo0=P0oooo000K0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool0f03oool001/0
oooo0P0000000d000000oooo0?ooo`1/0?ooo`030000003oool0oooo0=P0oooo000K0?ooo`030000
003oool0oooo0600oooo0`3o000;0?ooo`030000003oool0oooo0=P0oooo000K0?ooo`030000003o
ool0oooo0600oooo0`3o000<0?ooo`030000003oool0oooo0=L0oooo000K0?ooo`030000003oool0
oooo0640oooo00<0o`000?ooo`3oool02`3oool00`000000oooo0?ooo`3G0?ooo`006`3oool00`00
0000oooo0?ooo`1_0?ooo`030000003oool0oooo0=L0oooo000K0?ooo`030000003oool0oooo06P0
oooo1@0o?ol20?ooo`030000003oool0oooo0=L0oooo000K0?ooo`030000003oool0oooo06P0oooo
1@0o?ol20?ooo`030000003oool0oooo0=L0oooo000K0?ooo`80000000=000000?ooo`3oool0IP3o
ool503loo`<0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0J03oool5
03loo`<0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0J@3oool303lo
o`@0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0I03oool30?l000T0
oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0I03oool30?l000X0oooo
00<000000?ooo`3oool0e@3oool001/0oooo00<000000?ooo`3oool0I@3oool00`3o0000oooo0?oo
o`090?ooo`030000003oool0oooo0=D0oooo000D0?ooo`9000001@3oool00`000000oooo0?ooo`1a
0?ooo`030000003oool0oooo0=D0oooo000D0?ooo`03@000003ooom0000000@0oooo00<000000?oo
o`3oool0L@3oool00`000000oooo0?ooo`3E0?ooo`00503oool00d000000oooo@00000040?ooo`80
000000=000000?ooo`3oool0L03oool00`000000oooo0?ooo`3D0?ooo`00503oool2@00000D0oooo
00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`3D0?ooo`00503oool00d000000oooo0?oo
o`040?ooo`030000003oool0oooo06`0oooo1@0o?ol00`3oool000000?ooo`3E0?ooo`005@3oool2
@00000@0oooo00<000000?ooo`3oool0K03oool503loo`030?ooo`000000oooo0=D0oooo000K0?oo
o`030000003oool0oooo06P0oooo0`3o00000`3oool0?coo03loo`0303loo`80oooo00<000000?oo
o`3oool0d`3oool001/0oooo00<000000?ooo`3oool0J03oool30?l000030?ooo`0o?ol0?coo00<0
?coo0P3oool00`000000oooo0?ooo`3C0?ooo`006`3oool00`000000oooo0?ooo`1Y0?ooo`040?l0
003oool0oooo0?ooo`<0?coo0`3oool00`000000oooo0?ooo`3C0?ooo`006`3oool00`000000oooo
0?ooo`1c0?ooo`030000003oool0oooo0=<0oooo000K0?ooo`80000000=000000?ooo`3oool0LP3o
ool00`000000oooo0?ooo`3B0?ooo`006`3oool00`000000oooo0?ooo`1d0?ooo`030000003oool0
oooo0=80oooo000K0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool0dP3oool001/0
oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`3B0?ooo`006`3oool00`000000oooo
0?ooo`1e0?ooo`030000003oool0oooo0=40oooo000K0?ooo`030000003oool0oooo07D0oooo00<0
00000?ooo`3oool0d@3oool001/0oooo00<000000?ooo`3oool0K03oool30?l000H0oooo00<00000
0?ooo`3oool0d@3oool001/0oooo00<000000?ooo`3oool0K03oool30?l000030?ooo`0o?ol0?coo
00<0?coo00<000000?ooo`3oool0d@3oool001/0oooo0P0000000d000000oooo0?ooo`1[0?ooo`03
0?l0003oool0oooo00D0?coo00<000000?ooo`3oool0d@3oool001/0oooo00<000000?ooo`3oool0
L03oool503loo`030?ooo`000000oooo0=40oooo000K0?ooo`030000003oool0oooo0700oooo1@0o
?ol00`3oool000000?ooo`3A0?ooo`006`3oool00`000000oooo0?ooo`1a0?ooo`<0?coo0P3oool0
0`000000oooo0?ooo`3@0?ooo`006`3oool00`000000oooo0?ooo`1f0?ooo`030000003oool0oooo
0=00oooo000K0?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0c`3oool001/0oooo
00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`3?0?ooo`006`3oool200000003@000003o
ool0oooo07D0oooo00<000000?ooo`3oool0c`3oool001/0oooo00<000000?ooo`3oool0L@3oool3
0?l000<0oooo00<000000?ooo`3oool0c`3oool001/0oooo00<000000?ooo`3oool0L@3oool30?l0
00@0oooo00<000000?ooo`3oool0cP3oool001/0oooo00<000000?ooo`3oool0LP3oool00`3o0000
oooo0?ooo`030?ooo`030000003oool0oooo0<h0oooo000K0?ooo`030000003oool0oooo07P0oooo
00<000000?ooo`3oool0cP3oool001/0oooo00<000000?ooo`3oool0M03oool403loo`030000003o
ool0oooo0<h0oooo000E0?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0M03oool5
03loo`030000003oool0oooo0<d0oooo000D0?ooo`03@000003ooom0000000@0oooo00<000000?oo
o`3oool0M03oool503loo`030000003oool0oooo0<d0oooo000D0?ooo`03@000003ooom0000000@0
oooo0P0000000d000000oooo0?ooo`1b0?ooo`D0?coo00<000000?ooo`3oool0c@3oool001D0oooo
00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`1e0?ooo`<0?coo00<0oooo0000003oool0
cP3oool001@0oooo00=000000?oood000000103oool00`000000oooo0?ooo`1j0?ooo`030000003o
ool0oooo0<`0oooo000E0?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0M@3oool3
0?l00080oooo00<000000?ooo`3oool0c03oool001/0oooo00<000000?ooo`3oool0M@3oool30?l0
0080oooo00<000000?ooo`3oool0c03oool001/0oooo00<000000?ooo`3oool0MP3oool01@3o0000
oooo0?ooo`3oool000000<h0oooo000K0?ooo`030000003oool0oooo07/0oooo00<000000?ooo`3o
ool0b`3oool001/0oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?ooo`3;0?ooo`006`3o
ool200000003@000003oool0oooo07T0oooo00<000000?ooo`3oool0b`3oool001/0oooo00<00000
0?ooo`3oool0N`3oool00`000000oooo0?ooo`3;0?ooo`006`3oool00`000000oooo0?ooo`1h0?oo
o`@0?coo00<000000?ooo`3oool0bP3oool001/0oooo00<000000?ooo`3oool0N03oool403loo`03
0000003oool0oooo0<X0oooo000K0?ooo`030000003oool0oooo07P0oooo100o?ol00`000000oooo
0?ooo`3:0?ooo`006`3oool00`000000oooo0?ooo`1h0?ooo`@0?coo00<000000?ooo`3oool0bP3o
ool001/0oooo00<000000?ooo`3oool0N@3oool30?l000030?ooo`000000oooo0<X0oooo000K0?oo
o`030000003oool0oooo07T0oooo0`3o00000`3oool000000?ooo`3:0?ooo`006`3oool200000003
@000003oool0oooo07P0oooo00@0o`000?ooo`3oool00000b`3oool001/0oooo00<000000?ooo`3o
ool0O@3oool00`000000oooo0?ooo`390?ooo`006`3oool00`000000oooo0?ooo`1n0?ooo`030000
003oool0oooo0<P0oooo000K0?ooo`030000003oool0oooo07h0oooo00<000000?ooo`3oool0b03o
ool001/0oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?ooo`380?ooo`006`3oool00`00
0000oooo0?ooo`1n0?ooo`030000003oool0oooo0<P0oooo000K0?ooo`030000003oool0oooo07l0
oooo00<000000?ooo`3oool0a`3oool001/0oooo0P0000000d000000oooo0?ooo`1k0?ooo`80?coo
00<0000003loo`0o?ol0a`3oool001/0oooo00<000000?ooo`3oool0O@3oool01@0o?ol0o`000000
003o0000?coo0<L0oooo000K0?ooo`030000003oool0oooo07d0oooo00D0?coo0?l0003o00000000
03loo`370?ooo`006`3oool00`000000oooo0?ooo`1m0?ooo`80?coo00<0o`000000000o?ol0a`3o
ool001/0oooo00<000000?ooo`3oool0OP3oool203loo`030000003oool0oooo0<H0oooo000K0?oo
o`030000003oool0oooo0800oooo00<000000?ooo`3oool0aP3oool000h0oooo1D0000020?ooo`03
@000003oool0oooo00<0oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`350?ooo`00
403oool01d000000oooo0?ooo`3ooom000000?oood000000103oool00`000000oooo0?ooo`210?oo
o`030000000o?ol0?coo02D0?coo00<0oooo03loo`0o?ol0200o?ol00`3oool0?coo03loo`0303lo
o`030?ooo`0o?ol0?coo00<0?coo00<0oooo03loo`0o?ol00`0o?ol00`3oool0?coo03loo`0303lo
o`030?ooo`0o?ol0?coo00<0?coo00<0oooo03loo`0o?ol00`0o?ol20?ooo`D0?coo00<0oooo03lo
o`0o?ol00`0o?ol20?ooo`D0?coo0P3oool503loo`80oooo1@0o?ol20?ooo`D0?coo0`3oool503lo
o`80oooo1@0o?ol30?ooo`D0?coo0`3oool503loo`<0oooo1@0o?olQ0?ooo`00403oool01d000000
oooo0?ooo`3ooom000000?oood000000103oool200000003@000003oool0oooo07l0ooooZ@000000
0d000000oooo0?ooo`0L0?ooo`00403oool01d000000oooo0?ooo`3ooom000000?oood000000103o
ool00`000000oooo0?ooo`210?ooo`0403loo`3o0000o`000?l00080?coo0`3o000203loo`<0o`00
00@0?coo0?l0003o0000o`000P0o?ol30?l00080?coo0`3o000303loo`<0o`000P0o?ol30?l00003
03loo`3oool0o`000080o`000`0o?ol30?l0000303loo`3oool0?coo00<0o`0000<0?coo0?ooo`3o
00000P3o000203loo`040?ooo`3o0000o`000?l00080?coo00@0oooo0?l0003o0000o`000P0o?ol0
0`3oool0?coo0?l000020?l0000303loo`3oool0?coo00<0o`0000<0?coo0?ooo`3oool00`3o0002
03loo`030?ooo`0o?ol0o`000080o`0000@0?coo0?ooo`3oool0?coo0`3o0000100o?ol0oooo0?oo
o`0o?ol30?l0000403loo`3oool0oooo03loo`<0o`0000@0?coo0?ooo`3oool0?coo0`3o0000100o
?ol0oooo0?ooo`3oool30?l00080?coo0P3oool01@0o?ol0o`000?l0003o0000?coo00<0oooo00D0
?coo0?l0003o0000o`0003loo`030?ooo`0503loo`3o0000o`000?l0000o?ol00`3oool01@0o?ol0
o`000?l0003o0000?coo0240oooo000@0?ooo`07@000003oool0oooo0?oood000000oooo@0000004
0?ooo`030000003oool0oooo0840oooo0P0o?ol00`3o0000?coo03loo`0203loo`030?l0000o?ol0
?coo0080?coo00D0o`0003loo`0o?ol0?coo0?l0000403loo`030?l0000o?ol0?coo0080?coo00<0
o`0003loo`0o?ol00`0o?ol00`3o0000?coo03loo`0203loo`060?l0000o?ol0?coo0?ooo`0o?ol0
o`001@0o?ol0103o0000?coo03loo`3oool203loo`060?l0000o?ol0?coo0?ooo`0o?ol0o`000`0o
?ol00`3oool0?coo0?l0000303loo`030?ooo`0o?ol0o`0000<0?coo00@0oooo03loo`0o?ol0o`00
0P0o?ol0103oool0?coo03loo`3o000203loo`80oooo00<0?coo0?l0000o?ol00P0o?ol0103oool0
?coo03loo`3o000203loo`80oooo0P0o?ol00`3o0000?coo03loo`020?ooo`80?coo00<0o`0003lo
o`0o?ol00P3oool203loo`030?l0000o?ol0?coo0080oooo0P0o?ol00`3o0000?coo03loo`030?oo
o`0303loo`3o0000?coo0080?coo0P3oool203loo`030?l0000o?ol0?coo00<0oooo0P0o?ol00`3o
0000?coo03loo`030?ooo`80?coo00<0o`0003loo`0o?ol00`3oool203loo`030?l0000o?ol0?coo
0240oooo000?0?ooo`900000103oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo0880
oooo0`0o?ol20?ooo`<0?coo0P3oool303loo`80oooo0`0o?ol20?ooo`<0?coo0P3oool303loo`80
oooo0`0o?ol20?ooo`<0?coo0`3oool303loo`80oooo0`0o?ol30?ooo`<0?coo0`3oool303loo`<0
oooo0`0o?ol30?ooo`<0?coo0`3oool303loo`<0oooo0`0o?ol40?ooo`<0?coo0`3oool303loo`@0
oooo0`0o?ol40?ooo`<0?coo103oool303loo`@0oooo0`0o?ol50?ooo`<0?coo103oool303loo`D0
oooo0`0o?ol50?ooo`<0?coo1@3oool303loob80oooo000K0?ooo`030000003oool0oooo0?l0oooo
BP3oool001/0oooo00<000000?ooo`3oool0o`3ooom:0?ooo`006`3oool00`000000oooo0?ooo`3o
0?ooodX0oooo000K0?ooo`030000003oool0oooo0?l0ooooBP3oool001/0oooo0P0000000d000000
oooo0?ooo`3o0?ooodP0oooo000K0?ooo`030000003oool0oooo0?l0ooooBP3oool001/0oooo00<0
00000?ooo`3oool0o`3ooom:0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooodX0oooo000K0?oo
o`030000003oool0oooo0?l0ooooBP3oool001/0oooo00<000000?ooo`3oool0o`3ooom:0?ooo`00
6`3oool00`000000oooo0?ooo`3o0?ooodX0oooo000K0?ooo`030000003oool0oooo0?l0ooooBP3o
ool001/0oooo0P0000000d000000oooo0?ooo`3o0?ooodP0oooo000K0?ooo`030000003oool0oooo
0?l0ooooBP3oool001/0oooo00<000000?ooo`3oool0o`3ooom:0?ooo`006`3oool00`000000oooo
0?ooo`3o0?ooodX0oooo000K0?ooo`030000003oool0oooo0?l0ooooBP3oool001/0oooo00<00000
0?ooo`3oool0o`3ooom:0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooodX0oooo000K0?ooo`80
000000=000000?ooo`3oool0o`3ooom80?ooo`006`3oool00`000000oooo0?ooo`3o0?ooodX0oooo
000K0?ooo`030000003oool0oooo0?l0ooooBP3oool001/0oooo00<000000?ooo`3oool0o`3ooom:
0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooodX0oooo000K0?ooo`030000003oool0oooo0?l0
ooooBP3oool000h0oooo1D000000103ooom00000@000040000040?ooo`030000003oool0oooo0?l0
ooooBP3oool00100oooo00E000000?ooo`3oool0oooo@00000060?ooo`030000003oool0oooo0?l0
ooooBP3oool00100oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`030?ooo`03@000
0000001000000?l0ooooBP3oool00100oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`3o0?oooe00oooo000@0?ooo`07@000003oool0oooo0?oood000000oooo@000003o0?oooe40oooo
000?0?ooo`900000103oool00d000000oooo0?ooo`3o0?oooe00oooo003o0?ooofP0oooo003o0?oo
ofP0oooo003o0?ooofP0oooo003o0?ooofP0oooo003o0?ooofP0oooo003o0?ooofP0oooo003o0?oo
ofP0oooo003o0?ooofP0oooo003o0?ooofP0oooo000J0?ooo`900000o`3ooom<0?ooo`006@3oool0
0d000000oooo@000003o0?oood`0oooo000I0?ooo`03@000003ooom000000?l0ooooC03oool001T0
oooo00A000000?ooo`3ooom00000o`3ooom;0?ooo`00603oool01D000000oooo0?ooo`3ooom00000
0?l0ooooB`3oool001P0oooo0T0000000`3ooom00000@000003o0?oood/0oooo003o0?ooofP0oooo
003o0?ooofP0oooo003o0?ooofP0oooo003o0?ooofP0oooo0000\
\>"],
  ImageRangeCache->{{{0, 358.063}, {220.938, 0}} -> {12.5591, -0.824444, 
  0.266292, 0.0646305}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{452, 394},
WindowMargins->{{29, Automatic}, {Automatic, 9}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 54, 0, 30, "Input"],
Cell[1766, 51, 60, 0, 33, "Text"],
Cell[1829, 53, 344, 18, 318, "Input"],
Cell[2176, 73, 1246, 19, 930, "Input"],
Cell[3425, 94, 44, 0, 33, "Text"],
Cell[3472, 96, 133, 13, 228, "Input"],
Cell[3608, 111, 47, 0, 33, "Text"],
Cell[3658, 113, 73, 0, 48, "Input"],
Cell[3734, 115, 68, 0, 30, "Input"],
Cell[3805, 117, 34, 0, 33, "Text"],
Cell[3842, 119, 60, 0, 30, "Input"],
Cell[3905, 121, 125, 3, 66, "Input"],
Cell[4033, 126, 196, 4, 84, "Input"],
Cell[4232, 132, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[4281, 136, 129, 3, 48, "Input"],
Cell[4413, 141, 30107, 806, 230, 8340, 533, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

