(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     94844,       2533]*)
(*NotebookOutlinePosition[     95539,       2558]*)
(*  CellTagsIndexPosition[     95495,       2554]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
<<c:\\math\\kniz\\linearal\\tridiago.m
<<c:\\math\\kniz\\options\\optvalue.m\
\>", "Input"],

Cell["\<\
EuroCall[X_,sigma_,r_,D_,t_,m_,n_,trans_,time_]:=
Module[
{doldiag,diag,hordiag},

xright=Log[Slarge/X];
c1=N[r/(0.5*sigma^2)];
c2=N[(r-D)/(0.5*sigma^2)];
c3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
c4=N[0.25*(c2^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

TransfCallPayoff[x_]:=N[Max[Exp[0.5*(c2+1)*x]-Exp[0.5*(c2-1)*x],0]];
Do[u[i,0]=TransfCallPayoff[i*h],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
 Do[
      der1=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      der2=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
ClenAbs[i]=Abs[N[c4*u[i,j-1]-c2*der1+der2]],{i,-m+1,m-1}];

op1=0;
op2=Exp[0.5*(c2+1)*xright+0.25*(c2+1)^2*k*j]-
    Exp[0.5*(c2-1)*xright+0.25*(c2-1)^2*k*j];

ps = Join[{u[-m+1,j-1]-c3*k*ClenAbs[-m+1]-a*op1},
          Table[u[i,j-1]-c3*k*ClenAbs[i],{i,-m+2,m-2}],
          {u[m-1,j-1] -c3*k*ClenAbs[m-1] -c*op2}];

hordiag=Table[c,{i,-m+1,m-2}];
diag=Table[b,{i,-m+1,m-1}];
doldiag=Table[a,{i,-m+2,m-1}];

riesenie=TridiagonalSolve[N[doldiag],N[diag],N[hordiag],N[ps]];
 
u[-m,j]=op1;
Do[u[i,j]=riesenie[[i+m]],{i,-m+1,m-1}];
u[m,j] =op2;

xs=Table[X*Exp[i*h],{i,-m,m}];
ys=Table[X*Exp[-0.5*(c2-1)*i*h-(0.25*(c2-1)^2+c1)*j*k]*u[i,j],{i,-m,m}];
grf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
{j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X=60;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=10;
n=10;
Slarge=150;
trans=0.0;
time=0.03;\
\>", "Input"],

Cell["\"str: upraven\[AAcute] sigma\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["EuroCall[X,sigma,r,DD,t,m,n,trans,time]", "Input"],

Cell["\<\
\"B[i]: rozdiel medzi presn\[YAcute]m rie\.9aen\[IAcute]m a pribli\.9en\
\[YAcute]m numerick\[YAcute]m rie\.9aen\[IAcute]m.\"\
\>", "Text"],

Cell["\<\
B[i_]:=EuropeanCallDiv[xs[[i]],X,sigma,r,DD,t]*Exp[0.5*(c2-1)*(i-m-1)*h+(0.25*\
(c2-1)^2+c1)*n*k]/X - u[i-m-1,n];
ern:=Max[Table[Abs[B[i]],{i,1,2m+1}]]\
\>", "Input"],

Cell[TextData["\"V\[YAcute]po\[CHacek]et kon\.9atanty C.\""], "Text"],

Cell["\<\
Print[\"m = \",m,\" n = \",n,\" O(c) \",h^2+k,\" M.ch. \",ern,\" C \", \
ern/(h^2+k)]\
\>", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[BlackScholes[S,X,str,r,t],{S,0,150},PlotRange->All,PlotStyle->RGBColor[\
0,0,0], DisplayFunction->Identity];
g1=ListPlot[grf[n],PlotStyle->{PointSize[0.02],RGBColor[0,0,0]},\
DisplayFunction->Identity];
g2=Plot[BlackScholes[S,X,sigma,r,t],{S,0,150},PlotRange->All, \
DisplayFunction->Identity];

Show[g2,g1,g,DisplayFunction->$DisplayFunction,PlotRange->{{20,120},{0,65}}]
\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.2 0.01 0 0.00950822 [
[.2 -0.0125 -6 -9 ]
[.2 -0.0125 6 0 ]
[.4 -0.0125 -6 -9 ]
[.4 -0.0125 6 0 ]
[.6 -0.0125 -6 -9 ]
[.6 -0.0125 6 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[-0.0125 .09508 -12 -4.5 ]
[-0.0125 .09508 0 4.5 ]
[-0.0125 .19016 -12 -4.5 ]
[-0.0125 .19016 0 4.5 ]
[-0.0125 .28525 -12 -4.5 ]
[-0.0125 .28525 0 4.5 ]
[-0.0125 .38033 -12 -4.5 ]
[-0.0125 .38033 0 4.5 ]
[-0.0125 .47541 -12 -4.5 ]
[-0.0125 .47541 0 4.5 ]
[-0.0125 .57049 -12 -4.5 ]
[-0.0125 .57049 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2 0 m
.2 .00625 L
s
[(40)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(60)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(80)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(100)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(120)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .09508 m
.00625 .09508 L
s
[(10)] -0.0125 .09508 1 0 Mshowa
0 .19016 m
.00625 .19016 L
s
[(20)] -0.0125 .19016 1 0 Mshowa
0 .28525 m
.00625 .28525 L
s
[(30)] -0.0125 .28525 1 0 Mshowa
0 .38033 m
.00625 .38033 L
s
[(40)] -0.0125 .38033 1 0 Mshowa
0 .47541 m
.00625 .47541 L
s
[(50)] -0.0125 .47541 1 0 Mshowa
0 .57049 m
.00625 .57049 L
s
[(60)] -0.0125 .57049 1 0 Mshowa
.125 Mabswid
0 .01902 m
.00375 .01902 L
s
0 .03803 m
.00375 .03803 L
s
0 .05705 m
.00375 .05705 L
s
0 .07607 m
.00375 .07607 L
s
0 .1141 m
.00375 .1141 L
s
0 .13312 m
.00375 .13312 L
s
0 .15213 m
.00375 .15213 L
s
0 .17115 m
.00375 .17115 L
s
0 .20918 m
.00375 .20918 L
s
0 .2282 m
.00375 .2282 L
s
0 .24721 m
.00375 .24721 L
s
0 .26623 m
.00375 .26623 L
s
0 .30426 m
.00375 .30426 L
s
0 .32328 m
.00375 .32328 L
s
0 .3423 m
.00375 .3423 L
s
0 .36131 m
.00375 .36131 L
s
0 .39935 m
.00375 .39935 L
s
0 .41836 m
.00375 .41836 L
s
0 .43738 m
.00375 .43738 L
s
0 .45639 m
.00375 .45639 L
s
0 .49443 m
.00375 .49443 L
s
0 .51344 m
.00375 .51344 L
s
0 .53246 m
.00375 .53246 L
s
0 .55148 m
.00375 .55148 L
s
0 .58951 m
.00375 .58951 L
s
0 .60853 m
.00375 .60853 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 0 m
.0006 0 L
.00241 0 L
.00434 0 L
.00544 0 L
.00646 0 L
.00755 0 L
.00875 0 L
.01077 0 L
.01187 0 L
.0129 0 L
.01486 0 L
.01665 0 L
.01872 0 L
.02068 0 L
.02176 0 L
.02277 0 L
.02466 0 L
.0267 0 L
.02784 0 L
.0289 0 L
.03067 0 L
.0326 0 L
.03463 0 L
.03651 0 L
.03876 0 L
.04088 0 L
.04278 0 L
.04485 0 L
.0471 0 L
.04949 0 L
.05152 0 L
.05377 0 L
.0557 0 L
.05748 0 L
.05945 0 L
.06154 0 L
.06374 0 L
.06582 0 L
.06769 0 L
.06971 0 L
.0734 0 L
.07526 0 L
.07731 0 L
.07905 0 L
.08092 0 L
.0843 0 L
.0865 0 L
.08853 0 L
.09071 0 L
Mistroke
.09313 0 L
.09718 0 L
.0994 0 L
.10149 0 L
.10542 0 L
.10903 0 L
.113 0 L
.11717 0 L
.12121 0 L
.12503 0 L
.12846 0 L
.13218 0 L
.13623 0 L
.14053 0 L
.14419 1e-005 L
.14823 1e-005 L
.15199 1e-005 L
.15542 1e-005 L
.15912 2e-005 L
.16316 2e-005 L
.16688 2e-005 L
.17033 3e-005 L
.17714 5e-005 L
.18131 6e-005 L
.18515 7e-005 L
.18928 9e-005 L
.1938 .00012 L
.20143 .00017 L
.20949 .00025 L
.21681 .00035 L
.22465 .00049 L
.23206 .00066 L
.2388 .00086 L
.24638 .00114 L
.25443 .00152 L
.26889 .00245 L
.27691 .00314 L
.28444 .00391 L
.30159 .00619 L
.31709 .009 L
.3334 .01284 L
.36256 .02225 L
.39367 .0361 L
.42261 .05245 L
.48414 .09641 L
.54953 .15208 L
.61253 .20981 L
.67314 .26678 L
.73762 .32789 L
.79971 .38688 L
Mistroke
.85942 .44363 L
.92298 .50407 L
.98416 .56224 L
Mfstroke
.98416 .56224 m
1 .5773 L
s
0 0 0 r
.02 w
.04 0 Mdot
.05125 0 Mdot
.06303 0 Mdot
.07536 0 Mdot
.08827 0 Mdot
.10178 0 Mdot
.11593 0 Mdot
.13074 1e-005 Mdot
.14625 2e-005 Mdot
.16248 4e-005 Mdot
.17947 9e-005 Mdot
.19726 .0002 Mdot
.21589 .00042 Mdot
.23538 .00087 Mdot
.25579 .00172 Mdot
.27716 .00324 Mdot
.29953 .00585 Mdot
.32295 .01009 Mdot
.34747 .01659 Mdot
.37313 .02598 Mdot
.4 .0388 Mdot
.42813 .05536 Mdot
.45757 .0757 Mdot
.4884 .09958 Mdot
.52067 .12667 Mdot
.55446 .15654 Mdot
.58983 .18883 Mdot
.62686 .22329 Mdot
.66562 .25975 Mdot
.7062 .29813 Mdot
.74868 .33843 Mdot
.79316 .38067 Mdot
.83972 .42492 Mdot
.88846 .47125 Mdot
.93949 .51977 Mdot
.99291 .57056 Mdot
.5 Mabswid
0 0 m
.0006 0 L
.00241 0 L
.00434 0 L
.00544 0 L
.00646 0 L
.00755 0 L
.00875 0 L
.01077 0 L
.01187 0 L
.0129 0 L
.01486 0 L
.01665 0 L
.01872 0 L
.02068 0 L
.02176 0 L
.02277 0 L
.02466 0 L
.0267 0 L
.02784 0 L
.0289 0 L
.03067 0 L
.0326 0 L
.03463 0 L
.03651 0 L
.03876 0 L
.04088 0 L
.04278 0 L
.04485 0 L
.0471 0 L
.04949 0 L
.05152 0 L
.05377 0 L
.0557 0 L
.05748 0 L
.05945 0 L
.06154 0 L
.06374 0 L
.06582 0 L
.06769 0 L
.06971 0 L
.0734 0 L
.07526 0 L
.07731 0 L
.07905 0 L
.08092 0 L
.0843 0 L
.0865 0 L
.08853 0 L
.09071 0 L
Mistroke
.09313 0 L
.09718 0 L
.0994 0 L
.10149 0 L
.10542 0 L
.10903 0 L
.113 0 L
.11717 0 L
.12121 0 L
.12503 0 L
.12846 0 L
.13218 0 L
.13623 0 L
.14053 0 L
.14419 1e-005 L
.14823 1e-005 L
.15199 1e-005 L
.15542 1e-005 L
.15912 2e-005 L
.16316 2e-005 L
.16688 2e-005 L
.17033 3e-005 L
.17714 5e-005 L
.18131 6e-005 L
.18515 7e-005 L
.18928 9e-005 L
.1938 .00012 L
.20143 .00017 L
.20949 .00025 L
.21681 .00035 L
.22465 .00049 L
.23206 .00066 L
.2388 .00086 L
.24638 .00114 L
.25443 .00152 L
.26889 .00245 L
.27691 .00314 L
.28444 .00391 L
.30159 .00619 L
.31709 .009 L
.3334 .01284 L
.36256 .02225 L
.39367 .0361 L
.42261 .05245 L
.48414 .09641 L
.54953 .15208 L
.61253 .20981 L
.67314 .26678 L
.73762 .32789 L
.79971 .38688 L
Mistroke
.85942 .44363 L
.92298 .50407 L
.98416 .56224 L
Mfstroke
.98416 .56224 m
1 .5773 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{374.438, 231.313},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005f0000ib000`400?l00000o`00003oo`3ooomg
0?ooo`00o`3ooomg0?ooo`00DP3oool3@0000080oooo00=000000?ooo`3oool0?@3oool2@00000@0
oooo00=000000?ooo`3oool0?P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo03T0
oooo1D0000020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0=P3oool5@0000004
0?oood0000100000@00000<0oooo00=000000?ooo`3oool00`3oool005<0oooo00I000000?ooo`3o
oom000000?oood00000n0?ooo`03@000003ooom000000080oooo00=000000?oood000000?P3oool0
0d000000oooo@00000020?ooo`03@000003ooom0000003`0oooo00M000000?ooo`3oool0oooo@000
003ooom000000080oooo00=000000?oood000000>@3oool01D000000oooo0?ooo`3ooom0000000@0
oooo00=000000?oood000000103oool00540oooo14000000103ooom000000?oood00000n0?ooo`03
@000003ooom000000080oooo00=000000?oood000000?P3oool00d000000oooo@00000020?ooo`03
@000003ooom0000003`0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=00000
0?oood000000>@3oool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo
@00000040?ooo`00D@3oool00d000000oooo@00000020?ooo`03@000003ooom0000003h0oooo0T00
00030?ooo`03@000003ooom0000003l0oooo00M000000?ooo`3oool0oooo@000003ooom0000003`0
oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000>@3oool0
0d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@00000040?ooo`00DP3o
ool2@0000080oooo00=000000?oood000000?P3oool00d000000oooo0?ooo`020?ooo`03@000003o
oom0000003h0oooo00=000000?oood0000000P3oool00d000000oooo@000000l0?ooo`07@000003o
ool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom0000003T0oooo00M000000?ooo`3o
ool0oooo@000003ooom000000080oooo00=000000?oood000000103oool005<0oooo00E000000?oo
o`3oool0oooo@00000100?ooo`9000000`3oool00d000000oooo0?ooo`0n0?ooo`03@000003oool0
oooo0080oooo00=000000?ooo`3oool0>P3oool2@00000@0oooo00=000000?ooo`3oool00P3oool0
0d000000oooo0?ooo`0g0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0
oooo00<0oooo003o0?ooogL0oooo003o0?ooogL0oooo003o0?ooogL0oooo003o0?ooogL0oooo003o
0?ooogL0oooo000K0?ooob@0000000<0oooo000000000000200000000`3oool00000000000030000
0080oooo1@00003o0?ooob00oooo000@0?ooool00000G@0000000d000000oooo0?ooo`070?ooo`00
403oool00`000000oooo0?ooo`080?ooob@0000000<0oooo000000000000200000000`3oool00000
0000000300000080oooo800000030?ooo`D00000403oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00L0oooo000@0?ooo`030000003oool0oooo00P0oooo900000000`3oool000000000
0008000000030?ooo`000000000000<000000P3oool5000000030?ooo`000000000000<000000P3o
ool500000080oooo1@0000020?ooo`d00000403oool00d000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00=000000?ooo`3oool03`3oool00d000000oooo0?ooo`0>0?ooo`03@000003o
ool0oooo00l0oooo00<000000?ooo`3oool03P3oool00d000000oooo0?ooo`0?0?ooo`03@000003o
ool0oooo00h0oooo00=000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`03@000003o
ool0oooo00h0oooo00=000000?ooo`3oool03`3oool00d000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00L0oooo000@0?ooo`030000003oool0oooo00T0oooo0`0000001@3oool0000000000000
0000oooo00<0000000@0oooo00000000000000000P3oool3000000040?ooo`000000000000000080
oooo0`0000020?ooo`<000000`3oool300000080oooo0`0000030?ooo`<00000103oool300000080
oooo1@0000020?ooo`D000000P3oool500000080oooo1@0000030?ooo`L0000000<0oooo00000000
00000`00000I0?ooo`03@000003oool0oooo04<0oooo00=000000?ooo`3oool0@P3oool00d000000
oooo0?ooo`130?ooo`03@000003oool0oooo00L0oooo000@0?ooo`030000003oool0oooo04H0oooo
0`0000040?ooo`<00000103oool3000000<0oooo1@0000030?ooo`D000000P3oool600000?@0oooo
000@0?ooo`030000003oool0oooo05/0oooo0`0000050?ooo`<00000103oool>00000>/0oooo000@
0?ooo`030000003oool0oooo06X0oooo1@0000040?ooo`D00000j`3oool00100oooo00<00000@000
003oool0J`3oool3000000D0oooo1`00003Y0?ooo`00403oool00`000000oooo0?ooo`1c0?ooo`D0
00000P3oool700000>80oooo000@0?ooo`030000003oool0oooo07@0oooo0`0000050?ooo`D00000
hP3oool00100oooo00<000000?ooo`3oool0O03oool500000>80oooo000@0?ooo`030000003oool0
oooo07`0oooo1`00003P0?ooo`00403oool00`000000oooo0?ooo`1m0?ooo`<000000`3oool20000
0=h0oooo000@0?ooo`030000003oool0oooo08D0oooo1@00003I0?ooo`00403oool00`0000100000
0?ooo`250?ooo`D00000f@3oool00100oooo00<000000?ooo`3oool0Q@3oool600000=P0oooo000@
0?ooo`030000003oool0oooo08D0oooo1@0000000`3oool000000?ooo`3F0?ooo`00403oool00`00
0000oooo0?ooo`260?ooo`<000000`3oool200000=D0oooo000@0?ooo`030000003oool0oooo08h0
oooo0P00003C0?ooo`00403oool00`000000oooo0?ooo`2?0?ooo`D00000c`3oool00100oooo00<0
0000@000003oool0S`3oool500000<l0oooo000@0?ooo`030000003oool0oooo08l0oooo1@00003?
0?ooo`00403oool00`000000oooo0?ooo`2?0?ooo`H00000cP3oool00100oooo00<000000?ooo`3o
ool0T03oool300000080oooo0P00003<0?ooo`00403oool00`000000oooo0?ooo`2G0?ooo`030000
003oool0oooo0<T0oooo000@0?ooo`030000003oool0oooo09P0oooo0P0000390?ooo`00403oool0
0`000000oooo0?ooo`2I0?ooo`D00000a@3oool00100oooo00<00000@000003oool0V@3oool50000
0<D0oooo000@0?ooo`030000003oool0oooo09T0oooo1@0000350?ooo`00403oool00`000000oooo
0?ooo`2I0?ooo`H00000a03oool00100oooo00<000000?ooo`3oool0VP3oool300000080oooo0P00
00320?ooo`00403oool00`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo0;l0oooo00020?oo
o`E000000P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo0:80oooo00<000000?oo
o`3oool0_P3oool000@0oooo00M000000?ooo`3oool0oooo@000003ooom0000000D0oooo00<00000
0?ooo`3oool0X`3oool200000;h0oooo00040?ooo`07@000003oool0oooo0?oood000000oooo@000
00050?ooo`80000000=000000?ooo`3oool0XP3oool500000;X0oooo00040?ooo`07@000003oool0
oooo0?oood000000oooo@00000050?ooo`030000003oool0oooo0:@0oooo1@00002j0?ooo`00103o
ool01d000000oooo0?ooo`3ooom000000?oood0000001@3oool00`000000oooo0?ooo`2T0?ooo`D0
0000^P3oool000<0oooo0T0000040?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0
Y03oool600000;T0oooo000@0?ooo`030000003oool0oooo0:D0oooo0`0000020?ooo`030000003o
ool0oooo0;H0oooo000@0?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`3oool0]@3oool0
0100oooo00<00000@000003oool0[03oool00`000000oooo0?ooo`2d0?ooo`00403oool00`000000
oooo0?ooo`2]0?ooo`800000]03oool00100oooo00<000000?ooo`3oool0[`3oool00`000000oooo
0?ooo`2a0?ooo`00403oool00`000000oooo0?ooo`2_0?ooo`D00000[`3oool00100oooo00<00000
0?ooo`3oool0[`3oool500000:l0oooo000@0?ooo`030000003oool0oooo0:l0oooo1@00002_0?oo
o`00403oool00`000000oooo0?ooo`2_0?ooo`H00000[P3oool00100oooo00<00000@000003oool0
/03oool300000080oooo00<000000?ooo`3oool0Z`3oool00100oooo00<000000?ooo`3oool0]P3o
ool00`000000oooo0?ooo`2Z0?ooo`00403oool00`000000oooo0?ooo`2g0?ooo`030000003oool0
oooo0:T0oooo000@0?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`3oool0Z03oool00100
oooo00<000000?ooo`3oool0^@3oool200000:P0oooo000@0?ooo`030000003oool0oooo0;/0oooo
00<000000?ooo`3oool0Y@3oool00100oooo00<00000@000003oool0_03oool00`000000oooo0?oo
o`2T0?ooo`00403oool00`000000oooo0?ooo`2k0?ooo`D00000X`3oool00100oooo00<000000?oo
o`3oool0^`3oool500000:<0oooo000@0?ooo`030000003oool0oooo0;/0oooo1@00002S0?ooo`00
403oool00`000000oooo0?ooo`2k0?ooo`H00000XP3oool00100oooo00<000000?ooo`3oool0_03o
ool300000080oooo0P00002P0?ooo`00403oool00`000000oooo0?ooo`330?ooo`030000003oool0
oooo09d0oooo000@0?ooo`03000004000000oooo0<@0oooo00<000000?ooo`3oool0W03oool00100
oooo00<000000?ooo`3oool0a@3oool00`000000oooo0?ooo`2K0?ooo`00403oool00`000000oooo
0?ooo`360?ooo`030000003oool0oooo09X0oooo000@0?ooo`030000003oool0oooo0<L0oooo00<0
00000?ooo`3oool0V@3oool00100oooo00<000000?ooo`3oool0b03oool00`000000oooo0?ooo`2H
0?ooo`000`3oool3@00000<0oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`370?oo
o`D00000U`3oool000<0oooo00=000000?ooo`3oool00P3oool00d000000oooo@00000050?ooo`03
0000003oool0oooo0<L0oooo1@00002G0?ooo`00103oool01d000000oooo0?ooo`3ooom000000?oo
od0000001@3oool200000003@000003oool0oooo0<D0oooo1@00002G0?ooo`00103oool01d000000
oooo0?ooo`3ooom000000?oood0000001@3oool00`000000oooo0?ooo`370?ooo`L00000U@3oool0
00<0oooo00=000000?oood0000000P3oool00d000000oooo@00000050?ooo`030000003oool0oooo
0<P0oooo0`0000030?ooo`030000003oool0oooo0980oooo00040?ooo`03@000003oool0oooo0080
oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`3?0?ooo`030000003oool0oooo0940
oooo000@0?ooo`030000003oool0oooo0=00oooo00<000000?ooo`3oool0T03oool00100oooo00<0
00000?ooo`3oool0d@3oool00`000000oooo0?ooo`2?0?ooo`00403oool00`00001000000?ooo`3B
0?ooo`030000003oool0oooo08h0oooo000@0?ooo`030000003oool0oooo0=<0oooo00<000000?oo
o`3oool0S@3oool00100oooo00<000000?ooo`3oool0e03oool00`000000oooo0?ooo`2<0?ooo`00
403oool00`000000oooo0?ooo`3E0?ooo`030000003oool0oooo08/0oooo000@0?ooo`030000003o
ool0oooo0=@0oooo1@00002:0?ooo`00403oool00`000000oooo0?ooo`3D0?ooo`D00000RP3oool0
0100oooo00<000000?ooo`3oool0e03oool5000008X0oooo000@0?ooo`03000004000000oooo0=@0
oooo1P0000290?ooo`00403oool00`000000oooo0?ooo`3E0?ooo`<000000P3oool00`000000oooo
0?ooo`260?ooo`00403oool00`000000oooo0?ooo`3K0?ooo`030000003oool0oooo08D0oooo000@
0?ooo`030000003oool0oooo0=`0oooo0P0000250?ooo`00403oool00`000000oooo0?ooo`3N0?oo
o`030000003oool0oooo0880oooo000@0?ooo`030000003oool0oooo0=l0oooo00<000000?ooo`3o
ool0P@3oool00100oooo00<000000?ooo`3oool0h03oool00`000000oooo0?ooo`200?ooo`00403o
ool00`00001000000?ooo`3Q0?ooo`030000003oool0oooo07l0oooo000@0?ooo`030000003oool0
oooo0>80oooo00<000000?ooo`3oool0OP3oool00100oooo00<000000?ooo`3oool0h`3oool00`00
0000oooo0?ooo`1m0?ooo`00403oool00`000000oooo0?ooo`3R0?ooo`D00000O03oool00100oooo
00<000000?ooo`3oool0hP3oool5000007`0oooo000@0?ooo`030000003oool0oooo0>80oooo1@00
001l0?ooo`00403oool00`00001000000?ooo`3R0?ooo`H00000N`3oool00100oooo00<000000?oo
o`3oool0h`3oool300000080oooo00<000000?ooo`3oool0N03oool00100oooo00<000000?ooo`3o
ool0j@3oool00`000000oooo0?ooo`1g0?ooo`00403oool00`000000oooo0?ooo`3Z0?ooo`030000
003oool0oooo07H0oooo000@0?ooo`030000003oool0oooo0>/0oooo00<000000?ooo`3oool0M@3o
ool000<0oooo0T0000040?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0k03oool0
0`000000oooo0?ooo`1d0?ooo`001@3oool01T000000oooo0?oood000000oooo@00000D0oooo00<0
00000?ooo`3oool0k@3oool00`000000oooo0?ooo`1c0?ooo`00103oool01d000000oooo0?ooo`3o
oom000000?oood0000001@3oool200000003@000003oool0oooo0>`0oooo00<000000?ooo`3oool0
LP3oool000D0oooo00I000000?ooo`3ooom000000?oood0000050?ooo`030000003oool0oooo0>l0
oooo00<000000?ooo`3oool0L@3oool000<0oooo00=000000?oood0000000P3oool00d000000oooo
@00000050?ooo`030000003oool0oooo0?00oooo00<000000?ooo`3oool0L03oool000@0oooo00=0
00000?ooo`3oool00P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo0?00oooo1@00
001^0?ooo`00403oool00`000000oooo0?ooo`3`0?ooo`D00000KP3oool00100oooo00<000000?oo
o`3oool0l03oool5000006h0oooo000@0?ooo`03000004000000oooo0?00oooo1P00001]0?ooo`00
403oool00`000000oooo0?ooo`3a0?ooo`<000000P3oool00`000000oooo0?ooo`1Z0?ooo`00403o
ool00`000000oooo0?ooo`3g0?ooo`030000003oool0oooo06T0oooo000@0?ooo`030000003oool0
oooo0?P0oooo00<000000?ooo`3oool0J03oool00100oooo00<000000?ooo`3oool0n@3oool00`00
0000oooo0?ooo`1W0?ooo`00403oool00`000000oooo0?ooo`3j0?ooo`030000003oool0oooo06H0
oooo000@0?ooo`030000003oool0oooo0?/0oooo00<000000?ooo`3oool0I@3oool00100oooo00<0
0000@000003oool0o03oool00`000000oooo0?ooo`1T0?ooo`00403oool00`000000oooo0?ooo`3m
0?ooo`030000003oool0oooo06<0oooo000@0?ooo`030000003oool0oooo0?h0oooo00<000000?oo
o`3oool0HP3oool00100oooo00<000000?ooo`3oool0o`3oool00`000000oooo0?ooo`1Q0?ooo`00
403oool00`000000oooo0?ooo`3o0?ooo`D00000G`3oool00100oooo00<000000?ooo`3oool0o`3o
ool5000005l0oooo000@0?ooo`030000003oool0oooo0?l0oooo1@00001O0?ooo`00403oool00`00
001000000?ooo`3o0?ooo`D00000G`3oool00100oooo00<000000?ooo`3oool0o`3oool10?ooo`<0
000000<0oooo0000003oool0G@3oool00100oooo00<000000?ooo`3oool0o`3oool60?ooo`030000
003oool0oooo05/0oooo000@0?ooo`030000003oool0oooo0?l0oooo1`3oool00`000000oooo0?oo
o`1J0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`P0oooo00<000000?ooo`3oool0F@3oool0
0100oooo00<000000?ooo`3oool0o`3oool90?ooo`800000F@3oool00100oooo00<00000@000003o
ool0o`3oool;0?ooo`030000003oool0oooo05H0oooo000@0?ooo`030000003oool0oooo0?l0oooo
303oool00`000000oooo0?ooo`1E0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`d0oooo00<0
00000?ooo`3oool0E03oool00100oooo00<000000?ooo`3oool0o`3oool>0?ooo`030000003oool0
oooo05<0oooo000@0?ooo`030000003oool0oooo0?l0oooo3`3oool00`000000oooo0?ooo`1B0?oo
o`00103oool3@0000080oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooa00
oooo00<000000?ooo`3oool0D@3oool000D0oooo00I000000?ooo`3ooom000000?oood0000050?oo
o`030000003oool0oooo0?l0oooo3`3oool500000500oooo00030?ooo`A0000000@0oooo@000003o
oom000001@3oool200000003@000003oool0oooo0?l0oooo3@3oool500000500oooo00030?ooo`03
@000003ooom000000080oooo00=000000?oood0000001@3oool00`000000oooo0?ooo`3o0?ooo`l0
oooo1@00001@0?ooo`00103oool2@0000080oooo00=000000?oood0000001@3oool00`000000oooo
0?ooo`3o0?ooo`l0oooo1P00001?0?ooo`001@3oool01D000000oooo0?ooo`3ooom0000000H0oooo
00<000000?ooo`3oool0o`3oool@0?ooo`<000000P3oool00`000000oooo0?ooo`1<0?ooo`00403o
ool00`000000oooo0?ooo`3o0?oooaH0oooo00<000000?ooo`3oool0B`3oool00100oooo00<00000
0?ooo`3oool0o`3ooolG0?ooo`030000003oool0oooo04X0oooo000@0?ooo`03000004000000oooo
0?l0oooo603oool00`000000oooo0?ooo`190?ooo`00403oool00`000000oooo0?ooo`3o0?oooaT0
oooo00<000000?ooo`3oool0B03oool00100oooo00<000000?ooo`3oool0o`3ooolJ0?ooo`030000
003oool0oooo04L0oooo000@0?ooo`030000003oool0oooo0?l0oooo6`3oool00`000000oooo0?oo
o`160?ooo`00403oool00`000000oooo0?ooo`3o0?oooa`0oooo00<000000?ooo`3oool0A@3oool0
0100oooo00<000000?ooo`3oool0o`3ooolM0?ooo`030000003oool0oooo04@0oooo000@0?ooo`03
0000003oool0oooo0?l0oooo7P3oool2000004@0oooo000@0?ooo`03000004000000oooo0?l0oooo
803oool00`000000oooo0?ooo`110?ooo`00403oool00`000000oooo0?ooo`3o0?oooal0oooo1@00
00100?ooo`00403oool00`000000oooo0?ooo`3o0?oooal0oooo1@0000100?ooo`00403oool00`00
0000oooo0?ooo`3o0?oooal0oooo1@0000100?ooo`00403oool00`000000oooo0?ooo`3o0?oooal0
oooo1P00000o0?ooo`00403oool00`000000oooo0?ooo`3o0?ooob00oooo0`0000020?ooo`030000
003oool0oooo03`0oooo000@0?ooo`030000003oool0oooo0?l0oooo9P3oool00`000000oooo0?oo
o`0k0?ooo`00403oool00`00001000000?ooo`3o0?ooobL0oooo00<000000?ooo`3oool0>P3oool0
0100oooo00<000000?ooo`3oool0o`3ooolX0?ooo`030000003oool0oooo03T0oooo000@0?ooo`03
0000003oool0oooo0?l0oooo:@3oool00`000000oooo0?ooo`0h0?ooo`00403oool00`000000oooo
0?ooo`3o0?ooobX0oooo00<000000?ooo`3oool0=`3oool00100oooo00<000000?ooo`3oool0o`3o
ool[0?ooo`030000003oool0oooo03H0oooo000@0?ooo`030000003oool0oooo0?l0oooo;03oool0
0`000000oooo0?ooo`0e0?ooo`00403oool00`00001000000?ooo`3o0?ooobd0oooo00<000000?oo
o`3oool0=03oool00100oooo00<000000?ooo`3oool0o`3oool^0?ooo`030000003oool0oooo03<0
oooo000@0?ooo`030000003oool0oooo0?l0oooo;`3oool00`000000oooo0?ooo`0b0?ooo`00403o
ool00`000000oooo0?ooo`3o0?oooc00oooo00<000000?ooo`3oool0<@3oool00100oooo00<00000
0?ooo`3oool0o`3oool`0?ooo`D00000;`3oool000@0oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo<03oool5000002l0oooo00030?ooo`03
@000003ooom000000080oooo00=000000?oood0000001@3oool00`000000oooo0?ooo`3o0?oooc00
oooo1@00000_0?ooo`001@3oool01T000000oooo0?oood000000oooo@00000D0oooo0P0000000d00
0000oooo0?ooo`3o0?ooobh0oooo1P00000^0?ooo`000`3oool2@00000<0oooo00=000000?oood00
00001@3oool00`000000oooo0?ooo`3o0?oooc40oooo0`0000020?ooo`030000003oool0oooo02/0
oooo00030?ooo`03@000003oool0oooo0080oooo00=000000?oood0000001@3oool00`000000oooo
0?ooo`3o0?ooocL0oooo00<000000?ooo`3oool0:P3oool000<0oooo0d0000030?ooo`03@000003o
ool0oooo00@0oooo00<000000?ooo`3oool0o`3ooolh0?ooo`030000003oool0oooo02T0oooo000@
0?ooo`030000003oool0oooo0?l0oooo>@3oool00`000000oooo0?ooo`0X0?ooo`00403oool00`00
0000oooo0?ooo`3o0?ooocX0oooo00<000000?ooo`3oool09`3oool00100oooo00<000000?ooo`3o
ool0o`3ooolk0?ooo`030000003oool0oooo02H0oooo000@0?ooo`03000004000000oooo0?l0oooo
?03oool00`000000oooo0?ooo`0U0?ooo`00403oool00`000000oooo0?ooo`3o0?ooocd0oooo00<0
00000?ooo`3oool0903oool00100oooo00<000000?ooo`3oool0o`3oooln0?ooo`030000003oool0
oooo02<0oooo000@0?ooo`030000003oool0oooo0?l0oooo?`3oool00`000000oooo0?ooo`0R0?oo
o`00403oool00`000000oooo0?ooo`3o0?oood00oooo00<000000?ooo`3oool08@3oool00100oooo
00<000000?ooo`3oool0o`3ooom10?ooo`030000003oool0oooo0200oooo000@0?ooo`0300000400
0000oooo0?l0oooo@P3oool00`000000oooo0?ooo`0O0?ooo`00403oool00`000000oooo0?ooo`3o
0?oood80oooo1@00000M0?ooo`00403oool00`000000oooo0?ooo`3o0?oood80oooo1@00000M0?oo
o`00403oool00`000000oooo0?ooo`3o0?oood80oooo1@00000M0?ooo`00403oool00`000000oooo
0?ooo`3o0?oood80oooo1@00000M0?ooo`00403oool00`000000oooo0?ooo`3o0?oood<0oooo0`00
00000`3oool000000?ooo`0K0?ooo`00403oool00`000000oooo0?ooo`3o0?ooodP0oooo00<00000
0?ooo`3oool06@3oool00100oooo00<00000@000003oool0o`3ooom90?ooo`8000006@3oool00100
oooo00<000000?ooo`3oool0o`3ooom;0?ooo`030000003oool0oooo01H0oooo000@0?ooo`030000
003oool0oooo0?l0ooooC03oool00`000000oooo0?ooo`0E0?ooo`00403oool00`000000oooo0?oo
o`3o0?ooodd0oooo00<000000?ooo`3oool0503oool00100oooo00<000000?ooo`3oool0o`3ooom>
0?ooo`030000003oool0oooo01<0oooo000@0?ooo`030000003oool0oooo0?l0ooooC`3oool00`00
0000oooo0?ooo`0B0?ooo`00403oool00`00001000000?ooo`3o0?oooe00oooo00<000000?ooo`3o
ool04@3oool00100oooo00<000000?ooo`3oool0o`3ooomA0?ooo`030000003oool0oooo0100oooo
000@0?ooo`030000003oool0oooo0?l0ooooDP3oool00`000000oooo0?ooo`0?0?ooo`00403oool0
0`000000oooo0?ooo`3o0?oooe<0oooo00<000000?ooo`3oool03P3oool00100oooo00<000000?oo
o`3oool0o`3ooomD0?ooo`030000003oool0oooo00d0oooo00030?ooo`900000103oool00d000000
oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooE@3oool00`000000oooo0?ooo`0<0?ooo`00
0`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000D0oooo00<000000?ooo`3oool0
o`3ooomE0?ooo`D000002P3oool000<0oooo00=000000?oood0000000P3oool00d000000oooo@000
00050?ooo`80000000=000000?ooo`3oool0o`3ooomC0?ooo`D000002P3oool000<0oooo0T000003
0?ooo`03@000003ooom0000000D0oooo00<000000?ooo`3oool0o`3ooomE0?ooo`D000002P3oool0
00<0oooo00=000000?ooo`3oool00P3oool00d000000oooo@00000050?ooo`030000003oool0oooo
0?l0ooooE@3oool500000003@000003oool0oooo00L0oooo00040?ooo`9000000`3oool00d000000
oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooEP3oool3000000/0oooo000@0?ooo`030000
003oool0oooo0?l0ooooI03oool00100oooo00<000000?ooo`3oool0o`3ooomT0?ooo`00403oool0
0`000000oooo0?ooo`3o0?ooof@0oooo000@0?ooo`03000004000000oooo0?l0ooooI03oool00100
oooo00<000000?ooo`3oool0o`3ooomT0?ooo`00403oool00`000000oooo0?ooo`3o0?ooof@0oooo
000@0?ooo`030000003oool0oooo0?l0ooooI03oool00100oooo00<000000?ooo`3oool0o`3ooomT
0?ooo`00403oool00`000000oooo0?ooo`3o0?ooof@0oooo000@0?ooo`03000004000000oooo0?l0
ooooI03oool00100oooo00<000000?ooo`3oool0o`3ooomT0?ooo`00403oool00`000000oooo0?oo
o`3o0?ooof@0oooo000@0?ooo`030000003oool0oooo0?l0ooooI03oool00100oooo00=000000?oo
o`3oool0o`3ooomT0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 373.438}, {230.313, 0}} -> {15.302, -4.31131, 
  0.287288, 0.302147}}],

Cell[OutputFormData["\<\
Graphics[{{{Line[{{6.25*^-6, 0.}, 
       {6.085048735937368, 0.}, {9.252237381464611, 0.}, 
       {10.92834527263007, 0.}, {12.72131997890605, 0.}, 
       {13.58981583500571, 0.}, {14.41081114857589, 0.}, 
       {14.76859555493227, 0.}, {15.14788756115237, 0.}, 
       {15.3458484497508, 0.}, {15.45842755904098, 0.}, 
       {15.56389322103873, 8.639696303402299*^-16}, 
       {15.74892276615299, 8.742408334013182*^-16}, 
       {15.94796099451137, -1.520360547607351*^-15}, 
       {16.14748678916432, 1.190888008989799*^-15}, 
       {16.33272540057424, 6.713073242382735*^-16}, 
       {16.53600670174973, 1.523164713309176*^-15}, 
       {16.64966236626321, 5.876829815840527*^-16}, 
       {16.75271334219187, 1.571352941766565*^-15}, 
       {16.94193518787424, 4.806168452996221*^-16}, 
       {17.14662225717303, 2.520181943815007*^-15}, 
       {17.33989013168212, 2.781947946925682*^-15}, 
       {17.51770579578619, 4.142512560974941*^-15}, 
       {17.6898904045284, 9.506645540236807*^-15}, 
       {17.8506400903398, 1.202138509934159*^-14}, 
       {18.02701401583932, 2.320926253900919*^-14}, 
       {18.21608814403598, 3.521308221263463*^-14}, 
       {18.41427471208107, 6.296156588724609*^-14}, 
       {18.60202140597026, 1.026895779637848*^-13}, 
       {18.77056529882066, 1.58105998363544*^-13}, 
       {18.95390495078078, 2.511581648842609*^-13}, 
       {19.14559505591573, 4.006403805875618*^-13}, 
       {19.32135161571152, 6.176886010958272*^-13}, 
       {19.51430942554018, 9.772024860547722*^-13}, 
       {19.71746128460871, 1.574292533648809*^-12}, 
       {19.89480957338853, 2.373558802315149*^-12}, 
       {20.05981003513721, 3.448917169874734*^-12}, 
       {20.24086890548317, 5.169653043352736*^-12}, 
       {20.43429720813612, 7.905941324842437*^-12}, 
       {20.54424218992994, 1.003245913579862*^-11}, 
       {20.64561273269066, 1.247134187791167*^-11}, 
       {20.75469563056533, 1.572555580775298*^-11}, 
       {20.87468707771364, 2.023892869142985*^-11}, 
       {21.07663597961704, 3.076231934684619*^-11}, 
       {21.18709740654358, 3.855623815136415*^-11}, 
       {21.29044299952906, 4.753496039771165*^-11}, 
       {21.48641163754504, 7.032423193656821*^-11}, 
       {21.6654720991523, 9.99955692393652*^-11}, 
       {21.8721528439897, 1.491027938499707*^-10}, 
       {22.06836377526551, 2.164323500490863*^-10}, 
       {22.17594429547324, 2.647886279912325*^-10}, 
       {22.27715761243479, 3.195582812210781*^-10}, 
       {22.46622036131275, 4.520393934113399*^-10}, 
       {22.66983178135164, 6.526598509715045*^-10}, 
       {22.78446518908651, 8.003458761295163*^-10}, 
       {22.88979448939529, 9.636506870662708*^-10}, 
       {23.06658879793855, 1.311199783155835*^-9}, 
       {23.26039284218601, 1.828144469184692*^-9}, 
       {23.46274083686044, 2.571735933224806*^-9}, 
       {23.65140207506652, 3.517022997923652*^-9}, 
       {23.87555387431032, 5.069292964182424*^-9}, 
       {24.08761865138807, 7.11980931606576*^-9}, 
       {24.27800179968204, 9.61009284289668*^-9}, 
       {24.48482514047924, 1.324183699810494*^-8}, 
       {24.70984341897779, 1.865388676325856*^-8}, 
       {24.94858248615937, 2.665127334297491*^-8}, 
       {25.15240291055659, 3.59465055795145*^-8}, 
       {25.37708472577868, 4.971029774793189*^-8}, 
       {25.56955114345861, 6.532054938682505*^-8}, 
       {25.74838140887003, 8.387441362263908*^-8}, 
       {25.9446247737885, 1.099053180054413*^-7}, 
       {26.15399901166563, 1.459712642379534*^-7}, 
       {26.37443248269739, 1.95814830233829*^-7}, 
       {26.58226181261014, 2.571123052267681*^-7}, 
       {26.76886410808682, 3.271097813593321*^-7}, 
       {26.97088197192186, 4.228647855653236*^-7}, 
       {27.34018931929067, 6.692451513721298*^-7}, 
       {27.52625945774697, 8.392820063400701*^-7}, 
       {27.73066736092945, 1.072288219958844*^-6}, 
       {27.9051474392424, 1.317731934904491*^-6}, 
       {28.0923436758292, 1.638887331725904*^-6}, 
       {28.43027573456261, 2.410820843266159*^-6}, 
       {28.649592750201, 3.080865361984304*^-6}, 
       {28.85266962832258, 3.85242411210442*^-6}, 
       {29.07115542364506, 4.881101165789242*^-6}, 
       {29.31251810594775, 6.311370750188661*^-6}, 
       {29.71792373379078, 9.61871525749432*^-6}, 
       {29.94015944622259, 0.00001205356576912489}, 
       {30.14896689293921, 0.00001485030193273229}, 
       {30.54237592764245, 0.00002181348884147812}, 
       {30.90337820720664, 0.00003074493331934073}, 
       {31.29970059015256, 0.00004435496398848856}, 
       {31.7173004906179, 0.00006453115777313857}, 
       {32.12145671770966, 0.00009177862514961548}, 
       {32.50331638953279, 0.0001268362965333559}, 
       {32.84614965820358, 0.0001683265264040816}, 
       {33.21809720439586, 0.0002270607578278537}, 
       {33.62329881656555, 0.0003118147048664695}, 
       {34.0526424514177, 0.0004321268437294523}, 
       {34.41919371810931, 0.0005665672850398706}, 
       {34.82272970130031, 0.0007573682379287336}, 
       {35.19861057201497, 0.0009852905890917716}, 
       {35.54234036039946, 0.001245829235329943}, 
       {35.91235696644234, 0.001593885546669109}, 
       {36.31604371919116, 0.002070636856625979}, 
       {36.68795119905869, 0.002618393089845648}, 
       {37.0330542862503, 0.003238252849817602}, 
       {37.71429732967422, 0.004854779549269383}, 
       {38.13131778791846, 0.006163727952378766}, 
       {38.51480341602531, 0.007631530006442593}, 
       {38.92751334040389, 0.009545115493746841}, 
       {39.38029969313312, 0.01211437136124871}, 
       {40.14329845512483, 0.01781249748289459}, 
       {40.94897501217367, 0.02620642852173809}, 
       {41.68101753646745, 0.03656728554114807}, 
       {42.4653777220957, 0.05133905777034197}, 
       {43.20569829932856, 0.06960321842871985}, 
       {43.88036281326082, 0.09068733363471093}, 
       {44.63837781225354, 0.1204118806775831}, 
       {45.44326852433155, 0.1602568158915493}, 
       {46.88853765715521, 0.2581309420352204}, 
       {47.69078236442507, 0.3300188672738677}, 
       {48.44356065459195, 0.410846099846748}, 
       {50.15914072653425, 0.6512960774991016}, 
       {51.70917996932582, 0.9469248981053048}, 
       {53.34028811760143, 1.350869538574427}, 
       {56.25554609761978, 2.339561125049247}, 
       {59.36720810676584, 3.796992566571748}, 
       {62.26076519761138, 5.516295952290697}, 
       {68.41352678354033, 10.14004017859213}, 
       {74.95255961243797, 15.99490042676441}, 
       {81.25286368430431, 22.06587560421117}, 
       {87.31443899913932, 28.05781490543506}, 
       {93.76228555694302, 34.48469463576183}, 
       {99.9714033577154, 40.68871420209003}, 
       {105.9417924014564, 46.65788174608175}, 
       {112.2984526881662, 53.0142337448846}, 
       {118.4163842178446, 59.13209993106969}, 
       {124.9205869904917, 65.63628784613473}, 
       {131.1860610061075, 71.9017589791959}, 
       {137.212806264692, 77.92850365400465}, 
       {143.6258227662452, 84.34152002592195}, 
       {149.800110510767, 90.51580774554279}, 
       {149.9999937499999, 90.71569098445284}}]}}, 
   {PointSize[0.02], RGBColor[0, 0, 0], 
    {Point[{23.99999999999999, 0}], 
     Point[{25.12512563944476, 1.88735231406258*^-6}], 
     Point[{26.30299743324521, 5.901867082657837*^-6}], 
     Point[{27.53608813351164, 0.00001633915512610399}], 
     Point[{28.82698641555434, 0.0000437810870808237}], 
     Point[{30.17840231239044, 0.0001145522481910482}], 
     Point[{31.5931729040217, 0.0002926049090551139}], 
     Point[{33.07426827342697, 0.0007286104583974715}], 
     Point[{34.62479774177312, 0.001765649728415084}], 
     Point[{36.24801639593388, 0.004156250370428296}], 
     Point[{37.94733192202054, 0.009484579285998936}], 
     Point[{39.72631175926998, 0.02093756538637915}], 
     Point[{41.58869058930878, 0.04461143436750679}], 
     Point[{43.53837817651573, 0.09152899990068785}], 
     Point[{45.57946757594242, 0.180396170451088}], 
     Point[{47.71624372602303, 0.3407488360748354}], 
     Point[{49.95319244411239, 0.6155097574728324}], 
     Point[{52.29500984373696, 1.061284636596617}], 
     Point[{54.74661219332885, 1.744508935681679}], 
     Point[{57.31314623713943, 2.7325285311146}], 
     Point[{60, 4.081119138984584}], 
     Point[{62.81281409861192, 5.822776226431996}], 
     Point[{65.75749358311303, 7.961037704434469}], 
     Point[{68.84022033377911, 10.47352814693002}], 
     Point[{72.06746603888587, 13.32181201101901}], 
     Point[{75.44600578097612, 16.46317629630806}], 
     Point[{78.98293226005423, 19.85989975948332}], 
     Point[{82.68567068356743, 23.48408999902104}], 
     Point[{86.5619943544328, 27.31855952209111}], 
     Point[{90.62004098983473, 31.35532262411239}], 
     Point[{94.86832980505138, 35.59325097769979}], 
     Point[{99.31577939817497, 40.03586118567656}], 
     Point[{103.9717264732719, 44.68963631892576}], 
     Point[{108.8459454412893, 49.56291867009344}], 
     Point[{113.948668939856, 54.66525313518627}], 
     Point[{119.2906093150576, 60.00703246675848}], 
     Point[{124.8829811102809, 65.59932361349953}], 
     Point[{130.7375246093424, 71.453794220071}], 
     Point[{136.8665304833221, 77.5826914202486}], 
     Point[{143.2828655928486, 83.99884716938485}], 
     Point[{150., 90.71569722828417}]}}, 
   {RGBColor[0, 0, 0], {Line[{{6.25*^-6, 0.}, 
       {6.085048735937368, 0.}, {9.252237381464611, 0.}, 
       {10.92834527263007, 0.}, {12.72131997890605, 0.}, 
       {13.58981583500571, 0.}, {14.41081114857589, 0.}, 
       {14.76859555493227, 0.}, {15.14788756115237, 0.}, 
       {15.3458484497508, 0.}, {15.45842755904098, 0.}, 
       {15.56389322103873, 8.639696303402299*^-16}, 
       {15.74892276615299, 8.742408334013182*^-16}, 
       {15.94796099451137, -1.520360547607351*^-15}, 
       {16.14748678916432, 1.190888008989799*^-15}, 
       {16.33272540057424, 6.713073242382735*^-16}, 
       {16.53600670174973, 1.523164713309176*^-15}, 
       {16.64966236626321, 5.876829815840527*^-16}, 
       {16.75271334219187, 1.571352941766565*^-15}, 
       {16.94193518787424, 4.806168452996221*^-16}, 
       {17.14662225717303, 2.520181943815007*^-15}, 
       {17.33989013168212, 2.781947946925682*^-15}, 
       {17.51770579578619, 4.142512560974941*^-15}, 
       {17.6898904045284, 9.506645540236807*^-15}, 
       {17.8506400903398, 1.202138509934159*^-14}, 
       {18.02701401583932, 2.320926253900919*^-14}, 
       {18.21608814403598, 3.521308221263463*^-14}, 
       {18.41427471208107, 6.296156588724609*^-14}, 
       {18.60202140597026, 1.026895779637848*^-13}, 
       {18.77056529882066, 1.58105998363544*^-13}, 
       {18.95390495078078, 2.511581648842609*^-13}, 
       {19.14559505591573, 4.006403805875618*^-13}, 
       {19.32135161571152, 6.176886010958272*^-13}, 
       {19.51430942554018, 9.772024860547722*^-13}, 
       {19.71746128460871, 1.574292533648809*^-12}, 
       {19.89480957338853, 2.373558802315149*^-12}, 
       {20.05981003513721, 3.448917169874734*^-12}, 
       {20.24086890548317, 5.169653043352736*^-12}, 
       {20.43429720813612, 7.905941324842437*^-12}, 
       {20.54424218992994, 1.003245913579862*^-11}, 
       {20.64561273269066, 1.247134187791167*^-11}, 
       {20.75469563056533, 1.572555580775298*^-11}, 
       {20.87468707771364, 2.023892869142985*^-11}, 
       {21.07663597961704, 3.076231934684619*^-11}, 
       {21.18709740654358, 3.855623815136415*^-11}, 
       {21.29044299952906, 4.753496039771165*^-11}, 
       {21.48641163754504, 7.032423193656821*^-11}, 
       {21.6654720991523, 9.99955692393652*^-11}, 
       {21.8721528439897, 1.491027938499707*^-10}, 
       {22.06836377526551, 2.164323500490863*^-10}, 
       {22.17594429547324, 2.647886279912325*^-10}, 
       {22.27715761243479, 3.195582812210781*^-10}, 
       {22.46622036131275, 4.520393934113399*^-10}, 
       {22.66983178135164, 6.526598509715045*^-10}, 
       {22.78446518908651, 8.003458761295163*^-10}, 
       {22.88979448939529, 9.636506870662708*^-10}, 
       {23.06658879793855, 1.311199783155835*^-9}, 
       {23.26039284218601, 1.828144469184692*^-9}, 
       {23.46274083686044, 2.571735933224806*^-9}, 
       {23.65140207506652, 3.517022997923652*^-9}, 
       {23.87555387431032, 5.069292964182424*^-9}, 
       {24.08761865138807, 7.11980931606576*^-9}, 
       {24.27800179968204, 9.61009284289668*^-9}, 
       {24.48482514047924, 1.324183699810494*^-8}, 
       {24.70984341897779, 1.865388676325856*^-8}, 
       {24.94858248615937, 2.665127334297491*^-8}, 
       {25.15240291055659, 3.59465055795145*^-8}, 
       {25.37708472577868, 4.971029774793189*^-8}, 
       {25.56955114345861, 6.532054938682505*^-8}, 
       {25.74838140887003, 8.387441362263908*^-8}, 
       {25.9446247737885, 1.099053180054413*^-7}, 
       {26.15399901166563, 1.459712642379534*^-7}, 
       {26.37443248269739, 1.95814830233829*^-7}, 
       {26.58226181261014, 2.571123052267681*^-7}, 
       {26.76886410808682, 3.271097813593321*^-7}, 
       {26.97088197192186, 4.228647855653236*^-7}, 
       {27.34018931929067, 6.692451513721298*^-7}, 
       {27.52625945774697, 8.392820063400701*^-7}, 
       {27.73066736092945, 1.072288219958844*^-6}, 
       {27.9051474392424, 1.317731934904491*^-6}, 
       {28.0923436758292, 1.638887331725904*^-6}, 
       {28.43027573456261, 2.410820843266159*^-6}, 
       {28.649592750201, 3.080865361984304*^-6}, 
       {28.85266962832258, 3.85242411210442*^-6}, 
       {29.07115542364506, 4.881101165789242*^-6}, 
       {29.31251810594775, 6.311370750188661*^-6}, 
       {29.71792373379078, 9.61871525749432*^-6}, 
       {29.94015944622259, 0.00001205356576912489}, 
       {30.14896689293921, 0.00001485030193273229}, 
       {30.54237592764245, 0.00002181348884147812}, 
       {30.90337820720664, 0.00003074493331934073}, 
       {31.29970059015256, 0.00004435496398848856}, 
       {31.7173004906179, 0.00006453115777313857}, 
       {32.12145671770966, 0.00009177862514961548}, 
       {32.50331638953279, 0.0001268362965333559}, 
       {32.84614965820358, 0.0001683265264040816}, 
       {33.21809720439586, 0.0002270607578278537}, 
       {33.62329881656555, 0.0003118147048664695}, 
       {34.0526424514177, 0.0004321268437294523}, 
       {34.41919371810931, 0.0005665672850398706}, 
       {34.82272970130031, 0.0007573682379287336}, 
       {35.19861057201497, 0.0009852905890917716}, 
       {35.54234036039946, 0.001245829235329943}, 
       {35.91235696644234, 0.001593885546669109}, 
       {36.31604371919116, 0.002070636856625979}, 
       {36.68795119905869, 0.002618393089845648}, 
       {37.0330542862503, 0.003238252849817602}, 
       {37.71429732967422, 0.004854779549269383}, 
       {38.13131778791846, 0.006163727952378766}, 
       {38.51480341602531, 0.007631530006442593}, 
       {38.92751334040389, 0.009545115493746841}, 
       {39.38029969313312, 0.01211437136124871}, 
       {40.14329845512483, 0.01781249748289459}, 
       {40.94897501217367, 0.02620642852173809}, 
       {41.68101753646745, 0.03656728554114807}, 
       {42.4653777220957, 0.05133905777034197}, 
       {43.20569829932856, 0.06960321842871985}, 
       {43.88036281326082, 0.09068733363471093}, 
       {44.63837781225354, 0.1204118806775831}, 
       {45.44326852433155, 0.1602568158915493}, 
       {46.88853765715521, 0.2581309420352204}, 
       {47.69078236442507, 0.3300188672738677}, 
       {48.44356065459195, 0.410846099846748}, 
       {50.15914072653425, 0.6512960774991016}, 
       {51.70917996932582, 0.9469248981053048}, 
       {53.34028811760143, 1.350869538574427}, 
       {56.25554609761978, 2.339561125049247}, 
       {59.36720810676584, 3.796992566571748}, 
       {62.26076519761138, 5.516295952290697}, 
       {68.41352678354033, 10.14004017859213}, 
       {74.95255961243797, 15.99490042676441}, 
       {81.25286368430431, 22.06587560421117}, 
       {87.31443899913932, 28.05781490543506}, 
       {93.76228555694302, 34.48469463576183}, 
       {99.9714033577154, 40.68871420209003}, 
       {105.9417924014564, 46.65788174608175}, 
       {112.2984526881662, 53.0142337448846}, 
       {118.4163842178446, 59.13209993106969}, 
       {124.9205869904917, 65.63628784613473}, 
       {131.1860610061075, 71.9017589791959}, 
       {137.212806264692, 77.92850365400465}, 
       {143.6258227662452, 84.34152002592195}, 
       {149.800110510767, 90.51580774554279}, 
       {149.9999937499999, 90.71569098445284}}]}}}, 
  {DisplayFunction -> (Display[$Display, #1] & ), 
   PlotRange -> {{20, 120}, {0, 65}}, PlotRange -> All, 
   AspectRatio -> GoldenRatio^(-1), 
   DisplayFunction :> Identity, ColorOutput -> Automatic, 
   Axes -> Automatic, AxesOrigin -> Automatic, 
   PlotLabel -> None, AxesLabel -> None, 
   Ticks -> Automatic, GridLines -> None, Prolog -> {}, 
   Epilog -> {}, AxesStyle -> Automatic, 
   Background -> Automatic, DefaultColor -> Automatic, 
   DefaultFont :> $DefaultFont, RotateLabel -> True, 
   Frame -> False, FrameStyle -> Automatic, 
   FrameTicks -> Automatic, FrameLabel -> None, 
   PlotRegion -> Automatic, ImageSize -> Automatic, 
   TextStyle :> $TextStyle, FormatType :> $FormatType}]\
\>", "\<\
-Graphics-\
\>"], "Output"]
}, Open  ]],

Cell[TextData[
"\"Err : rozdiel medzi Black-Scholesov\[YAcute]m rie\.9aen\[IAcute]m a \
na\.9aim vysledkom\n tr1: tabu\:017eka Err\""], "Text"],

Cell["\<\
Err[i_,sgm_]:=EuropeanCallDiv[xs[[i]],X,sgm,r,DD,t]-ys[[i]];
tr1:=Table[{xs[[i]],Err[i,str]},{i,2m+1}];\
\>", "Input"],

Cell[TextData["\"Graf chyby na n-tej \[CHacek]asovej vrstve\""], "Text"],

Cell[CellGroupData[{

Cell["\<\
g=ListPlot[tr1,PlotStyle->{PointSize[0.02],RGBColor[0.,0.,0]},DisplayFunction-\
>Identity];

Show[g,DisplayFunction->$DisplayFunction,AxesLabel->{\"S\",\"CHYBA\"},\
PlotRange->{{20,140},{-0.0024,0.0062}}]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.166667 0.00833333 0.172475 71.8644 [
[.16667 .15997 -6 -9 ]
[.16667 .15997 6 0 ]
[.33333 .15997 -6 -9 ]
[.33333 .15997 6 0 ]
[.5 .15997 -6 -9 ]
[.5 .15997 6 0 ]
[.66667 .15997 -9 -9 ]
[.66667 .15997 9 0 ]
[.83333 .15997 -9 -9 ]
[.83333 .15997 9 0 ]
[1 .15997 -9 -9 ]
[1 .15997 9 0 ]
[1.025 .17247 0 -7.5 ]
[1.025 .17247 10 7.5 ]
[-0.0125 .02875 -36 -4.5 ]
[-0.0125 .02875 0 4.5 ]
[-0.0125 .3162 -30 -4.5 ]
[-0.0125 .3162 0 4.5 ]
[-0.0125 .45993 -30 -4.5 ]
[-0.0125 .45993 0 4.5 ]
[-0.0125 .60366 -30 -4.5 ]
[-0.0125 .60366 0 4.5 ]
[0 .64303 -17.5 0 ]
[0 .64303 17.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.16667 .17247 m
.16667 .17872 L
s
[(40)] .16667 .15997 0 1 Mshowa
.33333 .17247 m
.33333 .17872 L
s
[(60)] .33333 .15997 0 1 Mshowa
.5 .17247 m
.5 .17872 L
s
[(80)] .5 .15997 0 1 Mshowa
.66667 .17247 m
.66667 .17872 L
s
[(100)] .66667 .15997 0 1 Mshowa
.83333 .17247 m
.83333 .17872 L
s
[(120)] .83333 .15997 0 1 Mshowa
1 .17247 m
1 .17872 L
s
[(140)] 1 .15997 0 1 Mshowa
.125 Mabswid
.04167 .17247 m
.04167 .17622 L
s
.08333 .17247 m
.08333 .17622 L
s
.125 .17247 m
.125 .17622 L
s
.20833 .17247 m
.20833 .17622 L
s
.25 .17247 m
.25 .17622 L
s
.29167 .17247 m
.29167 .17622 L
s
.375 .17247 m
.375 .17622 L
s
.41667 .17247 m
.41667 .17622 L
s
.45833 .17247 m
.45833 .17622 L
s
.54167 .17247 m
.54167 .17622 L
s
.58333 .17247 m
.58333 .17622 L
s
.625 .17247 m
.625 .17622 L
s
.70833 .17247 m
.70833 .17622 L
s
.75 .17247 m
.75 .17622 L
s
.79167 .17247 m
.79167 .17622 L
s
.875 .17247 m
.875 .17622 L
s
.91667 .17247 m
.91667 .17622 L
s
.95833 .17247 m
.95833 .17622 L
s
.25 Mabswid
0 .17247 m
1 .17247 L
s
gsave
1.025 .17247 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .02875 m
.00625 .02875 L
s
[(-0.002)] -0.0125 .02875 1 0 Mshowa
0 .3162 m
.00625 .3162 L
s
[(0.002)] -0.0125 .3162 1 0 Mshowa
0 .45993 m
.00625 .45993 L
s
[(0.004)] -0.0125 .45993 1 0 Mshowa
0 .60366 m
.00625 .60366 L
s
[(0.006)] -0.0125 .60366 1 0 Mshowa
.125 Mabswid
0 .06468 m
.00375 .06468 L
s
0 .10061 m
.00375 .10061 L
s
0 .13654 m
.00375 .13654 L
s
0 .20841 m
.00375 .20841 L
s
0 .24434 m
.00375 .24434 L
s
0 .28027 m
.00375 .28027 L
s
0 .35214 m
.00375 .35214 L
s
0 .38807 m
.00375 .38807 L
s
0 .424 m
.00375 .424 L
s
0 .49586 m
.00375 .49586 L
s
0 .5318 m
.00375 .5318 L
s
0 .56773 m
.00375 .56773 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -78.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CHYBA) show
93.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 0 r
.02 w
.03333 .17248 Mdot
.03517 .17247 Mdot
.03703 .17247 Mdot
.03891 .17247 Mdot
.0408 .17247 Mdot
.04271 .17247 Mdot
.04464 .17247 Mdot
.04658 .17247 Mdot
.04854 .17246 Mdot
.05053 .17246 Mdot
.05252 .17246 Mdot
.05454 .17245 Mdot
.05658 .17244 Mdot
.05863 .17243 Mdot
.06071 .17242 Mdot
.0628 .17241 Mdot
.06491 .17239 Mdot
.06704 .17237 Mdot
.0692 .17234 Mdot
.07137 .1723 Mdot
.07356 .17226 Mdot
.07577 .1722 Mdot
.078 .17213 Mdot
.08025 .17205 Mdot
.08253 .17195 Mdot
.08482 .17182 Mdot
.08713 .17167 Mdot
.08947 .17148 Mdot
.09183 .17125 Mdot
.09421 .17098 Mdot
.09661 .17066 Mdot
.09903 .17027 Mdot
.10148 .1698 Mdot
.10395 .16925 Mdot
.10644 .1686 Mdot
.10895 .16784 Mdot
.11149 .16695 Mdot
.11405 .1659 Mdot
.11663 .16469 Mdot
.11924 .16329 Mdot
.12187 .16168 Mdot
.12453 .15983 Mdot
.12721 .15772 Mdot
.12991 .15533 Mdot
.13264 .15262 Mdot
.1354 .14958 Mdot
.13818 .14618 Mdot
.14099 .14239 Mdot
.14382 .1382 Mdot
.14668 .13359 Mdot
.14956 .12854 Mdot
.15247 .12305 Mdot
.15541 .11712 Mdot
.15837 .11075 Mdot
.16137 .10397 Mdot
.16439 .09678 Mdot
.16743 .08924 Mdot
.17051 .0814 Mdot
.17361 .07331 Mdot
.17674 .06505 Mdot
.17991 .05672 Mdot
.1831 .04843 Mdot
.18632 .0403 Mdot
.18956 .03246 Mdot
.19284 .02508 Mdot
.19615 .0183 Mdot
.19949 .01232 Mdot
.20286 .00731 Mdot
.20626 .00346 Mdot
.2097 .00098 Mdot
.21316 4e-005 Mdot
.21666 .00083 Mdot
.22019 .00354 Mdot
.22375 .00833 Mdot
.22734 .01532 Mdot
.23097 .02466 Mdot
.23463 .03642 Mdot
.23832 .05066 Mdot
.24205 .0674 Mdot
.24581 .08661 Mdot
.24961 .10824 Mdot
.25344 .13217 Mdot
.25731 .15823 Mdot
.26121 .18623 Mdot
.26515 .21591 Mdot
.26913 .24697 Mdot
.27314 .27908 Mdot
.27718 .31188 Mdot
.28127 .34495 Mdot
.28539 .37788 Mdot
.28956 .41023 Mdot
.29375 .44155 Mdot
.29799 .47141 Mdot
.30227 .49936 Mdot
.30659 .525 Mdot
.31094 .54795 Mdot
.31534 .56785 Mdot
.31978 .58441 Mdot
.32425 .59738 Mdot
.32877 .60655 Mdot
.33333 .61181 Mdot
.33794 .61308 Mdot
.34258 .61036 Mdot
.34727 .60371 Mdot
.352 .59327 Mdot
.35677 .57921 Mdot
.36159 .56178 Mdot
.36645 .54127 Mdot
.37136 .51803 Mdot
.37631 .49242 Mdot
.38131 .46485 Mdot
.38636 .43573 Mdot
.39145 .40549 Mdot
.39658 .37457 Mdot
.40177 .34338 Mdot
.407 .31233 Mdot
.41228 .28181 Mdot
.41761 .25218 Mdot
.42299 .22376 Mdot
.42842 .19683 Mdot
.4339 .17163 Mdot
.43942 .14836 Mdot
.445 .12717 Mdot
.45063 .10818 Mdot
.45632 .09145 Mdot
.46205 .077 Mdot
.46784 .06483 Mdot
.47368 .05488 Mdot
.47957 .04707 Mdot
.48552 .04129 Mdot
.49152 .03743 Mdot
.49758 .03532 Mdot
.5037 .03482 Mdot
.50987 .03575 Mdot
.5161 .03794 Mdot
.52238 .04122 Mdot
.52872 .04541 Mdot
.53512 .05036 Mdot
.54158 .05589 Mdot
.5481 .06187 Mdot
.55468 .06816 Mdot
.56132 .07464 Mdot
.56802 .08118 Mdot
.57479 .08771 Mdot
.58161 .09413 Mdot
.5885 .10037 Mdot
.59545 .10638 Mdot
.60247 .11212 Mdot
.60955 .11754 Mdot
.61669 .12263 Mdot
.6239 .12737 Mdot
.63118 .13175 Mdot
.63852 .13577 Mdot
.64594 .13944 Mdot
.65342 .14277 Mdot
.66096 .14577 Mdot
.66858 .14846 Mdot
.67627 .15086 Mdot
.68403 .15298 Mdot
.69186 .15485 Mdot
.69976 .1565 Mdot
.70774 .15793 Mdot
.71579 .15917 Mdot
.72391 .16024 Mdot
.73211 .16117 Mdot
.74038 .16195 Mdot
.74873 .16262 Mdot
.75716 .16319 Mdot
.76566 .16367 Mdot
.77424 .16407 Mdot
.78291 .16441 Mdot
.79165 .16469 Mdot
.80047 .16493 Mdot
.80937 .16513 Mdot
.81835 .1653 Mdot
.82742 .16544 Mdot
.83657 .16557 Mdot
.84581 .16569 Mdot
.85513 .16579 Mdot
.86453 .1659 Mdot
.87402 .166 Mdot
.8836 .1661 Mdot
.89327 .16622 Mdot
.90303 .16634 Mdot
.91288 .16647 Mdot
.92281 .16662 Mdot
.93284 .16679 Mdot
.94296 .16698 Mdot
.95318 .16719 Mdot
.96348 .16743 Mdot
.97389 .1677 Mdot
.98439 .16799 Mdot
.99498 .16832 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{350, 216.188},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005N0000f2000`400?l00000o`00003oo`3ooomO
0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO
0?ooo`00HP3oool600000?H0oooo000W0?ooo`030000003oool0oooo03L0oooo2000003e0?ooo`00
9`3oool00`000000oooo0?ooo`0f0?ooo`X00000m03oool002L0oooo00<000000?ooo`3oool0=@3o
ool;00000?@0oooo000W0?ooo`030000003oool0oooo03D0oooo1@0000020?ooo`D00000l`3oool0
02L0oooo00<000000?ooo`3oool0=03oool5000000@0oooo1000003c0?ooo`009`3oool00`000000
oooo0?ooo`0d0?ooo`@000001@3oool400000?<0oooo000=0?ooo`03@000003oool0oooo0080oooo
00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo0?ooo`=0
0000103oool00`000000oooo0?ooo`0c0?ooo`D000001P3oool400000?80oooo000<0?ooo`03@000
003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000
003oool0oooo00@0oooo00<000000?ooo`3oool0<`3oool4000000L0oooo1000003b0?ooo`001`3o
ool3@0000080oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003o
oom0000000<0oooo00=000000?ooo`3oool00`3oool200000003@000003oool0oooo0300oooo1@00
00070?ooo`@00000lP3oool000`0oooo00=000000?oood0000001`3oool00d000000oooo@0000002
0?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`0b
0?ooo`@000002@3oool2000004/0oooo2000002P0?ooo`00303oool00d000000oooo@00000070?oo
o`03@000003ooom000000080oooo00=000000?oood0000000P3oool00d000000oooo@00000040?oo
o`030000003oool0oooo0380oooo100000090?ooo`@00000A`3oool<000009h0oooo000=0?ooo`03
@000003oool0oooo00L0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo00<0oooo00<000000?ooo`3oool0<@3oool4000000X0oooo100000160?ooo`h0
0000W@3oool002L0oooo00<000000?ooo`3oool0<@3oool4000000X0oooo100000160?oooa000000
V`3oool002L0oooo00<000000?ooo`3oool0<03oool5000000/0oooo0P0000150?ooo`H000001P3o
ool6000009/0oooo000W0?ooo`030000003oool0oooo0300oooo1000000<0?ooo`@00000@`3oool5
000000P0oooo1`00002I0?ooo`009`3oool00`000000oooo0?ooo`0_0?ooo`D00000303oool40000
0440oooo1P00000;0?ooo`L00000U`3oool002L0oooo00<000000?ooo`3oool0;`3oool4000000d0
oooo100000110?ooo`D000003@3oool6000009L0oooo000W0?ooo`030000003oool0oooo02l0oooo
1000000>0?ooo`800000@P3oool4000000l0oooo1`00002E0?ooo`009`3oool00`00001000000?oo
o`0^0?ooo`@00000D@3oool500000180oooo1@00002E0?ooo`009`3oool00`000000oooo0?ooo`0^
0?ooo`@000003`3oool4000003h0oooo1000000D0?ooo`H00000T`3oool002L0oooo00<000000?oo
o`3oool0;@3oool5000000l0oooo1000000n0?ooo`@000005@3oool5000009<0oooo000W0?ooo`03
0000003oool0oooo02d0oooo1000000@0?ooo`@00000?@3oool4000001L0oooo1P00002A0?ooo`00
9`3oool00`000000oooo0?ooo`0]0?ooo`@000004@3oool2000003h0oooo1000000H0?ooo`D00000
T@3oool002L0oooo00<000000?ooo`3oool0;@3oool400000540oooo1000000I0?ooo`H00000S`3o
ool002L0oooo00<000000?ooo`3oool0;@3oool400000180oooo1000000l0?ooo`8000006`3oool7
000008d0oooo000W0?ooo`030000003oool0oooo02`0oooo1@00000B0?ooo`@00000FP3oool60000
08d0oooo000W0?ooo`030000003oool0oooo02`0oooo1000000C0?ooo`@00000>@3oool4000001h0
oooo1`00002;0?ooo`009`3oool00`000000oooo0?ooo`0[0?ooo`D00000503oool2000003X0oooo
1000000P0?ooo`D00000R`3oool002L0oooo00<000000?ooo`3oool0:`3oool400000540oooo1000
000Q0?ooo`H00000R@3oool002L0oooo00<00000@000003oool0:P3oool500000580oooo0P00000S
0?ooo`D00000R@3oool002L0oooo00<000000?ooo`3oool0:P3oool4000001H0oooo1000000f0?oo
o`@000009@3oool6000008L0oooo000W0?ooo`030000003oool0oooo02T0oooo1@00000F0?ooo`@0
0000=P3oool4000002H0oooo1@0000270?ooo`009`3oool00`000000oooo0?ooo`0Y0?ooo`@00000
5`3oool4000003H0oooo1000000W0?ooo`H00000Q@3oool002L0oooo00<000000?ooo`3oool0:03o
ool5000001P0oooo0P00000h0?ooo`800000:@3oool7000008<0oooo000W0?ooo`030000003oool0
oooo02P0oooo1000001o0?ooo`H00000P`3oool002L0oooo00<000000?ooo`3oool09`3oool50000
0800oooo1`0000210?ooo`009`3oool00`000000oooo0?ooo`0V0?ooo`D00000DP3oool4000002d0
oooo1`00001o0?ooo`009`3oool00`000000oooo0?ooo`0V0?ooo`D000006P3oool4000003@0oooo
1000000^0?ooo`P00000O@3oool002L0oooo00<000000?ooo`3oool09P3oool4000000040?oood00
00100000@0000080oooo00=000000?ooo`3oool04P3oool400000180oooo0T0000040?ooo`03@000
003oool0oooo01T0oooo1000000;0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0
703oool7000000030?oood000010000000=000000P3oool00d000000oooo0?ooo`020?ooo`03@000
003oool0oooo0280oooo1D000000103ooom00000@000040000030?ooo`03@000003oool0oooo0280
oooo1D0000020?ooo`=000000P3oool00d000000oooo0?ooo`0;0?ooo`009`3oool00`0000100000
0?ooo`0U0?ooo`D000000P3oool01T000000oooo0?oood000000oooo@00001<0oooo1000000B0?oo
o`03@000003ooom000000080oooo00=000000?oood0000006`3oool2000000/0oooo00=000000?oo
od0000000P3oool00d000000oooo@000000O0?ooo`L0000000<0oooo@000003oool00P3oool00d00
0000oooo@00000020?ooo`03@000003ooom0000002D0oooo00E000000?ooo`3oool0oooo@0000004
0?ooo`03@000003ooom0000002D0oooo00=000000?ooo`3oool00`3oool01T000000oooo0?oood00
0000oooo@00000`0oooo000W0?ooo`030000003oool0oooo02@0oooo1P000004@00000040?oood00
0000oooo@00001@0oooo0P00000C0?ooo`03@000003ooom000000080oooo00=000000?oood000000
:03oool00d000000oooo@00000020?ooo`03@000003ooom000000240oooo1`0000030?ooo`03@000
003ooom000000080oooo00=000000?oood0000009@3oool00d000000oooo0?ooo`020?ooo`07@000
003oool0oooo0?oood000000oooo@000000U0?ooo`04@000003oool0oooo0?ooo`A0000000@0oooo
@000003ooom00000303oool002L0oooo00<000000?ooo`3oool0903oool5000000040?oood000000
oooo@0000080oooo00=000000?oood000000:@3oool2@00000<0oooo00=000000?oood000000:@3o
ool01d000000oooo0?ooo`3ooom000000?oood0000008P3oool;00000006@000003oool0oooo@000
003ooom000009@3oool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo
@000000U0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom00000
00`0oooo000W0?ooo`030000003oool0oooo02<0oooo1@0000030?ooo`9000000P3oool00d000000
oooo@000000Y0?ooo`03@000003oool0oooo0080oooo00=000000?oood000000603oool4000000`0
oooo00=000000?oood0000000P3oool00d000000oooo@000000S0?ooo``0000000@0oooo@000003o
oom000009@3oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000
000U0?ooo`03@000003oool0oooo0080oooo0T0000020?ooo`03@000003ooom0000000`0oooo000W
0?ooo`030000003oool0oooo0280oooo1@0000050?ooo`05@000003oool0oooo0?oood000000:`3o
ool2@00000<0oooo00=000000?ooo`3oool05`3oool4000000d0oooo00=000000?ooo`3oool00P3o
ool00d000000oooo0?ooo`0T0?ooo``0000000=000000?ooo`3oool08`3oool2@00000@0oooo00=0
00000?ooo`3oool00P3oool00d000000oooo0?ooo`0S0?ooo`9000001@3oool01D000000oooo0?oo
o`3ooom0000000d0oooo000W0?ooo`030000003oool0oooo0240oooo1P00001D0?ooo`@00000?03o
ool>000006/0oooo000W0?ooo`030000003oool0oooo0200oooo1P00000P0?ooo`@00000<P3oool2
00000440oooo4@00001T0?ooo`009`3oool00`000000oooo0?ooo`0N0?ooo`L000008@3oool40000
07L0oooo6000001K0?ooo`009`3oool00`000000oooo0?ooo`0L0?ooo`P000008P3oool4000007X0
ooooA@00000[0?ooo`009`3oool00`000000oooo0?ooo`0H0?ooo`/00000903oool2000007l0oooo
100000000`3oool000000000001B000000/0oooo0d0000050?ooo`009`3oool00`000000oooo0?oo
o`050?oooad00000E`3oool400000580oooo0P0000000`3oool000000000001=000000/0oooo00=0
00000?oood0000001@3oool002L0ooooo`00000U00000003@000003oool0oooo00X0oooo00=00000
0?ooo`3oool00`3oool002L0oooo00<000000?ooo`3oool01@3ooolI000000@0oooo00=000000?oo
o`3oool02@3oool00`000000oooo0?ooo`090?ooo`03@000003oool0oooo00T0oooo00=000000?oo
o`3oool02@3oool00d000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00=000000?oo
o`3oool02@3oool00d000000oooo00000003000000H0oooo00=000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`090?ooo`03@000003oool0oooo00X0oooo00=000000?ooo`3oool02@3oool00d00
0000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00=000000?ooo`3oool02@3oool00d00
0000oooo0?ooo`090?ooo`03@000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00d00
0000oooo0?ooo`090?ooo`80000000@0oooo000000000000oooo0P000000103oool000000000003o
ool2000000040?ooo`00000000000?ooo`80000000D0oooo000000000000oooo0000000;0?ooo`03
@000003oool0oooo00@0oooo000W0?ooo`030000003oool0oooo00H0oooo5@00000C0?ooo`03@000
003oool0oooo02h0oooo00=000000?ooo`3oool0603oool2000001<0oooo00=000000?ooo`3oool0
;P3oool00d000000oooo0?ooo`0^0?ooo`03@000003oool0oooo02d0oooo00=000000?ooo`3oool0
203oool00d000000oooo@00000050?ooo`009`3oool00`000000oooo0?ooo`170?ooo`@00000h@3o
ool3@00000D0oooo000W0?ooo`030000003oool0oooo04L0oooo1000003Y0?ooo`009`3oool00`00
0000oooo0?ooo`170?ooo`@00000j@3oool002L0oooo00<000000?ooo`3oool0B03oool2000002h0
oooo1000002h0?ooo`009`3oool00`000000oooo0?ooo`1h0?ooo`@00000^03oool002L0oooo00<0
00000?ooo`3oool0N03oool400000;P0oooo000W0?ooo`030000003oool0oooo07T0oooo0P00002i
0?ooo`009`3oool00`00001000000?ooo`3o0?ooocD0oooo000W0?ooo`030000003oool0oooo0?l0
oooo=@3oool002L0oooo00<000000?ooo`3oool0B03oool400000>P0oooo000W0?ooo`030000003o
ool0oooo04P0oooo1000003X0?ooo`009`3oool00`000000oooo0?ooo`180?ooo`@00000:P3oool4
00000;X0oooo000W0?ooo`030000003oool0oooo04T0oooo0P00000[0?ooo`@00000^P3oool002L0
oooo00<000000?ooo`3oool0MP3oool400000;X0oooo000W0?ooo`030000003oool0oooo07L0oooo
0P00002k0?ooo`009`3oool00`000000oooo0?ooo`3o0?ooocD0oooo000W0?ooo`030000003oool0
oooo0?l0oooo=@3oool002L0oooo00<000000?ooo`3oool0o`3ooole0?ooo`009`3oool00`000010
00000?ooo`190?ooo`@00000i`3oool002L0oooo00<000000?ooo`3oool0B@3oool400000>L0oooo
000W0?ooo`030000003oool0oooo04T0oooo1000000X0?ooo`@00000^`3oool002L0oooo00<00000
0?ooo`3oool0BP3oool2000002T0oooo1000002k0?ooo`009`3oool00`000000oooo0?ooo`1e0?oo
o`@00000^`3oool002L0oooo00<000000?ooo`3oool0MP3oool200000;`0oooo000W0?ooo`030000
003oool0oooo0?l0oooo=@3oool002L0oooo00<000000?ooo`3oool0o`3ooole0?ooo`009`3oool0
0`000000oooo0?ooo`3o0?ooocD0oooo000W0?ooo`030000003oool0oooo04/0oooo1000003U0?oo
o`009`3oool00`00001000000?ooo`1;0?ooo`@00000903oool400000;d0oooo000W0?ooo`030000
003oool0oooo04/0oooo1000000T0?ooo`@00000_@3oool002L0oooo00<000000?ooo`3oool0C03o
ool2000002D0oooo1000002m0?ooo`009`3oool00`000000oooo0?ooo`1d0?ooo`800000_P3oool0
02L0oooo00<000000?ooo`3oool0o`3ooole0?ooo`009`3oool00`000000oooo0?ooo`3o0?ooocD0
oooo000W0?ooo`030000003oool0oooo0?l0oooo=@3oool002L0oooo00<000000?ooo`3oool0o`3o
oole0?ooo`009`3oool00`000000oooo0?ooo`3o0?ooocD0oooo000=0?ooo`03@000003oool0oooo
0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo
0?ooo`=00000103oool00`000000oooo0?ooo`1<0?ooo`@000008P3oool400000;h0oooo000<0?oo
o`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?oo
o`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0C03oool400000280oooo1000002n0?oo
o`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood00
00000`3oool00d000000oooo0?ooo`030?ooo`80000000=000000?ooo`3oool0BP3oool400000280
oooo1000002n0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo
00=000000?oood0000000`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo04d0oooo
0P00000T0?ooo`800000_`3oool000`0oooo00=000000?oood0000001`3oool00d000000oooo@000
00020?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool00`000000oooo0?oo
o`3o0?ooocD0oooo000=0?ooo`03@000003oool0oooo00L0oooo00=000000?ooo`3oool00P3oool0
0d000000oooo0?ooo`020?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooole
0?ooo`009`3oool00`000000oooo0?ooo`3o0?ooocD0oooo000W0?ooo`030000003oool0oooo0?l0
oooo=@3oool002L0oooo00<000000?ooo`3oool0o`3ooole0?ooo`009`3oool00`000000oooo0?oo
o`1`0?ooo`@00000`03oool002L0oooo00<000000?ooo`3oool0C@3oool4000001l0oooo10000030
0?ooo`009`3oool00`000000oooo0?ooo`1=0?ooo`@000007`3oool400000<00oooo000W0?ooo`03
000004000000oooo04d0oooo1000000P0?ooo`800000`@3oool002L0oooo00<000000?ooo`3oool0
CP3oool200000>@0oooo000W0?ooo`030000003oool0oooo0?l0oooo=@3oool002L0oooo00<00000
0?ooo`3oool0o`3ooole0?ooo`009`3oool00`000000oooo0?ooo`3o0?ooocD0oooo000W0?ooo`03
0000003oool0oooo0?l0oooo=@3oool002L0oooo00<000000?ooo`3oool0K`3oool400000<40oooo
000W0?ooo`030000003oool0oooo04h0oooo1000000M0?ooo`@00000`@3oool002L0oooo00<00000
0?ooo`3oool0CP3oool4000001d0oooo100000310?ooo`009`3oool00`000000oooo0?ooo`1>0?oo
o`@000007P3oool200000<80oooo000W0?ooo`030000003oool0oooo04l0oooo0P00003S0?ooo`00
9`3oool00`00001000000?ooo`3o0?ooocD0oooo000W0?ooo`030000003oool0oooo0?l0oooo=@3o
ool002L0oooo00<000000?ooo`3oool0o`3ooole0?ooo`009`3oool00`000000oooo0?ooo`3o0?oo
ocD0oooo000W0?ooo`030000003oool0oooo06d0oooo100000330?ooo`009`3oool00`000000oooo
0?ooo`1]0?ooo`@00000``3oool002L0oooo00<000000?ooo`3oool0C`3oool4000001X0oooo1000
00330?ooo`009`3oool00`000000oooo0?ooo`1?0?ooo`@000006`3oool200000<@0oooo000W0?oo
o`030000003oool0oooo04l0oooo1000003Q0?ooo`009`3oool00`000000oooo0?ooo`1@0?ooo`80
0000hP3oool002L0oooo00<00000@000003oool0o`3ooole0?ooo`009`3oool00`000000oooo0?oo
o`3o0?ooocD0oooo000W0?ooo`030000003oool0oooo0?l0oooo=@3oool002L0oooo00<000000?oo
o`3oool0K03oool400000<@0oooo000W0?ooo`030000003oool0oooo06`0oooo100000340?ooo`00
9`3oool00`000000oooo0?ooo`1A0?ooo`@000005`3oool400000<@0oooo000W0?ooo`030000003o
ool0oooo0540oooo1000000H0?ooo`800000a@3oool002L0oooo00<000000?ooo`3oool0D@3oool4
00000=l0oooo000W0?ooo`030000003oool0oooo0580oooo0P00003P0?ooo`003@3oool00d000000
oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000
oooo0?ooo`020?ooo`=000000`3oool00`000000oooo0?ooo`3o0?ooocD0oooo000<0?ooo`03@000
003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000040?ooo`03@000
003oool0oooo0080oooo00<000000?ooo`3oool0o`3ooole0?ooo`00303oool00d000000oooo@000
00070?ooo`03@000003ooom000000080oooo00=000000?oood0000000P3oool4@00000<0oooo0P00
00000d000000oooo0?ooo`3o0?oooc<0oooo000<0?ooo`03@000003ooom0000000L0oooo00=00000
0?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003ooom0000000@0oooo00<00000
0?ooo`3oool0JP3oool400000<H0oooo000<0?ooo`03@000003ooom0000000L0oooo00=000000?oo
od0000000P3oool00d000000oooo@00000030?ooo`900000103oool00`000000oooo0?ooo`1Z0?oo
o`@00000aP3oool000d0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo00<0oooo00=000000?ooo`3oool00P3oool00`000000oooo0?ooo`1B0?ooo`@0
0000503oool400000<H0oooo000W0?ooo`030000003oool0oooo0580oooo1000000E0?ooo`800000
a`3oool002L0oooo00<000000?ooo`3oool0DP3oool400000=h0oooo000W0?ooo`030000003oool0
oooo05<0oooo0P00003O0?ooo`009`3oool00`000000oooo0?ooo`3o0?ooocD0oooo000W0?ooo`03
0000003oool0oooo0?l0oooo=@3oool002L0oooo00<000000?ooo`3oool0J@3oool400000<L0oooo
000W0?ooo`03000004000000oooo06T0oooo100000370?ooo`009`3oool00`000000oooo0?ooo`1C
0?ooo`@000004P3oool400000<L0oooo000W0?ooo`030000003oool0oooo05<0oooo1000000C0?oo
o`800000b03oool002L0oooo00<000000?ooo`3oool0D`3oool400000=d0oooo000W0?ooo`030000
003oool0oooo05@0oooo0P00003N0?ooo`009`3oool00`000000oooo0?ooo`3o0?ooocD0oooo000W
0?ooo`030000003oool0oooo06L0oooo100000390?ooo`009`3oool00`000000oooo0?ooo`1W0?oo
o`@00000b@3oool002L0oooo00<000000?ooo`3oool0E03oool4000000l0oooo100000390?ooo`00
9`3oool00`000000oooo0?ooo`1D0?ooo`@00000403oool200000<X0oooo000W0?ooo`030000003o
ool0oooo05@0oooo1000003L0?ooo`009`3oool00`00001000000?ooo`1E0?ooo`800000g@3oool0
02L0oooo00<000000?ooo`3oool0o`3ooole0?ooo`009`3oool00`000000oooo0?ooo`1V0?ooo`@0
0000bP3oool002L0oooo00<000000?ooo`3oool0IP3oool400000<X0oooo000W0?ooo`030000003o
ool0oooo05H0oooo1000000<0?ooo`@00000bP3oool002L0oooo00<000000?ooo`3oool0EP3oool4
000000d0oooo0P00003;0?ooo`009`3oool00`000000oooo0?ooo`1F0?ooo`@00000fP3oool002L0
oooo00<000000?ooo`3oool0E`3oool200000=/0oooo000W0?ooo`030000003oool0oooo06@0oooo
1000003<0?ooo`009`3oool00`000000oooo0?ooo`1T0?ooo`@00000c03oool002L0oooo00<00000
@000003oool0E`3oool4000000T0oooo1000003<0?ooo`009`3oool00`000000oooo0?ooo`1G0?oo
o`@000002P3oool200000<d0oooo000W0?ooo`030000003oool0oooo05L0oooo1000003I0?ooo`00
9`3oool00`000000oooo0?ooo`1H0?ooo`8000002@3oool400000<d0oooo000W0?ooo`030000003o
ool0oooo06<0oooo1000003=0?ooo`009`3oool00`000000oooo0?ooo`1H0?ooo`@000001`3oool4
00000<d0oooo000W0?ooo`030000003oool0oooo05P0oooo100000080?ooo`800000cP3oool002L0
oooo00<000000?ooo`3oool0F03oool4000000H0oooo1000003>0?ooo`009`3oool00`000000oooo
0?ooo`1I0?ooo`@000001@3oool400000<h0oooo000=0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo0?ooo`900000
1@3oool00`000000oooo0?ooo`1I0?ooo`@000001@3oool400000<h0oooo000<0?ooo`03@000003o
oom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003o
oom0000000@0oooo00<000000?ooo`3oool0F@3oool4000000<0oooo1@00003?0?ooo`00303oool0
0d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood0000000P3oool0
0d000000oooo@00000040?ooo`80000000=000000?ooo`3oool0F03oool5000000030?ooo`000000
000000800000d03oool000`0oooo00=000000?oood0000001`3oool00d000000oooo@00000020?oo
o`03@000003ooom000000080oooo0T0000050?ooo`030000003oool0oooo05/0oooo2@00003@0?oo
o`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood00
00000P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo05/0oooo2000003A0?ooo`00
3@3oool00d000000oooo0?ooo`070?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0
0P3oool2@00000@0oooo00<000000?ooo`3oool0G03oool700000=40oooo000W0?ooo`03@000003o
ool0oooo05`0oooo1P00003B0?ooo`00Q`3oool300000=@0oooo003o0?oooel0oooo003o0?oooel0
oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0
oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo000J0?ooo`90
000000L0oooo@0000400001000000?oood000000oooo00=0000000<0oooo@000040000000T000000
103ooom00000@000003oool2@0000?l0oooo;P3oool001T0oooo00=000000?ooo`3oool00P3oool0
14000000oooo0?oood0000020?ooo`05@000003oool0oooo0?oood0000000P3oool2@00000<0oooo
00=000000?ooo`3oool0o`3oool/0?ooo`006@3oool00d000000oooo0?ooo`020?ooo`04@000003o
ool0oooo@0000080oooo00E000000?ooo`3oool0oooo@00000020?ooo`03@000003ooom000000090
0000o`3oool_0?ooo`006@3oool00d000000oooo0?ooo`020?ooo`A0000000@0oooo@000003ooom0
00000P3oool3@0000080oooo00=000000?oood000000o`3oool_0?ooo`006@3oool00d000000oooo
@00000020?ooo`03@000003oool0oooo009000000`3oool00d000000oooo@00000020?ooo`04@000
003oool0oooo@0000?l0oooo<03oool001T0oooo0d0000001@3ooom00000@00004000000oooo00=0
000000<0oooo@00004000000140000020?ooo`900000o`3oool`0?ooo`00o`3ooomO0?ooo`00o`3o
oomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3o
oomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 349}, {215.188, 0}} -> {3.70719, -0.00269527, 
  0.410895, 4.7647*^-05}}],

Cell[OutputFormData["\<\
Graphics[{PointSize[0.02], RGBColor[0., 0., 0], 
   {Point[{23.99999999999999, 6.191991400335671*^-9}], 
    Point[{24.2209203663876, -5.521979340383591*^-9}], 
    Point[{24.44387430812041, 
      -1.744003287478214*^-8}], 
    Point[{24.66888054429051, 
      -3.050017974464707*^-8}], 
    Point[{24.89595796629954, 
      -4.569207221212183*^-8}], 
    Point[{25.12512563944476, 
      -6.412159685962235*^-8}], 
    Point[{25.35640280451979, 
      -8.707921565759415*^-8}], 
    Point[{25.58980887943006, 
      -1.161154548465542*^-7}], 
    Point[{25.82536346082308, -1.53126959211582*^-7}], 
    Point[{26.06308632573383, 
      -2.004567492805827*^-7}], 
    Point[{26.30299743324521, 
      -2.610125309548409*^-7}], 
    Point[{26.54511692616374, 
      -3.384071858498457*^-7}], 
    Point[{26.78946513271082, 
      -4.371260515932025*^-7}], 
    Point[{27.03606256822943, 
      -5.627259141106005*^-7}], 
    Point[{27.28492993690657, 
      -7.220712424746627*^-7}], 
    Point[{27.53608813351164, 
      -9.236134683147994*^-7}], 
    Point[{27.78955824515067, 
      -1.177719723040915*^-6}], 
    Point[{28.04536155303686, 
      -1.497057696720216*^-6}], 
    Point[{28.30351953427726, 
      -1.897043579960565*^-6}], 
    Point[{28.56405386367606, 
      -2.396360171458745*^-6}], 
    Point[{28.82698641555434, 
      -3.017552123847206*^-6}], 
    Point[{29.09233926558663, 
      -3.787704897765587*^-6}], 
    Point[{29.36013469265437, 
      -4.739213241238326*^-6}], 
    Point[{29.63039518071648, 
      -5.910643887122367*^-6}], 
    Point[{29.90314342069704, 
      -7.347695382488658*^-6}], 
    Point[{30.17840231239044, 
      -9.104255660902252*^-6}], 
    Point[{30.45619496638402, 
      -0.00001124355490490259}], 
    Point[{30.73654470599843, 
      -0.00001383940742351008}], 
    Point[{31.01947506924586, 
      -0.0000169775314267188}], 
    Point[{31.30500981080623, 
      -0.00002075693005429428}], 
    Point[{31.5931729040217, 
      -0.00002529131010229903}], 
    Point[{31.88398854290934, 
      -0.00003071050735583197}], 
    Point[{32.17748114419258, 
      -0.00003716187871012153}], 
    Point[{32.47367534935114, 
      -0.00004481161160131063}], 
    Point[{32.77259602668991, 
      -0.00005384589109405602}], 
    Point[{33.07426827342697, 
      -0.00006447185394888819}], 
    Point[{33.37871741780062, 
      -0.00007691824804085594}], 
    Point[{33.68596902119599, 
      -0.00009143570439844822}], 
    Point[{33.99604888029116, 
      -0.0001082965189255122}], 
    Point[{34.30898302922303, -0.000127793831641108}], 
    Point[{34.62479774177312, 
      -0.0001502400840616687}], 
    Point[{34.9435195335735, -0.000175964630552104}], 
    Point[{35.26517516433307, -0.000205310378355218}], 
    Point[{35.58979164008422, 
      -0.0002386293338064499}], 
    Point[{35.9173962154503, -0.0002762769405162246}], 
    Point[{36.24801639593388, 
      -0.0003186051091701877}], 
    Point[{36.58167994022613, 
      -0.0003659538595833533}], 
    Point[{36.91841486253733, 
      -0.0004186415236332729}], 
    Point[{37.25824943494905, 
      -0.0004769534937935603}], 
    Point[{37.60121218978779, 
      -0.0005411295459967101}], 
    Point[{37.94733192202054, 
      -0.0006113498176190233}], 
    Point[{38.29663769167241, 
      -0.0006877195808361316}], 
    Point[{38.64915882626649, -0.000770253017955266}], 
    Point[{39.00492492328613, 
      -0.0008588562767107063}], 
    Point[{39.36396585266003, 
      -0.0009533101586536602}], 
    Point[{39.72631175926998, -0.00105325286991725}], 
    Point[{40.09199306548191, -0.001158163338365721}], 
    Point[{40.46104047370006, -0.001267345670684705}], 
    Point[{40.83348496894479, -0.001379915384493879}], 
    Point[{41.20935782145404, -0.001494788099134121}], 
    Point[{41.58869058930878, -0.001610671401552014}], 
    Point[{41.97151512108256, -0.001726060615554955}], 
    Point[{42.35786355851559, -0.001839239190895181}], 
    Point[{42.74776833921324, -0.001948284388963168}], 
    Point[{43.14126219936954, -0.00205107887243737}], 
    Point[{43.53837817651573, -0.002145328704666105}], 
    Point[{43.93914961229397, -0.00222858813078422}], 
    Point[{44.34361015525681, -0.002298291346623723}], 
    Point[{44.75179376369217, -0.002351791266226255}], 
    Point[{45.16373470847456, -0.002386405077094255}], 
    Point[{45.57946757594242, -0.002399466130265814}], 
    Point[{45.99902727080197, -0.002388381456192634}], 
    Point[{46.42244901905778, -0.002350693935841974}], 
    Point[{46.84976837097028, -0.002284147898839128}], 
    Point[{47.28102120404066, -0.002186756677587331}], 
    Point[{47.71624372602303, -0.002056870428627011}], 
    Point[{48.15547247796442, -0.001893242352261181}], 
    Point[{48.59874433727276, -0.001695091308128671}], 
    Point[{49.04609652081309, -0.001462158749412134}], 
    Point[{49.49756658803226, -0.001194757888509423}], 
    Point[{49.95319244411239, 
      -0.0008938130701841018}], 
    Point[{50.41301234315338, 
      -0.0005608874673773689}], 
    Point[{50.87706489138473, 
      -0.0001981974313449708}], 
    Point[{51.34538905040684, 0.0001913878802576318}], 
    Point[{51.81802414046225, 0.0006043626124357937}], 
    Point[{52.29500984373696, 0.001036616651547417}], 
    Point[{52.77638620769204, 0.001483484515107935}], 
    Point[{53.26219364842608, 0.001939810308934974}], 
    Point[{53.75247295406849, 0.002400027846084507}], 
    Point[{54.24726528820403, 0.002858254502734913}], 
    Point[{54.74661219332885, 0.003308396889023512}], 
    Point[{55.25055559433845, 0.003744265958499415}], 
    Point[{55.75913780204762, 0.004159698786958543}], 
    Point[{56.27240151674284, 0.00454868393844876}], 
    Point[{56.7903898317674, 0.004905487117096818}], 
    Point[{57.31314623713943, 0.005224773691194783}], 
    Point[{57.84071462320341, 0.005501724676808983}], 
    Point[{58.37313928431504, 0.005732142886659019}], 
    Point[{58.91046492256028, 0.005912546183235889}], 
    Point[{59.45273665150844, 0.00604024511828527}], 
    Point[{60, 0.006113402680816726}], 
    Point[{60.55230091596901, 0.006131074399488234}], 
    Point[{61.10968577030102, 0.006093227632614883}], 
    Point[{61.67220136072629, 0.006000739508494667}], 
    Point[{62.23989491574887, 0.005855373627575488}], 
    Point[{62.81281409861192, 0.005659736281029559}], 
    Point[{63.39100701129952, 0.005417213554413713}], 
    Point[{63.97452219857517, 0.005131891246850095}], 
    Point[{64.56340865205771, 0.004808460026162642}], 
    Point[{65.1577158143346, 0.004452108640279561}], 
    Point[{65.75749358311303, 0.0040684083033522}], 
    Point[{66.36279231540936, 0.003663191561319223}], 
    Point[{66.97366283177707, 0.003242429012194847}], 
    Point[{67.59015642057358, 0.002812107213506109}], 
    Point[{68.21232484226643, 0.002378110954973422}], 
    Point[{68.84022033377911, 0.001946112822233558}], 
    Point[{69.47389561287669, 0.00152147263690594}], 
    Point[{70.11340388259215, 0.00110914894848868}], 
    Point[{70.75879883569316, 0.0007136242894070221}], 
    Point[{71.41013465919018, 0.0003388454097681403}], 
    Point[{72.06746603888587, 
      -0.00001182080187334122}], 
    Point[{72.73084816396658, 
      -0.0003356155083267253}], 
    Point[{73.40033673163594, 
      -0.0006304005002046864}], 
    Point[{74.07598795179123, -0.000894655875255168}], 
    Point[{74.75785855174263, -0.001127463923632276}], 
    Point[{75.44600578097612, -0.001328480645664598}], 
    Point[{76.14048741596006, -0.001497896582851154}], 
    Point[{76.84136176499611, -0.001636388822088719}], 
    Point[{77.54868767311466, -0.001745066137864625}], 
    Point[{78.26252452701561, -0.001825409270420408}], 
    Point[{78.98293226005423, -0.001879208303229518}], 
    Point[{79.70997135727335, -0.00190849900798895}], 
    Point[{80.44370286048145, -0.001915499880809079}], 
    Point[{81.18418837337783, -0.001902551404679542}], 
    Point[{81.93149006672481, -0.001872058856882574}], 
    Point[{82.68567068356743, -0.001826439741911656}], 
    Point[{83.44679354450155, -0.001768076683514863}], 
    Point[{84.21492255298998, -0.0016992763631265}], 
    Point[{84.9901222007279, -0.001622234853165593}], 
    Point[{85.7724575730576, -0.001539009473091823}], 
    Point[{86.5619943544328, -0.001451497095203535}], 
    Point[{87.35879883393378, -0.001361418653647916}], 
    Point[{88.16293791083269, -0.001270309466995911}], 
    Point[{88.97447910021055, -0.001179514868642428}], 
    Point[{89.79349053862577, -0.001090190557462733}], 
    Point[{90.62004098983473, -0.001003307026547162}], 
    Point[{91.45419985056532, -0.000919657400210383}], 
    Point[{92.29603715634334, 
      -0.0008398680086258991}], 
    Point[{93.14562358737266, 
      -0.0007644110467524001}], 
    Point[{94.0030304744695, -0.0006936187011845618}], 
    Point[{94.86832980505138, 
      -0.0006276981789881119}], 
    Point[{95.74159422918105, -0.000566747131479417}], 
    Point[{96.62289706566623, 
      -0.0005107690333119307}], 
    Point[{97.51231230821534, 
      -0.0004596881462717306}], 
    Point[{98.40991463165009, 
      -0.0004133637678975787}], 
    Point[{99.31577939817497, -0.00037160353182486}], 
    Point[{100.2299826637047, 
      -0.0003341755921795197}], 
    Point[{101.1526011842501, 
      -0.0003008195813549718}], 
    Point[{102.083712422362, -0.0002712562841367116}], 
    Point[{103.0233945536351, 
      -0.0002451960140419373}], 
    Point[{103.9717264732719, 
      -0.0002223457167502829}], 
    Point[{104.9287878027064, 
      -0.0002024148552877136}], 
    Point[{105.8946588962889, 
      -0.0001851201538372038}], 
    Point[{106.8694208480331, 
      -0.0001701892948204886}], 
    Point[{107.8531554984238, 
      -0.0001573636738854133}], 
    Point[{108.8459454412893, 
      -0.0001464003233948574}], 
    Point[{109.8478740307349, 
      -0.0001370731157521731}], 
    Point[{110.859025388142, -0.0001291733565054187}], 
    Point[{111.8794844092304, 
      -0.0001225098710406768}], 
    Point[{112.9093367711864, 
      -0.0001169086827772503}], 
    Point[{113.948668939856, -0.0001122123706380762}], 
    Point[{114.9975681770049, 
      -0.0001082791859161602}], 
    Point[{116.0561225476444, 
      -0.0001049819975094123}], 
    Point[{117.1244209274257, 
      -0.0001022071252450018}], 
    Point[{118.2025530101016, 
      -0.00009985311155702447}], 
    Point[{119.2906093150576, 
      -0.00009782947316239187}], 
    Point[{120.388681194911, 
      -0.00009605546532043263}], 
    Point[{121.4968608431819, 
      -0.00009445888489523213}], 
    Point[{122.6152413020327, 
      -0.00009297493173932025}], 
    Point[{123.7439164700806, 
      -0.00009154514185638618}], 
    Point[{124.8829811102809, 
      -0.00009011640158007594}], 
    Point[{126.0325308578834, 
      -0.00008864004819031379}], 
    Point[{127.1926622284618, 
      -0.0000870710588287693}], 
    Point[{128.3634726260171, 
      -0.00008536732730135554}], 
    Point[{129.5450603511556, 
      -0.00008348902690613613}], 
    Point[{130.7375246093424, 
      -0.00008139805463258653}], 
    Point[{131.9409655192301, 
      -0.00007905755352055621}], 
    Point[{133.1554841210652, 
      -0.00007643150667036024}], 
    Point[{134.3811823851712, 
      -0.00007348439794441219}], 
    Point[{135.6181632205101, 
      -0.00007018093309341111}], 
    Point[{136.8665304833221, 
      -0.00006648581648960316}], 
    Point[{138.1263889858461, 
      -0.0000623635769301245}], 
    Point[{139.397844505119, 
      -0.00005777843732346354}], 
    Point[{140.6810037918571, 
      -0.00005269422300102633}], 
    Point[{141.9759745794185, 
      -0.00004707430471739826}], 
    Point[{143.2828655928486, 
      -0.00004088156929071828}], 
    Point[{144.6017865580085, 
      -0.0000340784159220675}], 
    Point[{145.9328482107876, 
      -0.00002662677187004192}], 
    Point[{147.2761623064006, 
      -0.00001848812416938017}], 
    Point[{148.6318416287711, 
      -9.623563002492119*^-6}], 
    Point[{150., 6.1686620256296*^-9}]}}, 
  {DisplayFunction -> (Display[$Display, #1] & ), 
   AxesLabel -> {\"S\", \"CHYBA\"}, 
   PlotRange -> 
    {{20, 140}, {-0.002399999999999999, 0.0062}}, 
   PlotRange -> Automatic, 
   AspectRatio -> GoldenRatio^(-1), 
   DisplayFunction :> Identity, 
   ColorOutput -> Automatic, Axes -> Automatic, 
   AxesOrigin -> Automatic, PlotLabel -> None, 
   AxesLabel -> None, Ticks -> Automatic, 
   GridLines -> None, Prolog -> {}, Epilog -> {}, 
   AxesStyle -> Automatic, Background -> Automatic, 
   DefaultColor -> Automatic, 
   DefaultFont :> $DefaultFont, RotateLabel -> True, 
   Frame -> False, FrameStyle -> Automatic, 
   FrameTicks -> Automatic, FrameLabel -> None, 
   PlotRegion -> Automatic, ImageSize -> Automatic, 
   TextStyle :> $TextStyle, FormatType :> $FormatType}]\
\>", "\<\
-Graphics-\
\>"], "Output"]
}, Open  ]],

Cell["\"MAXIMOVA CHYBA\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
Print[\"m = \",m,\" n = \",n,\" trans = \",trans,\" Max.chyba \
\",Max[Table[Abs[Err[i,str]],{i,2m+1}]]]\
\>", "Input"],

Cell["\<\
m = 20 n = 10 trans = 0. Max.chyba 0.0863671
m = 21 n = 10 trans = 0. Max.chyba 0.0824772
m = 22 n = 10 trans = 0. Max.chyba 0.0791189
m = 30 n = 10 trans = 0. Max.chyba 0.0633563
m = 50 n = 10 trans = 0. Max.chyba 0.0517769
m = 80 n = 10 trans = 0. Max.chyba 0.0479556
m = 100 n = 10 trans = 0. Max.chyba 0.0470884
m = 20 n = 11 trans = 0. Max.chyba 0.0821072
m = 20 n = 12 trans = 0. Max.chyba 0.0785549
m = 20 n = 20 trans = 0. Max.chyba 0.0628988
m = 20 n = 30 trans = 0. Max.chyba 0.055055
m = 20 n = 50 trans = 0. Max.chyba 0.0487726
m = 20 n = 80 trans = 0. Max.chyba 0.0452359
m = 20 n = 100 trans = 0. Max.chyba 0.0440565
m = 30 n = 20 trans = 0. Max.chyba 0.0404042
m = 50 n = 30 trans = 0. Max.chyba 0.021461
m = 80 n = 50 trans = 0. Max.chyba 0.0115778
m = 100 n = 80 trans = 0. Max.chyba 0.00727563
m = 100 n = 100 trans = 0. Max.chyba 0.00613107
m = 20 n = 10 trans = 0.02 Max.chyba 0.227695
m = 21 n = 10 trans = 0.02 Max.chyba 0.219509
m = 22 n = 10 trans = 0.02 Max.chyba 0.212421
m = 30 n = 10 trans = 0.02 Max.chyba 0.179068
m = 50 n = 10 trans = 0.02 Max.chyba 0.154724
m = 80 n = 10 trans = 0.02 Max.chyba 0.146524
m = 100 n = 10 trans = 0.02 Max.chyba 0.144644
m = 20 n = 11 trans = 0.02 Max.chyba 0.212137
m = 20 n = 12 trans = 0.02 Max.chyba 0.199211
m = 20 n = 20 trans = 0.02 Max.chyba 0.143511
m = 20 n = 30 trans = 0.02 Max.chyba 0.11694
m = 20 n = 50 trans = 0.02 Max.chyba 0.096547
m = 20 n = 80 trans = 0.02 Max.chyba 0.0854395
m = 20 n = 100 trans = 0.02 Max.chyba 0.0817948
m = 30 n = 20 trans = 0.02 Max.chyba 0.0989654
m = 50 n = 30 trans = 0.02 Max.chyba 0.0543297
m = 80 n = 50 trans = 0.02 Max.chyba 0.0298159
m = 100 n = 80 trans = 0.02 Max.chyba 0.0185522
m = 100 n = 100 trans = 0.02 Max.chyba 0.0153285
m = 150 n = 150 trans = 0.02 Max.chyba 0.00960596
m = 100 n = 80 trans = 0.005 Max.chyba 0.00895986
m = 100 n = 80 trans = 0.01 Max.chyba 0.0111167
m = 100 n = 80 trans = 0.015 Max.chyba 0.0140568
m = 100 n = 80 trans = 0.025 Max.chyba 0.0273179
m = 100 n = 80 trans = 0.03 Max.chyba 0.0740006\
\>", "Print",
  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]],

Cell["\<\
\"Porovnanie explicitn\[EAcute]ho rie\.9aenia s pribliznym \
rie\.9aen\[IAcute]m
 euro.call opcie bez trans. nakladov.\"\
\>", "Text"],

Cell[CellGroupData[{

Cell["\<\
Table[{xs[[i]],Max[xs[[i]]-X,0],EuropeanCallDiv[xs[[i]],X,sigma,r,DD,t],ys[[i]\
]},{i,1,2m+1,5}]\
\>", "Input"],

Cell[OutputFormData["\<\
{{23.99999999999999, 0, 6.191991400335671*^-9, 0}, 
  {25.12512563944476, 0, 3.454542099247703*^-8, 
   9.866701785209938*^-8}, 
  {26.30299743324521, 0, 1.781327934502698*^-7, 
   4.391453244051107*^-7}, 
  {27.53608813351164, 0, 8.493026952896858*^-7, 
   1.772916163604485*^-6}, 
  {28.82698641555434, 0, 3.745765162687129*^-6, 
   6.763317286534336*^-6}, 
  {30.17840231239044, 0, 0.00001528966099971778, 
   0.00002439391666062003}, 
  {31.5931729040217, 0, 0.00005779418848964783, 
   0.00008308549859194686}, 
  {33.07426827342697, 0, 0.0002024343069124464, 
   0.0002669061608613346}, 
  {34.62479774177312, 0, 0.000657541437874099, 
   0.0008077815219357679}, 
  {36.24801639593388, 0, 0.001982323057934054, 
   0.002300928167104242}, 
  {37.94733192202054, 0, 0.005552227644426852, 
   0.006163577462045876}, 
  {39.72631175926998, 0, 0.01446426788837445, 
   0.01551752075829171}, 
  {41.58869058930878, 0, 0.035094054924241, 
   0.03670472632579302}, 
  {43.53837817651573, 0, 0.07942175033671805, 
   0.08156707904138416}, 
  {45.57946757594242, 0, 0.1679494388739501, 
   0.170348905004216}, {47.71624372602303, 0, 
   0.3325324292485118, 0.3345892996771389}, 
  {49.95319244411239, 0, 0.6179074205618571, 
   0.6188012336320412}, 
  {52.29500984373696, 0, 1.080472758383885, 
   1.079436141732338}, {54.74661219332885, 0, 
   1.783339575804955, 1.780031178915931}, 
  {57.31314623713943, 0, 2.787928962527619, 
   2.782704188836424}, {60, 0, 4.144017931369464, 
   4.137904528688648}, {62.81281409861192, 
   2.81281409861193, 5.881282330377274, 
   5.875622594096244}, {65.75749358311303, 
   5.757493583113031, 8.005257548147397, 
   8.001189139844045}, {68.84022033377911, 
   8.840220333779114, 10.49910370468885, 
   10.49715759186662}, {72.06746603888587, 
   12.06746603888588, 13.33034310923559, 
   13.33035493003746}, {75.44600578097612, 
   15.44600578097612, 16.45998905181374, 
   16.4613175324594}, {78.98293226005423, 
   18.98293226005424, 19.85104140700063, 
   19.85292061530386}, {82.68567068356743, 
   22.68567068356743, 23.47420337090998, 
   23.47602981065189}, {86.5619943544328, 
   26.56199435443281, 27.31018427842532, 
   27.31163577552052}, {90.62004098983473, 
   30.62004098983473, 31.34924771691237, 
   31.35025102393892}, {94.86832980505138, 
   34.86832980505139, 35.58925449579836, 
   35.58988219397735}, {99.31577939817497, 
   39.31577939817498, 40.03335685622298, 
   40.03372845975481}, {103.9717264732719, 
   43.97172647327197, 44.68805167323233, 
   44.68827401894907}, {108.8459454412893, 
   48.84594544128935, 49.5618372412107, 49.5619836415341}\\
, {113.948668939856, 53.94866893985609, 
   54.66442205144831, 54.66453426381894}, 
  {119.2906093150576, 59.29060931505762, 
   60.00632141106669, 60.00641924053986}, 
  {124.8829811102809, 64.88298111028098, 
   65.59868200041971, 65.59877211682129}, 
  {130.7375246093424, 70.73752460934241, 
   71.45322267211118, 71.45330407016581}, 
  {136.8665304833221, 76.86653048332215, 
   77.58222788747572, 77.58229437329221}, 
  {143.2828655928486, 83.28286559284862, 
   83.99856285539652, 83.99860373696581}, 
  {150., 90.00000000000003, 90.71569723445284, 
   90.71569722828417}}\
\>", "\<\
                    -9
{{24., 0, 6.19199 10  , 0}, 
 
                         -8           -8
  {25.1251, 0, 3.45454 10  , 9.8667 10  }, 
 
                        -7            -7
  {26.303, 0, 1.78133 10  , 4.39145 10  }, 
 
                         -7            -6
  {27.5361, 0, 8.49303 10  , 1.77292 10  }, 
 
                        -6            -6
  {28.827, 0, 3.74577 10  , 6.76332 10  }, 
 
  {30.1784, 0, 0.0000152897, 0.0000243939}, 
 
  {31.5932, 0, 0.0000577942, 0.0000830855}, 
 
  {33.0743, 0, 0.000202434, 0.000266906}, 
 
  {34.6248, 0, 0.000657541, 0.000807782}, 
 
  {36.248, 0, 0.00198232, 0.00230093}, 
 
  {37.9473, 0, 0.00555223, 0.00616358}, 
 
  {39.7263, 0, 0.0144643, 0.0155175}, 
 
  {41.5887, 0, 0.0350941, 0.0367047}, 
 
  {43.5384, 0, 0.0794218, 0.0815671}, 
 
  {45.5795, 0, 0.167949, 0.170349}, 
 
  {47.7162, 0, 0.332532, 0.334589}, 
 
  {49.9532, 0, 0.617907, 0.618801}, 
 
  {52.295, 0, 1.08047, 1.07944}, 
 
  {54.7466, 0, 1.78334, 1.78003}, 
 
  {57.3131, 0, 2.78793, 2.7827}, 
 
  {60, 0, 4.14402, 4.1379}, 
 
  {62.8128, 2.81281, 5.88128, 5.87562}, 
 
  {65.7575, 5.75749, 8.00526, 8.00119}, 
 
  {68.8402, 8.84022, 10.4991, 10.4972}, 
 
  {72.0675, 12.0675, 13.3303, 13.3304}, 
 
  {75.446, 15.446, 16.46, 16.4613}, 
 
  {78.9829, 18.9829, 19.851, 19.8529}, 
 
  {82.6857, 22.6857, 23.4742, 23.476}, 
 
  {86.562, 26.562, 27.3102, 27.3116}, 
 
  {90.62, 30.62, 31.3492, 31.3503}, 
 
  {94.8683, 34.8683, 35.5893, 35.5899}, 
 
  {99.3158, 39.3158, 40.0334, 40.0337}, 
 
  {103.972, 43.9717, 44.6881, 44.6883}, 
 
  {108.846, 48.8459, 49.5618, 49.562}, 
 
  {113.949, 53.9487, 54.6644, 54.6645}, 
 
  {119.291, 59.2906, 60.0063, 60.0064}, 
 
  {124.883, 64.883, 65.5987, 65.5988}, 
 
  {130.738, 70.7375, 71.4532, 71.4533}, 
 
  {136.867, 76.8665, 77.5822, 77.5823}, 
 
  {143.283, 83.2829, 83.9986, 83.9986}, 
 
  {150., 90., 90.7157, 90.7157}}\
\>"], "Output"]
}, Open  ]],

Cell[TextData[
"\"Porovnanie ceny eur\[OAcute]pskej call opcie s \
transak\[CHacek]n\[YAcute]mi n\[AAcute]kladmi c_{t} a bez transak\[CHacek]n\
\[YAcute]ch n\[AAcute]kladov c pre r\[OHat]znu cenu S podkladaj\[UAcute]ceho \
akt\[IAcute]va. Volatilita opcie sigma = 0.29, expira\[EGrave]n\[AAcute] cena \
X=60, Cas do expir\[AAcute]cie t=0.3 a transak\[EGrave]n\[EAcute] \
n\[AAcute]klady \nf=0.02\""], "Text"],

Cell[CellGroupData[{

Cell["\<\
Table[{i,EuropeanCallDiv[i,X,sigma,r,DD,t],EuropeanCallDiv[i,X,str,r,DD,t]},{\
i,50,70,5}]\
\>", "Input"],

Cell[OutputFormData["\<\
{{50, 0.6253812017827691, 0.07913624205524882}, 
  {55, 1.869967892232736, 0.6789277461260248}, 
  {60, 4.144017931369464, 2.656895546609288}, 
  {65, 7.432168686009056, 6.25065402626646}, 
  {70, 11.4944896180926, 10.81999632010551}}\
\>", "\<\
{{50, 0.625381, 0.0791362}, {55, 1.86997, 0.678928}, 
 
  {60, 4.14402, 2.6569}, {65, 7.43217, 6.25065}, 
 
  {70, 11.4945, 10.82}}\
\>"], "Output"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{445, 414},
WindowMargins->{{13, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 101, 3, 48, "Input"],
Cell[1813, 54, 1244, 51, 1002, "Input"],
Cell[3060, 107, 44, 0, 33, "Text"],
Cell[3107, 109, 111, 11, 192, "Input"],
Cell[3221, 122, 47, 0, 33, "Text"],
Cell[3271, 124, 73, 0, 48, "Input"],
Cell[3347, 126, 56, 0, 30, "Input"],
Cell[3406, 128, 149, 3, 33, "Text"],
Cell[3558, 133, 176, 4, 84, "Input"],
Cell[3737, 139, 69, 0, 33, "Text"],
Cell[3809, 141, 110, 3, 48, "Input"],
Cell[3922, 146, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[3971, 150, 405, 10, 210, "Input"],
Cell[4379, 162, 24793, 727, 240, 6216, 493, "GraphicsData", 
"PostScript", "Graphics"],
Cell[29175, 891, 17291, 337, 28, "Output"]
}, Open  ]],
Cell[46481, 1231, 143, 2, 52, "Text"],
Cell[46627, 1235, 128, 3, 66, "Input"],
Cell[46758, 1240, 72, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[46855, 1244, 229, 6, 102, "Input"],
Cell[47087, 1252, 26088, 683, 225, 8124, 457, "GraphicsData", 
"PostScript", "Graphics"],
Cell[73178, 1937, 12905, 323, 28, "Output"]
}, Open  ]],
Cell[86098, 2263, 34, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[86157, 2267, 129, 3, 48, "Input"],
Cell[86289, 2272, 2115, 47, 756, "Print"]
}, Open  ]],
Cell[88419, 2322, 144, 4, 52, "Text"],

Cell[CellGroupData[{
Cell[88588, 2330, 121, 3, 48, "Input"],
Cell[88712, 2335, 5131, 165, 878, "Output"]
}, Open  ]],
Cell[93858, 2503, 408, 6, 90, "Text"],

Cell[CellGroupData[{
Cell[94291, 2513, 115, 3, 66, "Input"],
Cell[94409, 2518, 419, 12, 68, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

