(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    378973,       9456]*)
(*NotebookOutlinePosition[    380247,       9496]*)
(*  CellTagsIndexPosition[    380203,       9492]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["<<c:\\math\\kniz\\options\\optvalue.m", "Input"],

Cell["\"Payoff diagram eur\[OAcute]pskej call opcie pre X = 60\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[Max[S-60,0],{S,0,100},PlotRange->All,AxesLabel->
{\"CENA AKCIE\",\"CENA OPCIE\"},PlotStyle -> 
{Thickness[0.015]}, DisplayFunction->Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->{{20,100},{0,42}}]\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.25 0.0125 0 0.0147151 [
[.125 -0.0125 -6 -9 ]
[.125 -0.0125 6 0 ]
[.25 -0.0125 -6 -9 ]
[.25 -0.0125 6 0 ]
[.375 -0.0125 -6 -9 ]
[.375 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.625 -0.0125 -6 -9 ]
[.625 -0.0125 6 0 ]
[.75 -0.0125 -6 -9 ]
[.75 -0.0125 6 0 ]
[.875 -0.0125 -6 -9 ]
[.875 -0.0125 6 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 65 7.5 ]
[-0.0125 .14715 -12 -4.5 ]
[-0.0125 .14715 0 4.5 ]
[-0.0125 .2943 -12 -4.5 ]
[-0.0125 .2943 0 4.5 ]
[-0.0125 .44145 -12 -4.5 ]
[-0.0125 .44145 0 4.5 ]
[-0.0125 .5886 -12 -4.5 ]
[-0.0125 .5886 0 4.5 ]
[0 .64303 -32.5 0 ]
[0 .64303 32.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.125 0 m
.125 .00625 L
s
[(30)] .125 -0.0125 0 1 Mshowa
.25 0 m
.25 .00625 L
s
[(40)] .25 -0.0125 0 1 Mshowa
.375 0 m
.375 .00625 L
s
[(50)] .375 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(60)] .5 -0.0125 0 1 Mshowa
.625 0 m
.625 .00625 L
s
[(70)] .625 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(80)] .75 -0.0125 0 1 Mshowa
.875 0 m
.875 .00625 L
s
[(90)] .875 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(100)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.025 0 m
.025 .00375 L
s
.05 0 m
.05 .00375 L
s
.075 0 m
.075 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.175 0 m
.175 .00375 L
s
.2 0 m
.2 .00375 L
s
.225 0 m
.225 .00375 L
s
.275 0 m
.275 .00375 L
s
.3 0 m
.3 .00375 L
s
.325 0 m
.325 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.425 0 m
.425 .00375 L
s
.45 0 m
.45 .00375 L
s
.475 0 m
.475 .00375 L
s
.525 0 m
.525 .00375 L
s
.55 0 m
.55 .00375 L
s
.575 0 m
.575 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.675 0 m
.675 .00375 L
s
.7 0 m
.7 .00375 L
s
.725 0 m
.725 .00375 L
s
.775 0 m
.775 .00375 L
s
.8 0 m
.8 .00375 L
s
.825 0 m
.825 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.925 0 m
.925 .00375 L
s
.95 0 m
.95 .00375 L
s
.975 0 m
.975 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CENA) show
93.437500 14.437500 moveto
(AKCIE) show
123.437500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .14715 m
.00625 .14715 L
s
[(10)] -0.0125 .14715 1 0 Mshowa
0 .2943 m
.00625 .2943 L
s
[(20)] -0.0125 .2943 1 0 Mshowa
0 .44145 m
.00625 .44145 L
s
[(30)] -0.0125 .44145 1 0 Mshowa
0 .5886 m
.00625 .5886 L
s
[(40)] -0.0125 .5886 1 0 Mshowa
.125 Mabswid
0 .02943 m
.00375 .02943 L
s
0 .05886 m
.00375 .05886 L
s
0 .08829 m
.00375 .08829 L
s
0 .11772 m
.00375 .11772 L
s
0 .17658 m
.00375 .17658 L
s
0 .20601 m
.00375 .20601 L
s
0 .23544 m
.00375 .23544 L
s
0 .26487 m
.00375 .26487 L
s
0 .32373 m
.00375 .32373 L
s
0 .35316 m
.00375 .35316 L
s
0 .38259 m
.00375 .38259 L
s
0 .41202 m
.00375 .41202 L
s
0 .47088 m
.00375 .47088 L
s
0 .50031 m
.00375 .50031 L
s
0 .52974 m
.00375 .52974 L
s
0 .55917 m
.00375 .55917 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -93.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CENA) show
93.250000 14.437500 moveto
(OPCIE) show
123.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.015 w
.01107 0 m
.06224 0 L
.11664 0 L
.16905 0 L
.21947 0 L
.2731 0 L
.32475 0 L
.37441 0 L
.42729 0 L
.45162 0 L
.47818 0 L
.48514 0 L
.49256 0 L
.49617 0 L
.49794 0 L
.49957 0 L
.50105 .00123 L
.50262 .00308 L
.50592 .00696 L
.53228 .038 L
.58212 .09667 L
.63518 .15913 L
.68625 .21925 L
.74053 .28316 L
.79283 .34472 L
.84314 .40394 L
.89666 .46696 L
.9482 .52763 L
.99775 .58595 L
1 .5886 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00<`3oool2@00000@0oooo00=000000?ooo`3oool03`3oool3@0000080oooo00=000000?oo
o`3oool03`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00h0oooo0T0000040?oo
o`03@000003oool0oooo0100oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0?0?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool03P3oool2@00000@0oooo00=000000?oo
o`3oool02P3oool5@0000080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`100?oo
o`00=@3oool01T000000oooo0?oood000000oooo@0000140oooo00I000000?ooo`3ooom000000?oo
od00000?0?ooo`03@000003ooom000000080oooo00=000000?oood0000003`3oool00d000000oooo
@00000020?ooo`03@000003ooom000000140oooo00M000000?ooo`3oool0oooo@000003ooom00000
00l0oooo00=000000?oood0000000P3oool00d000000oooo@000000A0?ooo`06@000003oool0oooo
@000003ooom000003@3oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000
oooo@00000110?ooo`00=03oool01d000000oooo0?ooo`3ooom000000?oood0000003`3oool4@000
00040?oood000000oooo@0000140oooo00I000000?ooo`3ooom000000?oood00000?0?ooo`03@000
003ooom000000080oooo00=000000?oood0000004@3oool01d000000oooo0?ooo`3ooom000000?oo
od0000003`3oool00d000000oooo@00000020?ooo`03@000003ooom000000100oooo0T0000020?oo
o`03@000003ooom0000000d0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=0
00000?oood000000@@3oool003D0oooo00I000000?ooo`3ooom000000?oood00000?0?ooo`03@000
003ooom000000080oooo00=000000?oood0000003`3oool2@00000<0oooo00=000000?oood000000
3`3oool2@00000<0oooo00=000000?oood0000004P3oool01T000000oooo0?oood000000oooo@000
0100oooo00M000000?ooo`3oool0oooo@000003ooom0000000l0oooo00=000000?oood0000000P3o
ool00d000000oooo@000000=0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03
@000003ooom000000440oooo000c0?ooo`03@000003ooom000000080oooo00=000000?oood000000
403oool2@0000080oooo00=000000?oood0000003`3oool00d000000oooo0?ooo`020?ooo`03@000
003ooom0000000l0oooo00=000000?ooo`3oool00P3oool00d000000oooo@000000@0?ooo`03@000
003ooom000000080oooo00=000000?oood0000003`3oool00d000000oooo@00000020?ooo`03@000
003ooom0000000l0oooo00=000000?oood0000000P3oool00d000000oooo@000000=0?ooo`07@000
003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom000000440oooo000d0?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool0403oool01D000000oooo0?ooo`3ooom00000
0100oooo0d0000030?ooo`03@000003oool0oooo00l0oooo0T0000030?ooo`03@000003oool0oooo
00l0oooo0d0000030?ooo`03@000003oool0oooo00l0oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`0?0?ooo`9000000`3oool00d000000oooo0?ooo`0;0?ooo`900000103oool00d00
0000oooo0?ooo`020?ooo`03@000003oool0oooo0400oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003R0?ooo`90000000<0oooo@000040000001T0000001@3ooom00000@0000400
0000oooo009000002P3oool2@00000030?oood00001000000090000000<0oooo@000040000000P3o
ool2@0000080oooo0d0000000`3ooom00000@0000003@00000T0oooo001m0?ooo`030000003oool0
oooo0640oooo00=000000?ooo`3oool00P3oool01d000000oooo0?oood000000oooo@000003oool0
0d0000030?ooo`03@000003oool0oooo00P0oooo00U000000?ooo`3oool0oooo@000003ooom00000
0?oood0000000P3oool00d000000oooo0?ooo`030?ooo`05@000003oool0oooo0?oood0000000P3o
ool00d000000oooo0?ooo`070?ooo`00803oooni00000003@000003oool0oooo00D0oooo00=00000
0?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`05@000003ooom00000@000003oool00d00
000<0?ooo`=000000P3oool3@0000080oooo00=000000?ooo`3oool00`3oool01D000000oooo0?oo
o`3ooom0000000`0oooo000P0?oooel000005@3oool00d000000oooo0?ooo`0D0?ooo`03@000003o
ool0oooo01@0oooo00=000000?ooo`3oool0503oool00d000000oooo0?ooo`050?ooo`03@000003o
ool0oooo0080oooo0T0000030?ooo`90000000H0oooo@000003ooom000000?oood00000<0?ooo`03
@000003ooom000000080oooo0T0000030?ooo`03@000003oool0oooo00<0oooo00A000000?ooo`3o
ool0oooo0T00000;0?ooo`00803oool00`000000oooo0?ooo`1J0?ooo`800000HP3oool00d000000
oooo@00000020?ooo`05@000003oool0oooo@000003oool00T0000001@3ooom000000?ooo`3ooom0
000000h0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000
0`3oool01D000000oooo0?ooo`3ooom000000080oooo00=000000?ooo`3oool01`3oool00200oooo
00<000000?ooo`3oool0F`3oool200000640oooo0d0000000`3ooom00000@0000005@00000040?oo
od00001000000?ooo`9000003@3oool2@0000080oooo0T000000103ooom00000@000003oool3@000
0080oooo0d0000000`3ooom00000@0000003@00000T0oooo000P0?ooo`030000003oool0oooo05`0
oooo0P00002O0?ooo`00803oool00`00001000000?ooo`1M0?ooo`800000WP3oool00200oooo00<0
00000?ooo`3oool0GP3oool2000009d0oooo000P0?ooo`030000003oool0oooo05h0oooo0`00002L
0?ooo`00803oool00`000000oooo0?ooo`1O0?ooo`<00000V`3oool00200oooo00<000000?ooo`3o
ool0H03oool2000009/0oooo000P0?ooo`030000003oool0oooo0640oooo0P00002J0?ooo`00803o
ool00`00001000000?ooo`1Q0?ooo`<00000V@3oool00200oooo00<000000?ooo`3oool0HP3oool3
000009P0oooo000P0?ooo`030000003oool0oooo06<0oooo0`00002G0?ooo`00803oool00`000000
oooo0?ooo`1T0?ooo`<00000UP3oool00200oooo00<000000?ooo`3oool0I@3oool2000009H0oooo
000P0?ooo`03000004000000oooo06H0oooo0P00002E0?ooo`00803oool00`000000oooo0?ooo`1V
0?ooo`@00000T`3oool00200oooo00<000000?ooo`3oool0I`3oool400000980oooo000P0?ooo`03
0000003oool0oooo06P0oooo0`00002B0?ooo`00803oool00`000000oooo0?ooo`1Z0?ooo`800000
T@3oool00200oooo00<000000?ooo`3oool0JP3oool300000900oooo000P0?ooo`03000004000000
oooo06/0oooo0`00002?0?ooo`00803oool00`000000oooo0?ooo`1/0?ooo`800000S`3oool00200
oooo00<000000?ooo`3oool0K@3oool2000008h0oooo000D0?ooo`E000000P3oool00d000000oooo
0?ooo`020?ooo`030000003oool0oooo06d0oooo0`00002=0?ooo`005P3oool01d000000oooo0?oo
o`3ooom000000?oood0000000`3oool00`000000oooo0?ooo`1^0?ooo`<00000S03oool001H0oooo
00M000000?ooo`3oool0oooo@000003ooom0000000<0oooo00<00000@000003oool0K`3oool20000
08`0oooo000F0?ooo`07@000003oool0oooo0?oood000000oooo@00000030?ooo`030000003oool0
oooo0700oooo0`00002:0?ooo`005P3oool01d000000oooo0?ooo`3ooom000000?oood0000000`3o
ool00`000000oooo0?ooo`1`0?ooo`@00000R@3oool001D0oooo0T0000040?ooo`03@000003oool0
oooo0080oooo00<000000?ooo`3oool0L@3oool4000008P0oooo000P0?ooo`030000003oool0oooo
07<0oooo0P0000280?ooo`00803oool00`00001000000?ooo`1d0?ooo`800000Q`3oool00200oooo
00<000000?ooo`3oool0M03oool3000008H0oooo000P0?ooo`030000003oool0oooo07D0oooo0`00
00250?ooo`00803oool00`000000oooo0?ooo`1f0?ooo`<00000Q03oool00200oooo00<000000?oo
o`3oool0M`3oool3000008<0oooo000P0?ooo`030000003oool0oooo07P0oooo0P0000230?ooo`00
803oool00`00001000000?ooo`1i0?ooo`800000PP3oool00200oooo00<000000?ooo`3oool0N@3o
ool400000800oooo000P0?ooo`030000003oool0oooo07X0oooo1000001o0?ooo`00803oool00`00
0000oooo0?ooo`1k0?ooo`<00000O`3oool00200oooo00<000000?ooo`3oool0O@3oool2000007h0
oooo000P0?ooo`03000004000000oooo07d0oooo0`00001m0?ooo`00803oool00`000000oooo0?oo
o`1n0?ooo`<00000O03oool00200oooo00<000000?ooo`3oool0O`3oool3000007/0oooo000P0?oo
o`030000003oool0oooo0800oooo0P00001k0?ooo`00803oool00`000000oooo0?ooo`210?ooo`80
0000NP3oool00200oooo00<000000?ooo`3oool0P@3oool3000007T0oooo000P0?ooo`0300000400
0000oooo0880oooo0`00001h0?ooo`00803oool00`000000oooo0?ooo`230?ooo`800000N03oool0
0200oooo00<000000?ooo`3oool0Q03oool3000007H0oooo000E0?ooo`=000000`3oool00d000000
oooo0?ooo`020?ooo`030000003oool0oooo08@0oooo1000001e0?ooo`005@3oool00d000000oooo
0?ooo`020?ooo`03@000003ooom0000000<0oooo00<000000?ooo`3oool0Q@3oool4000007@0oooo
000F0?ooo`07@000003oool0oooo0?oood000000oooo@00000030?ooo`03000004000000oooo08L0
oooo0P00001d0?ooo`005P3oool01d000000oooo0?ooo`3ooom000000?oood0000000`3oool00`00
0000oooo0?ooo`280?ooo`800000L`3oool001D0oooo00=000000?oood0000000P3oool00d000000
oooo@00000030?ooo`030000003oool0oooo08P0oooo0`00001b0?ooo`005P3oool00d000000oooo
0?ooo`020?ooo`03@000003oool0oooo0080oooo00<000000?ooo`3oool0R@3oool300000740oooo
000P0?ooo`030000003oool0oooo08X0oooo0`00001`0?ooo`00803oool00`000000oooo0?ooo`2;
0?ooo`<00000K`3oool00200oooo00<00000@000003oool0S03oool2000006l0oooo000P0?ooo`03
0000003oool0oooo08d0oooo0P00001^0?ooo`00803oool00`000000oooo0?ooo`2=0?ooo`@00000
K03oool00200oooo00<000000?ooo`3oool0SP3oool4000006/0oooo000P0?ooo`030000003oool0
oooo08l0oooo0`00001[0?ooo`00803oool00`00001000000?ooo`2A0?ooo`800000JP3oool00200
oooo00<000000?ooo`3oool0T@3oool3000006T0oooo000P0?ooo`030000003oool0oooo0980oooo
0`00001X0?ooo`00803oool00`000000oooo0?ooo`2C0?ooo`800000J03oool00200oooo00<00000
0?ooo`3oool0U03oool2000006L0oooo000P0?ooo`03000004000000oooo09@0oooo0`00001V0?oo
o`00803oool00`000000oooo0?ooo`2E0?ooo`<00000I@3oool00200oooo00<000000?ooo`3oool0
UP3oool2000006D0oooo000P0?ooo`030000003oool0oooo09L0oooo0`00001S0?ooo`00803oool0
0`000000oooo0?ooo`2G0?ooo`@00000HP3oool00200oooo00<000000?ooo`3oool0V03oool30000
0680oooo000P0?ooo`03000004000000oooo09X0oooo0P00001Q0?ooo`00803oool00`000000oooo
0?ooo`2J0?ooo`<00000H03oool00200oooo00<000000?ooo`3oool0V`3oool3000005l0oooo000E
0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`030000003oool0oooo09`0oooo0`00001N
0?ooo`005`3oool01T000000oooo0?oood000000oooo@00000<0oooo00<000000?ooo`3oool0W@3o
ool2000005h0oooo000F0?ooo`07@000003oool0oooo0?oood000000oooo@00000030?ooo`030000
04000000oooo09h0oooo0P00001M0?ooo`005`3oool01T000000oooo0?oood000000oooo@00000<0
oooo00<000000?ooo`3oool0WP3oool3000005`0oooo000E0?ooo`03@000003ooom000000080oooo
00=000000?oood0000000`3oool00`000000oooo0?ooo`2O0?ooo`<00000F`3oool001H0oooo00=0
00000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`030000003oool0oooo0:00oooo0P00
001K0?ooo`00803oool00`000000oooo0?ooo`2Q0?ooo`<00000F@3oool00200oooo00<000000?oo
o`3oool0X@3oool4000005P0oooo000P0?ooo`03000004000000oooo0:80oooo0`00001H0?ooo`00
803oool00`000000oooo0?ooo`2T0?ooo`800000E`3oool00200oooo00<000000?ooo`3oool0Y03o
ool3000005H0oooo000P0?ooo`030000003oool0oooo0:D0oooo0`00001E0?ooo`00803oool00`00
0000oooo0?ooo`2V0?ooo`800000E@3oool00200oooo00<00000@000003oool0Y`3oool2000005@0
oooo000P0?ooo`030000003oool0oooo0:L0oooo0`00001C0?ooo`00803oool00`000000oooo0?oo
o`2X0?ooo`<00000DP3oool00200oooo00<000000?ooo`3oool0Z@3oool200000580oooo000P0?oo
o`030000003oool0oooo0:X0oooo0`00001@0?ooo`00803oool00`000000oooo0?ooo`2Z0?ooo`@0
0000C`3oool00200oooo00<00000@000003oool0Z`3oool3000004l0oooo000P0?ooo`030000003o
ool0oooo0:d0oooo0P00001>0?ooo`00803oool00`000000oooo0?ooo`2]0?ooo`<00000C@3oool0
0200oooo00<000000?ooo`3oool0[P3oool3000004`0oooo000P0?ooo`030000003oool0oooo0:l0
oooo0P00001<0?ooo`00803oool00`00001000000?ooo`2`0?ooo`800000B`3oool00200oooo00<0
00000?ooo`3oool0/03oool3000004X0oooo000P0?ooo`030000003oool0oooo0;40oooo0`000019
0?ooo`00803oool00`000000oooo0?ooo`2b0?ooo`800000B@3oool001H0oooo0d0000020?ooo`03
@000003oool0oooo0080oooo00<000000?ooo`3oool0/`3oool3000004L0oooo000G0?ooo`06@000
003oool0oooo@000003ooom000000`3oool00`000000oooo0?ooo`2c0?ooo`<00000A`3oool001D0
oooo14000000103ooom000000?oood0000030?ooo`03000004000000oooo0;@0oooo0`0000160?oo
o`005@3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0oooo00<000000?ooo`3o
ool0]@3oool2000004H0oooo000F0?ooo`9000000P3oool00d000000oooo@00000030?ooo`030000
003oool0oooo0?d0oooo000G0?ooo`05@000003oool0oooo0?oood000000103oool00`000000oooo
0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool00d000000oooo0?ooo`3m
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00103oool2
@00000030?oood000010000000I0000000D0oooo@0000400001000000?ooo`02@00000`0oooo0T00
0000103ooom00000@000040000040?ooo`9000000P3oool3@00000030?oood000010000000=00000
i`3oool000<0oooo00=000000?ooo`3oool00P3oool01d000000oooo0?oood000000oooo@000003o
ool00d0000030?ooo`03@000003oool0oooo00T0oooo00I000000?ooo`3ooom000000?oood000004
0?ooo`03@000003oool0oooo00<0oooo00E000000?ooo`3oool0oooo@00000020?ooo`03@000003o
ool0oooo0>D0oooo00030?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool0
1D000000oooo@00004000000oooo00=00000303oool01D000000oooo0?oood000000oooo00=00000
0P3oool00d000000oooo0?ooo`030?ooo`05@000003oool0oooo0?oood000000jP3oool000<0oooo
00=000000?ooo`3oool00P3oool2@00000<0oooo0T0000001P3ooom000000?oood000000oooo@000
00`0oooo00I000000?ooo`3ooom000000?oood0000020?ooo`03@000003ooom0000000D0oooo00A0
00000?ooo`3oool0oooo0T00003Y0?ooo`000`3oool00d000000oooo@00000020?ooo`05@000003o
ool0oooo@000003oool00T0000001@3ooom000000?ooo`3ooom0000000d0oooo00I000000?ooo`3o
oom000000?oood0000020?ooo`05@000003ooom000000?oood0000000`3oool01D000000oooo0?oo
o`3ooom000000080oooo00=000000?ooo`3oool0i@3oool000<0oooo0d0000000`3ooom00000@000
0005@00000040?oood00001000000?ooo`9000003P3oool2@00000030?oood000010000000900000
0P3oool3@0000080oooo0d0000000`3ooom00000@0000003@0000>L0oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {5.93612, -9.99229, 0.432722, 
  0.367583}}],

Cell[OutputFormData["\<\
Graphics[{Thickness[0.015], 
   {Line[{{4.166666666666666*^-6, 0.}, 
      {4.056699157291579, 0.}, {8.480879985937368, 0.}, 
      {12.63593663385385, 0.}, {16.6318407770828, 0.}, 
      {20.88525908229088, 0.}, {24.9795248828114, 0.}, 
      {29.33130484531106, 0.}, {33.52393230312316, 0.}, 
      {37.55740725624772, 0.}, {41.8483963713514, 0.}, 
      {45.98023298176753, 0.}, {49.95291708749613, 0.}, 
      {54.18311535520386, 0.}, {56.12954460089411, 0.}, 
      {58.25416111822403, 0.}, {58.81114343011613, 0.}, 
      {59.40491061331435, 0.}, {59.69342720002801, 0.}, 
      {59.83498527437989, 0.}, {59.96522545560042, 0.}, 
      {60.08389716597674, 0.08389716597674379}, 
      {60.20926972532082, 0.2092697253208228}, 
      {60.47325989076972, 0.473259890769718}, 
      {62.58272104322332, 2.58272104322333}, 
      {66.56975592134719, 6.569755921347194}, 
      {70.81430496145019, 10.81430496145018}, 
      {74.89970149686563, 14.89970149686563}, 
      {79.2426121942602, 19.2426121942602}, 
      {83.42637038696722, 23.42637038696722}, 
      {87.45097607498669, 27.45097607498669}, 
      {91.73309592498529, 31.7330959249853}, 
      {95.85606327029635, 35.85606327029636}, 
      {99.81987811091986, 39.81987811091987}, 
      {99.99999583333332, 39.99999583333332}}]}}, 
  {DisplayFunction -> (Display[$Display, #1] & ), 
   PlotRange -> {{20, 100}, {0, 42}}, PlotRange -> All, 
   AspectRatio -> GoldenRatio^(-1), 
   DisplayFunction :> Identity, ColorOutput -> Automatic, 
   Axes -> Automatic, AxesOrigin -> Automatic, 
   PlotLabel -> None, AxesLabel -> 
    {\"CENA AKCIE\", \"CENA OPCIE\"}, Ticks -> Automatic, 
   GridLines -> None, Prolog -> {}, Epilog -> {}, 
   AxesStyle -> Automatic, Background -> Automatic, 
   DefaultColor -> Automatic, DefaultFont :> $DefaultFont, 
   RotateLabel -> True, Frame -> False, 
   FrameStyle -> Automatic, FrameTicks -> Automatic, 
   FrameLabel -> None, PlotRegion -> Automatic, 
   ImageSize -> Automatic, TextStyle :> $TextStyle, 
   FormatType :> $FormatType}]\
\>", "\<\
-Graphics-\
\>"], "Output"]
}, Open  ]],

Cell["\"Payoff diagram eur\[OAcute]pskej put opcie pre X = 60\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[Max[60-S,0],{S,0,100},PlotRange->All,AxesLabel->
{\"CENA AKCIE\",\"CENA OPCIE\"},PlotStyle -> 
{Thickness[0.015]}, DisplayFunction->Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->{{20,100},{0,42}}]\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.25 0.0125 0 0.0147151 [
[.125 -0.0125 -6 -9 ]
[.125 -0.0125 6 0 ]
[.25 -0.0125 -6 -9 ]
[.25 -0.0125 6 0 ]
[.375 -0.0125 -6 -9 ]
[.375 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.625 -0.0125 -6 -9 ]
[.625 -0.0125 6 0 ]
[.75 -0.0125 -6 -9 ]
[.75 -0.0125 6 0 ]
[.875 -0.0125 -6 -9 ]
[.875 -0.0125 6 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 65 7.5 ]
[-0.0125 .14715 -12 -4.5 ]
[-0.0125 .14715 0 4.5 ]
[-0.0125 .2943 -12 -4.5 ]
[-0.0125 .2943 0 4.5 ]
[-0.0125 .44145 -12 -4.5 ]
[-0.0125 .44145 0 4.5 ]
[-0.0125 .5886 -12 -4.5 ]
[-0.0125 .5886 0 4.5 ]
[0 .64303 -32.5 0 ]
[0 .64303 32.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.125 0 m
.125 .00625 L
s
[(30)] .125 -0.0125 0 1 Mshowa
.25 0 m
.25 .00625 L
s
[(40)] .25 -0.0125 0 1 Mshowa
.375 0 m
.375 .00625 L
s
[(50)] .375 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(60)] .5 -0.0125 0 1 Mshowa
.625 0 m
.625 .00625 L
s
[(70)] .625 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(80)] .75 -0.0125 0 1 Mshowa
.875 0 m
.875 .00625 L
s
[(90)] .875 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(100)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.025 0 m
.025 .00375 L
s
.05 0 m
.05 .00375 L
s
.075 0 m
.075 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.175 0 m
.175 .00375 L
s
.2 0 m
.2 .00375 L
s
.225 0 m
.225 .00375 L
s
.275 0 m
.275 .00375 L
s
.3 0 m
.3 .00375 L
s
.325 0 m
.325 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.425 0 m
.425 .00375 L
s
.45 0 m
.45 .00375 L
s
.475 0 m
.475 .00375 L
s
.525 0 m
.525 .00375 L
s
.55 0 m
.55 .00375 L
s
.575 0 m
.575 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.675 0 m
.675 .00375 L
s
.7 0 m
.7 .00375 L
s
.725 0 m
.725 .00375 L
s
.775 0 m
.775 .00375 L
s
.8 0 m
.8 .00375 L
s
.825 0 m
.825 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.925 0 m
.925 .00375 L
s
.95 0 m
.95 .00375 L
s
.975 0 m
.975 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CENA) show
93.437500 14.437500 moveto
(AKCIE) show
123.437500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .14715 m
.00625 .14715 L
s
[(10)] -0.0125 .14715 1 0 Mshowa
0 .2943 m
.00625 .2943 L
s
[(20)] -0.0125 .2943 1 0 Mshowa
0 .44145 m
.00625 .44145 L
s
[(30)] -0.0125 .44145 1 0 Mshowa
0 .5886 m
.00625 .5886 L
s
[(40)] -0.0125 .5886 1 0 Mshowa
.125 Mabswid
0 .02943 m
.00375 .02943 L
s
0 .05886 m
.00375 .05886 L
s
0 .08829 m
.00375 .08829 L
s
0 .11772 m
.00375 .11772 L
s
0 .17658 m
.00375 .17658 L
s
0 .20601 m
.00375 .20601 L
s
0 .23544 m
.00375 .23544 L
s
0 .26487 m
.00375 .26487 L
s
0 .32373 m
.00375 .32373 L
s
0 .35316 m
.00375 .35316 L
s
0 .38259 m
.00375 .38259 L
s
0 .41202 m
.00375 .41202 L
s
0 .47088 m
.00375 .47088 L
s
0 .50031 m
.00375 .50031 L
s
0 .52974 m
.00375 .52974 L
s
0 .55917 m
.00375 .55917 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -93.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CENA) show
93.250000 14.437500 moveto
(OPCIE) show
123.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.015 w
0 .5886 m
.01107 .57558 L
.06224 .51533 L
.11664 .45129 L
.16905 .3896 L
.21947 .33024 L
.2731 .2671 L
.32475 .2063 L
.37441 .14784 L
.42729 .0856 L
.47818 .02569 L
.49144 .01008 L
.49507 .0058 L
.49707 .00345 L
.49805 .0023 L
.49895 .00124 L
.4998 .00024 L
.5007 0 L
.50161 0 L
.5026 0 L
.50592 0 L
.53228 0 L
.58534 0 L
.63641 0 L
.69069 0 L
.74299 0 L
.7933 0 L
.84683 0 L
.89836 0 L
.94791 0 L
1 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{42, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00<`3oool2@00000@0oooo00=000000?ooo`3oool03`3oool3@0000080oooo00=000000?oo
o`3oool03`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00h0oooo0T0000040?oo
o`03@000003oool0oooo0100oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0?0?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool03P3oool2@00000@0oooo00=000000?oo
o`3oool02P3oool5@0000080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`100?oo
o`00=@3oool01T000000oooo0?oood000000oooo@0000140oooo00I000000?ooo`3ooom000000?oo
od00000?0?ooo`03@000003ooom000000080oooo00=000000?oood0000003`3oool00d000000oooo
@00000020?ooo`03@000003ooom000000140oooo00M000000?ooo`3oool0oooo@000003ooom00000
00l0oooo00=000000?oood0000000P3oool00d000000oooo@000000A0?ooo`06@000003oool0oooo
@000003ooom000003@3oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000
oooo@00000110?ooo`00=03oool01d000000oooo0?ooo`3ooom000000?oood0000003`3oool4@000
00040?oood000000oooo@0000140oooo00I000000?ooo`3ooom000000?oood00000?0?ooo`03@000
003ooom000000080oooo00=000000?oood0000004@3oool01d000000oooo0?ooo`3ooom000000?oo
od0000003`3oool00d000000oooo@00000020?ooo`03@000003ooom000000100oooo0T0000020?oo
o`03@000003ooom0000000d0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=0
00000?oood000000@@3oool003D0oooo00I000000?ooo`3ooom000000?oood00000?0?ooo`03@000
003ooom000000080oooo00=000000?oood0000003`3oool2@00000<0oooo00=000000?oood000000
3`3oool2@00000<0oooo00=000000?oood0000004P3oool01T000000oooo0?oood000000oooo@000
0100oooo00M000000?ooo`3oool0oooo@000003ooom0000000l0oooo00=000000?oood0000000P3o
ool00d000000oooo@000000=0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03
@000003ooom000000440oooo000c0?ooo`03@000003ooom000000080oooo00=000000?oood000000
403oool2@0000080oooo00=000000?oood0000003`3oool00d000000oooo0?ooo`020?ooo`03@000
003ooom0000000l0oooo00=000000?ooo`3oool00P3oool00d000000oooo@000000@0?ooo`03@000
003ooom000000080oooo00=000000?oood0000003`3oool00d000000oooo@00000020?ooo`03@000
003ooom0000000l0oooo00=000000?oood0000000P3oool00d000000oooo@000000=0?ooo`07@000
003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom000000440oooo000d0?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool0403oool01D000000oooo0?ooo`3ooom00000
0100oooo0d0000030?ooo`03@000003oool0oooo00l0oooo0T0000030?ooo`03@000003oool0oooo
00l0oooo0d0000030?ooo`03@000003oool0oooo00l0oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`0?0?ooo`9000000`3oool00d000000oooo0?ooo`0;0?ooo`900000103oool00d00
0000oooo0?ooo`020?ooo`03@000003oool0oooo0400oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003R0?ooo`90000000<0oooo@000040000001T0000001@3ooom00000@0000400
0000oooo009000002P3oool2@00000030?oood00001000000090000000<0oooo@000040000000P3o
ool2@0000080oooo0d0000000`3ooom00000@0000003@00000T0oooo003Q0?ooo`03@000003oool0
oooo0080oooo00M000000?ooo`3ooom000000?oood000000oooo00=000000`3oool00d000000oooo
0?ooo`080?ooo`09@000003oool0oooo0?oood000000oooo@000003ooom000000080oooo00=00000
0?ooo`3oool00`3oool01D000000oooo0?ooo`3ooom000000080oooo00=000000?ooo`3oool01`3o
ool00200oooo^P0000070?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool0
1D000000oooo@00004000000oooo00=00000303oool3@0000080oooo0d0000020?ooo`03@000003o
ool0oooo00<0oooo00E000000?ooo`3oool0oooo@000000<0?ooo`00803oool00`000000oooo0?oo
o`0D0?ooo`03@000003oool0oooo01@0oooo00=000000?ooo`3oool0503oool00d000000oooo0?oo
o`0B0?ooof0000001`3oool00d000000oooo0?ooo`020?ooo`9000000`3oool2@00000060?oood00
0000oooo@000003ooom00000303oool00d000000oooo@00000020?ooo`9000000`3oool00d000000
oooo0?ooo`030?ooo`04@000003oool0oooo0?ooo`9000002`3oool00200oooo00<000000?ooo`3o
ool0EP3oool4000006@0oooo00=000000?oood0000000P3oool01D000000oooo0?oood000000oooo
0090000000D0oooo@000003oool0oooo@000000>0?ooo`07@000003oool0oooo0?oood000000oooo
@00000020?ooo`03@000003ooom0000000<0oooo00E000000?ooo`3oool0oooo@00000020?ooo`03
@000003oool0oooo00L0oooo000P0?ooo`030000003oool0oooo05D0oooo1000001U0?ooo`=00000
00<0oooo@000040000001D000000103ooom00000@000003oool2@00000d0oooo0T0000020?ooo`90
000000@0oooo@00004000000oooo0d0000020?ooo`=0000000<0oooo@000040000000d0000090?oo
o`00803oool00`000000oooo0?ooo`1D0?ooo`<00000YP3oool00200oooo00<00000@000003oool0
D`3oool300000:L0oooo000P0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool0Y`3o
ool00200oooo00<000000?ooo`3oool0DP3oool200000:T0oooo000P0?ooo`030000003oool0oooo
0540oooo0P00002Z0?ooo`00803oool00`000000oooo0?ooo`1@0?ooo`800000Z`3oool00200oooo
00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`2Z0?ooo`00803oool00`00001000000?oo
o`1?0?ooo`800000[03oool00200oooo00<000000?ooo`3oool0CP3oool200000:d0oooo000P0?oo
o`030000003oool0oooo04d0oooo0P00002^0?ooo`00803oool00`000000oooo0?ooo`1=0?ooo`03
0000003oool0oooo0:d0oooo000P0?ooo`030000003oool0oooo04/0oooo0`00002_0?ooo`00803o
ool00`00001000000?ooo`1:0?ooo`<00000/03oool00200oooo00<000000?ooo`3oool0B@3oool3
00000;40oooo000P0?ooo`030000003oool0oooo04T0oooo0P00002b0?ooo`00803oool00`000000
oooo0?ooo`180?ooo`800000/`3oool00200oooo00<000000?ooo`3oool0A`3oool300000;<0oooo
000P0?ooo`030000003oool0oooo04H0oooo0`00002d0?ooo`00803oool00`00001000000?ooo`15
0?ooo`<00000]@3oool00200oooo00<000000?ooo`3oool0A03oool300000;H0oooo000P0?ooo`03
0000003oool0oooo04@0oooo0P00002g0?ooo`00503oool5@0000080oooo00=000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`130?ooo`800000^03oool001H0oooo00M000000?ooo`3oool0oooo
@000003ooom0000000<0oooo00<000000?ooo`3oool0@@3oool400000;P0oooo000F0?ooo`07@000
003oool0oooo0?oood000000oooo@00000030?ooo`03000004000000oooo0400oooo1000002i0?oo
o`005P3oool01d000000oooo0?ooo`3ooom000000?oood0000000`3oool00`000000oooo0?ooo`10
0?ooo`<00000^P3oool001H0oooo00M000000?ooo`3oool0oooo@000003ooom0000000<0oooo00<0
00000?ooo`3oool0?`3oool200000;`0oooo000E0?ooo`900000103oool00d000000oooo0?ooo`02
0?ooo`030000003oool0oooo03h0oooo0`00002l0?ooo`00803oool00`000000oooo0?ooo`0m0?oo
o`<00000_@3oool00200oooo00<00000@000003oool0?@3oool200000;h0oooo000P0?ooo`030000
003oool0oooo03`0oooo0P00002o0?ooo`00803oool00`000000oooo0?ooo`0k0?ooo`<00000_`3o
ool00200oooo00<000000?ooo`3oool0>P3oool300000<00oooo000P0?ooo`030000003oool0oooo
03X0oooo0P0000310?ooo`00803oool00`000000oooo0?ooo`0h0?ooo`<00000`P3oool00200oooo
00<00000@000003oool0=`3oool400000<80oooo000P0?ooo`030000003oool0oooo03H0oooo1000
00330?ooo`00803oool00`000000oooo0?ooo`0f0?ooo`800000a@3oool00200oooo00<000000?oo
o`3oool0=@3oool200000<H0oooo000P0?ooo`030000003oool0oooo03@0oooo0`0000360?ooo`00
803oool00`00001000000?ooo`0c0?ooo`<00000a`3oool00200oooo00<000000?ooo`3oool0<P3o
ool300000<P0oooo000P0?ooo`030000003oool0oooo0340oooo0`0000390?ooo`00803oool00`00
0000oooo0?ooo`0a0?ooo`800000bP3oool00200oooo00<000000?ooo`3oool0<03oool200000</0
oooo000P0?ooo`030000003oool0oooo02l0oooo0`00003;0?ooo`00803oool00`00001000000?oo
o`0^0?ooo`<00000c03oool00200oooo00<000000?ooo`3oool0;@3oool300000<d0oooo000P0?oo
o`030000003oool0oooo02d0oooo00<000000?ooo`3oool0c@3oool001D0oooo0d0000030?ooo`03
@000003oool0oooo0080oooo00<000000?ooo`3oool0;03oool200000<l0oooo000E0?ooo`03@000
003oool0oooo0080oooo00=000000?oood0000000`3oool00`000000oooo0?ooo`0[0?ooo`800000
d03oool001H0oooo00M000000?ooo`3oool0oooo@000003ooom0000000<0oooo00<00000@000003o
ool0:P3oool200000=40oooo000F0?ooo`07@000003oool0oooo0?oood000000oooo@00000030?oo
o`030000003oool0oooo02X0oooo00<000000?ooo`3oool0d03oool001D0oooo00=000000?oood00
00000P3oool00d000000oooo@00000030?ooo`030000003oool0oooo02T0oooo0P00003B0?ooo`00
5P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00<000000?ooo`3oool0
:03oool200000=<0oooo000P0?ooo`030000003oool0oooo02L0oooo0P00003D0?ooo`00803oool0
0`000000oooo0?ooo`0W0?ooo`030000003oool0oooo0=<0oooo000P0?ooo`03000004000000oooo
02D0oooo0`00003E0?ooo`00803oool00`000000oooo0?ooo`0T0?ooo`<00000eP3oool00200oooo
00<000000?ooo`3oool08`3oool300000=L0oooo000P0?ooo`030000003oool0oooo02<0oooo0P00
003H0?ooo`00803oool00`000000oooo0?ooo`0R0?ooo`800000f@3oool00200oooo00<00000@000
003oool08@3oool300000=T0oooo000P0?ooo`030000003oool0oooo0200oooo0`00003J0?ooo`00
803oool00`000000oooo0?ooo`0O0?ooo`<00000f`3oool00200oooo00<000000?ooo`3oool07P3o
ool300000=`0oooo000P0?ooo`030000003oool0oooo01h0oooo0P00003M0?ooo`00803oool00`00
001000000?ooo`0M0?ooo`800000gP3oool00200oooo00<000000?ooo`3oool06`3oool400000=h0
oooo000P0?ooo`030000003oool0oooo01X0oooo1000003O0?ooo`00803oool00`000000oooo0?oo
o`0J0?ooo`<00000h03oool00200oooo00<000000?ooo`3oool06@3oool200000>80oooo000P0?oo
o`030000003oool0oooo01P0oooo0`00003R0?ooo`00803oool00`00001000000?ooo`0G0?ooo`<0
0000h`3oool00200oooo00<000000?ooo`3oool05`3oool200000>@0oooo000P0?ooo`030000003o
ool0oooo01H0oooo0P00003U0?ooo`005@3oool2@00000@0oooo00=000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0E0?ooo`<00000i@3oool001L0oooo00I000000?ooo`3ooom000000?oood00
00030?ooo`030000003oool0oooo01@0oooo0`00003V0?ooo`005P3oool01d000000oooo0?ooo`3o
oom000000?oood0000000`3oool00`00001000000?ooo`0D0?ooo`800000i`3oool001L0oooo00I0
00000?ooo`3ooom000000?oood0000030?ooo`030000003oool0oooo0180oooo0`00003X0?ooo`00
5@3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0oooo00<000000?ooo`3oool0
4@3oool400000>P0oooo000F0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0A0?ooo`<00000j@3oool00200oooo00<000000?ooo`3oool0403oool2
00000>/0oooo000P0?ooo`030000003oool0oooo00l0oooo0`00003[0?ooo`00803oool00`000010
00000?ooo`0>0?ooo`<00000k03oool00200oooo00<000000?ooo`3oool03P3oool200000>d0oooo
000P0?ooo`030000003oool0oooo00d0oooo0P00003^0?ooo`00803oool00`000000oooo0?ooo`0<
0?ooo`<00000kP3oool00200oooo00<000000?ooo`3oool02`3oool300000>l0oooo000P0?ooo`03
000004000000oooo00X0oooo0`00003`0?ooo`00803oool00`000000oooo0?ooo`0:0?ooo`800000
l@3oool00200oooo00<000000?ooo`3oool0203oool300000?80oooo000P0?ooo`030000003oool0
oooo00L0oooo1000003b0?ooo`00803oool00`000000oooo0?ooo`060?ooo`@00000l`3oool00200
oooo00<000000?ooo`3oool01P3oool200000?D0oooo000P0?ooo`03000004000000oooo00D0oooo
0P00003f0?ooo`00803oool00`000000oooo0?ooo`040?ooo`<00000mP3oool00200oooo00<00000
0?ooo`3oool00`3oool300000?L0oooo000P0?ooo`030000003oool0oooo0080oooo0`00003h0?oo
o`00803oool010000000oooo0?ooo`3oool300000?T0oooo000P0?ooo`04000004000000oooo0?oo
o`800000nP3oool00200oooo00<000000?ooo`3oool00P00003k0?ooo`00803oool00`000000oooo
0000000200000?/0oooo000P0?ooo`@00000o03oool001H0oooo0d0000020?ooo`03@000003oool0
oooo0080oooo0`00003m0?ooo`005`3oool01T000000oooo0?oood000000oooo@00000<0oooo0P00
003n0?ooo`005@3oool4@00000040?oood000000oooo@0000080oooo0P0000000d000000oooo0?oo
o`3l0?ooo`005@3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0oooo00<00000
0?ooo`3oool0o@3oool001H0oooo0T0000020?ooo`03@000003ooom0000000<0oooo00<000000?oo
o`3oool0o@3oool001L0oooo00E000000?ooo`3oool0oooo@00000040?ooo`030000003oool0oooo
0?d0oooo000P0?ooo`030000003oool0oooo0?d0oooo000P0?ooo`03@000003oool0oooo0?d0oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo00040?ooo`900000
00<0oooo@000040000001T0000001@3ooom00000@00004000000oooo00900000303oool2@0000004
0?oood0000100000@00000@0oooo0T0000020?ooo`=0000000<0oooo@000040000000d00003W0?oo
o`000`3oool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo@000003ooom000000?ooo`03
@00000<0oooo00=000000?ooo`3oool02@3oool01T000000oooo0?oood000000oooo@00000@0oooo
00=000000?ooo`3oool00`3oool01D000000oooo0?ooo`3ooom000000080oooo00=000000?ooo`3o
ool0i@3oool000<0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`05@000
003ooom00000@000003oool00d00000<0?ooo`05@000003oool0oooo@000003oool00d0000020?oo
o`03@000003oool0oooo00<0oooo00E000000?ooo`3oool0oooo@000003Z0?ooo`000`3oool00d00
0000oooo0?ooo`020?ooo`9000000`3oool2@00000060?oood000000oooo@000003ooom00000303o
ool01T000000oooo0?oood000000oooo@0000080oooo00=000000?oood0000001@3oool014000000
oooo0?ooo`3oool2@0000>T0oooo00030?ooo`03@000003ooom000000080oooo00E000000?ooo`3o
oom000000?ooo`02@00000050?oood000000oooo0?oood0000003@3oool01T000000oooo0?oood00
0000oooo@0000080oooo00E000000?oood000000oooo@00000030?ooo`05@000003oool0oooo0?oo
od0000000P3oool00d000000oooo0?ooo`3U0?ooo`000`3oool3@00000030?oood000010000000E0
000000@0oooo@00004000000oooo0T00000>0?ooo`90000000<0oooo@000040000000T0000020?oo
o`=000000P3oool3@00000030?oood000010000000=00000i`3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {5.93612, -9.99229, 0.432722, 
  0.367583}}],

Cell[OutputFormData["\<\
Graphics[{Thickness[0.015], 
   {Line[{{4.166666666666666*^-6, 59.99999583333333}, 
      {4.056699157291579, 55.94330084270842}, 
      {8.480879985937368, 51.51912001406262}, 
      {12.63593663385385, 47.36406336614614}, 
      {16.6318407770828, 43.36815922291719}, 
      {20.88525908229088, 39.11474091770911}, 
      {24.9795248828114, 35.02047511718859}, 
      {29.33130484531106, 30.66869515468893}, 
      {33.52393230312316, 26.47606769687683}, 
      {37.55740725624772, 22.44259274375227}, 
      {41.8483963713514, 18.15160362864859}, 
      {45.98023298176753, 14.01976701823245}, 
      {49.95291708749613, 10.04708291250385}, 
      {54.18311535520386, 5.816884644796139}, 
      {58.25416111822403, 1.745838881775966}, 
      {59.31514618235505, 0.6848538176449423}, 
      {59.60582673192192, 0.3941732680780773}, 
      {59.76538871273101, 0.23461128726899}, 
      {59.84367636683222, 0.1563236331677728}, 
      {59.91570474320114, 0.0842952567988604}, 
      {59.98401104101897, 0.01598895898102625}, 
      {60.05617428320688, 0.}, {60.12861230349221, 0.}, 
      {60.20812448940978, 0.}, {60.47325989076972, 0.}, 
      {62.58272104322332, 0.}, {66.82727008332632, 0.}, 
      {70.91266661874176, 0.}, {75.25557731613633, 0.}, 
      {79.43933550884335, 0.}, {83.46394119686284, 0.}, 
      {87.74606104686144, 0.}, {91.8690283921725, 0.}, 
      {95.83284323279601, 0.}, {99.99999583333332, 0.}}]}}, 
  {DisplayFunction -> (Display[$Display, #1] & ), 
   PlotRange -> {{20, 100}, {0, 42}}, PlotRange -> All, 
   AspectRatio -> GoldenRatio^(-1), 
   DisplayFunction :> Identity, ColorOutput -> Automatic, 
   Axes -> Automatic, AxesOrigin -> Automatic, 
   PlotLabel -> None, AxesLabel -> 
    {\"CENA AKCIE\", \"CENA OPCIE\"}, Ticks -> Automatic, 
   GridLines -> None, Prolog -> {}, Epilog -> {}, 
   AxesStyle -> Automatic, Background -> Automatic, 
   DefaultColor -> Automatic, DefaultFont :> $DefaultFont, 
   RotateLabel -> True, Frame -> False, 
   FrameStyle -> Automatic, FrameTicks -> Automatic, 
   FrameLabel -> None, PlotRegion -> Automatic, 
   ImageSize -> Automatic, TextStyle :> $TextStyle, 
   FormatType :> $FormatType}]\
\>", "\<\
-Graphics-\
\>"], "Output"]
}, Open  ]],

Cell[TextData[
"\"OBR.3\nZisk z eur\[OAcute]pskej call opcie v long poz\[IAcute]cii, ak \
expira\[CHacek]n\[AAcute] cena je 60 a cena opcie je 10\""], "Text"],

Cell[CellGroupData[{

Cell["\<\
c:=10;
g=Plot[-c+Max[S-60,0],{S,0,100},PlotRange->All,AxesLabel->
{\"CENA AKCIE\",\"ZISK\"},PlotStyle -> 
{Thickness[0.015]}, DisplayFunction->Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->
{{20,100},{-11,32}}]\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.25 0.0125 0.158102 0.0143729 [
[.125 .1456 -6 -9 ]
[.125 .1456 6 0 ]
[.25 .1456 -6 -9 ]
[.25 .1456 6 0 ]
[.375 .1456 -6 -9 ]
[.375 .1456 6 0 ]
[.5 .1456 -6 -9 ]
[.5 .1456 6 0 ]
[.625 .1456 -6 -9 ]
[.625 .1456 6 0 ]
[.75 .1456 -6 -9 ]
[.75 .1456 6 0 ]
[.875 .1456 -6 -9 ]
[.875 .1456 6 0 ]
[1 .1456 -9 -9 ]
[1 .1456 9 0 ]
[1.025 .1581 0 -7.5 ]
[1.025 .1581 65 7.5 ]
[-0.0125 .01437 -18 -4.5 ]
[-0.0125 .01437 0 4.5 ]
[-0.0125 .30183 -12 -4.5 ]
[-0.0125 .30183 0 4.5 ]
[-0.0125 .44556 -12 -4.5 ]
[-0.0125 .44556 0 4.5 ]
[-0.0125 .58929 -12 -4.5 ]
[-0.0125 .58929 0 4.5 ]
[0 .64303 -14 0 ]
[0 .64303 14 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.125 .1581 m
.125 .16435 L
s
[(30)] .125 .1456 0 1 Mshowa
.25 .1581 m
.25 .16435 L
s
[(40)] .25 .1456 0 1 Mshowa
.375 .1581 m
.375 .16435 L
s
[(50)] .375 .1456 0 1 Mshowa
.5 .1581 m
.5 .16435 L
s
[(60)] .5 .1456 0 1 Mshowa
.625 .1581 m
.625 .16435 L
s
[(70)] .625 .1456 0 1 Mshowa
.75 .1581 m
.75 .16435 L
s
[(80)] .75 .1456 0 1 Mshowa
.875 .1581 m
.875 .16435 L
s
[(90)] .875 .1456 0 1 Mshowa
1 .1581 m
1 .16435 L
s
[(100)] 1 .1456 0 1 Mshowa
.125 Mabswid
.025 .1581 m
.025 .16185 L
s
.05 .1581 m
.05 .16185 L
s
.075 .1581 m
.075 .16185 L
s
.1 .1581 m
.1 .16185 L
s
.15 .1581 m
.15 .16185 L
s
.175 .1581 m
.175 .16185 L
s
.2 .1581 m
.2 .16185 L
s
.225 .1581 m
.225 .16185 L
s
.275 .1581 m
.275 .16185 L
s
.3 .1581 m
.3 .16185 L
s
.325 .1581 m
.325 .16185 L
s
.35 .1581 m
.35 .16185 L
s
.4 .1581 m
.4 .16185 L
s
.425 .1581 m
.425 .16185 L
s
.45 .1581 m
.45 .16185 L
s
.475 .1581 m
.475 .16185 L
s
.525 .1581 m
.525 .16185 L
s
.55 .1581 m
.55 .16185 L
s
.575 .1581 m
.575 .16185 L
s
.6 .1581 m
.6 .16185 L
s
.65 .1581 m
.65 .16185 L
s
.675 .1581 m
.675 .16185 L
s
.7 .1581 m
.7 .16185 L
s
.725 .1581 m
.725 .16185 L
s
.775 .1581 m
.775 .16185 L
s
.8 .1581 m
.8 .16185 L
s
.825 .1581 m
.825 .16185 L
s
.85 .1581 m
.85 .16185 L
s
.9 .1581 m
.9 .16185 L
s
.925 .1581 m
.925 .16185 L
s
.95 .1581 m
.95 .16185 L
s
.975 .1581 m
.975 .16185 L
s
.25 Mabswid
0 .1581 m
1 .1581 L
s
gsave
1.025 .1581 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CENA) show
93.437500 14.437500 moveto
(AKCIE) show
123.437500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .01437 m
.00625 .01437 L
s
[(-10)] -0.0125 .01437 1 0 Mshowa
0 .30183 m
.00625 .30183 L
s
[(10)] -0.0125 .30183 1 0 Mshowa
0 .44556 m
.00625 .44556 L
s
[(20)] -0.0125 .44556 1 0 Mshowa
0 .58929 m
.00625 .58929 L
s
[(30)] -0.0125 .58929 1 0 Mshowa
.125 Mabswid
0 .04312 m
.00375 .04312 L
s
0 .07186 m
.00375 .07186 L
s
0 .10061 m
.00375 .10061 L
s
0 .12936 m
.00375 .12936 L
s
0 .18685 m
.00375 .18685 L
s
0 .21559 m
.00375 .21559 L
s
0 .24434 m
.00375 .24434 L
s
0 .27308 m
.00375 .27308 L
s
0 .33058 m
.00375 .33058 L
s
0 .35932 m
.00375 .35932 L
s
0 .38807 m
.00375 .38807 L
s
0 .41681 m
.00375 .41681 L
s
0 .47431 m
.00375 .47431 L
s
0 .50305 m
.00375 .50305 L
s
0 .5318 m
.00375 .5318 L
s
0 .56054 m
.00375 .56054 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(ZISK) show
87.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.015 w
0 .01437 m
.01107 .01437 L
.06224 .01437 L
.11664 .01437 L
.16905 .01437 L
.21947 .01437 L
.2731 .01437 L
.32475 .01437 L
.37441 .01437 L
.42729 .01437 L
.45162 .01437 L
.47818 .01437 L
.48514 .01437 L
.49256 .01437 L
.49617 .01437 L
.49794 .01437 L
.49957 .01437 L
.50105 .01558 L
.50262 .01738 L
.50592 .02117 L
.53228 .05149 L
.58212 .1088 L
.63518 .16981 L
.68625 .22852 L
.74053 .29094 L
.79283 .35108 L
.84314 .40892 L
.89666 .47047 L
.9482 .52973 L
.99775 .5867 L
1 .58929 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00503oool00`000000oooo0?ooo`3o0?ooo`X0oooo
00080?ooo`E000000P3oool00d000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0oooo2P3o
ool000X0oooo00M000000?ooo`3oool0oooo@000003ooom0000000<0oooo00<000000?ooo`3oool0
G`3oool00`000000oooo0?ooo`2W0?ooo`00103oool3@00000<0oooo00M000000?ooo`3oool0oooo
@000003ooom000000080ooooI@00002X0?ooo`002P3oool01d000000oooo0?ooo`3ooom000000?oo
od0000000P3ooomV00000:L0oooo000:0?ooo`07@000003oool0oooo0?oood000000oooo@0000003
0?ooo`030000003oool0oooo05l0oooo1000002V0?ooo`002@3oool2@00000@0oooo00=000000?oo
o`3oool00P3oool00`000000oooo0?ooo`1Q0?ooo`<00000Y@3oool001@0oooo00<000000?ooo`3o
ool0HP3oool200000:D0oooo000D0?ooo`030000003oool0oooo06<0oooo0P00002T0?ooo`00503o
ool00`00001000000?ooo`1S0?ooo`<00000X`3oool001@0oooo00<000000?ooo`3oool0I03oool3
00000:80oooo000D0?ooo`030000003oool0oooo06D0oooo0`00002Q0?ooo`00503oool00`000000
oooo0?ooo`1W0?ooo`030000003oool0oooo09l0oooo000D0?ooo`030000003oool0oooo06L0oooo
0P00002P0?ooo`00503oool00`00001000000?ooo`1X0?ooo`800000W`3oool001@0oooo00<00000
0?ooo`3oool0J@3oool2000009h0oooo000D0?ooo`030000003oool0oooo06X0oooo00<000000?oo
o`3oool0W03oool001@0oooo00<000000?ooo`3oool0JP3oool2000009d0oooo000D0?ooo`030000
003oool0oooo06/0oooo0P00002L0?ooo`00503oool00`000000oooo0?ooo`1/0?ooo`800000V`3o
ool001@0oooo00<00000@000003oool0K@3oool00`000000oooo0?ooo`2I0?ooo`00503oool00`00
0000oooo0?ooo`0B0?ooo`900000103oool00d000000oooo0?ooo`0@0?ooo`=000000P3oool00d00
0000oooo0?ooo`0A0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool03`3oool2@000
00@0oooo00=000000?ooo`3oool02@3oool3000000D0oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`0@0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0403oool2@000
00@0oooo00=000000?ooo`3oool0303oool5@0000080oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`100?ooo`00503oool00`000000oooo0?ooo`0D0?ooo`06@000003oool0oooo@000
003ooom000004P3oool01T000000oooo0?oood000000oooo@0000140oooo00=000000?oood000000
0P3oool00d000000oooo@000000@0?ooo`03@000003ooom000000080oooo00=000000?oood000000
2`3oool3000000@0oooo00M000000?ooo`3oool0oooo@000003ooom000000100oooo00=000000?oo
od0000000P3oool00d000000oooo@000000C0?ooo`06@000003oool0oooo@000003ooom000003`3o
ool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@00000110?ooo`00
503oool00`000000oooo0?ooo`0C0?ooo`07@000003oool0oooo0?oood000000oooo@000000@0?oo
o`A0000000@0oooo@000003ooom000004`3oool01T000000oooo0?oood000000oooo@0000100oooo
00=000000?oood0000000P3oool00d000000oooo@000000<0?ooo`<000000`3oool01d000000oooo
0?ooo`3ooom000000?oood000000403oool00d000000oooo@00000020?ooo`03@000003ooom00000
0180oooo0T0000020?ooo`03@000003ooom0000000l0oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood000000@@3oool001@0oooo00<000000?ooo`3oool0503oool0
1T000000oooo0?oood000000oooo@0000100oooo00=000000?oood0000000P3oool00d000000oooo
@000000A0?ooo`9000000`3oool00d000000oooo@000000@0?ooo`9000000`3oool00d000000oooo
@000000=0?ooo`800000103oool01T000000oooo0?oood000000oooo@0000140oooo00M000000?oo
o`3oool0oooo@000003ooom000000140oooo00=000000?oood0000000P3oool00d000000oooo@000
000?0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom000000440
oooo000D0?ooo`030000003oool0oooo0180oooo00=000000?oood0000000P3oool00d000000oooo
@000000A0?ooo`9000000P3oool00d000000oooo@000000A0?ooo`03@000003oool0oooo0080oooo
00=000000?oood000000403oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000000h0oooo
0P000000103ooom000000?oood0000020?ooo`03@000003ooom000000100oooo00=000000?oood00
00000P3oool00d000000oooo@000000A0?ooo`03@000003ooom000000080oooo00=000000?oood00
00003`3oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@0000011
0?ooo`00503oool00`00001000000?ooo`0C0?ooo`03@000003oool0oooo0080oooo00=000000?oo
o`3oool04@3oool01D000000oooo0?ooo`3ooom000000180oooo0d0000030?ooo`03@000003oool0
oooo0100oooo0T0000030?ooo`03@000003oool0oooo00d0oooo0`000003@00000<0oooo00=00000
0?ooo`3oool0403oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0140oooo0T000003
0?ooo`03@000003oool0oooo00d0oooo0T0000040?ooo`03@000003oool0oooo0080oooo00=00000
0?ooo`3oool0@03oool001@0oooo00<000000?ooo`3oool0LP3oool3000009@0oooo000D0?ooo`03
0000003oool0oooo07<0oooo0`00002C0?ooo`00503oool00`000000oooo0?ooo`1d0?ooo`<00000
E03oool2@00000030?oood000010000000I0000000D0oooo@0000400001000000?ooo`02@00000X0
oooo0T0000000`3ooom00000@0000002@00000030?oood00001000000080oooo0T0000020?ooo`=0
000000<0oooo@000040000000d0000090?ooo`00503oool00`000000oooo0?ooo`1e0?ooo`<00000
DP3oool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo@000003ooom000000?ooo`03@000
00<0oooo00=000000?ooo`3oool0203oool02D000000oooo0?ooo`3ooom000000?oood000000oooo
@00000020?ooo`03@000003oool0oooo00<0oooo00E000000?ooo`3oool0oooo@00000020?ooo`03
@000003oool0oooo00L0oooo000D0?ooolD0000000=000000?ooo`3oool01@3oool00d000000oooo
0?ooo`020?ooo`03@000003oool0oooo0080oooo00E000000?oood00001000000?ooo`03@00000`0
oooo0d0000020?ooo`=000000P3oool00d000000oooo0?ooo`030?ooo`05@000003oool0oooo0?oo
od000000303oool001@0oooo00<000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`05
@000003oool0oooo0?oood000000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo
0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo
0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo
0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`05@000003oool0oooo
0?oood000000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=00000
0?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00A00000
0?ooo`3oool0oooo0P0000040?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3o
ool00d000000oooo0?ooo`020?ooo`05@000003oool0oooo0?oood000000103oool00d000000oooo
0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo
0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo
0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo
0?ooo`050?ooo`03@000003oool0oooo0080oooo0T0000030?ooo`90000000H0oooo@000003ooom0
00000?oood00000<0?ooo`03@000003ooom000000080oooo0T0000030?ooo`03@000003oool0oooo
00<0oooo00A000000?ooo`3oool0oooo0T00000;0?ooo`00503oool00`000000oooo0?ooo`1g0?oo
o`@00000C`3oool00d000000oooo@00000020?ooo`05@000003oool0oooo@000003oool00T000000
1@3ooom000000?ooo`3ooom0000000h0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood0000000`3oool01D000000oooo0?ooo`3ooom000000080oooo00=000000?oo
o`3oool01`3oool001@0oooo00<000000?ooo`3oool0N03oool4000004h0oooo0d0000000`3ooom0
0000@0000005@00000040?oood00001000000?ooo`9000003@3oool2@0000080oooo0T000000103o
oom00000@000003oool3@0000080oooo0d0000000`3ooom00000@0000003@00000T0oooo000D0?oo
o`030000003oool0oooo07T0oooo1000002<0?ooo`00503oool00`000000oooo0?ooo`1k0?ooo`80
0000S03oool001@0oooo00<00000@000003oool0O03oool2000008/0oooo000D0?ooo`030000003o
ool0oooo07`0oooo0`00002:0?ooo`00503oool00`000000oooo0?ooo`1m0?ooo`<00000R@3oool0
01@0oooo00<000000?ooo`3oool0OP3oool3000008P0oooo000D0?ooo`030000003oool0oooo07l0
oooo0`0000270?ooo`00503oool00`000000oooo0?ooo`200?ooo`800000Q`3oool001@0oooo00<0
0000@000003oool0P@3oool2000008H0oooo000D0?ooo`030000003oool0oooo0840oooo10000024
0?ooo`00503oool00`000000oooo0?ooo`220?ooo`@00000P`3oool001@0oooo00<000000?ooo`3o
ool0P`3oool400000880oooo000D0?ooo`030000003oool0oooo08D0oooo0P0000220?ooo`00503o
ool00`00001000000?ooo`260?ooo`800000P@3oool001@0oooo00<000000?ooo`3oool0QP3oool3
00000800oooo000D0?ooo`030000003oool0oooo08L0oooo0`00001o0?ooo`00503oool00`000000
oooo0?ooo`280?ooo`<00000OP3oool001@0oooo00<000000?ooo`3oool0R@3oool3000007d0oooo
000D0?ooo`030000003oool0oooo08X0oooo0`00001l0?ooo`00503oool00`00001000000?ooo`2;
0?ooo`800000O03oool001@0oooo00<000000?ooo`3oool0S03oool2000007/0oooo000D0?ooo`03
0000003oool0oooo08`0oooo1000001i0?ooo`00203oool5@0000080oooo00=000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`2=0?ooo`@00000N03oool000X0oooo00M000000?ooo`3oool0oooo
@000003ooom0000000<0oooo00<000000?ooo`3oool0SP3oool3000007P0oooo000:0?ooo`07@000
003oool0oooo0?oood000000oooo@00000030?ooo`03000004000000oooo0900oooo0P00001g0?oo
o`002P3oool01d000000oooo0?ooo`3ooom000000?oood0000000`3oool00`000000oooo0?ooo`2@
0?ooo`<00000MP3oool000X0oooo00M000000?ooo`3oool0oooo@000003ooom0000000<0oooo00<0
00000?ooo`3oool0T@3oool3000007D0oooo00090?ooo`900000103oool00d000000oooo0?ooo`02
0?ooo`030000003oool0oooo0980oooo0`00001d0?ooo`00503oool00`000000oooo0?ooo`2C0?oo
o`800000M03oool001@0oooo00<000000?ooo`3oool0U03oool2000007<0oooo000D0?ooo`030000
04000000oooo09@0oooo0`00001b0?ooo`00503oool00`000000oooo0?ooo`2E0?ooo`<00000L@3o
ool001@0oooo00<000000?ooo`3oool0UP3oool200000740oooo000D0?ooo`030000003oool0oooo
09L0oooo0`00001_0?ooo`00503oool00`000000oooo0?ooo`2G0?ooo`@00000KP3oool001@0oooo
00<000000?ooo`3oool0V03oool3000006h0oooo000D0?ooo`03000004000000oooo09X0oooo0P00
001]0?ooo`00503oool00`000000oooo0?ooo`2J0?ooo`<00000K03oool001@0oooo00<000000?oo
o`3oool0V`3oool3000006/0oooo000D0?ooo`030000003oool0oooo09`0oooo0`00001Z0?ooo`00
503oool00`000000oooo0?ooo`2M0?ooo`800000JP3oool001@0oooo00<00000@000003oool0WP3o
ool2000006T0oooo000D0?ooo`030000003oool0oooo09h0oooo0`00001X0?ooo`00503oool00`00
0000oooo0?ooo`2O0?ooo`<00000I`3oool001@0oooo00<000000?ooo`3oool0X03oool2000006L0
oooo000D0?ooo`030000003oool0oooo0:40oooo0`00001U0?ooo`00503oool00`000000oooo0?oo
o`2Q0?ooo`@00000I03oool001@0oooo00<00000@000003oool0XP3oool3000006@0oooo000D0?oo
o`030000003oool0oooo0:@0oooo0P00001S0?ooo`00503oool00`000000oooo0?ooo`2T0?ooo`<0
0000HP3oool001@0oooo00<000000?ooo`3oool0Y@3oool300000640oooo00090?ooo`=000000`3o
ool00d000000oooo0?ooo`020?ooo`030000003oool0oooo0:H0oooo0`00001P0?ooo`002@3oool0
0d000000oooo0?ooo`020?ooo`03@000003ooom0000000<0oooo00<000000?ooo`3oool0Y`3oool2
00000600oooo000:0?ooo`07@000003oool0oooo0?oood000000oooo@00000030?ooo`0300000400
0000oooo0:P0oooo0P00001O0?ooo`002P3oool01d000000oooo0?ooo`3ooom000000?oood000000
0`3oool00`000000oooo0?ooo`2X0?ooo`<00000GP3oool000T0oooo00=000000?oood0000000P3o
ool00d000000oooo@00000030?ooo`030000003oool0oooo0:T0oooo0`00001M0?ooo`002P3oool0
0d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00<000000?ooo`3oool0ZP3oool2
000005d0oooo000D0?ooo`030000003oool0oooo0:/0oooo0`00001K0?ooo`00503oool00`000010
00000?ooo`2[0?ooo`@00000FP3oool001@0oooo00<000000?ooo`3oool0[03oool4000005T0oooo
000D0?ooo`030000003oool0oooo0:h0oooo0P00001I0?ooo`00503oool00`000000oooo0?ooo`2_
0?ooo`800000F03oool001@0oooo00<000000?ooo`3oool0[`3oool3000005L0oooo000D0?ooo`03
0000003oool0oooo0;00oooo0`00001F0?ooo`00503oool00`00001000000?ooo`2a0?ooo`<00000
E@3oool001@0oooo00<000000?ooo`3oool0/P3oool3000005@0oooo000D0?ooo`030000003oool0
oooo0;<0oooo0P00001D0?ooo`00503oool00`000000oooo0?ooo`2d0?ooo`800000D`3oool001@0
oooo00<000000?ooo`3oool0]03oool400000540oooo000D0?ooo`030000003oool0oooo0;D0oooo
1000001@0?ooo`00503oool00`00001000000?ooo`2f0?ooo`<00000D03oool001@0oooo00<00000
0?ooo`3oool0^03oool2000004l0oooo000D0?ooo`030000003oool0oooo0;P0oooo0`00001>0?oo
o`00503oool00`000000oooo0?ooo`2i0?ooo`<00000C@3oool001@0oooo00<000000?ooo`3oool0
^P3oool3000004`0oooo000D0?ooo`03000004000000oooo0;/0oooo0P00001<0?ooo`00503oool0
0`000000oooo0?ooo`2l0?ooo`800000B`3oool001@0oooo00<000000?ooo`3oool0_03oool30000
04X0oooo000D0?ooo`030000003oool0oooo0;d0oooo0`0000190?ooo`002@3oool2@00000@0oooo
00=000000?ooo`3oool00P3oool00`000000oooo0?ooo`2n0?ooo`800000B@3oool000/0oooo00I0
00000?ooo`3ooom000000?oood0000030?ooo`030000003oool0oooo0;l0oooo0P0000180?ooo`00
2P3oool01d000000oooo0?ooo`3ooom000000?oood0000000`3oool00`00001000000?ooo`2o0?oo
o`@00000AP3oool000/0oooo00I000000?ooo`3ooom000000?oood0000030?ooo`030000003oool0
oooo0<00oooo0`0000160?ooo`002@3oool00d000000oooo@00000020?ooo`03@000003ooom00000
00<0oooo00<000000?ooo`3oool0o`3oool:0?ooo`002P3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo0080oooo00<000000?ooo`3oool0o`3oool:0?ooo`00503oool00`000000oooo
0?ooo`3o0?ooo`X0oooo000D0?ooo`030000003oool0oooo0?l0oooo2P3oool001@0oooo00=00000
0?ooo`3oool0o`3oool:0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`002@3oool4@00000040?oood0000100000@0000080oooo0d000000103ooom00000@000
003oool2@0000?l0oooo1@3oool000T0oooo00A000000?ooo`3ooom000000P3oool01d000000oooo
0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000003o0?ooo`H0oooo000:0?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`03@0000?l0
oooo1P3oool000/0oooo00E000000?ooo`3oool0oooo@00000040?ooo`04@000003oool0oooo0?oo
o`900000o`3oool70?ooo`002@3oool014000000oooo0?oood0000020?ooo`07@000003oool0oooo
0?oood000000oooo@00000020?ooo`03@000003ooom000000?l0oooo1P3oool000T0oooo14000000
103ooom00000@000040000020?ooo`=0000000@0oooo@00004000000oooo0T00003o0?ooo`D0oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {11.676, -17.5774, 0.406867, 
  0.353849}}],

Cell[OutputFormData["\<\
Graphics[{Thickness[0.015], 
   {Line[{{4.166666666666666*^-6, -10.}, 
      {4.056699157291579, -10.}, {8.480879985937368, -10.}, 
      {12.63593663385385, -10.}, {16.6318407770828, -10.}, 
      {20.88525908229088, -10.}, {24.9795248828114, -10.}, 
      {29.33130484531106, -10.}, {33.52393230312316, -10.}, 
      {37.55740725624772, -10.}, {41.8483963713514, -10.}, 
      {45.98023298176753, -10.}, {49.95291708749613, -10.}, 
      {54.18311535520386, -10.}, {56.12954460089411, -10.}, 
      {58.25416111822403, -10.}, {58.81114343011613, -10.}, 
      {59.40491061331435, -10.}, {59.69342720002801, -10.}, 
      {59.83498527437989, -10.}, {59.96522545560042, -10.}, 
      {60.08389716597674, -9.916102834023256}, 
      {60.20926972532082, -9.790730274679177}, 
      {60.47325989076972, -9.526740109230281}, 
      {62.58272104322332, -7.417278956776669}, 
      {66.56975592134719, -3.430244078652805}, 
      {70.81430496145019, 0.8143049614501904}, 
      {74.89970149686563, 4.899701496865631}, 
      {79.2426121942602, 9.242612194260203}, 
      {83.42637038696722, 13.42637038696722}, 
      {87.45097607498669, 17.45097607498669}, 
      {91.73309592498529, 21.7330959249853}, 
      {95.85606327029635, 25.85606327029636}, 
      {99.81987811091986, 29.81987811091987}, 
      {99.99999583333332, 29.99999583333332}}]}}, 
  {DisplayFunction -> (Display[$Display, #1] & ), 
   PlotRange -> {{20, 100}, {-11, 32}}, PlotRange -> All, 
   AspectRatio -> GoldenRatio^(-1), 
   DisplayFunction :> Identity, ColorOutput -> Automatic, 
   Axes -> Automatic, AxesOrigin -> Automatic, 
   PlotLabel -> None, AxesLabel -> {\"CENA AKCIE\", \"ZISK\"}, 
   Ticks -> Automatic, GridLines -> None, Prolog -> {}, 
   Epilog -> {}, AxesStyle -> Automatic, 
   Background -> Automatic, DefaultColor -> Automatic, 
   DefaultFont :> $DefaultFont, RotateLabel -> True, 
   Frame -> False, FrameStyle -> Automatic, 
   FrameTicks -> Automatic, FrameLabel -> None, 
   PlotRegion -> Automatic, ImageSize -> Automatic, 
   TextStyle :> $TextStyle, FormatType :> $FormatType}]\
\>", "\<\
-Graphics-\
\>"], "Output"]
}, Open  ]],

Cell[TextData[
"\"OBR.4\nZisk z eur\[OAcute]pskej put opcie v long poz\[IAcute]cii, ak \
expira\[CHacek]n\[AAcute] cena je 60 a cena opcie je 10\""], "Text"],

Cell[CellGroupData[{

Cell["\<\
p:=10;
g=Plot[-p+Max[60-S,0],{S,0,100},PlotRange->All,AxesLabel->
{\"CENA AKCIE\",\"ZISK\"},PlotStyle -> 
{Thickness[0.015]}, DisplayFunction->Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->
{{20,100},{-11,32}}]\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.25 0.0125 0.158102 0.0143729 [
[.125 .1456 -6 -9 ]
[.125 .1456 6 0 ]
[.25 .1456 -6 -9 ]
[.25 .1456 6 0 ]
[.375 .1456 -6 -9 ]
[.375 .1456 6 0 ]
[.5 .1456 -6 -9 ]
[.5 .1456 6 0 ]
[.625 .1456 -6 -9 ]
[.625 .1456 6 0 ]
[.75 .1456 -6 -9 ]
[.75 .1456 6 0 ]
[.875 .1456 -6 -9 ]
[.875 .1456 6 0 ]
[1 .1456 -9 -9 ]
[1 .1456 9 0 ]
[1.025 .1581 0 -7.5 ]
[1.025 .1581 65 7.5 ]
[-0.0125 .01437 -18 -4.5 ]
[-0.0125 .01437 0 4.5 ]
[-0.0125 .30183 -12 -4.5 ]
[-0.0125 .30183 0 4.5 ]
[-0.0125 .44556 -12 -4.5 ]
[-0.0125 .44556 0 4.5 ]
[-0.0125 .58929 -12 -4.5 ]
[-0.0125 .58929 0 4.5 ]
[0 .64303 -14 0 ]
[0 .64303 14 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.125 .1581 m
.125 .16435 L
s
[(30)] .125 .1456 0 1 Mshowa
.25 .1581 m
.25 .16435 L
s
[(40)] .25 .1456 0 1 Mshowa
.375 .1581 m
.375 .16435 L
s
[(50)] .375 .1456 0 1 Mshowa
.5 .1581 m
.5 .16435 L
s
[(60)] .5 .1456 0 1 Mshowa
.625 .1581 m
.625 .16435 L
s
[(70)] .625 .1456 0 1 Mshowa
.75 .1581 m
.75 .16435 L
s
[(80)] .75 .1456 0 1 Mshowa
.875 .1581 m
.875 .16435 L
s
[(90)] .875 .1456 0 1 Mshowa
1 .1581 m
1 .16435 L
s
[(100)] 1 .1456 0 1 Mshowa
.125 Mabswid
.025 .1581 m
.025 .16185 L
s
.05 .1581 m
.05 .16185 L
s
.075 .1581 m
.075 .16185 L
s
.1 .1581 m
.1 .16185 L
s
.15 .1581 m
.15 .16185 L
s
.175 .1581 m
.175 .16185 L
s
.2 .1581 m
.2 .16185 L
s
.225 .1581 m
.225 .16185 L
s
.275 .1581 m
.275 .16185 L
s
.3 .1581 m
.3 .16185 L
s
.325 .1581 m
.325 .16185 L
s
.35 .1581 m
.35 .16185 L
s
.4 .1581 m
.4 .16185 L
s
.425 .1581 m
.425 .16185 L
s
.45 .1581 m
.45 .16185 L
s
.475 .1581 m
.475 .16185 L
s
.525 .1581 m
.525 .16185 L
s
.55 .1581 m
.55 .16185 L
s
.575 .1581 m
.575 .16185 L
s
.6 .1581 m
.6 .16185 L
s
.65 .1581 m
.65 .16185 L
s
.675 .1581 m
.675 .16185 L
s
.7 .1581 m
.7 .16185 L
s
.725 .1581 m
.725 .16185 L
s
.775 .1581 m
.775 .16185 L
s
.8 .1581 m
.8 .16185 L
s
.825 .1581 m
.825 .16185 L
s
.85 .1581 m
.85 .16185 L
s
.9 .1581 m
.9 .16185 L
s
.925 .1581 m
.925 .16185 L
s
.95 .1581 m
.95 .16185 L
s
.975 .1581 m
.975 .16185 L
s
.25 Mabswid
0 .1581 m
1 .1581 L
s
gsave
1.025 .1581 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CENA) show
93.437500 14.437500 moveto
(AKCIE) show
123.437500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .01437 m
.00625 .01437 L
s
[(-10)] -0.0125 .01437 1 0 Mshowa
0 .30183 m
.00625 .30183 L
s
[(10)] -0.0125 .30183 1 0 Mshowa
0 .44556 m
.00625 .44556 L
s
[(20)] -0.0125 .44556 1 0 Mshowa
0 .58929 m
.00625 .58929 L
s
[(30)] -0.0125 .58929 1 0 Mshowa
.125 Mabswid
0 .04312 m
.00375 .04312 L
s
0 .07186 m
.00375 .07186 L
s
0 .10061 m
.00375 .10061 L
s
0 .12936 m
.00375 .12936 L
s
0 .18685 m
.00375 .18685 L
s
0 .21559 m
.00375 .21559 L
s
0 .24434 m
.00375 .24434 L
s
0 .27308 m
.00375 .27308 L
s
0 .33058 m
.00375 .33058 L
s
0 .35932 m
.00375 .35932 L
s
0 .38807 m
.00375 .38807 L
s
0 .41681 m
.00375 .41681 L
s
0 .47431 m
.00375 .47431 L
s
0 .50305 m
.00375 .50305 L
s
0 .5318 m
.00375 .5318 L
s
0 .56054 m
.00375 .56054 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(ZISK) show
87.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.015 w
0 .58929 m
.01107 .57656 L
.06224 .51772 L
.11664 .45517 L
.16905 .39491 L
.21947 .33694 L
.2731 .27526 L
.32475 .21588 L
.37441 .15878 L
.42729 .09798 L
.47818 .03947 L
.49144 .02422 L
.49507 .02004 L
.49707 .01774 L
.49805 .01662 L
.49895 .01558 L
.4998 .0146 L
.5007 .01437 L
.50161 .01437 L
.5026 .01437 L
.50592 .01437 L
.53228 .01437 L
.58534 .01437 L
.63641 .01437 L
.69069 .01437 L
.74299 .01437 L
.7933 .01437 L
.84683 .01437 L
.89836 .01437 L
.94791 .01437 L
1 .01437 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00503oool00`000000oooo0?ooo`3o0?ooo`X0oooo
00080?ooo`E000000P3oool00d000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0oooo2P3o
ool000X0oooo00M000000?ooo`3oool0oooo@000003ooom0000000<0oooo00<000000?ooo`3oool0
o`3oool:0?ooo`00103oool3@00000<0oooo00M000000?ooo`3oool0oooo@000003ooom0000000<0
oooo00<00000@000003oool0GP3ooomU000004H0oooo000:0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000030?ooo`030000003oool0oooo05d0ooooIP0000160?ooo`002P3oool01d000000
oooo0?ooo`3ooom000000?oood0000000`3oool00`000000oooo0?ooo`1L0?ooo`@00000Z@3oool0
00T0oooo0T0000040?ooo`03@000003oool0oooo0080oooo00<000000?ooo`3oool0G03oool30000
0:X0oooo000D0?ooo`030000003oool0oooo05X0oooo0`00002/0?ooo`00503oool00`000000oooo
0?ooo`1I0?ooo`@00000[03oool001@0oooo00<00000@000003oool0F03oool400000:d0oooo000D
0?ooo`030000003oool0oooo05P0oooo0P00002_0?ooo`00503oool00`000000oooo0?ooo`1G0?oo
o`800000/03oool001@0oooo00<000000?ooo`3oool0EP3oool300000;00oooo000D0?ooo`030000
003oool0oooo05D0oooo0`00002a0?ooo`00503oool00`00001000000?ooo`1D0?ooo`<00000/P3o
ool001@0oooo00<000000?ooo`3oool0D`3oool300000;<0oooo000D0?ooo`030000003oool0oooo
05<0oooo0P00002d0?ooo`00503oool00`000000oooo0?ooo`1B0?ooo`800000]@3oool001@0oooo
00<000000?ooo`3oool0D03oool400000;D0oooo000D0?ooo`030000003oool0oooo04l0oooo1000
002f0?ooo`00503oool00`00001000000?ooo`1?0?ooo`<00000]`3oool001@0oooo00<000000?oo
o`3oool04P3oool2@00000@0oooo00=000000?ooo`3oool0403oool3@0000080oooo00=000000?oo
o`3oool04@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo0P00000;0?oo
o`900000103oool00d000000oooo0?ooo`0A0?ooo`03@000003oool0oooo0080oooo00=000000?oo
o`3oool0403oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0100oooo0T0000040?oo
o`03@000003oool0oooo00`0oooo1D0000020?ooo`03@000003oool0oooo0080oooo00=000000?oo
o`3oool0@03oool001@0oooo00<000000?ooo`3oool0503oool01T000000oooo0?oood000000oooo
@0000180oooo00I000000?ooo`3ooom000000?oood00000A0?ooo`03@000003ooom000000080oooo
00=000000?oood0000000P3oool3000000/0oooo00=000000?oood0000000P3oool00d000000oooo
@000000B0?ooo`07@000003oool0oooo0?oood000000oooo@000000@0?ooo`03@000003ooom00000
0080oooo00=000000?oood0000004`3oool01T000000oooo0?oood000000oooo@00000l0oooo00M0
00000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000@@3oool001@0oooo
00<000000?ooo`3oool04`3oool01d000000oooo0?ooo`3ooom000000?oood000000403oool4@000
00040?oood000000oooo@00001<0oooo00M000000?ooo`3ooom000000?oood000000oooo00<00000
303oool00d000000oooo@00000020?ooo`03@000003ooom000000180oooo00M000000?ooo`3oool0
oooo@000003ooom000000100oooo00=000000?oood0000000P3oool00d000000oooo@000000B0?oo
o`9000000P3oool00d000000oooo@000000?0?ooo`07@000003oool0oooo0?oood000000oooo@000
00020?ooo`03@000003ooom000000440oooo000D0?ooo`030000003oool0oooo01@0oooo00I00000
0?ooo`3ooom000000?oood00000@0?ooo`03@000003ooom000000080oooo00=000000?oood000000
4@3oool2@00000<0oooo00A000000?oood000000oooo0P00000=0?ooo`9000000`3oool00d000000
oooo@000000C0?ooo`06@000003oool0oooo@000003ooom000004@3oool01d000000oooo0?ooo`3o
oom000000?oood0000004@3oool00d000000oooo@00000020?ooo`03@000003ooom0000000l0oooo
00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000@@3oool001@0
oooo00<000000?ooo`3oool04P3oool00d000000oooo@00000020?ooo`03@000003ooom000000140
oooo0T0000020?ooo`03@000003ooom000000140oooo00=000000?ooo`3oool00P3oool00d000000
oooo@0000002000000h0oooo00=000000?ooo`3oool00P3oool00d000000oooo@000000A0?ooo`03
@000003ooom000000080oooo00=000000?oood000000403oool00d000000oooo@00000020?ooo`03
@000003ooom000000140oooo00=000000?oood0000000P3oool00d000000oooo@000000?0?ooo`07
@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom000000440oooo000D0?oo
o`03000004000000oooo01<0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0A0?oo
o`05@000003oool0oooo0?oood0000004P3oool3@00000<0oooo00A0000000000000000000003`3o
ool2@00000<0oooo00=000000?ooo`3oool0403oool3@00000<0oooo00=000000?ooo`3oool0403o
ool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0140oooo0T0000030?ooo`03@000003o
ool0oooo00d0oooo0T0000040?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0@03o
ool001@0oooo00<000000?ooo`3oool0B@3oool300000;d0oooo000D0?ooo`030000003oool0oooo
04P0oooo0`00002n0?ooo`00503oool00`000000oooo0?ooo`180?ooo`800000P@3oool2@0000003
0?oood000010000000I0000000D0oooo@0000400001000000?ooo`02@00000X0oooo0T0000000`3o
oom00000@0000002@00000030?oood00001000000080oooo0T0000020?ooo`=0000000<0oooo@000
040000000d0000090?ooo`00503oool00`000000oooo0?ooo`160?ooo`<00000P@3oool00d000000
oooo0?ooo`020?ooo`07@000003oool0oooo@000003ooom000000?ooo`03@00000<0oooo00=00000
0?ooo`3oool0203oool02D000000oooo0?ooo`3ooom000000?oood000000oooo@00000020?ooo`03
@000003oool0oooo00<0oooo00E000000?ooo`3oool0oooo@00000020?ooo`03@000003oool0oooo
00L0oooo000D0?ooolD0000000=000000?ooo`3oool01@3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo0080oooo00E000000?oood00001000000?ooo`03@00000`0oooo0d0000020?oo
o`=000000P3oool00d000000oooo0?ooo`030?ooo`05@000003oool0oooo0?oood000000303oool0
01@0oooo00<000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo
0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`05@000003oool0oooo
0?oood000000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=00000
0?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=00000
0?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00<00000103oool0
0d000000oooo0?ooo`020?ooo`05@000003oool0oooo0?oood000000103oool00d000000oooo0?oo
o`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`020?ooo`05@000003oool0oooo0?oood000000103oool00d000000oooo0?ooo`020?ooo`03@000
003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000
003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000
003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`050?ooo`03@000
003oool0oooo0080oooo0T0000030?ooo`90000000H0oooo@000003ooom000000?oood00000<0?oo
o`03@000003ooom000000080oooo0T0000030?ooo`03@000003oool0oooo00<0oooo00A000000?oo
o`3oool0oooo0T00000;0?ooo`00503oool00`000000oooo0?ooo`140?ooo`800000Q03oool00d00
0000oooo@00000020?ooo`05@000003oool0oooo@000003oool00T0000001@3ooom000000?ooo`3o
oom0000000h0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood00
00000`3oool01D000000oooo0?ooo`3ooom000000080oooo00=000000?ooo`3oool01`3oool001@0
oooo00<000000?ooo`3oool0@`3oool3000008@0oooo0d0000000`3ooom00000@0000005@0000004
0?oood00001000000?ooo`9000003@3oool2@0000080oooo0T000000103ooom00000@000003oool3
@0000080oooo0d0000000`3ooom00000@0000003@00000T0oooo000D0?ooo`030000003oool0oooo
0480oooo0`0000340?ooo`00503oool00`000000oooo0?ooo`120?ooo`800000a@3oool001@0oooo
00<00000@000003oool0@@3oool200000<H0oooo000D0?ooo`030000003oool0oooo0400oooo0`00
00360?ooo`00503oool00`000000oooo0?ooo`0o0?ooo`<00000a`3oool001@0oooo00<000000?oo
o`3oool0?P3oool300000<P0oooo000D0?ooo`030000003oool0oooo03h0oooo0P0000390?ooo`00
503oool00`000000oooo0?ooo`0l0?ooo`<00000bP3oool001@0oooo00<00000@000003oool0>`3o
ool400000<X0oooo000D0?ooo`030000003oool0oooo03X0oooo1000003;0?ooo`00503oool00`00
0000oooo0?ooo`0j0?ooo`800000c@3oool001@0oooo00<000000?ooo`3oool0>@3oool200000<h0
oooo000D0?ooo`030000003oool0oooo03P0oooo0`00003>0?ooo`00503oool00`00001000000?oo
o`0g0?ooo`<00000c`3oool001@0oooo00<000000?ooo`3oool0=P3oool300000=00oooo000D0?oo
o`030000003oool0oooo03D0oooo0`00003A0?ooo`00503oool00`000000oooo0?ooo`0e0?ooo`80
0000dP3oool001@0oooo00<000000?ooo`3oool0=03oool200000=<0oooo000D0?ooo`030000003o
ool0oooo0380oooo1000003C0?ooo`00503oool00`00001000000?ooo`0a0?ooo`@00000e03oool0
01@0oooo00<000000?ooo`3oool0<03oool400000=D0oooo000D0?ooo`030000003oool0oooo0300
oooo0P00003G0?ooo`00203oool5@0000080oooo00=000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0_0?ooo`800000f03oool000X0oooo00M000000?ooo`3oool0oooo@000003ooom0000000<0
oooo00<000000?ooo`3oool0;P3oool300000=P0oooo000:0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000030?ooo`03000004000000oooo02d0oooo0`00003I0?ooo`002P3oool01d000000
oooo0?ooo`3ooom000000?oood0000000`3oool00`000000oooo0?ooo`0/0?ooo`<00000fP3oool0
00X0oooo00M000000?ooo`3oool0oooo@000003ooom0000000<0oooo00<000000?ooo`3oool0:`3o
ool300000=/0oooo00090?ooo`900000103oool00d000000oooo0?ooo`020?ooo`030000003oool0
oooo02X0oooo0`00003L0?ooo`00503oool00`000000oooo0?ooo`0Z0?ooo`800000g@3oool001@0
oooo00<000000?ooo`3oool0:@3oool200000=h0oooo000D0?ooo`03000004000000oooo02L0oooo
1000003N0?ooo`00503oool00`000000oooo0?ooo`0V0?ooo`@00000g`3oool001@0oooo00<00000
0?ooo`3oool09P3oool300000>00oooo000D0?ooo`030000003oool0oooo02D0oooo0P00003R0?oo
o`00503oool00`000000oooo0?ooo`0T0?ooo`<00000hP3oool001@0oooo00<000000?ooo`3oool0
8`3oool300000><0oooo000D0?ooo`03000004000000oooo02<0oooo0P00003T0?ooo`00503oool0
0`000000oooo0?ooo`0R0?ooo`800000i@3oool001@0oooo00<000000?ooo`3oool08@3oool30000
0>D0oooo000D0?ooo`030000003oool0oooo0200oooo0`00003V0?ooo`00503oool00`000000oooo
0?ooo`0O0?ooo`<00000i`3oool001@0oooo00<00000@000003oool07`3oool200000>P0oooo000D
0?ooo`030000003oool0oooo01d0oooo0`00003Y0?ooo`00503oool00`000000oooo0?ooo`0L0?oo
o`@00000j@3oool001@0oooo00<000000?ooo`3oool0703oool300000>X0oooo000D0?ooo`030000
003oool0oooo01/0oooo0P00003/0?ooo`00503oool00`000000oooo0?ooo`0J0?ooo`<00000k03o
ool001@0oooo00<00000@000003oool06@3oool300000>d0oooo000D0?ooo`030000003oool0oooo
01T0oooo0P00003^0?ooo`00503oool00`000000oooo0?ooo`0H0?ooo`800000k`3oool001@0oooo
00<000000?ooo`3oool05`3oool300000>l0oooo00090?ooo`=000000`3oool00d000000oooo0?oo
o`020?ooo`030000003oool0oooo01H0oooo0`00003`0?ooo`002@3oool00d000000oooo0?ooo`02
0?ooo`03@000003ooom0000000<0oooo00<000000?ooo`3oool05@3oool300000?40oooo000:0?oo
o`07@000003oool0oooo0?oood000000oooo@00000030?ooo`03000004000000oooo01D0oooo0P00
003b0?ooo`002P3oool01d000000oooo0?ooo`3ooom000000?oood0000000`3oool00`000000oooo
0?ooo`0C0?ooo`<00000l`3oool000T0oooo00=000000?oood0000000P3oool00d000000oooo@000
00030?ooo`030000003oool0oooo0180oooo1000003c0?ooo`002P3oool00d000000oooo0?ooo`02
0?ooo`03@000003oool0oooo0080oooo00<000000?ooo`3oool04@3oool400000?@0oooo000D0?oo
o`030000003oool0oooo0140oooo0P00003f0?ooo`00503oool00`00001000000?ooo`0@0?ooo`80
0000m`3oool001@0oooo00<000000?ooo`3oool03`3oool300000?L0oooo000D0?ooo`030000003o
ool0oooo00h0oooo0`00003h0?ooo`00503oool00`000000oooo0?ooo`0=0?ooo`<00000n@3oool0
01@0oooo00<000000?ooo`3oool0303oool300000?X0oooo000D0?ooo`030000003oool0oooo00/0
oooo0`00003k0?ooo`00503oool00`00001000000?ooo`0;0?ooo`800000o03oool001@0oooo00<0
00000?ooo`3oool02P3oool200000?d0oooo000D0?ooo`030000003oool0oooo00P0oooo1000003m
0?ooo`00503oool00`000000oooo0?ooo`070?ooo`@00000oP3oool001@0oooo00<000000?ooo`3o
ool01`3oool300000?l0oooo000D0?ooo`030000003oool0oooo00H0oooo0P00003o0?ooo`80oooo
000D0?ooo`03000004000000oooo00D0oooo0`00003o0?ooo`80oooo000D0?ooo`030000003oool0
oooo00@0oooo0`00003o0?ooo`<0oooo000D0?ooo`030000003oool0oooo00@0oooo0P00003o0?oo
o`@0oooo000D0?ooo`030000003oool0oooo00<0oooo0P00003o0?ooo`D0oooo000D0?ooo`030000
003oool0oooo0080oooo0`00003o0?ooo`D0oooo000D0?ooo`04000004000000oooo0?ooo`<00000
o`3oool60?ooo`00503oool00`000000oooo0?ooo`0300000?l0oooo1`3oool001@0oooo00<00000
0?ooo`3oool00P00003o0?ooo`P0oooo000D0?ooo`@00000o`3oool90?ooo`002@3oool2@00000@0
oooo00=000000?ooo`3oool00P3oool400000?l0oooo2@3oool000/0oooo00I000000?ooo`3ooom0
00000?oood0000030?ooo`<00000o`3oool:0?ooo`002P3oool01d000000oooo0?ooo`3ooom00000
0?oood0000000P3oool300000?l0oooo2`3oool000/0oooo00I000000?ooo`3ooom000000?oood00
00030?ooo`030000003oool0oooo0?l0oooo2P3oool000T0oooo00=000000?oood0000000P3oool0
0d000000oooo@00000030?ooo`030000003oool0oooo0?l0oooo2P3oool000X0oooo00=000000?oo
o`3oool00P3oool00d000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0oooo2P3oool001@0
oooo00<000000?ooo`3oool0o`3oool:0?ooo`00503oool00`000000oooo0?ooo`3o0?ooo`X0oooo
000D0?ooo`03@000003oool0oooo0?l0oooo2P3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool000T0oooo14000000103ooom00000@000040000020?ooo`=00000
00@0oooo@00004000000oooo0T00003o0?ooo`D0oooo00090?ooo`04@000003oool0oooo@0000080
oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000o`3oool6
0?ooo`002P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00<0oooo00=000000?oo
o`3oool00d00003o0?ooo`H0oooo000;0?ooo`05@000003oool0oooo0?oood000000103oool01400
0000oooo0?ooo`3oool2@0000?l0oooo1`3oool000T0oooo00A000000?ooo`3ooom000000P3oool0
1d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000003o0?ooo`H0oooo
00090?ooo`A0000000@0oooo@0000400001000000P3oool3@00000040?oood00001000000?ooo`90
0000o`3oool50?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {11.676, -17.5774, 0.406867, 
  0.353849}}],

Cell[OutputFormData["\<\
Graphics[{Thickness[0.015], 
   {Line[{{4.166666666666666*^-6, 49.99999583333333}, 
      {4.056699157291579, 45.94330084270842}, 
      {8.480879985937368, 41.51912001406262}, 
      {12.63593663385385, 37.36406336614614}, 
      {16.6318407770828, 33.36815922291719}, 
      {20.88525908229088, 29.11474091770911}, 
      {24.9795248828114, 25.02047511718859}, 
      {29.33130484531106, 20.66869515468893}, 
      {33.52393230312316, 16.47606769687683}, 
      {37.55740725624772, 12.44259274375227}, 
      {41.8483963713514, 8.151603628648594}, 
      {45.98023298176753, 4.019767018232457}, 
      {49.95291708749613, 0.04708291250386054}, 
      {54.18311535520386, -4.18311535520386}, 
      {58.25416111822403, -8.254161118224033}, 
      {59.31514618235505, -9.315146182355057}, 
      {59.60582673192192, -9.605826731921922}, 
      {59.76538871273101, -9.765388712731009}, 
      {59.84367636683222, -9.843676366832227}, 
      {59.91570474320114, -9.915704743201139}, 
      {59.98401104101897, -9.984011041018973}, 
      {60.05617428320688, -10.}, {60.12861230349221, -10.}, 
      {60.20812448940978, -10.}, {60.47325989076972, -10.}, 
      {62.58272104322332, -10.}, {66.82727008332632, -10.}, 
      {70.91266661874176, -10.}, {75.25557731613633, -10.}, 
      {79.43933550884335, -10.}, {83.46394119686284, -10.}, 
      {87.74606104686144, -10.}, {91.8690283921725, -10.}, 
      {95.83284323279601, -10.}, {99.99999583333332, -10.}}]}}, 
  {DisplayFunction -> (Display[$Display, #1] & ), 
   PlotRange -> {{20, 100}, {-11, 32}}, PlotRange -> All, 
   AspectRatio -> GoldenRatio^(-1), 
   DisplayFunction :> Identity, ColorOutput -> Automatic, 
   Axes -> Automatic, AxesOrigin -> Automatic, 
   PlotLabel -> None, AxesLabel -> {\"CENA AKCIE\", \"ZISK\"}, 
   Ticks -> Automatic, GridLines -> None, Prolog -> {}, 
   Epilog -> {}, AxesStyle -> Automatic, 
   Background -> Automatic, DefaultColor -> Automatic, 
   DefaultFont :> $DefaultFont, RotateLabel -> True, 
   Frame -> False, FrameStyle -> Automatic, 
   FrameTicks -> Automatic, FrameLabel -> None, 
   PlotRegion -> Automatic, ImageSize -> Automatic, 
   TextStyle :> $TextStyle, FormatType :> $FormatType}]\
\>", "\<\
-Graphics-\
\>"], "Output"]
}, Open  ]],

Cell["\<\
\"OBR.5
Eur\[OAcute]pska call opcia c \
\>", "Text"],

Cell[CellGroupData[{

Cell["\<\
X:=60;
sigma:=0.29;
r:=0.04;
DD:=0.;
Plot3D[EuropeanCallDiv[S,X,sigma,r,DD,tau],{S,1,100},{tau,0.001,0.6},
PlotRange->All,AxesLabel->
{\"CENA AKCIE\",\"\\[CapitalCHacek]AS DO EXPIR\[CapitalAAcute]CIE\",\"CENA \
OPCIE\"}];

\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
5.55112e-017 1.04977 -0.0679587 1.04977 [
[.14109 .2015 -11.9442 -9 ]
[.14109 .2015 .05581 0 ]
[.26628 .15225 -11.4388 -9 ]
[.26628 .15225 .56124 0 ]
[.39776 .10054 -10.9333 -9 ]
[.39776 .10054 1.06668 0 ]
[.53601 .04619 -10.4279 -9 ]
[.53601 .04619 1.57211 0 ]
[.68156 -0.01098 -14.8837 -9 ]
[.68156 -0.01098 3.11632 0 ]
[.29165 .07573 -60.5226 -15 ]
[.29165 .07573 4.4774 0 ]
[.80816 .15937 0 -6.10166 ]
[.80816 .15937 18 2.89834 ]
[.90104 .30161 0 -5.96742 ]
[.90104 .30161 18 3.03258 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 100 4.94788 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01599 .31604 -12 -2.78538 ]
[.01599 .31604 0 6.21462 ]
[.00759 .36869 -12 -2.83004 ]
[.00759 .36869 0 6.16996 ]
[-0.0011 .42314 -12 -2.87638 ]
[-0.0011 .42314 0 6.12362 ]
[-0.01009 .47949 -12 -2.92452 ]
[-0.01009 .47949 0 6.07548 ]
[-0.05457 .39542 -65 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.03716 .25514 m
.68874 0 L
s
.15032 .21083 m
.15494 .21549 L
s
[(20)] .14109 .2015 .9907 1 Mshowa
.2751 .16197 m
.2795 .16683 L
s
[(40)] .26628 .15225 .90646 1 Mshowa
.4061 .11067 m
.41026 .11574 L
s
[(60)] .39776 .10054 .82222 1 Mshowa
.5438 .05675 m
.5477 .06203 L
s
[(80)] .53601 .04619 .73798 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(100)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06057 .24597 m
.06342 .24868 L
s
.09013 .23439 m
.09296 .23713 L
s
.12005 .22268 m
.12285 .22545 L
s
.18096 .19883 m
.1837 .20166 L
s
.21196 .18669 m
.21467 .18955 L
s
.24334 .17441 m
.24601 .17729 L
s
.30724 .14938 m
.30985 .15233 L
s
.33979 .13664 m
.34236 .13962 L
s
.37274 .12374 m
.37527 .12675 L
s
.43987 .09745 m
.44233 .10052 L
s
.47408 .08405 m
.4765 .08716 L
s
.50872 .07049 m
.5111 .07363 L
s
.57933 .04284 m
.58163 .04604 L
s
.61533 .02874 m
.61758 .03198 L
s
.65179 .01447 m
.654 .01773 L
s
gsave
.29165 .07573 -121.523 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CENA) show
93.437500 14.437500 moveto
(AKCIE) show
123.437500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.7958 .16377 m
.78962 .16597 L
s
[(0.2)] .80816 .15937 -1 .35593 Mshowa
.88857 .30567 m
.88233 .30771 L
s
[(0.4)] .90104 .30161 -1 .32609 Mshowa
.125 Mabswid
.71665 .0427 m
.71298 .04411 L
s
.74405 .08461 m
.74036 .08599 L
s
.77041 .12494 m
.76672 .12629 L
s
.82026 .20118 m
.81654 .20248 L
s
.84384 .23726 m
.84012 .23853 L
s
.8666 .27207 m
.86286 .27331 L
s
.90979 .33814 m
.90604 .33934 L
s
.93031 .36952 m
.92655 .37069 L
s
.95015 .39987 m
.94638 .40102 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(\\310AS) show
87.000000 14.437500 moveto
(DO) show
105.000000 14.437500 moveto
(EXPIR\\301CIE) show
159.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02825 .31137 m
.03438 .30904 L
s
[(10)] .01599 .31604 1 -0.38103 Mshowa
.01989 .36413 m
.02604 .36184 L
s
[(20)] .00759 .36869 1 -0.3711 Mshowa
.01124 .41869 m
.01741 .41646 L
s
[(30)] -0.0011 .42314 1 -0.3608 Mshowa
.00229 .47515 m
.00849 .47298 L
s
[(40)] -0.01009 .47949 1 -0.35011 Mshowa
.125 Mabswid
.03474 .27041 m
.03841 .26898 L
s
.03313 .28055 m
.0368 .27913 L
s
.03152 .29075 m
.03519 .28934 L
s
.02989 .30103 m
.03356 .29962 L
s
.0266 .32178 m
.03028 .32039 L
s
.02494 .33226 m
.02862 .33087 L
s
.02327 .34281 m
.02695 .34143 L
s
.02158 .35343 m
.02527 .35206 L
s
.01818 .37489 m
.02188 .37353 L
s
.01646 .38573 m
.02016 .38437 L
s
.01474 .39664 m
.01843 .39529 L
s
.01299 .40763 m
.0167 .40628 L
s
.00948 .42983 m
.01318 .4285 L
s
.0077 .44104 m
.01141 .43972 L
s
.00591 .45233 m
.00962 .45102 L
s
.00411 .4637 m
.00782 .46239 L
s
.00047 .48668 m
.00419 .48539 L
s
gsave
-0.05457 .39542 -126 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CENA) show
93.250000 14.437500 moveto
(OPCIE) show
123.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.664 .741 .908 r
.38313 .58323 .40512 .60371 .44189 .59268 .42021 .57192 Metetra
.664 .741 .908 r
.42021 .57192 .44189 .59268 .47916 .5815 .45781 .56045 Metetra
.664 .741 .908 r
.45781 .56045 .47916 .5815 .51695 .57017 .49594 .54882 Metetra
.663 .741 .908 r
.49594 .54882 .51695 .57017 .55526 .55868 .5346 .53703 Metetra
.661 .741 .909 r
.5346 .53703 .55526 .55868 .59412 .54731 .57383 .52528 Metetra
.647 .735 .914 r
.57383 .52528 .59412 .54731 .63359 .53745 .61365 .51485 Metetra
.6 .716 .926 r
.61365 .51485 .63359 .53745 .67388 .53199 .65427 .50869 Metetra
.508 .673 .938 r
.65427 .50869 .67388 .53199 .7153 .53347 .696 .50959 Metetra
.391 .61 .937 r
.696 .50959 .7153 .53347 .75818 .54231 .73918 .51815 Metetra
.284 .548 .923 r
.73918 .51815 .75818 .54231 .80272 .55723 .78403 .53303 Metetra
.21 .504 .907 r
.78403 .53303 .80272 .55723 .84903 .57644 .83068 .55228 Metetra
.167 .478 .896 r
.83068 .55228 .84903 .57644 .89718 .59848 .8792 .57436 Metetra
.146 .465 .89 r
.8792 .57436 .89718 .59848 .94722 .62242 .92964 .59831 Metetra
.136 .459 .888 r
.92964 .59831 .94722 .62242 .99922 .6478 .98208 .62367 Metetra
.664 .741 .908 r
.36056 .56222 .38313 .58323 .42021 .57192 .39797 .55062 Metetra
.664 .741 .908 r
.39797 .55062 .42021 .57192 .45781 .56045 .4359 .53885 Metetra
.664 .741 .908 r
.4359 .53885 .45781 .56045 .49594 .54882 .47438 .52691 Metetra
.664 .741 .908 r
.47438 .52691 .49594 .54882 .5346 .53703 .5134 .51481 Metetra
.662 .741 .908 r
.5134 .51481 .5346 .53703 .57383 .52528 .55299 .50268 Metetra
.65 .736 .913 r
.55299 .50268 .57383 .52528 .61365 .51485 .59318 .49168 Metetra
.605 .718 .925 r
.59318 .49168 .61365 .51485 .65427 .50869 .63414 .48476 Metetra
.514 .675 .937 r
.63414 .48476 .65427 .50869 .696 .50959 .67618 .48504 Metetra
.393 .611 .937 r
.67618 .48504 .696 .50959 .73918 .51815 .71967 .4933 Metetra
.282 .547 .922 r
.71967 .4933 .73918 .51815 .78403 .53303 .76484 .50814 Metetra
.206 .501 .906 r
.76484 .50814 .78403 .53303 .83068 .55228 .81182 .52744 Metetra
.164 .476 .895 r
.81182 .52744 .83068 .55228 .8792 .57436 .8607 .54956 Metetra
.143 .464 .89 r
.8607 .54956 .8792 .57436 .92964 .59831 .91154 .57351 Metetra
.134 .459 .887 r
.91154 .57351 .92964 .59831 .98208 .62367 .96442 .59882 Metetra
.664 .741 .908 r
.33741 .54067 .36056 .56222 .39797 .55062 .37515 .52876 Metetra
.664 .741 .908 r
.37515 .52876 .39797 .55062 .4359 .53885 .41342 .51668 Metetra
.664 .741 .908 r
.41342 .51668 .4359 .53885 .47438 .52691 .45224 .50442 Metetra
.664 .741 .908 r
.45224 .50442 .47438 .52691 .5134 .51481 .49163 .49199 Metetra
.663 .741 .908 r
.49163 .49199 .5134 .51481 .55299 .50268 .53159 .47948 Metetra
.652 .737 .912 r
.53159 .47948 .55299 .50268 .59318 .49168 .57216 .46789 Metetra
.61 .72 .923 r
.57216 .46789 .59318 .49168 .63414 .48476 .61347 .46018 Metetra
.519 .678 .937 r
.61347 .46018 .63414 .48476 .67618 .48504 .65583 .45978 Metetra
.394 .611 .937 r
.65583 .45978 .67618 .48504 .71967 .4933 .69962 .46774 Metetra
.279 .545 .921 r
.69962 .46774 .71967 .4933 .76484 .50814 .7451 .48254 Metetra
.202 .498 .905 r
.7451 .48254 .76484 .50814 .81182 .52744 .79242 .5019 Metetra
.161 .474 .894 r
.79242 .5019 .81182 .52744 .8607 .54956 .84167 .52405 Metetra
.141 .462 .889 r
.84167 .52405 .8607 .54956 .91154 .57351 .8929 .54798 Metetra
.133 .458 .887 r
.8929 .54798 .91154 .57351 .96442 .59882 .94622 .57323 Metetra
.664 .741 .908 r
.31365 .51855 .33741 .54067 .37515 .52876 .35172 .50632 Metetra
.664 .741 .908 r
.35172 .50632 .37515 .52876 .41342 .51668 .39033 .49391 Metetra
.664 .741 .908 r
.39033 .49391 .41342 .51668 .45224 .50442 .42951 .48132 Metetra
.664 .741 .908 r
.42951 .48132 .45224 .50442 .49163 .49199 .46926 .46855 Metetra
.663 .741 .908 r
.46926 .46855 .49163 .49199 .53159 .47948 .5096 .45566 Metetra
.654 .738 .911 r
.5096 .45566 .53159 .47948 .57216 .46789 .55056 .44348 Metetra
.616 .723 .922 r
.55056 .44348 .57216 .46789 .61347 .46018 .59223 .43492 Metetra
.525 .68 .936 r
.59223 .43492 .61347 .46018 .65583 .45978 .63492 .43379 Metetra
.396 .612 .936 r
.63492 .43379 .65583 .45978 .69962 .46774 .67901 .44141 Metetra
.276 .542 .921 r
.67901 .44141 .69962 .46774 .7451 .48254 .7248 .4562 Metetra
.197 .495 .904 r
.7248 .4562 .7451 .48254 .79242 .5019 .77246 .47563 Metetra
.157 .471 .893 r
.77246 .47563 .79242 .5019 .84167 .52405 .82207 .49781 Metetra
.139 .461 .888 r
.82207 .49781 .84167 .52405 .8929 .54798 .8737 .52169 Metetra
.132 .457 .886 r
.8737 .52169 .8929 .54798 .94622 .57323 .92747 .54685 Metetra
.664 .741 .908 r
.28926 .49583 .31365 .51855 .35172 .50632 .32766 .48327 Metetra
.664 .741 .908 r
.32766 .48327 .35172 .50632 .39033 .49391 .36662 .47053 Metetra
.664 .741 .908 r
.36662 .47053 .39033 .49391 .42951 .48132 .40615 .4576 Metetra
.664 .741 .908 r
.40615 .4576 .42951 .48132 .46926 .46855 .44628 .44447 Metetra
.663 .741 .908 r
.44628 .44447 .46926 .46855 .5096 .45566 .48701 .43119 Metetra
.657 .739 .91 r
.48701 .43119 .5096 .45566 .55056 .44348 .52836 .41842 Metetra
.622 .725 .92 r
.52836 .41842 .55056 .44348 .59223 .43492 .5704 .40896 Metetra
.532 .683 .935 r
.5704 .40896 .59223 .43492 .63492 .43379 .61342 .40702 Metetra
.398 .612 .936 r
.61342 .40702 .63492 .43379 .67901 .44141 .65782 .4143 Metetra
.272 .539 .92 r
.65782 .4143 .67901 .44141 .7248 .4562 .70392 .42909 Metetra
.192 .492 .902 r
.70392 .42909 .7248 .4562 .77246 .47563 .75191 .44861 Metetra
.153 .469 .892 r
.75191 .44861 .77246 .47563 .82207 .49781 .80188 .47079 Metetra
.137 .46 .888 r
.80188 .47079 .82207 .49781 .8737 .52169 .85392 .4946 Metetra
.131 .457 .886 r
.85392 .4946 .8737 .52169 .92747 .54685 .90812 .51965 Metetra
.664 .741 .908 r
.2642 .4725 .28926 .49583 .32766 .48327 .30294 .4596 Metetra
.664 .741 .908 r
.30294 .4596 .32766 .48327 .36662 .47053 .34225 .4465 Metetra
.664 .741 .908 r
.34225 .4465 .36662 .47053 .40615 .4576 .38215 .43321 Metetra
.664 .741 .908 r
.38215 .43321 .40615 .4576 .44628 .44447 .42266 .41972 Metetra
.663 .741 .908 r
.42266 .41972 .44628 .44447 .48701 .43119 .46378 .40604 Metetra
.659 .74 .91 r
.46378 .40604 .48701 .43119 .52836 .41842 .50553 .39268 Metetra
.628 .727 .919 r
.50553 .39268 .52836 .41842 .5704 .40896 .54797 .38228 Metetra
.539 .686 .934 r
.54797 .38228 .5704 .40896 .61342 .40702 .59132 .37944 Metetra
.399 .612 .936 r
.59132 .37944 .61342 .40702 .65782 .4143 .63603 .38636 Metetra
.267 .536 .918 r
.63603 .38636 .65782 .4143 .70392 .42909 .68244 .40119 Metetra
.186 .488 .9 r
.68244 .40119 .70392 .42909 .75191 .44861 .73075 .42079 Metetra
.149 .466 .891 r
.73075 .42079 .75191 .44861 .80188 .47079 .78108 .44297 Metetra
.135 .458 .887 r
.78108 .44297 .80188 .47079 .85392 .4946 .83351 .46669 Metetra
.13 .456 .886 r
.83351 .46669 .85392 .4946 .90812 .51965 .88816 .49159 Metetra
.664 .741 .908 r
.23846 .44853 .2642 .4725 .30294 .4596 .27754 .43527 Metetra
.664 .741 .908 r
.27754 .43527 .30294 .4596 .34225 .4465 .3172 .42181 Metetra
.664 .741 .908 r
.3172 .42181 .34225 .4465 .38215 .43321 .35748 .40814 Metetra
.664 .741 .908 r
.35748 .40814 .38215 .43321 .42266 .41972 .39837 .39426 Metetra
.663 .741 .908 r
.39837 .39426 .42266 .41972 .46378 .40604 .43989 .38018 Metetra
.66 .74 .909 r
.43989 .38018 .46378 .40604 .50553 .39268 .48205 .36624 Metetra
.634 .73 .917 r
.48205 .36624 .50553 .39268 .54797 .38228 .52489 .35484 Metetra
.547 .69 .933 r
.52489 .35484 .54797 .38228 .59132 .37944 .56859 .35101 Metetra
.401 .612 .935 r
.56859 .35101 .59132 .37944 .63603 .38636 .6136 .35754 Metetra
.261 .532 .917 r
.6136 .35754 .63603 .38636 .68244 .40119 .66031 .37245 Metetra
.179 .483 .898 r
.66031 .37245 .68244 .40119 .73075 .42079 .70895 .39217 Metetra
.145 .464 .89 r
.70895 .39217 .73075 .42079 .78108 .44297 .75963 .41432 Metetra
.133 .457 .887 r
.75963 .41432 .78108 .44297 .83351 .46669 .81246 .4379 Metetra
.129 .456 .886 r
.81246 .4379 .83351 .46669 .88816 .49159 .86754 .46262 Metetra
.664 .741 .908 r
.212 .42389 .23846 .44853 .27754 .43527 .25142 .41026 Metetra
.664 .741 .908 r
.25142 .41026 .27754 .43527 .3172 .42181 .29145 .39641 Metetra
.664 .741 .908 r
.29145 .39641 .3172 .42181 .35748 .40814 .3321 .38236 Metetra
.664 .741 .908 r
.3321 .38236 .35748 .40814 .39837 .39426 .37338 .36808 Metetra
.664 .741 .908 r
.37338 .36808 .39837 .39426 .43989 .38018 .4153 .35358 Metetra
.662 .741 .909 r
.4153 .35358 .43989 .38018 .48205 .36624 .45789 .33907 Metetra
.64 .732 .915 r
.45789 .33907 .48205 .36624 .52489 .35484 .50114 .32662 Metetra
.557 .694 .932 r
.50114 .32662 .52489 .35484 .56859 .35101 .54521 .32167 Metetra
.402 .612 .935 r
.54521 .32167 .56859 .35101 .6136 .35754 .59052 .32781 Metetra
.254 .527 .915 r
.59052 .32781 .6136 .35754 .66031 .37245 .63752 .34285 Metetra
.172 .479 .896 r
.63752 .34285 .66031 .37245 .70895 .39217 .68648 .36269 Metetra
.14 .461 .888 r
.68648 .36269 .70895 .39217 .75963 .41432 .73751 .38479 Metetra
.131 .457 .886 r
.73751 .38479 .75963 .41432 .81246 .4379 .79072 .4082 Metetra
.129 .456 .886 r
.79072 .4082 .81246 .4379 .86754 .46262 .84625 .4327 Metetra
.664 .741 .908 r
.18479 .39856 .212 .42389 .25142 .41026 .22456 .38453 Metetra
.664 .741 .908 r
.22456 .38453 .25142 .41026 .29145 .39641 .26496 .37029 Metetra
.664 .741 .908 r
.26496 .37029 .29145 .39641 .3321 .38236 .30599 .35583 Metetra
.664 .741 .908 r
.30599 .35583 .3321 .38236 .37338 .36808 .34766 .34113 Metetra
.664 .741 .908 r
.34766 .34113 .37338 .36808 .4153 .35358 .39 .32621 Metetra
.663 .741 .908 r
.39 .32621 .4153 .35358 .45789 .33907 .43301 .31115 Metetra
.646 .735 .914 r
.43301 .31115 .45789 .33907 .50114 .32662 .4767 .29761 Metetra
.567 .699 .93 r
.4767 .29761 .50114 .32662 .54521 .32167 .52114 .29137 Metetra
.403 .612 .934 r
.52114 .29137 .54521 .32167 .59052 .32781 .56675 .2971 Metetra
.245 .52 .912 r
.56675 .2971 .59052 .32781 .63752 .34285 .61404 .31237 Metetra
.164 .473 .894 r
.61404 .31237 .63752 .34285 .68648 .36269 .66331 .33235 Metetra
.136 .459 .887 r
.66331 .33235 .68648 .36269 .73751 .38479 .71468 .35434 Metetra
.13 .456 .886 r
.71468 .35434 .73751 .38479 .79072 .4082 .76828 .37753 Metetra
.128 .455 .886 r
.76828 .37753 .79072 .4082 .84625 .4327 .82424 .40178 Metetra
.664 .741 .908 r
.1568 .3725 .18479 .39856 .22456 .38453 .19693 .35807 Metetra
.664 .741 .908 r
.19693 .35807 .22456 .38453 .26496 .37029 .2377 .34341 Metetra
.664 .741 .908 r
.2377 .34341 .26496 .37029 .30599 .35583 .27911 .32852 Metetra
.664 .741 .908 r
.27911 .32852 .30599 .35583 .34766 .34113 .32118 .31339 Metetra
.664 .741 .908 r
.32118 .31339 .34766 .34113 .39 .32621 .36394 .29802 Metetra
.663 .741 .908 r
.36394 .29802 .39 .32621 .43301 .31115 .40739 .28243 Metetra
.652 .737 .912 r
.40739 .28243 .43301 .31115 .4767 .29761 .45152 .26779 Metetra
.58 .705 .928 r
.45152 .26779 .4767 .29761 .52114 .29137 .49636 .26004 Metetra
.405 .612 .934 r
.49636 .26004 .52114 .29137 .56675 .2971 .54227 .26537 Metetra
.233 .512 .909 r
.54227 .26537 .56675 .2971 .61404 .31237 .58984 .28099 Metetra
.154 .468 .891 r
.58984 .28099 .61404 .31237 .66331 .33235 .6394 .3011 Metetra
.133 .457 .886 r
.6394 .3011 .66331 .33235 .71468 .35434 .6911 .32293 Metetra
.129 .456 .886 r
.6911 .32293 .71468 .35434 .76828 .37753 .74508 .34584 Metetra
.128 .455 .886 r
.74508 .34584 .76828 .37753 .82424 .40178 .80148 .3698 Metetra
.664 .741 .908 r
.128 .34568 .1568 .3725 .19693 .35807 .16849 .33082 Metetra
.664 .741 .908 r
.16849 .33082 .19693 .35807 .2377 .34341 .20963 .31573 Metetra
.664 .741 .908 r
.20963 .31573 .2377 .34341 .27911 .32852 .25143 .3004 Metetra
.664 .741 .908 r
.25143 .3004 .27911 .32852 .32118 .31339 .29391 .28481 Metetra
.664 .741 .908 r
.29391 .28481 .32118 .31339 .36394 .29802 .33709 .26897 Metetra
.663 .741 .908 r
.33709 .26897 .36394 .29802 .40739 .28243 .38098 .25288 Metetra
.658 .739 .91 r
.38098 .25288 .40739 .28243 .45152 .26779 .42558 .23716 Metetra
.595 .711 .925 r
.42558 .23716 .45152 .26779 .49636 .26004 .47084 .22758 Metetra
.405 .61 .933 r
.47084 .22758 .49636 .26004 .54227 .26537 .51704 .23253 Metetra
.218 .501 .905 r
.51704 .23253 .54227 .26537 .58984 .28099 .56487 .2487 Metetra
.145 .462 .889 r
.56487 .2487 .58984 .28099 .6394 .3011 .61472 .2689 Metetra
.13 .456 .886 r
.61472 .2689 .6394 .3011 .6911 .32293 .66675 .29049 Metetra
.128 .455 .886 r
.66675 .29049 .6911 .32293 .74508 .34584 .7211 .31309 Metetra
.128 .455 .886 r
.7211 .31309 .74508 .34584 .80148 .3698 .77793 .33672 Metetra
.664 .741 .908 r
.09834 .31807 .128 .34568 .16849 .33082 .1392 .30277 Metetra
.664 .741 .908 r
.1392 .30277 .16849 .33082 .20963 .31573 .18072 .28723 Metetra
.664 .741 .908 r
.18072 .28723 .20963 .31573 .25143 .3004 .22291 .27142 Metetra
.664 .741 .908 r
.22291 .27142 .25143 .3004 .29391 .28481 .26581 .25536 Metetra
.664 .741 .908 r
.26581 .25536 .29391 .28481 .33709 .26897 .30942 .23903 Metetra
.664 .741 .908 r
.30942 .23903 .33709 .26897 .38098 .25288 .35376 .22243 Metetra
.662 .741 .909 r
.35376 .22243 .38098 .25288 .42558 .23716 .39884 .20576 Metetra
.614 .72 .921 r
.39884 .20576 .42558 .23716 .47084 .22758 .44456 .19388 Metetra
.404 .608 .931 r
.44456 .19388 .47084 .22758 .51704 .23253 .49105 .19853 Metetra
.196 .487 .898 r
.49105 .19853 .51704 .23253 .56487 .2487 .53911 .21553 Metetra
.136 .458 .887 r
.53911 .21553 .56487 .2487 .61472 .2689 .58922 .23571 Metetra
.129 .455 .886 r
.58922 .23571 .61472 .2689 .66675 .29049 .64156 .25697 Metetra
.128 .455 .886 r
.64156 .25697 .66675 .29049 .7211 .31309 .69628 .27919 Metetra
.128 .455 .886 r
.69628 .27919 .7211 .31309 .77793 .33672 .75355 .30245 Metetra
.664 .741 .908 r
.0678 .28963 .09834 .31807 .1392 .30277 .10903 .27387 Metetra
.664 .741 .908 r
.10903 .27387 .1392 .30277 .18072 .28723 .15093 .25785 Metetra
.664 .741 .908 r
.15093 .25785 .18072 .28723 .22291 .27142 .19352 .24156 Metetra
.664 .741 .908 r
.19352 .24156 .22291 .27142 .26581 .25536 .23684 .225 Metetra
.664 .741 .908 r
.23684 .225 .26581 .25536 .30942 .23903 .28088 .20816 Metetra
.664 .741 .908 r
.28088 .20816 .30942 .23903 .35376 .22243 .32567 .19104 Metetra
.663 .741 .908 r
.32567 .19104 .35376 .22243 .39884 .20576 .37124 .17363 Metetra
.638 .731 .916 r
.37124 .17363 .39884 .20576 .44456 .19388 .41749 .15871 Metetra
.399 .602 .929 r
.41749 .15871 .44456 .19388 .49105 .19853 .46424 .16336 Metetra
.168 .468 .89 r
.46424 .16336 .49105 .19853 .53911 .21553 .5125 .1815 Metetra
.13 .455 .886 r
.5125 .1815 .53911 .21553 .58922 .23571 .56287 .20144 Metetra
.128 .455 .886 r
.56287 .20144 .58922 .23571 .64156 .25697 .61552 .22229 Metetra
.128 .455 .886 r
.61552 .22229 .64156 .25697 .69628 .27919 .6706 .24411 Metetra
.128 .455 .886 r
.6706 .24411 .69628 .27919 .75355 .30245 .72829 .26696 Metetra
.664 .741 .908 r
.03634 .26033 .0678 .28963 .10903 .27387 .07793 .24409 Metetra
.664 .741 .908 r
.07793 .24409 .10903 .27387 .15093 .25785 .12022 .22757 Metetra
.664 .741 .908 r
.12022 .22757 .15093 .25785 .19352 .24156 .16322 .21077 Metetra
.664 .741 .908 r
.16322 .21077 .19352 .24156 .23684 .225 .20695 .19369 Metetra
.664 .741 .908 r
.20695 .19369 .23684 .225 .28088 .20816 .25144 .17632 Metetra
.664 .741 .908 r
.25144 .17632 .28088 .20816 .32567 .19104 .29669 .15864 Metetra
.664 .741 .908 r
.29669 .15864 .32567 .19104 .37124 .17363 .34274 .14065 Metetra
.664 .741 .908 r
.34274 .14065 .37124 .17363 .41749 .15871 .3896 .12235 Metetra
.378 .589 .927 r
.3896 .12235 .41749 .15871 .46424 .16336 .43657 .12783 Metetra
.14 .455 .885 r
.43657 .12783 .46424 .16336 .5125 .1815 .485 .1465 Metetra
.128 .455 .886 r
.485 .1465 .5125 .1815 .56287 .20144 .53562 .166 Metetra
.128 .455 .886 r
.53562 .166 .56287 .20144 .61552 .22229 .58856 .18641 Metetra
.128 .455 .886 r
.58856 .18641 .61552 .22229 .6706 .24411 .64399 .20777 Metetra
.128 .455 .886 r
.64399 .20777 .6706 .24411 .72829 .26696 .7021 .23016 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.15032 .21083 m
.15494 .21549 L
s
[(20)] .14109 .2015 .9907 1 Mshowa
.2751 .16197 m
.2795 .16683 L
s
[(40)] .26628 .15225 .90646 1 Mshowa
.4061 .11067 m
.41026 .11574 L
s
[(60)] .39776 .10054 .82222 1 Mshowa
.5438 .05675 m
.5477 .06203 L
s
[(80)] .53601 .04619 .73798 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(100)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06057 .24597 m
.06342 .24868 L
s
.09013 .23439 m
.09296 .23713 L
s
.12005 .22268 m
.12285 .22545 L
s
.18096 .19883 m
.1837 .20166 L
s
.21196 .18669 m
.21467 .18955 L
s
.24334 .17441 m
.24601 .17729 L
s
.30724 .14938 m
.30985 .15233 L
s
.33979 .13664 m
.34236 .13962 L
s
.37274 .12374 m
.37527 .12675 L
s
.43987 .09745 m
.44233 .10052 L
s
.47408 .08405 m
.4765 .08716 L
s
.50872 .07049 m
.5111 .07363 L
s
.57933 .04284 m
.58163 .04604 L
s
.61533 .02874 m
.61758 .03198 L
s
.65179 .01447 m
.654 .01773 L
s
gsave
.29165 .07573 -121.523 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CENA) show
93.437500 14.437500 moveto
(AKCIE) show
123.437500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{486.063, 394.063},
  ImageMargins->{{33, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007V0001RR000`400?l00000o`00003oo`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooolW0?ooo`E000000P3oool00d000000oooo
0?ooo`020?ooo`03@000003oool0oooo0;40oooo003o0?ooobT0oooo00M000000?ooo`3oool0oooo
@000003ooom000000080oooo00=000000?oood000000/P3oool00?l0oooo:@3oool01d000000oooo
0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000002b0?ooo`00o`3ooolY0?ooo`07
@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom000000;80oooo003o0?oo
obT0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000/P3o
ool00?l0oooo:03oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`2a
0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW
0?ooo`00o`3ooooW0?ooo`00o`3ooole0?ooo`800000/03oool00?l0oooo<`3oool2000000030?oo
o`00000000000:l0oooo003o0?oooc00oooo0`0000030?ooo`03000004000000oooo0:h0oooo003o
0?ooobh0oooo0P0000060?ooo`030000003oool000000:h0oooo003o0?ooob/0oooo0`0000080?oo
o`040000003oool0oooo00000:d0oooo003o0?ooobP0oooo0`00000;0?ooo`040000003oool0oooo
00000:d0oooo003o0?ooobH0oooo0P0000030?ooo`03@000003oool0oooo00P0oooo00D000000?oo
o`3oool0oooo0000002/0?ooo`00o03oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo
01h0oooo0`00000@0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0Z@3oool00?/0
oooo00=000000?oood0000000P3oool00d000000oooo@000000M0?ooo`8000004`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0:T0oooo003k0?ooo`03@000003ooom000000080oooo
00=000000?oood0000006P3oool3000001H0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`2X0?ooo`00o03oool01d000000oooo0?ooo`3ooom000000?oood000000603oool200000003
0?oood000000oooo01H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2W0?ooo`00
n`3oool00d000000oooo@00000020?ooo`03@000003ooom0000001D0oooo0`00000K0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0Y`3oool00?`0oooo00=000000?ooo`3oool00P3o
ool00d000000oooo0?ooo`0B0?ooo`8000007P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0:H0oooo003o0?oooa@0oooo0`00000P0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0YP3oool00?l0oooo4P3oool2000002<0oooo00<000000?ooo`3oool0103oool00d00
000000000?ooo`2V0?ooo`00NP3oool2@00000030?oood000010000000I0000000D0oooo@0000400
001000000?ooo`02@00000X0oooo0T0000000`3ooom00000@0000002@00000030?oood0000100000
0080oooo0T0000020?ooo`=0000000<0oooo@000040000000d00001O0?ooo`<0000000<0oooo@000
003oool08P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0:@0oooo001i0?ooo`03
@000003oool0oooo0080oooo00M000000?ooo`3ooom000000?oood000000oooo00=000000`3oool0
0d000000oooo0?ooo`080?ooo`09@000003oool0oooo0?oood000000oooo@000003ooom000000080
oooo00=000000?ooo`3oool00`3oool01D000000oooo0?ooo`3ooom000000080oooo00=000000?oo
o`3oool0FP3oool3000002P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2T0?oo
o`00N@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00E000000?oood00
001000000?ooo`03@00000`0oooo0d0000020?ooo`=000000P3oool00d000000oooo0?ooo`030?oo
o`05@000003oool0oooo0?oood000000G@3oool2000002/0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`2S0?ooo`00N@3oool00d000000oooo0?ooo`020?ooo`9000000`3oool2@000
00060?oood000000oooo@000003ooom00000303oool00d000000oooo@00000020?ooo`9000000`3o
ool00d000000oooo0?ooo`030?ooo`04@000003oool0oooo0?ooo`900000F@3oool3000002d0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`2R0?ooo`00N@3oool00d000000oooo@000
00020?ooo`05@000003oool0oooo@000003oool00T0000001@3ooom000000?ooo`3ooom0000000h0
oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood0000000`3oool0
1D000000oooo0?ooo`3ooom000000080oooo00=000000?ooo`3oool0D`3oool200000300oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`2R0?ooo`00N@3oool3@00000030?oood000010
000000E0000000@0oooo@00004000000oooo0T00000=0?ooo`9000000P3oool2@00000040?oood00
001000000?ooo`=000000P3oool3@00000030?oood000010000000=00000DP3oool300000080oooo
00<00000@000003oool0;@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0:40oooo
003o0?ooo`800000=@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0:00oooo003l
0?ooo`<00000=`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0:00oooo003j0?oo
o`800000>P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo09l0oooo003g0?ooo`<0
000000<0oooo@000003oool0>@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo09h0
oooo003=0?ooo`900000103oool00d000000oooo0?ooo`0O0?ooo`800000@03oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo09h0oooo003=0?ooo`03@000003ooom000000080oooo00=0
00000?oood0000007@3oool300000480oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`2M0?ooo`00c@3oool00d000000oooo@00000020?ooo`03@000003ooom0000001X0oooo0`000015
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0W03oool00<d0oooo0T0000030?oo
o`03@000003ooom0000001P0oooo0P0000180?ooo`030000003oool0oooo00`0oooo00=000000000
003oool0W@3oool00<d0oooo00=000000?ooo`3oool00P3oool00d000000oooo@000000E0?ooo`<0
00000P3oool00d000000oooo0?ooo`150?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool0V`3oool00<h0oooo0T0000030?ooo`03@000003oool0oooo0180oooo0P00001=0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool0VP3oool00>D0oooo0`00001?0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool0VP3oool00><0oooo0P00001B0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0V@3oool00>00oooo0`0000000`3ooom000000?ooo`1A0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool0V03oool00=h0oooo0P00001G0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0V03oool00=/0oooo0`00001I0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool0U`3oool00=P0oooo0`00001L0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool0U`3oool00=H0oooo1000001M0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0UP3oool00=<0oooo0`0000030?ooo`03@000003oool0oooo
05/0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`2E0?ooo`00d@3oool2000006@0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`2E0?ooo`00cP3oool3000000030?oo
o`000000000000<00000H03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo09@0oooo
003<0?ooo`8000000P3oool200000080ZKgX00<00000062Fk@1PU^d02000001I0?ooo`030000003o
ool0oooo01@0oooo00=000000000003oool0U03oool00:80oooo0d0000020?ooo`03@000003oool0
oooo01l0oooo0`000000103oool00000@000000000050:Vmj0030000001PU^d0H9K]00L0H9K]1@00
001D0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0T`3oool00:<0oooo00I00000
0?ooo`3ooom000000?oood00000N0?ooo`80000000@0oooo0000000000000000202Y_NP00`000000
H9K]062Fk@0;062Fk@<00000DP3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0980
oooo002Q0?ooo`A0000000@0oooo@000003ooom000006`3oool3000000030?ooo`000000000000`0
ZKgX00<00000062Fk@1PU^d02`1PU^d00`0000008gCR00000002000004l0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`2A0?ooo`00X@3oool00d000000oooo@00000020?ooo`03@000
003ooom0000001T0oooo0P000000103oool0000000000000000?0:Vmj0030000001PU^d0H9K]00X0
H9K]00<0000002=dhP0SM>800P0SM>83000004`0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`2A0?ooo`00XP3oool2@0000080oooo00=000000?oood0000005P3oool400000003@000
00000000ZKgX0180ZKgX00<00000062Fk@1PU^d02P1PU^d00`0000008gCR02=dhP0402=dhP800000
BP3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0900oooo002S0?ooo`05@000003o
ool0oooo0?oood000000503oool3000000030?ooo`00000000000080ZKgX00<000000:Vmj02Y_NP0
4@2Y_NP00`000000H9K]062Fk@0;062Fk@030000000SM>808gCR00D08gCR0`0000170?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool0S`3oool00;X0oooo0P000000103oool000000000
000000050:Vmj0030000002Y_NP0ZKgX0140ZKgX00<00000062Fk@1PU^d02`1PU^d00`0000008gCR
02=dhP0702=dhP<00000A03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00L0oooo
00=000000?ooo`3oool00P3oool014000000oooo0?ooo`3oool3@00007`0oooo002g0?ooo`<00000
00<0oooo0000000000002@2Y_NP00`000000ZKgX0:Vmj00A0:Vmj0030000001PU^d0H9K]00X0H9K]
00<0000002=dhP0SM>802@0SM>8400000440oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`050?ooo`03@000003ooom0000000L0oooo00=000000?ooo`3oool0O03oool00;D0oooo0P00
0000103ooom0000000000000000<0:Vmj0030000002Y_NP0ZKgX0140ZKgX00<00000062Fk@1PU^d0
2P1PU^d00`0000008gCR02=dhP0902=dhP030000000PM>8087CR00<00000?P3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00@0oooo00=000000?oood000000203oool00d000000oooo
0?ooo`1k0?ooo`00/P3oool3000000030?ooo`00000000000100ZKgX00<000000:Vmj02Y_NP0402Y
_NP00`000000H9K]062Fk@0;062Fk@030000000SM>808gCR00P08gCR00<00000021dhP0PM>800`0P
M>82000003`0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`03@000003o
oom0000000P0oooo00=000000?ooo`3oool0N`3oool00;00oooo0P000000103oool0000000000000
000B0:Vmj0030000002Y_NP0ZKgX0100ZKgX1@00000:062Fk@030000000SM>808gCR00P08gCR00<0
0000021dhP0PM>80100PM>83000003T0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`030?ooo`03@000003ooom0000000L0oooo00=000000?oood000000O03oool00:d0oooo0`000000
0`3oool00000000000020:Vmj0030000002Y_NP0ZKgX0140ZKgX00<000000:Vmj02Y_NP0302Y_NP3
00000080Xk_Z00<0000006JJk@1VV^d020000002062Fk@030000000SM>808gCR00T08gCR00<00000
021dhP0PM>801P0PM>83000003H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`03
0?ooo`03@000003oool0oooo00L0oooo00=000000?ooo`3oool0N`3oool00:/0oooo0P000000103o
ool000000000000000050:Vmj0030000002Y_NP0ZKgX0140ZKgX00<000000:Vmj02Y_NP0202Y_NP3
000000H0Xk_Z00<0000006JJk@1VV^d01`1VV^d5000000X08gCR00<00000021dhP0PM>80200PM>83
000003<0oooo00<000000?ooo`3oool06`3oool00d00000000000000002=0?ooo`00Z03oool30000
00040?ooo`0000000000@00000P0ZKgX00<000000:Vmj02Y_NP04@2Y_NP00`000000ZKgX0:Vmj004
0:Vmj0<000002@2S^nX00`000000IY[]06JJk@0;06JJk@<00000200SM>800`00000087CR021dhP0:
021dhP<00000<@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo08X0oooo002V0?oo
o`80000000@0oooo0000000000000000302Y_NP00`000000ZKgX0:Vmj00A0:Vmj0030000002Y_NP0
ZKgX00<000003@2S^nX00`000000IY[]06JJk@0;06JJk@030000000[Mn<00000008000001P0SM>80
0`00000087CR021dhP0:021dhP030000000PM>80000000800000;P3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo08T0oooo002R0?ooo`@0000000<0oooo000000000000402Y_NP00`00
0000ZKgX0:Vmj00@0:Vmj0<000004@2S^nX00`000000IY[]06JJk@0:06JJk@030000000[Mn<0:gOS
0080:gOS0`00000402=dhP030000000PM>8087CR00T087CR00<00000021dhP0PM>800P0PM>820000
02d0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`290?ooo`00N03oool3@00000<0
oooo00=000000?ooo`3oool07`3oool300000004@00000000000000000000180ZKgX00<000000:Vm
j02Y_NP03P2Y_NP200000080ZKgX00<000000:>kjP2S^nX0402S^nX00`000000IY[]06JJk@0:06JJ
k@030000000[Mn<0:gOS00@0:gOS0P00000302=dhP030000000PM>8087CR00T087CR00<00000021d
hP0PM>800`0PM>82000002/0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`280?oo
o`00N03oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000001h0oooo0P0000020?ooo`80
00000P2Y_NP00`000000ZKgX0:Vmj00A0:Vmj0030000002Y_NP0ZKgX00X0ZKgX0`0000050:Vmj003
0000002S^nX0Xk_Z00l0Xk_Z00<0000006JJk@1VV^d02`1VV^d00`000000:gOS02]gh`0502]gh`@0
0000300PM>800`00000087CR021dhP04021dhP<00000:03oool00`000000oooo0?ooo`0O0?ooo`03
0000003oool0oooo08P0oooo001i0?ooo`07@000003oool0oooo0?oood000000oooo@000000K0?oo
o`<000000P3oool2000000D0ZKgX00<000000:Vmj02Y_NP04@2Y_NP00`000000ZKgX0:Vmj0070:Vm
j0800000202Y_NP00`000000Xk_Z0:>kjP0@0:>kjP030000001VV^d0IY[]00/0IY[]00<0000002]g
h`0[Mn<01`0[Mn<3000000/087CR00<00000021dhP0PM>801P0PM>82000002H0oooo00<000000?oo
o`3oool0803oool00`000000oooo0?ooo`270?ooo`00N@3oool01d000000oooo0?ooo`3ooom00000
0?oood000000603oool300000080oooo0`0000080:Vmj0030000002Y_NP0ZKgX0140ZKgX00<00000
0:Vmj02Y_NP00`2Y_NP3000000/0ZKgX00<000000:>kjP2S^nX0402S^nX00`000000IY[]06JJk@0;
06JJk@030000000[Mn<0:gOS00P0:gOS10000008021dhP030000000PM>8087CR00P087CR0`00000S
0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0QP3oool007P0oooo00=000000?oo
od0000000P3oool00d000000oooo@000000F0?ooo`<0000000A000000?ooo`0000000000302Y_NP0
0`000000ZKgX0:Vmj00A0:Vmj0030000002Y_NP0ZKgX008000003`2Y_NP00`000000Xk_Z0:>kjP0@
0:>kjP030000001VV^d0IY[]00/0IY[]00<0000002]gh`0[Mn<0200[Mn<00`0000008GCR025dhP03
000000H087CR00<00000021dhP0PM>802@0PM>8300000240oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`260?ooo`00N@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo
01<0oooo0P0000030?ooo`8000003`2Y_NP00`000000ZKgX0:Vmj00@0:Vmj0<000004P2Y_NP00`00
0000Xk_Z0:>kjP0?0:>kjP030000001VV^d0IY[]00/0IY[]00<0000002]gh`0[Mn<0200[Mn<00`00
00008GCR025dhP03025dhP8000001@0PM>800`00000087CR021dhP09021dhP030000000PM>800000
008000007P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo08D0oooo002A0?ooo`<0
00000P3oool300000180ZKgX00<000000:Vmj02Y_NP0302Y_NP300000080ZKgX00<000000:Vmj02Y
_NP04@2Y_NP00`000000Xk_Z0:>kjP0>0:>kjPT000001P1VV^d00`000000:gOS02]gh`0802]gh`03
0000000QM>808GCR00@08GCR0`000003021dhP030000000PM>8087CR00P087CR00<00000021dhP0P
M>800P0PM>82000001`0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`240?ooo`00
SP3oool300000080oooo0`0000020:Vmj0030000002Y_NP0ZKgX0140ZKgX00<000000:Vmj02Y_NP0
202Y_NP3000000H0ZKgX00<000000:Vmj02Y_NP04@2Y_NP00`000000Xk_Z0:>kjP090:>kjP@00000
0P2M^>/00`000000Ii_^06NKkP0406NKkPT000002@0[Mn<00`0000008GCR025dhP06025dhP@00000
2`0PM>800`00000087CR021dhP03021dhP<000006@3oool00`000000oooo0?ooo`0S0?ooo`030000
003oool0oooo02<0oooo0T000000103ooom00000@000003oool2@00000040?oood0000100000@000
00X0oooo140000030?ooo`9000002@3oool7@00000030?oood000010000000=000000`3oool3@000
00050?oood0000100000@000003oool00d0000000`3ooom00000@00000020?ooo`9000000P3oool3
@00000030?oood000010000000=00000303oool008`0oooo0`000000140000000000000000000006
0:Vmj0030000002Y_NP0ZKgX0140ZKgX00<000000:Vmj02Y_NP0102Y_NP3000000X0ZKgX00<00000
0:Vmj02Y_NP0402Y_NP00`000000Xk_Z0:>kjP050:>kjP@000001P2M^>/00`000000Ii_^06NKkP0<
06NKkP<00000200[Mn<00`0000008GCR025dhP08025dhP<000002P0PM>800`00000087CR021dhP05
021dhP<000005P3oool00`000000oooo0?ooo`0S0?ooo`03@00000000000oooo0280oooo00E00000
0?ooo`3oool0oooo@00000030?ooo`05@000003ooom000000?oood0000002`3oool01T000000oooo
0?oood000000oooo@0000080oooo00=000000?ooo`3oool01`3oool024000000oooo0?oood000000
oooo@000003ooom000000P3oool00d000000oooo0?ooo`030?ooo`05@000003oool0oooo0?oood00
00000P3oool2@00000<0oooo00=000000?oood0000001@3oool01D000000oooo0?ooo`3ooom00000
0080oooo00=000000?ooo`3oool02P3oool008X0oooo0P000000103oool0000000000000000:0:Vm
j0030000002Y_NP0ZKgX0140ZKgX00<000000:Vmj02Y_NP00`00000>0:Vmj0030000002Y_NP0ZKgX
0100ZKgX00<000000:>kjP2S^nX01000000;09fhj`030000001WVnh0Ii_^00/0Ii_^00<00000039l
i@0bO>D00`00000602]gh`030000000QM>808GCR00T08GCR0`000009021dhP030000000PM>8087CR
00L087CR0P00000D0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0803oool00d00
0000oooo0?ooo`020?ooo`=00000103oool00d000000oooo0?ooo`090?ooo`06@000003oool0oooo
@000003ooom000000P3oool00d000000oooo0?ooo`070?ooo`03@000003oool0oooo00<0oooo00A0
00000?ooo`3oool0oooo0d0000030?ooo`04@000003oool0oooo0?ooo`=000000P3oool3@0000080
oooo00=000000?ooo`3oool00`3oool01D000000oooo0?ooo`3ooom0000000l0oooo00270?ooo`H0
00003P2Y_NP00`000000ZKgX0:Vmj00@0:Vmj0<000004P2Y_NP00`000000ZKgX0:Vmj00?0:Vmj0<0
0000402M^>/00`000000Ii_^06NKkP0;06NKkP030000000bO>D0<WcU0080<WcU0`00000402]gh`03
0000000QM>808GCR00P08GCR00<00000021dhP0PM>800`000006021dhP030000000PM>8087CR00T0
87CR0`00000A0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0803oool00d000000
oooo0?ooo`020?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3oool02P3oool01T000000
oooo0?oood000000oooo@0000080oooo00=000000?ooo`3oool01`3oool2@00000@0oooo00E00000
0?ooo`3oool0oooo@00000020?ooo`04@000003oool0oooo@00000<0oooo00Q000000?ooo`3ooom0
00000?oood000000oooo@0000080oooo00=000000?ooo`3oool00`3oool014000000oooo0?ooo`3o
ool2@00000h0oooo00240?ooo`H000004P2Y_NP00`000000ZKgX0:Vmj00=0:Vmj08000000P2Y_NP0
0`000000ZKgX0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00`0ZKgX0`0000020:Vmj0030000002M^>/0
WKS[00l0WKS[00<0000006NKkP1WVnh02`1WVnh00`000000<WcU039li@04039li@8000000P0[Mn<0
0`0000008GCR025dhP09025dhP030000000PM>8087CR008087CR0P000005021dhP030000000PM>80
87CR00X087CR0`00000?0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool07`3oool0
0d000000oooo@00000030?ooo`07@000003oool0oooo0?oood000000oooo@000000;0?ooo`06@000
003oool0oooo@000003ooom000000P3oool00d000000oooo0?ooo`070?ooo`08@000003oool0oooo
@000003ooom000000?oood0000020?ooo`04@000003oool0oooo@0000080oooo00E000000?ooo`3o
ool0oooo@00000020?ooo`04@000003oool0oooo@00000<0oooo00=000000?oood0000000`3oool0
1D000000oooo0?ooo`3ooom000000080oooo00=000000?ooo`3oool02P3oool00880oooo0P000000
0`3oool00000000000020:Vmj0030000002Y_NP0ZKgX0100ZKgX00<000000:Vmj02Y_NP02P2Y_NP3
000000D0ZKgX00<000000:Vmj02Y_NP0402Y_NP00`000000ZKgX0:Vmj0080:Vmj0<000001P2Y_NP0
0`000000WKS[09fhj`0>09fhj`030000001WVnh0Ii_^00`0Ii_^00<00000039li@0bO>D01@0bO>D4
000000/08GCR00<00000021dhP0PM>800`0PM>82000000@087CR00<00000021dhP0PM>802P0PM>80
1000000087CR00000000000=0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool07P3o
ool3@0000080oooo0T0000030?ooo`=000002P3oool4@00000<0oooo0T0000090?ooo`M0000000<0
oooo@00004000000140000020?ooo`=0000000<0oooo@000040000000T0000020?ooo`9000000`3o
ool3@0000080oooo0d0000000`3ooom00000@0000003@00000`0oooo001o0?ooo`<0000000@0oooo
0000000000100000102Y_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00L0ZKgX0P00
00080:Vmj0030000002Y_NP0ZKgX0140ZKgX00<000000:Vmj02Y_NP0102Y_NP3000000T0ZKgX00<0
000009fhj`2M^>/03`2M^>/00`000000Ii_^06NKkP0;06NKkP030000000bO>D0<WcU00P0<WcU0`00
000:025dhP030000000PM>8087CR00@087CR0`000002021dhP030000000PM>8087CR00T087CR00@0
0000021dhP0PM>8087CR0`00000:0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0
7`3oool00d000000oooo0?ooo`100?ooo`03@000003oool0oooo01/0oooo001m0?ooo`80000000@0
oooo0000000000000000202Y_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00<0ZKgX
0`00000;0:Vmj0030000002Y_NP0ZKgX0140ZKgX00<000000:Vmj02Y_NP00`00000=0:Vmj0030000
002M^>/0WKS[00l0WKS[00<0000006NKkP1WVnh02`1WVnh00`000000<WcU039li@09039li@<00000
200QM>800`00000087CR021dhP07021dhP<00000300PM>800`00000087CR021dhP03021dhP800000
203oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo01d0oooo00=000000?oood000000
@P3oool00d000000oooo0?ooo`0J0?ooo`00NP3oool3000000030?ooo`000000000000`0ZKgX00<0
00000:Vmj02Y_NP0402Y_NP00`000000ZKgX0:Vmj002000000l0ZKgX00<000000:Vmj02Y_NP0402Y
_NP300000140ZKgX00<0000009fhj`2M^>/03`2M^>/00`000000Ii_^06NKkP0;06NKkP030000000b
O>D0<WcU00P0<WcU00<00000029eh`0RMN<00`000006025dhP030000000PM>8087CR00P087CR0`00
000;021dhP030000000PM>8087CR00@087CR0`0000060?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool0OP3oool007P0oooo0P000000103ooom0000000000000000?0:Vmj0030000002Y
_NP0ZKgX00l0ZKgX0`00000B0:Vmj0030000002Y_NP0ZKgX00d0ZKgX0P0000020:Vmj0030000002Y
_NP0ZKgX0100ZKgX00<0000009fhj`2M^>/03P2M^>/00`000000Ii_^06NKkP0<06NKkP030000000b
O>D0<WcU00P0<WcU00<00000029eh`0RMN<00P0RMN<3000000@08GCR00<00000021dhP0PM>802@0P
M>83000000X087CR00<00000021dhP0PM>801P0PM>82000000@0oooo00<000000?ooo`3oool0:03o
ool00`000000oooo0?ooo`1n0?ooo`00M@3oool3000000040?ooo`000000000000000180ZKgX00<0
00000:Vmj02Y_NP02`2Y_NP300000080ZKgX00<000000:Vmj02Y_NP04@2Y_NP00`000000ZKgX0:Vm
j0090:Vmj0<000001@2Y_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002M^>/0WKS[00`0WKS[2P00
000606NKkP030000000bO>D0<WcU00T0<WcU00<00000029eh`0RMN<0100RMN<2000000<08GCR00<0
0000021dhP0PM>80200PM>800`00000087CR021dhP03000000L087CR00<00000021dhP0PM>80200P
M>8200000080oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1m0?ooo`00L`3oool2
000000040?ooo`000000000000000080ZKgX00<000000:Vmj02Y_NP04@2Y_NP00`000000ZKgX0:Vm
j0080:Vmj08000001P2Y_NP00`000000ZKgX0:Vmj00A0:Vmj0030000002Y_NP0ZKgX00H0ZKgX0P00
00090:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<0000009fhj`2M^>/01`2M^>/5000000<0V;K/00<0
000006NLkP1WW>h0101WW>h9000000X0<WcU00<00000029eh`0RMN<01@0RMN<4000000/087CR00<0
0000021dhP0PM>800P0PM>82000000H087CR00<00000021dhP0PM>802@0PM>800`00001000000000
000/0?ooo`030000003oool0oooo07`0oooo001`0?ooo`<0000000<0oooo0000000000001P2Y_NP0
0`000000ZKgX0:Vmj00A0:Vmj0030000002Y_NP0ZKgX00@0ZKgX0`0000090:Vmj0030000002Y_NP0
ZKgX0100ZKgX00<000000:Vmj02Y_NP00`2Y_NP3000000`0ZKgX00<000000:Vmj02Y_NP03`2Y_NP0
10000000WKS[09fhj`2M^>/5000000T0V;K/00<0000006NLkP1WW>h02`1WW>h3000000P0<WcU00<0
0000029eh`0RMN<0200RMN<3000000X087CR00<00000021dhP0PM>800`0PM>83000000@087CR00<0
0000021dhP0PM>802P0PM>800`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo07`0oooo001^
0?ooo`80000000@0oooo@0000000000000002@2Y_NP00`000000ZKgX0:Vmj00A0:Vmj0030000002Y
_NP0ZKgX00<000003@2Y_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00800000402Y
_NP00`000000ZKgX0:Vmj00>0:Vmj0@000003`2H]^`00`000000Iic^06NLkP0;06NLkP030000000g
P>L00000008000001P0bO>D00`0000008WGS029eh`09029eh`<000002@0PM>800`00000087CR021d
hP05021dhP<000000P0PM>800`00000087CR021dhP09021dhP800000:`3oool00d00000000000?oo
o`1l0?ooo`00J`3oool6000000d0ZKgX00<000000:Vmj02Y_NP0402Y_NP300000140ZKgX00<00000
0:Vmj02Y_NP03`2Y_NP300000180ZKgX00<000000:Vmj02Y_NP02`2Y_NP300000080Z;gX00<00000
09Rfk02H]^`03`2H]^`00`000000Iic^06NLkP0:06NLkP030000000gP>L0=h3W0080=h3W0`000004
039li@030000000RMN<08WGS00T08WGS00<00000025dhP0000000P000006021dhP030000000PM>80
87CR00P087CR0`00000;021dhP800000;@3oool00`000000oooo0?ooo`1j0?ooo`00J03oool60000
0140ZKgX00<000000:Vmj02Y_NP03@2Y_NP200000080ZKgX00<000000:Vmj02Y_NP0402Y_NP00`00
0000ZKgX0:Vmj00;0:Vmj0<000000P2Y_NP00`000000ZKgX0:Vmj00A0:Vmj0030000002Y_NP0ZKgX
00P0ZKgX0P0000060:Rmj0030000002H]^`0V;K/00l0V;K/00<0000006NLkP1WW>h02P1WW>h00`00
0000=h3W03N0i`0403N0i`8000000`0bO>D00`0000008WGS029eh`08029eh`030000000QM>808GCR
00808GCR0P000005021dhP030000000PM>8087CR00T087CR0`000009021dhP030000000PM>800000
02`0oooo00<000000?ooo`3oool0NP3oool006H0oooo0P0000000`3oool00000000000020:Vmj003
0000002Y_NP0ZKgX0100ZKgX00<000000:Vmj02Y_NP02P2Y_NP2000000D0ZKgX00<000000:Vmj02Y
_NP0402Y_NP00`000000ZKgX0:Vmj0080:Vmj08000001P2Y_NP00`000000ZKgX0:Vmj00A0:Vmj003
0000002Y_NP0ZKgX00@0ZKgX0`0000090:Rmj0030000002H]^`0V;K/00h0V;K/00<0000006NLkP1W
W>h02`1WW>h00`000000=h3W03N0i`0503N0i`@000002`0RMN<00`0000008GCR025dhP03025dhP80
0000100PM>800`00000087CR021dhP0:021dhP<000001P0PM>820000008087CR00<000000?ooo`3o
ool0:P3oool00`000000oooo0?ooo`1i0?ooo`00H`3oool3000000030?oood000000000000D0ZKgX
00<000000:Vmj02Y_NP0402Y_NP00`000000ZKgX0:Vmj0060:Vmj0<00000202Y_NP00`000000ZKgX
0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00@0ZKgX0`0000090:Vmj0030000002Y_NP0ZKgX0140ZKgX
00<000000:Vmj02Y_NP00`00000=0:Rmj0030000002H]^`0V;K/00h0V;K/00<0000006NLkP1WW>h0
2`1WW>h00`000000=h3W03N0i`0703N0i`<000002P0RMN<00`0000008GCR025dhP04025dhP<00000
0P0PM>800`00000087CR021dhP09021dhP030000000PM>8087CR0080000000@087CR000000000000
00000P0PM>801000000087CR021dhP00000/0?ooo`030000003oool0oooo07P0oooo001Q0?ooo`80
000000@0oooo0000000000000000202Y_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002Y_NP0ZKgX
00<0ZKgX0P00000<0:Vmj0030000002Y_NP0ZKgX0100ZKgX00<000000:Vmj02Y_NP00`00000=0:Vm
j0030000002Y_NP0ZKgX0100ZKgX0`00000A0:Rmj0030000002H]^`0V;K/00h0V;K/00<0000006NL
kP1WW>h02`1WW>h00`000000=h3W03N0i`0803N0i`@00000200RMN<00`0000008GCR025dhP06025d
hP<00000300PM>800`00000087CR00000004000000<087CR00@00000021dhP0PM>800000;03oool0
0`000000oooo0?ooo`1h0?ooo`00G`3oool2000000030?ooo`000000000000`0ZKgX00<000000:Vm
j02Y_NP0402Y_NP00`000000ZKgX0:Vmj002000000l0ZKgX00<000000:Vmj02Y_NP03`2Y_NP30000
0140ZKgX00<000000:Vmj02Y_NP0302Y_NP300000080ZKgX00<000000:Rmj02X_NP03`2X_NP00`00
0000V;K/09Rfk00?09Rfk0030000001WW>h0Iic^00/0Iic^00<0000003N0i`0gP>L0200gP>L00`00
00009GKS02Efh`03000000H08WGS00<00000025dhP0QM>801`0QM>83000000T087CR0`000005021d
hP8000000P0PM>801000000087CR021dhP00000/0?ooo`030000003oool0oooo07L0oooo001O0?oo
o`<000003`2Y_NP00`000000ZKgX0:Vmj00?0:Vmj0<000004P2Y_NP00`000000ZKgX0:Vmj00;0:Vm
j0<000000P2Y_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00P0ZKgX0`0000060:Vm
j0030000002X_NP0Z;gX00l0Z;gX00<0000009Rfk02H]^`03@2H]^`6000000T0Iic^00<0000003N0
i`0gP>L0200gP>L00`0000009GKS02Efh`0302Efh`8000001@0RMN<00`0000008GCR025dhP08025d
hP<00000100PM>830000008087CR00<00000021dhP0PM>801@0PM>840000008087CR00<000000?oo
o`3oool0:@3oool00`000000oooo0?ooo`1g0?ooo`00GP3oool200000180ZKgX00<000000:Vmj02Y
_NP02`2Y_NP300000080ZKgX00<000000:Vmj02Y_NP04@2Y_NP00`000000ZKgX0:Vmj0080:Vmj080
00001P2Y_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00@0ZKgX0`0000090:Vmj003
0000002X_NP0Z;gX0100Z;gX00<0000009Rfk02H]^`01`2H]^`5000000<0U;C]00<0000006NLk`1W
W>l02000000206NLkP030000000gP>L0=h3W00P0=h3W00<0000002Efh`0UM^<0100UM^<300000080
8WGS00<00000025dhP0QM>802@0QM>800`00000087CR00000003000000H087CR00<00000021dhP0P
M>801`0PM>820000008087CR00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1f0?ooo`00
E`3oool00d000000oooo0?ooo`040?ooo`8000004`2Y_NP00`000000ZKgX0:Vmj0080:Vmj0800000
1P2Y_NP00`000000ZKgX0:Vmj00A0:Vmj0030000002Y_NP0ZKgX00@0ZKgX0`0000090:Vmj0030000
002Y_NP0ZKgX0100ZKgX00<000000:Vmj02Y_NP00`00000=0:Vmj0030000002X_NP0Z;gX0100Z;gX
00@0000009Rfk02H]^`0V;K/1@00000809Bdk@030000001WW>l0Iic_00P0Iic_1@00000903N0i`03
0000000UM^<09GKS00H09GKS1000000:025dhPH000001`0PM>800`00000087CR021dhP07021dhP@0
0000;03oool00`000000oooo0?ooo`1e0?ooo`00EP3oool00d000000oooo@00000050?ooo`040000
04000000000000000180ZKgX00<000000:Vmj02Y_NP0102Y_NP3000000T0ZKgX00<000000:Vmj02Y
_NP04@2Y_NP00`000000ZKgX0:Vmj003000000d0ZKgX00<000000:Vmj02Y_NP03`2Y_NP300000140
ZKgX00<000000:Rmj02X_NP03`2X_NP4000000h0U;C]00<0000006NLk`1WW>l02`1WW>l4000000L0
=h3W00<0000002Efh`0UM^<0200UM^<3000000H08GCR10000004021dhP<00000100PM>800`000000
87CR021dhP08021dhP040000000PM>800000000002/0oooo00<000000?ooo`3oool0M@3oool005H0
oooo00=000000?oood0000001@3oool01@000000oooo0?ooo`3oool000000180ZKgX00<000000:Vm
j02Y_NP00`00000=0:Vmj0030000002Y_NP0ZKgX0100ZKgX0`00000A0:Vmj0030000002Y_NP0ZKgX
00`0ZKgX0P0000020:Vmj0030000002Y_NP0ZKgX0100ZKgX00<000000:Rmj02X_NP02`2X_NP30000
0080Y[cY00<0000009Bdk@2D]>d03P2D]>d00`000000Iic_06NLk`0:06NLk`040000000kPnP0>h?X
03^3j0<000001@0gP>L00`0000009GKS02Efh`0902Efh`<0000000@08GCR0000000000000000100Q
M>800`00000087CR021dhP04021dhP8000000`0PM>800`00000087CR021dhP08021dhP040000000P
M>8087CR000002/0oooo00<000000?ooo`3oool0M03oool005H0oooo00=000000?oood0000001@3o
ool00`000000oooo0?ooo`020?ooo`030000002Y_NP0ZKgX00l0ZKgX0`00000A0:Vmj08000003@2Y
_NP300000080ZKgX00<000000:Vmj02Y_NP03`2Y_NP00`000000ZKgX0:Vmj00:0:Vmj08000001@2Y
_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002X_NP0Z;gX00L0Z;gX0`0000060:Jlj@030000002D
]>d0U;C]00h0U;C]00<0000006NLk`1WW>l02P1WW>l00`000000>h?X03^3j00303^3j0<000000P0g
P>L00`0000009GKS02Efh`0902Efh`H000001P0QM>800`00000087CR021dhP05021dhP8000000P0P
M>800`00000087CR021dhP08021dhP030000000PM>80000002X0oooo00=000000?ooo`000000M@3o
ool005H0oooo00=000000?oood0000001@3oool00`000000oooo0?ooo`030?ooo`030000002Y_NP0
ZKgX00`0ZKgX0P0000020:Vmj0030000002Y_NP0ZKgX0140ZKgX00<000000:Vmj02Y_NP0202Y_NP2
000000H0ZKgX00<000000:Vmj02Y_NP03`2Y_NP00`000000ZKgX0:Vmj0060:Vmj0<00000202Y_NP0
0`000000ZKgX0:Vmj00?0:Vmj0030000002X_NP0Z;gX00@0Z;gX0`0000090:Jlj@030000002D]>d0
U;C]00h0U;C]00<0000006NLk`1WW>l02`1WW>l00`000000>h?X03^3j00503^3j0@00000200UM^<4
000000@08GCR0P000005025dhP030000000PM>8087CR00H087CR0`00000:021dhP040000000PM>80
87CR000002/0oooo00<000000?ooo`3oool0L`3oool005L0oooo00=000000?ooo`3oool00`3oool2
00000003@000003oool0oooo00<0oooo00<000000:Vmj02Y_NP0202Y_NP3000000D0ZKgX00<00000
0:Vmj02Y_NP04@2Y_NP00`000000ZKgX0:Vmj0040:Vmj0<000002@2Y_NP00`000000ZKgX0:Vmj00?
0:Vmj0030000002Y_NP0ZKgX00<0ZKgX0P00000<0:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<00000
0:Rmj02X_NP00`00000=0:Jlj@030000002D]>d0U;C]00h0U;C]00<0000006NLk`1WW>l02`1WW>l0
0`000000>h?X03^3j00703^3j0<000000`0UM^<3000000@09GKS00<00000025dhP0QM>800`0QM>82
000000@08GCR00<00000021dhP0PM>801`0PM>83000000T087CR00@00000021dhP0PM>800000:`3o
ool00`000000oooo0?ooo`1b0?ooo`00G@3oool00`000000oooo0?ooo`060?ooo`8000001@2Y_NP3
000000T0ZKgX00<000000:Vmj02Y_NP04@2Y_NP00`000000ZKgX0:Vmj003000000d0ZKgX00<00000
0:Vmj02Y_NP03`2Y_NP00`000000ZKgX0:Vmj002000000l0ZKgX00<000000:Vmj02Y_NP03P2Y_NP3
00000140Y[cY00<0000009Bdk@2D]>d03P2D]>d00`000000Iic_06NLk`0:06NLk`030000000kPnP0
>h?X00T0>h?X1000000802Efh`030000000QM>808GCR00@08GCR0`0000000`0QM>800000021dhP0:
021dhP@000001`0PM>801000000087CR021dhP00000[0?ooo`030000003oool0oooo0740oooo001M
0?ooo`030000003oool0oooo00P0oooo00<000000:Vmj02Y_NP00P00000=0:Vmj0030000002Y_NP0
ZKgX0100ZKgX0`00000A0:Vmj0030000002Y_NP0ZKgX00h0ZKgX0`00000A0:Vmj0030000002Y_NP0
ZKgX00/0ZKgX0`0000020:Vmj0030000002V_>T0Y[cY0100Y[cY00<0000009Bdk@2D]>d03P2D]>d0
0`000000Iic_06NLk`0:06NLk`030000000kPnP0>h?X00H0>h?X0`00000202Mgi0<000001P0UM^<0
0`0000008GCR025dhP07025dhP<000002`0PM>800`00000087CR021dhP02000000D087CR00@00000
021dhP0PM>800000:`3oool00`000000oooo0?ooo`1a0?ooo`00G@3oool00`00001000000?ooo`09
0?ooo`800000402Y_NP2000000d0ZKgX0`0000020:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<00000
0:Vmj02Y_NP02`2Y_NP300000080ZKgX00<000000:Vmj02Y_NP0402Y_NP00`000000ZKgX0:Vmj008
0:Vmj08000001P2Y_NP00`000000Y[cY0:Jlj@0@0:Jlj@030000002D]>d0U;C]00d0U;C]00<00000
06NLk`1WW>l02`1WW>l00`000000>h?X03^3j00203^3j0<000000`0kPnP00`0000009gOT02Mgi002
02Mgi08000001@0UM^<00`0000008GCR025dhP08025dhP<000002@0PM>800`00000087CR021dhP02
021dhP<000000`0PM>801000000087CR021dhP00000[0?ooo`030000003oool0oooo00L0oooo00=0
00000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`=00000G03oool005d0oooo00<00000
0?ooo`3oool02P3oool00`000000ZKgX0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00P0ZKgX0P000006
0:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP0202Y_NP2000000H0ZKgX00<00000
0:Vmj02Y_NP0402Y_NP00`000000ZKgX0:Vmj0040:Vmj0<000002@2Y_NP00`000000Y[cY0:Jlj@0?
0:Jlj@030000002D]>d0U;C]00/0U;C]1`00000:06NLk`040000000kPnP00000000000L0>h?X00<0
000002Mgi00WMn@00`0WMn@2000000@09GKS00<00000025dhP0QM>802@0QM>83000000P087CR00<0
0000021dhP0PM>80100PM>8300000005021dhP00000087CR021dhP000000:`3oool00`000000oooo
0?ooo`050?ooo`03@000003ooom0000000T0oooo00=000000?ooo`3oool0F`3oool005d0oooo00<0
00000?ooo`3oool02`3oool00`000000ZKgX0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00@0ZKgX0`00
00090:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP0102Y_NP3000000T0ZKgX00<0
00000:Vmj02Y_NP0402Y_NP00`000000ZKgX0:Vmj003000000d0ZKgX00<000000:Jlj@2V_>T03`2V
_>T00`000000U;C]09Bdk@0209Bdk@P00000102A/^h00`000000Iic_06NLk`080000000406NLk`00
00000000000000X0>h?X00<0000002Mgi00WMn@0100WMn@3000000809GKS00<00000025dhP0QM>80
200QM>800`00000087CR021dhP02000000L087CR00<00000021dhP0PM>801P0PM>830000008087CR
00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`050?ooo`03@000003ooom0000000L0oooo
1400001L0?ooo`00G@3oool00`000000oooo0?ooo`0<0?ooo`030000002Y_NP0ZKgX0100ZKgX00<0
00000:Vmj02Y_NP00`00000=0:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP00`00
000=0:Vmj0030000002Y_NP0ZKgX00l0ZKgX0`00000A0:Vmj0030000002V_>T0Y[cY00h0Y[cY1@00
000=096bkP030000001WW>l0Iic_00D0Iic_1`00000903^3j0030000000WMn@09gOT00L09gOT0`00
000;025dhP040000000PM>8087CR021dhP8000001P0PM>800`00000087CR021dhP07021dhP@00000
:`3oool00`000000oooo0?ooo`040?ooo`03@000003ooom0000000L0oooo00=000000?oood000000
G@3oool005`0oooo00<000000?ooo`3oool03P3oool00`000000ZKgX0:Vmj00?0:Vmj0<000004@2Y
_NP00`000000ZKgX0:Vmj00>0:Vmj0<000004@2Y_NP00`000000ZKgX0:Vmj00;0:Vmj0<000000P2Y
_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002V_>T0Y[cY00T0Y[cY100000020:Flj@030000002A
/^h0TK;^00d0TK;^00<0000006NLk`1WW>l00P1WW>l3000000H0Iic_1000000703^3j0030000000W
Mn@09gOT00P09gOT0`00000:025dhP030000000PM>8087CR008087CR0`000004021dhP030000000P
M>8087CR00L087CR00@00000021dhP0000000000:`3oool00`000000oooo0?ooo`030?ooo`03@000
003ooom0000000P0oooo0T00001M0?ooo`00G03oool00`000000oooo0?ooo`0?0?ooo`8000003@2Y
_NP200000080ZKgX00<000000:Vmj02Y_NP03`2Y_NP00`000000ZKgX0:Vmj00;0:Vmj0<000000P2Y
_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00P0ZKgX0P0000060:Vmj0030000002Y
_NP0ZKgX0100ZKgX00<000000:Jlj@2V_>T01@2V_>T3000000L0YKcY00<00000096bkP2A/^h03@2A
/^h4000000X0Iic_00<0000003j5j@0nQNT00`00000503^3j0030000000WMn@09gOT00T09gOT0`00
0009025dhP030000000PM>8087CR00@087CR0P000003021dhP030000000PM>8087CR00L087CR00@0
0000021dhP0PM>800000:P3oool2000000D0oooo00=000000?ooo`3oool0203oool00d000000oooo
0?ooo`1K0?ooo`00G03oool00`000000oooo0?ooo`0A0?ooo`030000002Y_NP0ZKgX00L0ZKgX0`00
00050:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP0202Y_NP2000000H0ZKgX00<0
00000:Vmj02Y_NP0402Y_NP00`000000ZKgX0:Vmj0040:Vmj0<000002@2Y_NP00`000000ZKgX0:Vm
j00@0:Vmj0030000002V_>T0Y[cY00@000002`2U_>T00`000000TK;^096bkP0:096bkP@00000301W
W>l00`000000?XGY03j5j@0303j5j@<000000`0kPnP00`0000009gOT02Mgi00902Mgi0030000000R
M>800000008000001P0QM>800`00000087CR021dhP06021dhP80000000<087CR0000000PM>80200P
M>801000000087CR021dhP00000Y0?ooo`03@00000000000000006h0oooo001L0?ooo`80000000=0
00000?ooo`3oool0403oool00`000000ZKgX0:Vmj0030:Vmj0<000002@2Y_NP00`000000ZKgX0:Vm
j00?0:Vmj0030000002Y_NP0ZKgX00@0ZKgX0`0000090:Vmj0030000002Y_NP0ZKgX0100ZKgX00<0
00000:Vmj02Y_NP00`00000=0:Vmj0030000002Y_NP0ZKgX00l0ZKgX0`00000@0:Flj@030000002A
/^h0TK;^00H0TK;^0`000004096bkP030000001WW>l0Iic_00X0Iic_00<0000003j5j@0nQNT01@0n
QNT4000000/09gOT00<00000029dhP0RM>800P0RM>82000000D08GCR00<00000021dhP0PM>801`0P
M>83000000T087CR00@00000021dhP0PM>800000:`3oool00`000000oooo0?ooo`1[0?ooo`00G03o
ool00`000000oooo0?ooo`0C0?ooo`030000002Y_NP0ZKgX008000003@2Y_NP00`000000ZKgX0:Vm
j00?0:Vmj0030000002Y_NP0ZKgX00<000003@2Y_NP00`000000ZKgX0:Vmj00?0:Vmj0<000004@2Y
_NP00`000000ZKgX0:Vmj00;0:Vmj0<000000P2Y_NP00`000000YKcY0:Flj@0>0:Flj@030000002A
/^h0TK;^00<0TK;^0`000008096bkP030000001WW>l0Iic_00X0Iic_00<0000003j5j@0nQNT01`0n
QNT3000000X09gOT00<00000029dhP0RM>800`0RM>82000000@08GCR00<00000021dhP0PM>80200P
M>83000000P087CR00@00000021dhP0PM>800000:P3oool00`000000oooo0?ooo`1[0?ooo`00CP3o
ool5@0000080oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`0D0?ooo`800000402Y
_NP00`000000ZKgX0:Vmj00>0:Vmj0<000004@2Y_NP00`000000ZKgX0:Vmj00;0:Vmj0<000000P2Y
_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00P0ZKgX0P0000060:Vmj0030000002U
_>T0YKcY00h0YKcY00<00000096bkP0000000P00000;096bkP030000001WW>l0Iic_00/0Iic_00<0
000003j5j@0nQNT0200nQNT4000000P09gOT00<00000029dhP0RM>80100RM>83000000808GCR00<0
0000021dhP0PM>802@0PM>83000000L087CR00<00000021dhP000000:`3oool00`000000oooo0?oo
o`1Z0?ooo`00D03oool01d000000oooo0?ooo`3ooom000000?oood000000103oool00`0000100000
0?ooo`0F0?ooo`030000002Y_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP02`2Y_NP200000080ZKgX
00<000000:Vmj02Y_NP0402Y_NP00`000000ZKgX0:Vmj0080:Vmj08000001P2Y_NP00`000000ZKgX
0:Vmj00@0:Vmj0030000002Y_NP0ZKgX00@0ZKgX0`0000090:Vmj0030000002U_>T0YKcY00`0YKcY
0`00000?096bkP030000001WW>l0Iic_00/0Iic_00<0000003j5j@0nQNT0200nQNT00`000000:GWT
02Uii003000000H09gOT00<00000029dhP0RM>801P0RM>83000000/087CR00<00000021dhP0PM>80
0P000005021dhP040000000PM>8087CR000002/0oooo00<000000?ooo`3oool0J@3oool00500oooo
00M000000?ooo`3oool0oooo@000003ooom0000000@0oooo00<000000?ooo`3oool05`3oool00`00
0000ZKgX0:Vmj00?0:Vmj0030000002Y_NP0ZKgX00L0ZKgX0`0000050:Vmj0030000002Y_NP0ZKgX
0100ZKgX00<000000:Vmj02Y_NP0102Y_NP3000000T0ZKgX00<000000:Vmj02Y_NP0402Y_NP00`00
0000ZKgX0:Vmj003000000d0ZKgX00<000000:Flj@2U_>T02@2U_>T2000000<0YKcY00<00000096b
kP2A/^h01P2A/^h;000000T0Iic_00<0000003j5j@0nQNT0200nQNT00`000000:GWT02Uii00302Ui
i08000001@0WMn@00`0000008WCR029dhP07029dhP<000002P0PM>801000000087CR021dhP0PM>82
000000@087CR00@00000021dhP0PM>800000:P3oool00`000000oooo0?ooo`1Y0?ooo`00D03oool0
1d000000oooo0?ooo`3ooom000000?oood000000103oool00`000000oooo0?ooo`0H0?ooo`030000
002Y_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP00`2Y_NP3000000T0ZKgX00<000000:Vmj02Y_NP0
402Y_NP00`000000ZKgX0:Vmj003000000d0ZKgX00<000000:Vmj02Y_NP03`2Y_NP300000100ZKgX
00<000000:Flj@2U_>T01P2U_>T3000000D0YKcY2@00000808jakP030000001VW>l0IYc_00P00000
0P1WW>l00`000000?XGY03j5j@0803j5j@030000000YNN@0:GWT00@0:GWT0`00000202Mgi0030000
000RM>808WCR00T08WCR0`000009021dhP030000000PM>8087CR008087CR0`000002021dhP030000
000PM>80000002/0oooo00<000000?ooo`3oool0J03oool00500oooo00M000000?ooo`3oool0oooo
@000003ooom0000000@0oooo00<000000?ooo`3oool06@3oool00`000000ZKgX0:Vmj00?0:Vmj003
0000002Y_NP0ZKgX008000003@2Y_NP00`000000ZKgX0:Vmj00?0:Vmj0<000004@2Y_NP00`000000
ZKgX0:Vmj00;0:Vmj0<000000P2Y_NP00`000000ZKgX0:Vmj00?0:Vmj0030000002U_>T0YKcY0080
YKcY0`0000040:Flj@@000000P2S^nX00`000000S[7^08jakP0=08jakP030000001VW>l0IYc_00L0
IYc_1@00000903j5j@030000000YNN@0:GWT00H0:GWT1000000:029dhP030000000QM>808GCR0080
00001`0PM>800`00000087CR021dhP05021dhP80000000@087CR0000000PM>800000:P3oool00`00
0000oooo0?ooo`1X0?ooo`00C`3oool2@00000@0oooo00=000000?ooo`3oool00`3oool00`000010
00000?ooo`0J0?ooo`030000002Y_NP0ZKgX00h0ZKgX0`00000@0:Vmj08000003@2Y_NP200000080
ZKgX00<000000:Vmj02Y_NP0402Y_NP00`000000ZKgX0:Vmj0080:Vmj08000001P2Y_NP00`000000
ZKgX0:Vmj00?0:Vmj0@00000102U_>T3000000L0Xk_Z00<0000008jakP2>/Nh0302>/Nh00`000000
IYc_06JLk`0;06JLk`@000001`0nQNT00`000000:GWT02Uii00802Uii0<000002@0RM>8010000000
8GCR025dhP0QM>82000000H087CR00<00000021dhP0PM>801P0PM>820000008087CR00<000000?oo
o`3oool0:03oool00`000000oooo0?ooo`1W0?ooo`00F`3oool00`000000oooo0?ooo`0K0?ooo`03
0000002Y_NP0ZKgX00/0ZKgX0P0000020:Vmj0030000002Y_NP0ZKgX0100ZKgX00<000000:Vmj02Y
_NP01`2Y_NP3000000D0ZKgX00<000000:Vmj02Y_NP0402Y_NP00`000000ZKgX0:Vmj0040:Vmj0<0
00002@2Y_NP00`000000ZKgX0:Vmj00<0:Vmj0@000000P2U_>T4000000X0Xk_Z00<0000008jakP2>
/Nh03@2>/Nh00`000000IYc_06JLk`0;06JLk`0300000011Q^X0@HKZ00<000001@0nQNT00`000000
:GWT02Uii00902Uii0<00000200RM>800`0000008GCR025dhP02025dhP800000100PM>800`000000
87CR021dhP08021dhP<00000:`3oool00`000000oooo0?ooo`1V0?ooo`00FP3oool00`000000oooo
0?ooo`0M0?ooo`030000002Y_NP0ZKgX00L0ZKgX0`0000050:Vmj0030000002Y_NP0ZKgX0100ZKgX
00<000000:Vmj02Y_NP00`2Y_NP3000000T0ZKgX00<000000:Vmj02Y_NP0402Y_NP00`000000ZKgX
0:Vmj003000000d0ZKgX00<000000:Vmj02Y_NP0202Y_NP3000000<0ZKgX0`00000?0:>kjP030000
002>/Nh0S[7^00d0S[7^00<0000006JLk`1VW>l02P1VW>l00`000000@HKZ0466jP030466jP<00000
0P0nQNT00`000000:GWT02Uii00902Uii0030000000RMN<08WGS008000001`0RM>800`0000008GCR
025dhP03025dhP8000000`0PM>800`00000087CR021dhP08021dhP<00000:@3oool00d0000000000
0000001W0?ooo`00FP3oool00`00001000000?ooo`0N0?ooo`030000002Y_NP0ZKgX00<0ZKgX0`00
00090:Vmj0030000002Y_NP0ZKgX0100ZKgX00<000000:Vmj02Y_NP00P00000=0:Vmj0030000002Y
_NP0ZKgX00l0ZKgX0`00000@0:Vmj0030000002Y_NP0ZKgX00D0ZKgX0`0000030:Vmj0<000000P2Y
_NP00`000000Xk_Z0:>kjP0>0:>kjP030000002>/Nh0S[7^00d0S[7^00<0000006JLk`1VW>l02P1V
W>l00`000000@HKZ0466jP050466jP@000002`0YNN@0100000008WGS029eh`0RMN<2000000D08WCR
00<00000025dhP0QM>801@0QM>820000008087CR00<00000021dhP0PM>801`0PM>801000000087CR
021dhP00000Z0?ooo`030000003oool0oooo06D0oooo001J0?ooo`030000003oool0oooo01l0oooo
00<000000:Vmj02Y_NP00P00000=0:Vmj0030000002Y_NP0ZKgX00l0ZKgX0`00000@0:Vmj0030000
002Y_NP0ZKgX00/0ZKgX0`0000020:Vmj0030000002Y_NP0ZKgX00l0ZKgX00@000000:Vmj02Y_NP0
ZKgX0`0000040:Vmj08000001P2Y_NP00`000000Xk_Z0:>kjP0>0:>kjP030000002>/Nh0S[7^00`0
S[7^00<0000006JLk`1VW>l02`1VW>l00`000000@HKZ0466jP070466jP<000002P0YNN@00`000000
8WGS029eh`02029eh`<000000`0RM>800`0000008GCR025dhP06025dhP<000002P0PM>800`000000
87CR0000000[0?ooo`030000003oool0oooo06@0oooo001J0?ooo`030000003oool0oooo0200oooo
0P00000@0:Vmj0030000002Y_NP0ZKgX00/0ZKgX0`0000020:Vmj0030000002Y_NP0ZKgX00l0ZKgX
00<000000:Vmj02Y_NP0202Y_NP2000000H0ZKgX00<000000:Vmj02Y_NP03`2Y_NP3000000@0ZKgX
0`0000090:Vmj0030000002S^nX0Xk_Z00h0Xk_Z00<0000008jakP2>/Nh0302>/Nh00`000000IYc_
06JLk`0;06JLk`0300000011Q^X0@HKZ00P0@HKZ0`00000902Uii0030000000RMN<08WGS00@08WGS
0P000002029dhP030000000QM>808GCR00L08GCR0`000009021dhP030000000PM>80000002X0oooo
00<000000?ooo`3oool0I03oool005X0oooo00<000000?ooo`3oool08@3oool00`000000ZKgX0:Vm
j00?0:Vmj0030000002Y_NP0ZKgX00P0ZKgX0P0000060:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<0
00000:Vmj02Y_NP0102Y_NP3000000T0ZKgX00<000000:Vmj02Y_NP02`2Y_NP3000000040:Vmj000
0000ZKgX0:Vmj0<000003@2Y_NP00`000000Xk_Z0:>kjP0=0:>kjP030000002>/Nh0S[7^00X0S[7^
1`00000906JLk`0300000011Q^X0@HKZ00T0@HKZ00<0000002aji@0000000P00000602Uii0030000
000RMN<08WGS00H08WGS0`00000;025dhP<00000200PM>800`00000087CR0000000Z0?ooo`030000
003oool0oooo06<0oooo001J0?ooo`03000004000000oooo0280oooo00<000000:Vmj02Y_NP03`2Y
_NP00`000000ZKgX0:Vmj0040:Vmj0<000002@2Y_NP00`000000ZKgX0:Vmj00?0:Vmj0030000002Y
_NP0ZKgX00<000003@2Y_NP00`000000ZKgX0:Vmj0080:Vmj0800000102Y_NP300000100ZKgX00<0
00000:>kjP2S^nX03P2S^nX00`000000S[7^08jakP0208jakPL00000102</>h00`000000IYc_06JL
k`0800000080IYc_00<000000466jP11Q^X02@11Q^X010000000;7[U02aji@0/N^D3000000@0:GWT
00<00000029eh`0RMN<01`0RMN<3000000X08GCR00@00000021dhP00000000001P0PM>8010000000
87CR021dhP00000Z0?ooo`030000003oool0oooo0680oooo001I0?ooo`030000003oool0oooo02@0
oooo00<000000:Vmj02Y_NP03`2Y_NP00`000000ZKgX0:Vmj003000000d0ZKgX00<000000:Vmj02Y
_NP03P2Y_NP300000100ZKgX00<000000:Vmj02Y_NP01@2Y_NP3000000<0ZKgX0`0000020:Vmj003
0000002Y_NP0ZKgX00l0ZKgX00<000000:>kjP2S^nX0302S^nX6000000`0S;3^00<0000006JLk`1V
W>l01`1VW>l5000000X0@HKZ00<0000002aji@0/N^D00`0/N^D2000000<0:GWT00<00000029eh`0R
MN<0200RMN<3000000P08GCR00@00000021dhP0PM>8087CR0`000004021dhP030000000PM>800000
02X0oooo00<000000?ooo`3oool0HP3oool005T0oooo00<000000?ooo`3oool09@3oool2000000l0
ZKgX0`00000A0:Vmj0030000002Y_NP0ZKgX00/0ZKgX0P0000020:Vmj0030000002Y_NP0ZKgX00l0
ZKgX00@000000:Vmj02Y_NP0ZKgX0`0000040:Vmj08000001P2Y_NP00`000000ZKgX0:Vmj00?0:Vm
j0030000002S^nX0Xk_Z00L0Xk_Z100000030::jjP030000002</>h0S;3^00`0S;3^00<0000006JL
k`1VW>l02`1VW>l4000000L0@HKZ00<0000002aji@0/N^D01@0/N^D4000000/08WGS00@00000025d
hP00000000001`0QM>800`00000087CR021dhP03021dhP8000000`0PM>800`00000087CR0000000Z
0?ooo`030000003oool0oooo0640oooo001I0?ooo`030000003ooom0000002L0oooo00<000000:Vm
j02Y_NP02@2Y_NP300000080ZKgX00<000000:Vmj02Y_NP0402Y_NP00`000000ZKgX0:Vmj0070:Vm
j0<000001@2Y_NP00`000000ZKgX0:Vmj00?0:Vmj0<00000102Y_NP3000000T0ZKgX00<000000:Vm
j02Y_NP03`2Y_NP010000000Xk_Z0:>kjP2S^nX5000000P0X[[Z00<0000008b`kP2</>h0302</>h0
0`000000IYc_06JLk`0;06JLk`0300000012R>X0@XSZ00<000001@11Q^X00`000000;7[U02aji@07
02aji@<000002@0RMN<0100000008GCR025dhP0QM>82000000H08GCR00<00000021dhP0PM>80100P
M>8300000004021dhP00000087CR000002X0oooo00<000000?ooo`3oool0H03oool005T0oooo0P00
000Y0?ooo`030000002Y_NP0ZKgX00@0ZKgX100000060:Vmj0030000002Y_NP0ZKgX0100ZKgX00<0
00000:Vmj02Y_NP00`2Y_NP3000000T0ZKgX00<000000:Vmj02Y_NP02`2Y_NP3000000040:Vmj000
0000ZKgX0:Vmj0<000003@2Y_NP00`000000ZKgX0:Vmj00>0:Vmj0@000003P2R^^X00`000000S;3^
08b`kP0<08b`kP030000001VW>l0IYc_00X0IYc_00<0000004:8jP12R>X00`12R>X400000080@HKZ
00<0000002aji@0/N^D0200/N^D3000000P08WGS00<00000025dhP0QM>800P0QM>83000000@08GCR
00<00000021dhP0PM>801P0PM>820000008087CR00<000000?ooo`3oool09`3oool00`000000oooo
0?ooo`1P0?ooo`00C03oool3@00000<0oooo00=000000?ooo`3oool0103oool00`000000oooo0?oo
o`0Y0?ooo`030000002Y_NP0ZKgX00<000002`2Y_NP00`000000ZKgX0:Vmj00@0:Vmj0030000002Y
_NP0ZKgX008000003@2Y_NP00`000000ZKgX0:Vmj0070:Vmj0<00000102Y_NP300000100ZKgX00<0
00000:Vmj02Y_NP02`2Y_NP300000080Z;gX00<000000::jjP2R^^X03P2R^^X00`000000S;3^08b`
kP0<08b`kP030000001VW>l0IYc_00X0IYc_00<0000004:8jP12R>X01P12R>X4000000X0;7[U00<0
000002=fh`0000000P000006029eh`030000000QM>808GCR00@08GCR0P000003025dhP030000000P
M>8087CR00L087CR0`00000Z0?ooo`030000003oool0oooo05l0oooo001<0?ooo`03@000003oool0
oooo0080oooo00=000000?oood0000001@3oool00`000000oooo0?ooo`0Z0?ooo`8000003`2Y_NP2
00000100ZKgX0`00000@0:Vmj0030000002Y_NP0ZKgX00<0ZKgX0`0000050:Vmj08000000P2Y_NP0
0`000000ZKgX0:Vmj00?0:Vmj0030000002Y_NP0ZKgX00P0ZKgX0P0000060:Rmj0030000002R^^X0
X[[Z00d0X[[Z00<0000008b`kP2</>h03@2</>h00`000000IYc_06JLk`0:06JLk`0300000012R>X0
@XSZ00P0@XSZ0`00000802aji@030000000SM^<08gKS00808gKS0P000005029eh`030000000QM>80
8GCR00D08GCR0P0000000`0QM>800000021dhP09021dhP<00000:03oool00d000000oooo0000001P
0?ooo`00C@3oool01d000000oooo0?ooo`3ooom000000?oood000000103oool200000003@000003o
ool0oooo02X0oooo00<000000:Vmj02Y_NP03`2Y_NP00`000000ZKgX0:Vmj0090:Vmj0@000000P2Y
_NP00`000000ZKgX0:Vmj00?0:Vmj0030000002Y_NP00000008000001@2Y_NP3000000D0ZKgX00<0
00000:Vmj02Y_NP03`2Y_NP00`000000ZKgX0:Vmj0040:Vmj0<000002@2X_NP00`000000X[[Z0::j
jP0=0::jjP030000002</>h0S;3^00`0S;3^00<0000006JLk`1VW>l02`1VW>l00`000000@XSZ04:8
jP0904:8jP<000001`0/N^D00`0000008gKS02=fh`0302=fh`800000100RMN<00`0000008GCR025d
hP06025dhP<000002@0PM>801000000087CR021dhP00000Y0?ooo`030000003oool0oooo05h0oooo
001=0?ooo`07@000003oool0oooo0?oood000000oooo@00000040?ooo`030000003oool0oooo02d0
oooo00<000000:Vmj02Y_NP03`2Y_NP00`000000ZKgX0:Vmj0050:Vmj0<000001`2Y_NP00`000000
ZKgX0:Vmj00=0:Vmj0<000001@2Y_NP3000000T0ZKgX00<000000:Vmj02Y_NP03`2Y_NP00`000000
ZKgX0:Vmj003000000d0Z;gX00<000000::jjP2R^^X03@2R^^X00`000000S;3^08b`kP0<08b`kP03
0000001VW>l0IYc_00/0IYc_00<0000004:8jP12R>X02012R>X00`000000;G_U02eki@02000000H0
;7[U00<0000002=fh`0SM^<0100SM^<300000003029eh`0000008GCR00T08GCR0`000008021dhP04
0000000PM>8087CR000002T0oooo00<000000?ooo`3oool0G@3oool004`0oooo00=000000?oood00
00000P3oool00d000000oooo@00000040?ooo`030000003oool0oooo02h0oooo00<000000:Vmj02Y
_NP03`2Y_NP00`000000ZKgX0:Vmj004000000/0ZKgX00<000000:Vmj02Y_NP02@2Y_NP3000000<0
ZKgX00<000000:Vmj02Y_NP00P00000=0:Vmj0030000002Y_NP0ZKgX00h0ZKgX0`00000@0:Rmj003
0000002R^^X0X[[Z00h0X[[Z00<0000008b`kP2</>h01P2</>h:000000T0IYc_00<0000004:8jP12
R>X02@12R>X010000000;G_U02eki@0]NnD2000000D0;7[U00<0000002=fh`0SM^<01P0SM^<30000
00/08GCR0`000007021dhP030000000PM>80000002X0oooo00<000000?ooo`3oool0G03oool004d0
oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`030?ooo`03000004000000oooo02l0
oooo00<000000:Vmj02Y_NP03P2Y_NP300000100ZKgX00<000000:Vmj02Y_NP01P2Y_NP2000000H0
ZKgX0`00000?0:Vmj0030000002Y_NP0ZKgX00/0ZKgX0`0000020:Vmj0030000002X_NP0Z;gX00l0
Z;gX00<000000::jjP2R^^X0302R^^X:000000L0RJo_00<0000006JLk`1VW>l02000000206JLk`03
00000012R>X0@XSZ00T0@XSZ00<0000002eki@0]NnD00P0]NnD3000000<0;7[U00<0000002=fh`0S
M^<01`0SM^<3000000X08GCR00@00000021dhP00000000001P0PM>800`00000087CR0000000Y0?oo
o`030000003oool0oooo05`0oooo001H0?ooo`030000003oool0oooo0300oooo00<000000:Vmj02Y
_NP02`2Y_NP200000080ZKgX00<000000:Vmj02Y_NP03`2Y_NP00`000000ZKgX0:Vmj0020:Vmj0<0
0000102Y_NP400000080ZKgX00<000000:Vmj02Y_NP03P2Y_NP00`000000ZKgX0:Vmj0080:Vmj080
00001P2Y_NP00`000000Z;gX0:Rmj00?0:Rmj0030000002R^^X0X[[Z00L0X[[Z100000030:2jj`03
00000029[nl0RJo_00`0RJo_00<0000006JLk`1VW>l01`1VW>l5000000X0@XSZ00<0000002eki@0]
NnD0100]NnD20000000302aji@0000008gKS00X08gKS0`000008025dhP040000000PM>8087CR021d
hP<000000`0PM>801000000087CR021dhP00000Y0?ooo`030000003oool0oooo05/0oooo001H0?oo
o`030000003oool0oooo0340oooo00<000000:Vmj02Y_NP01`2Y_NP3000000D0ZKgX00<000000:Vm
j02Y_NP03`2Y_NP4000000@0ZKgX0`0000070:Vmj0030000002Y_NP0ZKgX00h0ZKgX00<000000:Vm
j02Y_NP0102Y_NP3000000T0ZKgX00<000000:Rmj02X_NP03`2X_NP010000000X[[Z0::jjP2R^^X5
000000P0X;[[00<0000008V_k`29[nl02`29[nl00`000000IYc_06JLk`0;06JLk`@000001`12R>X0
0`000000;G_U02eki@0602eki@<000002P0SM^<00`0000008GCR025dhP02000000L08GCR00<00000
021dhP0PM>800`0PM>820000008087CR00@00000021dhP0PM>800000:@3oool00`000000oooo0?oo
o`1J0?ooo`00E`3oool00`000000oooo0?ooo`0c0?ooo`030000002Y_NP0ZKgX00<0ZKgX0`000009
0:Vmj0030000002Y_NP0ZKgX00`0ZKgX100000020:Vmj0@000002`2Y_NP00`000000ZKgX0:Vmj00>
0:Vmj0030000002Y_NP0ZKgX00<000003@2Y_NP00`000000Z;gX0:Rmj00>0:Rmj0@000003P2P^^/0
0`000000RJo_08V_k`0;08V_k`030000001VW>l0IYc_00/0IYc_00<0000004B9j`14RN/00`000005
04:8jP030000000]NnD0;G_U00L0;G_U0`00000902=fh`040000000QM>808GCR025dhP8000001P0Q
M>800`00000087CR021dhP04021dhP@000000P0PM>800`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo05X0oooo001G0?ooo`80000000=000000?ooo`3oool0<P3oool00`000000ZKgX0:Vmj002
000000d0ZKgX00<000000:Vmj02Y_NP0202Y_NP3000000<0ZKgX0`00000@0:Vmj0030000002Y_NP0
ZKgX00d0ZKgX0`00000A0:Vmj0030000002X_NP0Z;gX00T0Z;gX100000020:Rmj0030000002P^^/0
X;[[00h0X;[[00<0000008V_k`29[nl02`29[nl00`000000IYc_06JLk`0:06JLk`0300000014RN/0
A8W[00<0A8W[0`00000304:8jP030000000]NnD0;G_U00P0;G_U0`00000802=fh`030000000QM>80
8GCR00808GCR0`000004025dhP030000000PM>8087CR00H087CR0P0000000`0PM>8000000?ooo`0X
0?ooo`030000003oool0oooo05T0oooo00040?ooo`90000000<0oooo@000040000001T0000001@3o
oom00000@00004000000oooo00900000303oool2@00000040?oood0000100000@00000@0oooo0T00
00020?ooo`=0000000<0oooo@000040000000d00000N0?ooo`030000003oool0oooo03D0oooo0P00
000@0:Vmj0030000002Y_NP0ZKgX00@0ZKgX0`0000040:Vmj08000000P2Y_NP00`000000ZKgX0:Vm
j00?0:Vmj0030000002Y_NP0ZKgX00T0ZKgX0`0000020:Vmj0030000002Y_NP0ZKgX0100ZKgX00<0
00000:Rmj02X_NP01@2X_NP3000000L0Z;gX00<000000:2jj`2P^^/03@2P^^/00`000000RJo_08V_
k`0<08V_k`030000001VW>l0IYc_00X0IYc_00<0000004B9j`14RN/01@14RN/4000000/0;G_U00@0
000002Efh`00000000001`0SM^<00`0000008GCR025dhP04025dhP8000000`0QM>800`00000087CR
021dhP06021dhP@00000:03oool2000005X0oooo00030?ooo`03@000003oool0oooo0080oooo00M0
00000?ooo`3ooom000000?oood000000oooo00=000000`3oool00d000000oooo0?ooo`090?ooo`06
@000003oool0oooo@000003ooom00000103oool00d000000oooo0?ooo`030?ooo`05@000003oool0
oooo0?oood0000000P3oool00d000000oooo0?ooo`0L0?ooo`030000003oool0oooo03H0oooo00<0
00000:Vmj02Y_NP03`2Y_NP00`000000ZKgX0:Vmj003000000@0ZKgX0`0000050:Vmj0030000002Y
_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP0102Y_NP4000000H0ZKgX00<000000:Vmj02Y_NP0402Y
_NP00`000000Z;gX0:Rmj004000000/0Z;gX00<000000:2jj`2P^^/03@2P^^/00`000000RJo_08V_
k`0;08V_k`030000001VW>l0IYc_00/0IYc_00<0000004B9j`14RN/01`14RN/3000000T0;G_U00@0
000002Efh`0UM^<09GKS0P00000502=fh`030000000QM>808GCR00H08GCR0P0000000`0QM>800000
021dhP08021dhP040000000PM>800000000002L0oooo00=000000000003oool0F@3oool000<0oooo
00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`05@000003ooom00000@000003o
ool00d00000<0?ooo`05@000003oool0oooo@000003oool00d0000020?ooo`03@000003oool0oooo
00<0oooo00E000000?ooo`3oool0oooo@000000Q0?ooo`030000003oool0oooo03L0oooo00<00000
0:Vmj02Y_NP03P2Y_NP3000000@0ZKgX0`0000090:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<00000
0:Vmj02Y_NP00`00000;0:Vmj0030000002Y_NP0ZKgX00l0ZKgX0`00000@0:Rmj0030000002P^^/0
X;[[00d0X;[[00<0000008V_k`29[nl02`29[nl00`000000IYc_06JLk`0;06JLk`0300000014RN/0
A8W[00P0A8W[0`00000802eki@030000000UM^<09GKS00809GKS0`00000302=fh`030000000QM>80
8GCR00L08GCR0`000009021dhP040000000PM>8087CR000002P0oooo00<000000?ooo`3oool0E`3o
ool000<0oooo00=000000?ooo`3oool00P3oool2@00000<0oooo0T0000001P3ooom000000?oood00
0000oooo@00000`0oooo00I000000?ooo`3ooom000000?oood0000020?ooo`03@000003ooom00000
00D0oooo00A000000?ooo`3oool0oooo0T00000P0?ooo`03000004000000oooo03P0oooo00<00000
0:Vmj02Y_NP02P2Y_NP300000080ZKgX00<000000:Vmj02Y_NP00P00000=0:Vmj0030000002Y_NP0
ZKgX00h0ZKgX0`00000?0:Vmj0030000002Y_NP0ZKgX00/0ZKgX0`0000020:Vmj0030000002X_NP0
Z;gX00h0Z;gX00<000000:2jj`2P^^/0302P^^/D000000T0IYc_00<0000004B9j`14RN/02@14RN/0
0`000000;gcV00000002000000H0;G_U00<0000002Efh`0UM^<0100UM^<2000000808gKS00<00000
025dhP0QM>80200QM>83000000L087CR00@00000021dhP0PM>800000:03oool00`000000oooo0?oo
o`1G0?ooo`000`3oool00d000000oooo@00000020?ooo`05@000003oool0oooo@000003oool00T00
00001@3ooom000000?ooo`3ooom0000000d0oooo00I000000?ooo`3ooom000000?oood0000020?oo
o`05@000003ooom000000?oood0000000`3oool01D000000oooo0?ooo`3ooom000000080oooo00=0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`0j0?ooo`8000001`2Y_NP3000000D0ZKgX0`00
000@0:Vmj0030000002Y_NP0ZKgX00/0ZKgX0P0000020:Vmj0030000002Y_NP0ZKgX00h0ZKgX00<0
00000:Vmj02Y_NP0202Y_NP2000000H0ZKgX00<000000:Rmj02X_NP03P2X_NP00`000000X;[[0:2j
j`070:2jj`@000000`2O^N/00`000000R:k_08R^k`0;08R^k`030000001UW>l0IIc_00P000000P1V
W>l00`000000A8W[04B9j`0804B9j`030000000_O>H0;gcV0080;gcV0`00000402eki@030000000U
M^<09GKS00D09GKS0`00000<025dhP<000001P0PM>801000000087CR021dhP00000X0?ooo`030000
003oool0oooo05H0oooo00030?ooo`=0000000<0oooo@000040000001D000000103ooom00000@000
003oool2@00000h0oooo0T0000000`3ooom00000@0000002@0000080oooo0d0000020?ooo`=00000
00<0oooo@000040000000d00000M0?ooo`030000003oool0oooo03`0oooo00<000000:Vmj02Y_NP0
0P2Y_NP2000000D0ZKgX0`0000020:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP0
1`2Y_NP3000000D0ZKgX00<000000:Vmj02Y_NP03P2Y_NP00`000000ZKgX0:Vmj0040:Vmj0<00000
2@2Y_NP00`000000Z;gX0:Rmj00>0:Rmj0040000002P^^/0X;[[0:2jj`D00000202O^N/00`000000
R:k_08R^k`0;08R^k`030000001UW>l0IIc_00L0IIc_1@00000904B9j`030000000_O>H0;gcV00@0
;gcV0P00000202eki@030000000UM^<09GKS00L09GKS0`00000:025dhP030000000QM>808GCR0080
00001@0PM>801000000087CR021dhP00000X0?ooo`030000003oool0oooo05D0oooo001F0?ooo`03
0000003ooom0000003d0oooo100000030:Vmj0@000001P2Y_NP00`000000ZKgX0:Vmj00?0:Vmj003
0000002Y_NP0ZKgX00<0ZKgX0`0000090:Vmj0030000002Y_NP0ZKgX00h0ZKgX00<000000:Vmj02Y
_NP00`00000=0:Vmj0030000002X_NP0Z;gX00d0Z;gX1000000=09nij`0300000028[^l0R:k_00/0
R:k_00<0000006FLk`1UW>l02`1UW>l4000000L0A8W[00<0000002mliP0_O>H01@0_O>H4000000X0
9GKS0`000009025dhP040000000QM>808GCR025dhP800000100PM>801000000087CR021dhP00000W
0?ooo`030000003oool0oooo05D0oooo001F0?ooo`800000?03oool400000080ZKgX0`00000;0:Vm
j0030000002Y_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP00P00000=0:Vmj0030000002Y_NP0ZKgX
00d0ZKgX0`00000@0:Vmj0030000002X_NP0Z;gX00/0Z;gX0P0000020:Rmj0030000002O^N/0WkW[
00d0WkW[00<0000008R^k`28[^l02`28[^l00`000000IIc_06FLk`0;06FLk`0300000015RN/0AHW[
00<000001@14RN/00`000000;gcV02mliP0702mliP8000002@0UM^<00`0000008WCS029dh`020000
00P08GCR00<00000025dhP0QM>800P0QM>8300000005021dhP00000087CR021dhP000000:03oool0
0`000000oooo0?ooo`1D0?ooo`00B@3oool2@00000@0oooo00=000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0h0?ooo`<00000103oool2000000l0ZKgX0P00000?0:Vmj0<00000402Y_NP00`00
0000ZKgX0:Vmj0090:Vmj0<000000P2Y_NP00`000000ZKgX0:Vmj00?0:Vmj0030000002X_NP0Z;gX
00L0Z;gX0`0000050:Rmj0030000002O^N/0WkW[00d0WkW[00<0000008R^k`28[^l02`28[^l00`00
0000IIc_06FLk`0:06FLk`0300000015RN/0AHW[00<0AHW[0`00000204B9j`030000000_O>H0;gcV
00T0;gcV0P00000802Efh`040000000RM><08WCS029dh`8000001`0QM>800`0000008GCR025dhP04
025dhP<000000P0PM>800`000000oooo0?ooo`0V0?ooo`030000003oool0oooo05<0oooo001;0?oo
o`06@000003oool0oooo@000003ooom000001@3oool00`000000oooo0?ooo`0e0?ooo`<00000203o
ool00`000000ZKgX0:Vmj00?0:Vmj0030000002Y_NP0ZKgX00T0ZKgX0`0000020:Vmj0030000002Y
_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP0102Y_NP4000000H0ZKgX00<000000:Vmj02Y_NP03`2Y
_NP00`000000Z;gX0:Rmj0030:Rmj0<000002@2X_NP00`000000WkW[09nij`0=09nij`0300000028
[^l0R:k_00/0R:k_00<0000006FLk`1UW>l02P1UW>l00`000000AHW[04F9j`0504F9j`@000002`0_
O>H3000000L09GKS00<00000029dh`0RM><00P0RM><3000000@08GCR00<00000025dhP0QM>801P0Q
M>820000008087CR00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1C0?ooo`00BP3oool0
1d000000oooo0?ooo`3ooom000000?oood000000103oool200000003@000003oool0oooo0340oooo
0`00000<0?ooo`030000002Y_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP0102Y_NP4000000H0ZKgX
00<000000:Vmj02Y_NP03`2Y_NP00`000000ZKgX0:Vmj003000000/0ZKgX00<000000:Vmj02Y_NP0
3`2Y_NP00`000000Z;gX0:Rmj002000000d0Z;gX00<0000009nij`2O^N/0302O^N/00`000000R:k_
08R^k`0;08R^k`030000001UW>l0IIc_00/0IIc_00<0000004F9j`15RN/01`15RN/3000000T0;gcV
00<0000002Igi00VMn@00P00000602Efh`030000000RM><08WCS00@08WCS0P000003025dhP030000
000QM>808GCR00H08GCR1000000W0?ooo`800000E03oool004/0oooo00I000000?ooo`3ooom00000
0?oood0000040?ooo`030000003oool0oooo0300oooo0`00000@0?ooo`030000002Y_NP0ZKgX00l0
ZKgX00<000000:Vmj02Y_NP00`00000;0:Vmj0030000002Y_NP0ZKgX00h0ZKgX0`00000?0:Vmj003
0000002Y_NP0ZKgX00h0ZKgX0`00000?0:Rmj0030000002O^N/0WkW[00d0WkW[00<0000008R^k`28
[^l02`28[^l00`000000IIc_06FLk`0;06FLk`0300000015RN/0AHW[00P0AHW[0`00000802mliP04
0000000VMn@09WOT02Igi0800000100UM^<00`0000008WCS029dh`06029dh`8000000P0QM>800`00
00008GCR025dhP06025dhP040000000QM>800000000002<0oooo0`0000000`3oool000000?ooo`1C
0?ooo`00B@3oool00d000000oooo@00000020?ooo`03@000003ooom0000000@0oooo00<000000?oo
o`3oool0;@3oool3000001@0oooo0P00000?0:Vmj0<000003`2Y_NP00`000000ZKgX0:Vmj00;0:Vm
j08000000P2Y_NP00`000000ZKgX0:Vmj00>0:Vmj0030000002Y_NP0ZKgX00T0ZKgX100000020:Vm
j0030000002X_NP0Z;gX00h0Z;gX00<0000009nij`2O^N/02`2O^N/D000000T0IIc_00<0000004F9
j`15RN/02@15RN/00`000000<GgV00000002000000H0;gcV00<0000002Igi00VMn@00P0VMn@20000
00<09GKS00<00000029dh`0RM><01`0RM><3000000T08GCR00@00000025dhP0QM>8000007P3oool4
000000@0oooo00<000000?ooo`3oool0DP3oool004X0oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`030?ooo`030000003oool0oooo02X0oooo0`00000I0?ooo`030000002Y_NP0ZKgX
00T0ZKgX0`0000020:Vmj0030000002Y_NP0ZKgX00h0ZKgX00<000000:Vmj02Y_NP01`2Y_NP30000
00D0ZKgX00<000000:Vmj02Y_NP03P2Y_NP00`000000ZKgX0:Vmj0050:Vmj0<000001`2Y_NP00`00
0000Z;gX0:Rmj00>0:Rmj0030000002O^N/0WkW[00H0WkW[1000000309fik00300000026[^l0QZk_
00/0QZk_00<0000006FLk`1UW>l02000000206FLk`0300000015RN/0AHW[00P0AHW[00<00000035m
iP0aONH00P0aONH3000000@0;gcV00<0000002Igi00VMn@00`0VMn@2000000809GKS00<00000029d
h`0RM><0200RM><3000000P08GCR00<00000025dhP0000006`3oool3000000P0oooo00<000000?oo
o`3oool0DP3oool005D0oooo00<00000@000003oool09`3oool3000001d0oooo00<000000:Vmj02Y
_NP0102Y_NP4000000H0ZKgX00<000000:Vmj02Y_NP03P2Y_NP00`000000ZKgX0:Vmj0030:Vmj0<0
00002@2Y_NP00`000000ZKgX0:Vmj00>0:Vmj0030000002Y_NP0ZKgX00@000002`2Y_NP00`000000
Z;gX0:Rmj00>0:Rmj0040000002O^N/0WkW[09nij`@00000202M^N`00`000000QZk_08J^k`0;08J^
k`030000001UW>l0IIc_00L0IIc_1@00000904F9j`030000000aONH0<GgV00@0<GgV0P00000202ml
iP030000000VMn@09WOT00D09WOT0`00000<029dh`<000001P0QM>80100000008GCR025dhP00000G
0?ooo`<00000303oool00`000000oooo0?ooo`1A0?ooo`00E@3oool00`000000oooo0?ooo`0U0?oo
o`8000008@3oool00`000000ZKgX0:Vmj003000000/0ZKgX00<000000:Vmj02Y_NP03P2Y_NP00`00
0000ZKgX0:Vmj002000000d0ZKgX00<000000:Vmj02Y_NP03@2Y_NP300000100ZKgX00<000000:Rm
j02X_NP03@2X_NP4000000d0WKW/00<0000008J^k`26[^l02`26[^l00`000000IIc_06FLk`0:06FL
k`@000001`15RN/00`000000<GgV035miP05035miP@00000200VMn@3000000/08WCS00@00000025d
hP00000000001@0QM>80100000008GCR025dhP00000B0?ooo`@000003`3oool00`000000oooo0?oo
o`1A0?ooo`00E03oool00`000000oooo0?ooo`0S0?ooo`<00000903oool2000000l0ZKgX00<00000
0:Vmj02Y_NP03@2Y_NP300000100ZKgX00<000000:Vmj02Y_NP02@2Y_NP300000080ZKgX00<00000
0:Vmj02Y_NP03P2Y_NP00`000000Z;gX0:Rmj0090:Rmj0@000000P2W_>T00`000000WKW/09fik00=
09fik00300000026[^l0QZk_00/0QZk_00<0000006FLk`1UW>l02P1UW>l00`000000AX[[04J:j`03
000000D0AHW[00<00000035miP0aONH01`0aONH2000000T09WOT0`000009029dh`040000000QM>80
8GCR025dhP800000100QM>80100000008GCR025dhP00000>0?ooo`<000004`3oool00`000000oooo
0?ooo`1A0?ooo`00E03oool00`000000oooo@000000P0?ooo`<00000:03oool00`000000ZKgX0:Vm
j00>0:Vmj0030000002Y_NP0ZKgX00T0ZKgX0`0000020:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<0
00000:Vmj02Y_NP0102Y_NP4000000H0ZKgX00<000000:Vmj02Y_NP03P2Y_NP00`000000Z;gX0:Rm
j0050:Rmj0<000001`2W_>T00`000000WKW/09fik00<09fik00300000026[^l0QZk_00/0QZk_00<0
000006FLk`1UW>l02P1UW>l00`000000AX[[04J:j`0304J:j`<000000P15RN/00`000000<GgV035m
iP09035miP800000200VMn@00`0000008WGS00000002000000L08WCS00<00000025dhP0QM>800P0Q
M>83000000808GCR00<00000025dhP0000002`3oool3000001H0oooo00<000000?ooo`3oool0D@3o
ool005@0oooo0P00000N0?ooo`<00000;03oool00`000000ZKgX0:Vmj00>0:Vmj0030000002Y_NP0
ZKgX00@0ZKgX100000060:Vmj0030000002Y_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP00`00000;
0:Vmj0030000002Y_NP0ZKgX00h0ZKgX00<000000:Rmj02X_NP01000000;0:Nlj@030000002M^N`0
WKW/00`0WKW/00<0000008J^k`26[^l02`26[^l00`000000IIc_06FLk`0:06FLk`0300000016R^/0
AX[[00D0AX[[1000000:035miP040000000WN>@00000000000H09WOT00<00000029eh`0RMN<00P0R
MN<2000000H08WCS00<00000025dhP0QM>80100QM>83000000808GCR00<000000?ooo`3oool0103o
ool4000001T0oooo00<000000?ooo`3oool0D@3oool005@0oooo00<000000?ooo`3oool06P3oool3
00000300oooo00<000000:Vmj02Y_NP03P2Y_NP00`000000ZKgX0:Vmj003000000/0ZKgX00<00000
0:Vmj02Y_NP03P2Y_NP3000000l0ZKgX00<000000:Vmj02Y_NP03@2Y_NP300000100YkcY00<00000
09fik02M^N`0302M^N`00`000000QZk_08J^k`0;08J^k`030000001UW>l0IIc_00X0IIc_00<00000
04J:j`16R^/01`16R^/3000000T0<GgV00<0000002Mhi00WN>@00P00000502Igi0030000000RMN<0
8WGS00<08WGS0`000004029dh`030000000QM>808GCR00D08GCR0P000002025dhP030000003oool0
oooo00<000007@3oool00`000000oooo0?ooo`1A0?ooo`00E03oool00`000000oooo0?ooo`0G0?oo
o`<00000=03oool00`000000ZKgX0:Vmj00=0:Vmj0<000003`2Y_NP00`000000ZKgX0:Vmj00;0:Vm
j08000000P2Y_NP00`000000ZKgX0:Vmj00>0:Vmj0030000002Y_NP0ZKgX00T0ZKgX0`0000020:Vm
j0030000002W_>T0YkcY00h0YkcY00<0000009fik02M^N`02`2M^N`C000000X0IIc_00<0000004J:
j`16R^/02016R^/3000000P0<GgV00@0000002Mhi00WN>@09gST0P00000402Igi0030000000RMN<0
8WGS00D08WGS0`0000000`0RM><00000025dhP08025dhPD00000803oool00`000000oooo0?ooo`1A
0?ooo`00E03oool00`00001000000?ooo`0D0?ooo`<00000>03oool00`000000ZKgX0:Vmj0090:Vm
j0<000000P2Y_NP00`000000ZKgX0:Vmj00>0:Vmj0030000002Y_NP0ZKgX00L0ZKgX0`0000050:Vm
j0030000002Y_NP0ZKgX00h0ZKgX00<000000:Vmj02Y_NP0102Y_NP4000000H0ZKgX00<000000:Nl
j@2W_>T03P2W_>T00`000000WKW/09fik00609fik0@000000`2L^>`00`000000Q:g_08B]k`0;08B]
k`030000001TW>l0000000@000001@1UW>l00`000000AX[[04J:j`0804J:j`030000000bO^L0<WkW
00<000001@0aONH00`0000009gST02Mhi00302Mhi08000000`0VMn@00`0000008WGS029eh`07029e
h`<00000200QM>80100000008GCR00000000000Q0?ooo`030000003oool0oooo0540oooo001C0?oo
o`030000003oool0oooo0180oooo0`00000l0?ooo`030000002Y_NP0ZKgX00@0ZKgX100000060:Vm
j0030000002Y_NP0ZKgX00h0ZKgX00<000000:Vmj02Y_NP00`2Y_NP3000000T0ZKgX00<000000:Vm
j02Y_NP03P2Y_NP00`000000ZKgX0:Vmj003000000/0ZKgX00<000000:Nlj@2W_>T03P2W_>T01000
0000WKW/09fik02M^N`4000000P0W;S/00<0000008B]k`24[Nl02`24[Nl00`000000I9c_06BLk`03
06BLk`D0000000<0IIc_00000016R^/02@16R^/00`000000<WkW039ni`02039ni`800000100aONH0
0`0000009gST02Mhi00402Mhi080000000<09WOT0000000RMN<02P0RMN<2000000P08GCR00@00000
025dhP0QM>8000008@3oool00`000000oooo0?ooo`1@0?ooo`00D`3oool00`000000oooo0?ooo`0?
0?ooo`<00000@03oool00`000000ZKgX0:Vmj003000000/0ZKgX00<000000:Vmj02Y_NP03P2Y_NP0
0`000000ZKgX0:Vmj002000000d0ZKgX00<000000:Vmj02Y_NP03@2Y_NP3000000l0ZKgX00<00000
0:Nlj@2W_>T03@2W_>T4000000d0W;S/00<0000008B]k`24[Nl02`24[Nl00`000000I9c_06BLk`07
06BLk`@000002@16R^/00`000000<WkW039ni`03039ni`<000000P0aONH00`0000009gST02Mhi005
02Mhi0<00000300RMN<2000000L08GCR00<00000025dhP0000008@3oool00`000000oooo0?ooo`1@
0?ooo`00D`3oool00`000000oooo@000000<0?ooo`<00000A03oool2000000l0ZKgX00<000000:Vm
j02Y_NP03@2Y_NP300000100ZKgX00<000000:Vmj02Y_NP02@2Y_NP300000080ZKgX00<000000:Vm
j02Y_NP03@2Y_NP00`000000YkcY0:Nlj@090:Nlj@@000000P2V_>T00`000000W;S/09bhk00=09bh
k00300000024[Nl0Q:g_00/0Q:g_00<0000006BLk`1TW>l02@1TW>l4000000H0AX[[00<00000039n
i`0bO^L01P0bO^L3000000T09gST0`00000:029eh`040000000QM>800000000000H08GCR00<00000
025dhP000000803oool00`000000oooo0?ooo`1@0?ooo`00D`3oool2000000/0oooo0P0000180?oo
o`030000002Y_NP0ZKgX00h0ZKgX00<000000:Vmj02Y_NP02@2Y_NP300000080ZKgX00<000000:Vm
j02Y_NP03`2Y_NP00`000000ZKgX0:Vmj0040:Vmj0@000001P2Y_NP00`000000ZKgX0:Vmj00=0:Vm
j0030000002W_>T0YkcY00D0YkcY0`0000070:Jlj@030000002L^>`0W;S/00`0W;S/00<0000008B]
k`24[Nl02`24[Nl00`000000I9c_06BLk`0:06BLk`0300000017Rn/0Ah_[008000001@16R^/00`00
0000<WkW039ni`07039ni`<000002@0WN>@3000000T08WGS00<00000025dhP0QM>800P000004025d
hP040000000QM>808GCR000001l0oooo00<000000?ooo`3oool0D03oool005<0oooo00<000000?oo
o`3oool01`3oool3000004/0oooo00<000000:Vmj02Y_NP03P2Y_NP00`000000ZKgX0:Vmj0040:Vm
j0@000001P2Y_NP00`000000ZKgX0:Vmj00?0:Vmj0030000002Y_NP0ZKgX00<000002`2Y_NP00`00
0000ZKgX0:Vmj00=0:Vmj0030000002W_>T0YkcY00@000002`2V_>T00`000000W;S/09bhk00<09bh
k00300000024[Nl0Q:g_00/0Q:g_00<0000006BLk`1TW>l02@1TW>l00`000000Ah_[04N;j`0204N;
j`<000000`16R^/00`000000<WkW039ni`08039ni`<00000200WN>@0100000008gGS000000000007
029eh`030000000QM>808GCR00808GCR0P000003025dhP040000000QM>808GCR000001h0oooo00<0
00000?ooo`3oool0D03oool004L0oooo0d0000020?ooo`03@000003oool0oooo00@0oooo00<00000
0?ooo`3oool0103oool3000004l0oooo00<000000:Vmj02Y_NP03P2Y_NP00`000000ZKgX0:Vmj003
000000/0ZKgX00<000000:Vmj02Y_NP03P2Y_NP3000000l0ZKgX00<000000:Vmj02Y_NP0302Y_NP3
00000100Y[cY00<0000009bhk02L^>`0302L^>`00`000000Q:g_08B]k`0;08B]k`030000001TW>l0
I9c_00T0I9c_00<0000004N;j`17Rn/01017Rn/4000000/0<WkW00@0000002Qhi000000000001P0W
N>@0100000008gGS02=eh`0SMN<2000000H08WGS00<00000025dhP0QM>800`0QM>82000000808GCR
00<00000025dhP0000007P3oool00`000000oooo0?ooo`1@0?ooo`00B03oool01T000000oooo0?oo
od000000oooo@00000@0oooo00<000000?ooo`3oool00P3oool3000005<0oooo0P00000>0:Vmj0<0
00003`2Y_NP2000000/0ZKgX0`0000020:Vmj0030000002Y_NP0ZKgX00d0ZKgX00<000000:Vmj02Y
_NP02@2Y_NP300000080ZKgX00<000000:Jlj@2V_>T03P2V_>T00`000000W;S/09bhk00;09bhk1<0
00002@1TW>l00`000000Ah_[04N;j`0604N;j`<000002@0bO^L010000000:7ST02Qhi00XN>@20000
00D09gST00<0000002=eh`0SMN<00P0SMN<2000000D08WGS00<00000025dhP0QM>80100QM>830000
00808GCR00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`1@0?ooo`00AP3oool4@0000004
0?oood000000oooo@00000@0oooo1@00001H0?ooo`030000002Y_NP0ZKgX00P0ZKgX0`0000020:Vm
j0030000002Y_NP0ZKgX00l0ZKgX00<000000:Vmj02Y_NP0102Y_NP4000000H0ZKgX00<000000:Vm
j02Y_NP03@2Y_NP00`000000ZKgX0:Vmj0040:Vmj0@000001P2Y_NP00`000000Y[cY0:Jlj@0>0:Jl
j@030000002L^>`0W;S/00H0W;S/1000000309Zgk00300000023[>l0Pjc_00/0Pjc_00<0000006BL
k`0000000`00000606BLk`0300000017Rn/0Ah_[00L0Ah_[0`000008039ni`030000000XN>@0:7ST
0080:7ST0P00000402Mhi0030000000SMN<08gGS00<08gGS0P000003029eh`030000000QM>808GCR
00H08GCR0P000002025dhP030000003oool0oooo01/0oooo00<000000?ooo`3oool0C`3oool004H0
oooo00=000000?oood0000000P3oool00d000000oooo@00000040?ooo`800000G03oool00`000000
ZKgX0:Vmj0040:Vmj0<000001P2Y_NP00`000000ZKgX0:Vmj00?0:Vmj0030000002Y_NP0ZKgX00<0
00002`2Y_NP00`000000ZKgX0:Vmj00=0:Vmj0030000002Y_NP0ZKgX00<000002`2Y_NP00`000000
Y[cY0:Jlj@0>0:Jlj@040000002L^>`0W;S/09bhk0@00000202J]n`00`000000Pjc_08>/k`0;08>/
k`030000001TW>l0I9c_0080I9c_1@0000000`1TW>l0000004N;j`0904N;j`030000000cOnL00000
008000001P0bO^L00`000000:7ST02Qhi00302Qhi08000000`0WN>@00`0000008gGS02=eh`0402=e
h`8000000P0RMN<00`0000008GCR025dhP07025dhP<000007@3oool00`000000oooo0?ooo`1?0?oo
o`00A`3oool2@0000080oooo00=000000?oood0000001@3oool00`000000oooo0?ooo`1K0?ooo`03
0000002Y_NP0ZKgX00<000002P2Y_NP00`000000ZKgX0:Vmj00>0:Vmj0<000003`2Y_NP00`000000
ZKgX0:Vmj00<0:Vmj0<000003`2Y_NP00`000000Y[cY0:Jlj@0<0:Jlj@D000003@2J]n`00`000000
Pjc_08>/k`0:08>/k`030000001TW>l0I9c_00L0I9c_1000000904N;j`040000000cOnL0<goW03=o
i`<00000100bO^L00`000000:7ST02Qhi00402Qhi080000000<09gST0000000SMN<01`0SMN<30000
00X08GCR0`00000L0?ooo`030000003oool0oooo04l0oooo00180?ooo`05@000003oool0oooo0?oo
od0000001`3oool2000005`0oooo0P00000>0:Vmj08000002`2Y_NP300000080ZKgX00<000000:Vm
j02Y_NP03@2Y_NP00`000000ZKgX0:Vmj0090:Vmj0<000000P2Y_NP00`000000ZKgX0:Vmj00>0:Vm
j0030000002V_>T0Y[cY00L0Y[cY100000030:Jlj@030000002J]n`0V[O/00d0V[O/00<0000008>/
k`23[>l02P23[>l00`000000I9c_06BLk`0906BLk`@000001`17Rn/00`000000<goW03=oi`0303=o
i`8000000P0bO^L00`000000:7ST02Qhi00602Qhi0<000002@0SMN<3000000P08GCR00@00000025d
hP0QM>8000006`3oool00`000000oooo0?ooo`1?0?ooo`00EP3oool00`000000oooo0?ooo`1J0?oo
o`030000002Y_NP0ZKgX00h0ZKgX00<000000:Vmj02Y_NP0102Y_NP4000000H0ZKgX00<000000:Vm
j02Y_NP03@2Y_NP00`000000ZKgX0:Vmj0040:Vmj0@000001P2Y_NP00`000000ZKgX0:Vmj00>0:Vm
j0040000002V_>T0Y[cY0:Jlj@D00000202V_>T00`000000V[O/09Zgk00<09Zgk00300000023[>l0
Pjc_00/0Pjc_00<0000006BLk`1TW>l02@1TW>l00`000000B8c/04R<k003000000@0Ah_[00<00000
03=oi`0cOnL01@0cOnL4000000T0:7ST0`00000902=eh`<000001`0QM>800`0000008GCR0000000K
0?ooo`030000003oool0oooo04l0oooo001G0?ooo`030000003oool0oooo05X0oooo00<000000:Vm
j02Y_NP03P2Y_NP00`000000ZKgX0:Vmj003000000/0ZKgX00<000000:Vmj02Y_NP03@2Y_NP00`00
0000ZKgX0:Vmj003000000/0ZKgX00<000000:Vmj02Y_NP03@2Y_NP4000000h0Y[cY00<0000009Zg
k02J]n`0302J]n`00`000000Pjc_08>/k`0;08>/k`030000001TW>l0I9c_00T0I9c_00<0000004R<
k018S>`00P18S>`300000080Ah_[00<0000003=oi`0cOnL01`0cOnL3000000T0:7ST0`00000802=e
h`040000000QM>800000000000H08GCR00<00000025dhP0000006P3oool00`000000oooo0?ooo`1?
0?ooo`00F03oool00`000000oooo0?ooo`1J0?ooo`030000002Y_NP0ZKgX00d0ZKgX0`00000?0:Vm
j0030000002Y_NP0ZKgX00`0ZKgX0`00000?0:Vmj0030000002Y_NP0ZKgX00T0ZKgX0`0000020:Vm
j0030000002V_>T0Y[cY00d0Y[cY00<0000009Zgk02J]n`03@2J]n`00`000000Pjc_08>/k`0:08>/
k`030000001TW>l0I9c_00X0I9c_00<0000004R<k018S>`01018S>`4000000X0<goW0`00000802Qh
i0030000000SM^<00000008000001P0SMN<00`0000008GCR025dhP02000000D08GCR00<00000025d
hP0000006@3oool00`000000oooo0?ooo`1?0?ooo`00F@3oool2000005/0oooo0P00000:0:Vmj0<0
00000P2Y_NP00`000000ZKgX0:Vmj00=0:Vmj0030000002Y_NP0ZKgX00T0ZKgX0`0000020:Vmj003
0000002Y_NP0ZKgX00h0ZKgX00<000000:Vmj02Y_NP0102Y_NP4000000H0ZKgX00<000000:Jlj@2V
_>T03@2V_>T00`000000V[O/09Zgk00:09Zgk1<000002@1TW>l00`000000B8c/04R<k00704R<k0<0
00002@0cOnL010000000:GWT00000000000602Qhi0030000000SM^<08gKS00808gKS0P00000502=e
h`040000000QM>808GCR025dhP<000000P0QM>800`0000008GCR0000000J0?ooo`030000003oool0
oooo04h0oooo001K0?ooo`030000003oool0oooo05X0oooo00<000000:Vmj02Y_NP0102Y_NP30000
00H0ZKgX00<000000:Vmj02Y_NP03@2Y_NP00`000000ZKgX0:Vmj0040:Vmj0@000001P2Y_NP00`00
0000ZKgX0:Vmj00>0:Vmj0030000002Y_NP0ZKgX00<000002`2Y_NP00`000000Y[cY0:Jlj@0=0:Jl
j@030000002J]n`0V[O/0080V[O/1`00000409Vgk@0300000022[?00PZc`00X0PZc`00<0000006BL
k`0000001000000506BLk`0300000018S>`0B8c/00P0B8c/0`00000703=oi`040000000YNN@0:GWT
02Uii08000001@0XN>@00`0000008gKS02=fh`0302=fh`8000000`0SMN<00`0000008GCR025dhP04
025dhP80000000@08GCR0000000QM>8000006@3oool00`000000oooo0?ooo`1>0?ooo`00G03oool0
0`000000oooo0?ooo`1J0?ooo`030000002Y_NP0ZKgX00<000002P2Y_NP00`000000ZKgX0:Vmj00=
0:Vmj0030000002Y_NP0ZKgX00<000002`2Y_NP00`000000ZKgX0:Vmj00=0:Vmj0<000003`2Y_NP0
0`000000Y[cY0:Jlj@0<0:Jlj@D00000302I]nd00`000000PZc`08:/l00:08:/l0030000001TW>l0
I9c_00<0I9c_1@0000000`1TW>l0000004R<k00904R<k0030000000dP>L00000008000001@0cOnL0
0`000000:GWT02Uii00202Uii0<000000`0XN>@00`0000008gKS02=fh`0402=fh`<0000000<08gGS
0000000QM>801P0QM>8300000003025dhP000000oooo01L0oooo00<000000?ooo`3oool0CP3oool0
05d0oooo00<000000?ooo`3oool0FP3oool2000000h0ZKgX00<000000:Vmj02Y_NP0302Y_NP30000
00l0ZKgX00<000000:Vmj02Y_NP02@2Y_NP300000080ZKgX00<000000:Vmj02Y_NP03@2Y_NP00`00
0000Y[cY0:Jlj@090:Jlj@<000000P2U_>T00`000000VKO]09Vgk@0<09Vgk@0300000022[?00PZc`
00/0PZc`00<0000006BLk`1TW>l01`1TW>l4000000P0B8c/00<0000003B0i`0dP>L00P0dP>L20000
00@0<goW00<0000002Uii00YNN@0100YNN@200000080:7ST00<0000002=fh`0SM^<01P0SM^<30000
00P08GCR0`00000H0?ooo`030000003oool0oooo04h0oooo001N0?ooo`030000003oool0oooo05X0
oooo00<000000:Vmj02Y_NP03@2Y_NP00`000000ZKgX0:Vmj0080:Vmj0<000000P2Y_NP00`000000
ZKgX0:Vmj00>0:Vmj0030000002Y_NP0ZKgX00@0ZKgX100000060:Vmj0030000002Y_NP0ZKgX00d0
ZKgX00<000000:Jlj@2V_>T0102V_>T4000000H0YKcY00<0000009Vgk@2I]nd0302I]nd00`000000
PZc`08:/l00;08:/l0030000001TW>l0I9c_00T0I9c_1000000604R<k0030000000dP>L0=83W00<0
=83W0`00000203=oi`030000000YNN@0:GWT00D0:GWT0`00000:02=fh`800000200QM>83000001L0
oooo00<000000?ooo`3oool0CP3oool005l0oooo0P00001K0?ooo`030000002Y_NP0ZKgX00d0ZKgX
00<000000:Vmj02Y_NP0102Y_NP3000000H0ZKgX00<000000:Vmj02Y_NP03P2Y_NP00`000000ZKgX
0:Vmj003000000/0ZKgX00<000000:Vmj02Y_NP03@2Y_NP00`000000Y[cY0:Jlj@03000000/0YKcY
00<0000009Vgk@2I]nd0302I]nd00`000000PZc`08:/l00:08:/l0030000001TW>l0I9c_00X0I9c_
00<0000004R<k018S>`00P00000504R<k0030000000dP>L0=83W00D0=83W0`00000902Uii0<00000
2P0SM^<2000000L08GCR00<00000025dhP0000005P3oool00`000000oooo0?ooo`1>0?ooo`00H@3o
ool00`000000oooo0?ooo`1I0?ooo`030000002Y_NP0ZKgX00d0ZKgX00<000000:Vmj02Y_NP00`00
000:0:Vmj0030000002Y_NP0ZKgX00d0ZKgX0`00000?0:Vmj0030000002Y_NP0ZKgX00`0ZKgX0`00
000?0:Flj@030000002I]nd0VKO]00`0VKO]00<0000008:/l022[?002P22[?000`000000I9c_06BL
k`0906BLk`0300000018S>`0B8c/0080B8c/0`00000304R<k0030000000dP>L0=83W00H0=83W0`00
000902Uii0<00000200SM^<0100000008GCR000000000006025dhP8000005P3oool00`000000oooo
0?ooo`1>0?ooo`00HP3oool00`000000oooo0?ooo`1I0?ooo`030000002Y_NP0ZKgX00`0ZKgX0`00
000>0:Vmj08000002P2Y_NP300000080ZKgX00<000000:Vmj02Y_NP03@2Y_NP00`000000ZKgX0:Vm
j0090:Vmj0<000000P2Y_NP00`000000YKcY0:Flj@0=0:Flj@030000002I]nd0VKO]00`0VKO]00<0
000008:/l022[?002`22[?000`000000I9c_06BLk`0906BLk`0300000018S>`0B8c/00@0B8c/1000
000:03B0i`<00000200YNN@01000000097KS00000000000702=fh`030000000QM>808GCR00800000
100QM>800`0000008GCR0000000E0?ooo`030000003oool0oooo04h0oooo001S0?ooo`030000003o
ool0oooo05P0oooo00<000000:Vmj02Y_NP02@2Y_NP300000080ZKgX00<000000:Vmj02Y_NP03P2Y
_NP00`000000ZKgX0:Vmj0040:Vmj0<000001P2Y_NP00`000000ZKgX0:Vmj00=0:Vmj0030000002Y
_NP0ZKgX00@0ZKgX100000060:Vmj0030000002U_>T0YKcY00d0YKcY00<0000009Vgk@2I]nd02@2I
]ndD000000T0I9c_00<0000004R<k018S>`01P18S>`3000000T0=83W00@0000002Uii@0000000000
1P0YNN@01000000097KS02Afh`0TM^<2000000H08gKS00@00000025dhP0QM>808GCR0P000003025d
hP030000000QM>80000001D0oooo00<000000?ooo`3oool0C@3oool006@0oooo0P00001I0?ooo`03
0000002Y_NP0ZKgX00@0ZKgX100000060:Vmj0030000002Y_NP0ZKgX00h0ZKgX00<000000:Vmj02Y
_NP00`00000:0:Vmj0030000002Y_NP0ZKgX00d0ZKgX00<000000:Vmj02Y_NP00`00000;0:Vmj003
0000002U_>T0YKcY00d0YKcY00<0000009Vgk@2I]nd00P2I]nd6000001@0oooo1000000606BLk`03
00000018S>`0B8c/00L0B8c/0`00000703B0i`040000000YNND0:GWU02Uii@8000001@0YNN@00`00
000097KS02Afh`0202Afh`800000100SM^<00`0000008GCR025dhP03025dhP8000000P0QM>820000
01D0oooo00<000000?ooo`3oool0C@3oool006H0oooo00<000000?ooo`3oool0E`3oool00`000000
ZKgX0:Vmj003000000/0ZKgX00<000000:Vmj02Y_NP03@2Y_NP3000000h0ZKgX0P00000=0:Vmj0<0
00003`2Y_NP00`000000YKcY0:Flj@0;0:Flj@H000007P3oool50000000306BLk`000000B8c/00T0
B8c/00@0000003F1j000000000001P0dP>L00`000000:GWU02Uii@0202Uii@800000100YNN@00`00
000097KS02Afh`0302Afh`8000000`0SM^<00`0000008GCR025dhP04025dhP<0000000<08GCR0000
003oool04`3oool00`000000oooo0?ooo`1=0?ooo`00I`3oool00`000000oooo0?ooo`1G0?ooo`80
00003`2Y_NP00`000000ZKgX0:Vmj0090:Vmj0<000000P2Y_NP00`000000ZKgX0:Vmj00>0:Vmj003
0000002Y_NP0ZKgX00H0ZKgX100000020:Vmj0030000002Y_NP0ZKgX00h0ZKgX00<000000:Flj@2U
_>T01P2U_>T4000002T0oooo1000000804R<k0040000000ePNP0=H7X03F1j08000001@0dP>L00`00
0000:GWU02Uii@0302Uii@8000000`0YNN@00`00000097KS02Afh`0402Afh`8000000P0SM^<00`00
00008GCR025dhP05025dhP80000000<08GCR0000003oool04P3oool00`000000oooo0?ooo`1=0?oo
o`00J03oool00`000000oooo0?ooo`1G0?ooo`030000002Y_NP0ZKgX00h0ZKgX00<000000:Vmj02Y
_NP0102Y_NP4000000H0ZKgX00<000000:Vmj02Y_NP03P2Y_NP010000000ZKgX0:Vmj02Y_NP40000
00L0ZKgX00<000000:Vmj02Y_NP03P2Y_NP010000000YKcY0:Flj@2U_>T400000340oooo0`000006
04R<k0030000000ePNP0=H7X0080=H7X0`00000303B0i`030000000YNND0:GWU00@0:GWU0P000000
0`0YNN@0000002Afh`0702Afh`<000002@0QM>82000001<0oooo00<000000?ooo`3oool0C@3oool0
06T0oooo0P00001H0?ooo`030000002Y_NP0ZKgX00h0ZKgX00<000000:Vmj02Y_NP00`00000;0:Vm
j0030000002Y_NP0ZKgX00d0ZKgX1000000<0:Vmj0030000002Y_NP0ZKgX00d0ZKgX1000000h0?oo
o`8000001@18S>`00`000000=H7X03F1j00403F1j080000000<0=83W0000000YNND01`0YNND30000
00T097KS0`000008025dhP8000004P3oool00`000000oooo0?ooo`1=0?ooo`00J`3oool00`000000
oooo0?ooo`1F0?ooo`030000002Y_NP0ZKgX00d0ZKgX0`00000?0:Vmj0030000002Y_NP0ZKgX00T0
ZKgX0`0000020:Vmj0030000002Y_NP0ZKgX00`0ZKgX00<000000:Vmj02Y_NP02@2Y_NP3000003h0
oooo0`00000304R<k0030000000ePNP0=H7X00D0=H7X0`00000902Uii@8000002P0TM^<3000000H0
8GCR00<00000025dhP0000004@3oool00`000000oooo0?ooo`1=0?ooo`00K03oool00`000000oooo
0?ooo`1F0?ooo`8000002P2Y_NP300000080ZKgX00<000000:Vmj02Y_NP03P2Y_NP00`000000ZKgX
0:Vmj0040:Vmj0@000001P2Y_NP00`000000ZKgX0:Vmj00<0:Vmj0030000002Y_NP0ZKgX00@0ZKgX
100000140?ooo`@000002@0ePNP3000000T0:GWU0P00000802Afh`030000000RMN<08WGS00800000
1@0QM>800`0000008GCR0000000A0?ooo`030000003oool0oooo04`0oooo001]0?ooo`030000003o
ool0oooo05L0oooo00<000000:Vmj02Y_NP0102Y_NP3000000H0ZKgX00<000000:Vmj02Y_NP03P2Y
_NP00`000000ZKgX0:Vmj003000000/0ZKgX00<000000:Vmj02Y_NP0302Y_NP00`000000ZKgX0:Vm
j003000004/0oooo0`00000903F1j0<00000200YNND3000000L097KS00@00000029eh`0RMN<08WGS
0P000004025dhP030000000QM>8000000100oooo00<000000?ooo`3oool0C03oool006h0oooo0P00
001H0?ooo`030000002Y_NP0ZKgX00<000002P2Y_NP00`000000ZKgX0:Vmj00=0:Vmj0<000003P2Y
_NP00`000000ZKgX0:Vmj00;0:Vmj0@00000D@3oool2000000P0=H7X00@0000002Yji@0000000000
1P0YNND00`00000097KS02Afh`02000000H097KS00<00000029eh`0RMN<00P0RMN<3000000808GCR
00<00000025dhP0000003`3oool00`000000oooo0?ooo`1<0?ooo`00L03oool00`000000oooo0?oo
o`1F0?ooo`8000003P2Y_NP2000000X0ZKgX0`0000020:Vmj0030000002Y_NP0ZKgX00d0ZKgX00<0
00000:Vmj02Y_NP01P2Y_NP4000005L0oooo0`00000603F1j0030000000ZN^D0:W[U008000001@0Y
NND01000000097KS02Afh`0TM^<2000000@097KS00<00000029eh`0RMN<01@0RMN<300000003025d
hP000000oooo00h0oooo00<000000?ooo`3oool0C03oool00740oooo00<000000?ooo`3oool0EP3o
ool00`000000ZKgX0:Vmj00>0:Vmj0030000002Y_NP0ZKgX00@0ZKgX0`0000060:Vmj0030000002Y
_NP0ZKgX00d0ZKgX00@000000:Vmj02Y_NP0ZKgX1000001N0?ooo`<000000`0ePNP00`000000:W[U
02Yji@0202Yji@<000000`0YNND00`00000097KS02Afh`0202Afh`8000000`0TM^<00`0000008WGS
029eh`06029eh`80000000<08GCR0000003oool03@3oool00`000000oooo0?ooo`1<0?ooo`00LP3o
ool00`000000oooo0?ooo`1F0?ooo`030000002Y_NP0ZKgX00h0ZKgX00<000000:Vmj02Y_NP00`00
000:0:Vmj0030000002Y_NP0ZKgX00`0ZKgX1000001U0?ooo`8000000P0ePNP00`000000:W[U02Yj
i@0402Yji@8000000P0YNND00`00000097KS02Afh`0302Afh`8000000P0TM^<00`0000008WGS029e
h`07029eh`<000003@3oool00`000000oooo0?ooo`1<0?ooo`00L`3oool00`000000oooo0?ooo`1F
0?ooo`030000002Y_NP0ZKgX00d0ZKgX0`00000>0:Vmj0030000002Y_NP0ZKgX00P0ZKgX0`00001[
0?ooo`@000001`0ZN^D3000000L097KS0`000009029eh`040000000RMN<00000000000`0oooo00<0
00000?ooo`3oool0C03oool007@0oooo0P00001G0?ooo`030000002Y_NP0ZKgX00T0ZKgX0`000002
0:Vmj0030000002Y_NP0ZKgX00d0ZKgX00<000000:Vmj02Y_NP0102Y_NP300000740oooo0P000008
02Yji@800000200TM^<3000000P08WGS00@00000029eh`0RMN<000002`3oool00`000000oooo0?oo
o`1<0?ooo`00MP3oool00`000000oooo0?ooo`1E0?ooo`030000002Y_NP0ZKgX00@0ZKgX10000006
0:Vmj0030000002Y_NP0ZKgX00d0ZKgX00<000000:Vmj02Y_NP00`00001f0?ooo`800000200ZN^D2
000000P097KS0`000007029eh`030000000RMN<0000000`0oooo00<000000?ooo`3oool0B`3oool0
07L0oooo00<000000?ooo`3oool0E@3oool00`000000ZKgX0:Vmj003000000/0ZKgX00<000000:Vm
j02Y_NP0302Y_NP3000007/0oooo0P00000702Yji@<000001`0TM^<0100000008WGS000000000006
029eh`030000000RMN<0000000/0oooo00<000000?ooo`3oool0B`3oool007P0oooo00<000000?oo
o`3oool0E@3oool2000000l0ZKgX00<000000:Vmj02Y_NP0202Y_NP300000800oooo0P00000502Yj
i@030000000UMn<09GOS008000001@0TM^<0100000008WGS029eh`0RMN<2000000@08WGS00@00000
029eh`0RMN<000002P3oool00`000000oooo0?ooo`1;0?ooo`00N@3oool2000005H0oooo00<00000
0:Vmj02Y_NP03P2Y_NP00`000000ZKgX0:Vmj0040:Vmj0<00000Q@3oool2000000@0:W[U00@00000
02Egh`0UMn<09GOS0P00000402Afh`030000000RMN<08WGS00808WGS0`000002029eh`030000000R
MN<0000000X0oooo00<000000?ooo`3oool0B`3oool007/0oooo00<000000?ooo`3oool0E03oool2
000000l0ZKgX00<000000:Vmj02Y_NP00`00002:0?ooo`8000000`0ZN^D00`0000009GOS02Egh`02
02Egh`8000000`0TM^<00`0000008WGS029eh`04029eh`80000000@08WGS0000000RMN<000002@3o
ool00`000000oooo0?ooo`1;0?ooo`00O03oool00`000000oooo0?ooo`1E0?ooo`030000002Y_NP0
ZKgX00`0ZKgX0`00002?0?ooo`8000000P0ZN^D00`0000009GOS02Egh`0302Egh`8000000P0TM^<0
0`0000008WGS029eh`05029eh`<0000000<08WGS0000003oool01`3oool00`000000oooo0?ooo`1;
0?ooo`00O@3oool00`000000oooo0?ooo`1E0?ooo`030000002Y_NP0ZKgX00L0ZKgX1000002D0?oo
o`<000001`0UMn<3000000T08WGS0`0000080?ooo`030000003oool0oooo04/0oooo001n0?ooo`80
0000EP3oool2000000<0ZKgX1000002J0?ooo`800000200UMn<3000000P08WGS0`0000080?ooo`03
0000003oool0oooo04X0oooo00200?ooo`030000003oool0oooo05D0oooo0`00002P0?ooo`800000
200UMn<3000000L08WGS00<00000029eh`0000001`3oool00`000000oooo0?ooo`1:0?ooo`00P@3o
ool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo0:80oooo0P00000702Egh`040000000R
MN<00000000000D08WGS00<00000029eh`0000001`3oool00`000000oooo0?ooo`1:0?ooo`00PP3o
ool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo0:@0oooo0P00000502Egh`040000000R
MN<08WGS029eh`800000100RMN<00`0000008WGS000000060?ooo`030000003oool0oooo04X0oooo
00230?ooo`800000D`3oool00`000000oooo0?ooo`2V0?ooo`800000100UMn<00`0000008WGS029e
h`02029eh`8000000`0RMN<00`0000008WGS000000050?ooo`030000003oool0oooo04X0oooo0025
0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0Z03oool2000000<09GOS00<00000
029eh`0RMN<00`0RMN<2000000808WGS0P0000050?ooo`030000003oool0oooo04X0oooo00260?oo
o`030000003oool0oooo04l0oooo00<000000?ooo`3oool0ZP3oool2000000809GOS00<00000029e
h`0RMN<0100RMN<300000003029eh`000000oooo00<0oooo00<000000?ooo`3oool0BP3oool008L0
oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`2/0?ooo`<00000200RMN<3000000D0
oooo00<000000?ooo`3oool0B@3oool008P0oooo00<000000?ooo`3oool0C@3oool00`000000oooo
0?ooo`2^0?ooo`<00000200RMN<2000000@0oooo00<000000?ooo`3oool0B@3oool008T0oooo0P00
001=0?ooo`030000003oool0oooo0;40oooo0P000006029eh`030000000RMN<0000000<0oooo00<0
00000?ooo`3oool0B@3oool008/0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`2c
0?ooo`8000001@0RMN<00`0000008WGS000000020?ooo`030000003oool0oooo04T0oooo002<0?oo
o`030000003oool0oooo04T0oooo00<000000?ooo`3oool0]@3oool2000000@08WGS0P0000020?oo
o`030000003oool0oooo04T0oooo002=0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3o
ool0^03oool2000000<08WGS0P0000000`3oool000000?ooo`1:0?ooo`00SP3oool2000004L0oooo
00<000000?ooo`3oool0^P3oool200000003029eh`0000008WGS00800000B`3oool00900oooo00<0
00000?ooo`3oool0A03oool00`000000oooo0?ooo`2l0?ooo`<0000000<08WGS0000003oool0BP3o
ool00940oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`2n0?ooo`@00000BP3oool0
0980oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`300?ooo`800000BP3oool009<0
oooo0P0000120?ooo`030000003oool0oooo0<00oooo0P00001:0?ooo`00U@3oool00`000000oooo
0?ooo`0o0?ooo`030000003oool0oooo0<00oooo0P00001:0?ooo`00UP3oool00`000000oooo0?oo
o`0n0?ooo`030000003oool0oooo0;`0oooo1000001<0?ooo`00U`3oool00`000000oooo0?ooo`0m
0?ooo`030000003oool0oooo0;P0oooo1000001@0?ooo`00V03oool2000003d0oooo00<000000?oo
o`3oool0]03oool4000005@0oooo002J0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0/03oool4000005P0oooo002K0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0
[@3oool3000005`0oooo002L0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0Z@3o
ool4000005l0oooo002M0?ooo`800000>03oool00`000000oooo0?ooo`2U0?ooo`@00000H`3oool0
09l0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`2Q0?ooo`@00000I`3oool00:00
oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`2M0?ooo`@00000J`3oool00:40oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`2J0?ooo`<00000K`3oool00:80oooo00<0
00000?ooo`3oool0<P3oool00`000000oooo0?ooo`2F0?ooo`@00000LP3oool00:<0oooo0P00000b
0?ooo`030000003oool0oooo0980oooo1000001f0?ooo`00Y@3oool00`000000oooo0?ooo`0_0?oo
o`030000003oool0oooo08h0oooo1000001j0?ooo`00YP3oool00`000000oooo0?ooo`0^0?ooo`03
0000003oool0oooo08X0oooo1000001n0?ooo`00Y`3oool00`000000oooo0?ooo`0]0?ooo`030000
003oool0oooo08H0oooo100000220?ooo`00Z03oool2000002d0oooo00<000000?ooo`3oool0P`3o
ool3000008H0oooo002Z0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0P03oool4
000008T0oooo002[0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0O03oool40000
08d0oooo002/0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0N03oool400000940
oooo002]0?ooo`8000009`3oool00`000000oooo0?ooo`1d0?ooo`@00000U@3oool00:l0oooo00<0
00000?ooo`3oool0903oool00`000000oooo0?ooo`1a0?ooo`<00000V@3oool00;00oooo00<00000
0?ooo`3oool08`3oool00`000000oooo0?ooo`1]0?ooo`@00000W03oool00;40oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`1Y0?ooo`@00000X03oool00;80oooo0P00000R0?ooo`03
0000003oool0oooo06D0oooo1000002T0?ooo`00]03oool00`000000oooo0?ooo`0O0?ooo`030000
003oool0oooo0640oooo1000002X0?ooo`00]@3oool00`000000oooo0?ooo`0N0?ooo`030000003o
ool0oooo05h0oooo0`00002/0?ooo`00]P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo05X0oooo1000002_0?ooo`00]`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo
05H0oooo1000002c0?ooo`00^03oool2000001`0oooo00<000000?ooo`3oool0DP3oool400000;L0
oooo002j0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0CP3oool400000;/0oooo
002k0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0B`3oool300000;l0oooo002l
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0A`3oool400000<80oooo002m0?oo
o`8000005`3oool00`000000oooo0?ooo`130?ooo`@00000aP3oool00;l0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`0o0?ooo`@00000bP3oool00<00oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0k0?ooo`@00000cP3oool00<40oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0h0?ooo`<00000dP3oool00<80oooo0P00000B0?ooo`030000003oool0
oooo03@0oooo1000003E0?ooo`00a03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
0300oooo1000003I0?ooo`00a@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02`0
oooo1000003M0?ooo`00aP3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02P0oooo
1000003Q0?ooo`00a`3oool2000000`0oooo00<000000?ooo`3oool09@3oool400000>D0oooo0039
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool08P3oool300000>T0oooo003:0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool07P3oool400000>`0oooo003;0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool06P3oool400000?00oooo003<0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool05P3oool400000?@0oooo003=0?ooo`8000001P3o
ool00`000000oooo0?ooo`0B0?ooo`@00000n03oool00<l0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0?0?ooo`<00000o03oool00=00oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0;0?ooo`@00000o`3oool00=40oooo00D000000?ooo`3oool0oooo000000090?oo
o`@00000o`3oool40?ooo`00dP3oool2000000030?ooo`000000oooo00@0oooo1000003o0?ooo`P0
oooo003D0?ooo`80000000<0oooo0000000000000P00003o0?ooo``0oooo003E0?ooo`800000o`3o
ool@0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3o
oooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3o
oooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3o
oooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3o
oooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3o
oooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3o
oooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3o
oooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3o
oooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3o
oooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3o
oooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3ooooW0?ooo`00o`3o
oooW0?ooo`00o`3ooooW0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 485.063}, {393.063, 0}} -> {-0.240258, -0.136432, 
  0.00289647, 0.00289647}}]
}, Open  ]],

Cell["\<\
\"OBR.6
Eur\[OAcute]pska call opcia na akcie vypl\[AAcute]caj\[UAcute]ce spojit\
\[UAcute] dividendu a payoff diagram.\
\>", "Text"],

Cell[CellGroupData[{

Cell["\<\
X:=60;
sigma:=0.29;
r:=0.04;
DD:=0.1;
tau:=0.6;
g1=Plot[Max[S-60,0],{S,0,100},PlotRange->All,AxesLabel->
{\"S\",\"c\"},PlotStyle -> 
{Thickness[0.007]}, DisplayFunction->Identity];

g2=Plot[EuropeanCallDiv[S,X,sigma,r,DD,tau],{S,0,100},PlotRange->All,\
AxesLabel->
{\"S\",\"c\"},PlotStyle -> RGBColor[0.2,0.6,1], DisplayFunction->Identity];

Show[g1,g2,DisplayFunction->$DisplayFunction,PlotRange->{{20,100},{0,42}}]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.25 0.0125 0 0.0147151 [
[.125 -0.0125 -6 -9 ]
[.125 -0.0125 6 0 ]
[.25 -0.0125 -6 -9 ]
[.25 -0.0125 6 0 ]
[.375 -0.0125 -6 -9 ]
[.375 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.625 -0.0125 -6 -9 ]
[.625 -0.0125 6 0 ]
[.75 -0.0125 -6 -9 ]
[.75 -0.0125 6 0 ]
[.875 -0.0125 -6 -9 ]
[.875 -0.0125 6 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .14715 -12 -4.5 ]
[-0.0125 .14715 0 4.5 ]
[-0.0125 .2943 -12 -4.5 ]
[-0.0125 .2943 0 4.5 ]
[-0.0125 .44145 -12 -4.5 ]
[-0.0125 .44145 0 4.5 ]
[-0.0125 .5886 -12 -4.5 ]
[-0.0125 .5886 0 4.5 ]
[0 .64303 -5 0 ]
[0 .64303 5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.125 0 m
.125 .00625 L
s
[(30)] .125 -0.0125 0 1 Mshowa
.25 0 m
.25 .00625 L
s
[(40)] .25 -0.0125 0 1 Mshowa
.375 0 m
.375 .00625 L
s
[(50)] .375 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(60)] .5 -0.0125 0 1 Mshowa
.625 0 m
.625 .00625 L
s
[(70)] .625 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(80)] .75 -0.0125 0 1 Mshowa
.875 0 m
.875 .00625 L
s
[(90)] .875 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(100)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.025 0 m
.025 .00375 L
s
.05 0 m
.05 .00375 L
s
.075 0 m
.075 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.175 0 m
.175 .00375 L
s
.2 0 m
.2 .00375 L
s
.225 0 m
.225 .00375 L
s
.275 0 m
.275 .00375 L
s
.3 0 m
.3 .00375 L
s
.325 0 m
.325 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.425 0 m
.425 .00375 L
s
.45 0 m
.45 .00375 L
s
.475 0 m
.475 .00375 L
s
.525 0 m
.525 .00375 L
s
.55 0 m
.55 .00375 L
s
.575 0 m
.575 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.675 0 m
.675 .00375 L
s
.7 0 m
.7 .00375 L
s
.725 0 m
.725 .00375 L
s
.775 0 m
.775 .00375 L
s
.8 0 m
.8 .00375 L
s
.825 0 m
.825 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.925 0 m
.925 .00375 L
s
.95 0 m
.95 .00375 L
s
.975 0 m
.975 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .14715 m
.00625 .14715 L
s
[(10)] -0.0125 .14715 1 0 Mshowa
0 .2943 m
.00625 .2943 L
s
[(20)] -0.0125 .2943 1 0 Mshowa
0 .44145 m
.00625 .44145 L
s
[(30)] -0.0125 .44145 1 0 Mshowa
0 .5886 m
.00625 .5886 L
s
[(40)] -0.0125 .5886 1 0 Mshowa
.125 Mabswid
0 .02943 m
.00375 .02943 L
s
0 .05886 m
.00375 .05886 L
s
0 .08829 m
.00375 .08829 L
s
0 .11772 m
.00375 .11772 L
s
0 .17658 m
.00375 .17658 L
s
0 .20601 m
.00375 .20601 L
s
0 .23544 m
.00375 .23544 L
s
0 .26487 m
.00375 .26487 L
s
0 .32373 m
.00375 .32373 L
s
0 .35316 m
.00375 .35316 L
s
0 .38259 m
.00375 .38259 L
s
0 .41202 m
.00375 .41202 L
s
0 .47088 m
.00375 .47088 L
s
0 .50031 m
.00375 .50031 L
s
0 .52974 m
.00375 .52974 L
s
0 .55917 m
.00375 .55917 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.007 w
.01107 0 m
.06224 0 L
.11664 0 L
.16905 0 L
.21947 0 L
.2731 0 L
.32475 0 L
.37441 0 L
.42729 0 L
.45162 0 L
.47818 0 L
.48514 0 L
.49256 0 L
.49617 0 L
.49794 0 L
.49957 0 L
.50105 .00123 L
.50262 .00308 L
.50592 .00696 L
.53228 .038 L
.58212 .09667 L
.63518 .15913 L
.68625 .21925 L
.74053 .28316 L
.79283 .34472 L
.84314 .40394 L
.89666 .46696 L
.9482 .52763 L
.99775 .58595 L
1 .5886 L
s
.2 .6 1 r
.5 Mabswid
0 0 m
.00042 0 L
.00396 0 L
.00772 0 L
.01094 0 L
.01449 0 L
.01756 0 L
.02093 0 L
.02444 0 L
.02772 0 L
.03358 0 L
.03687 0 L
.03985 0 L
.0466 0 L
.05041 0 L
.05392 0 L
.06038 0 L
.06363 0 L
.06721 0 L
.07048 0 L
.07404 0 L
.08053 0 L
.08685 0 L
.09271 0 L
.09967 1e-005 L
.10598 1e-005 L
.11326 1e-005 L
.12012 2e-005 L
.12623 2e-005 L
.13295 3e-005 L
.13995 4e-005 L
.14649 5e-005 L
.1582 8e-005 L
.16476 .00011 L
.17074 .00013 L
.17706 .00017 L
.18377 .00021 L
.19581 .00031 L
.20877 .00047 L
.22307 .00071 L
.23633 .00102 L
.24848 .00139 L
.26182 .00191 L
.27586 .00262 L
.2884 .00342 L
.30179 .00448 L
.3259 .00699 L
.35394 .01111 L
.38039 .01639 L
.40668 .02318 L
Mistroke
.43091 .03093 L
.48265 .05259 L
.5324 .08008 L
.58537 .11607 L
.63636 .1564 L
.69056 .20422 L
.74277 .25398 L
.79299 .30435 L
.84644 .35986 L
.89789 .41458 L
.95256 .47363 L
1 .52537 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00<`3oool2@00000@0oooo00=000000?ooo`3oool05@3oool3@0000080oooo00=000000?oo
o`3oool05@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01D0oooo0T0000040?oo
o`03@000003oool0oooo01D0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0E0?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0503oool2@00000@0oooo00=000000?oo
o`3oool04@3oool5@0000080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0E0?oo
o`00=@3oool01T000000oooo0?oood000000oooo@00001L0oooo00I000000?ooo`3ooom000000?oo
od00000E0?ooo`03@000003ooom000000080oooo00=000000?oood0000005P3oool00d000000oooo
@00000020?ooo`03@000003ooom0000001H0oooo00M000000?ooo`3oool0oooo@000003ooom00000
01D0oooo00=000000?oood0000000P3oool00d000000oooo@000000G0?ooo`06@000003oool0oooo
@000003ooom00000503oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000
oooo@000000F0?ooo`00=03oool01d000000oooo0?ooo`3ooom000000?oood0000005@3oool4@000
00040?oood000000oooo@00001L0oooo00I000000?ooo`3ooom000000?oood00000F0?ooo`03@000
003ooom000000080oooo00=000000?oood0000005P3oool01d000000oooo0?ooo`3ooom000000?oo
od0000005@3oool00d000000oooo@00000020?ooo`03@000003ooom0000001H0oooo0T0000020?oo
o`03@000003ooom0000001@0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=0
00000?oood0000005P3oool003D0oooo00I000000?ooo`3ooom000000?oood00000E0?ooo`03@000
003ooom000000080oooo00=000000?oood0000005@3oool2@00000<0oooo00=000000?oood000000
5P3oool2@00000<0oooo00=000000?oood0000005`3oool01T000000oooo0?oood000000oooo@000
01H0oooo00M000000?ooo`3oool0oooo@000003ooom0000001D0oooo00=000000?oood0000000P3o
ool00d000000oooo@000000D0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03
@000003ooom0000001H0oooo000c0?ooo`03@000003ooom000000080oooo00=000000?oood000000
5P3oool2@0000080oooo00=000000?oood0000005@3oool00d000000oooo0?ooo`020?ooo`03@000
003ooom0000001H0oooo00=000000?ooo`3oool00P3oool00d000000oooo@000000E0?ooo`03@000
003ooom000000080oooo00=000000?oood0000005@3oool00d000000oooo@00000020?ooo`03@000
003ooom0000001D0oooo00=000000?oood0000000P3oool00d000000oooo@000000D0?ooo`07@000
003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom0000001H0oooo000d0?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool05P3oool01D000000oooo0?ooo`3ooom00000
01H0oooo0d0000030?ooo`03@000003oool0oooo01H0oooo0T0000030?ooo`03@000003oool0oooo
01@0oooo0d0000030?ooo`03@000003oool0oooo01D0oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`0E0?ooo`9000000`3oool00d000000oooo0?ooo`0B0?ooo`900000103oool00d00
0000oooo0?ooo`020?ooo`03@000003oool0oooo01D0oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooo`d0oooo0d00000A0?ooo`006P3ooolV03>Iol<0000000=000000?oo
o`3oool01P3oool00d000000oooo@000000A0?ooo`006P3oool00`000000oooo0?ooo`030?ooo`03
@000003oool0oooo00<0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`030?ooo`03
@000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00d000000oooo0?ooo`0O03>Io`03
0?oood000000oooo00@0oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`030?ooo`03
@000003oool0oooo00<0oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`03
@000003oool0oooo00<0oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`030?ooo`03
@000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo00<0oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo00<0oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`03
@000003oool0oooo00<0oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo00<0oooo00<000000?ooo`3oool0203oool00d000000oooo0?ooo`0?0?ooo`00
6P3oool00`000000oooo0?ooo`0J0?ooo`03@000003oool0oooo01X0oooo00=000000?ooo`3oool0
203oool:03>Io`P0oooo00=000000?ooo`3oool06`3oool00d00000000000?ooo`0J0?ooo`03@000
003oool0oooo01X0oooo00=000000?ooo`3oool06P3oool00d000000oooo0?ooo`0J0?ooo`03@000
003oool0oooo00L0oooo00=000000?ooo`3oool0403oool001X0oooo00<000000?ooo`3oool0C03o
ool703>Iob40oooo00<000000?ooo`3oool0N03oool00d000000oooo@000000A0?ooo`006P3oool0
0`000000oooo0?ooo`1C0?ooo`D0<iWo7@3oool00`000000oooo0?ooo`1g0?ooo`=000004@3oool0
01X0oooo00<000000?ooo`3oool0F03oool303>Ioa/0oooo00<000000?ooo`3oool0RP3oool001X0
oooo00<000000?ooo`3oool0F`3oool303>IoaP0oooo00<000000?ooo`3oool0RP3oool001X0oooo
00<00000@000003oool0GP3oool203>IoaL0oooo00<000000?ooo`3oool0R@3oool001X0oooo00<0
00000?ooo`3oool0H03oool303>IoaD0oooo00<000000?ooo`3oool0R03oool001X0oooo00<00000
0?ooo`3oool0H`3oool203>Ioa@0oooo00<000000?ooo`3oool0Q`3oool001X0oooo00<000000?oo
o`3oool0I@3oool203>Ioa<0oooo00<000000?ooo`3oool0QP3oool001X0oooo00<000000?ooo`3o
ool0I`3oool303>Ioa40oooo00<000000?ooo`3oool0Q@3oool001X0oooo00<000000?ooo`3oool0
JP3oool203>Ioa00oooo00<000000?ooo`3oool0Q03oool001X0oooo00<000000?ooo`3oool0K03o
ool203>Io`h0oooo00<000000?ooo`3oool0Q03oool001X0oooo00<00000@000003oool0KP3oool2
03>Io`d0oooo00<000000?ooo`3oool0P`3oool001X0oooo00<000000?ooo`3oool0L03oool203>I
o``0oooo00<000000?ooo`3oool0PP3oool001X0oooo00<000000?ooo`3oool0LP3oool203>Io`/0
oooo00<000000?ooo`3oool0P@3oool001X0oooo00<000000?ooo`3oool0M03oool203>Io`X0oooo
00<000000?ooo`3oool0P03oool001X0oooo00<000000?ooo`3oool0MP3oool203>Io`T0oooo00<0
00000?ooo`3oool0O`3oool001X0oooo00<000000?ooo`3oool0N03oool203>Io`P0oooo00<00000
0?ooo`3oool0OP3oool001X0oooo00<000000?ooo`3oool0NP3oool00`0cVOl0oooo0?ooo`050?oo
o`030000003oool0oooo07h0oooo000J0?ooo`03000004000000oooo07/0oooo0P0cVOl60?ooo`03
0000003oool0oooo07d0oooo000J0?ooo`030000003oool0oooo07d0oooo00<0<iWo0?ooo`3oool0
103oool00`000000oooo0?ooo`1l0?ooo`006P3oool00`000000oooo0?ooo`1n0?ooo`0303>Io`3o
ool0oooo00@0oooo00<000000?ooo`3oool0N`3oool001X0oooo00<000000?ooo`3oool0O`3oool2
03>Io`D0oooo00<000000?ooo`3oool0NP3oool001X0oooo00<000000?ooo`3oool0P@3oool00`0c
VOl0oooo0?ooo`030?ooo`030000003oool0oooo07T0oooo000J0?ooo`030000003oool0oooo0880
oooo00<0<iWo0?ooo`3oool00P3oool00`000000oooo0?ooo`1i0?ooo`006P3oool00`000000oooo
0?ooo`230?ooo`80<iWo0`3oool00`000000oooo0?ooo`1h0?ooo`006P3oool00`00001000000?oo
o`250?ooo`0503>Io`3oool0oooo0?ooo`000000N@3oool001X0oooo00<000000?ooo`3oool0QP3o
ool01@0cVOl0oooo0?ooo`3oool0000007P0oooo000J0?ooo`030000003oool0oooo08L0oooo0P0c
VOl20?ooo`030000003oool0oooo07D0oooo000J0?ooo`030000003oool0oooo08T0oooo00<0<iWo
0?ooo`000000M`3oool001X0oooo00<000000?ooo`3oool0RP3oool00`0cVOl0oooo0000001f0?oo
o`003@3oool5@0000080oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`2;0?ooo`80
<iWo00<000000?ooo`3oool0L`3oool000l0oooo00M000000?ooo`3oool0oooo@000003ooom00000
00@0oooo00<000000?ooo`3oool0S@3oool00`0cVOl000000?ooo`1c0?ooo`003`3oool01d000000
oooo0?ooo`3ooom000000?oood000000103oool00`00001000000?ooo`2>0?ooo`0303>Io`000000
oooo0780oooo000?0?ooo`07@000003oool0oooo0?oood000000oooo@00000040?ooo`030000003o
ool0oooo08l0oooo0P0cVOmb0?ooo`003`3oool01d000000oooo0?ooo`3ooom000000?oood000000
103oool00`000000oooo0?ooo`2@0?ooo`030000000cVOl0oooo0700oooo000>0?ooo`900000103o
ool00d000000oooo0?ooo`030?ooo`030000003oool0oooo0940oooo00<0000003>Io`3oool0K`3o
ool001X0oooo00<000000?ooo`3oool0TP3oool00`000000<iWo0?ooo`1^0?ooo`006P3oool00`00
0000oooo0?ooo`2C0?ooo`030000000cVOl0<iWo06d0oooo000J0?ooo`030000003oool0oooo09@0
oooo00<000000?ooo`0cVOl0K03oool001X0oooo00<00000@000003oool0U03oool010000000oooo
0?ooo`0cVOm[0?ooo`006P3oool00`000000oooo0?ooo`2E0?ooo`040000003oool0oooo03>IofX0
oooo000J0?ooo`030000003oool0oooo09H0oooo00@000000?ooo`3oool0<iWoJ@3oool001X0oooo
00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`0203>IofL0oooo000J0?ooo`030000003o
ool0oooo09P0oooo00D000000?ooo`3oool0oooo03>Io`1V0?ooo`006P3oool00`000000oooo0?oo
o`2I0?ooo`050000003oool0oooo0?ooo`0cVOl0I@3oool001X0oooo00<000000?ooo`3oool0VP3o
ool01@000000oooo0?ooo`3oool0<iWo06@0oooo000J0?ooo`03000004000000oooo09X0oooo00<0
00000?ooo`3oool00P3oool00`0cVOl0oooo0?ooo`1Q0?ooo`006P3oool00`000000oooo0?ooo`2K
0?ooo`030000003oool0oooo0080oooo00<0<iWo0?ooo`3oool0H03oool001X0oooo00<000000?oo
o`3oool0W03oool00`000000oooo0?ooo`020?ooo`0303>Io`3oool0oooo05l0oooo000J0?ooo`03
0000003oool0oooo09d0oooo00<000000?ooo`3oool00P3oool00`0cVOl0oooo0?ooo`1N0?ooo`00
6P3oool00`000000oooo0?ooo`2N0?ooo`030000003oool0oooo0080oooo00<0<iWo0?ooo`3oool0
G@3oool001X0oooo00<000000?ooo`3oool0W`3oool00`000000oooo0?ooo`020?ooo`0303>Io`3o
ool0oooo05`0oooo000J0?ooo`03000004000000oooo0:00oooo00<000000?ooo`3oool00P3oool0
0`0cVOl0oooo0?ooo`1K0?ooo`006P3oool00`000000oooo0?ooo`2P0?ooo`030000003oool0oooo
00<0oooo00<0<iWo0?ooo`3oool0FP3oool001X0oooo00<000000?ooo`3oool0X@3oool00`000000
oooo0?ooo`030?ooo`0303>Io`3oool0oooo05T0oooo000J0?ooo`030000003oool0oooo0:80oooo
00<000000?ooo`3oool00`3oool00`0cVOl0oooo0?ooo`1H0?ooo`006P3oool00`000000oooo0?oo
o`2S0?ooo`030000003oool0oooo00<0oooo00<0<iWo0?ooo`3oool0E`3oool001X0oooo00<00000
0?ooo`3oool0Y03oool00`000000oooo0?ooo`030?ooo`0303>Io`3oool0oooo05H0oooo000J0?oo
o`030000003oool0oooo0:D0oooo00<000000?ooo`3oool00`3oool00`0cVOl0oooo0?ooo`1E0?oo
o`006P3oool00`00001000000?ooo`2V0?ooo`030000003oool0oooo00<0oooo00<0<iWo0?ooo`3o
ool0E03oool001X0oooo00<000000?ooo`3oool0Y`3oool00`000000oooo0?ooo`030?ooo`0303>I
o`3oool0oooo05<0oooo000J0?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool0103o
ool00`0cVOl0oooo0?ooo`1B0?ooo`006P3oool00`000000oooo0?ooo`2X0?ooo`030000003oool0
oooo00@0oooo00<0<iWo0?ooo`3oool0D@3oool001X0oooo00<000000?ooo`3oool0Z@3oool00`00
0000oooo0?ooo`040?ooo`80<iWoD@3oool000h0oooo0d0000030?ooo`03@000003oool0oooo00<0
oooo00<000000?ooo`3oool0ZP3oool00`000000oooo0?ooo`050?ooo`0303>Io`3oool0oooo04h0
oooo000>0?ooo`03@000003oool0oooo0080oooo00=000000?oood000000103oool00`000000oooo
0?ooo`2[0?ooo`030000003oool0oooo00D0oooo00<0<iWo0?ooo`3oool0C@3oool000l0oooo00M0
00000?ooo`3oool0oooo@000003ooom0000000@0oooo00<00000@000003oool0[03oool00`000000
oooo0?ooo`050?ooo`0303>Io`3oool0oooo04`0oooo000?0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000040?ooo`030000003oool0oooo0:d0oooo00<000000?ooo`3oool01@3oool00`0c
VOl0oooo0?ooo`1;0?ooo`003P3oool00d000000oooo@00000020?ooo`03@000003ooom0000000@0
oooo00<000000?ooo`3oool0[@3oool00`000000oooo0?ooo`060?ooo`0303>Io`3oool0oooo04X0
oooo000?0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00`3oool00`000000oooo
0?ooo`2^0?ooo`030000003oool0oooo00H0oooo00<0<iWo0?ooo`3oool0B@3oool001X0oooo00<0
00000?ooo`3oool0[`3oool00`000000oooo0?ooo`060?ooo`0303>Io`3oool0oooo04P0oooo000J
0?ooo`030000003oool0oooo0;00oooo00<000000?ooo`3oool01P3oool00`0cVOl0oooo0?ooo`17
0?ooo`006P3oool00`000000oooo0?ooo`2a0?ooo`030000003oool0oooo00H0oooo00<0<iWo0?oo
o`3oool0AP3oool001X0oooo00<00000@000003oool0/P3oool00`000000oooo0?ooo`060?ooo`03
03>Io`3oool0oooo04D0oooo000J0?ooo`030000003oool0oooo0;<0oooo00<000000?ooo`3oool0
1P3oool00`0cVOl0oooo0?ooo`140?ooo`006P3oool00`000000oooo0?ooo`2c0?ooo`030000003o
ool0oooo00H0oooo00<0<iWo0?ooo`3oool0A03oool001X0oooo00<000000?ooo`3oool0]03oool0
0`000000oooo0?ooo`060?ooo`0303>Io`3oool0oooo04<0oooo000J0?ooo`030000003oool0oooo
0;D0oooo00<000000?ooo`3oool01P3oool00`0cVOl0oooo0?ooo`120?ooo`006P3oool00`000000
oooo0?ooo`2f0?ooo`030000003oool0oooo00H0oooo00<0<iWo0?ooo`3oool0@@3oool001X0oooo
00<000000?ooo`3oool0]`3oool00`000000oooo0?ooo`060?ooo`0303>Io`3oool0oooo0400oooo
000J0?ooo`03000004000000oooo0;P0oooo00<000000?ooo`3oool01P3oool00`0cVOl0oooo0?oo
o`0o0?ooo`006P3oool00`000000oooo0?ooo`2i0?ooo`030000003oool0oooo00H0oooo00<0<iWo
0?ooo`3oool0?P3oool001X0oooo00<000000?ooo`3oool0^@3oool00`000000oooo0?ooo`070?oo
o`0303>Io`3oool0oooo03d0oooo000J0?ooo`030000003oool0oooo0;X0oooo00<000000?ooo`3o
ool01`3oool00`0cVOl0oooo0?ooo`0l0?ooo`006P3oool00`000000oooo0?ooo`2k0?ooo`030000
003oool0oooo00L0oooo00<0<iWo0?ooo`3oool0>`3oool001X0oooo00<000000?ooo`3oool0_03o
ool00`000000oooo0?ooo`070?ooo`0303>Io`3oool0oooo03X0oooo000J0?ooo`030000003oool0
oooo0;d0oooo00<000000?ooo`3oool01`3oool00`0cVOl0oooo0?ooo`0i0?ooo`006P3oool00`00
001000000?ooo`2n0?ooo`030000003oool0oooo00L0oooo00<0<iWo0?ooo`3oool0>03oool001X0
oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?ooo`060?ooo`0303>Io`3oool0oooo03P0
oooo000J0?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool01`3oool00`0cVOl0oooo
0?ooo`0g0?ooo`006P3oool00`000000oooo0?ooo`300?ooo`030000003oool0oooo00L0oooo00<0
<iWo0?ooo`3oool0=P3oool001X0oooo00<000000?ooo`3oool0`@3oool00`000000oooo0?ooo`07
0?ooo`0303>Io`3oool0oooo03D0oooo000J0?ooo`030000003oool0oooo0<80oooo00<000000?oo
o`3oool01`3oool00`0cVOl0oooo0?ooo`0d0?ooo`006P3oool00`000000oooo0?ooo`330?ooo`03
0000003oool0oooo00L0oooo00<0<iWo0?ooo`3oool0<`3oool001X0oooo00<00000@000003oool0
a03oool00`000000oooo0?ooo`070?ooo`0303>Io`3oool0oooo0380oooo000J0?ooo`030000003o
ool0oooo0<D0oooo00<000000?ooo`3oool01`3oool00`0cVOl0oooo0?ooo`0a0?ooo`006P3oool0
0`000000oooo0?ooo`350?ooo`030000003oool0oooo00P0oooo00<0<iWo0?ooo`3oool0<03oool0
01X0oooo00<000000?ooo`3oool0aP3oool00`000000oooo0?ooo`080?ooo`0303>Io`3oool0oooo
02l0oooo000>0?ooo`900000103oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo0<L0
oooo00<000000?ooo`3oool0203oool00`0cVOl0oooo0?ooo`0^0?ooo`00403oool01T000000oooo
0?oood000000oooo@00000@0oooo00<000000?ooo`3oool0b03oool00`000000oooo0?ooo`080?oo
o`0303>Io`3oool0oooo02d0oooo000?0?ooo`07@000003oool0oooo0?oood000000oooo@0000004
0?ooo`03000004000000oooo0<T0oooo00<000000?ooo`3oool0203oool00`0cVOl0oooo0?ooo`0/
0?ooo`00403oool01T000000oooo0?oood000000oooo@00000@0oooo00<000000?ooo`3oool0bP3o
ool00`000000oooo0?ooo`080?ooo`0303>Io`3oool0oooo02/0oooo000>0?ooo`03@000003ooom0
00000080oooo00=000000?oood000000103oool00`000000oooo0?ooo`3;0?ooo`030000003oool0
oooo00L0oooo00<0<iWo0?ooo`3oool0:`3oool000l0oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`030?ooo`030000003oool0oooo0</0oooo00<000000?ooo`3oool0203oool00`0c
VOl0oooo0?ooo`0Z0?ooo`006P3oool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo00P0
oooo00<0<iWo0?ooo`3oool0:@3oool001X0oooo00<000000?ooo`3oool0c@3oool00`000000oooo
0?ooo`080?ooo`0303>Io`3oool0oooo02P0oooo000J0?ooo`030000003oool0oooo0<h0oooo00<0
00000?ooo`3oool0203oool00`0cVOl0oooo0?ooo`0W0?ooo`006P3oool00`00001000000?ooo`3?
0?ooo`030000003oool0oooo00P0oooo00<0<iWo0?ooo`3oool09P3oool001X0oooo00<000000?oo
o`3oool0d03oool00`000000oooo0?ooo`080?ooo`0303>Io`3oool0oooo02D0oooo000J0?ooo`03
0000003oool0oooo0=00oooo00<000000?ooo`3oool02@3oool00`0cVOl0oooo0?ooo`0T0?ooo`00
6P3oool00`000000oooo0?ooo`3A0?ooo`030000003oool0oooo00T0oooo00<0<iWo0?ooo`3oool0
8`3oool001X0oooo00<000000?ooo`3oool0dP3oool00`000000oooo0?ooo`090?ooo`0303>Io`3o
ool0oooo0280oooo000J0?ooo`030000003oool0oooo0=<0oooo00<000000?ooo`3oool02@3oool0
0`0cVOl0oooo0?ooo`0Q0?ooo`006P3oool00`000000oooo0?ooo`3D0?ooo`030000003oool0oooo
00T0oooo00<0<iWo0?ooo`3oool0803oool001X0oooo00<00000@000003oool0e03oool00`000000
oooo0?ooo`0:0?ooo`0303>Io`3oool0oooo01l0oooo000J0?ooo`030000003oool0oooo0=D0oooo
00<000000?ooo`3oool02@3oool00`0cVOl0oooo0?ooo`0O0?ooo`006P3oool00`000000oooo0?oo
o`3F0?ooo`030000003oool0oooo00T0oooo00<0<iWo0?ooo`3oool07P3oool001X0oooo00<00000
0?ooo`3oool0e`3oool00`000000oooo0?ooo`090?ooo`0303>Io`3oool0oooo01d0oooo000J0?oo
o`030000003oool0oooo0=P0oooo00<000000?ooo`3oool02@3oool00`0cVOl0oooo0?ooo`0L0?oo
o`006P3oool00`000000oooo0?ooo`3H0?ooo`030000003oool0oooo00X0oooo00<0<iWo0?ooo`3o
ool06`3oool001X0oooo00<000000?ooo`3oool0f@3oool00`000000oooo0?ooo`0:0?ooo`0303>I
o`3oool0oooo01X0oooo000J0?ooo`03000004000000oooo0=X0oooo00<000000?ooo`3oool09P3o
ool001X0oooo00<000000?ooo`3oool0f`3oool00`000000oooo0?ooo`0U0?ooo`006P3oool00`00
0000oooo0?ooo`3L0?ooo`030000003oool0oooo02@0oooo000J0?ooo`030000003oool0oooo0=d0
oooo00<000000?ooo`3oool08`3oool001X0oooo00<000000?ooo`3oool0gP3oool00`000000oooo
0?ooo`0R0?ooo`006P3oool00`000000oooo0?ooo`3O0?ooo`030000003oool0oooo0240oooo000J
0?ooo`030000003oool0oooo0>00oooo00<000000?ooo`3oool0803oool001X0oooo00<00000@000
003oool0h03oool00`000000oooo0?ooo`0P0?ooo`006P3oool00`000000oooo0?ooo`3Q0?ooo`03
0000003oool0oooo01l0oooo000J0?ooo`030000003oool0oooo0>80oooo00<000000?ooo`3oool0
7P3oool001X0oooo00<000000?ooo`3oool0h`3oool00`000000oooo0?ooo`0M0?ooo`006P3oool0
0`000000oooo0?ooo`3T0?ooo`030000003oool0oooo01`0oooo000?0?ooo`=000000P3oool00d00
0000oooo0?ooo`030?ooo`030000003oool0oooo0>D0oooo00<000000?ooo`3oool06`3oool00100
oooo00I000000?ooo`3ooom000000?oood0000040?ooo`030000003oool0oooo0>H0oooo00<00000
0?ooo`3oool06P3oool000h0oooo14000000103ooom000000?oood0000040?ooo`03000004000000
oooo0>H0oooo00=000000?ooo`3oool06P3oool000h0oooo00=000000?oood0000000P3oool00d00
0000oooo@00000040?ooo`030000003oool0oooo0?l0oooo103oool000l0oooo0T0000020?ooo`03
@000003ooom0000000@0oooo00<000000?ooo`3oool0o`3oool40?ooo`00403oool01D000000oooo
0?ooo`3ooom0000000D0oooo00<000000?ooo`3oool0o`3oool40?ooo`006P3oool00`000000oooo
0?ooo`3o0?ooo`@0oooo000J0?ooo`030000003oool0oooo0?l0oooo103oool001X0oooo00<00000
0?ooo`3oool0o`3oool40?ooo`006P3oool00d000000oooo0?ooo`3o0?ooo`@0oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo000H0?ooo`=0
0000o`3oool60?ooo`00603oool00d000000oooo0?ooo`3o0?ooo`H0oooo000H0?ooo`03@000003o
ool0oooo0?l0oooo1P3oool001P0oooo0d00003o0?ooo`H0oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {10.9503, -3.47127, 0.342904, 
  0.291286}}],

Cell[OutputFormData["\<\
Graphics[{{Thickness[0.007], 
    {Line[{{4.166666666666666*^-6, 0.}, 
       {4.056699157291579, 0.}, {8.480879985937368, 0.}, 
       {12.63593663385385, 0.}, {16.6318407770828, 0.}, 
       {20.88525908229088, 0.}, {24.9795248828114, 0.}, 
       {29.33130484531106, 0.}, {33.52393230312316, 0.}, 
       {37.55740725624772, 0.}, {41.8483963713514, 0.}, 
       {45.98023298176753, 0.}, {49.95291708749613, 0.}, 
       {54.18311535520386, 0.}, {56.12954460089411, 0.}, 
       {58.25416111822403, 0.}, {58.81114343011613, 0.}, 
       {59.40491061331435, 0.}, {59.69342720002801, 0.}, 
       {59.83498527437989, 0.}, {59.96522545560042, 0.}, 
       {60.08389716597674, 0.08389716597674379}, 
       {60.20926972532082, 0.2092697253208228}, 
       {60.47325989076972, 0.473259890769718}, 
       {62.58272104322332, 2.58272104322333}, 
       {66.56975592134719, 6.569755921347194}, 
       {70.81430496145019, 10.81430496145018}, 
       {74.89970149686563, 14.89970149686563}, 
       {79.2426121942602, 19.2426121942602}, 
       {83.42637038696722, 23.42637038696722}, 
       {87.45097607498669, 27.45097607498669}, 
       {91.73309592498529, 31.7330959249853}, 
       {95.85606327029635, 35.85606327029636}, 
       {99.81987811091986, 39.81987811091987}, 
       {99.99999583333332, 39.99999583333332}}]}}, 
   {RGBColor[0.2, 0.6, 1], 
    {Line[{{4.166666666666666*^-6, 0.}, 
       {4.056699157291579, 0.}, {6.168158254309742, 0.}, 
       {7.28556351508672, 0.}, {7.900025088072824, 0.}, 
       {8.480879985937368, 0.}, {8.743042063275071, 0.}, 
       {9.020963567123965, 0.}, {9.090844882206402, 0.}, 
       {9.166016948055524, 0.}, 
       {9.248507891293959, 4.834975042885935*^-16}, 
       {9.325786544432316, 4.875375112136406*^-16}, 
       {9.401128641144746, 4.914762780024563*^-16}, 
       {9.47274835817832, 4.952204446129628*^-16}, 
       {9.607207432383932, 1.004499508750609*^-15}, 
       {9.730183996262008, -1.725648291300214*^-15}, 
       {9.861282320884253, -1.584902716097246*^-16}, 
       {9.984994676776041, 1.446314296441719*^-15}, 
       {10.09716400035226, 3.588616691669504*^-16}, 
       {10.22944992559881, 1.47531809778119*^-15}, 
       {10.30397814646763, 1.537509083032861*^-15}, 
       {10.37254766492458, -1.073249269775836*^-15}, 
       {10.49869922956121, -7.246730407129789*^-16}, 
       {10.63197399634091, 5.389679848828624*^-17}, 
       {10.75670174642782, 8.828754777234466*^-16}, 
       {10.87042514672985, 3.036578549847717*^-15}, 
       {11.00169323323589, 4.563052497677743*^-15}, 
       {11.12604651054307, 4.804760291950294*^-15}, 
       {11.24080511058157, 9.832197334372938*^-15}, 
       {11.34697949600651, 1.394346982656635*^-14}, 
       {11.46350915064545, 1.940749930409784*^-14}, 
       {11.58730725856351, 2.763740725862255*^-14}, 
       {11.71102549932804, 3.855395331834259*^-14}, 
       {11.84439449151912, 5.847301734614664*^-14}, 
       {11.97030575240032, 8.391030919529628*^-14}, 
       {12.08575109600035, 1.148105394757324*^-13}, 
       {12.21374965299024, 1.667970831184993*^-13}, 
       {12.3537642366015, 2.414528567547221*^-13}, 
       {12.42443758087251, 2.933789960830965*^-13}, 
       {12.49993912906526, 3.617151815194819*^-13}, 
       {12.63593663385385, 5.181565592538268*^-13}, 
       {12.76536354091926, 7.270492466235051*^-13}, 
       {12.90773344657167, 1.044345153728354*^-12}, 
       {12.97940438807846, 1.254135832109999*^-12}, 
       {13.05640008196272, 1.52359534924832*^-12}, 
       {13.19548973542032, 2.148428363883379*^-12}, 
       {13.33378617445562, 3.011250542192989*^-12}, 
       {13.46507693943032, 4.124167548302294*^-12}, 
       {13.58293076403442, 5.451015441941522*^-12}, 
       {13.71140415628584, 7.355328526468875*^-12}, 
       {13.86517308992867, 1.046206612781199*^-11}, 
       {14.00441080728992, 1.431896561289016*^-11}, 
       {14.16514057486071, 2.044220874305481*^-11}, 
       {14.31635747620016, 2.840556802617006*^-11}, 
       {14.45687064901525, 3.837658118809491*^-11}, 
       {14.58597920880795, 5.038271013141838*^-11}, 
       {14.72771320878608, 6.763000826689609*^-11}, 
       {14.87725327605085, 9.180841253895319*^-11}, 
       {15.00929836664033, 1.19753852145032*^-10}, 
       {15.12953489519469, 1.520386691805947*^-10}, 
       {15.26832272364077, 1.995025006102446*^-10}, 
       {15.39962664357279, 2.570211351392167*^-10}, 
       {15.6330675560003, 3.997718871798308*^-10}, 
       {15.76487732418001, 5.105796972051606*^-10}, 
       {15.88666683629194, 6.381735412940997*^-10}, 
       {16.14204590085228, 1.009575837943817*^-9}, 
       {16.28733955143786, 1.303622588574543*^-9}, 
       {16.42356347675192, 1.650998264985713*^-9}, 
       {16.69787643164582, 2.630821643863853*^-9}, 
       {16.85203739511075, 3.399242483010672*^-9}, 
       {16.99319810364368, 4.283500542574061*^-9}, 
       {17.12793888492682, 5.325344854915522*^-9}, 
       {17.25497533794334, 6.521526683647396*^-9}, 
       {17.49252085969621, 9.462374468426494*^-9}, 
       {17.62569494692845, 1.161471128035421*^-8}, 
       {17.7483212936924, 1.399468252869734*^-8}, 
       {18.02525388507332, 2.115092812392566*^-8}, 
       {18.24736296025425, 2.922945737356333*^-8}, 
       {18.49136154440209, 4.138255848176034*^-8}, 
       {18.74613840284564, 5.900228916112485*^-8}, 
       {18.98418901535347, 8.157846843884694*^-8}, 
       {19.2658169416433, 1.186156056270823*^-7}, 
       {19.53282671692557, 1.676862688991481*^-7}, 
       {19.77252005926147, 2.272197166996365*^-7}, 
       {20.03346753080017, 3.140100570150105*^-7}, 
       {20.31676791291668, 4.424616115405504*^-7}, 
       {20.61798398716106, 6.313261364086977*^-7}, 
       {20.87513802465275, 8.490202530071654*^-7}, 
       {21.15921776614053, 1.168992871392808*^-6}, 
       {21.40516173429675, 1.532480505804882*^-6}, 
       {21.67441327767512, 2.048197906143294*^-6}, 
       {21.9555202842947, 2.753734851636381*^-6}, 
       {22.21726829569813, 3.605549680581247*^-6}, 
       {22.6864836984737, 5.762929543272977*^-6}, 
       {22.94922928754885, 7.43648103679296*^-6}, 
       {23.18816275762253, 9.333764863727244*^-6}, 
       {23.72801266885185, 0.00001535608945267894}, 
       {24.0326240162205, 0.00002015153546870544}, 
       {24.31370801450013, 0.00002574977004262887}, 
       {24.83005156777527, 0.00003985275145455477}, 
       {25.09046741849181, 0.00004935547551083735}, 
       {25.37715901092826, 0.0000621580058702345}, 
       {25.63841186730087, 0.00007636913651318461}, 
       {25.92343777022803, 0.00009517322588873462}, 
       {26.44246583151534, 0.0001404494692568316}, 
       {26.94776782421123, 0.0002023123836344484}, 
       {27.41665131562565, 0.0002805594402625057}, 
       {27.9735743242436, 0.0004079809339778773}, 
       {28.47827911212402, 0.0005657125956796109}, 
       {29.06088278101782, 0.0008135356879988078}, 
       {29.60945102811125, 0.001130483645410854}, 
       {30.09878975653618, 0.001500708337453797}, 
       {30.6356459962457, 0.002026225022831708}, 
       {31.19618785619259, 0.002741178640360677}, 
       {31.71924045271532, 0.003598334979113916}, 
       {32.65583710362706, 0.005726223253134001}, 
       {33.18088604598957, 0.007341002405222313}, 
       {33.65937050310635, 0.009140597541021172}, 
       {34.16471383576817, 0.01144078269615084}, 
       {34.70130764382017, 0.01440900889512536}, 
       {35.66482039903594, 0.0213963598504831}, 
       {36.70150239732711, 0.03192203513350949}, 
       {37.84522244528864, 0.0482570220625652}, 
       {38.90604096536287, 0.06909379185691733}, 
       {39.87819323491245, 0.09419011270652921}, 
       {40.94550828947037, 0.1297974215313979}, 
       {42.06864519736654, 0.1781997587083303}, 
       {43.07186673490182, 0.2326358176895109}, 
       {44.14308653679724, 0.3043246397865808}, 
       {46.07212459736093, 0.4751487921470429}, 
       {48.31506587996392, 0.754838241387894}, 
       {50.43147981662603, 1.113959704193845}, 
       {52.53449836415219, 1.575565208917344}, 
       {54.47253002651604, 2.102148640417286}, 
       {58.61194189369762, 3.574161351102723}, 
       {62.59220125619166, 5.441995105660947}, 
       {66.82997478066482, 7.887848461804644}, 
       {70.90859580045045, 10.62830561488468}, 
       {75.2447309822152, 13.87805348771484}, 
       {79.4217136592924, 17.2596149001431}, 
       {83.43954383168206, 20.68270255812823}, 
       {87.71488816605085, 24.45494060440129}, 
       {91.83107999573209, 28.17357970045216}, 
       {96.20478598739245, 32.18659757988625}, 
       {99.99999583333332, 35.70266564427654}}]}}}, 
  {DisplayFunction -> (Display[$Display, #1] & ), 
   PlotRange -> {{20, 100}, {0, 42}}, PlotRange -> All, 
   AspectRatio -> GoldenRatio^(-1), 
   DisplayFunction :> Identity, ColorOutput -> Automatic, 
   Axes -> Automatic, AxesOrigin -> Automatic, 
   PlotLabel -> None, AxesLabel -> {\"S\", \"c\"}, 
   Ticks -> Automatic, GridLines -> None, Prolog -> {}, 
   Epilog -> {}, AxesStyle -> Automatic, 
   Background -> Automatic, DefaultColor -> Automatic, 
   DefaultFont :> $DefaultFont, RotateLabel -> True, 
   Frame -> False, FrameStyle -> Automatic, 
   FrameTicks -> Automatic, FrameLabel -> None, 
   PlotRegion -> Automatic, ImageSize -> Automatic, 
   TextStyle :> $TextStyle, FormatType :> $FormatType}]\
\>", "\<\
-Graphics-\
\>"], "Output"]
}, Open  ]],

Cell["\<\
\"OBR.7
Eur\[OAcute]pska put opcia  s dividendou , payoff diagram\"\
\>", "Text"],

Cell[CellGroupData[{

Cell["\<\
X:=60;
sigma:=0.29;
r:=0.04;
DD:=0.;
tau:=0.6;
g1=Plot[Max[X-S,0],{S,0,100},PlotRange->All,AxesLabel->
{\"S\",\"p\"},PlotStyle -> 
{Thickness[0.007]}, DisplayFunction->Identity];

g2=Plot[EuropeanPutDiv[S,X,sigma,r,DD,tau],{S,0,100},PlotRange->All,AxesLabel-\
>
{\"S\",\"p\"},PlotStyle -> RGBColor[0.25,0.3,1], DisplayFunction->Identity];

Show[g1,g2,DisplayFunction->$DisplayFunction,PlotRange->{{20,100},{0,42}}]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.25 0.0125 0 0.0147151 [
[.125 -0.0125 -6 -9 ]
[.125 -0.0125 6 0 ]
[.25 -0.0125 -6 -9 ]
[.25 -0.0125 6 0 ]
[.375 -0.0125 -6 -9 ]
[.375 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.625 -0.0125 -6 -9 ]
[.625 -0.0125 6 0 ]
[.75 -0.0125 -6 -9 ]
[.75 -0.0125 6 0 ]
[.875 -0.0125 -6 -9 ]
[.875 -0.0125 6 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .14715 -12 -4.5 ]
[-0.0125 .14715 0 4.5 ]
[-0.0125 .2943 -12 -4.5 ]
[-0.0125 .2943 0 4.5 ]
[-0.0125 .44145 -12 -4.5 ]
[-0.0125 .44145 0 4.5 ]
[-0.0125 .5886 -12 -4.5 ]
[-0.0125 .5886 0 4.5 ]
[0 .64303 -5 0 ]
[0 .64303 5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.125 0 m
.125 .00625 L
s
[(30)] .125 -0.0125 0 1 Mshowa
.25 0 m
.25 .00625 L
s
[(40)] .25 -0.0125 0 1 Mshowa
.375 0 m
.375 .00625 L
s
[(50)] .375 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(60)] .5 -0.0125 0 1 Mshowa
.625 0 m
.625 .00625 L
s
[(70)] .625 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(80)] .75 -0.0125 0 1 Mshowa
.875 0 m
.875 .00625 L
s
[(90)] .875 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(100)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.025 0 m
.025 .00375 L
s
.05 0 m
.05 .00375 L
s
.075 0 m
.075 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.175 0 m
.175 .00375 L
s
.2 0 m
.2 .00375 L
s
.225 0 m
.225 .00375 L
s
.275 0 m
.275 .00375 L
s
.3 0 m
.3 .00375 L
s
.325 0 m
.325 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.425 0 m
.425 .00375 L
s
.45 0 m
.45 .00375 L
s
.475 0 m
.475 .00375 L
s
.525 0 m
.525 .00375 L
s
.55 0 m
.55 .00375 L
s
.575 0 m
.575 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.675 0 m
.675 .00375 L
s
.7 0 m
.7 .00375 L
s
.725 0 m
.725 .00375 L
s
.775 0 m
.775 .00375 L
s
.8 0 m
.8 .00375 L
s
.825 0 m
.825 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.925 0 m
.925 .00375 L
s
.95 0 m
.95 .00375 L
s
.975 0 m
.975 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .14715 m
.00625 .14715 L
s
[(10)] -0.0125 .14715 1 0 Mshowa
0 .2943 m
.00625 .2943 L
s
[(20)] -0.0125 .2943 1 0 Mshowa
0 .44145 m
.00625 .44145 L
s
[(30)] -0.0125 .44145 1 0 Mshowa
0 .5886 m
.00625 .5886 L
s
[(40)] -0.0125 .5886 1 0 Mshowa
.125 Mabswid
0 .02943 m
.00375 .02943 L
s
0 .05886 m
.00375 .05886 L
s
0 .08829 m
.00375 .08829 L
s
0 .11772 m
.00375 .11772 L
s
0 .17658 m
.00375 .17658 L
s
0 .20601 m
.00375 .20601 L
s
0 .23544 m
.00375 .23544 L
s
0 .26487 m
.00375 .26487 L
s
0 .32373 m
.00375 .32373 L
s
0 .35316 m
.00375 .35316 L
s
0 .38259 m
.00375 .38259 L
s
0 .41202 m
.00375 .41202 L
s
0 .47088 m
.00375 .47088 L
s
0 .50031 m
.00375 .50031 L
s
0 .52974 m
.00375 .52974 L
s
0 .55917 m
.00375 .55917 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.007 w
0 .5886 m
.01107 .57558 L
.06224 .51533 L
.11664 .45129 L
.16905 .3896 L
.21947 .33024 L
.2731 .2671 L
.32475 .2063 L
.37441 .14784 L
.42729 .0856 L
.47818 .02569 L
.49144 .01008 L
.49507 .0058 L
.49707 .00345 L
.49805 .0023 L
.49895 .00124 L
.4998 .00024 L
.5007 0 L
.50161 0 L
.5026 0 L
.50592 0 L
.53228 0 L
.58534 0 L
.63641 0 L
.69069 0 L
.74299 0 L
.7933 0 L
.84683 0 L
.89836 0 L
.94791 0 L
1 0 L
s
.25 .3 1 r
.5 Mabswid
0 .56767 m
.01107 .55464 L
.06224 .49439 L
.11664 .43039 L
.16905 .36897 L
.21947 .31069 L
.2731 .25097 L
.32475 .19761 L
.37441 .15198 L
.42729 .11093 L
.47818 .07927 L
.53228 .05366 L
.5844 .0358 L
.63453 .02368 L
.66035 .01899 L
.68788 .01492 L
.71409 .0118 L
.74245 .0091 L
.76752 .00721 L
.79504 .00556 L
.82121 .00433 L
.84886 .00331 L
.87446 .00257 L
.90191 .00196 L
.92979 .00148 L
.9562 .00113 L
1 .00073 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00<`3oool2@00000@0oooo00=000000?ooo`3oool05@3oool3@0000080oooo00=000000?oo
o`3oool05@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01D0oooo0T0000040?oo
o`03@000003oool0oooo01D0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0E0?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0503oool2@00000@0oooo00=000000?oo
o`3oool04@3oool5@0000080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0E0?oo
o`00=@3oool01T000000oooo0?oood000000oooo@00001L0oooo00I000000?ooo`3ooom000000?oo
od00000E0?ooo`03@000003ooom000000080oooo00=000000?oood0000005P3oool00d000000oooo
@00000020?ooo`03@000003ooom0000001H0oooo00M000000?ooo`3oool0oooo@000003ooom00000
01D0oooo00=000000?oood0000000P3oool00d000000oooo@000000G0?ooo`06@000003oool0oooo
@000003ooom00000503oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000
oooo@000000F0?ooo`00=03oool01d000000oooo0?ooo`3ooom000000?oood0000005@3oool4@000
00040?oood000000oooo@00001L0oooo00I000000?ooo`3ooom000000?oood00000F0?ooo`03@000
003ooom000000080oooo00=000000?oood0000005P3oool01d000000oooo0?ooo`3ooom000000?oo
od0000005@3oool00d000000oooo@00000020?ooo`03@000003ooom0000001H0oooo0T0000020?oo
o`03@000003ooom0000001@0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=0
00000?oood0000005P3oool003D0oooo00I000000?ooo`3ooom000000?oood00000E0?ooo`03@000
003ooom000000080oooo00=000000?oood0000005@3oool2@00000<0oooo00=000000?oood000000
5P3oool2@00000<0oooo00=000000?oood0000005`3oool01T000000oooo0?oood000000oooo@000
01H0oooo00M000000?ooo`3oool0oooo@000003ooom0000001D0oooo00=000000?oood0000000P3o
ool00d000000oooo@000000D0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03
@000003ooom0000001H0oooo000c0?ooo`03@000003ooom000000080oooo00=000000?oood000000
5P3oool2@0000080oooo00=000000?oood0000005@3oool00d000000oooo0?ooo`020?ooo`03@000
003ooom0000001H0oooo00=000000?ooo`3oool00P3oool00d000000oooo@000000E0?ooo`03@000
003ooom000000080oooo00=000000?oood0000005@3oool00d000000oooo@00000020?ooo`03@000
003ooom0000001D0oooo00=000000?oood0000000P3oool00d000000oooo@000000D0?ooo`07@000
003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom0000001H0oooo000d0?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool05P3oool01D000000oooo0?ooo`3ooom00000
01H0oooo0d0000030?ooo`03@000003oool0oooo01H0oooo0T0000030?ooo`03@000003oool0oooo
01@0oooo0d0000030?ooo`03@000003oool0oooo01D0oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`0E0?ooo`9000000`3oool00d000000oooo0?ooo`0B0?ooo`900000103oool00d00
0000oooo0?ooo`020?ooo`03@000003oool0oooo01D0oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooo`d0oooo0d00000A0?ooo`006P3ooooY00000003@000003oool0oooo
00H0oooo00=000000?oood0000004@3oool001X0oooo00<000000?ooo`3oool00`3oool00d000000
oooo0?ooo`030?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00`3oool00d000000
oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00=000000?ooo`3oool00`3oool00d000000
oooo0?ooo`030?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`03@000003oool0oooo00<0oooo00=000000?ooo`3oool00`3oool00d000000
oooo0?ooo`030?ooo`03@000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00d000000
oooo0?ooo`030?ooo`03@000003oool0oooo00<0oooo00=000000?ooo`3oool00`3oool00d000000
oooo0?ooo`020?ooo`800000103oool00d000000oooo0?ooo`030?ooo`03@000003oool0oooo00<0
oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo00<0
oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`030?ooo`03@000003oool0oooo00<0
oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`03@000003oool0oooo00<0
oooo00=000000?ooo`0oC?l0;00oC?l:0?ooo`03@000003oool0oooo00l0oooo000J0?ooo`030000
003oool0oooo01X0oooo00=000000?ooo`3oool06P3oool00d000000oooo0?ooo`0J0?ooo`03@000
003oool0oooo01T0oooo00<000000?oood000000703oool00d000000oooo0?ooo`0J0?ooo`03@000
003oool0?dco00/0?dco3`3oool00d000000oooo0?ooo`0J0?ooo`03@000003oool0oooo00L0oooo
00=000000?ooo`3oool0403oool001X0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?oo
o`0^0?ooo`d0?dco@@3oool00d000000oooo@000000A0?ooo`006P3oool00`000000oooo0?ooo`1_
0?ooo`030000003oool0oooo02T0oooo1P0oC?m>0?ooo`=000004@3oool001X0oooo00<000000?oo
o`3oool0K@3oool2000002H0oooo1P0oC?mX0?ooo`006P3oool00`000000oooo0?ooo`1/0?ooo`03
0000003oool0oooo0240oooo1@0oC?m^0?ooo`006P3oool00`00001000000?ooo`1[0?ooo`030000
003oool0oooo01h0oooo100oC?mc0?ooo`006P3oool00`000000oooo0?ooo`1Z0?ooo`030000003o
ool0oooo01/0oooo100oC?mg0?ooo`006P3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0
oooo01L0oooo100oC?mk0?ooo`006P3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo
01D0oooo0`0oC?mo0?ooo`006P3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo01<0
oooo0`0oC?n20?ooo`006P3oool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo0140oooo
0`0oC?n50?ooo`006P3oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo00l0oooo0`0o
C?n80?ooo`006P3oool00`00001000000?ooo`1V0?ooo`030000003oool0oooo00d0oooo0P0oC?n;
0?ooo`006P3oool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo00`0oooo0P0oC?n=0?oo
o`006P3oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo00/0oooo0P0oC?n?0?ooo`00
6P3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00X0oooo0P0oC?nA0?ooo`006P3o
ool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00P0oooo0P0oC?nC0?ooo`006P3oool0
0`000000oooo0?ooo`1R0?ooo`030000003oool0oooo00L0oooo0P0oC?nE0?ooo`006P3oool00`00
0000oooo0?ooo`1Q0?ooo`030000003oool0oooo00H0oooo0P0oC?nG0?ooo`006P3oool00`000010
00000?ooo`1P0?ooo`030000003oool0oooo00H0oooo00<0?dco0?ooo`3oool0U`3oool001X0oooo
00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`050?ooo`80?dcoVP3oool001X0oooo00<0
00000?ooo`3oool0GP3oool00`000000oooo0?ooo`040?ooo`80?dcoW03oool001X0oooo00<00000
0?ooo`3oool0GP3oool00`000000oooo0?ooo`030?ooo`0303m<o`3oool0oooo09`0oooo000J0?oo
o`030000003oool0oooo05d0oooo00<000000?ooo`3oool00P3oool203m<oil0oooo000J0?ooo`03
0000003oool0oooo05`0oooo00<000000?ooo`3oool00P3oool00`0oC?l0oooo0?ooo`2O0?ooo`00
6P3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo0080oooo00<0?dco0?ooo`3oool0
X03oool001X0oooo00<00000@000003oool0FP3oool010000000oooo0?ooo`3oool203m<oj<0oooo
000J0?ooo`030000003oool0oooo05T0oooo00D000000?ooo`3oool0oooo03m<o`2U0?ooo`006P3o
ool00`000000oooo0?ooo`1H0?ooo`050000003oool0oooo0?ooo`0oC?l0YP3oool001X0oooo00<0
00000?ooo`3oool0E`3oool00`000000oooo0?ooo`0203m<ojL0oooo000J0?ooo`030000003oool0
oooo05L0oooo00<000000?ooo`0oC?l0Z@3oool000d0oooo1D0000020?ooo`03@000003oool0oooo
00<0oooo00<000000?ooo`3oool0EP3oool00`000000oooo03m<o`2Z0?ooo`003`3oool01d000000
oooo0?ooo`3ooom000000?oood000000103oool00`000000oooo0?ooo`1E0?ooo`030000000oC?l0
?dco0:/0oooo000?0?ooo`07@000003oool0oooo0?oood000000oooo@00000040?ooo`0300000400
0000oooo05@0oooo00<0000003m<o`3oool0[03oool000l0oooo00M000000?ooo`3oool0oooo@000
003ooom0000000@0oooo00<000000?ooo`3oool0D`3oool00`000000?dco0?ooo`2]0?ooo`003`3o
ool01d000000oooo0?ooo`3ooom000000?oood000000103oool00`000000oooo0?ooo`1B0?ooo`03
0000000oC?l0oooo0:h0oooo000>0?ooo`900000103oool00d000000oooo0?ooo`030?ooo`030000
003oool0oooo0580oooo00<0?dco0?ooo`3oool0[P3oool001X0oooo00<000000?ooo`3oool0D@3o
ool00`0oC?l0oooo0?ooo`2_0?ooo`006P3oool00`000000oooo0?ooo`1@0?ooo`0303m<o`3oool0
oooo0;00oooo000J0?ooo`030000003oool0oooo04l0oooo00<0?dco0?ooo`3oool0/@3oool001X0
oooo00<00000@000003oool0CP3oool00`0oC?l0oooo0?ooo`2b0?ooo`006P3oool00`000000oooo
0?ooo`1=0?ooo`0303m<o`000000oooo0;<0oooo000J0?ooo`030000003oool0oooo04`0oooo00<0
?dco0000003oool0]03oool001X0oooo00<000000?ooo`3oool0B`3oool00`0oC?l000000?ooo`2e
0?ooo`006P3oool00`000000oooo0?ooo`1:0?ooo`0303m<o`000000oooo0;H0oooo000J0?ooo`03
0000003oool0oooo04T0oooo00<0?dco0?ooo`000000]`3oool001X0oooo00<000000?ooo`3oool0
B03oool00`0oC?l0oooo0000002h0?ooo`006P3oool00`00001000000?ooo`170?ooo`0303m<o`3o
ool000000;T0oooo000J0?ooo`030000003oool0oooo04H0oooo00<0?dco0?ooo`000000^P3oool0
01X0oooo00<000000?ooo`3oool0A@3oool00`0oC?l0oooo0000002k0?ooo`006P3oool00`000000
oooo0?ooo`140?ooo`0303m<o`3oool000000;`0oooo000J0?ooo`030000003oool0oooo04<0oooo
00@0?dco0?ooo`3oool00000_03oool001X0oooo00<000000?ooo`3oool0@P3oool0100oC?l0oooo
0?ooo`00002m0?ooo`006P3oool00`00001000000?ooo`110?ooo`0403m<o`3oool0oooo00000;h0
oooo000J0?ooo`030000003oool0oooo0400oooo00@0?dco0?ooo`3oool00000_`3oool001X0oooo
00<000000?ooo`3oool0?`3oool0100oC?l0oooo0?ooo`0000300?ooo`006P3oool00`000000oooo
0?ooo`0n0?ooo`0403m<o`3oool0oooo00000<40oooo000J0?ooo`030000003oool0oooo03d0oooo
00@0?dco0?ooo`3oool00000`P3oool001X0oooo00<000000?ooo`3oool0?03oool01@0oC?l0oooo
0?ooo`3oool000000<80oooo000J0?ooo`030000003oool0oooo03/0oooo00D0?dco0?ooo`3oool0
oooo000000330?ooo`006P3oool00`00001000000?ooo`0j0?ooo`0503m<o`3oool0oooo0?ooo`00
0000a03oool001X0oooo00<000000?ooo`3oool0>@3oool01@0oC?l0oooo0?ooo`3oool000000<D0
oooo000J0?ooo`030000003oool0oooo03P0oooo00D0?dco0?ooo`3oool0oooo000000360?ooo`00
6P3oool00`000000oooo0?ooo`0g0?ooo`0503m<o`3oool0oooo0?ooo`000000a`3oool001X0oooo
00<000000?ooo`3oool0=P3oool01@0oC?l0oooo0?ooo`3oool000000<P0oooo000>0?ooo`=00000
0`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo03H0oooo00D0?dco0?ooo`3oool0
oooo000000380?ooo`003P3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000000@0oooo
00<000000?ooo`3oool0=@3oool01@0oC?l0oooo0?ooo`3oool000000<T0oooo000?0?ooo`07@000
003oool0oooo0?oood000000oooo@00000040?ooo`03000004000000oooo03@0oooo00D0?dco0?oo
o`3oool0oooo0000003:0?ooo`003`3oool01d000000oooo0?ooo`3ooom000000?oood000000103o
ool00`000000oooo0?ooo`0c0?ooo`0503m<o`3oool0oooo0?ooo`000000b`3oool000h0oooo00=0
00000?oood0000000P3oool00d000000oooo@00000040?ooo`030000003oool0oooo0380oooo00D0
?dco0?ooo`3oool0oooo0000003<0?ooo`003`3oool00d000000oooo0?ooo`020?ooo`03@000003o
ool0oooo00<0oooo00<000000?ooo`3oool0<@3oool01@0oC?l0oooo0?ooo`3oool000000<d0oooo
000J0?ooo`030000003oool0oooo0300oooo00D0?dco0?ooo`3oool0oooo0000003>0?ooo`006P3o
ool00`000000oooo0?ooo`0_0?ooo`0503m<o`3oool0oooo0?ooo`000000c`3oool001X0oooo00<0
00000?ooo`3oool0;P3oool00`0oC?l0oooo0?ooo`020?ooo`030000003oool0oooo0<d0oooo000J
0?ooo`03000004000000oooo02d0oooo00<0?dco0?ooo`3oool00P3oool00`000000oooo0?ooo`3>
0?ooo`006P3oool00`000000oooo0?ooo`0]0?ooo`0503m<o`3oool0oooo0?ooo`000000d@3oool0
01X0oooo00<000000?ooo`3oool0;03oool01@0oC?l0oooo0?ooo`3oool000000=80oooo000J0?oo
o`030000003oool0oooo02/0oooo00D0?dco0?ooo`3oool0oooo0000003C0?ooo`006P3oool00`00
0000oooo0?ooo`0Z0?ooo`0503m<o`3oool0oooo0?ooo`000000e03oool001X0oooo00<000000?oo
o`3oool0:@3oool01@0oC?l0oooo0?ooo`3oool000000=D0oooo000J0?ooo`030000003oool0oooo
02P0oooo00D0?dco0?ooo`3oool0oooo0000003F0?ooo`006P3oool00`00001000000?ooo`0W0?oo
o`0503m<o`3oool0oooo0?ooo`000000e`3oool001X0oooo00<000000?ooo`3oool09`3oool0100o
C?l0oooo0?ooo`00003H0?ooo`006P3oool00`000000oooo0?ooo`0V0?ooo`0503m<o`3oool0oooo
0?ooo`000000f03oool001X0oooo00<000000?ooo`3oool09@3oool01@0oC?l0oooo0?ooo`3oool0
00000=T0oooo000J0?ooo`030000003oool0oooo02@0oooo00D0?dco0?ooo`3oool0oooo0000003J
0?ooo`006P3oool00`000000oooo0?ooo`0S0?ooo`0503m<o`3oool0oooo0?ooo`000000f`3oool0
01X0oooo00<000000?ooo`3oool08P3oool01@0oC?l0oooo0?ooo`3oool000000=`0oooo000J0?oo
o`03000004000000oooo0240oooo00D0?dco0?ooo`3oool0oooo0000003M0?ooo`006P3oool00`00
0000oooo0?ooo`0Q0?ooo`0403m<o`3oool0oooo00000=h0oooo000J0?ooo`030000003oool0oooo
0200oooo00@0?dco0?ooo`3oool00000g`3oool001X0oooo00<000000?ooo`3oool07`3oool0100o
C?l0oooo0?ooo`00003P0?ooo`006P3oool00`000000oooo0?ooo`0N0?ooo`0503m<o`3oool0oooo
0?ooo`000000h03oool001X0oooo00<000000?ooo`3oool07@3oool01@0oC?l0oooo0?ooo`3oool0
00000>40oooo000J0?ooo`030000003oool0oooo01`0oooo00D0?dco0?ooo`3oool0oooo0000003R
0?ooo`006P3oool00`00001000000?ooo`0K0?ooo`0503m<o`3oool0oooo0?ooo`000000h`3oool0
01X0oooo00<000000?ooo`3oool06`3oool0100oC?l0oooo0?ooo`00003T0?ooo`006P3oool00`00
0000oooo0?ooo`0J0?ooo`0503m<o`3oool0oooo0?ooo`000000i03oool001X0oooo00<000000?oo
o`3oool06@3oool01@0oC?l0oooo0?ooo`3oool000000>D0oooo000>0?ooo`900000103oool00d00
0000oooo0?ooo`030?ooo`030000003oool0oooo01P0oooo00D0?dco0?ooo`3oool0oooo0000003V
0?ooo`00403oool01T000000oooo0?oood000000oooo@00000@0oooo00<000000?ooo`3oool05`3o
ool01@0oC?l0oooo0?ooo`3oool000000>L0oooo000?0?ooo`07@000003oool0oooo0?oood000000
oooo@00000040?ooo`03000004000000oooo01H0oooo00D0?dco0?ooo`3oool0oooo0000003X0?oo
o`00403oool01T000000oooo0?oood000000oooo@00000@0oooo00<000000?ooo`3oool05@3oool0
0`0oC?l0oooo0?ooo`020?ooo`030000003oool0oooo0>H0oooo000>0?ooo`03@000003ooom00000
0080oooo00=000000?oood000000103oool00`000000oooo0?ooo`0E0?ooo`0503m<o`3oool0oooo
0?ooo`000000j@3oool000l0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`030?oo
o`030000003oool0oooo01@0oooo00D0?dco0?ooo`3oool0oooo0000003Z0?ooo`006P3oool00`00
0000oooo0?ooo`0C0?ooo`0503m<o`3oool0oooo0?ooo`000000j`3oool001X0oooo00<000000?oo
o`3oool04P3oool01@0oC?l0oooo0?ooo`3oool000000>`0oooo000J0?ooo`030000003oool0oooo
0140oooo00D0?dco0?ooo`3oool0oooo0000003]0?ooo`006P3oool00`00001000000?ooo`0@0?oo
o`0303m<o`3oool0oooo0080oooo00<000000?ooo`3oool0j`3oool001X0oooo00<000000?ooo`3o
ool03`3oool00`0oC?l0oooo0?ooo`020?ooo`030000003oool0oooo0>`0oooo000J0?ooo`030000
003oool0oooo00h0oooo00<0?dco0?ooo`3oool00P3oool00`000000oooo0?ooo`3]0?ooo`006P3o
ool00`000000oooo0?ooo`0>0?ooo`0503m<o`3oool0oooo0?ooo`000000l03oool001X0oooo00<0
00000?ooo`3oool03@3oool01@0oC?l0oooo0?ooo`3oool000000?40oooo000J0?ooo`030000003o
ool0oooo00`0oooo00D0?dco0?ooo`3oool0oooo0000003b0?ooo`006P3oool00`000000oooo0?oo
o`0;0?ooo`0503m<o`3oool0oooo0?ooo`000000l`3oool001X0oooo00<00000@000003oool02P3o
ool01@0oC?l0oooo0?ooo`3oool000000?@0oooo000J0?ooo`030000003oool0oooo00T0oooo00<0
?dco0?ooo`3oool00P3oool00`000000oooo0?ooo`3b0?ooo`006P3oool00`000000oooo0?ooo`08
0?ooo`0303m<o`3oool0oooo0080oooo00<000000?ooo`3oool0l`3oool001X0oooo00<000000?oo
o`3oool0203oool01@0oC?l0oooo0?ooo`3oool000000?H0oooo000J0?ooo`030000003oool0oooo
00L0oooo00D0?dco0?ooo`3oool0oooo0000003g0?ooo`006P3oool00`000000oooo0?ooo`060?oo
o`0503m<o`3oool0oooo0?ooo`000000n03oool001X0oooo00<000000?ooo`3oool01@3oool01@0o
C?l0oooo0?ooo`3oool000000?T0oooo000J0?ooo`03000004000000oooo00@0oooo00D0?dco0?oo
o`3oool0oooo0000003j0?ooo`006P3oool00`000000oooo0?ooo`030?ooo`0303m<o`3oool0oooo
0080oooo00<000000?ooo`3oool0n03oool001X0oooo00<000000?ooo`3oool00P3oool00`0oC?l0
oooo0?ooo`020?ooo`030000003oool0oooo0?T0oooo000J0?ooo`030000003oool0oooo0080oooo
00D0?dco0?ooo`3oool0oooo0000003l0?ooo`006P3oool01@000000oooo0?ooo`3oool0?dco00<0
oooo00<000000?ooo`3oool0n`3oool001X0oooo00@000000?ooo`3oool0?dco0`3oool00`000000
oooo0?ooo`3l0?ooo`006P3oool00`000000oooo03m<o`030?ooo`030000003oool0oooo0?d0oooo
000J0?ooo`030000000oC?l0oooo0080oooo00<000000?ooo`3oool0oP3oool001X0oooo00<00000
03m<o`3oool00P3oool00`000000oooo0?ooo`3n0?ooo`006P3oool01@0oC?l0oooo0?ooo`3oool0
00000?l0oooo0P3oool001X0oooo00@000000?ooo`3oool00000o`3oool30?ooo`006P3oool00`00
0000oooo0000003o0?ooo`@0oooo000?0?ooo`=000000P3oool00d000000oooo0?ooo`030?ooo`80
0000o`3oool50?ooo`00403oool01T000000oooo0?oood000000oooo@00000@0oooo0P00003o0?oo
o`D0oooo000>0?ooo`A0000000@0oooo@000003ooom00000103oool00`00001000000?ooo`3o0?oo
o`@0oooo000>0?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool00`000000
oooo0?ooo`3o0?ooo`@0oooo000?0?ooo`9000000P3oool00d000000oooo@00000040?ooo`030000
003oool0oooo0?l0oooo103oool00100oooo00E000000?ooo`3oool0oooo@00000050?ooo`030000
003oool0oooo0?l0oooo103oool001X0oooo00<000000?ooo`3oool0o`3oool40?ooo`006P3oool0
0`000000oooo0?ooo`3o0?ooo`@0oooo000J0?ooo`030000003oool0oooo0?l0oooo103oool001X0
oooo00=000000?ooo`3oool0o`3oool40?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`005`3oool3@0000?l0oooo1`3oool001P0oooo00=000000?ooo`3oool0o`3oool60?ooo`00
603oool3@0000?l0oooo1P3oool001P0oooo00A000000?ooo`3ooom00000o`3oool50?ooo`00603o
ool014000000oooo0?oood00003o0?ooo`D0oooo000G0?ooo`A00000o`3oool60?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {10.9503, -3.47127, 0.342904, 
  0.291286}}],

Cell[OutputFormData["\<\
Graphics[{{Thickness[0.007], 
    {Line[{{4.166666666666666*^-6, 59.99999583333333}, 
       {4.056699157291579, 55.94330084270842}, 
       {8.480879985937368, 51.51912001406262}, 
       {12.63593663385385, 47.36406336614614}, 
       {16.6318407770828, 43.36815922291719}, 
       {20.88525908229088, 39.11474091770911}, 
       {24.9795248828114, 35.02047511718859}, 
       {29.33130484531106, 30.66869515468893}, 
       {33.52393230312316, 26.47606769687683}, 
       {37.55740725624772, 22.44259274375227}, 
       {41.8483963713514, 18.15160362864859}, 
       {45.98023298176753, 14.01976701823245}, 
       {49.95291708749613, 10.04708291250385}, 
       {54.18311535520386, 5.816884644796139}, 
       {58.25416111822403, 1.745838881775966}, 
       {59.31514618235505, 0.6848538176449423}, 
       {59.60582673192192, 0.3941732680780773}, 
       {59.76538871273101, 0.23461128726899}, 
       {59.84367636683222, 0.1563236331677728}, 
       {59.91570474320114, 0.0842952567988604}, 
       {59.98401104101897, 0.01598895898102625}, 
       {60.05617428320688, 0.}, {60.12861230349221, 0.}, 
       {60.20812448940978, 0.}, {60.47325989076972, 0.}, 
       {62.58272104322332, 0.}, {66.82727008332632, 0.}, 
       {70.91266661874176, 0.}, {75.25557731613633, 0.}, 
       {79.43933550884335, 0.}, {83.46394119686284, 0.}, 
       {87.74606104686144, 0.}, {91.8690283921725, 0.}, 
       {95.83284323279601, 0.}, {99.99999583333332, 0.}}]}}, 
   {RGBColor[0.25, 0.3, 1], 
    {Line[{{4.166666666666666*^-6, 58.57713841880789}, 
       {4.056699157291579, 54.52044342818297}, 
       {8.480879985937368, 50.09626259953718}, 
       {12.63593663385385, 45.94120595162437}, 
       {16.6318407770828, 41.94530182063644}, 
       {20.88525908229088, 37.69188696264124}, 
       {24.9795248828114, 33.59776682591529}, 
       {29.33130484531106, 29.2485056123909}, 
       {33.52393230312316, 25.07403474713321}, 
       {37.55740725624772, 21.11397314157332}, 
       {41.8483963713514, 17.05538415992853}, 
       {45.98023298176753, 13.42902451525382}, 
       {49.95291708749613, 10.32797750081466}, 
       {54.18311535520386, 7.538247041581122}, 
       {58.25416111822403, 5.387035290657117}, 
       {62.58272104322332, 3.646820790753992}, 
       {66.75212846353508, 2.432842097774383}, 
       {70.76238337915929, 1.609385048694157}, 
       {72.8280561407872, 1.290213193732292}, 
       {75.03015245676263, 1.013656968840656}, 
       {77.1275086848816, 0.8015607188159634}, 
       {79.39628319165755, 0.61865435551897}, 
       {81.40184265745249, 0.4900599748171146}, 
       {83.60326142186492, 0.3779327268824701}, 
       {85.69682440036169, 0.2941300093891072}, 
       {87.90860130936389, 0.2249016760211617}, 
       {89.95712166295859, 0.1748910719397045}, 
       {92.15315034946687, 0.1331763453190433}, 
       {94.38334570015811, 0.1007019760430551}, 
       {96.49606104686146, 0.07709456563131311}, 
       {99.99999583333332, 0.04928012511747681}}]}}}, 
  {DisplayFunction -> (Display[$Display, #1] & ), 
   PlotRange -> {{20, 100}, {0, 42}}, PlotRange -> All, 
   AspectRatio -> GoldenRatio^(-1), 
   DisplayFunction :> Identity, ColorOutput -> Automatic, 
   Axes -> Automatic, AxesOrigin -> Automatic, 
   PlotLabel -> None, AxesLabel -> {\"S\", \"p\"}, 
   Ticks -> Automatic, GridLines -> None, Prolog -> {}, 
   Epilog -> {}, AxesStyle -> Automatic, 
   Background -> Automatic, DefaultColor -> Automatic, 
   DefaultFont :> $DefaultFont, RotateLabel -> True, 
   Frame -> False, FrameStyle -> Automatic, 
   FrameTicks -> Automatic, FrameLabel -> None, 
   PlotRegion -> Automatic, ImageSize -> Automatic, 
   TextStyle :> $TextStyle, FormatType :> $FormatType}]\
\>", "\<\
-Graphics-\
\>"], "Output"]
}, Open  ]],

Cell["\<\
\"OBR.8
Americk\[AAcute] put opcia s dividendami a payoff diagram
numerick\[EAcute] rie\.9aenie\"\
\>", "Text"],

Cell[CellGroupData[{

Cell["\<\
X=60;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.6;
m=20;
n=10;
Slarge=150;
trans=0.0;
time=0.03;
eps=0.01;

AmericanPut[X,sigma,r,DD,t,m,n,trans,time,eps];

g1=ListPlot[graf[n],PlotStyle->{PointSize[0.02],RGBColor[1,0,1]},\
DisplayFunction->Identity];
g2=Plot[Max[X-S,0],{S,0,150},PlotRange->All, DisplayFunction->Identity];

Show[g1,g2,DisplayFunction->$DisplayFunction,PlotRange->{{20,130},{0,40}}]
\
\>", "Input"],

Cell["Pomer k/h^2  1.20202", "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.181818 0.00909091 0 0.0154508 [
[.18182 -0.0125 -6 -9 ]
[.18182 -0.0125 6 0 ]
[.36364 -0.0125 -6 -9 ]
[.36364 -0.0125 6 0 ]
[.54545 -0.0125 -6 -9 ]
[.54545 -0.0125 6 0 ]
[.72727 -0.0125 -9 -9 ]
[.72727 -0.0125 9 0 ]
[.90909 -0.0125 -9 -9 ]
[.90909 -0.0125 9 0 ]
[-0.0125 .07725 -6 -4.5 ]
[-0.0125 .07725 0 4.5 ]
[-0.0125 .15451 -12 -4.5 ]
[-0.0125 .15451 0 4.5 ]
[-0.0125 .23176 -12 -4.5 ]
[-0.0125 .23176 0 4.5 ]
[-0.0125 .30902 -12 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .38627 -12 -4.5 ]
[-0.0125 .38627 0 4.5 ]
[-0.0125 .46353 -12 -4.5 ]
[-0.0125 .46353 0 4.5 ]
[-0.0125 .54078 -12 -4.5 ]
[-0.0125 .54078 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.18182 0 m
.18182 .00625 L
s
[(40)] .18182 -0.0125 0 1 Mshowa
.36364 0 m
.36364 .00625 L
s
[(60)] .36364 -0.0125 0 1 Mshowa
.54545 0 m
.54545 .00625 L
s
[(80)] .54545 -0.0125 0 1 Mshowa
.72727 0 m
.72727 .00625 L
s
[(100)] .72727 -0.0125 0 1 Mshowa
.90909 0 m
.90909 .00625 L
s
[(120)] .90909 -0.0125 0 1 Mshowa
.125 Mabswid
.04545 0 m
.04545 .00375 L
s
.09091 0 m
.09091 .00375 L
s
.13636 0 m
.13636 .00375 L
s
.22727 0 m
.22727 .00375 L
s
.27273 0 m
.27273 .00375 L
s
.31818 0 m
.31818 .00375 L
s
.40909 0 m
.40909 .00375 L
s
.45455 0 m
.45455 .00375 L
s
.5 0 m
.5 .00375 L
s
.59091 0 m
.59091 .00375 L
s
.63636 0 m
.63636 .00375 L
s
.68182 0 m
.68182 .00375 L
s
.77273 0 m
.77273 .00375 L
s
.81818 0 m
.81818 .00375 L
s
.86364 0 m
.86364 .00375 L
s
.95455 0 m
.95455 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .07725 m
.00625 .07725 L
s
[(5)] -0.0125 .07725 1 0 Mshowa
0 .15451 m
.00625 .15451 L
s
[(10)] -0.0125 .15451 1 0 Mshowa
0 .23176 m
.00625 .23176 L
s
[(15)] -0.0125 .23176 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(20)] -0.0125 .30902 1 0 Mshowa
0 .38627 m
.00625 .38627 L
s
[(25)] -0.0125 .38627 1 0 Mshowa
0 .46353 m
.00625 .46353 L
s
[(30)] -0.0125 .46353 1 0 Mshowa
0 .54078 m
.00625 .54078 L
s
[(35)] -0.0125 .54078 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(40)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .01545 m
.00375 .01545 L
s
0 .0309 m
.00375 .0309 L
s
0 .04635 m
.00375 .04635 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .10816 m
.00375 .10816 L
s
0 .12361 m
.00375 .12361 L
s
0 .13906 m
.00375 .13906 L
s
0 .16996 m
.00375 .16996 L
s
0 .18541 m
.00375 .18541 L
s
0 .20086 m
.00375 .20086 L
s
0 .21631 m
.00375 .21631 L
s
0 .24721 m
.00375 .24721 L
s
0 .26266 m
.00375 .26266 L
s
0 .27812 m
.00375 .27812 L
s
0 .29357 m
.00375 .29357 L
s
0 .32447 m
.00375 .32447 L
s
0 .33992 m
.00375 .33992 L
s
0 .35537 m
.00375 .35537 L
s
0 .37082 m
.00375 .37082 L
s
0 .40172 m
.00375 .40172 L
s
0 .41717 m
.00375 .41717 L
s
0 .43262 m
.00375 .43262 L
s
0 .44807 m
.00375 .44807 L
s
0 .47898 m
.00375 .47898 L
s
0 .49443 m
.00375 .49443 L
s
0 .50988 m
.00375 .50988 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .57168 m
.00375 .57168 L
s
0 .58713 m
.00375 .58713 L
s
0 .60258 m
.00375 .60258 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.02 w
.03636 .55623 Mdot
.04659 .53885 Mdot
.0573 .52065 Mdot
.06851 .5016 Mdot
.08025 .48165 Mdot
.09253 .46077 Mdot
.10539 .43891 Mdot
.11886 .41603 Mdot
.13295 .39207 Mdot
.14771 .36699 Mdot
.16316 .34073 Mdot
.17933 .31325 Mdot
.19626 .28447 Mdot
.21399 .25435 Mdot
.23254 .22371 Mdot
.25197 .194 Mdot
.2723 .16561 Mdot
.29359 .13896 Mdot
.31588 .11444 Mdot
.33921 .09237 Mdot
.36364 .07298 Mdot
.38921 .05638 Mdot
.41598 .04254 Mdot
.444 .03131 Mdot
.47334 .02246 Mdot
.50405 .01568 Mdot
.53621 .01064 Mdot
.56987 .007 Mdot
.60511 .00446 Mdot
.642 .00274 Mdot
.68062 .00161 Mdot
.72105 .00091 Mdot
.76338 .00048 Mdot
.80769 .00023 Mdot
.85408 .0001 Mdot
.90264 4e-005 Mdot
.95348 1e-005 Mdot
0 g
.5 Mabswid
0 .61803 m
.04498 .54159 L
.10298 .44301 L
.15881 .34812 L
.21815 .24726 L
.27533 .15009 L
.33033 .05661 L
.34499 .03169 L
.35873 .00834 L
.36042 .00546 L
.36227 .00232 L
.36401 0 L
.36563 0 L
.36951 0 L
.37306 0 L
.38884 0 L
.44487 0 L
.50441 0 L
.56177 0 L
.61697 0 L
.67568 0 L
.73222 0 L
.78659 0 L
.84447 0 L
.90018 0 L
.9594 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00@@3oool3@0000080oooo00=000000?ooo`3oool09P3oool2@00000@0oooo00=000000?oo
o`3oool09`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo02<0oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0803oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool0603oool00480oooo00I000000?ooo`3ooom000000?oood00
000W0?ooo`03@000003ooom000000080oooo00=000000?oood0000009`3oool00d000000oooo@000
00020?ooo`03@000003ooom0000002H0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood0000008`3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oo
od0000006@3oool00400oooo14000000103ooom000000?oood00000W0?ooo`03@000003ooom00000
0080oooo00=000000?oood0000009`3oool00d000000oooo@00000020?ooo`03@000003ooom00000
02H0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood0000008`3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000I0?ooo`00
@03oool00d000000oooo@00000020?ooo`03@000003ooom0000002L0oooo0T0000030?ooo`03@000
003ooom0000002P0oooo00M000000?ooo`3oool0oooo@000003ooom0000002H0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood0000008`3oool00d000000oooo0?oo
o`020?ooo`07@000003oool0oooo0?oood000000oooo@000000I0?ooo`00@@3oool2@0000080oooo
00=000000?oood0000009`3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000002L0oooo
00=000000?oood0000000P3oool00d000000oooo@000000V0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000020?ooo`03@000003ooom0000002<0oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood0000006@3oool00480oooo00E000000?ooo`3oool0oooo@000
000Y0?ooo`9000000`3oool00d000000oooo0?ooo`0W0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool0903oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`0Q0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01P0oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo00330?ooo`@0o`3o1`3o
ool40?l0o`L0oooo103o0?l70?ooo`@0o`3o203oool40?l0o`T0oooo103o0?l90?ooo`@0o`3o4P3o
ool001D0oooon@0000000d00000000000000000700000003@000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo00T0oooo00=000000?ooo`3oool02@3oool00d000000oooo0?ooo`080?oo
o`03@000003oool0oooo00T0oooo00=000000?ooo`3oool02@3oool00d000000oooo0?ooo`090?oo
o`03@000003oool0oooo00P0oooo00=000000?ooo`3oool0203oool00`00001000000?ooo`0:0?oo
o`03@000003oool0oooo00T0oooo00=000000?ooo`3oool02@3oool00d000000oooo0?ooo`080?oo
o`03@000003oool0oooo0080oooo103o0?l30?ooo`03@000003oool0o`3o00<0o`3o1@3oool40?l0
o`H0oooo103o0?l70?ooo`@0o`3o00=000000?ooo`3oool0103oool40?l0o`03@000003oool0oooo
00@0oooo103o0?l00`3ooom000000?ooo`050?ooo`@0o`3o00<0oooo@000003oool01P3oool40?l0
o`03@000003oool0oooo00H0oooo103o0?lB0?ooo`005@3oool00`000000oooo0?ooo`1J0?ooo`03
0000003oool0oooo02T0oooo103o0?l50?ooo`@0o`3o1@3oool40?l0o`D0oooo103o0?l70?ooo`80
o`3o2@3oool20?l0o`T0oooo0P3o0?l90?ooo`80o`3o2P3oool20?l0o`/0oooo0P3o0?l;0?ooo`80
o`3o4`3oool001D0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0R0?ooo`@0o`3o
103oool40?l0o`D0oooo103o0?l60?ooo`80o`3o1`3oool20?l0of@0oooo000E0?ooo`0300000400
0000oooo05T0oooo00<000000?ooo`3oool08P3oool40?l0o`@0oooo103o0?l60?ooo`80o`3oMP3o
ool001D0oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`0K0?ooo`@0o`3o103oool4
0?l0o`D0oooo0P3o0?mo0?ooo`005@3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo
01`0oooo103o0?l50?ooo`80o`3oQ`3oool001D0oooo00<000000?ooo`3oool0E`3oool00`000000
oooo0?ooo`0D0?ooo`@0o`3o103oool40?l0ohh0oooo000E0?ooo`03000004000000oooo05H0oooo
00<000000?ooo`3oool05@3oool40?l0o`D0oooo0P3o0?n?0?ooo`005@3oool00`000000oooo0?oo
o`1E0?ooo`030000003oool0oooo01H0oooo103o0?nF0?ooo`005@3oool00`000000oooo0?ooo`1E
0?ooo`030000003oool0oooo00l0oooo103o0?l40?ooo`80o`3oU`3oool001D0oooo00<000000?oo
o`3oool0E03oool00`000000oooo0?ooo`0@0?ooo`@0o`3oW@3oool001D0oooo00<00000@000003o
ool0E03oool00`000000oooo0?ooo`0@0?ooo`@0o`3oW@3oool001D0oooo00<000000?ooo`3oool0
D`3oool00`000000oooo0?ooo`0:0?ooo`@0o`3o103oool20?l0oih0oooo000E0?ooo`030000003o
ool0oooo05<0oooo00<000000?ooo`3oool02P3oool40?l0oj@0oooo000E0?ooo`030000003oool0
oooo0580oooo00<000000?ooo`3oool02`3oool40?l0oj@0oooo000E0?ooo`03000004000000oooo
0580oooo00<000000?ooo`3oool0303oool20?l0ojD0oooo000E0?ooo`030000003oool0oooo0540
oooo00<000000?ooo`3oool0]03oool000l0oooo00=000000?ooo`3oool00`3oool00`000000oooo
0?ooo`1A0?ooo`030000003oool0oooo00D0oooo103o0?n[0?ooo`003P3oool00d000000oooo@000
00040?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool01P3oool40?l0oj/0oooo000@
0?ooo`03@000003oool0oooo0080oooo0P0000000d000000oooo0?ooo`1=0?ooo`030000003oool0
oooo00L0oooo103o0?n[0?ooo`003P3oool2@00000D0oooo00<000000?ooo`3oool0C`3oool00`00
0000oooo0?ooo`080?ooo`80o`3o[03oool000h0oooo00=000000?ooo`3oool0103oool00`000000
oooo0?ooo`1>0?ooo`030000003oool0oooo0;L0oooo000>0?ooo`=00000103oool00`000000oooo
0?ooo`1>0?ooo`030000003oool0oooo0080oooo103o0?na0?ooo`005@3oool00`00001000000?oo
o`1=0?ooo`030000003oool0oooo00<0oooo103o0?na0?ooo`005@3oool00`000000oooo0?ooo`1<
0?ooo`030000003oool0oooo00@0oooo103o0?na0?ooo`005@3oool00`000000oooo0?ooo`1<0?oo
o`030000003oool0oooo00D0oooo0P3o0?nb0?ooo`005@3oool00`000000oooo0?ooo`1;0?ooo`03
0000003oool0oooo0;X0oooo000E0?ooo`03000004000000oooo04/0oooo00<000000?ooo`3oool0
^P3oool001D0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`040?l0okL0oooo000E
0?ooo`030000003oool0oooo04T0oooo00@000000?ooo`3oool0oooo103o0?ng0?ooo`005@3oool0
0`000000oooo0?ooo`190?ooo`040000003oool0oooo0?ooo`@0o`3o]`3oool001D0oooo00<00000
@000003oool0B03oool00`000000oooo0?ooo`030?ooo`80o`3o^03oool001D0oooo00<000000?oo
o`3oool0B03oool00`000000oooo0?ooo`2m0?ooo`005@3oool00`000000oooo0?ooo`170?ooo`03
0000003oool0oooo0;h0oooo000E0?ooo`030000003oool0oooo04H0oooo00<000000?l0o`3o0?l0
0P3o0?nm0?ooo`005@3oool00`00001000000?ooo`160?ooo`030000003o0?l0o`3o0080o`3o_@3o
ool001D0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?l0o`030?l0okd0oooo00080?oo
o`E000000P3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo04D0oooo00<000000?oo
o`3oool00P3o0?nn0?ooo`002P3oool01d000000oooo0?ooo`3ooom000000?oood000000103oool0
0`000000oooo0?ooo`140?ooo`030000003oool0oooo0<40oooo000:0?ooo`07@000003oool0oooo
0?oood000000oooo@00000040?ooo`80000000=000000?ooo`3oool0@@3oool00`000000oooo0?oo
o`320?ooo`002P3oool01d000000oooo0?ooo`3ooom000000?oood000000103oool00`000000oooo
0?ooo`130?ooo`030000003oool0oooo0<80oooo000:0?ooo`07@000003oool0oooo0?oood000000
oooo@00000040?ooo`030000003oool0oooo0480oooo00@000000?l0o`3o0?l0o`3o`P3oool000T0
oooo0T0000040?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0@P3oool010000000
o`3o0?l0o`3o0?o20?ooo`005@3oool00`00001000000?ooo`110?ooo`030000003o0?l0o`3o0080
o`3o`P3oool001D0oooo00<000000?ooo`3oool0@@3oool010000000oooo0?l0o`3o0?o30?ooo`00
5@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0<D0oooo000E0?ooo`030000003o
ool0oooo0400oooo00<000000?ooo`3oool0a@3oool001D0oooo00<00000@000003oool0?`3oool0
0`000000oooo0?ooo`360?ooo`005@3oool00`000000oooo0?ooo`0l0?ooo`80o`3o00<000000?l0
o`3oool0a`3oool001D0oooo00<000000?ooo`3oool0?03oool20?l0o`030000003o0?l0oooo0<L0
oooo000E0?ooo`030000003oool0oooo03`0oooo00@0o`3o0000003o0?l0o`3ob03oool001D0oooo
00<00000@000003oool0?@3oool00`000000o`3o0?ooo`380?ooo`005@3oool00`000000oooo0?oo
o`0l0?ooo`030000003oool0oooo0<T0oooo000E0?ooo`030000003oool0oooo03`0oooo00<00000
0?ooo`3oool0b@3oool001D0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`3:0?oo
o`005@3oool00`00001000000?ooo`0j0?ooo`030000003oool0oooo0</0oooo000E0?ooo`030000
003oool0oooo03L0oooo0`3o0?l00`000000oooo0?ooo`3;0?ooo`00203oool5@0000080oooo00=0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0g0?ooo`80o`3o00<000000?l0o`3oool0c03o
ool000X0oooo00M000000?ooo`3oool0oooo@000003ooom0000000@0oooo00<000000?ooo`3oool0
=`3oool20?l0o`030000003o0?l0oooo0<`0oooo000:0?ooo`03@000003oool0oooo00<0oooo00=0
00000?ooo`3oool00P3oool200000003@000003oool0oooo03H0oooo00<000000?l0o`3oool0c@3o
ool000X0oooo00A000000?ooo`3oool0oooo0T0000050?ooo`030000003oool0oooo03P0oooo00<0
00000?ooo`3oool0c@3oool000X0oooo00E000000?ooo`3oool0oooo@00000060?ooo`030000003o
ool0oooo03L0oooo00<000000?ooo`3oool0cP3oool000T0oooo0T0000030?ooo`=00000103oool0
0`000000oooo0?ooo`0g0?ooo`030000003oool0oooo0<h0oooo000E0?ooo`03000004000000oooo
03H0oooo00<000000?ooo`3oool0c`3oool001D0oooo00<000000?ooo`3oool0<P3oool30?l0o`03
0000003oool0oooo0=00oooo000E0?ooo`030000003oool0oooo0380oooo0`3o0?l00`000000oooo
0?ooo`3@0?ooo`005@3oool00`000000oooo0?ooo`0b0?ooo`80o`3o00<000000?l0o`3oool0d@3o
ool001D0oooo00<00000@000003oool0<`3oool00`3o0?l000000?ooo`3B0?ooo`005@3oool00`00
0000oooo0?ooo`0c0?ooo`030000003oool0oooo0=80oooo000E0?ooo`030000003oool0oooo0380
oooo00<000000?ooo`3oool0d`3oool001D0oooo00<000000?ooo`3oool0<P3oool00`000000oooo
0?ooo`3C0?ooo`005@3oool00`00001000000?ooo`0a0?ooo`030000003oool0oooo0=@0oooo000E
0?ooo`030000003oool0oooo02h0oooo0P3o0?l00`000000o`3o0?ooo`3E0?ooo`005@3oool00`00
0000oooo0?ooo`0^0?ooo`80o`3o00<000000?l0o`3oool0e@3oool001D0oooo00<000000?ooo`3o
ool0;P3oool0103o0?l000000?l0o`3o0?oF0?ooo`005@3oool00`00001000000?ooo`0_0?ooo`03
0000003o0?l0oooo0=H0oooo000E0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0
e`3oool000T0oooo0d0000030?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0;@3o
ool00`000000oooo0?ooo`3H0?ooo`002@3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0
000000@0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`3H0?ooo`002P3oool01d00
0000oooo0?ooo`3ooom000000?oood000000103oool200000003@000003oool0oooo02L0oooo0`3o
0?l00`000000oooo0?ooo`3I0?ooo`002P3oool01d000000oooo0?ooo`3ooom000000?oood000000
103oool00`000000oooo0?ooo`0Y0?ooo`<0o`3o00<000000?ooo`3oool0f@3oool000T0oooo00=0
00000?oood0000000P3oool00d000000oooo@00000040?ooo`030000003oool0oooo02T0oooo0P3o
0?l00`000000o`3o0?ooo`3J0?ooo`002P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0
oooo00<0oooo00<000000?ooo`3oool0:P3oool00`000000o`3o0?ooo`3K0?ooo`005@3oool00`00
001000000?ooo`0Z0?ooo`030000003oool0oooo0=/0oooo000E0?ooo`030000003oool0oooo02T0
oooo00<000000?ooo`3oool0g03oool001D0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`3M0?ooo`005@3oool00`000000oooo0?ooo`0U0?ooo`<0o`3o00<000000?ooo`3oool0g@3o
ool001D0oooo00<00000@000003oool09@3oool20?l0o`030000003o0?l0oooo0=h0oooo000E0?oo
o`030000003oool0oooo02D0oooo0P3o0?l00`000000o`3o0?ooo`3N0?ooo`005@3oool00`000000
oooo0?ooo`0V0?ooo`030000003o0?l0oooo0=l0oooo000E0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool0h03oool001D0oooo00<00000@000003oool09@3oool00`000000oooo0?oo
o`3P0?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0>40oooo000E0?oo
o`030000003oool0oooo0240oooo0`3o0?l00`000000oooo0?ooo`3Q0?ooo`005@3oool00`000000
oooo0?ooo`0Q0?ooo`80o`3o00<000000?l0o`3oool0hP3oool001D0oooo00<00000@000003oool0
8@3oool20?l0o`030000003o0?l0oooo0>80oooo000E0?ooo`030000003oool0oooo0280oooo00<0
00000?l0o`3oool0h`3oool000T0oooo0d0000030?ooo`03@000003oool0oooo00<0oooo00<00000
0?ooo`3oool08P3oool00`000000oooo0?ooo`3S0?ooo`002@3oool00d000000oooo0?ooo`020?oo
o`03@000003ooom0000000@0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`3T0?oo
o`002P3oool00d000000oooo0?ooo`030?ooo`03@000003oool0oooo0080oooo0P0000000d000000
oooo0?ooo`0K0?ooo`<0o`3o00<000000?ooo`3oool0i@3oool000X0oooo00A000000?ooo`3oool0
oooo0T0000050?ooo`030000003oool0oooo01d0oooo0`3o0?l00`000000oooo0?ooo`3U0?ooo`00
2@3oool00d000000oooo@00000020?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0
7@3oool20?l0o`030000003o0?l0oooo0>H0oooo000:0?ooo`04@000003oool0oooo0?ooo`=00000
103oool00`000000oooo0?ooo`0N0?ooo`030?l0o`000000oooo0>L0oooo000E0?ooo`0300000400
0000oooo01h0oooo00<000000?ooo`3oool0i`3oool001D0oooo00<000000?ooo`3oool07P3oool0
0`000000oooo0?ooo`3W0?ooo`005@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo
0>P0oooo000E0?ooo`030000003oool0oooo01X0oooo0P3o0?l00`000000o`3o0?ooo`3Y0?ooo`00
5@3oool00`00001000000?ooo`0J0?ooo`80o`3o00<000000?l0o`3oool0j@3oool001D0oooo00<0
00000?ooo`3oool06P3oool0103o0?l000000?l0o`3o0?oZ0?ooo`005@3oool00`000000oooo0?oo
o`0K0?ooo`030000003o0?l0oooo0>X0oooo000E0?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool0j`3oool001D0oooo00<00000@000003oool06P3oool00`000000oooo0?ooo`3[0?oo
o`005@3oool00`000000oooo0?ooo`0F0?ooo`<0o`3o00<000000?ooo`3oool0k03oool001D0oooo
00<000000?ooo`3oool05P3oool30?l0o`030000003oool0oooo0>`0oooo000E0?ooo`030000003o
ool0oooo01H0oooo0P3o0?l00`000000o`3o0?ooo`3]0?ooo`005@3oool00`00001000000?ooo`0G
0?ooo`030000003o0?l0oooo0>h0oooo000E0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool0kP3oool000T0oooo0T0000040?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3o
ool04`3oool30?l0o`030000003oool0oooo0>l0oooo000;0?ooo`06@000003oool0oooo@000003o
oom00000103oool00`000000oooo0?ooo`0C0?ooo`<0o`3o00<000000?ooo`3oool0k`3oool000X0
oooo00M000000?ooo`3oool0oooo@000003ooom0000000@0oooo0P0000000d000000oooo0?ooo`0A
0?ooo`80o`3o00<000000?l0o`3oool0l03oool000/0oooo00I000000?ooo`3ooom000000?oood00
00040?ooo`030000003oool0oooo01@0oooo00<000000?l0o`3oool0l@3oool000T0oooo00=00000
0?oood0000000P3oool00d000000oooo@00000040?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool0l@3oool000X0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`030?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool0lP3oool001D0oooo00<00000@000003o
ool0403oool30?l0o`030000003oool0oooo0?80oooo000E0?ooo`030000003oool0oooo0100oooo
0P3o0?l00`000000o`3o0?ooo`3c0?ooo`005@3oool00`000000oooo0?ooo`0@0?ooo`040?l0o`00
0000o`3o0?l0oo@0oooo000E0?ooo`030000003oool0oooo0140oooo00<000000?l0o`3oool0m03o
ool001D0oooo00<00000@000003oool0403oool00`000000oooo0?ooo`3e0?ooo`005@3oool00`00
0000oooo0?ooo`0=0?ooo`<0o`3o00<000000?ooo`3oool0m@3oool001D0oooo00<000000?ooo`3o
ool03@3oool20?l0o`030000003o0?l0oooo0?H0oooo000E0?ooo`030000003oool0oooo00d0oooo
00@0o`3o0000003o0?l0o`3om`3oool001D0oooo00<00000@000003oool03P3oool00`000000o`3o
0?ooo`3g0?ooo`005@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0?P0oooo000E
0?ooo`030000003oool0oooo00X0oooo0`3o0?l00`000000oooo0?ooo`3h0?ooo`005@3oool00`00
0000oooo0?ooo`0:0?ooo`80o`3o00<000000?l0o`3oool0n@3oool001D0oooo00<00000@000003o
ool02P3oool0103o0?l000000?l0o`3o0?oj0?ooo`005@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003o0?l0oooo0?X0oooo00090?ooo`900000103oool00d000000oooo0?ooo`030?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0n`3oool000/0oooo00I000000?ooo`3ooom00000
0?oood0000040?ooo`030000003oool0oooo00L0oooo0`3o0?l00`000000oooo0?ooo`3k0?ooo`00
2P3oool00d000000oooo0?ooo`030?ooo`03@000003oool0oooo0080oooo0P0000000d000000oooo
0?ooo`050?ooo`80o`3o00<000000?l0o`3oool0o03oool000/0oooo00=000000?ooo`3oool00T00
00050?ooo`030000003oool0oooo00L0oooo00@0o`3o0000003o0?l0o`3oo@3oool000T0oooo00=0
00000?oood0000000P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo00P0oooo00<0
00000?l0o`3oool0o@3oool000X0oooo00A000000?ooo`3oool0oooo0d0000040?ooo`030000003o
ool0oooo00@0oooo0`3o0?l00`000000oooo0?ooo`3n0?ooo`005@3oool00`00001000000?ooo`04
0?ooo`<0o`3o00<000000?ooo`3oool0oP3oool001D0oooo00<000000?ooo`3oool0103oool20?l0
o`030000003o0?l0oooo0?l0oooo000E0?ooo`030000003oool0oooo00D0oooo00<000000?l0o`3o
ool0o`3oool10?ooo`005@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo
0@3oool001D0oooo00<00000@000003oool0103oool00`000000oooo0?ooo`3o0?ooo`80oooo000E
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3oool20?ooo`005@3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo0`3oool001D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`3o0?ooo`@0oooo000E0?ooo`03000004000000oooo0080oooo
00<000000?ooo`3oool0o`3oool40?ooo`005@3oool01@000000oooo0?ooo`3oool000000?l0oooo
1`3oool001D0oooo00D000000?ooo`3oool0oooo0000003o0?ooo`L0oooo000E0?ooo`040000003o
ool0oooo00000?l0oooo203oool001D0oooo00<00000@00000000000o`3oool90?ooo`005@3oool0
0`000000oooo0000003o0?ooo`T0oooo000:0?ooo`=000000P3oool00d000000oooo0?ooo`030?oo
o`800000o`3oool:0?ooo`002`3oool01T000000oooo0?oood000000oooo@00000@0oooo0P00003o
0?ooo`X0oooo00090?ooo`A0000000@0oooo@000003ooom00000103oool200000003@000003oool0
oooo0?l0oooo1`3oool000T0oooo00=000000?oood0000000P3oool00d000000oooo@000003o0?oo
oa00oooo000:0?ooo`9000000P3oool00d000000oooo@000003o0?oooa00oooo000;0?ooo`05@000
003oool0oooo0?oood000000o`3ooolA0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {10.8682, -3.05647, 0.424376, 
  0.249694}}],

Cell[OutputFormData["\<\
Graphics[{{PointSize[0.02], RGBColor[1, 0, 1], 
    {Point[{23.99999999999999, 36.}], 
     Point[{25.12512563944476, 34.87487436055521}], 
     Point[{26.30299743324521, 33.69700256675479}], 
     Point[{27.53608813351164, 32.46391186648835}], 
     Point[{28.82698641555434, 31.17301358444565}], 
     Point[{30.17840231239044, 29.82159768760956}], 
     Point[{31.5931729040217, 28.40682709597831}], 
     Point[{33.07426827342697, 26.92573172657302}], 
     Point[{34.62479774177312, 25.37520225822688}], 
     Point[{36.24801639593388, 23.7519836040661}], 
     Point[{37.94733192202054, 22.05266807797945}], 
     Point[{39.72631175926998, 20.27368824073001}], 
     Point[{41.58869058930878, 18.41130941069122}], 
     Point[{43.53837817651573, 16.46162182348426}], 
     Point[{45.57946757594242, 14.47855136959231}], 
     Point[{47.71624372602303, 12.5558635767166}], 
     Point[{49.95319244411239, 10.71870213710807}], 
     Point[{52.29500984373696, 8.993824853180338}], 
     Point[{54.74661219332885, 7.406620840935406}], 
     Point[{57.31314623713943, 5.978280401639701}], 
     Point[{60, 4.723473577112416}], 
     Point[{62.81281409861192, 3.648922510709264}], 
     Point[{65.75749358311303, 2.752980849968868}], 
     Point[{68.84022033377911, 2.02632282092897}], 
     Point[{72.06746603888587, 1.453450222826738}], 
     Point[{75.44600578097612, 1.014712811826387}], 
     Point[{78.98293226005423, 0.6885093744575959}], 
     Point[{82.68567068356743, 0.4532021410360325}], 
     Point[{86.5619943544328, 0.2886761555892622}], 
     Point[{90.62004098983473, 0.1773214806010606}], 
     Point[{94.86832980505138, 0.1045195017863063}], 
     Point[{99.31577939817497, 0.05867788035161032}], 
     Point[{103.9717264732719, 0.03100196538340132}], 
     Point[{108.8459454412893, 0.01512387761495199}], 
     Point[{113.948668939856, 0.006588258528920427}], 
     Point[{119.2906093150576, 0.002346245890632619}], 
     Point[{124.8829811102809, 0.0005030201704427708}], 
     Point[{130.7375246093424, 0}], 
     Point[{136.8665304833221, 0}], 
     Point[{143.2828655928486, 0}], Point[{150., 0}]}}, 
   {{Line[{{6.25*^-6, 59.99999374999999}, 
       {6.085048735937368, 53.91495126406263}, 
       {12.72131997890605, 47.27868002109394}, 
       {18.95390495078078, 41.04609504921921}, 
       {24.9477611656242, 35.05223883437578}, 
       {31.32788862343631, 28.67211137656368}, 
       {37.4692873242171, 22.53071267578289}, 
       {43.99695726796657, 16.00304273203342}, 
       {50.28589845468474, 9.714101545315259}, 
       {56.33611088437158, 3.663889115628414}, 
       {57.94924211153555, 2.050757888464453}, 
       {59.46044568948869, 0.5395543105112992}, 
       {59.64656397911945, 0.3534360208805438}, 
       {59.84972060204948, 0.1502793979505128}, 
       {60.04161198567113, 0.}, {60.21976285335933, 0.}, 
       {60.64630977043291, 0.}, {61.03656831524167, 0.}, 
       {62.77259455702711, 0.}, {68.93551941640079, 0.}, 
       {75.48471551874316, 0.}, {81.79518286405421, 0.}, 
       {87.86692145233395, 0.}, {94.32493128358236, 0.}, 
       {100.5442123577994, 0.}, {106.5247646749852, 0.}, 
       {112.8915882351397, 0.}, {119.0196830382629, 0.}, 
       {125.5340490843547, 0.}, {131.8096863734153, 0.}, 
       {137.8465949054445, 0.}, {144.2697746804423, 0.}, 
       {149.9999937499999, 0.}}]}}}, 
  {DisplayFunction -> (Display[$Display, #1] & ), 
   PlotRange -> {{20, 130}, {0, 40}}, PlotRange -> Automatic, 
   AspectRatio -> GoldenRatio^(-1), 
   DisplayFunction :> Identity, ColorOutput -> Automatic, 
   Axes -> Automatic, AxesOrigin -> Automatic, 
   PlotLabel -> None, AxesLabel -> None, Ticks -> Automatic, 
   GridLines -> None, Prolog -> {}, Epilog -> {}, 
   AxesStyle -> Automatic, Background -> Automatic, 
   DefaultColor -> Automatic, DefaultFont :> $DefaultFont, 
   RotateLabel -> True, Frame -> False, 
   FrameStyle -> Automatic, FrameTicks -> Automatic, 
   FrameLabel -> None, PlotRegion -> Automatic, 
   ImageSize -> Automatic, TextStyle :> $TextStyle, 
   FormatType :> $FormatType}]\
\>", "\<\
-Graphics-\
\>"], "Output"]
}, Open  ]],

Cell["\<\
\"OBR.9
Probl\[EAcute]m prek\[AAcute]\.9eky\"\
\>", "Text"],

Cell[CellGroupData[{

Cell["\<\
A:=-3;
B:=4;
alfa:=N[A + Sqrt[A^2 - 1]];
bt:=N[B - Sqrt[B^2 - 1]];
g[x_]:= Max[1 - x^2,0];
u1[x_]:=(x-A)g[alfa]/(alfa - A);
u2[x_]:=g[x];
u3[x_]:=(x-B)g[bt]/(bt-B);

g0:=Plot[g[x],{x,A,B},PlotStyle -> 
{Thickness[0.012],RGBColor[0,0,0]},PlotRange->{{-3.2,3.2},{-0.5,2}},\
DisplayFunction->Identity];

g1=Plot[u1[x],{x,A,alfa},PlotRange->All,PlotStyle -> 
{Thickness[0.004],RGBColor[0.,0.,0]}, DisplayFunction->Identity];
g2=Plot[u2[x],{x,alfa,bt},PlotRange->All,PlotStyle -> 
{Thickness[0.004],RGBColor[0.,0.,0]}, DisplayFunction->Identity];
g3=Plot[u3[x],{x,bt,B},PlotRange->All,PlotStyle -> 
{Thickness[0.004],RGBColor[0.,0.,0]}, DisplayFunction->Identity];

Show[g0,g1,g2,g3,DisplayFunction->$DisplayFunction,PlotRange->All]

\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.431973 0.136054 0.0147151 0.588604 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.15986 .00222 -6 -9 ]
[.15986 .00222 6 0 ]
[.29592 .00222 -6 -9 ]
[.29592 .00222 6 0 ]
[.56803 .00222 -3 -9 ]
[.56803 .00222 3 0 ]
[.70408 .00222 -3 -9 ]
[.70408 .00222 3 0 ]
[.84014 .00222 -3 -9 ]
[.84014 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.41947 .13244 -18 -4.5 ]
[.41947 .13244 0 4.5 ]
[.41947 .25016 -18 -4.5 ]
[.41947 .25016 0 4.5 ]
[.41947 .36788 -18 -4.5 ]
[.41947 .36788 0 4.5 ]
[.41947 .4856 -18 -4.5 ]
[.41947 .4856 0 4.5 ]
[.41947 .60332 -6 -4.5 ]
[.41947 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .01472 m
.02381 .02097 L
s
[(-3)] .02381 .00222 0 1 Mshowa
.15986 .01472 m
.15986 .02097 L
s
[(-2)] .15986 .00222 0 1 Mshowa
.29592 .01472 m
.29592 .02097 L
s
[(-1)] .29592 .00222 0 1 Mshowa
.56803 .01472 m
.56803 .02097 L
s
[(1)] .56803 .00222 0 1 Mshowa
.70408 .01472 m
.70408 .02097 L
s
[(2)] .70408 .00222 0 1 Mshowa
.84014 .01472 m
.84014 .02097 L
s
[(3)] .84014 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(4)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05102 .01472 m
.05102 .01847 L
s
.07823 .01472 m
.07823 .01847 L
s
.10544 .01472 m
.10544 .01847 L
s
.13265 .01472 m
.13265 .01847 L
s
.18707 .01472 m
.18707 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.2415 .01472 m
.2415 .01847 L
s
.26871 .01472 m
.26871 .01847 L
s
.32313 .01472 m
.32313 .01847 L
s
.35034 .01472 m
.35034 .01847 L
s
.37755 .01472 m
.37755 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45918 .01472 m
.45918 .01847 L
s
.48639 .01472 m
.48639 .01847 L
s
.51361 .01472 m
.51361 .01847 L
s
.54082 .01472 m
.54082 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62245 .01472 m
.62245 .01847 L
s
.64966 .01472 m
.64966 .01847 L
s
.67687 .01472 m
.67687 .01847 L
s
.73129 .01472 m
.73129 .01847 L
s
.7585 .01472 m
.7585 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.81293 .01472 m
.81293 .01847 L
s
.86735 .01472 m
.86735 .01847 L
s
.89456 .01472 m
.89456 .01847 L
s
.92177 .01472 m
.92177 .01847 L
s
.94898 .01472 m
.94898 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.43197 .13244 m
.43822 .13244 L
s
[(0.2)] .41947 .13244 1 0 Mshowa
.43197 .25016 m
.43822 .25016 L
s
[(0.4)] .41947 .25016 1 0 Mshowa
.43197 .36788 m
.43822 .36788 L
s
[(0.6)] .41947 .36788 1 0 Mshowa
.43197 .4856 m
.43822 .4856 L
s
[(0.8)] .41947 .4856 1 0 Mshowa
.43197 .60332 m
.43822 .60332 L
s
[(1)] .41947 .60332 1 0 Mshowa
.125 Mabswid
.43197 .04415 m
.43572 .04415 L
s
.43197 .07358 m
.43572 .07358 L
s
.43197 .10301 m
.43572 .10301 L
s
.43197 .16187 m
.43572 .16187 L
s
.43197 .1913 m
.43572 .1913 L
s
.43197 .22073 m
.43572 .22073 L
s
.43197 .27959 m
.43572 .27959 L
s
.43197 .30902 m
.43572 .30902 L
s
.43197 .33845 m
.43572 .33845 L
s
.43197 .39731 m
.43572 .39731 L
s
.43197 .42674 m
.43572 .42674 L
s
.43197 .45617 m
.43572 .45617 L
s
.43197 .51503 m
.43572 .51503 L
s
.43197 .54446 m
.43572 .54446 L
s
.43197 .57389 m
.43572 .57389 L
s
.25 Mabswid
.43197 0 m
.43197 .61803 L
s
0 0 0 r
.012 w
.02381 .01472 m
.06244 .01472 L
.10458 .01472 L
.14415 .01472 L
.18221 .01472 L
.22272 .01472 L
.26171 .01472 L
.27193 .01472 L
.28302 .01472 L
.2881 .01472 L
.29088 .01472 L
.29349 .01472 L
.29462 .01472 L
.2957 .01472 L
.29695 .0236 L
.29809 .03334 L
.30316 .07567 L
.34135 .34217 L
.36102 .44324 L
.38199 .52389 L
.39228 .55322 L
.39769 .56595 L
.40341 .57737 L
.40841 .58567 L
.41391 .59294 L
.41632 .59553 L
.41891 .59789 L
.42113 .59958 L
.42358 .60108 L
.42614 .60224 L
.42754 .60269 L
.42886 .60301 L
.43009 .60321 L
.43121 .6033 L
.43245 .60331 L
.43375 .60322 L
.43444 .60312 L
.43507 .60301 L
.43649 .60267 L
.4378 .60224 L
.43903 .60173 L
.44181 .60024 L
.44482 .59807 L
.4499 .5931 L
.45528 .58604 L
.46494 .56877 L
.47437 .54615 L
.48451 .51555 L
.50282 .4437 L
.524 .33403 L
Mistroke
.5441 .20353 L
.55444 .12639 L
.55951 .08608 L
.56417 .0476 L
.56637 .02895 L
.56745 .01974 L
.56842 .01472 L
.56946 .01472 L
.57056 .01472 L
.57291 .01472 L
.58235 .01472 L
.60206 .01472 L
.62304 .01472 L
.66294 .01472 L
.70132 .01472 L
.74216 .01472 L
.78148 .01472 L
.81928 .01472 L
.85953 .01472 L
.89827 .01472 L
.93947 .01472 L
.97619 .01472 L
Mfstroke
.004 w
.02381 .01472 m
.03942 .03789 L
.05645 .06316 L
.07244 .0869 L
.08781 .10973 L
.10418 .13403 L
.11994 .15742 L
.13668 .18228 L
.15282 .20623 L
.16834 .22927 L
.18485 .25379 L
.20075 .27739 L
.21604 .30008 L
.23232 .32425 L
.24798 .34751 L
.26464 .37224 L
.28069 .39605 L
.29612 .41896 L
.31254 .44335 L
.32835 .46682 L
.34515 .49176 L
.36134 .51579 L
.37692 .53892 L
.39349 .56351 L
.40863 .58599 L
s
.40863 .58599 m
.41028 .58835 L
.41207 .59073 L
.41376 .59277 L
.41539 .59457 L
.41711 .5963 L
.41878 .59778 L
.42055 .59917 L
.42225 .60031 L
.42389 .60124 L
.42563 .60204 L
.4265 .60237 L
.42731 .60263 L
.42814 .60285 L
.42892 .60302 L
.42934 .6031 L
.42979 .60317 L
.43019 .60322 L
.43058 .60326 L
.43079 .60327 L
.43102 .60329 L
.43121 .6033 L
.43142 .60331 L
.43153 .60331 L
.43164 .60332 L
.4317 .60332 L
.43176 .60332 L
.43179 .60332 L
.43182 .60332 L
.43185 .60332 L
.43188 .60332 L
.43193 .60332 L
.43196 .60332 L
.43199 .60332 L
.43202 .60332 L
.43205 .60332 L
.4321 .60332 L
.43216 .60332 L
.4322 .60332 L
.43231 .60332 L
.43242 .60331 L
.43253 .60331 L
.43276 .6033 L
.43296 .60329 L
.43318 .60327 L
.43356 .60324 L
.43398 .60319 L
.43481 .60306 L
.4357 .60288 L
.43746 .60236 L
Mistroke
.43915 .60168 L
.44078 .60085 L
.44252 .59978 L
.44419 .59857 L
.44597 .59709 L
.44768 .59547 L
.44925 .59382 L
Mfstroke
.44925 .59382 m
.47063 .57033 L
.49394 .54471 L
.51584 .52065 L
.53689 .49751 L
.55931 .47287 L
.58088 .44916 L
.60381 .42396 L
.6259 .39968 L
.64716 .37632 L
.66977 .35148 L
.69154 .32755 L
.71247 .30454 L
.73476 .28004 L
.75622 .25647 L
.77903 .2314 L
.801 .20726 L
.82213 .18403 L
.84462 .15932 L
.86627 .13552 L
.88927 .11024 L
.91144 .08588 L
.93277 .06244 L
.95546 .0375 L
.97619 .01472 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`003`3oool2@00002<0oooo0d00000Q0?ooo`E00000@P3oool5@0000240oooo0d00000R0?oo
o`900000903oool3@00000d0oooo000A0?ooo`03@000003oool0oooo0200oooo00=000000?ooo`3o
ool08`3oool00d000000oooo0?ooo`140?ooo`03@000003oool0oooo0240oooo00=000000?ooo`3o
ool0903oool00d000000oooo0?ooo`0R0?ooo`03@000003oool0oooo00`0oooo000:0?ooo`=00000
0`3oool00d000000oooo0?ooo`0L0?ooo`=000000`3oool00d000000oooo0?ooo`0L0?ooo`=00000
0`3oool00d000000oooo0?ooo`140?ooo`03@000003oool0oooo0280oooo00=000000?ooo`3oool0
8P3oool00d000000oooo0?ooo`0Q0?ooo`A000003@3oool00140oooo00=000000?ooo`3oool08@3o
ool00d000000oooo0?ooo`0R0?ooo`03@000003oool0oooo04@0oooo00=000000?ooo`3oool08P3o
ool00d000000oooo0?ooo`0S0?ooo`03@000003oool0oooo0200oooo00=000000?oood0000003P3o
ool000l0oooo00=000000?oood0000008P3oool00d000000oooo@000000S0?ooo`03@000003oool0
oooo04@0oooo00=000000?ooo`3oool08@3oool00d000000oooo@000000R0?ooo`03@000003ooom0
000002<0oooo0T00000>0?ooo`00403oool00d000000oooo0?ooo`0R0?ooo`03@000003oool0oooo
0240oooo0T0000150?ooo`900000903oool00d000000oooo0?ooo`0R0?ooo`03@000003oool0oooo
02<0oooo00=000000?ooo`3oool0303oool00?l0oooo8@3oool007d0oooo00<000000?ooo`3oool0
X03oool007d0oooo00<000000?ooo`3oool0X03oool007d0oooo00<000000?ooo`3oool0X03oool0
00d0ooooC000000T0?ooo`030000003oool0oooo0240ooooL@00000>0?ooo`001`3ooooo000000X0
000000=00000000000000000100000000d000000oooo0?ooo`060?ooo`003@3ooom=000000D0oooo
00=000000?ooo`3oool0103oool00d000000oooo0?ooo`050?ooo`03@000003oool0oooo00@0oooo
00=000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`03@000003oool0oooo00@0oooo
00=000000?ooo`3oool01@3oool00d000000oooo0?ooo`040?ooo`03@000003oool0oooo0080oooo
L`00000>0?ooo`003P3oool00d00000000000?ooo`0R0?ooo`03@000003oool0oooo0200oooo1000
000S0?ooo`030000003oool0oooo0200oooo0`00000S0?ooo`03@000003oool0oooo0280oooo00=0
00000?ooo`3oool0803oool00`000000oooo@000000?0?ooo`00403oool00`000000oooo0?ooo`14
0?ooo`<000008`3oool00`000000oooo0?ooo`0P0?ooo`<00000JP3oool00`000000oooo0?ooo`0@
0?ooo`004@3oool00`000000oooo0?ooo`120?ooo`@000008`3oool00`000000oooo0?ooo`0P0?oo
o`<00000JP3oool00`000000oooo0?ooo`0@0?ooo`004@3oool00`000000oooo0?ooo`120?ooo`@0
00008`3oool00`000000oooo0?ooo`0O0?ooo`@00000J@3oool00`000000oooo0?ooo`0A0?ooo`00
4P3oool00`000000oooo0?ooo`110?ooo`@000008`3oool00`000000oooo0?ooo`0O0?ooo`<00000
J@3oool00`000000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo0?ooo`110?ooo`<000008`3o
ool00`000000oooo0?ooo`0O0?ooo`<00000J03oool00`000000oooo0?ooo`0C0?ooo`004`3oool0
0`000000oooo0?ooo`110?ooo`<000008`3oool00`00001000000?ooo`0O0?ooo`<00000I`3oool0
0`000000oooo0?ooo`0D0?ooo`00503oool00`000000oooo0?ooo`100?ooo`<000008`3oool00`00
0000oooo0?ooo`0N0?ooo`@00000IP3oool00`000000oooo0?ooo`0E0?ooo`00503oool00`000000
oooo0?ooo`100?ooo`<000008`3oool00`000000oooo0?ooo`0N0?ooo`@00000IP3oool00`000000
oooo0?ooo`0E0?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`<000008`3oool00`000000oooo
0?ooo`0N0?ooo`<00000IP3oool00`000000oooo0?ooo`0F0?ooo`005@3oool00`000000oooo0?oo
o`0o0?ooo`<000008`3oool00`000000oooo0?ooo`0N0?ooo`<00000I@3oool00`000000oooo0?oo
o`0G0?ooo`005P3oool00`000000oooo0?ooo`0n0?ooo`<000008`3oool00`000000oooo0?ooo`0N
0?ooo`<00000I03oool00`000000oooo0?ooo`0H0?ooo`005`3oool00`000000oooo0?ooo`0m0?oo
o`<000008`3oool00`000000oooo0?ooo`0N0?ooo`<00000H`3oool00`000000oooo0?ooo`0I0?oo
o`005`3oool00`000000oooo0?ooo`0n0?ooo`<000008P3oool00`000000oooo0?ooo`0N0?ooo`<0
0000HP3oool00`000000oooo0?ooo`0J0?ooo`00603oool00`000000oooo0?ooo`0l0?ooo`@00000
8P3oool00`00001000000?ooo`0N0?ooo`<00000H@3oool00`000000oooo0?ooo`0K0?ooo`006@3o
ool00`000000oooo0?ooo`0k0?ooo`@000008P3oool00`000000oooo0?ooo`0M0?ooo`<00000H@3o
ool00`000000oooo0?ooo`0L0?ooo`006P3oool00`000000oooo0?ooo`0j0?ooo`@000008P3oool0
0`000000oooo0?ooo`0M0?ooo`@00000G`3oool00`000000oooo0?ooo`0M0?ooo`006P3oool00`00
0000oooo0?ooo`0k0?ooo`<000008P3oool00`000000oooo0?ooo`0M0?ooo`@00000GP3oool00`00
0000oooo0?ooo`0N0?ooo`006`3oool00`000000oooo0?ooo`0j0?ooo`<000008P3oool00`000000
oooo0?ooo`0M0?ooo`@00000G@3oool00`000000oooo0?ooo`0O0?ooo`00703oool00`000000oooo
0?ooo`0i0?ooo`<000008P3oool00`000000oooo0?ooo`0M0?ooo`<00000G@3oool00`000000oooo
0?ooo`0P0?ooo`00703oool00`000000oooo0?ooo`0i0?ooo`<000008P3oool00`000000oooo0?oo
o`0M0?ooo`<00000G03oool00`000000oooo0?ooo`0Q0?ooo`007@3oool00`000000oooo0?ooo`0h
0?ooo`<000008P3oool00`000000oooo0?ooo`0M0?ooo`<00000G03oool00`000000oooo0?ooo`0Q
0?ooo`007P3oool00`000000oooo0?ooo`0g0?ooo`<000008P3oool00`00001000000?ooo`0M0?oo
o`<00000F`3oool00`000000oooo0?ooo`0R0?ooo`007P3oool00`000000oooo0?ooo`0h0?ooo`<0
00008@3oool00`000000oooo0?ooo`0M0?ooo`<00000FP3oool00`000000oooo0?ooo`0S0?ooo`00
7`3oool00`000000oooo0?ooo`0g0?ooo`<000008@3oool00`000000oooo0?ooo`0M0?ooo`<00000
F@3oool00`000000oooo0?ooo`0T0?ooo`00803oool00`000000oooo0?ooo`0f0?ooo`<000008@3o
ool00`000000oooo0?ooo`0M0?ooo`<00000F03oool00`000000oooo0?ooo`0U0?ooo`00803oool0
0`000000oooo0?ooo`0f0?ooo`<000008@3oool00`000000oooo0?ooo`0L0?ooo`<00000F03oool0
0`000000oooo0?ooo`0V0?ooo`008@3oool00`000000oooo0?ooo`0e0?ooo`<000008@3oool00`00
0000oooo0?ooo`0L0?ooo`@00000EP3oool00`000000oooo0?ooo`0W0?ooo`008P3oool00`000000
oooo0?ooo`0d0?ooo`<00000403oool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo0?oo
o`=000001@3oool00`000000oooo0?ooo`0L0?ooo`@00000EP3oool00`000000oooo0?ooo`0W0?oo
o`008P3oool00`000000oooo0?ooo`0e0?ooo`<000003P3oool00d000000oooo@00000070?ooo`03
@000003oool0oooo00D0oooo00<000000?ooo`3oool0703oool4000005D0oooo00<000000?ooo`3o
ool0:03oool002<0oooo00<000000?ooo`3oool0=03oool3000000h0oooo00=000000?oood000000
203oool00d000000oooo0?ooo`040?ooo`03000004000000oooo01`0oooo0`00001E0?ooo`030000
003oool0oooo02T0oooo000T0?ooo`030000003oool0oooo03<0oooo0`00000>0?ooo`03@000003o
oom0000000P0oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`0L0?ooo`<00000E03o
ool00`000000oooo0?ooo`0Z0?ooo`00903oool00`000000oooo0?ooo`0c0?ooo`<000003P3oool0
0d000000oooo@00000070?ooo`03@000003ooom0000000D0oooo00<000000?ooo`3oool0703oool3
000005<0oooo00<000000?ooo`3oool0:`3oool002D0oooo00<000000?ooo`3oool0<P3oool30000
00l0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo
01`0oooo0`00001B0?ooo`030000003oool0oooo02`0oooo000V0?ooo`030000003oool0oooo0340
oooo0`00000P0?ooo`030000003oool0oooo01`0oooo0`00001A0?ooo`030000003oool0oooo02d0
oooo000W0?ooo`030000003oool0oooo0340oooo0`00000O0?ooo`030000003oool0oooo01`0oooo
0`00001@0?ooo`030000003oool0oooo02h0oooo000W0?ooo`030000003oool0oooo0340oooo0`00
000O0?ooo`030000003oool0oooo01/0oooo0`00001@0?ooo`030000003oool0oooo02l0oooo000X
0?ooo`030000003oool0oooo0300oooo0`00000O0?ooo`030000003oool0oooo01/0oooo0`00001?
0?ooo`030000003oool0oooo0300oooo000Y0?ooo`030000003oool0oooo02l0oooo0`00000O0?oo
o`03000004000000oooo01/0oooo0`00001>0?ooo`030000003oool0oooo0340oooo000Y0?ooo`03
0000003oool0oooo02l0oooo0`00000O0?ooo`030000003oool0oooo01/0oooo0`00001=0?ooo`03
0000003oool0oooo0380oooo000Z0?ooo`030000003oool0oooo02h0oooo0`00000O0?ooo`030000
003oool0oooo01/0oooo0`00001<0?ooo`030000003oool0oooo03<0oooo000Z0?ooo`030000003o
ool0oooo02h0oooo0`00000O0?ooo`030000003oool0oooo01/0oooo0`00001<0?ooo`030000003o
ool0oooo03<0oooo000[0?ooo`030000003oool0oooo02h0oooo0`00000N0?ooo`030000003oool0
oooo01X0oooo0`00001<0?ooo`030000003oool0oooo03@0oooo000[0?ooo`030000003oool0oooo
02h0oooo0`00000N0?ooo`030000003oool0oooo01X0oooo0`00001;0?ooo`030000003oool0oooo
03D0oooo000/0?ooo`030000003oool0oooo02d0oooo0`00000N0?ooo`030000003oool0oooo01X0
oooo0`00001:0?ooo`030000003oool0oooo03H0oooo000]0?ooo`030000003oool0oooo02`0oooo
0`00000N0?ooo`030000003oool0oooo01X0oooo0`0000190?ooo`030000003oool0oooo03L0oooo
000^0?ooo`030000003oool0oooo02/0oooo0`00000N0?ooo`03000004000000oooo01X0oooo0`00
00180?ooo`030000003oool0oooo03P0oooo000_0?ooo`030000003oool0oooo02X0oooo0`00000N
0?ooo`030000003oool0oooo01X0oooo0`0000170?ooo`030000003oool0oooo03T0oooo000_0?oo
o`030000003oool0oooo02/0oooo0`00000M0?ooo`030000003oool0oooo01T0oooo100000160?oo
o`030000003oool0oooo03X0oooo000`0?ooo`030000003oool0oooo02X0oooo0`00000M0?ooo`03
0000003oool0oooo01T0oooo100000150?ooo`030000003oool0oooo03/0oooo000a0?ooo`030000
003oool0oooo02T0oooo0`00000M0?ooo`030000003oool0oooo01T0oooo100000140?ooo`030000
003oool0oooo03`0oooo000b0?ooo`030000003oool0oooo02P0oooo0`00000M0?ooo`030000003o
ool0oooo01T0oooo0`0000140?ooo`030000003oool0oooo03d0oooo000b0?ooo`030000003oool0
oooo02P0oooo0`00000M0?ooo`030000003oool0oooo01T0oooo0`0000130?ooo`030000003oool0
oooo03h0oooo000c0?ooo`030000003oool0oooo02L0oooo0`00000M0?ooo`030000003oool0oooo
01T0oooo0`0000120?ooo`030000003oool0oooo03l0oooo000d0?ooo`030000003oool0oooo02L0
oooo0`00000L0?ooo`03000004000000oooo01T0oooo0`0000120?ooo`030000003oool0oooo03l0
oooo000d0?ooo`030000003oool0oooo02L0oooo0`00000L0?ooo`030000003oool0oooo01T0oooo
0`0000110?ooo`030000003oool0oooo0400oooo000e0?ooo`030000003oool0oooo02H0oooo0`00
000L0?ooo`030000003oool0oooo01T0oooo0`0000100?ooo`030000003oool0oooo0440oooo000f
0?ooo`030000003oool0oooo02D0oooo0`00000L0?ooo`030000003oool0oooo01P0oooo0`000010
0?ooo`030000003oool0oooo0480oooo000f0?ooo`030000003oool0oooo02D0oooo0`00000L0?oo
o`030000003oool0oooo01P0oooo0`00000o0?ooo`030000003oool0oooo04<0oooo000g0?ooo`03
0000003oool0oooo02@0oooo0`00000L0?ooo`030000003oool0oooo01P0oooo0`00000n0?ooo`03
0000003oool0oooo04@0oooo000g0?ooo`030000003oool0oooo02D0oooo0`00000:0?ooo`03@000
003oool0oooo0080oooo00=000000?ooo`3oool00P3oool3@00000@0oooo00<000000?ooo`3oool0
603oool3000003d0oooo00<000000?ooo`3oool0A@3oool003P0oooo00<000000?ooo`3oool0903o
ool3000000T0oooo00=000000?oood0000002@3oool00d000000oooo0?ooo`030?ooo`030000003o
ool0oooo01P0oooo0`00000m0?ooo`030000003oool0oooo04D0oooo000h0?ooo`030000003oool0
oooo02@0oooo0`0000090?ooo`03@000003ooom0000000L0oooo140000040?ooo`03000004000000
oooo01P0oooo0`00000l0?ooo`030000003oool0oooo04H0oooo000i0?ooo`030000003oool0oooo
02<0oooo0`0000090?ooo`03@000003ooom0000000L0oooo00=000000?oood0000001@3oool00`00
0000oooo0?ooo`0H0?ooo`<00000>`3oool00`000000oooo0?ooo`170?ooo`00>P3oool00`000000
oooo0?ooo`0R0?ooo`<000002@3oool00d000000oooo@00000080?ooo`9000001@3oool00`000000
oooo0?ooo`0G0?ooo`<00000>`3oool00`000000oooo0?ooo`180?ooo`00>`3oool00`000000oooo
0?ooo`0Q0?ooo`<000002P3oool00d000000oooo0?ooo`080?ooo`03@000003oool0oooo00<0oooo
00<000000?ooo`3oool05`3oool3000003X0oooo00<000000?ooo`3oool0B@3oool003`0oooo00<0
00000?ooo`3oool0803oool3000001/0oooo00<000000?ooo`3oool05`3oool3000003T0oooo00<0
00000?ooo`3oool0BP3oool003`0oooo00<000000?ooo`3oool08@3oool3000001X0oooo00<00000
0?ooo`3oool05`3oool3000003P0oooo00<000000?ooo`3oool0B`3oool003d0oooo00<000000?oo
o`3oool0803oool3000001X0oooo00<000000?ooo`3oool05`3oool3000003L0oooo00<000000?oo
o`3oool0C03oool003h0oooo00<000000?ooo`3oool07`3oool3000001X0oooo00<000000?ooo`3o
ool05`3oool3000003H0oooo00<000000?ooo`3oool0C@3oool003l0oooo00<000000?ooo`3oool0
7P3oool3000001X0oooo00<00000@000003oool05P3oool3000003H0oooo00<000000?ooo`3oool0
CP3oool003l0oooo00<000000?ooo`3oool07P3oool3000001X0oooo00<000000?ooo`3oool05P3o
ool3000003D0oooo00<000000?ooo`3oool0C`3oool00400oooo00<000000?ooo`3oool07@3oool3
000001X0oooo00<000000?ooo`3oool05P3oool3000003@0oooo00<000000?ooo`3oool0D03oool0
0400oooo00<000000?ooo`3oool07P3oool3000001T0oooo00<000000?ooo`3oool05P3oool30000
03<0oooo00<000000?ooo`3oool0D@3oool00440oooo00<000000?ooo`3oool07@3oool3000001T0
oooo00<000000?ooo`3oool05P3oool3000003<0oooo00<000000?ooo`3oool0D@3oool00440oooo
00<000000?ooo`3oool07@3oool3000001T0oooo00<000000?ooo`3oool05P3oool300000380oooo
00<000000?ooo`3oool0DP3oool00480oooo00<000000?ooo`3oool0703oool3000001T0oooo00<0
00000?ooo`3oool05P3oool300000340oooo00<000000?ooo`3oool0D`3oool004<0oooo00<00000
0?ooo`3oool06`3oool3000001T0oooo00<000000?ooo`3oool05@3oool300000340oooo00<00000
0?ooo`3oool0E03oool004<0oooo00<000000?ooo`3oool06`3oool3000001T0oooo00<00000@000
003oool05@3oool300000300oooo00<000000?ooo`3oool0E@3oool004@0oooo00<000000?ooo`3o
ool06`3oool3000001P0oooo00<000000?ooo`3oool05@3oool3000002l0oooo00<000000?ooo`3o
ool0EP3oool004D0oooo00<000000?ooo`3oool06P3oool3000001P0oooo00<000000?ooo`3oool0
5@3oool3000002h0oooo00<000000?ooo`3oool0E`3oool004D0oooo00<000000?ooo`3oool06P3o
ool3000001P0oooo00<000000?ooo`3oool05@3oool3000002d0oooo00<000000?ooo`3oool0F03o
ool004H0oooo00<000000?ooo`3oool06@3oool3000001P0oooo00<000000?ooo`3oool05@3oool3
000002`0oooo00<000000?ooo`3oool0F@3oool004L0oooo00<000000?ooo`3oool0603oool30000
01P0oooo00<000000?ooo`3oool0503oool3000002`0oooo00<000000?ooo`3oool0FP3oool004L0
oooo00<000000?ooo`3oool0603oool3000001P0oooo00<000000?ooo`3oool0503oool4000002X0
oooo00<000000?ooo`3oool0F`3oool004P0oooo00<000000?ooo`3oool0603oool3000001L0oooo
00<000000?ooo`3oool0503oool4000002T0oooo00<000000?ooo`3oool0G03oool004T0oooo00<0
00000?ooo`3oool05P3oool4000001L0oooo00<00000@000003oool0503oool3000002T0oooo00<0
00000?ooo`3oool0G@3oool004T0oooo00<000000?ooo`3oool05P3oool4000001L0oooo00<00000
0?ooo`3oool0503oool3000002T0oooo00<000000?ooo`3oool0G@3oool004X0oooo00<000000?oo
o`3oool05P3oool3000001L0oooo00<000000?ooo`3oool0503oool3000002P0oooo00<000000?oo
o`3oool0GP3oool004/0oooo00<000000?ooo`3oool05@3oool3000001L0oooo00<000000?ooo`3o
ool0503oool3000002L0oooo00<000000?ooo`3oool0G`3oool004/0oooo00<000000?ooo`3oool0
5@3oool3000001L0oooo00<000000?ooo`3oool0503oool3000002H0oooo00<000000?ooo`3oool0
H03oool004`0oooo00<000000?ooo`3oool0503oool3000001L0oooo00<000000?ooo`3oool04`3o
ool3000002H0oooo00<000000?ooo`3oool0H@3oool004d0oooo00<000000?ooo`3oool04`3oool3
000000H0oooo00=000000?ooo`3oool00P3oool014000000oooo0?ooo`3oool2@00000H0oooo00<0
00000?ooo`3oool04`3oool3000002D0oooo00<000000?ooo`3oool0HP3oool004h0oooo00<00000
0?ooo`3oool04`3oool3000000@0oooo00=000000?oood0000001`3oool00d000000oooo@0000005
0?ooo`030000003oool0oooo01<0oooo0`00000T0?ooo`030000003oool0oooo06<0oooo001>0?oo
o`030000003oool0oooo01<0oooo0`0000040?ooo`03@000003ooom0000000L0oooo00=000000?oo
od0000001@3oool00`00001000000?ooo`0C0?ooo`<000008`3oool00`000000oooo0?ooo`1T0?oo
o`00C`3oool00`000000oooo0?ooo`0B0?ooo`<00000103oool00d000000oooo@00000070?ooo`90
00001P3oool00`000000oooo0?ooo`0B0?ooo`<000008`3oool00`000000oooo0?ooo`1U0?ooo`00
D03oool00`000000oooo0?ooo`0A0?ooo`<00000103oool00d000000oooo@00000070?ooo`03@000
003oool0oooo00D0oooo00<000000?ooo`3oool04P3oool300000280oooo00<000000?ooo`3oool0
IP3oool00500oooo00<000000?ooo`3oool04@3oool3000000D0oooo00=000000?ooo`3oool01`3o
ool2@00000D0oooo00<000000?ooo`3oool04P3oool300000240oooo00<000000?ooo`3oool0I`3o
ool00540oooo00<000000?ooo`3oool04@3oool3000001D0oooo00<000000?ooo`3oool04P3oool3
00000200oooo00<000000?ooo`3oool0J03oool00540oooo00<000000?ooo`3oool04@3oool30000
01D0oooo00<000000?ooo`3oool04P3oool3000001l0oooo00<000000?ooo`3oool0J@3oool00580
oooo00<000000?ooo`3oool0403oool3000001D0oooo00<000000?ooo`3oool04@3oool300000200
oooo00<000000?ooo`3oool0J@3oool00580oooo00<000000?ooo`3oool0403oool3000001D0oooo
00<000000?ooo`3oool04@3oool3000001l0oooo00<000000?ooo`3oool0JP3oool005<0oooo00<0
00000?ooo`3oool03`3oool3000001D0oooo00<00000@000003oool04@3oool3000001h0oooo00<0
00000?ooo`3oool0J`3oool005@0oooo00<000000?ooo`3oool03`3oool3000001@0oooo00<00000
0?ooo`3oool04@3oool3000001d0oooo00<000000?ooo`3oool0K03oool005D0oooo00<000000?oo
o`3oool03P3oool3000001@0oooo00<000000?ooo`3oool04@3oool3000001`0oooo00<000000?oo
o`3oool0K@3oool005H0oooo00<000000?ooo`3oool03@3oool3000001@0oooo00<000000?ooo`3o
ool0403oool3000001`0oooo00<000000?ooo`3oool0KP3oool005H0oooo00<000000?ooo`3oool0
3@3oool3000001@0oooo00<000000?ooo`3oool0403oool3000001/0oooo00<000000?ooo`3oool0
K`3oool005L0oooo00<000000?ooo`3oool0303oool3000001@0oooo00<000000?ooo`3oool0403o
ool3000001X0oooo00<000000?ooo`3oool0L03oool005P0oooo00<000000?ooo`3oool0303oool3
000001<0oooo00<000000?ooo`3oool0403oool3000001T0oooo00<000000?ooo`3oool0L@3oool0
05T0oooo00<000000?ooo`3oool02`3oool3000001<0oooo00<000000?ooo`3oool03`3oool30000
01T0oooo00<000000?ooo`3oool0LP3oool005T0oooo00<000000?ooo`3oool02`3oool3000001<0
oooo00<00000@000003oool03`3oool3000001P0oooo00<000000?ooo`3oool0L`3oool005X0oooo
00<000000?ooo`3oool02P3oool3000001<0oooo00<000000?ooo`3oool03`3oool3000001L0oooo
00<000000?ooo`3oool0M03oool005X0oooo00<000000?ooo`3oool02P3oool3000001<0oooo00<0
00000?ooo`3oool03`3oool3000001H0oooo00<000000?ooo`3oool0M@3oool005/0oooo00<00000
0?ooo`3oool02@3oool400000180oooo00<000000?ooo`3oool03`3oool3000001H0oooo00<00000
0?ooo`3oool0M@3oool005/0oooo00<000000?ooo`3oool02@3oool400000180oooo00<000000?oo
o`3oool03P3oool4000001D0oooo00<000000?ooo`3oool0MP3oool005`0oooo00<000000?ooo`3o
ool02@3oool300000180oooo00<000000?ooo`3oool03P3oool4000001@0oooo00<000000?ooo`3o
ool0M`3oool005d0oooo00<000000?ooo`3oool0203oool300000180oooo00<000000?ooo`3oool0
3P3oool3000001@0oooo00<000000?ooo`3oool0N03oool005d0oooo00<000000?ooo`3oool0203o
ool300000180oooo00<000000?ooo`3oool03P3oool3000001<0oooo00<000000?ooo`3oool0N@3o
ool005h0oooo00<000000?ooo`3oool01`3oool400000140oooo00<00000@000003oool03P3oool3
00000180oooo00<000000?ooo`3oool0NP3oool005l0oooo00<000000?ooo`3oool01`3oool30000
0140oooo00<000000?ooo`3oool03@3oool400000140oooo00<000000?ooo`3oool0N`3oool005l0
oooo00<000000?ooo`3oool01`3oool300000140oooo00<000000?ooo`3oool03@3oool300000180
oooo00<000000?ooo`3oool0N`3oool00600oooo00<000000?ooo`3oool01P3oool400000100oooo
00<000000?ooo`3oool03@3oool300000140oooo00<000000?ooo`3oool0O03oool00640oooo00<0
00000?ooo`3oool01P3oool300000100oooo00<000000?ooo`3oool03@3oool300000100oooo00<0
00000?ooo`3oool0O@3oool00640oooo00<000000?ooo`3oool01P3oool300000100oooo00<00000
0?ooo`3oool0303oool4000000l0oooo00<000000?ooo`3oool0OP3oool00680oooo00<000000?oo
o`3oool01@3oool3000000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`040?oo
o`030000003oool0oooo00`0oooo0`00000?0?ooo`030000003oool0oooo07l0oooo001S0?ooo`03
0000003oool0oooo00@0oooo100000070?ooo`03@000003ooom0000000D0oooo00<000000?ooo`3o
ool0303oool3000000h0oooo00<000000?ooo`3oool0P03oool006@0oooo00<000000?ooo`3oool0
103oool3000000L0oooo00=000000?oood0000001@3oool00`00001000000?ooo`0;0?ooo`@00000
3@3oool00`000000oooo0?ooo`210?ooo`00I03oool00`000000oooo0?ooo`040?ooo`<00000203o
ool00d000000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo0`00000=0?ooo`030000003o
ool0oooo0880oooo001U0?ooo`030000003oool0oooo00<0oooo0`0000070?ooo`03@000003ooom0
000000D0oooo00<000000?ooo`3oool02`3oool3000000`0oooo00<000000?ooo`3oool0P`3oool0
06H0oooo00<000000?ooo`3oool00P3oool4000000L0oooo00=000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0;0?ooo`<000002`3oool00`000000oooo0?ooo`240?ooo`00IP3oool00`000000
oooo0?ooo`030?ooo`<000003P3oool00`000000oooo0?ooo`0:0?ooo`@000002P3oool00`000000
oooo0?ooo`250?ooo`00I`3oool00`000000oooo0?ooo`020?ooo`<000003P3oool00`000000oooo
0?ooo`0:0?ooo`<000002P3oool00`000000oooo0?ooo`260?ooo`00J03oool010000000oooo0?oo
o`3oool4000000d0oooo00<000000?ooo`3oool02P3oool3000000T0oooo00<000000?ooo`3oool0
Q`3oool006P0oooo00<000000?ooo`3oool00P3oool3000000d0oooo00<000000?ooo`3oool02P3o
ool3000000T0oooo00<000000?ooo`3oool0Q`3oool006T0oooo00@000000?ooo`3oool0oooo0`00
000=0?ooo`03000004000000oooo00T0oooo100000080?ooo`030000003oool0oooo08P0oooo001Z
0?ooo`030000003oool0oooo00<000003@3oool00`000000oooo0?ooo`090?ooo`<00000203oool0
0`000000oooo0?ooo`290?ooo`00J`3oool00`000000oooo00000003000000`0oooo00<000000?oo
o`3oool02@3oool3000000L0oooo00<000000?ooo`3oool0RP3oool006`0oooo00<000000?ooo`00
00000P00000<0?ooo`030000003oool0oooo00P0oooo100000060?ooo`030000003oool0oooo08/0
oooo001/0?ooo`030000003oool0000000800000303oool00`000000oooo0?ooo`080?ooo`<00000
1P3oool00`000000oooo0?ooo`2<0?ooo`00K@3oool5000000/0oooo00<000000?ooo`3oool01`3o
ool4000000D0oooo00<000000?ooo`3oool0S@3oool006h0oooo1000000;0?ooo`030000003oool0
oooo00L0oooo0`0000050?ooo`030000003oool0oooo08h0oooo001_0?ooo`@000002P3oool00`00
0000oooo0?ooo`070?ooo`<00000103oool00`000000oooo0?ooo`2?0?ooo`00K`3oool4000000X0
oooo00<00000@000003oool01P3oool4000000<0oooo00<000000?ooo`3oool0T03oool00700oooo
0`00000:0?ooo`030000003oool0oooo00H0oooo0`0000030?ooo`030000003oool0oooo0940oooo
001`0?ooo`@000002@3oool00`000000oooo0?ooo`050?ooo`@000000P3oool00`000000oooo0?oo
o`2B0?ooo`00L@3oool3000000T0oooo00<000000?ooo`3oool01@3oool300000080oooo00<00000
0?ooo`3oool0T`3oool00740oooo0`0000090?ooo`030000003oool0oooo00D0oooo0`0000020?oo
o`030000003oool0oooo09<0oooo001a0?ooo`@00000203oool00`000000oooo0?ooo`040?ooo`@0
000000<0oooo0000003oool0U@3oool00740oooo100000080?ooo`030000003oool0oooo00@0oooo
0`0000000`3oool000000?ooo`2F0?ooo`00LP3oool4000000L0oooo00<000000?ooo`3oool00`3o
ool5000009P0oooo001c0?ooo`<000001`3oool00`00001000000?ooo`030?ooo`@00000V@3oool0
07<0oooo100000060?ooo`030000003oool0oooo0080oooo1000002J0?ooo`00M03oool3000000H0
oooo00<000000?ooo`3oool00P3oool3000009/0oooo001d0?ooo`@000001@3oool010000000oooo
0?ooo`3oool4000009/0oooo001e0?ooo`D000000`3oool00`000000oooo0?ooo`04000009`0oooo
001f0?ooo`@000000`3oool00`000000oooo00000003000009d0oooo001d0?ooo`9000001P000000
0`3oool0000000000003000009h0oooo001f0?ooo`03@00000000000000000<000000T0000040000
09h0oooo001f0?ooo`03@000003oool0000000T00000WP3oool007H0oooo00A000000?ooo`3oool0
oooo1P00002P0?ooo`00MP3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo0:00oooo
001e0?ooo`9000001P3oool00`000000oooo0?ooo`2P0?ooo`00O@3oool00d000000oooo0?ooo`2P
0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-3.37918, -0.07747, 
  0.0270326, 0.00624851}}],

Cell[OutputFormData["\<\
Graphics[{{Thickness[0.01199999999999999], 
    RGBColor[0, 0, 0], 
    {Line[{{-2.999999708333333, 0.}, 
       {-2.716031058989589, 0.}, 
       {-2.406338400984384, 0.}, 
       {-2.11548443563023, 0.}, 
       {-1.835771145604203, 0.}, 
       {-1.538031864239638, 0.}, 
       {-1.251433258203201, 0.}, 
       {-1.176344815025348, 0.}, 
       {-1.094838654315513, 0.}, 
       {-1.057476835967042, 0.}, 
       {-1.037026878102475, 0.}, 
       {-1.017869075579331, 0.}, 
       {-1.009517386737721, 0.}, 
       {-1.001578324544223, 0.}, 
       {-0.9924269844172384, 
        0.01508868060050638}, 
       {-0.984054192262252, 
        0.03163734669108653}, 
       {-0.9468086608282261, 
        0.103553359780661}, 
       {-0.6660908167345312, 
        0.5563230238619249}, 
       {-0.5214937234205777, 
        0.7280442964329418}, 
       {-0.3673469813022978, 
        0.8650561953280892}, 
       {-0.2917492262413292, 
        0.9148823889875856}, 
       {-0.2519837104875799, 
        0.9365042096489114}, 
       {-0.2099728178504465, 
        0.9559114157639431}, 
       {-0.1731630927601952, 
        0.970014543305724}, 
       {-0.1327585967038172, 
        0.9823751550012332}, 
       {-0.1150268236688318, 
        0.9867688298366594}, 
       {-0.09601823428422996, 
        0.9907804986849388}, 
       {-0.07971426110754177, 
        0.9936456365760786}, 
       {-0.06171782985965389, 
        0.9961909094774147}, 
       {-0.04288514648579637, 
        0.9981608642108918}, 
       {-0.03256575635082382, 
        0.9989394715132988}, 
       {-0.02287778805049173, 
        0.9994766068139167}, 
       {-0.01385641141799806, 
        0.9998079998626151}, 
       {-0.005584904026247768, 
        0.9999688088470175}, 
       {0.003496133700869083, 
        0.9999877770491456}, 
       {0.01305692679949152, 
        0.9998295166625526}, 
       {0.01815453523298243, 
        0.9996704128504743}, 
       {0.0227863812886992, 
        0.9994807808277659}, 
       {0.03318052471835098, 
        0.9988990527794149}, 
       {0.04281112554886267, 
        0.9981672075292394}, 
       {0.05190302253043221, 
        0.9973060762522054}, 
       {0.07229266730768003, 
        0.9947737702535411}, 
       {0.09439584468873295, 
        0.9910894245055006}, 
       {0.1317712651273547, 
        0.9826363336867364}, 
       {0.1713413107508907, 
        0.9706421552301666}, 
       {0.2422859189579655, 0.941297533474694}, 
       {0.311644337940588, 0.9028778066295725}, 
       {0.3861557017375396, 
        0.8508837740155883}, 
       {0.5207575118692798, 
        0.7288116138317168}, 
       {0.6763909178548191, 
        0.5424953262435153}, 
       {0.8241404121295431, 
        0.3207925810949465}, 
       {0.9001503413305337, 
        0.1897293630025234}, 
       {0.9374183760126111, 
        0.1212467883138785}, 
       {0.9716615874333598, 
        0.0558737595064832}, 
       {0.9878311949804984, 
        0.02418953022340031}, 
       {0.995721974417588, 
        0.008537749661940207}, 
       {1.002907095218886, 0.}, 
       {1.010502317575154, 0.}, 
       {1.018633733936308, 0.}, 
       {1.0358734641684, 0.}, 
       {1.10524196173355, 0.}, 
       {1.250123155223112, 0.}, 
       {1.404369502676096, 0.}, 
       {1.6976162816759, 0.}, 
       {1.979722385347576, 0.}, 
       {2.27985448035779, 0.}, 
       {2.568845900039876, 0.}, 
       {2.846696644393834, 0.}, 
       {3.14257338008633, 0.}, 
       {3.427309440450699, 0.}, 
       {3.730071492153606, 0.}, 
       {3.999999708333333, 0.}}]}}, 
   {Thickness[0.004], RGBColor[0., 0., 0], 
    {Line[{{-2.999999882148869, 
        4.044011451654247*^-8}, 
       {-2.885259220665814, 
        0.03937281083845811}, 
       {-2.760124490060576, 
        0.08231226188656139}, 
       {-2.642601740782337, 
        0.1226396938893617}, 
       {-2.529580504116392, 
        0.1614224509683965}, 
       {-2.409275667042968, 
        0.2027045445756538}, 
       {-2.293472342581838, 
        0.2424419632591453}, 
       {-2.170385417713229, 
        0.2846787184708594}, 
       {-2.051800005456914, 
        0.3253707987588079}, 
       {-1.937716105812896, 
        0.3645182041229906}, 
       {-1.816348605761397, 0.406164946015396}, 
       {-1.699482618322193, 
        0.4462670129840354}, 
       {-1.587118143495285, 
        0.4848244050289094}, 
       {-1.467470068260896, 
        0.5258811336020058}, 
       {-1.352323505638803, 
        0.5653931872513365}, 
       {-1.22989334260923, 0.6074045774288898}, 
       {-1.111964692191952, 
        0.6478712926826774}, 
       {-0.9985375543869697, 
        0.6867933330126993}, 
       {-0.8778268161745065, 
        0.7282147098709438}, 
       {-0.761617590574339, 
        0.7680914118054227}, 
       {-0.6381247645666912, 
        0.8104674502681239}, 
       {-0.5191334511713386, 
        0.8512988138070596}, 
       {-0.4046436503882816, 
        0.8905855024222296}, 
       {-0.2828702491977442, 
        0.9323715275656219}, 
       {-0.1715729931049398, 
        0.9705627080370261}}]}}, 
   {Thickness[0.004], RGBColor[0., 0., 0], 
    {Line[{{-0.1715728628125793, 
        0.9705627527462958}, 
       {-0.1594599963452238, 
        0.9745725095655812}, 
       {-0.1462498556448095, 
        0.9786109797238722}, 
       {-0.1338432915681849, 
        0.9820859733021938}, 
       {-0.1219119402057723, 
        0.9851374788352641}, 
       {-0.1092116785198784, 
        0.9880728092748707}, 
       {-0.09698662954819676, 
        0.9905935936888809}, 
       {-0.0839926702530338, 
        0.992945231343765}, 
       {-0.07147392367208292, 
        0.9948914782349172}, 
       {-0.05943038980534408, 
        0.9964680287675848}, 
       {-0.04661794561512405, 
        0.9978267671466253}, 
       {-0.04024808623958485, 
        0.9983800915540509}, 
       {-0.03428071413911606, 
        0.9988248326381121}, 
       {-0.0281994788714261, 
        0.9992047893913799}, 
       {-0.02241869537732017, 
        0.9994974020975789}, 
       {-0.01938367669059049, 
        0.9996242730779545}, 
       {-0.01607081502530859, 
        0.9997417289044223}, 
       {-0.01308025168850072, 
        0.9998289070157653}, 
       {-0.01026297900625511, 
        0.999894671261917}, 
       {-0.008709052670398108, 
        0.9999241524015843}, 
       {-0.007028122931837657, 
        0.9999506054880548}, 
       {-0.00562988440267728, 
        0.9999683044016125}, 
       {-0.004095096435670744, 
        0.9999832301851824}, 
       {-0.003233878139471975, 
        0.999989542032179}, 
       {-0.00242985406589034, 
        0.9999940958092185}, 
       {-0.001993837011196641, 
        0.9999960246139727}, 
       {-0.001580788027577226, 
        0.9999975011092118}, 
       {-0.001352744933866582, 
        0.9999981700811439}, 
       {-0.001104682896579161, 
        0.9999987796756981}, 
       {-0.0008807830019986983, 
        0.9999992242213034}, 
       {-0.0006705830722768823, 
        0.9999995503183431}, 
       {-0.0002933926826614015, 
        0.9999999139207337}, 
       {-0.000093034638214202, 
        0.9999999913445559}, 
       {0.0001229525137220662, 
        0.9999999848826794}, 
       {0.0003371903918842231, 
        0.9999998863026394}, 
       {0.0005627465550174179, 
        0.9999996833163148}, 
       {0.000965984310363931, 
        0.9999990668743121}, 
       {0.001340591101624204, 
        0.9999982028154981}, 
       {0.001689115995534366, 
        0.9999971468871535}, 
       {0.002480132583348235, 
        0.9999938489423689}, 
       {0.003303772394569917, 
        0.9999890850879648}, 
       {0.004063177811175857, 
        0.9999834905860748}, 
       {0.005779261139510635, 
        0.9999666001406813}, 
       {0.007292137422959874, 
        0.9999468247318045}, 
       {0.008893847393210563, 
        0.9999208994785462}, 
       {0.01166894013951386, 
        0.9998638358360205}, 
       {0.01472154876183236, 
        0.9997832760020529}, 
       {0.02081870452502267, 
        0.9995665815418998}, 
       {0.02736884505391187, 
        0.999250946320415}, 
       {0.04030983895526053, 
        0.9983751168834009}, 
       {0.05277562014239711, 
        0.9972147339185854}, 
       {0.06476618861532163, 
        0.9958053408122445}, 
       {0.07752566741172737, 
        0.9939897708923663}, 
       {0.08980993349392104, 
        0.9919341758458173}, 
       {0.1028631098995959, 
        0.9894191806217836}, 
       {0.1154410735910587, 
        0.9866733585281437}, 
       {0.1270166413513521, 0.9838667728198219}}
]}}, {Thickness[0.004], RGBColor[0., 0., 0], 
    {Line[{{0.1270168151668886, 
        0.9838667286648867}, 
       {0.2841319365602219, 0.943954254705693}, 
       {0.4554797232597747, 0.9004262097030082}, 
       {0.6164043752590647, 0.8595459880836367}, 
       {0.7711650772567338, 0.8202316150709666}, 
       {0.9358992598619803, 0.7783836457914171}, 
       {1.094469492465606, 0.7381015251185688}, 
       {1.263013205676809, 0.6952858081788413}, 
       {1.425392968886391, 0.6540359398458152}, 
       {1.581608782094352, 0.61435192011949}, 
       {1.747798075909891, 0.5721343041262857}, 
       {1.907823419723809, 0.5314825367397826}, 
       {2.061684813536107, 0.4923966179599808}, 
       {2.225519687955982, 0.4507771029132997}, 
       {2.383190612374236, 0.41072343647332}, 
       {2.550835017400067, 0.3681361737664607}, 
       {2.712315472424277, 0.3271147596663029}, 
       {2.867631977446867, 0.2876591941728463}, 
       {3.032921963077034, 0.2456700324125104}, 
       {3.19204799870558, 0.2052467192588757}, 
       {3.361147514941704, 0.1622898098383618}, 
       {3.524083081176207, 0.1208987490245491}, 
       {3.680854697409089, 0.08107353681743767}, 
       {3.847599794249548, 0.03871472834344693}, 
       {3.999999838625694, 
        4.099444869163948*^-8}}]}}}, 
  {DisplayFunction -> (Display[$Display, #1] & ), 
   PlotRange -> All, 
   PlotRange -> {{-3.2, 3.2}, {-0.5, 2}}, 
   AspectRatio -> GoldenRatio^(-1), 
   DisplayFunction :> Identity, 
   ColorOutput -> Automatic, Axes -> Automatic, 
   AxesOrigin -> Automatic, PlotLabel -> None, 
   AxesLabel -> None, Ticks -> Automatic, 
   GridLines -> None, Prolog -> {}, Epilog -> {}, 
   AxesStyle -> Automatic, 
   Background -> Automatic, 
   DefaultColor -> Automatic, 
   DefaultFont :> $DefaultFont, 
   RotateLabel -> True, Frame -> False, 
   FrameStyle -> Automatic, 
   FrameTicks -> Automatic, FrameLabel -> None, 
   PlotRegion -> Automatic, 
   ImageSize -> Automatic, 
   TextStyle :> $TextStyle, 
   FormatType :> $FormatType}]\
\>", "\<\
-Graphics-\
\>"], "Output"]
}, Open  ]],

Cell[TextData[
"\"Eur\[OAcute]pska call opcia bez transak\[CHacek]n\[YAcute]mi \
n\[AAcute]kladmi\""], "Text"],

Cell[CellGroupData[{

Cell["\<\
X=60;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=20;
n=20;
Slarge=150;
trans=0.02;
time=0.03;
str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]];

NumImplicitTransCost[X,sigma,r,DD,t,m,n,trans,time];

Payoff[S_]:=Max[S-X,0];

g=Plot[BlackScholes[S,X,str,r,t],{S,0,150},PlotRange->All,PlotStyle->{\
Thickness[0.0055],RGBColor[0,0,0]}, DisplayFunction->Identity];
g1=ListPlot[grf[n],PlotStyle->{PointSize[0.02],RGBColor[0.,0.,0]},\
DisplayFunction->Identity];

Show[g,g1,AxesLabel -> \
{\"S\",\"c\"},DisplayFunction->$DisplayFunction,PlotRange->{{20,120},{0,65}}]
\
\>", "Input"],

Cell["Pomer k/h^2  0.300504", "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.2 0.01 0 0.00950822 [
[.2 -0.0125 -6 -9 ]
[.2 -0.0125 6 0 ]
[.4 -0.0125 -6 -9 ]
[.4 -0.0125 6 0 ]
[.6 -0.0125 -6 -9 ]
[.6 -0.0125 6 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .09508 -12 -4.5 ]
[-0.0125 .09508 0 4.5 ]
[-0.0125 .19016 -12 -4.5 ]
[-0.0125 .19016 0 4.5 ]
[-0.0125 .28525 -12 -4.5 ]
[-0.0125 .28525 0 4.5 ]
[-0.0125 .38033 -12 -4.5 ]
[-0.0125 .38033 0 4.5 ]
[-0.0125 .47541 -12 -4.5 ]
[-0.0125 .47541 0 4.5 ]
[-0.0125 .57049 -12 -4.5 ]
[-0.0125 .57049 0 4.5 ]
[0 .64303 -5 0 ]
[0 .64303 5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2 0 m
.2 .00625 L
s
[(40)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(60)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(80)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(100)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(120)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .09508 m
.00625 .09508 L
s
[(10)] -0.0125 .09508 1 0 Mshowa
0 .19016 m
.00625 .19016 L
s
[(20)] -0.0125 .19016 1 0 Mshowa
0 .28525 m
.00625 .28525 L
s
[(30)] -0.0125 .28525 1 0 Mshowa
0 .38033 m
.00625 .38033 L
s
[(40)] -0.0125 .38033 1 0 Mshowa
0 .47541 m
.00625 .47541 L
s
[(50)] -0.0125 .47541 1 0 Mshowa
0 .57049 m
.00625 .57049 L
s
[(60)] -0.0125 .57049 1 0 Mshowa
.125 Mabswid
0 .01902 m
.00375 .01902 L
s
0 .03803 m
.00375 .03803 L
s
0 .05705 m
.00375 .05705 L
s
0 .07607 m
.00375 .07607 L
s
0 .1141 m
.00375 .1141 L
s
0 .13312 m
.00375 .13312 L
s
0 .15213 m
.00375 .15213 L
s
0 .17115 m
.00375 .17115 L
s
0 .20918 m
.00375 .20918 L
s
0 .2282 m
.00375 .2282 L
s
0 .24721 m
.00375 .24721 L
s
0 .26623 m
.00375 .26623 L
s
0 .30426 m
.00375 .30426 L
s
0 .32328 m
.00375 .32328 L
s
0 .3423 m
.00375 .3423 L
s
0 .36131 m
.00375 .36131 L
s
0 .39935 m
.00375 .39935 L
s
0 .41836 m
.00375 .41836 L
s
0 .43738 m
.00375 .43738 L
s
0 .45639 m
.00375 .45639 L
s
0 .49443 m
.00375 .49443 L
s
0 .51344 m
.00375 .51344 L
s
0 .53246 m
.00375 .53246 L
s
0 .55148 m
.00375 .55148 L
s
0 .58951 m
.00375 .58951 L
s
0 .60853 m
.00375 .60853 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 0 r
.0055 w
.02092 0 m
.03462 0 L
.04948 0 L
.05348 0 L
.05772 0 L
.06134 0 L
.0634 0 L
.06532 0 L
s
.06532 0 m
.06619 0 L
s
.07154 0 m
.07254 0 L
.07449 0 L
.07657 0 L
.07853 0 L
.0803 0 L
.08237 0 L
.08341 0 L
.08455 0 L
.08657 0 L
.08846 0 L
.0896 0 L
.09069 0 L
.09272 0 L
.09385 0 L
.0949 0 L
.09605 0 L
.09728 0 L
.09918 0 L
.10097 0 L
.102 0 L
.10309 0 L
.10504 0 L
.10708 0 L
.10897 0 L
.11106 0 L
.11222 0 L
.11328 0 L
.11516 0 L
.11692 0 L
.11884 0 L
.12092 0 L
.12195 0 L
.12308 0 L
.12514 0 L
.12714 0 L
.129 0 L
.1309 0 L
.13268 0 L
.13429 0 L
.13602 0 L
.13792 0 L
.13992 0 L
.14162 0 L
.1435 0 L
.14455 0 L
.1457 0 L
.14778 0 L
.14981 0 L
.15168 0 L
Mistroke
.1537 0 L
.15593 0 L
.15706 0 L
.15826 0 L
.16045 0 L
.16237 0 L
.16447 0 L
.16666 0 L
.1687 0 L
.17061 0 L
.17235 0 L
.17436 0 L
.17625 0 L
.17807 0 L
.18003 0 L
.18188 0 L
.18357 0 L
.18554 0 L
.18769 0 L
.18972 0 L
.1916 0 L
.19534 0 L
.19747 0 L
.19947 0 L
.20349 0 L
.20576 0 L
.20783 0 L
.21134 0 L
.21459 0 L
.21817 0 L
.22017 0 L
.222 0 L
.22568 0 L
.22967 0 L
.23344 1e-005 L
.23692 1e-005 L
.24075 1e-005 L
.24426 2e-005 L
.24831 2e-005 L
.25216 3e-005 L
.2557 4e-005 L
.25899 6e-005 L
.26259 7e-005 L
.26643 .0001 L
.27065 .00013 L
.27521 .00017 L
.27952 .00023 L
.28348 .00029 L
.29099 .00046 L
.29478 .00057 L
Mistroke
.29893 .00071 L
.30719 .00109 L
.31501 .00159 L
.32204 .00218 L
.32968 .00302 L
.33798 .00419 L
.3468 .00578 L
.36263 .00969 L
.3774 .01474 L
.39332 .02179 L
.42211 .03874 L
.48694 .09104 L
.54938 .14898 L
.60943 .20595 L
.67335 .26671 L
.73488 .32521 L
.80027 .38739 L
.86327 .44729 L
.92388 .50493 L
.98836 .56623 L
Mfstroke
.98836 .56623 m
1 .5773 L
s
.02 w
.04 0 Mdot
.05125 0 Mdot
.06303 0 Mdot
.07536 0 Mdot
.08827 0 Mdot
.10178 0 Mdot
.11593 0 Mdot
.13074 0 Mdot
.14625 0 Mdot
.16248 0 Mdot
.17947 0 Mdot
.19726 1e-005 Mdot
.21589 2e-005 Mdot
.23538 6e-005 Mdot
.25579 .00015 Mdot
.27716 .00041 Mdot
.29953 .00104 Mdot
.32295 .00252 Mdot
.34747 .00576 Mdot
.37313 .01225 Mdot
.4 .0239 Mdot
.42813 .042 Mdot
.45757 .06537 Mdot
.4884 .09248 Mdot
.52067 .12219 Mdot
.55446 .15392 Mdot
.58983 .18739 Mdot
.62686 .22254 Mdot
.66562 .25938 Mdot
.7062 .29796 Mdot
.74868 .33835 Mdot
.79316 .38063 Mdot
.83972 .4249 Mdot
.88846 .47125 Mdot
.93949 .51977 Mdot
.99291 .57056 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{368.875, 227.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005`0000hb000`400?l00000o`00003oo`3oooma
0?ooo`00E`3oool3@0000080oooo00=000000?ooo`3oool0=@3oool2@00000@0oooo00=000000?oo
o`3oool0=@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0380oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0;`3oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool05`3oool005P0oooo00I000000?ooo`3ooom000000?oood00
000f0?ooo`03@000003ooom000000080oooo00=000000?oood000000=@3oool00d000000oooo@000
00020?ooo`03@000003ooom0000003D0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood000000<P3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oo
od000000603oool005H0oooo14000000103ooom000000?oood00000f0?ooo`03@000003ooom00000
0080oooo00=000000?oood000000=@3oool00d000000oooo@00000020?ooo`03@000003ooom00000
03D0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000<P3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000H0?ooo`00
EP3oool00d000000oooo@00000020?ooo`03@000003ooom0000003H0oooo0T0000030?ooo`03@000
003ooom0000003H0oooo00M000000?ooo`3oool0oooo@000003ooom0000003D0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood000000<P3oool00d000000oooo0?oo
o`020?ooo`07@000003oool0oooo0?oood000000oooo@000000H0?ooo`00E`3oool2@0000080oooo
00=000000?oood000000=P3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000003D0oooo
00=000000?oood0000000P3oool00d000000oooo@000000e0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000020?ooo`03@000003ooom000000380oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood000000603oool005P0oooo00E000000?ooo`3oool0oooo@000
000h0?ooo`9000000`3oool00d000000oooo0?ooo`0e0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool0<`3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`0`0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01L0oooo003o
0?ooog40oooo003o0?ooog40oooo003o0?ooog40oooo003o0?oooed0oooo0d00000A0?ooo`009P3o
oolZ000000030?ooo`000000000000P0000000<0oooo0000000000000`0000000`3oool000000000
0003000000030?ooo`000000000000<000000P3oool500000080oooo1@00003Q0?ooo`03@000003o
oom000000140oooo000L0?ooool00000=P0000000d000000oooo0?ooo`0:0?ooo`03@000003oool0
oooo00l0oooo000L0?ooo`030000003oool0oooo00L0oooo:P0000000`3oool00000000000080000
00030?ooo`000000000000<0000000<0oooo0000000000000`0000000`3oool00000000000030000
0080oooo500000020?ooo`D000003P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`03@000003oool0oooo
0100oooo000L0?ooo`030000003oool0oooo00L0oooo:P0000000`3oool000000000000800000003
0?ooo`000000000000<0000000<0oooo0000000000000`0000000`3oool000000000000300000080
oooo1@0000020?ooo`D000000P3oool5000000030?ooo`000000000000D000003P3oool00d000000
oooo0?ooo`0<0?ooo`03@000003oool0oooo00d0oooo00=000000?ooo`3oool0303oool00d000000
oooo0?ooo`0<0?ooo`03@000003oool0oooo00d0oooo00=000000?ooo`3oool0303oool00d000000
oooo0?ooo`0=0?ooo`03@000003oool0oooo00`0oooo00=000000?ooo`3oool03@3oool00d000000
oooo0?ooo`0<0?ooo`03@000003oool0oooo00d0oooo00=000000?ooo`3oool0303oool00d000000
oooo0?ooo`080?ooo`03@000003ooom000000140oooo000L0?ooo`030000003oool0oooo00P0oooo
1P0000000`3oool0000000000004000000040?ooo`000000000000000080oooo0`000000103oool0
00000000000000020?ooo`<0000000@0oooo00000000000000000P3oool3000000<0oooo0`000002
0?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`<00000103oool3000000@0oooo0`000003
0?ooo`D000000`3oool=00000<X0oooo0d00000A0?ooo`00703oool00`000000oooo0?ooo`1O0?oo
o`<00000103oool5000000<0oooo1@00003N0?ooo`00703oool00`000000oooo0?ooo`1W0?ooo`<0
0000103oool500000=h0oooo000L0?ooo`03000004000000oooo06h0oooo1`0000000`3oool00000
0000000300000=H0oooo000L0?ooo`030000003oool0oooo06l0oooo0`0000030?ooo`H00000eP3o
ool001`0oooo00<000000?ooo`3oool0MP3oool500000=H0oooo000L0?ooo`030000003oool0oooo
07H0oooo1@00003F0?ooo`00703oool00`000000oooo0?ooo`1g0?ooo`<0000000<0oooo00000000
0000e03oool001`0oooo00<000000?ooo`3oool0O@3oool200000=80oooo000L0?ooo`0300000400
0000oooo07l0oooo1@00003=0?ooo`00703oool00`000000oooo0?ooo`1o0?ooo`D00000c@3oool0
01`0oooo00<000000?ooo`3oool0O`3oool500000<d0oooo000L0?ooo`030000003oool0oooo07l0
oooo1@00003=0?ooo`00703oool00`000000oooo0?ooo`200?ooo`<0000000<0oooo0000003oool0
b`3oool001`0oooo00<000000?ooo`3oool0Q@3oool00`000000oooo0?ooo`390?ooo`00703oool0
0`00001000000?ooo`260?ooo`030000003oool0oooo0<P0oooo000L0?ooo`030000003oool0oooo
08L0oooo1P0000340?ooo`00703oool00`000000oooo0?ooo`280?ooo`D00000a03oool001`0oooo
00<000000?ooo`3oool0R03oool500000<@0oooo000L0?ooo`030000003oool0oooo08P0oooo1@00
00340?ooo`00703oool00`000000oooo0?ooo`290?ooo`@00000a03oool001`0oooo00<00000@000
003oool0S@3oool00`000000oooo0?ooo`310?ooo`00703oool00`000000oooo0?ooo`2>0?ooo`03
0000003oool0oooo0<00oooo000L0?ooo`030000003oool0oooo08l0oooo0P0000300?ooo`00703o
ool00`000000oooo0?ooo`2A0?ooo`030000003oool0oooo0;d0oooo000>0?ooo`E000000P3oool0
0d000000oooo0?ooo`040?ooo`030000003oool0oooo0940oooo1@00002k0?ooo`00403oool01d00
0000oooo0?ooo`3ooom000000?oood0000001@3oool00`000000oooo0?ooo`2A0?ooo`D00000^`3o
ool00100oooo00M000000?ooo`3oool0oooo@000003ooom0000000D0oooo0P0000000d000000oooo
0?ooo`2?0?ooo`D00000^`3oool00100oooo00M000000?ooo`3oool0oooo@000003ooom0000000D0
oooo00<000000?ooo`3oool0T@3oool500000;/0oooo000@0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000050?ooo`030000003oool0oooo0980oooo0`0000000`3oool000000?ooo`2i0?oo
o`003`3oool2@00000@0oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`2G0?ooo`03
0000003oool0oooo0;L0oooo000L0?ooo`030000003oool0oooo09P0oooo0P00002g0?ooo`00703o
ool00`000000oooo0?ooo`2J0?ooo`030000003oool0oooo0;@0oooo000L0?ooo`03000004000000
oooo09/0oooo00<000000?ooo`3oool0/`3oool001`0oooo00<000000?ooo`3oool0V`3oool50000
0;40oooo000L0?ooo`030000003oool0oooo09/0oooo1@00002a0?ooo`00703oool00`000000oooo
0?ooo`2K0?ooo`D00000/@3oool001`0oooo00<000000?ooo`3oool0V`3oool500000;40oooo000L
0?ooo`030000003oool0oooo09`0oooo0`0000000`3oool000000?ooo`2_0?ooo`00703oool00`00
001000000?ooo`2Q0?ooo`030000003oool0oooo0:d0oooo000L0?ooo`030000003oool0oooo0:80
oooo0P00002]0?ooo`00703oool00`000000oooo0?ooo`2T0?ooo`030000003oool0oooo0:X0oooo
000L0?ooo`030000003oool0oooo0:D0oooo00<000000?ooo`3oool0Z@3oool001`0oooo00<00000
0?ooo`3oool0YP3oool00`000000oooo0?ooo`2X0?ooo`00703oool00`000000oooo0?ooo`2V0?oo
o`D00000YP3oool001`0oooo00<00000@000003oool0YP3oool500000:H0oooo000L0?ooo`030000
003oool0oooo0:H0oooo1@00002V0?ooo`00703oool00`000000oooo0?ooo`2V0?ooo`D00000YP3o
ool001`0oooo00<000000?ooo`3oool0Y`3oool3000000030?ooo`000000oooo0:@0oooo000L0?oo
o`030000003oool0oooo0:`0oooo00<000000?ooo`3oool0XP3oool001`0oooo00<00000@000003o
ool0[@3oool00`000000oooo0?ooo`2Q0?ooo`00703oool00`000000oooo0?ooo`2^0?ooo`030000
003oool0oooo0:00oooo000L0?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0W`3o
ool001`0oooo00<000000?ooo`3oool0/03oool2000009l0oooo000?0?ooo`=000000`3oool00d00
0000oooo0?ooo`040?ooo`030000003oool0oooo0;40oooo1@00002K0?ooo`003`3oool00d000000
oooo0?ooo`020?ooo`03@000003ooom0000000D0oooo00<000000?ooo`3oool0/@3oool5000009/0
oooo000@0?ooo`07@000003oool0oooo0?oood000000oooo@00000050?ooo`80000000=000000?oo
o`3oool0[`3oool5000009/0oooo000@0?ooo`07@000003oool0oooo0?oood000000oooo@0000005
0?ooo`030000003oool0oooo0;40oooo1@00002K0?ooo`003`3oool00d000000oooo@00000020?oo
o`03@000003ooom0000000D0oooo00<000000?ooo`3oool0/P3oool3000000030?ooo`000000oooo
09T0oooo000@0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0103oool00`000000
oooo0?ooo`2g0?ooo`030000003oool0oooo09L0oooo000L0?ooo`030000003oool0oooo0;P0oooo
00<000000?ooo`3oool0UP3oool001`0oooo00<000000?ooo`3oool0^@3oool00`000000oooo0?oo
o`2E0?ooo`00703oool00`00001000000?ooo`2j0?ooo`030000003oool0oooo09@0oooo000L0?oo
o`030000003oool0oooo0;/0oooo00<000000?ooo`3oool0T`3oool001`0oooo00<000000?ooo`3o
ool0_03oool00`000000oooo0?ooo`2B0?ooo`00703oool00`000000oooo0?ooo`2l0?ooo`D00000
T03oool001`0oooo00<000000?ooo`3oool0_03oool500000900oooo000L0?ooo`030000003oool0
oooo0;`0oooo1@00002@0?ooo`00703oool00`00001000000?ooo`2l0?ooo`D00000T03oool001`0
oooo00<000000?ooo`3oool0_@3oool3000000030?ooo`000000oooo08h0oooo000L0?ooo`030000
003oool0oooo0<80oooo00<000000?ooo`3oool0S03oool001`0oooo00<000000?ooo`3oool0``3o
ool2000008`0oooo000L0?ooo`030000003oool0oooo0<D0oooo00<000000?ooo`3oool0R@3oool0
01`0oooo00<000000?ooo`3oool0aP3oool00`000000oooo0?ooo`280?ooo`00703oool00`000010
00000?ooo`370?ooo`030000003oool0oooo08L0oooo000L0?ooo`030000003oool0oooo0<P0oooo
00<000000?ooo`3oool0QP3oool001`0oooo00<000000?ooo`3oool0b03oool5000008@0oooo000L
0?ooo`030000003oool0oooo0<P0oooo1@0000240?ooo`00703oool00`000000oooo0?ooo`380?oo
o`D00000Q03oool001`0oooo00<000000?ooo`3oool0b03oool5000008@0oooo000L0?ooo`030000
04000000oooo0<T0oooo0`0000000`3oool000000?ooo`220?ooo`00703oool00`000000oooo0?oo
o`3>0?ooo`030000003oool0oooo0800oooo000L0?ooo`030000003oool0oooo0<l0oooo00<00000
0?ooo`3oool0O`3oool001`0oooo00<000000?ooo`3oool0d03oool00`000000oooo0?ooo`1n0?oo
o`003`3oool2@00000@0oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`3A0?ooo`03
0000003oool0oooo07d0oooo000A0?ooo`06@000003oool0oooo@000003ooom000001@3oool00`00
0000oooo0?ooo`3B0?ooo`030000003oool0oooo07`0oooo000@0?ooo`07@000003oool0oooo0?oo
od000000oooo@00000050?ooo`80000000=000000?ooo`3oool0d@3oool00`000000oooo0?ooo`1k
0?ooo`004@3oool01T000000oooo0?oood000000oooo@00000D0oooo00<000000?ooo`3oool0e03o
ool00`000000oooo0?ooo`1j0?ooo`003`3oool00d000000oooo@00000020?ooo`03@000003ooom0
000000D0oooo00<000000?ooo`3oool0e@3oool5000007L0oooo000@0?ooo`03@000003oool0oooo
0080oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`3E0?ooo`D00000M`3oool001`0
oooo00<000000?ooo`3oool0e@3oool5000007L0oooo000L0?ooo`030000003oool0oooo0=D0oooo
1@00001g0?ooo`00703oool00`00001000000?ooo`3F0?ooo`<0000000<0oooo0000003oool0M@3o
ool001`0oooo00<000000?ooo`3oool0f`3oool00`000000oooo0?ooo`1c0?ooo`00703oool00`00
0000oooo0?ooo`3L0?ooo`030000003oool0oooo0780oooo000L0?ooo`030000003oool0oooo0=d0
oooo00<000000?ooo`3oool0L@3oool001`0oooo00<000000?ooo`3oool0gP3oool00`000000oooo
0?ooo`1`0?ooo`00703oool00`000000oooo0?ooo`3O0?ooo`030000003oool0oooo06l0oooo000L
0?ooo`03000004000000oooo0>00oooo00<000000?ooo`3oool0KP3oool001`0oooo00<000000?oo
o`3oool0h@3oool00`000000oooo0?ooo`1]0?ooo`00703oool00`000000oooo0?ooo`3R0?ooo`03
0000003oool0oooo06`0oooo000L0?ooo`030000003oool0oooo0>80oooo1@00001Z0?ooo`00703o
ool00`000000oooo0?ooo`3R0?ooo`D00000JP3oool001`0oooo00<00000@000003oool0hP3oool5
000006X0oooo000L0?ooo`030000003oool0oooo0>80oooo1@00001Z0?ooo`00703oool00`000000
oooo0?ooo`3S0?ooo`<0000000<0oooo0000003oool0J03oool001`0oooo00<000000?ooo`3oool0
j03oool00`000000oooo0?ooo`1V0?ooo`00703oool00`000000oooo0?ooo`3Y0?ooo`030000003o
ool0oooo06D0oooo000L0?ooo`030000003oool0oooo0>X0oooo0P00001U0?ooo`00703oool00`00
001000000?ooo`3/0?ooo`030000003oool0oooo0680oooo000L0?ooo`030000003oool0oooo0>d0
oooo00<000000?ooo`3oool0H@3oool001`0oooo00<000000?ooo`3oool0kP3oool00`000000oooo
0?ooo`1P0?ooo`00703oool00`000000oooo0?ooo`3_0?ooo`030000003oool0oooo05l0oooo000@
0?ooo`=000000P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo0?00oooo00<00000
0?ooo`3oool0GP3oool00140oooo00I000000?ooo`3ooom000000?oood0000050?ooo`030000003o
ool0oooo0?00oooo1@00001L0?ooo`003`3oool4@00000040?oood000000oooo@00000D0oooo0P00
00000d000000oooo0?ooo`3^0?ooo`D00000G03oool000l0oooo00=000000?oood0000000P3oool0
0d000000oooo@00000050?ooo`030000003oool0oooo0?00oooo1@00001L0?ooo`00403oool2@000
0080oooo00=000000?oood0000001@3oool00`000000oooo0?ooo`3`0?ooo`D00000G03oool00140
oooo00E000000?ooo`3oool0oooo@00000060?ooo`030000003oool0oooo0?40oooo0`0000000`3o
ool000000?ooo`1J0?ooo`00703oool00`000000oooo0?ooo`3f0?ooo`030000003oool0oooo05P0
oooo000L0?ooo`030000003oool0oooo0?L0oooo00<000000?ooo`3oool0E`3oool001`0oooo00<0
0000@000003oool0n03oool00`000000oooo0?ooo`1F0?ooo`00703oool00`000000oooo0?ooo`3i
0?ooo`030000003oool0oooo05D0oooo000L0?ooo`030000003oool0oooo0?X0oooo00<000000?oo
o`3oool0E03oool001`0oooo00<000000?ooo`3oool0n`3oool00`000000oooo0?ooo`1C0?ooo`00
703oool00`000000oooo0?ooo`3l0?ooo`030000003oool0oooo0580oooo000L0?ooo`030000003o
ool0oooo0?d0oooo00<000000?ooo`3oool0D@3oool001`0oooo00<00000@000003oool0oP3oool2
00000540oooo000L0?ooo`030000003oool0oooo0?h0oooo1@00001>0?ooo`00703oool00`000000
oooo0?ooo`3n0?ooo`D00000CP3oool001`0oooo00<000000?ooo`3oool0oP3oool5000004h0oooo
000L0?ooo`030000003oool0oooo0?h0oooo1P00001=0?ooo`00703oool00`000000oooo0?ooo`3o
0?ooo`<000000P3oool00`000000oooo0?ooo`1:0?ooo`00703oool00`00001000000?ooo`3o0?oo
o`H0oooo00<000000?ooo`3oool0B@3oool001`0oooo00<000000?ooo`3oool0o`3oool70?ooo`03
0000003oool0oooo04P0oooo000L0?ooo`030000003oool0oooo0?l0oooo203oool00`000000oooo
0?ooo`170?ooo`00703oool00`000000oooo0?ooo`3o0?ooo`T0oooo00<000000?ooo`3oool0AP3o
ool001`0oooo00<000000?ooo`3oool0o`3oool:0?ooo`030000003oool0oooo04D0oooo000L0?oo
o`030000003oool0oooo0?l0oooo2`3oool00`000000oooo0?ooo`140?ooo`00703oool00`000010
00000?ooo`3o0?ooo``0oooo00<000000?ooo`3oool0@`3oool001`0oooo00<000000?ooo`3oool0
o`3oool=0?ooo`030000003oool0oooo0480oooo000L0?ooo`030000003oool0oooo0?l0oooo3P3o
ool00`000000oooo0?ooo`110?ooo`00703oool00`000000oooo0?ooo`3o0?ooo`h0oooo1@00000o
0?ooo`00403oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00@0oooo00<000000?oo
o`3oool0o`3oool>0?ooo`D00000?`3oool000l0oooo00=000000?oood0000000P3oool00d000000
oooo@00000050?ooo`030000003oool0oooo0?l0oooo3P3oool5000003l0oooo000A0?ooo`06@000
003oool0oooo@000003ooom000001@3oool200000003@000003oool0oooo0?l0oooo303oool60000
03h0oooo000?0?ooo`9000000`3oool00d000000oooo@00000050?ooo`030000003oool0oooo0?l0
oooo3`3oool300000080oooo00<000000?ooo`3oool0>`3oool000l0oooo00=000000?ooo`3oool0
0P3oool00d000000oooo@00000050?ooo`030000003oool0oooo0?l0oooo5@3oool00`000000oooo
0?ooo`0j0?ooo`003`3oool3@00000<0oooo00=000000?ooo`3oool0103oool00`000000oooo0?oo
o`3o0?oooaH0oooo00<000000?ooo`3oool0>@3oool001`0oooo00<000000?ooo`3oool0o`3ooolG
0?ooo`030000003oool0oooo03P0oooo000L0?ooo`03000004000000oooo0?l0oooo603oool00`00
0000oooo0?ooo`0g0?ooo`00703oool00`000000oooo0?ooo`3o0?oooaT0oooo00<000000?ooo`3o
ool0=P3oool001`0oooo00<000000?ooo`3oool0o`3ooolJ0?ooo`030000003oool0oooo03D0oooo
000L0?ooo`030000003oool0oooo0?l0oooo6`3oool00`000000oooo0?ooo`0d0?ooo`00703oool0
0`000000oooo0?ooo`3o0?oooa`0oooo00<000000?ooo`3oool0<`3oool001`0oooo00<000000?oo
o`3oool0o`3ooolM0?ooo`030000003oool0oooo0380oooo000L0?ooo`03000004000000oooo0?l0
oooo7P3oool00`000000oooo0?ooo`0a0?ooo`00703oool00`000000oooo0?ooo`3o0?oooah0oooo
1@00000_0?ooo`00703oool00`000000oooo0?ooo`3o0?oooah0oooo1@00000_0?ooo`00703oool0
0`000000oooo0?ooo`3o0?oooah0oooo1@00000_0?ooo`00703oool00`000000oooo0?ooo`3o0?oo
oah0oooo1@00000_0?ooo`00703oool00`000000oooo0?ooo`3o0?oooal0oooo0`0000000`3oool0
00000?ooo`0]0?ooo`00703oool00`00001000000?ooo`3o0?ooob@0oooo00<000000?ooo`3oool0
:`3oool001`0oooo00<000000?ooo`3oool0o`3ooolU0?ooo`030000003oool0oooo02X0oooo000L
0?ooo`030000003oool0oooo0?l0oooo9P3oool2000002X0oooo000L0?ooo`030000003oool0oooo
0?l0oooo:03oool00`000000oooo0?ooo`0W0?ooo`00703oool00`000000oooo0?ooo`3o0?ooobT0
oooo00<000000?ooo`3oool09P3oool001`0oooo00<000000?ooo`3oool0o`3ooolZ0?ooo`030000
003oool0oooo02D0oooo000L0?ooo`03000004000000oooo0?l0oooo:`3oool00`000000oooo0?oo
o`0T0?ooo`00703oool00`000000oooo0?ooo`3o0?ooob`0oooo00<000000?ooo`3oool08`3oool0
01`0oooo00<000000?ooo`3oool0o`3oool]0?ooo`030000003oool0oooo0280oooo000L0?ooo`03
0000003oool0oooo0?l0oooo;P3oool00`000000oooo0?ooo`0Q0?ooo`003`3oool2@00000@0oooo
00=000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?ooobl0oooo00<000000?ooo`3oool0
803oool000l0oooo00=000000?oood0000000P3oool00d000000oooo@00000050?ooo`030000003o
ool0oooo0?l0oooo;`3oool5000001h0oooo000?0?ooo`03@000003ooom000000080oooo00=00000
0?oood0000001@3oool200000003@000003oool0oooo0?l0oooo;@3oool5000001h0oooo000?0?oo
o`9000000`3oool00d000000oooo@00000050?ooo`030000003oool0oooo0?l0oooo;`3oool50000
01h0oooo000?0?ooo`03@000003oool0oooo0080oooo00=000000?oood0000001@3oool00`000000
oooo0?ooo`3o0?ooobl0oooo1@00000N0?ooo`00403oool2@00000<0oooo00=000000?ooo`3oool0
103oool00`000000oooo0?ooo`3o0?oooc00oooo0`00000O0?ooo`00703oool00`000000oooo0?oo
o`3o0?oooe80oooo000L0?ooo`030000003oool0oooo0?l0ooooDP3oool001`0oooo00<00000@000
003oool0o`3ooomB0?ooo`00703oool00`000000oooo0?ooo`3o0?oooe80oooo000L0?ooo`030000
003oool0oooo0?l0ooooDP3oool001`0oooo00<000000?ooo`3oool0o`3ooomB0?ooo`00703oool0
0`000000oooo0?ooo`3o0?oooe80oooo000L0?ooo`030000003oool0oooo0?l0ooooDP3oool001`0
oooo00<00000@000003oool0o`3ooomB0?ooo`00703oool00`000000oooo0?ooo`3o0?oooe80oooo
000L0?ooo`030000003oool0oooo0?l0ooooDP3oool001`0oooo00=000000?ooo`3oool0o`3ooomB
0?ooo`00o`3oooma0?ooo`00o`3oooma0?ooo`00o`3oooma0?ooo`00o`3oooma0?ooo`00o`3oooma
0?ooo`00o`3oooma0?ooo`00o`3oooma0?ooo`00o`3oooma0?ooo`00o`3oooma0?ooo`00o`3oooma
0?ooo`00o`3oooma0?ooo`00o`3oooma0?ooo`006P3oool3@0000?l0ooooE03oool001X0oooo00=0
00000?ooo`3oool0o`3ooomD0?ooo`006P3oool00d000000oooo0?ooo`3o0?oooe@0oooo000J0?oo
o`=00000o`3ooomD0?ooo`00o`3oooma0?ooo`00o`3oooma0?ooo`00o`3oooma0?ooo`00o`3oooma
0?ooo`00o`3oooma0?ooo`00o`3oooma0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 367.875}, {226.938, 0}} -> {10.8858, -4.37258, 
  0.323024, 0.339731}}],

Cell[OutputFormData["\<\
Graphics[{{Thickness[0.005499999999999999], 
    RGBColor[0, 0, 0], 
    {Line[{{6.25*^-6, 0.}, 
       {6.085048735937368, 0.}, 
       {12.72131997890605, 0.}, 
       {18.95390495078078, 0.}, 
       {22.09232880960876, 0.}, 
       {23.46153288746221, 0.}, 
       {24.9477611656242, 0.}, 
       {25.34771217226902, 0.}, 
       {25.77170555209497, 0.}, 
       {26.13368730833881, 0.}, 
       {26.33954405097998, 0.}, 
       {26.53239348615709, 
        1.472843707337306*^-15}, 
       {26.72559744613692, 
        -1.807371215222169*^-15}, 
       {26.90925589934318, 
        -3.03412349302282*^-16}, 
       {27.07411050134739, 
        -5.702196236324655*^-16}, 
       {27.25405683700358, 
        7.175088048082328*^-16}, 
       {27.44890433660676, 
        6.272425609982472*^-17}, 
       {27.65662018057958, 
        2.180931769935916*^-15}, 
       {27.85263348958237, 4.66190909496861*^-16}, 
       {28.0303576960635, 1.516910496918646*^-15}, 
       {28.23692879931455, 
        8.315329172206251*^-16}, 
       {28.340966354427, 1.446627909573856*^-15}, 
       {28.45516402840989, 
        2.877534495326985*^-15}, 
       {28.65729698237575, 
        9.789176931596008*^-15}, 
       {28.8460061189211, 1.399788904327661*^-14}, 
       {28.96038781586089, 
        1.980192731754184*^-14}, 
       {29.0687442279715, 2.790165067060038*^-14}, 
       {29.27183083155736, 4.76433336489721*^-14}, 
       {29.38540180029162, 
        6.562845486447256*^-14}, 
       {29.49047739204186, 
        9.072424373619043*^-14}, 
       {29.60493357483936, 
        1.197622075473901*^-13}, 
       {29.72831801399244, 
        1.660861728191217*^-13}, 
       {29.91846717889671, 
        2.733184791154947*^-13}, 
       {30.09698151528991, 
        4.330715077229696*^-13}, 
       {30.2003945745426, 5.646127478734392*^-13}, 
       {30.30927099295657, 
        7.418177085628006*^-13}, 
       {30.50391467709074, 
        1.206729866038242*^-12}, 
       {30.70776937324557, 
        1.991478696873633*^-12}, 
       {30.89743074086634, 3.15055975146014*^-12}, 
       {31.10555060068824, 
        5.173472772848322*^-12}, 
       {31.22204142564697, 
        6.807161324900836*^-12}, 
       {31.32788862343631, 
        8.714036557293386*^-12}, 
       {31.51575757500997, 
        1.343701379145308*^-11}, 
       {31.69152416380164, 2.0043034496057*^-11}, 
       {31.88436079872453, 
        3.088255465127896*^-11}, 
       {32.09152412321898, 
        4.878822023557289*^-11}, 
       {32.19521276482838, 
        6.116827963879823*^-11}, 
       {32.30824457835035, 
        7.810790458030462*^-11}, 
       {32.51398663894383, 
        1.212232550075321*^-10}, 
       {32.71428658006874, 
        1.847249233033765*^-10}, 
       {32.89999908380906, 
        2.714197318299822*^-10}, 
       {33.08983663363979, 
        3.999532344601543*^-10}, 
       {33.26843855957508, 
        5.730313558366298*^-10}, 
       {33.42881004626834, 
        7.881182724641599*^-10}, 
       {33.6020603801607, 1.107167706606274*^-9}, 
       {33.79160535469256, 1.59765088896248*^-9}, 
       {33.99158960861586, 2.33897773924512*^-9}, 
       {34.16233258277908, 3.223787253135661*^-9}, 
       {34.34950308160524, 4.560681442945837*^-9}, 
       {34.45503636668459, 5.533883156996949*^-9}, 
       {34.56968278776233, 6.815793115775894*^-9}, 
       {34.77798966042974, 9.906118766550484*^-9}, 
       {34.98078173259405, 1.417490217658023*^-8}, 
       {35.16815743221131, 1.964140481045493*^-8}, 
       {35.37043507416039, 2.778593863487024*^-8}, 
       {35.5934162003472, 4.047757983970182*^-8}, 
       {35.70555348362387, 4.879042730691218*^-8}, 
       {35.82627898856175, 5.955142030412567*^-8}, 
       {36.04460568723244, 8.499817963023602*^-8}, 
       {36.23680280115086, 1.156944224817159*^-7}, 
       {36.44676571264997, 1.611971361305862*^-7}, 
       {36.66595510000743, 2.26610959994792*^-7}, 
       {36.86961502566619, 3.093967624723096*^-7}, 
       {37.06122891320678, 4.128947013099014*^-7}, 
       {37.23510583956632, 5.345400228848879*^-7}, 
       {37.43581718115585, 7.17104874907905*^-7}, 
       {37.62505207108973, 9.421135613371921*^-7}, 
       {37.80749868723292, 1.221109016099757*^-6}, 
       {38.00324206521755, 1.606476012060427*^-6}, 
       {38.18800473424867, 2.073389003308222*^-6}, 
       {38.35660367072775, 2.608735609424176*^-6}, 
       {38.55411215460097, 3.401344651696115*^-6}, 
       {38.76913414466498, 4.519741723488918*^-6}, 
       {38.97221181654879, 5.886492701047039*^-6}, 
       {39.16025185303354, 7.490556870321852*^-6}, 
       {39.53404595119432, 
        0.00001197024737776002}, 
       {39.74694437655653, 
        0.00001554031562829897}, 
       {39.94697872802698, 
        0.00001978246575321765}, 
       {40.34934791617482, 
        0.00003178876278773535}, 
       {40.57572663543884, 
        0.00004124530190805505}, 
       {40.78345758844243, 
        0.00005217035552683912}, 
       {41.13352326569279, 
        0.00007686150960604888}, 
       {41.45948097120411, 0.0001092271002908163}, 
       {41.8171521777425, 0.000158997212847913}, 
       {42.01743659147071, 0.0001953093468720322}, 
       {42.19956962039119, 0.0002348287186492003}, 
       {42.56756080476766, 0.0003380581109837504}, 
       {42.96680274117568, 0.0004960897464876545}, 
       {43.34381560418657, 0.0007048596692787074}, 
       {43.69170902264711, 0.0009657718725895602}, 
       {44.07538629778448, 0.001353284318795985}, 
       {44.42624562281521, 0.001825992486398197}, 
       {44.8312222339674, 0.002553870141760242}, 
       {45.21599689667342, 0.003477772697656589}, 
       {45.57004142935998, 0.00458210412578694}, 
       {45.89856900099409, 0.005877097346292408}, 
       {46.25910209331361, 0.007664984968967891}, 
       {46.64325264980905, 0.01008629726524562}, 
       {47.06509798857766, 0.01350174240423757}, 
       {47.52119142302456, 0.01830032691593574}, 
       {47.95183145880921, 0.02413525413933448}, 
       {48.34784144188325, 0.03086256157631517}, 
       {49.09920938544846, 0.04814179051475564}, 
       {49.47753806481721, 0.05959376648522751}, 
       {49.89260456248422, 0.07473142333829474}, 
       {50.71901337903879, 0.1145802311176598}, 
       {51.50149587014049, 0.1671208578247611}, 
       {52.20395765923719, 0.2295804730561759}, 
       {52.96770105939369, 0.3173050935711279}, 
       {53.79795836038097, 0.4403359777279778}, 
       {54.67955884465585, 0.6076933301707381}, 
       {56.26256874685161, 1.01935413293101}, 
       {57.7398751722377, 1.549948654486055}, 
       {59.3316190256906, 2.292183443681977}, 
       {62.21143163199978, 4.074110648402118}, 
       {68.69410824605401, 9.574835855661305}, 
       {74.93805610307691, 15.66900228776939}, 
       {80.94327520306851, 21.66000511948633}, 
       {87.33476554602878, 28.05050415424174}, 
       {93.48752713195775, 34.20322578249336}, 
       {100.0265599608554, 40.74225722053737}, 
       {106.3268640327217, 47.04256126167416}, 
       {112.3884393475567, 53.10413657585542}, 
       {118.8362859053604, 59.55198313364483}, 
       {125.0454037061328, 65.761100934417}, 
       {131.0157927498738, 71.73148997815806}, 
       {137.3724530365836, 78.0881502648678}, 
       {143.490384566262, 84.20608179454623}, 
       {149.9945873389091, 90.71028456719336}, 
       {149.9999937499999, 90.71569097828415}}]}}, 
   {PointSize[0.02], RGBColor[0., 0., 0], 
    {Point[{23.99999999999999, 0}], 
     Point[{25.12512563944476, 
       4.653156322216904*^-9}], 
     Point[{26.30299743324521, 
       1.746918129166563*^-8}], 
     Point[{27.53608813351164, 
       6.051170284514385*^-8}], 
     Point[{28.82698641555434, 
       2.05970180689912*^-7}], 
     Point[{30.17840231239044, 
       6.915211124885779*^-7}], 
     Point[{31.5931729040217, 
       2.288407341384316*^-6}], 
     Point[{33.07426827342697, 
       7.455341817513447*^-6}], 
     Point[{34.62479774177312, 
       0.00002387805002375405}], 
     Point[{36.24801639593388, 
       0.00007506256512510094}], 
     Point[{37.94733192202054, 
       0.0002311653769606277}], 
     Point[{39.72631175926998, 
       0.0006958843626868855}], 
     Point[{41.58869058930878, 
       0.002042346107353692}], 
     Point[{43.53837817651573, 
       0.005825570964326775}], 
     Point[{45.57946757594242, 
       0.01608850623039115}], 
     Point[{47.71624372602303, 
       0.04281911423704261}], 
     Point[{49.95319244411239, 
       0.1091910232294245}], 
     Point[{52.29500984373696, 
       0.2648421248933796}], 
     Point[{54.74661219332885, 0.605312534375919}], 
     Point[{57.31314623713943, 1.288089897346106}], 
     Point[{60, 2.513384843463199}], 
     Point[{62.81281409861192, 4.416825795222842}], 
     Point[{65.75749358311303, 6.875445691814836}], 
     Point[{68.84022033377911, 9.725830917591023}], 
     Point[{72.06746603888587, 12.85109075352019}], 
     Point[{75.44600578097612, 16.18778425919134}], 
     Point[{78.98293226005423, 19.70846070573988}], 
     Point[{82.68567068356743, 23.40517390499741}], 
     Point[{86.5619943544328, 27.27935028487546}], 
     Point[{90.62004098983473, 31.33665614722551}], 
     Point[{94.86832980505138, 35.58469260392366}], 
     Point[{99.31577939817497, 40.03204936141746}], 
     Point[{103.9717264732719, 44.68794931990354}], 
     Point[{108.8459454412893, 49.56214232292457}], 
     Point[{113.948668939856, 54.66484889136372}], 
     Point[{119.2906093150576, 60.00677110694763}], 
     Point[{124.8829811102809, 65.59911396472354}], 
     Point[{130.7375246093424, 71.45360794033767}], 
     Point[{136.8665304833221, 77.58253295276526}], 
     Point[{143.2828655928486, 83.99874381745734}], 
     Point[{150., 90.71569722828417}]}}}, 
  {AxesLabel -> {\"S\", \"c\"}, 
   DisplayFunction -> (Display[$Display, #1] & ), 
   PlotRange -> {{20, 120}, {0, 65}}, 
   PlotRange -> All, AspectRatio -> 
    GoldenRatio^(-1), DisplayFunction :> Identity, 
   ColorOutput -> Automatic, Axes -> Automatic, 
   AxesOrigin -> Automatic, PlotLabel -> None, 
   AxesLabel -> None, Ticks -> Automatic, 
   GridLines -> None, Prolog -> {}, Epilog -> {}, 
   AxesStyle -> Automatic, Background -> Automatic, 
   DefaultColor -> Automatic, 
   DefaultFont :> $DefaultFont, RotateLabel -> True, 
   Frame -> False, FrameStyle -> Automatic, 
   FrameTicks -> Automatic, FrameLabel -> None, 
   PlotRegion -> Automatic, ImageSize -> Automatic, 
   TextStyle :> $TextStyle, 
   FormatType :> $FormatType}]\
\>", "\<\
-Graphics-\
\>"], "Output"]
}, Open  ]],

Cell[TextData[
"\"Eur\[OAcute]pska call opcia s transak\[CHacek]n\[YAcute]mi \
n\[AAcute]kladmi"], "Text"],

Cell[CellGroupData[{

Cell["\<\
X=60;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=20;
n=30;
Slarge=150;
trans=0.02;
time=0.03;
str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]];

EuroCall[X,sigma,r,DD,t,m,n,trans,time];

Payoff[S_]:=Max[S-X,0];

g=Plot[BlackScholes[S,X,str,r,t],{S,0,150},PlotRange->All,PlotStyle->{\
Thickness[0.005],RGBColor[0,0,0]}, DisplayFunction->Identity];
g1=ListPlot[grf[n],PlotStyle->{PointSize[0.02],RGBColor[0.,0.,0]},\
DisplayFunction->Identity];
g2=Plot[Payoff[S],{S,0,150},PlotRange->All,PlotStyle->Thickness[0.002], \
DisplayFunction->Identity];

Show[g2,g,g1,AxesLabel -> \
{\"S\",\"c\"},DisplayFunction->$DisplayFunction,PlotRange->{{20,120},{0,65}}]
\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.2 0.01 0 0.00950822 [
[.2 -0.0125 -6 -9 ]
[.2 -0.0125 6 0 ]
[.4 -0.0125 -6 -9 ]
[.4 -0.0125 6 0 ]
[.6 -0.0125 -6 -9 ]
[.6 -0.0125 6 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .09508 -12 -4.5 ]
[-0.0125 .09508 0 4.5 ]
[-0.0125 .19016 -12 -4.5 ]
[-0.0125 .19016 0 4.5 ]
[-0.0125 .28525 -12 -4.5 ]
[-0.0125 .28525 0 4.5 ]
[-0.0125 .38033 -12 -4.5 ]
[-0.0125 .38033 0 4.5 ]
[-0.0125 .47541 -12 -4.5 ]
[-0.0125 .47541 0 4.5 ]
[-0.0125 .57049 -12 -4.5 ]
[-0.0125 .57049 0 4.5 ]
[0 .64303 -5 0 ]
[0 .64303 5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2 0 m
.2 .00625 L
s
[(40)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(60)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(80)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(100)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(120)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .09508 m
.00625 .09508 L
s
[(10)] -0.0125 .09508 1 0 Mshowa
0 .19016 m
.00625 .19016 L
s
[(20)] -0.0125 .19016 1 0 Mshowa
0 .28525 m
.00625 .28525 L
s
[(30)] -0.0125 .28525 1 0 Mshowa
0 .38033 m
.00625 .38033 L
s
[(40)] -0.0125 .38033 1 0 Mshowa
0 .47541 m
.00625 .47541 L
s
[(50)] -0.0125 .47541 1 0 Mshowa
0 .57049 m
.00625 .57049 L
s
[(60)] -0.0125 .57049 1 0 Mshowa
.125 Mabswid
0 .01902 m
.00375 .01902 L
s
0 .03803 m
.00375 .03803 L
s
0 .05705 m
.00375 .05705 L
s
0 .07607 m
.00375 .07607 L
s
0 .1141 m
.00375 .1141 L
s
0 .13312 m
.00375 .13312 L
s
0 .15213 m
.00375 .15213 L
s
0 .17115 m
.00375 .17115 L
s
0 .20918 m
.00375 .20918 L
s
0 .2282 m
.00375 .2282 L
s
0 .24721 m
.00375 .24721 L
s
0 .26623 m
.00375 .26623 L
s
0 .30426 m
.00375 .30426 L
s
0 .32328 m
.00375 .32328 L
s
0 .3423 m
.00375 .3423 L
s
0 .36131 m
.00375 .36131 L
s
0 .39935 m
.00375 .39935 L
s
0 .41836 m
.00375 .41836 L
s
0 .43738 m
.00375 .43738 L
s
0 .45639 m
.00375 .45639 L
s
0 .49443 m
.00375 .49443 L
s
0 .51344 m
.00375 .51344 L
s
0 .53246 m
.00375 .53246 L
s
0 .55148 m
.00375 .55148 L
s
0 .58951 m
.00375 .58951 L
s
0 .60853 m
.00375 .60853 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.002 w
.04948 0 m
.11328 0 L
.17469 0 L
.23997 0 L
.30286 0 L
.36336 0 L
.37949 0 L
.38738 0 L
.3946 0 L
.39647 0 L
.3985 0 L
.40042 .0004 L
.4022 .00209 L
.41037 .00986 L
.42773 .02636 L
.48936 .08496 L
.55485 .14723 L
.61795 .20723 L
.67867 .26496 L
.74325 .32637 L
.80544 .3855 L
.86525 .44237 L
.92892 .5029 L
.9902 .56117 L
s
.9902 .56117 m
1 .57049 L
s
0 0 0 r
.005 w
.02092 0 m
.03462 0 L
.04948 0 L
.05348 0 L
.05772 0 L
.06134 0 L
.0634 0 L
.06532 0 L
s
.06532 0 m
.06619 0 L
s
.07154 0 m
.07254 0 L
.07449 0 L
.07657 0 L
.07853 0 L
.0803 0 L
.08237 0 L
.08341 0 L
.08455 0 L
.08657 0 L
.08846 0 L
.0896 0 L
.09069 0 L
.09272 0 L
.09385 0 L
.0949 0 L
.09605 0 L
.09728 0 L
.09918 0 L
.10097 0 L
.102 0 L
.10309 0 L
.10504 0 L
.10708 0 L
.10897 0 L
.11106 0 L
.11222 0 L
.11328 0 L
.11516 0 L
.11692 0 L
.11884 0 L
.12092 0 L
.12195 0 L
.12308 0 L
.12514 0 L
.12714 0 L
.129 0 L
.1309 0 L
.13268 0 L
.13429 0 L
.13602 0 L
.13792 0 L
.13992 0 L
.14162 0 L
.1435 0 L
.14455 0 L
.1457 0 L
.14778 0 L
.14981 0 L
.15168 0 L
Mistroke
.1537 0 L
.15593 0 L
.15706 0 L
.15826 0 L
.16045 0 L
.16237 0 L
.16447 0 L
.16666 0 L
.1687 0 L
.17061 0 L
.17235 0 L
.17436 0 L
.17625 0 L
.17807 0 L
.18003 0 L
.18188 0 L
.18357 0 L
.18554 0 L
.18769 0 L
.18972 0 L
.1916 0 L
.19534 0 L
.19747 0 L
.19947 0 L
.20349 0 L
.20576 0 L
.20783 0 L
.21134 0 L
.21459 0 L
.21817 0 L
.22017 0 L
.222 0 L
.22568 0 L
.22967 0 L
.23344 1e-005 L
.23692 1e-005 L
.24075 1e-005 L
.24426 2e-005 L
.24831 2e-005 L
.25216 3e-005 L
.2557 4e-005 L
.25899 6e-005 L
.26259 7e-005 L
.26643 .0001 L
.27065 .00013 L
.27521 .00017 L
.27952 .00023 L
.28348 .00029 L
.29099 .00046 L
.29478 .00057 L
Mistroke
.29893 .00071 L
.30719 .00109 L
.31501 .00159 L
.32204 .00218 L
.32968 .00302 L
.33798 .00419 L
.3468 .00578 L
.36263 .00969 L
.3774 .01474 L
.39332 .02179 L
.42211 .03874 L
.48694 .09104 L
.54938 .14898 L
.60943 .20595 L
.67335 .26671 L
.73488 .32521 L
.80027 .38739 L
.86327 .44729 L
.92388 .50493 L
.98836 .56623 L
Mfstroke
.98836 .56623 m
1 .5773 L
s
.02 w
.04 0 Mdot
.05125 0 Mdot
.06303 0 Mdot
.07536 0 Mdot
.08827 0 Mdot
.10178 0 Mdot
.11593 0 Mdot
.13074 0 Mdot
.14625 0 Mdot
.16248 0 Mdot
.17947 0 Mdot
.19726 0 Mdot
.21589 1e-005 Mdot
.23538 4e-005 Mdot
.25579 .00012 Mdot
.27716 .00035 Mdot
.29953 .00096 Mdot
.32295 .00243 Mdot
.34747 .00572 Mdot
.37313 .01236 Mdot
.4 .02415 Mdot
.42813 .04211 Mdot
.45757 .06536 Mdot
.4884 .09242 Mdot
.52067 .12214 Mdot
.55446 .15388 Mdot
.58983 .18737 Mdot
.62686 .22253 Mdot
.66562 .25937 Mdot
.7062 .29795 Mdot
.74868 .33835 Mdot
.79316 .38063 Mdot
.83972 .4249 Mdot
.88846 .47125 Mdot
.93949 .51976 Mdot
.99291 .57056 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00AP3oool3@0000080oooo00=000000?ooo`3oool09@3oool2@00000@0oooo00=000000?oo
o`3oool09`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0280oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0803oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool05@3oool004L0oooo00I000000?ooo`3ooom000000?oood00
000V0?ooo`03@000003ooom000000080oooo00=000000?oood0000009`3oool00d000000oooo@000
00020?ooo`03@000003ooom0000002D0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood0000008`3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oo
od0000005P3oool004D0oooo14000000103ooom000000?oood00000V0?ooo`03@000003ooom00000
0080oooo00=000000?oood0000009`3oool00d000000oooo@00000020?ooo`03@000003ooom00000
02D0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood0000008`3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000F0?ooo`00
A@3oool00d000000oooo@00000020?ooo`03@000003ooom0000002H0oooo0T0000030?ooo`03@000
003ooom0000002P0oooo00M000000?ooo`3oool0oooo@000003ooom0000002D0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood0000008`3oool00d000000oooo0?oo
o`020?ooo`07@000003oool0oooo0?oood000000oooo@000000F0?ooo`00AP3oool2@0000080oooo
00=000000?oood0000009P3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000002L0oooo
00=000000?oood0000000P3oool00d000000oooo@000000U0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000020?ooo`03@000003ooom0000002<0oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood0000005P3oool004L0oooo00E000000?ooo`3oool0oooo@000
000X0?ooo`9000000`3oool00d000000oooo0?ooo`0W0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool08`3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`0Q0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01D0oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooo`d0oooo0d00000A0?ooo`006P3o
oooY00000003@000003oool0oooo00H0oooo00=000000?oood0000004@3oool001X0oooo00<00000
0?ooo`3oool0103ooolE000000030?ooo`000000000000@0000000E0000000000000000000000?oo
o`03000000030?ooo`000000000000D000000P3oool300000080oooo0`0000000`3oool000000000
000@00000080oooo00=000000?ooo`3oool0203oool2000000X0oooo00=000000?ooo`3oool02@3o
ool00d000000oooo0?ooo`080?ooo`03@000003oool0oooo00T0oooo00<000000?ooo`3oool02@3o
ool00d000000oooo0?ooo`080?ooo`03@000003oool0oooo00T0oooo00=000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`080?ooo`03@000003oool0oooo00T0oooo00=000000?ooo`3oool02@3o
ool00d000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00=000000?ooo`3oool03`3o
ool001X0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`090000003oool0oooo0?ooo`000000oooo
@000003oool0000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`04
0000003oool0oooo0?ooo`<000000P3oool3000000<0oooo1000000:0?ooo`03@000003oool00000
02`0oooo00=000000?ooo`3oool0;03oool00d000000oooo0?ooo`0[0?ooo`03@000003oool0oooo
00L0oooo00=000000?ooo`3oool0403oool001X0oooo00<000000?ooo`3oool0@P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0`0000000`3oool0000000000003000000P0
oooo00<000000?ooo`3oool0S`3oool00d000000oooo@000000A0?ooo`006P3oool00`000000oooo
0?ooo`1=0?ooo`030000003oool0oooo0080oooo100000080?ooo`030000003oool0oooo08h0oooo
0d00000A0?ooo`006P3oool00`00001000000?ooo`1C0?ooo`030000003oool0oooo008000001`3o
ool00`000000oooo0?ooo`2Q0?ooo`006P3oool00`000000oooo0?ooo`1H0?ooo`<000001@3oool0
0`000000oooo0?ooo`2P0?ooo`006P3oool00`000000oooo0?ooo`1H0?ooo`@000001@3oool00`00
0000oooo0?ooo`2O0?ooo`006P3oool00`000000oooo0?ooo`1I0?ooo`040000003oool0oooo0000
00D0oooo00<000000?ooo`3oool0WP3oool001X0oooo00<00000@000003oool0G@3oool2000000@0
oooo00<000000?ooo`3oool0W@3oool001X0oooo00<000000?ooo`3oool0G`3oool300000080oooo
00<000000?ooo`3oool0W03oool001X0oooo00<000000?ooo`3oool0G`3oool3000000<0oooo00<0
00000?ooo`3oool0V`3oool001X0oooo00<000000?ooo`3oool0H03oool3000000<0oooo00<00000
0?ooo`3oool0VP3oool001X0oooo00<000000?ooo`3oool0H`3oool01@000000oooo0?ooo`3oool0
000009/0oooo000J0?ooo`03000004000000oooo06@0oooo00@000000?ooo`3oool0oooo0P00002I
0?ooo`006P3oool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0UP3oool001X0oooo00<000000?ooo`3oool0IP3oool300000080oooo00<000000?ooo`3o
ool0U@3oool001X0oooo00<000000?ooo`3oool0IP3oool3000000<0oooo00<000000?ooo`3oool0
U03oool001X0oooo00<00000@000003oool0I`3oool00`000000oooo000000030?ooo`030000003o
ool0oooo09<0oooo000J0?ooo`030000003oool0oooo06X0oooo00D000000?ooo`3oool0oooo0000
002D0?ooo`006P3oool00`000000oooo0?ooo`1[0?ooo`8000000P3oool00`000000oooo0?ooo`2A
0?ooo`003@3oool5@0000080oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`1]0?oo
o`040000003oool0oooo00000980oooo000?0?ooo`07@000003oool0oooo0?oood000000oooo@000
00040?ooo`030000003oool0oooo06d0oooo0`0000000`3oool000000?ooo`2@0?ooo`003`3oool0
1d000000oooo0?ooo`3ooom000000?oood000000103oool00`00001000000?ooo`1]0?ooo`<00000
0P3oool00`000000oooo0?ooo`2>0?ooo`003`3oool01d000000oooo0?ooo`3ooom000000?oood00
0000103oool00`000000oooo0?ooo`1^0?ooo`030000003oool000000080oooo00<000000?ooo`3o
ool0S@3oool000l0oooo00M000000?ooo`3oool0oooo@000003ooom0000000@0oooo00<000000?oo
o`3oool0L@3oool2000000030?ooo`000000oooo08d0oooo000>0?ooo`900000103oool00d000000
oooo0?ooo`030?ooo`030000003oool0oooo07<0oooo00<000000?ooo`000000S@3oool001X0oooo
00<00000@000003oool0M03oool00`000000oooo0000002<0?ooo`006P3oool00`000000oooo0?oo
o`1e0?ooo`030000003oool0000008/0oooo000J0?ooo`030000003oool0oooo07D0oooo1000002:
0?ooo`006P3oool00`000000oooo0?ooo`1e0?ooo`<0000000<0oooo0000003oool0R03oool001X0
oooo00<000000?ooo`3oool0MP3oool01@000000oooo0000003oool0000008P0oooo000J0?ooo`03
000004000000oooo07T0oooo0`0000270?ooo`006P3oool00`000000oooo0?ooo`1k0?ooo`800000
QP3oool001X0oooo00<000000?ooo`3oool0O03oool2000008D0oooo000J0?ooo`030000003oool0
oooo07d0oooo0P0000240?ooo`006P3oool00`00001000000?ooo`1l0?ooo`@00000P`3oool001X0
oooo00<000000?ooo`3oool0O03oool500000880oooo000J0?ooo`030000003oool0oooo07d0oooo
00<000000?ooo`3oool00P0000210?ooo`006P3oool00`000000oooo0?ooo`210?ooo`800000P03o
ool001X0oooo00<00000@000003oool0PP3oool2000007l0oooo000J0?ooo`030000003oool0oooo
08<0oooo0P00001n0?ooo`006P3oool00`000000oooo0?ooo`240?ooo`<00000O03oool000h0oooo
0d0000030?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0Q@3oool00`000000oooo
0000001k0?ooo`003P3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000000@0oooo00<0
00000?ooo`3oool0Q@3oool4000007X0oooo000?0?ooo`07@000003oool0oooo0?oood000000oooo
@00000040?ooo`03000004000000oooo08D0oooo0`0000000`3oool000000?ooo`1h0?ooo`003`3o
ool01d000000oooo0?ooo`3ooom000000?oood000000103oool00`000000oooo0?ooo`260?ooo`05
0000003oool000000?ooo`000000N03oool000h0oooo00=000000?oood0000000P3oool00d000000
oooo@00000040?ooo`030000003oool0oooo08T0oooo00<000000?ooo`000000M`3oool000l0oooo
00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo08X0oooo
00<000000?ooo`000000MP3oool001X0oooo00<00000@000003oool0R`3oool00`000000oooo0000
001e0?ooo`006P3oool00`000000oooo0?ooo`2<0?ooo`030000003oool0000007@0oooo000J0?oo
o`030000003oool0oooo08d0oooo00<000000?ooo`000000L`3oool001X0oooo00<000000?ooo`3o
ool0S@3oool400000780oooo000J0?ooo`030000003oool0oooo08d0oooo0`0000000`3oool00000
0?ooo`1`0?ooo`006P3oool00`00001000000?ooo`2>0?ooo`050000003oool000000?ooo`000000
L03oool001X0oooo00<000000?ooo`3oool0T@3oool00`000000oooo0000001_0?ooo`006P3oool0
0`000000oooo0?ooo`2B0?ooo`@00000K@3oool001X0oooo00<000000?ooo`3oool0U03oool00`00
0000oooo0000001/0?ooo`006P3oool00`00001000000?ooo`2E0?ooo`030000003oool0000006/0
oooo000J0?ooo`030000003oool0oooo09H0oooo00<000000?ooo`000000JP3oool001X0oooo00<0
00000?ooo`3oool0U`3oool00`000000oooo0000001Y0?ooo`006P3oool00`000000oooo0?ooo`2F
0?ooo`<0000000<0oooo0000003oool0I`3oool001X0oooo00<000000?ooo`3oool0UP3oool40000
00030?ooo`000000oooo06H0oooo000J0?ooo`03000004000000oooo09L0oooo00H000000?ooo`3o
ool000000?ooo`00001V0?ooo`006P3oool00`000000oooo0?ooo`2K0?ooo`030000003oool00000
06D0oooo000>0?ooo`900000103oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo09`0
oooo00<000000?ooo`000000I03oool00100oooo00I000000?ooo`3ooom000000?oood0000040?oo
o`030000003oool0oooo09d0oooo00<000000?ooo`000000H`3oool000l0oooo00M000000?ooo`3o
ool0oooo@000003ooom0000000@0oooo00<00000@000003oool0WP3oool00`000000oooo0000001R
0?ooo`00403oool01T000000oooo0?oood000000oooo@00000@0oooo00<000000?ooo`3oool0W`3o
ool00`000000oooo0000001Q0?ooo`003P3oool00d000000oooo@00000020?ooo`03@000003ooom0
000000@0oooo00<000000?ooo`3oool0X03oool00`000000oooo0000001P0?ooo`003`3oool00d00
0000oooo0?ooo`020?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0X03oool40000
05l0oooo000J0?ooo`03000004000000oooo0:00oooo1@00001N0?ooo`006P3oool00`000000oooo
0?ooo`2Q0?ooo`030000003oool0oooo00800000G@3oool001X0oooo00<000000?ooo`3oool0Y@3o
ool2000005`0oooo000J0?ooo`030000003oool0oooo0:H0oooo0P00001K0?ooo`006P3oool00`00
0000oooo0?ooo`2W0?ooo`800000FP3oool001X0oooo00<00000@000003oool0Z03oool2000005T0
oooo000J0?ooo`030000003oool0oooo0:T0oooo0P00001H0?ooo`006P3oool00`000000oooo0?oo
o`2Z0?ooo`800000E`3oool001X0oooo00<000000?ooo`3oool0ZP3oool3000005H0oooo000J0?oo
o`03000004000000oooo0:X0oooo1@00001D0?ooo`006P3oool00`000000oooo0?ooo`2[0?ooo`05
0000003oool000000?ooo`000000D`3oool001X0oooo00<000000?ooo`3oool0[P3oool00`000000
oooo0000001B0?ooo`006P3oool00`000000oooo0?ooo`2_0?ooo`030000003oool000000540oooo
000J0?ooo`030000003oool0oooo0;00oooo0`00001@0?ooo`006P3oool00`00001000000?ooo`2b
0?ooo`800000C`3oool001X0oooo00<000000?ooo`3oool0/`3oool2000004h0oooo000?0?ooo`=0
00000P3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo0;@0oooo0`00001<0?ooo`00
403oool01T000000oooo0?oood000000oooo@00000@0oooo00<000000?ooo`3oool0]@3oool00`00
0000oooo0000001;0?ooo`003P3oool4@00000040?oood000000oooo@00000@0oooo00<00000@000
003oool0]03oool3000000030?ooo`000000oooo04T0oooo000>0?ooo`03@000003ooom000000080
oooo00=000000?oood000000103oool00`000000oooo0?ooo`2d0?ooo`@0000000<0oooo0000003o
ool0B03oool000l0oooo0T0000020?ooo`03@000003ooom0000000@0oooo00<000000?ooo`3oool0
]@3oool01P000000oooo0?ooo`000000oooo000004P0oooo000@0?ooo`05@000003oool0oooo0?oo
od0000001@3oool00`000000oooo0?ooo`2i0?ooo`030000003oool0000004L0oooo000J0?ooo`03
0000003oool0oooo0;X0oooo00<000000?ooo`000000AP3oool001X0oooo00<00000@000003oool0
^`3oool00`000000oooo000000150?ooo`006P3oool00`000000oooo0?ooo`2l0?ooo`030000003o
ool0000004@0oooo000J0?ooo`030000003oool0oooo0;d0oooo00<000000?ooo`000000@`3oool0
01X0oooo00<000000?ooo`3oool0_P3oool00`000000oooo000000120?ooo`006P3oool00`000010
00000?ooo`2o0?ooo`030000003oool000000440oooo000J0?ooo`030000003oool0oooo0;l0oooo
100000100?ooo`006P3oool00`000000oooo0?ooo`2o0?ooo`<0000000<0oooo0000003oool0?P3o
ool001X0oooo00<000000?ooo`3oool0`03oool01@000000oooo0000003oool0000003h0oooo000J
0?ooo`030000003oool0oooo0<<0oooo00<000000?ooo`000000?@3oool001X0oooo00<00000@000
003oool0a03oool00`000000oooo0000000l0?ooo`006P3oool00`000000oooo0?ooo`350?ooo`03
0000003oool0000003/0oooo000J0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`000000
>P3oool001X0oooo00<000000?ooo`3oool0a`3oool00`000000oooo0000000i0?ooo`006P3oool0
0`00001000000?ooo`380?ooo`030000003oool0000003P0oooo000J0?ooo`030000003oool0oooo
0<T0oooo00<000000?ooo`000000=`3oool000l0oooo00=000000?ooo`3oool00P3oool00d000000
oooo0?ooo`030?ooo`030000003oool0oooo0<X0oooo00<000000?ooo`000000=P3oool000h0oooo
00=000000?oood0000000P3oool00d000000oooo@00000040?ooo`030000003oool0oooo0<X0oooo
1000000e0?ooo`00403oool01T000000oooo0?oood000000oooo@00000@0oooo00<00000@000003o
ool0bP3oool3000000030?ooo`000000000003<0oooo000>0?ooo`9000000`3oool00d000000oooo
@00000040?ooo`030000003oool0oooo0</0oooo00H000000?ooo`00000000000?ooo`00000b0?oo
o`003P3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000000@0oooo00<000000?ooo`3o
ool0c`3oool00`000000oooo0000000a0?ooo`003P3oool3@00000<0oooo00=000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`3@0?ooo`030000003oool000000300oooo000J0?ooo`030000003o
ool0oooo0=40oooo00<000000?ooo`000000;`3oool001X0oooo00<00000@000003oool0dP3oool0
0`000000oooo0000000^0?ooo`006P3oool00`000000oooo0?ooo`3C0?ooo`030000003oool00000
02d0oooo000J0?ooo`030000003oool0oooo0=@0oooo00<000000?ooo`000000;03oool001X0oooo
00<000000?ooo`3oool0e@3oool00`000000oooo0000000[0?ooo`006P3oool00`00001000000?oo
o`3F0?ooo`030000003oool0000002X0oooo000J0?ooo`030000003oool0oooo0=L0oooo00<00000
0?ooo`000000:@3oool001X0oooo00<000000?ooo`3oool0eP3oool3000000030?ooo`000000oooo
02L0oooo000J0?ooo`030000003oool0oooo0=H0oooo100000000`3oool000000?ooo`0V0?ooo`00
6P3oool00`000000oooo0?ooo`3G0?ooo`060000003oool0oooo0000003oool000009P3oool001X0
oooo00<00000@000003oool0f`3oool010000000oooo00000000000T0?ooo`006P3oool00`000000
oooo0?ooo`3L0?ooo`040000003oool0oooo000002<0oooo000J0?ooo`030000003oool0oooo0=d0
oooo00@000000?ooo`3oool000008P3oool001X0oooo00<000000?ooo`3oool0gP3oool010000000
oooo0?ooo`00000Q0?ooo`006P3oool00`00001000000?ooo`3O0?ooo`040000003oool0oooo0000
0200oooo000J0?ooo`030000003oool0oooo0>00oooo00@000000?ooo`3oool000007`3oool001X0
oooo00<000000?ooo`3oool0h@3oool010000000oooo0?ooo`00000N0?ooo`003P3oool2@00000@0
oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`3R0?ooo`040000003oool0oooo0000
01d0oooo000>0?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool00`000000
oooo0?ooo`3S0?ooo`<000007@3oool000h0oooo00=000000?oood0000000P3oool00d000000oooo
@00000040?ooo`03000004000000oooo0><0oooo0`0000000d000000oooo0?ooo`0J0?ooo`003P3o
ool2@00000<0oooo00=000000?oood000000103oool00`000000oooo0?ooo`3T0?ooo`030000003o
oom0000001`0oooo000>0?ooo`03@000003oool0oooo0080oooo00=000000?oood000000103oool0
0`000000oooo0?ooo`3o0?ooo`@0oooo000?0?ooo`9000000`3oool00d000000oooo0?ooo`030?oo
o`030000003oool0oooo0?l0oooo103oool001X0oooo00<00000@000003oool0o`3oool40?ooo`00
6P3oool00`000000oooo0?ooo`3o0?ooo`@0oooo000J0?ooo`030000003oool0oooo0?l0oooo103o
ool001X0oooo00<000000?ooo`3oool0o`3oool40?ooo`006P3oool00`00001000000?ooo`3o0?oo
o`@0oooo000J0?ooo`030000003oool0oooo0?l0oooo103oool001X0oooo00<000000?ooo`3oool0
o`3oool40?ooo`006P3oool00d000000oooo0?ooo`3o0?ooo`@0oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo000H0?ooo`=00000o`3oool6
0?ooo`00603oool00d000000oooo0?ooo`3o0?ooo`H0oooo000H0?ooo`03@000003oool0oooo0?l0
oooo1P3oool001P0oooo0d00003o0?ooo`H0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {8.68791, -5.3722, 0.42863, 
  0.4508}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
AutoGeneratedPackage->None,
WindowSize->{381, 260},
WindowMargins->{{89, Automatic}, {Automatic, 65}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageHeaderLines->{False, Inherited},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 54, 0, 30, "Input"],
Cell[1766, 51, 74, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[1865, 55, 354, 10, 102, "Input",
  InitializationCell->True],
Cell[2222, 67, 18355, 529, 186, 5334, 364, "GraphicsData", 
"PostScript", "Graphics"],
Cell[20580, 598, 2099, 44, 28, "Output"]
}, Open  ]],
Cell[22694, 645, 73, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[22792, 649, 354, 10, 102, "Input",
  InitializationCell->True],
Cell[23149, 661, 18284, 529, 186, 5348, 365, "GraphicsData", 
"PostScript", "Graphics"],
Cell[41436, 1192, 2230, 47, 28, "Output"]
}, Open  ]],
Cell[43681, 1242, 158, 2, 71, "Text"],

Cell[CellGroupData[{
Cell[43864, 1248, 361, 12, 138, "Input",
  InitializationCell->True],
Cell[44228, 1262, 19151, 536, 186, 5527, 363, "GraphicsData", 
"PostScript", "Graphics"],
Cell[63382, 1800, 2137, 43, 28, "Output"]
}, Open  ]],
Cell[65534, 1846, 157, 2, 71, "Text"],

Cell[CellGroupData[{
Cell[65716, 1852, 361, 12, 138, "Input",
  InitializationCell->True],
Cell[66080, 1866, 19084, 535, 186, 5525, 363, "GraphicsData", 
"PostScript", "Graphics"],
Cell[85167, 2403, 2253, 46, 28, "Output"]
}, Open  ]],
Cell[87435, 2452, 62, 3, 52, "Text"],

Cell[CellGroupData[{
Cell[87522, 2459, 356, 15, 174, "Input",
  InitializationCell->True],
Cell[87881, 2476, 108998, 1966, 403, 24799, 922, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[196894, 4445, 142, 4, 71, "Text"],

Cell[CellGroupData[{
Cell[197061, 4453, 441, 15, 354, "Input"],
Cell[197505, 4470, 23374, 643, 186, 6133, 426, "GraphicsData", 
"PostScript", "Graphics"],
Cell[220882, 5115, 9410, 185, 28, "Output"]
}, Open  ]],
Cell[230307, 5303, 91, 3, 52, "Text"],

Cell[CellGroupData[{
Cell[230423, 5310, 439, 15, 354, "Input"],
Cell[230865, 5327, 21573, 592, 186, 5692, 391, "GraphicsData", 
"PostScript", "Graphics"],
Cell[252441, 5921, 3771, 78, 28, "Output"]
}, Open  ]],
Cell[256227, 6002, 121, 4, 71, "Text"],

Cell[CellGroupData[{
Cell[256373, 6010, 416, 21, 462, "Input"],
Cell[256792, 6033, 37, 0, 25, "Print"],
Cell[256832, 6035, 20609, 539, 186, 4518, 336, "GraphicsData", 
"PostScript", "Graphics"],
Cell[277444, 6576, 4129, 82, 28, "Output"]
}, Open  ]],
Cell[281588, 6661, 69, 3, 52, "Text"],

Cell[CellGroupData[{
Cell[281682, 6668, 754, 24, 570, "Input"],
Cell[282439, 6694, 27504, 701, 186, 6354, 435, "GraphicsData", 
"PostScript", "Graphics"],
Cell[309946, 7397, 10694, 328, 28, "Output"]
}, Open  ]],
Cell[320655, 7728, 110, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[320790, 7734, 587, 25, 570, "Input"],
Cell[321380, 7761, 38, 0, 25, "Print"],
Cell[321421, 7763, 24212, 696, 236, 6914, 478, "GraphicsData", 
"PostScript", "Graphics"],
Cell[345636, 8461, 10590, 262, 28, "Output"]
}, Open  ]],
Cell[356241, 8726, 106, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[356372, 8732, 679, 27, 606, "Input"],
Cell[357054, 8761, 21903, 692, 186, 7270, 507, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

