(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     64132,       1781]*)
(*NotebookOutlinePosition[     64828,       1806]*)
(*  CellTagsIndexPosition[     64784,       1802]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
<<c:\\math\\kniz\\linearal\\tridiago.m
<<c:\\math\\kniz\\options\\optvalue.m\
\>", "Input"],

Cell["\"Bought Straddle : 1 call long + 1 put long\"", "Text"],

Cell["\<\
BoughtStraddleImpl[X_,sigma_,r_,D_,t_,m_,n_,trans_,time_]:=
Module[
{doldiag,diag,hordiag},

xright=Log[Slarge/X];
xleft=-xright;
k1=N[r/(0.5*sigma^2)];
k2=N[(r-D)/(0.5*sigma^2)];
k3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
k4=N[0.25*(k2^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

TransfBoughtStraddlePayoff[x_]:=N[Exp[0.5*(k2-1)*x]*(Max[Exp[x]-1,0]+Max[1-\
Exp[x],0])];
Do[u[i,0]=TransfBoughtStraddlePayoff[i*h],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
 Do[
      grad=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      kriv=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
ClenAbs[i]=Abs[N[k4*u[i,j-1]-k2*grad+kriv]],{i,-m+1,m-1}];

op1=Exp[0.5*(k2-1)*xleft+0.25*(k2-1)^2*k*j]-
    Exp[0.5*(k2+1)*xleft+0.25*(k2+1)^2*k*j];
op2=Exp[0.5*(k2+1)*xright+0.25*(k2+1)^2*k*j]-
    Exp[0.5*(k2-1)*xright+0.25*(k2-1)^2*k*j];

ps = Join[{u[-m+1,j-1]-k3*k*ClenAbs[-m+1]-a*op1},
          Table[u[i,j-1]-k3*k*ClenAbs[i],{i,-m+2,m-2}],
          {u[m-1,j-1]-k3*k*ClenAbs[m-1]-c*op2}];

hordiag=Table[c,{i,-m+1,m-2}];
diag=Table[b,{i,-m+1,m-1}];
doldiag=Table[a,{i,-m+2,m-1}];

riesenie=TridiagonalSolve[N[doldiag],N[diag],N[hordiag],N[ps]];
 
u[-m,j]=op1;
Do[u[i,j]=riesenie[[i+m]],{i,-m+1,m-1}];
u[m,j] =op2;

xs=Table[X*Exp[i*h],{i,-m,m}];
ys=Table[X*Exp[-0.5*(k2-1)*i*h-(0.25*(k2-1)^2+k1)*j*k]*u[i,j],{i,-m,m}];
graf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
{j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X=60;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=100;
n=100;
Slarge=150;
trans=0.02;
time=0.03;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["BoughtStraddleImpl[X,sigma,r,DD,t,m,n,trans,time]", "Input"],

Cell["\"Explicitn\[EAcute] rie\.9aenie\"", "Text"],

Cell["\<\
BoughtStraddle[S_,X,sigma_,r_,DD_,t_]:=
N[EuropeanCallDiv[S,X,sigma,r,DD,t]+EuropeanPutDiv[S,X,sigma,r,DD,t]]\
\>", "Input"],

Cell["\"Payoff diagram\"", "Text"],

Cell["Payoff[S_,X_]:=N[Max[S-X,0]+Max[X-S,0]]", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[BoughtStraddle[S,X,sigma,r,DD,t],{S,0,150},PlotRange->All,PlotStyle->\
RGBColor[0,1,0], DisplayFunction->Identity];
g1=ListPlot[graf[n],PlotStyle->{PointSize[0.015],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];
g2=Plot[Payoff[S,X],{S,0,150},PlotRange->All, DisplayFunction->Identity];

Show[g2,g1,g,AxesLabel -> \
{\"S\",\"V\"},DisplayFunction->$DisplayFunction,PlotRange->{{20,120},{0,80}}]
\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.2 0.01 0 0.00772542 [
[.2 -0.0125 -6 -9 ]
[.2 -0.0125 6 0 ]
[.4 -0.0125 -6 -9 ]
[.4 -0.0125 6 0 ]
[.6 -0.0125 -6 -9 ]
[.6 -0.0125 6 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .07725 -12 -4.5 ]
[-0.0125 .07725 0 4.5 ]
[-0.0125 .15451 -12 -4.5 ]
[-0.0125 .15451 0 4.5 ]
[-0.0125 .23176 -12 -4.5 ]
[-0.0125 .23176 0 4.5 ]
[-0.0125 .30902 -12 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .38627 -12 -4.5 ]
[-0.0125 .38627 0 4.5 ]
[-0.0125 .46353 -12 -4.5 ]
[-0.0125 .46353 0 4.5 ]
[-0.0125 .54078 -12 -4.5 ]
[-0.0125 .54078 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[0 .64303 -5.5 0 ]
[0 .64303 5.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2 0 m
.2 .00625 L
s
[(40)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(60)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(80)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(100)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(120)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .07725 m
.00625 .07725 L
s
[(10)] -0.0125 .07725 1 0 Mshowa
0 .15451 m
.00625 .15451 L
s
[(20)] -0.0125 .15451 1 0 Mshowa
0 .23176 m
.00625 .23176 L
s
[(30)] -0.0125 .23176 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(40)] -0.0125 .30902 1 0 Mshowa
0 .38627 m
.00625 .38627 L
s
[(50)] -0.0125 .38627 1 0 Mshowa
0 .46353 m
.00625 .46353 L
s
[(60)] -0.0125 .46353 1 0 Mshowa
0 .54078 m
.00625 .54078 L
s
[(70)] -0.0125 .54078 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(80)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .01545 m
.00375 .01545 L
s
0 .0309 m
.00375 .0309 L
s
0 .04635 m
.00375 .04635 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .10816 m
.00375 .10816 L
s
0 .12361 m
.00375 .12361 L
s
0 .13906 m
.00375 .13906 L
s
0 .16996 m
.00375 .16996 L
s
0 .18541 m
.00375 .18541 L
s
0 .20086 m
.00375 .20086 L
s
0 .21631 m
.00375 .21631 L
s
0 .24721 m
.00375 .24721 L
s
0 .26266 m
.00375 .26266 L
s
0 .27812 m
.00375 .27812 L
s
0 .29357 m
.00375 .29357 L
s
0 .32447 m
.00375 .32447 L
s
0 .33992 m
.00375 .33992 L
s
0 .35537 m
.00375 .35537 L
s
0 .37082 m
.00375 .37082 L
s
0 .40172 m
.00375 .40172 L
s
0 .41717 m
.00375 .41717 L
s
0 .43262 m
.00375 .43262 L
s
0 .44807 m
.00375 .44807 L
s
0 .47898 m
.00375 .47898 L
s
0 .49443 m
.00375 .49443 L
s
0 .50988 m
.00375 .50988 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .57168 m
.00375 .57168 L
s
0 .58713 m
.00375 .58713 L
s
0 .60258 m
.00375 .60258 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(V) show
69.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .30902 m
.04948 .27079 L
.11328 .2215 L
.17469 .17406 L
.23997 .12363 L
.30286 .07505 L
.36336 .02831 L
.37949 .01584 L
.38738 .00975 L
.3946 .00417 L
.39647 .00273 L
.3985 .00116 L
.40042 .00032 L
.4022 .0017 L
.41037 .00801 L
.42773 .02142 L
.48936 .06903 L
.55485 .11963 L
.61795 .16838 L
.67867 .21528 L
.74325 .26517 L
.80544 .31322 L
.86525 .35942 L
.92892 .40861 L
.9902 .45595 L
s
.9902 .45595 m
1 .46353 L
s
.25 .25 1 r
.015 w
.04 .27259 Mdot
.04221 .27088 Mdot
.04444 .26916 Mdot
.04669 .26742 Mdot
.04896 .26566 Mdot
.05125 .26389 Mdot
.05356 .26211 Mdot
.0559 .2603 Mdot
.05825 .25848 Mdot
.06063 .25665 Mdot
.06303 .25479 Mdot
.06545 .25292 Mdot
.06789 .25104 Mdot
.07036 .24913 Mdot
.07285 .24721 Mdot
.07536 .24527 Mdot
.0779 .24331 Mdot
.08045 .24133 Mdot
.08304 .23934 Mdot
.08564 .23733 Mdot
.08827 .2353 Mdot
.09092 .23325 Mdot
.0936 .23118 Mdot
.0963 .22909 Mdot
.09903 .22698 Mdot
.10178 .22486 Mdot
.10456 .22271 Mdot
.10737 .22054 Mdot
.11019 .21836 Mdot
.11305 .21615 Mdot
.11593 .21393 Mdot
.11884 .21168 Mdot
.12177 .20941 Mdot
.12474 .20712 Mdot
.12773 .20481 Mdot
.13074 .20248 Mdot
.13379 .20013 Mdot
.13686 .19776 Mdot
.13996 .19536 Mdot
.14309 .19294 Mdot
.14625 .1905 Mdot
.14944 .18804 Mdot
.15265 .18556 Mdot
.1559 .18305 Mdot
.15917 .18052 Mdot
.16248 .17796 Mdot
.16582 .17539 Mdot
.16918 .17279 Mdot
.17258 .17016 Mdot
.17601 .16751 Mdot
.17947 .16484 Mdot
.18297 .16214 Mdot
.18649 .15942 Mdot
.19005 .15667 Mdot
.19364 .15389 Mdot
.19726 .15109 Mdot
.20092 .14827 Mdot
.20461 .14542 Mdot
.20833 .14254 Mdot
.21209 .13964 Mdot
.21589 .13671 Mdot
.21972 .13376 Mdot
.22358 .13077 Mdot
.22748 .12776 Mdot
.23141 .12473 Mdot
.23538 .12167 Mdot
.23939 .11858 Mdot
.24344 .11547 Mdot
.24752 .11233 Mdot
.25164 .10916 Mdot
.25579 .10598 Mdot
.25999 .10277 Mdot
.26422 .09954 Mdot
.2685 .09629 Mdot
.27281 .09303 Mdot
.27716 .08976 Mdot
.28155 .08647 Mdot
.28599 .08319 Mdot
.29046 .07991 Mdot
.29498 .07663 Mdot
.29953 .07338 Mdot
.30413 .07015 Mdot
.30877 .06697 Mdot
.31345 .06383 Mdot
.31818 .06076 Mdot
.32295 .05777 Mdot
.32776 .05488 Mdot
.33262 .0521 Mdot
.33752 .04946 Mdot
.34247 .04697 Mdot
.34747 .04465 Mdot
.35251 .04253 Mdot
.35759 .04062 Mdot
.36272 .03896 Mdot
.3679 .03754 Mdot
.37313 .0364 Mdot
.37841 .03555 Mdot
.38373 .03501 Mdot
.3891 .03478 Mdot
.39453 .03487 Mdot
.4 .03528 Mdot
.40552 .03603 Mdot
.4111 .03711 Mdot
.41672 .03852 Mdot
.4224 .04024 Mdot
.42813 .04227 Mdot
.43391 .04459 Mdot
.43975 .0472 Mdot
.44563 .05008 Mdot
.45158 .05321 Mdot
.45757 .05657 Mdot
.46363 .06015 Mdot
.46974 .06393 Mdot
.4759 .06789 Mdot
.48212 .07202 Mdot
.4884 .07631 Mdot
.49474 .08073 Mdot
.50113 .08528 Mdot
.50759 .08994 Mdot
.5141 .09471 Mdot
.52067 .09957 Mdot
.52731 .10452 Mdot
.534 .10955 Mdot
.54076 .11466 Mdot
.54758 .11984 Mdot
.55446 .12509 Mdot
.5614 .1304 Mdot
.56841 .13577 Mdot
.57549 .1412 Mdot
.58263 .14669 Mdot
.58983 .15224 Mdot
.5971 .15784 Mdot
.60444 .1635 Mdot
.61184 .16921 Mdot
.61931 .17498 Mdot
.62686 .1808 Mdot
.63447 .18668 Mdot
.64215 .19261 Mdot
.6499 .19859 Mdot
.65772 .20464 Mdot
.66562 .21073 Mdot
.67359 .21689 Mdot
.68163 .2231 Mdot
.68974 .22937 Mdot
.69793 .2357 Mdot
.7062 .24208 Mdot
.71454 .24853 Mdot
.72296 .25503 Mdot
.73146 .26159 Mdot
.74003 .26822 Mdot
.74868 .2749 Mdot
.75742 .28165 Mdot
.76623 .28846 Mdot
.77512 .29533 Mdot
.7841 .30226 Mdot
.79316 .30926 Mdot
.8023 .31632 Mdot
.81153 .32345 Mdot
.82084 .33064 Mdot
.83023 .3379 Mdot
.83972 .34523 Mdot
.84929 .35262 Mdot
.85895 .36009 Mdot
.86869 .36762 Mdot
.87853 .37522 Mdot
.88846 .38289 Mdot
.89848 .39063 Mdot
.90859 .39844 Mdot
.91879 .40632 Mdot
.92909 .41428 Mdot
.93949 .42231 Mdot
.94998 .43041 Mdot
.96056 .43859 Mdot
.97124 .44684 Mdot
.98203 .45517 Mdot
.99291 .46357 Mdot
0 1 0 r
.5 Mabswid
0 .30349 m
.04948 .26526 L
.11328 .21598 L
.17469 .1686 L
.23997 .11957 L
.27267 .09732 L
.30286 .07991 L
.31802 .07275 L
.33223 .0672 L
.34704 .06272 L
.3549 .06091 L
.359 .06013 L
.36336 .05943 L
.36769 .05885 L
.37161 .05844 L
.37351 .05827 L
.37556 .05812 L
.37748 .05801 L
.37928 .05793 L
.38037 .05789 L
.38137 .05786 L
.38248 .05783 L
.38368 .05781 L
.38482 .0578 L
.38606 .0578 L
.38724 .05781 L
.38832 .05783 L
.39024 .05788 L
.39133 .05792 L
.39236 .05796 L
.39441 .05807 L
.39665 .05822 L
.40052 .05855 L
.40459 .059 L
.41187 .06007 L
.42038 .06173 L
.42829 .06365 L
.44486 .0688 L
.46051 .07491 L
.48979 .08914 L
.55037 .12667 L
.61482 .17292 L
.67688 .21982 L
.73655 .26563 L
.80008 .31464 L
.86123 .36186 L
.92624 .41208 L
.98887 .46045 L
s
.98887 .46045 m
1 .46905 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{412.563, 254.938},
  ImageMargins->{{42, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006L0000oR000`400?l00000o`00003oo`3ooonM
0?ooo`00H03oool3@0000080oooo00=000000?ooo`3oool0?@3oool2@00000@0oooo00=000000?oo
o`3oool0?P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo03X0oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0=`3oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool06@3oool00640oooo00I000000?ooo`3ooom000000?oood00
000n0?ooo`03@000003ooom000000080oooo00=000000?oood000000?P3oool00d000000oooo@000
00020?ooo`03@000003ooom0000003d0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood000000>P3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oo
od0000006P3oool005l0oooo14000000103ooom000000?oood00000n0?ooo`03@000003ooom00000
0080oooo00=000000?oood000000?P3oool00d000000oooo@00000020?ooo`03@000003ooom00000
03d0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000>P3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000J0?ooo`00
G`3oool00d000000oooo@00000020?ooo`03@000003ooom0000003h0oooo0T0000030?ooo`03@000
003ooom0000003l0oooo00M000000?ooo`3oool0oooo@000003ooom0000003d0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood000000>P3oool00d000000oooo0?oo
o`020?ooo`07@000003oool0oooo0?oood000000oooo@000000J0?ooo`00H03oool2@0000080oooo
00=000000?oood000000?P3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000003h0oooo
00=000000?oood0000000P3oool00d000000oooo@000000m0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000020?ooo`03@000003ooom0000003X0oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood0000006P3oool00640oooo00E000000?ooo`3oool0oooo@000
00100?ooo`9000000`3oool00d000000oooo0?ooo`0n0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool0>`3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`0h0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01T0oooo003o
0?oooid0oooo003o0?oooid0oooo003o0?oooid0oooo003o0?oooid0oooo003o0?ooohP0oooo0d00
000B0?ooo`00o`3ooon80?ooo`03@000003ooom000000180oooo000M0?ooool00000G`0000000d00
0000oooo0?ooo`0;0?ooo`03@000003oool0oooo0100oooo000M0?ooo`030000003oool0oooo00h0
oooo00=000000?ooo`3oool03`3oool00d000000oooo0?ooo`0>0?ooo`03@000003oool0oooo00l0
oooo00<000000?ooo`3oool03P3oool00d000000oooo0?ooo`0?0?ooo`03@000003oool0oooo00h0
oooo00=000000?ooo`3oool03@3oool400000100oooo00=000000?ooo`3oool03P3oool00d000000
oooo0?ooo`0?0?ooo`03@000003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00d000000
oooo0?ooo`0>0?ooo`03@000003oool0oooo00l0oooo00=000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0?0?ooo`03@000003oool0oooo00h0oooo00=000000?ooo`3oool03`3oool00d000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00X0oooo00=000000?ooo`3oool04@3oool001d0oooo
00<000000?ooo`3oool0@`3oool00d000000oooo0?ooo`100?ooo`050000003oool0oooo@000003o
ool00P0000120?ooo`03@000003oool0oooo04<0oooo00=000000?ooo`3oool0@`3oool00d000000
oooo0?ooo`090?ooo`03@000003ooom000000180oooo000M0?ooo`030000003oool0oooo08D0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3G0?ooo`=000004P3oool001d0oooo00<0
00000?ooo`3oool0Q03oool00`000000oooo0?ooo`070?ooo`800000k03oool001d0oooo00<00000
@000003oool0P`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0>T0oooo000M0?oo
o`030000003oool0oooo0880oooo00<000000?ooo`3oool0303oool200000>T0oooo000M0?ooo`03
0000003oool0oooo0800oooo0P00000A0?ooo`030000003oool0oooo0>H0oooo000M0?ooo`030000
003oool0oooo07l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`3U0?ooo`007@3o
ool00`000000oooo0?ooo`1m0?ooo`8000005P3oool200000>D0oooo000M0?ooo`030000003oool0
oooo07`0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`3R0?ooo`007@3oool00`00
001000000?ooo`1k0?ooo`030000003oool0oooo00<0oooo2P0o?ol=0?ooo`030000003oool0oooo
0>40oooo000M0?ooo`030000003oool0oooo07T0oooo0P0000000`3oool0?coo03loo`0A03loo`X0
oooo00<000000?ooo`3oool0h03oool001d0oooo00<000000?ooo`3oool0N03ooolK03loo`L0oooo
0P00003P0?ooo`007@3oool00`000000oooo0?ooo`1f0?oooal0?coo1`3oool00`000000oooo0?oo
o`3M0?ooo`007@3oool00`000000oooo0?ooo`1d0?ooo`h0?coo203oool=03loo`H0oooo00<00000
0?ooo`3oool0g03oool001d0oooo00<00000@000003oool0L@3oool<03looa40oooo2`0o?ol50?oo
o`030000003oool0oooo0=/0oooo000M0?ooo`030000003oool0oooo06l0oooo2P0o?olI0?ooo`T0
?coo103oool00`000000oooo0?ooo`3J0?ooo`007@3oool00`000000oooo0?ooo`1^0?ooo`T0?coo
7@3oool903loo`<0oooo0P00003J0?ooo`007@3oool00`000000oooo0?ooo`1/0?ooo`X0?coo803o
ool903loo`<0oooo00<000000?ooo`3oool0e`3oool001d0oooo00<000000?ooo`3oool0JP3oool8
03loo`d0oooo2`00o`0>0?ooo`T0?coo0P3oool00`000000oooo0?ooo`3F0?ooo`007@3oool00`00
0000oooo0?ooo`1Y0?ooo`P0?coo1`3oool7003o00/0oooo1@00o`0;0?ooo`T0?coo00<0oooo0000
003oool0eP3oool001d0oooo00<00000@000003oool0J@3oool603loo`H0oooo0`00o`0G0?ooo`H0
0?l01`3oool703loo`80oooo0P00003E0?ooo`007@3oool00`000000oooo0?ooo`1W0?ooo`H0?coo
1P3oool2003o0200oooo0`00o`060?ooo`P0?coo00<0oooo0000003oool0d`3oool001d0oooo00<0
00000?ooo`3oool0I@3oool703loo`<0oooo1000o`0U0?ooo`<00?l01@3oool803loo`030000003o
ool0oooo0=40oooo000>0?ooo`E000000P3oool00d000000oooo0?ooo`050?ooo`030000003oool0
oooo06@0oooo1`0o?ol0103oool00?l0003o0000o`0/0?ooo`800?l01@3oool603loo`030?ooo`00
0000oooo0=40oooo000@0?ooo`07@000003oool0oooo0?oood000000oooo@00000060?ooo`030000
003oool0oooo0680oooo200o?ol2003o0340oooo0`00o`030?ooo`L0?coo0P00003@0?ooo`00403o
ool01d000000oooo0?ooo`3ooom000000?oood0000001P3oool200000003@000003oool0oooo05h0
oooo200o?ol2003o03H0oooo0P00o`030?ooo`L0?coo00<000000?ooo`3oool0c@3oool00100oooo
00M000000?ooo`3oool0oooo@000003ooom0000000H0oooo00<000000?ooo`3oool0G`3oool803lo
o`03003o003oool0oooo03P0oooo0P00o`020?ooo`H0?coo00<0oooo0000003oool0c@3oool00100
oooo00M000000?ooo`3oool0oooo@000003ooom0000000H0oooo00<000000?ooo`3oool0G@3oool8
03loo`800?l0?@3oool2003o00030?ooo`0o?ol0?coo00D0?coo0P00003<0?ooo`003`3oool2@000
00@0oooo00=000000?ooo`3oool01@3oool00`000000oooo0?ooo`1M0?ooo`H0?coo0P00o`110?oo
o`800?l000<0oooo03loo`0o?ol00`0o?ol20?ooo`030000003oool0oooo0<T0oooo000M0?ooo`03
0000003oool0oooo05`0oooo1@0o?ol2003o04D0oooo0P00o`0703loo`030000003oool0oooo0<P0
oooo000M0?ooo`03000004000000oooo05X0oooo1@0o?ol2003o04T0oooo0P00o`0703loolT0oooo
000M0?ooo`030000003oool0oooo05T0oooo100o?ol2003o000303loo`3oool0oooo04X0oooo0P00
o`0503loo`800000a`3oool001d0oooo00<000000?ooo`3oool0E`3oool503loo`03003o000o?ol0
?coo04l0oooo00<00?l003loo`0o?ol0100o?ol00`000000oooo0?ooo`340?ooo`007@3oool00`00
0000oooo0?ooo`1F0?ooo`@0?coo0P00o`000`0o?ol0oooo0?ooo`1@0?ooo`800?l0100o?ol00`3o
ool000000?ooo`340?ooo`007@3oool00`000000oooo0?ooo`1D0?ooo`D0?coo00<00?l003loo`0o
?ol0E@3oool00`00o`00?coo03loo`0403lool@0oooo000M0?ooo`030000003oool0oooo05<0oooo
1@0o?ol00`00o`00?coo0?ooo`1G0?ooo`800?l01P0o?oo20?ooo`007@3oool00`00001000000?oo
o`1A0?ooo`D0?coo0P00o`000`0o?ol0oooo0?ooo`1I0?ooo`800?l0100o?ol00`000000oooo0?oo
o`2o0?ooo`007@3oool00`000000oooo0?ooo`1A0?ooo`@0?coo00<00?l003loo`3oool0G@3oool0
0`0o?ol00?l003loo`0403lool00oooo000M0?ooo`030000003oool0oooo0500oooo100o?ol00`00
o`00?coo0?ooo`1P0?ooo`800?l00`0o?ol200000;h0oooo000M0?ooo`030000003oool0oooo04l0
oooo0`0o?ol2003o00030000003oool0oooo0640oooo00<0?coo003o000o?ol0100o?onm0?ooo`00
7@3oool00`000000oooo0?ooo`1=0?ooo`@0?coo00<00?l003loo`0o?ol0I@3oool00`0o?ol00?l0
003o000303loo`030000003oool0oooo0;X0oooo000M0?ooo`03000004000000oooo04`0oooo0`0o
?ol2003o0080?cooJ03oool00`0o?ol00?l0003o000303look/0oooo000M0?ooo`030000003oool0
oooo04X0oooo100o?ol01000o`00?coo03loo`0o?omZ0?ooo`80?coo00<00?l003loo`0o?ol00P00
002i0?ooo`007@3oool00`000000oooo0?ooo`190?ooo`@0?coo00<00?l003loo`0o?ol0K@3oool2
03loo`03003o000o?ol0?coo0080?coo^03oool001d0oooo00<000000?ooo`3oool0B03oool303lo
o`800?l00P0o?om_0?ooo`80?coo0P00o`0203loo`030000003oool0oooo0;D0oooo000M0?ooo`03
0000003oool0oooo04H0oooo100o?ol00`00o`00?coo03loo`1c0?ooo`80?coo00D00?l003loo`0o
?ol0?coo0000002e0?ooo`007@3oool00`000000oooo0?ooo`150?ooo`@0?coo00<00?l003loo`0o
?ol0M@3oool203loo`05003o000o?ol0?coo0?ooo`000000]03oool001d0oooo00<00000@000003o
ool0A03oool303loo`800?l00P0o?omg0?ooo`80?coo0P00o`0203loo`030000003oool0oooo0;40
oooo000M0?ooo`030000003oool0oooo0480oooo100o?ol00`00o`00?coo03loo`1j0?ooo`<0?coo
00@00?l003loo`3oool00000/P3oool001d0oooo00<000000?ooo`3oool0@@3oool403loo`03003o
000o?ol0?coo07`0oooo0`0o?ol01@00o`00?coo03loo`0o?ol000000;00oooo000?0?ooo`=00000
0`3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo0400oooo0`0o?ol2003o0080?coo
OP3oool303loo`03003o000o?ol0?coo0080?coo[`3oool000l0oooo00=000000?ooo`3oool00P3o
ool00d000000oooo@00000060?ooo`030000003oool0oooo03l0oooo0`0o?ol00`00o`00?coo03lo
o`220?ooo`80?coo0P00o`0203loo`030000003oool0oooo0:`0oooo000@0?ooo`07@000003oool0
oooo0?oood000000oooo@00000060?ooo`80000000=000000?ooo`3oool0>`3oool403loo`03003o
000o?ol0?coo08@0oooo0`0o?ol00`00o`00?coo03loo`0203looj`0oooo000@0?ooo`07@000003o
ool0oooo0?oood000000oooo@00000060?ooo`030000003oool0oooo03`0oooo0`0o?ol2003o0080
?cooQ`3oool203loo`05003o000o?ol0?coo03loo`000000Z`3oool000l0oooo00=000000?oood00
00000P3oool00d000000oooo@00000060?ooo`030000003oool0oooo03/0oooo0`0o?ol01000o`00
?coo03loo`0o?on:0?ooo`0303loo`00o`000?l000@0?cooZ@3oool00100oooo00=000000?ooo`3o
ool00P3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo03X0oooo0`0o?ol00`00o`00
?coo03loo`2=0?ooo`80?coo00D00?l003loo`0o?ol0?coo0000002X0?ooo`007@3oool00`000000
oooo0?ooo`0h0?ooo`<0?coo0P00o`0203looi00oooo00<0?coo003o000o?ol00`0o?onW0?ooo`00
7@3oool00`000000oooo0?ooo`0g0?ooo`<0?coo00@00?l003loo`0o?ol0?cooTP3oool00`0o?ol0
0?l0003o000203loo`030000003oool0oooo0:@0oooo000M0?ooo`03000004000000oooo03H0oooo
0`0o?ol01000o`00?coo03loo`0o?onD0?ooo`80?coo00<00?l003loo`0o?ol00P0o?onT0?ooo`00
7@3oool00`000000oooo0?ooo`0d0?ooo`<0?coo0P00o`0203looiL0oooo0P0o?ol01@00o`00?coo
03loo`0o?ol000000:<0oooo000M0?ooo`030000003oool0oooo0380oooo100o?ol01000o`00?coo
03loo`0o?onJ0?ooo`0303loo`00o`000?l000<0?cooXP3oool001d0oooo00<000000?ooo`3oool0
<@3oool403loo`04003o000o?ol0?coo03looi`0oooo0P0o?ol00`00o`00?coo03loo`0200000:00
oooo000M0?ooo`030000003oool0oooo0300oooo0`0o?ol2003o00<0?cooWP3oool203loo`05003o
000o?ol0oooo0?ooo`000000W`3oool001d0oooo00<00000@000003oool0;`3oool303loo`04003o
000o?ol0?coo00000:40oooo0P0o?ol2003o0080?coo00<000000?ooo`3oool0W03oool001d0oooo
00<000000?ooo`3oool0;P3oool303loo`04003o000o?ol0?coo00000:@0oooo0P0o?ol00`00o`00
?coo0?ooo`02000009`0oooo000M0?ooo`030000003oool0oooo02d0oooo0`0o?ol00`00o`00?coo
03loo`2V0?ooo`<0?coo00D00?l003loo`0o?ol0?coo0000002K0?ooo`007@3oool00`000000oooo
0?ooo`0[0?ooo`<0?coo0P00o`0203loojP0oooo0`0o?ol2003o000403loo`3oool00000000009T0
oooo000M0?ooo`030000003oool0oooo02X0oooo0`0o?ol01000o`00?coo03loo`0o?on[0?ooo`<0
?coo00D00?l003loo`0o?ol0?coo0000002H0?ooo`007@3oool00`00001000000?ooo`0X0?ooo`@0
?coo00@00?l003loo`0o?ol0?coo[@3oool303loo`800?l000<0?coo0?ooo`000000U`3oool001d0
oooo00<000000?ooo`3oool09`3oool303loo`800?l00`0o?on`0?ooo`<0?coo00<00?l003loo`0o
?ol00P00002E0?ooo`007@3oool00`000000oooo0?ooo`0V0?ooo`<0?coo00@00?l003loo`0o?ol0
?coo/`3oool303loo`05003o000o?ol0oooo0?ooo`000000U03oool001d0oooo00<000000?ooo`3o
ool0903oool403loo`04003o000o?ol0?coo00000;D0oooo0`0o?ol2003o0080?coo00<000000?oo
o`3oool0T@3oool001d0oooo00<000000?ooo`3oool08`3oool303loo`800?l00P0o?onh0?ooo`@0
?coo00<00?l003loo`3oool00P00002A0?ooo`007@3oool00`000000oooo0?ooo`0R0?ooo`<0?coo
00@00?l003loo`0o?ol0?coo^`3oool303loo`05003o000o?ol0?coo03loo`000000T03oool001d0
oooo00<00000@000003oool0803oool403loo`04003o000o?ol0?coo03lookd0oooo0`0o?ol2003o
000303loo`3oool0000008l0oooo000M0?ooo`030000003oool0oooo01l0oooo100o?ol00`00o`00
?coo03loo`310?ooo`<0?coo00D00?l003loo`0o?ol0?coo0000002=0?ooo`007@3oool00`000000
oooo0?ooo`0N0?ooo`<0?coo0P00o`0203lool<0oooo0`0o?ol01@00o`00?coo03loo`3oool00000
08`0oooo000?0?ooo`900000103oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo01`0
oooo100o?ol01000o`00?coo03loo`0o?oo60?ooo`80?coo0P00o`020?ooo`030000003oool0oooo
08T0oooo000A0?ooo`06@000003oool0oooo@000003ooom000001P3oool00`000000oooo0?ooo`0K
0?ooo`@0?coo00@00?l003loo`0o?ol00000b03oool303loo`04003o000o?ol0?coo000008X0oooo
000@0?ooo`07@000003oool0oooo0?oood000000oooo@00000060?ooo`80000000=000000?ooo`3o
ool0603oool303loo`800?l00P0o?oo<0?ooo`80?coo00@00?l003loo`3oool00000R@3oool00140
oooo00I000000?ooo`3ooom000000?oood0000060?ooo`030000003oool0oooo01T0oooo0`0o?ol0
1000o`00?coo03loo`0o?oo=0?ooo`<0?coo0P00o`000`0o?ol00000000000270?ooo`003`3oool0
0d000000oooo@00000020?ooo`03@000003ooom0000000H0oooo00<000000?ooo`3oool0603oool3
03loo`04003o000o?ol0?coo00000<l0oooo100o?ol01000o`00oooo0?ooo`0000260?ooo`00403o
ool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool05P3o
ool403loo`04003o000o?ol0?coo03loom40oooo100o?ol01000o`00?coo03loo`0000250?ooo`00
7@3oool00`000000oooo0?ooo`0E0?ooo`<0?coo0P00o`0303loom<0oooo100o?ol2003o00030?oo
o`000000oooo08<0oooo000M0?ooo`030000003oool0oooo01<0oooo100o?ol01000o`00?coo03lo
o`0o?ooG0?ooo`@0?coo00@00?l003loo`0o?ol00000PP3oool001d0oooo00<00000@000003oool0
4P3oool403loo`04003o000o?ol0?coo03loomT0oooo100o?ol01000o`00?coo0?ooo`0000210?oo
o`007@3oool00`000000oooo0?ooo`0A0?ooo`<0?coo0P00o`0203loomd0oooo0`0o?ol2003o0003
0?ooo`000000oooo07l0oooo000M0?ooo`030000003oool0oooo0100oooo0`0o?ol01000o`00?coo
03loo`0o?ooO0?ooo`@0?coo00<00?l003loo`000000O`3oool001d0oooo00<000000?ooo`3oool0
3P3oool403loo`04003o000o?ol0?coo03loon80oooo0`0o?ol00`00o`00oooo0000001n0?ooo`00
7@3oool00`000000oooo0?ooo`0=0?ooo`<0?coo0P00o`0303loon<0oooo100o?ol2003o000303lo
o`000000oooo07/0oooo000M0?ooo`03000004000000oooo00`0oooo0`0o?ol01000o`00?coo03lo
o`0o?ooV0?ooo`D0?coo00<00?l00?ooo`000000N`3oool001d0oooo00<000000?ooo`3oool02P3o
ool403loo`04003o000o?ol0?coo03loonT0oooo100o?ol00`00o`00?coo03loo`1j0?ooo`007@3o
ool00`000000oooo0?ooo`090?ooo`@0?coo00@00?l003loo`0o?ol0?cooj`3oool403loo`03003o
000o?ol0000007T0oooo000M0?ooo`030000003oool0oooo00T0oooo0P0o?ol2003o00<0?cookP3o
ool303loo`800?l00P0o?omg0?ooo`007@3oool00`000000oooo0?ooo`090?ooo`0303loo`00o`00
?coo0080?cool@3oool403loo`03003o000o?ol0000007H0oooo000M0?ooo`030000003oool0oooo
00T0oooo00@00?l003loo`0o?ol0?coom03oool303loo`03003o003oool0000007D0oooo000M0?oo
o`03000004000000oooo00L0oooo0P00o`000`3oool0?coo03loo`3f0?ooo`<0?coo0P00o`000`0o
?ol000000?ooo`1b0?ooo`007@3oool00`000000oooo0?ooo`060?ooo`04003o003oool0oooo0000
0?X0oooo0`0o?ol00`00o`00oooo0000001b0?ooo`007@3oool00`000000oooo0?ooo`050?ooo`04
003o003oool0000000000?/0oooo100o?ol00`00o`00?coo03loo`1a0?ooo`007@3oool00`000000
oooo0?ooo`030?ooo`800?l000<0oooo0000003oool0o@3oool403loo`03003o000o?ol000000700
oooo000M0?ooo`030000003oool0oooo0080oooo00@00?l00?ooo`3oool00000o`3oool20?ooo`<0
?coo0P00o`02000006h0oooo000M0?ooo`06000004000000oooo0?ooo`00o`00oooo0P00003o0?oo
o`@0oooo100o?ol00`00o`00?coo0000001]0?ooo`007@3oool01P000000oooo003o0000o`00oooo
00000?l0oooo203oool303loo`03003o003oool0000006`0oooo000M0?ooo`0500000000o`00oooo
0?ooo`000000o`3oool90?ooo`@0?coo0P00o`0203loofX0oooo000@0?ooo`=000000P3oool00d00
0000oooo0?ooo`050?ooo`04003o003oool0000000000?l0oooo2`3oool203loo`060?ooo`0o?ol0
?coo003o000o?ol00000J@3oool00140oooo00I000000?ooo`3ooom000000?oood0000060?ooo`80
0000o`3oool@0?ooo`<0?coo00<00?l00?ooo`000000J03oool000l0oooo14000000103ooom00000
0?oood0000060?ooo`80000000=000000?ooo`3oool0o`3oool>0?ooo`<0?coo0P00o`000`0o?ol0
00000?ooo`1U0?ooo`003`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000H0oooo
00<000000?ooo`3oool0o`3ooolB0?ooo`<0?coo00<00?l00?ooo`000000I@3oool00100oooo0T00
00020?ooo`03@000003ooom0000000H0oooo00<000000?ooo`3oool0o`3ooolB0?ooo`@0?coo00<0
0?l003loo`0o?ol0I03oool00140oooo00E000000?ooo`3oool0oooo@00000070?ooo`030000003o
ool0oooo0?l0oooo4`3oool403loo`03003o000o?ol0000006<0oooo000M0?ooo`030000003oool0
oooo0?l0oooo5@3oool303loo`800?l00P00001Q0?ooo`007@3oool00`000000oooo0?ooo`3o0?oo
oaH0oooo100o?ol00`00o`00?coo0000001P0?ooo`007@3oool00`00001000000?ooo`3o0?oooaP0
oooo0`0o?ol00`00o`00oooo0000001O0?ooo`007@3oool00`000000oooo0?ooo`3o0?oooaP0oooo
100o?ol2003o0080?cooG@3oool001d0oooo00<000000?ooo`3oool0o`3ooolI0?ooo`80?coo00H0
oooo03loo`0o?ol00?l003loo`00001L0?ooo`007@3oool00`000000oooo0?ooo`3o0?oooa`0oooo
0`0o?ol00`00o`00oooo0000001K0?ooo`007@3oool00`000000oooo0?ooo`3o0?oooad0oooo0`0o
?ol01000o`00?coo03loo`00001I0?ooo`007@3oool00`00001000000?ooo`3o0?oooal0oooo0P0o
?ol2003o00030?ooo`000000oooo05L0oooo000M0?ooo`030000003oool0oooo0?l0oooo7`3oool4
03loo`03003o000o?ol0?coo05L0oooo000M0?ooo`030000003oool0oooo0?l0oooo803oool403lo
o`04003o000o?ol00000000005D0oooo000M0?ooo`030000003oool0oooo0?l0oooo8P3oool303lo
o`800?l000<0oooo0000003oool0D`3oool001d0oooo00<000000?ooo`3oool0o`3ooolS0?ooo`@0
?coo00<00?l003loo`000000D`3oool001d0oooo00<000000?ooo`3oool0o`3ooolU0?ooo`<0?coo
00@00?l00?ooo`0000000000D@3oool001d0oooo00<00000@000003oool0o`3ooolU0?ooo`@0?coo
0P00o`0203looe00oooo000M0?ooo`030000003oool0oooo0?l0oooo9P3oool203loo`060?ooo`0o
?ol0?coo003o000o?ol00000C`3oool001d0oooo00<000000?ooo`3oool0o`3ooolY0?ooo`<0?coo
00@00?l00?ooo`0000000000C@3oool001d0oooo00<000000?ooo`3oool0o`3ooolZ0?ooo`<0?coo
0P00o`000`0o?ol000000?ooo`1;0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooob`0oooo0`0o
?ol00`00o`00oooo0000001;0?ooo`007@3oool00`00001000000?ooo`3o0?ooob`0oooo100o?ol0
1000o`00oooo0000000000190?ooo`007@3oool00`000000oooo0?ooo`3o0?ooobd0oooo0P0o?ol0
1P3oool0?coo003o0000o`00?coo000004P0oooo000M0?ooo`030000003oool0oooo0?l0oooo<03o
ool303loo`03003o003oool0000004L0oooo000@0?ooo`03@000003oool0oooo0080oooo00=00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?oooc00oooo100o?ol01000o`00?coo03loo`00
00150?ooo`003`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000H0oooo00<00000
0?ooo`3oool0o`3ooola0?ooo`@0?coo0P00o`000`3oool000000?ooo`130?ooo`004@3oool01T00
0000oooo0?oood000000oooo@00000H0oooo0P0000000d000000oooo0?ooo`3o0?oooc40oooo100o
?ol00`00o`00oooo000000130?ooo`003`3oool2@00000<0oooo00=000000?oood0000001P3oool0
0`000000oooo0?ooo`3o0?oooc@0oooo0P0o?ol00`3oool0?coo003o000203loo`030000003oool0
oooo03l0oooo000?0?ooo`03@000003oool0oooo0080oooo00=000000?oood0000001P3oool00`00
0000oooo0?ooo`3o0?ooocL0oooo0P0o?ol2003o00030?ooo`000000oooo03l0oooo000?0?ooo`=0
00000`3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo=`3oool403loo`03
003o003oool0000003l0oooo000M0?ooo`030000003oool0oooo0?l0oooo>03oool403loo`04003o
000o?ol00000000003d0oooo000M0?ooo`030000003oool0oooo0?l0oooo>P3oool303loo`800?l0
00<0oooo0000003oool0>`3oool001d0oooo00<00000@000003oool0o`3ooolj0?ooo`@0?coo00@0
oooo003o003oool00000>`3oool001d0oooo00<000000?ooo`3oool0o`3ooolk0?ooo`80?coo00D0
oooo03loo`0o?ol00?l003loo`02000003T0oooo000M0?ooo`030000003oool0oooo0?l0oooo?P3o
ool303loo`800?l000<0oooo0000003oool0=`3oool001d0oooo00<000000?ooo`3oool0o`3oooln
0?ooo`D0?coo00<00?l003loo`000000=`3oool001d0oooo00<000000?ooo`3oool0o`3ooolo0?oo
o`D0?coo00@00?l00?ooo`0000000000=@3oool001d0oooo00<00000@000003oool0o`3ooom10?oo
o`@0?coo0P00o`000`3oool000000?ooo`0c0?ooo`007@3oool00`000000oooo0?ooo`3o0?oood80
oooo0P0o?ol01P3oool0?coo03loo`00o`00?coo000003<0oooo000M0?ooo`030000003oool0oooo
0?l0ooooA@3oool303loo`03003o003oool000000380oooo000M0?ooo`030000003oool0oooo0?l0
ooooA@3oool403loo`800?l00P00000`0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooodH0oooo
0P0o?ol01P3oool0?coo03loo`00o`00?coo000002l0oooo000M0?ooo`030000003oool0oooo0?l0
ooooB@3oool303loo`03003o003oool0000002h0oooo000M0?ooo`03000004000000oooo0?l0oooo
B@3oool403loo`03003o003oool0000002d0oooo000M0?ooo`030000003oool0oooo0?l0ooooBP3o
ool203loo`050?ooo`0o?ol00?l0003o000o?ol0;03oool001d0oooo00<000000?ooo`3oool0o`3o
oom=0?ooo`<0?coo00<00?l0000000000000:P3oool001d0oooo00<000000?ooo`3oool0o`3ooom=
0?ooo`@0?coo00<00?l00?ooo`000000:@3oool001d0oooo00<000000?ooo`3oool0o`3ooom>0?oo
o`@0?coo0P00o`000`000000oooo0?ooo`0V0?ooo`007@3oool00`00001000000?ooo`3o0?oooe00
oooo100o?ol00`00o`0000000?ooo`0V0?ooo`007@3oool00`000000oooo0?ooo`3o0?oooe00oooo
100o?ol0103oool00?l000000000000U0?ooo`007@3oool00`000000oooo0?ooo`3o0?oooe40oooo
0P0o?ol00`3oool0?coo03loo`02003o00030000003oool0oooo0280oooo000M0?ooo`030000003o
ool0oooo0?l0ooooE03oool403loo`03003o00000000oooo0280oooo000?0?ooo`900000103oool0
0d000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooE03oool403loo`030?ooo`00o`00
00000280oooo000?0?ooo`03@000003ooom000000080oooo00=000000?oood0000001P3oool00`00
0000oooo0?ooo`3o0?oooeD0oooo0P0o?ol01@3oool0?coo03loo`00o`00?coo0240oooo000?0?oo
o`03@000003ooom000000080oooo00=000000?oood0000001P3oool200000003@000003oool0oooo
0?l0ooooEP3oool303loo`03003o04000000oooo01l0oooo000?0?ooo`9000000`3oool00d000000
oooo@00000060?ooo`030000003oool0oooo0?l0ooooF03oool403loo`03003o003oool0oooo01h0
oooo000?0?ooo`03@000003oool0oooo0080oooo00=000000?oood0000001P3oool00`000000oooo
0?ooo`3o0?oooeT0oooo0P0o?olR0?ooo`00403oool2@00000<0oooo00=000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`3o0?ooogd0oooo000M0?ooo`030000003oool0oooo0?l0ooooO@3oool0
01d0oooo00<00000@000003oool0o`3ooomm0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogd0
oooo000M0?ooo`030000003oool0oooo0?l0ooooO@3oool001d0oooo00<000000?ooo`3oool0o`3o
oomm0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogd0oooo000M0?ooo`03000004000000oooo
0?l0ooooO@3oool001d0oooo00<000000?ooo`3oool0o`3ooomm0?ooo`007@3oool00`000000oooo
0?ooo`3o0?ooogd0oooo000M0?ooo`030000003oool0oooo0?l0ooooO@3oool001d0oooo00<00000
0?ooo`3oool0o`3ooomm0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogd0oooo000M0?ooo`03
000004000000oooo0?l0ooooO@3oool001d0oooo00<000000?ooo`3oool0o`3ooomm0?ooo`007@3o
ool00`000000oooo0?ooo`3o0?ooogd0oooo000M0?ooo`030000003oool0oooo0?l0ooooO@3oool0
01d0oooo00<000000?ooo`3oool0o`3ooomm0?ooo`007@3oool00`00001000000?ooo`3o0?ooogd0
oooo000M0?ooo`030000003oool0oooo0?l0ooooO@3oool001d0oooo00<000000?ooo`3oool0o`3o
oomm0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogd0oooo000@0?ooo`03@000003oool0oooo
0080oooo00=000000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooogd0oooo000@0?ooo`07
@000003oool0oooo0?oood000000oooo@00000060?ooo`030000003oool0oooo0?l0ooooO@3oool0
0100oooo00M000000?ooo`3oool0oooo@000003ooom0000000H0oooo0P0000000d000000oooo0?oo
o`3o0?ooog/0oooo000A0?ooo`06@000003oool0oooo@000003ooom000001P3oool00`000000oooo
0?ooo`3o0?ooogd0oooo000?0?ooo`03@000003ooom000000080oooo00=000000?oood0000001P3o
ool00`000000oooo0?ooo`3o0?ooogd0oooo000?0?ooo`=000000`3oool00d000000oooo0?ooo`05
0?ooo`030000003oool0oooo0?l0ooooO@3oool001d0oooo00<000000?ooo`3oool0o`3ooomm0?oo
o`007@3oool00`00001000000?ooo`3o0?ooogd0oooo000M0?ooo`030000003oool0oooo0?l0oooo
O@3oool001d0oooo00<000000?ooo`3oool0o`3ooomm0?ooo`007@3oool00`000000oooo0?ooo`3o
0?ooogd0oooo000M0?ooo`030000003oool0oooo0?l0ooooO@3oool001d0oooo00<00000@000003o
ool0o`3ooomm0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogd0oooo000M0?ooo`030000003o
ool0oooo0?l0ooooO@3oool001d0oooo00<000000?ooo`3oool0o`3ooomm0?ooo`007@3oool00`00
0000oooo0?ooo`3o0?ooogd0oooo000M0?ooo`030000003oool0oooo0?l0ooooO@3oool001d0oooo
00<00000@000003oool0o`3ooomm0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooogd0oooo000M
0?ooo`030000003oool0oooo0?l0ooooO@3oool001d0oooo00<000000?ooo`3oool0o`3ooomm0?oo
o`007@3oool00`000000oooo0?ooo`3o0?ooogd0oooo000M0?ooo`03000004000000oooo0?l0oooo
O@3oool001d0oooo00<000000?ooo`3oool0o`3ooomm0?ooo`007@3oool00`000000oooo0?ooo`3o
0?ooogd0oooo000M0?ooo`030000003oool0oooo0?l0ooooO@3oool00100oooo00=000000?ooo`3o
ool00P3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooO@3oool000l0oooo
00=000000?oood0000000P3oool00d000000oooo@00000060?ooo`030000003oool0oooo0?l0oooo
O@3oool000l0oooo00=000000?oood0000000P3oool00d000000oooo@00000060?ooo`03@0000000
001000000?l0ooooO@3oool00100oooo00M000000?ooo`3oool0oooo@000003ooom000000?l0oooo
QP3oool000l0oooo00=000000?oood0000000P3oool00d000000oooo@000003o0?ooohH0oooo000@
0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0o`3ooon50?ooo`00o`3ooonM0?oo
o`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?oo
o`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`006`3oool2@000
0?l0ooooP03oool001X0oooo00=000000?oood000000o`3ooon00?ooo`006P3oool00d000000oooo
@000003o0?oooh00oooo000J0?ooo`04@000003oool0oooo@0000?l0ooooO`3oool001T0oooo00E0
00000?ooo`3oool0oooo@000003o0?ooogl0oooo000I0?ooo`90000000<0oooo@00004000000o`3o
oomo0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 411.563}, {253.938, 0}} -> {11.673, -4.93975, 
  0.285093, 0.369033}}]
}, Open  ]],

Cell[TextData[
"\"Err - rozdiel medzi explicitn\[YAcute]m rie\.9aen\[IAcute]m a na\.9aim v\
\[YAcute]sledkom\ntr1: tabu\:017eka chyby pribli\.9en\[EAcute]ho \
rie\.9aenia\""], "Text"],

Cell["\<\
Err[i_,sgm_]:=BoughtStraddle[xs[[i]],X,sgm,r,DD,t]-ys[[i]];
tr1:=Table[{xs[[i]],Err[i,sigma]},{i,2m+1}];\
\>", "Input"],

Cell["\"Maximov\[AAcute] chyba\"", "Text"],

Cell["\<\
Print[\"m = \",m,\" n = \",n,\" trans = \",trans,\" Max.chyba = \
\",Max[Table[Abs[Err[i,str]],{i,2m+1}]]]\
\>", "Input"],

Cell["\"Graf chyby pri delen\[IAcute] m = 100, n=100\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=ListPlot[tr1,PlotStyle->{PointSize[0.02],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->All]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.157596 0.00755858 0.178902 34.4756 [
[.14475 .1664 -6 -9 ]
[.14475 .1664 6 0 ]
[.29592 .1664 -6 -9 ]
[.29592 .1664 6 0 ]
[.44709 .1664 -6 -9 ]
[.44709 .1664 6 0 ]
[.59826 .1664 -9 -9 ]
[.59826 .1664 9 0 ]
[.74943 .1664 -9 -9 ]
[.74943 .1664 9 0 ]
[.9006 .1664 -9 -9 ]
[.9006 .1664 9 0 ]
[-0.01892 .00652 -36 -4.5 ]
[-0.01892 .00652 0 4.5 ]
[-0.01892 .09271 -42 -4.5 ]
[-0.01892 .09271 0 4.5 ]
[-0.01892 .26509 -36 -4.5 ]
[-0.01892 .26509 0 4.5 ]
[-0.01892 .35128 -30 -4.5 ]
[-0.01892 .35128 0 4.5 ]
[-0.01892 .43747 -36 -4.5 ]
[-0.01892 .43747 0 4.5 ]
[-0.01892 .52366 -24 -4.5 ]
[-0.01892 .52366 0 4.5 ]
[-0.01892 .60985 -36 -4.5 ]
[-0.01892 .60985 0 4.5 ]
[ -0.00642 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.14475 .1789 m
.14475 .18515 L
s
[(40)] .14475 .1664 0 1 Mshowa
.29592 .1789 m
.29592 .18515 L
s
[(60)] .29592 .1664 0 1 Mshowa
.44709 .1789 m
.44709 .18515 L
s
[(80)] .44709 .1664 0 1 Mshowa
.59826 .1789 m
.59826 .18515 L
s
[(100)] .59826 .1664 0 1 Mshowa
.74943 .1789 m
.74943 .18515 L
s
[(120)] .74943 .1664 0 1 Mshowa
.9006 .1789 m
.9006 .18515 L
s
[(140)] .9006 .1664 0 1 Mshowa
.125 Mabswid
.03137 .1789 m
.03137 .18265 L
s
.06916 .1789 m
.06916 .18265 L
s
.10695 .1789 m
.10695 .18265 L
s
.18254 .1789 m
.18254 .18265 L
s
.22033 .1789 m
.22033 .18265 L
s
.25813 .1789 m
.25813 .18265 L
s
.33371 .1789 m
.33371 .18265 L
s
.3715 .1789 m
.3715 .18265 L
s
.4093 .1789 m
.4093 .18265 L
s
.48488 .1789 m
.48488 .18265 L
s
.52268 .1789 m
.52268 .18265 L
s
.56047 .1789 m
.56047 .18265 L
s
.63605 .1789 m
.63605 .18265 L
s
.67385 .1789 m
.67385 .18265 L
s
.71164 .1789 m
.71164 .18265 L
s
.78723 .1789 m
.78723 .18265 L
s
.82502 .1789 m
.82502 .18265 L
s
.86281 .1789 m
.86281 .18265 L
s
.9384 .1789 m
.9384 .18265 L
s
.97619 .1789 m
.97619 .18265 L
s
.25 Mabswid
0 .1789 m
1 .1789 L
s
-0.00642 .00652 m
-0.00017 .00652 L
s
[(-0.005)] -0.01892 .00652 1 0 Mshowa
-0.00642 .09271 m
-0.00017 .09271 L
s
[(-0.0025)] -0.01892 .09271 1 0 Mshowa
-0.00642 .26509 m
-0.00017 .26509 L
s
[(0.0025)] -0.01892 .26509 1 0 Mshowa
-0.00642 .35128 m
-0.00017 .35128 L
s
[(0.005)] -0.01892 .35128 1 0 Mshowa
-0.00642 .43747 m
-0.00017 .43747 L
s
[(0.0075)] -0.01892 .43747 1 0 Mshowa
-0.00642 .52366 m
-0.00017 .52366 L
s
[(0.01)] -0.01892 .52366 1 0 Mshowa
-0.00642 .60985 m
-0.00017 .60985 L
s
[(0.0125)] -0.01892 .60985 1 0 Mshowa
.125 Mabswid
-0.00642 .02376 m
-0.00267 .02376 L
s
-0.00642 .041 m
-0.00267 .041 L
s
-0.00642 .05824 m
-0.00267 .05824 L
s
-0.00642 .07548 m
-0.00267 .07548 L
s
-0.00642 .10995 m
-0.00267 .10995 L
s
-0.00642 .12719 m
-0.00267 .12719 L
s
-0.00642 .14443 m
-0.00267 .14443 L
s
-0.00642 .16166 m
-0.00267 .16166 L
s
-0.00642 .19614 m
-0.00267 .19614 L
s
-0.00642 .21338 m
-0.00267 .21338 L
s
-0.00642 .23062 m
-0.00267 .23062 L
s
-0.00642 .24785 m
-0.00267 .24785 L
s
-0.00642 .28233 m
-0.00267 .28233 L
s
-0.00642 .29957 m
-0.00267 .29957 L
s
-0.00642 .3168 m
-0.00267 .3168 L
s
-0.00642 .33404 m
-0.00267 .33404 L
s
-0.00642 .36852 m
-0.00267 .36852 L
s
-0.00642 .38576 m
-0.00267 .38576 L
s
-0.00642 .40299 m
-0.00267 .40299 L
s
-0.00642 .42023 m
-0.00267 .42023 L
s
-0.00642 .45471 m
-0.00267 .45471 L
s
-0.00642 .47194 m
-0.00267 .47194 L
s
-0.00642 .48918 m
-0.00267 .48918 L
s
-0.00642 .50642 m
-0.00267 .50642 L
s
-0.00642 .5409 m
-0.00267 .5409 L
s
-0.00642 .55813 m
-0.00267 .55813 L
s
-0.00642 .57537 m
-0.00267 .57537 L
s
-0.00642 .59261 m
-0.00267 .59261 L
s
.25 Mabswid
-0.00642 0 m
-0.00642 .61803 L
s
.25 .25 1 r
.02 w
.02381 .1789 Mdot
.02548 .17897 Mdot
.02716 .17903 Mdot
.02887 .17908 Mdot
.03058 .17913 Mdot
.03231 .17918 Mdot
.03406 .17923 Mdot
.03583 .17927 Mdot
.03761 .17931 Mdot
.0394 .17934 Mdot
.04122 .17937 Mdot
.04305 .1794 Mdot
.04489 .17942 Mdot
.04676 .17944 Mdot
.04864 .17945 Mdot
.05054 .17946 Mdot
.05245 .17947 Mdot
.05439 .17947 Mdot
.05634 .17946 Mdot
.05831 .17944 Mdot
.06029 .17942 Mdot
.0623 .17938 Mdot
.06432 .17933 Mdot
.06637 .17927 Mdot
.06843 .17918 Mdot
.07051 .17907 Mdot
.07261 .17894 Mdot
.07473 .17877 Mdot
.07687 .17857 Mdot
.07903 .17832 Mdot
.0812 .17801 Mdot
.0834 .17765 Mdot
.08562 .17722 Mdot
.08786 .1767 Mdot
.09012 .17609 Mdot
.0924 .17536 Mdot
.0947 .17451 Mdot
.09702 .17352 Mdot
.09937 .17237 Mdot
.10173 .17103 Mdot
.10412 .1695 Mdot
.10653 .16773 Mdot
.10896 .16572 Mdot
.11141 .16343 Mdot
.11389 .16084 Mdot
.11639 .15793 Mdot
.11891 .15468 Mdot
.12145 .15106 Mdot
.12402 .14704 Mdot
.12662 .14263 Mdot
.12923 .1378 Mdot
.13187 .13254 Mdot
.13454 .12686 Mdot
.13723 .12076 Mdot
.13994 .11426 Mdot
.14268 .10738 Mdot
.14544 .10015 Mdot
.14823 .09263 Mdot
.15105 .08488 Mdot
.15389 .07697 Mdot
.15676 .06899 Mdot
.15965 .06105 Mdot
.16257 .05325 Mdot
.16552 .04575 Mdot
.16849 .03867 Mdot
.17149 .03218 Mdot
.17452 .02645 Mdot
.17758 .02166 Mdot
.18066 .01798 Mdot
.18378 .0156 Mdot
.18692 .01472 Mdot
.19009 .01549 Mdot
.19329 .0181 Mdot
.19652 .0227 Mdot
.19978 .02943 Mdot
.20307 .0384 Mdot
.20639 .04969 Mdot
.20974 .06337 Mdot
.21312 .07944 Mdot
.21653 .09789 Mdot
.21998 .11865 Mdot
.22345 .14162 Mdot
.22696 .16664 Mdot
.2305 .19352 Mdot
.23407 .222 Mdot
.23768 .25182 Mdot
.24132 .28265 Mdot
.24499 .31413 Mdot
.2487 .34587 Mdot
.25244 .37748 Mdot
.25621 .40853 Mdot
.26002 .4386 Mdot
.26386 .46726 Mdot
.26774 .49409 Mdot
.27166 .51871 Mdot
.27561 .54074 Mdot
.2796 .55985 Mdot
.28362 .57575 Mdot
.28768 .58821 Mdot
.29178 .59703 Mdot
.29592 .60209 Mdot
.30009 .60332 Mdot
.30431 .60072 Mdot
.30856 .59436 Mdot
.31285 .58436 Mdot
.31718 .57088 Mdot
.32155 .55418 Mdot
.32596 .53452 Mdot
.33041 .51223 Mdot
.3349 .48768 Mdot
.33944 .46124 Mdot
.34401 .43332 Mdot
.34863 .40432 Mdot
.35329 .37467 Mdot
.35799 .34476 Mdot
.36274 .31499 Mdot
.36753 .28573 Mdot
.37236 .25732 Mdot
.37724 .23006 Mdot
.38216 .20424 Mdot
.38713 .18008 Mdot
.39215 .15777 Mdot
.39721 .13746 Mdot
.40231 .11926 Mdot
.40747 .10323 Mdot
.41267 .08939 Mdot
.41792 .07772 Mdot
.42322 .06819 Mdot
.42856 .06072 Mdot
.43396 .0552 Mdot
.4394 .05151 Mdot
.4449 .04951 Mdot
.45044 .04905 Mdot
.45604 .04996 Mdot
.46169 .05208 Mdot
.46739 .05525 Mdot
.47314 .0593 Mdot
.47895 .06406 Mdot
.48481 .06939 Mdot
.49072 .07515 Mdot
.49669 .08121 Mdot
.50271 .08744 Mdot
.50879 .09375 Mdot
.51492 .10003 Mdot
.52111 .10621 Mdot
.52736 .11222 Mdot
.53367 .11802 Mdot
.54003 .12354 Mdot
.54645 .12877 Mdot
.55293 .13367 Mdot
.55947 .13824 Mdot
.56607 .14246 Mdot
.57274 .14635 Mdot
.57946 .14989 Mdot
.58624 .15311 Mdot
.59309 .15601 Mdot
.6 .15862 Mdot
.60697 .16094 Mdot
.61401 .163 Mdot
.62111 .16482 Mdot
.62828 .16642 Mdot
.63552 .16782 Mdot
.64282 .16903 Mdot
.65018 .17009 Mdot
.65762 .17099 Mdot
.66512 .17177 Mdot
.6727 .17243 Mdot
.68034 .17299 Mdot
.68805 .17347 Mdot
.69584 .17387 Mdot
.70369 .17421 Mdot
.71162 .17449 Mdot
.71962 .17473 Mdot
.7277 .17492 Mdot
.73585 .17509 Mdot
.74407 .17523 Mdot
.75237 .17535 Mdot
.76075 .17545 Mdot
.7692 .17554 Mdot
.77773 .17562 Mdot
.78634 .1757 Mdot
.79503 .17577 Mdot
.8038 .17584 Mdot
.81265 .17591 Mdot
.82158 .17598 Mdot
.83059 .17607 Mdot
.83969 .17615 Mdot
.84887 .17625 Mdot
.85813 .17635 Mdot
.86748 .17647 Mdot
.87692 .1766 Mdot
.88644 .17675 Mdot
.89605 .17691 Mdot
.90575 .17708 Mdot
.91554 .17728 Mdot
.92542 .17749 Mdot
.93539 .17773 Mdot
.94545 .17798 Mdot
.9556 .17826 Mdot
.96585 .17857 Mdot
.97619 .1789 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`004`3oool00d000000oooo0?ooo`020?ooo`03@000
003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000
003oool0oooo0?H0oooo000B0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3o
ool00d000000oooo@00000020?ooo`03@000003ooom0000000@0oooo00<000000?ooo`3oool0l03o
ool000d0oooo0d0000020?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool0
0d000000oooo@00000040?ooo`03@000003oool0oooo0080oooo00<00000@000003oool0l03oool0
0180oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom00000
0080oooo0T0000050?ooo`030000003oool0oooo0?00oooo000B0?ooo`03@000003ooom0000000L0
oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003oool0oooo00@0
oooo00<000000?ooo`3oool0:@3oool303lool@0oooo000C0?ooo`03@000003oool0oooo00L0oooo
00=000000?ooo`3oool00P3oool014000000oooo0?ooo`3oool3@00000@0oooo00<000000?ooo`3o
ool0:03oool603lool80oooo000]0?ooo`030000003oool0oooo02L0oooo1`0o?oo20?ooo`00;@3o
ool00`000000oooo0?ooo`0V0?ooo`@0?coo00@0oooo03loo`0o?ol0?coo`P3oool002d0oooo00<0
00000?ooo`3oool09P3oool303loo`<0oooo0`0o?oo10?ooo`00;@3oool00`000000oooo0?ooo`0U
0?ooo`<0?coo103oool303lool40oooo000]0?ooo`030000003oool0oooo02D0oooo0`0o?ol50?oo
o`<0?coo`03oool002d0oooo00<000000?ooo`3oool09@3oool303loo`D0oooo0`0o?oo00?ooo`00
;@3oool00`000000oooo0?ooo`0T0?ooo`<0?coo1`3oool00`0o?ol0oooo0?ooo`2o0?ooo`00;@3o
ool00`000000oooo0?ooo`0T0?ooo`<0?coo1`3oool303loocD0oooo200o?on20?ooo`00;@3oool0
0`000000oooo0?ooo`0S0?ooo`<0?coo203oool303looc@0oooo2`0o?on00?ooo`00;@3oool00`00
0000oooo0?ooo`0S0?ooo`<0?coo2@3oool00`0o?ol0oooo0?ooo`0a0?ooo`L0?coo00<0oooo03lo
o`0o?ol0100o?omo0?ooo`00;@3oool00`000000oooo0?ooo`0S0?ooo`<0?coo2@3oool303looc40
oooo100o?ol70?ooo`@0?cooOP3oool002d0oooo00<000000?ooo`3oool08P3oool303loo`X0oooo
0`0o?ol`0?ooo`<0?coo2P3oool503loog`0oooo000]0?ooo`030000003oool0oooo0280oooo0`0o
?ol;0?ooo`0303loo`3oool0oooo02l0oooo0`0o?ol;0?ooo`@0?cooO03oool002d0oooo00<00000
0?ooo`3oool08@3oool303loocd0oooo0`0o?ol>0?ooo`<0?cooN`3oool002d0oooo00<000000?oo
o`3oool08@3oool303loo`/0oooo0`0o?ol_0?ooo`<0?coo3P3oool503loogT0oooo000>0?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`04
@000003oool0oooo0?ooo`=000000`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo
0200oooo0`0o?ol<0?ooo`<0?coo<03oool00`0o?ol0oooo0?ooo`0>0?ooo`@0?cooN@3oool000d0
oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom000000080
oooo00=000000?ooo`3oool00P3oool00d000000oooo@00000040?ooo`030000003oool0oooo0200
oooo0`0o?ol=0?ooo`0303loo`3oool0oooo02`0oooo0`0o?olC0?ooo`<0?cooN03oool000P0oooo
0d0000020?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo
@00000030?ooo`03@000003oool0oooo00<0oooo00=000000?ooo`3oool00P3oool00`0000100000
0?ooo`0P0?ooo`<0?coo?03oool303looa<0oooo1@0o?omf0?ooo`003@3oool00d000000oooo@000
00070?ooo`03@000003ooom000000080oooo00=000000?oood0000000`3oool014000000oooo0?oo
o`3oool2@00000D0oooo00<000000?ooo`3oool0803oool303loo`d0oooo0`0o?ol]0?ooo`0303lo
o`3oool0oooo01<0oooo100o?omf0?ooo`003@3oool00d000000oooo@00000070?ooo`03@000003o
oom000000080oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003o
ool0oooo00@0oooo00<000000?ooo`3oool07`3oool303loo`h0oooo0`0o?om50?ooo`<0?cooM@3o
ool000h0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0
oooo0080oooo00A000000?ooo`3oool0oooo0d0000040?ooo`030000003oool0oooo01l0oooo0`0o
?ol?0?ooo`0303loo`3oool0oooo02X0oooo0`0o?olG0?ooo`@0?cooM03oool002d0oooo00<00000
0?ooo`3oool07P3oool303loocd0oooo0`0o?olH0?ooo`<0?cooM03oool002d0oooo00<000000?oo
o`3oool07P3oool303looch0oooo00<0?coo0?ooo`3oool0603oool403loog80oooo000]0?ooo`03
0000003oool0oooo01h0oooo0`0o?ol@0?ooo`<0?coo:@3oool303looa/0oooo100o?oma0?ooo`00
;@3oool00`000000oooo0?ooo`0M0?ooo`<0?coo4@3oool303loobT0oooo0`0o?olL0?ooo`<0?coo
L@3oool002d0oooo00<000000?ooo`3oool07@3oool303looa80oooo00<0?coo0?ooo`3oool0:@3o
ool00`0o?ol0oooo0?ooo`0L0?ooo`@0?cooK`3oool002d0oooo00<000000?ooo`3oool07@3oool3
03looeh0oooo1@0o?om]0?ooo`00;@3oool00`000000oooo0?ooo`0L0?ooo`<0?coo0T0000020?oo
o`03@000003oool0oooo01/0oooo0T0000040?ooo`03@000003oool0oooo01d0oooo00=000000?oo
o`3oool00P3oool00d000000oooo0?ooo`0@0?ooo`D0?coo0P3oool5@0000080oooo00=000000?oo
o`3oool00P3oool00d000000oooo0?ooo`0F0?ooo`E0000000@0oooo@0000400001000000`3oool0
0d000000oooo0?ooo`0E0?ooo`E000000P3oool3@0000080oooo00=000000?ooo`3oool04P3oool0
02d0oooo00<000000?ooo`3oool06`3oool403loo`06@000003oool0oooo@000003ooom00000703o
ool00d000000oooo@00000020?ooo`03@000003ooom0000001<0oooo0`0o?ol70?ooo`03@000003o
oom000000080oooo00=000000?oood0000004`3oool503loo`80oooo00M000000?ooo`3oool0oooo
@000003ooom000000080oooo00=000000?oood0000006@3oool01D000000oooo0?ooo`3ooom00000
00@0oooo00=000000?oood000000603oool00d000000oooo0?ooo`030?ooo`06@000003oool0oooo
@000003ooom000004`3oool002d0oooo00<000000?ooo`3oool06`3oool303loo`=0000000@0oooo
@000003ooom000003@3oool303loo``0oooo00=000000?oood0000000P3oool00d000000oooo@000
000C0?ooo`<0?coo1`3oool00d000000oooo@00000020?ooo`03@000003ooom0000001@0oooo1@0o
?ol00`3ooom000000?ooo`020?ooo`03@000003ooom000000080oooo00=000000?oood0000006@3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000H0?ooo`04
@000003oool0oooo0?ooo`A0000000@0oooo@000003ooom000004`3oool002d0oooo00<000000?oo
o`3oool06P3oool403loo`070?oood000000oooo0?oood000000oooo@000000=0?ooo`<0?coo303o
ool2@00000<0oooo00=000000?oood000000503oool00`0o?ol0oooo0?ooo`070?ooo`07@000003o
ool0oooo0?oood000000oooo@000000F0?ooo`D0?coo0`3oool00d000000oooo@00000020?ooo`03
@000003ooom0000001T0oooo00=000000?ooo`3oool00P3oool01d000000oooo0?ooo`3ooom00000
0?oood000000603oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000oooo
@000000C0?ooo`00;@3oool00`000000oooo0?ooo`0I0?ooo`@0?coo00<0oooo@000040000000P3o
ool00d000000oooo@000000>0?ooo`0303loo`3oool0oooo00/0oooo00=000000?ooo`3oool00P3o
ool00d000000oooo@000000M0?ooo`03@000003ooom000000080oooo00=000000?oood0000005`3o
ool603loo`040?oood000000oooo@0000080oooo00=000000?oood0000006@3oool01d000000oooo
0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000000H0?ooo`03@000003oool0oooo
0080oooo0T0000020?ooo`03@000003ooom0000001<0oooo000]0?ooo`030000003oool0oooo01T0
oooo0`0o?ol30?ooo`05@000003oool0oooo0?oood0000007P3oool2@00000<0oooo00=000000?oo
o`3oool07@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01P0oooo1`0o?ol40?oo
o`03@000003oool0oooo01L0oooo0T0000040?ooo`03@000003oool0oooo0080oooo00=000000?oo
o`3oool05P3oool2@00000D0oooo00E000000?ooo`3oool0oooo@000000D0?ooo`00;@3oool00`00
0000oooo0?ooo`0H0?ooo`@0?coo?P3oool303loob`0oooo200o?omO0?ooo`00;@3oool00`000000
oooo0?ooo`0G0?ooo`@0?coo?`3oool303loobd0oooo00<0?coo0?ooo`0o?ol0200o?omK0?ooo`00
;@3oool00`000000oooo0?ooo`0F0?ooo`@0?coo6@3oool303loobD0oooo00<0?coo0?ooo`3oool0
;`3oool00`0o?ol0oooo03loo`0:03looeH0oooo000]0?ooo`030000003oool0oooo01@0oooo1@0o
?olJ0?ooo`<0?cooF`3oool00`0o?ol0oooo03loo`0?03loodd0oooo000]0?ooo`030000003oool0
oooo0140oooo1`0o?olL0?ooo`0303loo`3oool0oooo05d0oooo00@0?coo0?ooo`0o?ol0ooooAP0o
?olB0?ooo`00;@3oool5000001D0?coo@P00000303looch000000P0o?ol01@000000?coo0000000o
?ol0000004T0?coo1@000001@0000000;@3oool00`000000oooo0?ooo`020?oooa@0?coo0P3oool0
0d000000oooo0?ooo`060?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool0
0d000000oooo0?ooo`060?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool0
0d000000oooo0?ooo`060?ooo`03@000003oool0?coo0080?coo103oool00d000000oooo0?ooo`07
0?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool00d000000oooo0?ooo`06
0?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool00d000000oooo0?ooo`06
0?ooo`03@000003oool0oooo0080?coo01X0oooo03loo`3oool0?coo@000000o?ol0oooo03loo`3o
ool0?coo0?ooo`0o?ol0oooo03loo`3oool0?coo0?ooo`0o?ol0oooo03loo`3oool0?coo@000000o
?ol0oooo03loo`80oooo00T0?coo0?ooo`0o?om0000003loo`3oool0?coo0?ooo`0o?ol00P3oool0
1`0o?ol0oooo03loo`3oool0?coo0?ooo`0o?ol00P3oool01@0o?ol0oooo03loo`3oool0?coo0080
oooo3P0o?ol60?ooo`00;@3oool00`000000oooo0?ooo`030?ooo`l0?cooB03oool00`0o?ol0oooo
0?ooo`210?ooo`0803loo`3oool0oooo03loo`3oool0?coo0?ooo`0o?ol20?ooo`0303loo`3oool0
oooo00D0oooo000]0?ooo`030000003oool0oooo03@0oooo0`0o?oni0?ooo`00;@3oool00`000000
oooo0?ooo`0d0?ooo`<0?coo^@3oool002d0oooo00<000000?ooo`3oool0=@3oool00`0o?ol0oooo
0?ooo`2h0?ooo`00;@3oool00`000000oooo0?ooo`1H0?ooo`<0?cooU@3oool002d0oooo00<00000
0?ooo`3oool0F03oool303looiD0oooo000]0?ooo`030000003oool0oooo05T0oooo00<0?coo0?oo
o`3oool0U03oool002d0oooo00<000000?ooo`3oool0l03oool002d0oooo00<000000?ooo`3oool0
=03oool303lookT0oooo000]0?ooo`030000003oool0oooo03@0oooo0`0o?oni0?ooo`00;@3oool0
0`000000oooo0?ooo`0e0?ooo`0303loo`3oool0oooo01l0oooo0`0o?onF0?ooo`00;@3oool00`00
0000oooo0?ooo`1G0?ooo`<0?cooUP3oool002d0oooo00<000000?ooo`3oool0F03oool00`0o?ol0
oooo0?ooo`2E0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?oo
o`3`0?ooo`00;@3oool00`000000oooo0?ooo`0e0?ooo`<0?coo^03oool002d0oooo00<000000?oo
o`3oool0=@3oool303lookP0oooo000>0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3o
ool00P3oool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo0?ooo`=000000`3oool00d00
0000oooo0?ooo`030?ooo`030000003oool0oooo03H0oooo00<0?coo0?ooo`3oool07@3oool303lo
oiL0oooo000=0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000
oooo@00000020?ooo`03@000003oool0oooo0080oooo00=000000?oood000000103oool00`000000
oooo0?ooo`1F0?ooo`<0?cooU`3oool000d0oooo00=000000?oood0000001`3oool00d000000oooo
@00000020?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3oool00`3oool00d000000oooo
0?ooo`020?ooo`03000004000000oooo05L0oooo00<0?coo0?ooo`3oool0UP3oool000d0oooo00=0
00000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0oooo00A0
00000?ooo`3oool0oooo0T0000050?ooo`030000003oool0oooo0?00oooo000=0?ooo`03@000003o
oom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003o
oom000000080oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`3`0?ooo`003P3oool0
0d000000oooo0?ooo`070?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool0
14000000oooo0?ooo`3oool3@00000@0oooo00<000000?ooo`3oool0l03oool002d0oooo00<00000
0?ooo`3oool0=P3oool303lookL0oooo000]0?ooo`030000003oool0oooo03H0oooo0`0o?olL0?oo
o`<0?cooV03oool002d0oooo00<000000?ooo`3oool0=`3oool00`0o?ol0oooo0?ooo`0K0?ooo`<0
?cooV03oool002d0oooo00<000000?ooo`3oool0EP3oool00`0o?ol0oooo0?ooo`2G0?ooo`00;@3o
ool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`00
0000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?ooo`0g0?ooo`<0?coo]P3oool002d0oooo
00<000000?ooo`3oool0=`3oool303looaT0oooo0`0o?onJ0?ooo`00;@3oool00`000000oooo0?oo
o`0h0?ooo`0303loo`3oool0oooo01P0oooo0`0o?onJ0?ooo`00;@3oool00`000000oooo0?ooo`1D
0?ooo`0303loo`3oool0oooo09T0oooo000]0?ooo`030000003oool0oooo0?00oooo000]0?ooo`03
0000003oool0oooo0?00oooo000]0?ooo`030000003oool0oooo0?00oooo000C0?ooo`03@000003o
ool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003o
ool0oooo0080oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`3`0?ooo`004P3oool0
0d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood0000000P3oool0
0d000000oooo@00000040?ooo`030000003oool0oooo03P0oooo0`0o?olG0?ooo`<0?cooV`3oool0
0180oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom00000
00@0oooo00=000000?ooo`3oool00P3oool00`00001000000?ooo`0h0?ooo`<0?coo5`3oool303lo
oi/0oooo000B0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000
oooo@00000020?ooo`9000001@3oool00`000000oooo0?ooo`0i0?ooo`0303loo`3oool0oooo01L0
oooo00<0?coo0?ooo`3oool0VP3oool00180oooo00=000000?oood0000001`3oool00d000000oooo
@00000020?ooo`03@000003ooom000000080oooo00=000000?ooo`3oool0103oool00`000000oooo
0?ooo`3`0?ooo`004`3oool00d000000oooo0?ooo`070?ooo`03@000003oool0oooo0080oooo00A0
00000?ooo`3oool0oooo0d0000040?ooo`030000003oool0oooo0?00oooo000]0?ooo`030000003o
ool0oooo0?00oooo000]0?ooo`030000003oool0oooo0?00oooo000]0?ooo`030000003oool0oooo
0540oooo0`0o?onL0?ooo`00;@3oool00`000000oooo0?ooo`0i0?ooo`<0?coo5@3oool303looi`0
oooo000]0?ooo`030000003oool0oooo03T0oooo0`0o?olF0?ooo`0303loo`3oool0oooo09/0oooo
000]0?ooo`030000003oool0oooo03X0oooo00<0?coo0?ooo`3oool0/`3oool002d0oooo00<00000
0?ooo`3oool0l03oool002d0oooo00<000000?ooo`3oool0l03oool002d0oooo00<000000?ooo`3o
ool0l03oool002d0oooo00<000000?ooo`3oool0D03oool303looid0oooo000]0?ooo`030000003o
ool0oooo03X0oooo0`0o?olC0?ooo`<0?cooW@3oool002d0oooo00<000000?ooo`3oool0>P3oool3
03looa@0oooo00<0?coo0?ooo`3oool0W03oool002d0oooo00<000000?ooo`3oool0>`3oool00`0o
?ol0oooo0?ooo`2b0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo
0?ooo`3`0?ooo`003P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`3`0?ooo`003@3oool00d000000oooo@0000007
0?ooo`03@000003ooom000000080oooo00=000000?oood0000000`3oool01d000000oooo0?ooo`3o
oom000000?oood000000103oool00`000000oooo0?ooo`1?0?ooo`<0?cooWP3oool000d0oooo00=0
00000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0oooo00=0
00000?ooo`3oool00`3oool00d000000oooo0?ooo`020?ooo`03000004000000oooo03/0oooo0`0o
?olA0?ooo`<0?cooWP3oool000d0oooo00=000000?oood0000001`3oool00d000000oooo@0000002
0?ooo`03@000003ooom0000000@0oooo00=000000?ooo`3oool00T0000050?ooo`030000003oool0
oooo03/0oooo0`0o?olB0?ooo`0303loo`3oool0oooo09d0oooo000=0?ooo`03@000003ooom00000
00L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003ooom00000
0080oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`0l0?ooo`0303loo`3oool0oooo
0;40oooo000>0?ooo`03@000003oool0oooo00L0oooo00=000000?ooo`3oool00P3oool014000000
oooo0?ooo`3oool3@0000080oooo0d0000040?ooo`030000003oool0oooo0?00oooo000]0?ooo`03
0000003oool0oooo0?00oooo000]0?ooo`030000003oool0oooo0?00oooo000]0?ooo`030000003o
ool0oooo04h0oooo0`0o?onO0?ooo`00;@3oool00`000000oooo0?ooo`0l0?ooo`<0?coo3`3oool3
03looil0oooo000]0?ooo`030000003oool0oooo03`0oooo0`0o?ol@0?ooo`0303loo`3oool0oooo
09h0oooo000]0?ooo`030000003oool0oooo03d0oooo00<0?coo0?ooo`3oool0/03oool002d0oooo
00<000000?ooo`3oool0l03oool002d0oooo00<000000?ooo`3oool0l03oool002d0oooo00<00000
0?ooo`3oool0C@3oool303looj00oooo000]0?ooo`030000003oool0oooo04d0oooo0`0o?onP0?oo
o`00;@3oool00`000000oooo0?ooo`0m0?ooo`<0?coo3P3oool00`0o?ol0oooo0?ooo`2O0?ooo`00
;@3oool00`000000oooo0?ooo`0m0?ooo`<0?coo/03oool002d0oooo00<000000?ooo`3oool0?P3o
ool00`0o?ol0oooo0?ooo`2_0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`00
0000oooo0?ooo`1<0?ooo`<0?cooX@3oool001P0oooo00=000000?ooo`3oool00P3oool00d000000
oooo0?ooo`020?ooo`03@000003oool0oooo00E000000`3oool00`000000oooo0?ooo`1<0?ooo`<0
?cooX@3oool001L0oooo00=000000?oood0000001`3oool00d000000oooo@00000030?ooo`03@000
003oool0oooo00<0oooo00<000000?ooo`3oool0?@3oool303loo`d0oooo00<0?coo0?ooo`3oool0
X03oool001L0oooo00=000000?oood0000001`3oool00d000000oooo@00000030?ooo`03@000003o
ool0oooo00<0oooo00<00000@000003oool0?@3oool303look00oooo000G0?ooo`03@000003ooom0
000000L0oooo00=000000?oood0000000`3oool00d000000oooo0?ooo`030?ooo`030000003oool0
oooo03h0oooo00<0?coo0?ooo`3oool0[`3oool001L0oooo00=000000?oood0000001`3oool00d00
0000oooo@00000030?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0B`3oool303lo
oj80oooo000H0?ooo`03@000003oool0oooo00L0oooo00A000000?ooo`3oool0oooo0T0000050?oo
o`030000003oool0oooo04/0oooo0`0o?onR0?ooo`00;@3oool00`000000oooo0?ooo`0n0?ooo`<0
?coo2`3oool00`0o?ol0oooo0?ooo`2Q0?ooo`00;@3oool00`000000oooo0?ooo`0n0?ooo`<0?coo
[`3oool002d0oooo00<000000?ooo`3oool0?`3oool00`0o?ol0oooo0?ooo`2^0?ooo`00;@3oool0
0`000000oooo0?ooo`190?ooo`<0?cooY03oool002d0oooo00<000000?ooo`3oool0?`3oool303lo
o`L0oooo0`0o?onT0?ooo`00;@3oool00`000000oooo0?ooo`0o0?ooo`<0?coo203oool00`0o?ol0
oooo0?ooo`2S0?ooo`00;@3oool00`000000oooo0?ooo`100?ooo`0303loo`3oool0oooo0:d0oooo
000]0?ooo`030000003oool0oooo04P0oooo0`0o?onU0?ooo`00;@3oool00`000000oooo0?ooo`10
0?ooo`<0?coo1@3oool303loojD0oooo000]0?ooo`030000003oool0oooo0400oooo0`0o?ol60?oo
o`0303loo`3oool0oooo0:@0oooo000]0?ooo`030000003oool0oooo0440oooo00<0?coo0?ooo`3o
ool00`3oool303loojH0oooo000]0?ooo`030000003oool0oooo0440oooo0`0o?ol30?ooo`<0?coo
YP3oool002d0oooo00<000000?ooo`3oool0@@3oool303loo`@0oooo00<0?coo0?ooo`3oool0Y@3o
ool002d0oooo00<000000?ooo`3oool0@P3oool303loo`040?ooo`0o?ol0?coo03loojL0oooo000]
0?ooo`030000003oool0oooo0480oooo1`0o?onW0?ooo`003P3oool00d000000oooo0?ooo`020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool01D000000103ooom00000@00004000003
0?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0@`3oool503loojP0oooo000=0?oo
o`03@000003ooom0000000L0oooo00=000000?oood0000000`3oool01D000000oooo0?ooo`3ooom0
000000@0oooo00=000000?oood000000103oool00`000000oooo0?ooo`130?ooo`@0?cooZ@3oool0
00d0oooo00=000000?oood0000001`3oool00d000000oooo@00000030?ooo`03@000003oool0oooo
0080oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`020?ooo`03000004000000oooo
04@0oooo0P0o?onZ0?ooo`003@3oool00d000000oooo@00000070?ooo`03@000003ooom0000000<0
oooo00=000000?ooo`3oool00P3oool014000000oooo0?ooo`3oool2@00000D0oooo00<000000?oo
o`3oool0l03oool000d0oooo00=000000?oood0000001`3oool00d000000oooo@00000030?ooo`07
@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003oool0oooo00@0oooo00=00000
0?ooo`3oool0l03oool000h0oooo00=000000?ooo`3oool01`3oool014000000oooo0?ooo`3oool2
@00000@0oooo00A000000?ooo`3oool0oooo0d00003g0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-4.76318, -0.00692227, 
  0.550222, 0.000120633}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{476, 303},
WindowMargins->{{33, Automatic}, {Automatic, 10}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 101, 3, 48, "Input"],
Cell[1813, 54, 62, 0, 33, "Text"],
Cell[1878, 56, 1382, 54, 1020, "Input"],
Cell[3263, 112, 44, 0, 33, "Text"],
Cell[3310, 114, 114, 11, 192, "Input"],
Cell[3427, 127, 47, 0, 33, "Text"],
Cell[3477, 129, 73, 0, 30, "Input"],
Cell[3553, 131, 66, 0, 30, "Input"],
Cell[3622, 133, 50, 0, 33, "Text"],
Cell[3675, 135, 134, 3, 66, "Input"],
Cell[3812, 140, 34, 0, 33, "Text"],
Cell[3849, 142, 56, 0, 30, "Input"],
Cell[3908, 144, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[3957, 148, 431, 10, 210, "Input"],
Cell[4391, 160, 33483, 892, 263, 9589, 593, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[37889, 1055, 183, 3, 52, "Text"],
Cell[38075, 1060, 129, 3, 48, "Input"],
Cell[38207, 1065, 42, 0, 33, "Text"],
Cell[38252, 1067, 131, 3, 48, "Input"],
Cell[38386, 1072, 64, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[38475, 1076, 178, 5, 84, "Input"],
Cell[38656, 1083, 25460, 695, 186, 7713, 471, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

