(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     64492,       1756]*)
(*NotebookOutlinePosition[     65188,       1781]*)
(*  CellTagsIndexPosition[     65144,       1777]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["<<c:\\math\\kniz\\options\\optvalue.m", "Input"],

Cell["\<\
\"Bought Strangle : kupa
 call opcie za vysoku realizacnu cenu
 put opcie za nizku realizacnu cenu\"\
\>", "Text"],

Cell["\<\
BoughtStrangleImpl[X1_,X2_,sigma_,r_,D_,t_,m_,n_,trans_,time_]:=
Module[
{doldiag,diag,hordiag},

X=(X1+X2)/2;
xright=Log[Slarge/X];
xleft=-xright;

k1=N[r/(0.5*sigma^2)];
k2=N[(r-D)/(0.5*sigma^2)];
k3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
k4=N[0.25*(k2^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

BoughtStranglePayoff[x_]:=N[Exp[0.5*(k2-1)*x]*(Max[Exp[x]-X1/X,0]+Max[-Exp[x]+\
X2/X,0])];
Do[u[i,0]=BoughtStranglePayoff[i*h],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
 Do[
      grad=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      kriv=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
ClenAbs[i]=Abs[N[k4*u[i,j-1]-k2*grad+kriv]],{i,-m+1,m-1}];

op1=Exp[0.5*(k2-1)*xleft+0.25*(k2-1)^2*k*j]*X2/X-
    Exp[0.5*(k2+1)*xleft+0.25*(k2+1)^2*k*j];
op2=Exp[0.5*(k2+1)*xright+0.25*(k2+1)^2*k*j]-
    Exp[0.5*(k2-1)*xright+0.25*(k2-1)^2*k*j]*X1/X;

ps = Join[{u[-m+1,j-1]-k3*k*ClenAbs[-m+1]-a*op1},
          Table[u[i,j-1]-k3*k*ClenAbs[i],{i,-m+2,m-2}],
          {u[m-1,j-1]-k3*k*ClenAbs[m-1]-c*op2}];

hordiag=Table[c,{i,-m+1,m-2}];
diag=Table[b,{i,-m+1,m-1}];
doldiag=Table[a,{i,-m+2,m-1}];

riesenie=TridiagonalSolve[N[doldiag],N[diag],N[hordiag],N[ps]];
 
u[-m,j]=op1;
Do[u[i,j]=riesenie[[i+m]],{i,-m+1,m-1}];
u[m,j] =op2;

xs=Table[X*Exp[i*h],{i,-m,m}];
ys=Table[X*Exp[-0.5*(k2-1)*i*h-(0.25*(k2-1)^2+k1)*j*k]*u[i,j],{i,-m,m}];
graf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
{j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X1=65;
X2=50;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=100;
n=100;
Slarge=150;
trans=0.02;
time=0.03;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["BoughtStrangleImpl[X1,X2,sigma,r,DD,t,m,n,trans,time]", "Input"],

Cell["\"Explicitn\[EAcute] rie\.9aenie\"", "Text"],

Cell["\<\
BoughtStrangle[S_,X1_,X2_,sigma_,r_,DD_,t_]:=
N[EuropeanCallDiv[S,X1,sigma,r,DD,t]+EuropeanPutDiv[S,X2,sigma,r,DD,t]]\
\>", "Input"],

Cell["\"Payoff diagram\"", "Text"],

Cell["Payoff[S_,X1_,X2_]:=N[Max[S-X1,0]+Max[X2-S,0]]", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[BoughtStrangle[S,X1,X2,sigma,r,DD,t],{S,0,150},PlotRange->All,\
PlotStyle->RGBColor[0,1,0], DisplayFunction->Identity];
g1=ListPlot[graf[n],PlotStyle->{PointSize[0.015],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];
g2=Plot[Payoff[S,X1,X2],{S,0,150},PlotStyle -> 
{Thickness[0.006]},PlotRange->All, DisplayFunction->Identity];

Show[g2,g1,g,AxesLabel -> \
{\"S\",\"V\"},DisplayFunction->$DisplayFunction,PlotRange->{{20,120},{-1,60}}]\

\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.2 0.01 0.0101317 0.0101317 [
[.2 -0.00237 -6 -9 ]
[.2 -0.00237 6 0 ]
[.4 -0.00237 -6 -9 ]
[.4 -0.00237 6 0 ]
[.6 -0.00237 -6 -9 ]
[.6 -0.00237 6 0 ]
[.8 -0.00237 -9 -9 ]
[.8 -0.00237 9 0 ]
[1 -0.00237 -9 -9 ]
[1 -0.00237 9 0 ]
[1.025 .01013 0 -7.5 ]
[1.025 .01013 10 7.5 ]
[-0.0125 .11145 -12 -4.5 ]
[-0.0125 .11145 0 4.5 ]
[-0.0125 .21277 -12 -4.5 ]
[-0.0125 .21277 0 4.5 ]
[-0.0125 .31408 -12 -4.5 ]
[-0.0125 .31408 0 4.5 ]
[-0.0125 .4154 -12 -4.5 ]
[-0.0125 .4154 0 4.5 ]
[-0.0125 .51672 -12 -4.5 ]
[-0.0125 .51672 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[0 .64303 -5.5 0 ]
[0 .64303 5.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2 .01013 m
.2 .01638 L
s
[(40)] .2 -0.00237 0 1 Mshowa
.4 .01013 m
.4 .01638 L
s
[(60)] .4 -0.00237 0 1 Mshowa
.6 .01013 m
.6 .01638 L
s
[(80)] .6 -0.00237 0 1 Mshowa
.8 .01013 m
.8 .01638 L
s
[(100)] .8 -0.00237 0 1 Mshowa
1 .01013 m
1 .01638 L
s
[(120)] 1 -0.00237 0 1 Mshowa
.125 Mabswid
.05 .01013 m
.05 .01388 L
s
.1 .01013 m
.1 .01388 L
s
.15 .01013 m
.15 .01388 L
s
.25 .01013 m
.25 .01388 L
s
.3 .01013 m
.3 .01388 L
s
.35 .01013 m
.35 .01388 L
s
.45 .01013 m
.45 .01388 L
s
.5 .01013 m
.5 .01388 L
s
.55 .01013 m
.55 .01388 L
s
.65 .01013 m
.65 .01388 L
s
.7 .01013 m
.7 .01388 L
s
.75 .01013 m
.75 .01388 L
s
.85 .01013 m
.85 .01388 L
s
.9 .01013 m
.9 .01388 L
s
.95 .01013 m
.95 .01388 L
s
.25 Mabswid
0 .01013 m
1 .01013 L
s
gsave
1.025 .01013 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .11145 m
.00625 .11145 L
s
[(10)] -0.0125 .11145 1 0 Mshowa
0 .21277 m
.00625 .21277 L
s
[(20)] -0.0125 .21277 1 0 Mshowa
0 .31408 m
.00625 .31408 L
s
[(30)] -0.0125 .31408 1 0 Mshowa
0 .4154 m
.00625 .4154 L
s
[(40)] -0.0125 .4154 1 0 Mshowa
0 .51672 m
.00625 .51672 L
s
[(50)] -0.0125 .51672 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(60)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0304 m
.00375 .0304 L
s
0 .05066 m
.00375 .05066 L
s
0 .07092 m
.00375 .07092 L
s
0 .09119 m
.00375 .09119 L
s
0 .13171 m
.00375 .13171 L
s
0 .15198 m
.00375 .15198 L
s
0 .17224 m
.00375 .17224 L
s
0 .1925 m
.00375 .1925 L
s
0 .23303 m
.00375 .23303 L
s
0 .25329 m
.00375 .25329 L
s
0 .27356 m
.00375 .27356 L
s
0 .29382 m
.00375 .29382 L
s
0 .33435 m
.00375 .33435 L
s
0 .35461 m
.00375 .35461 L
s
0 .37487 m
.00375 .37487 L
s
0 .39514 m
.00375 .39514 L
s
0 .43566 m
.00375 .43566 L
s
0 .45593 m
.00375 .45593 L
s
0 .47619 m
.00375 .47619 L
s
0 .49645 m
.00375 .49645 L
s
0 .53698 m
.00375 .53698 L
s
0 .55724 m
.00375 .55724 L
s
0 .57751 m
.00375 .57751 L
s
0 .59777 m
.00375 .59777 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(V) show
69.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.006 w
0 .31408 m
.04948 .26395 L
.11328 .19931 L
.17469 .13709 L
.23997 .07095 L
.27267 .03782 L
.28704 .02327 L
.29466 .01554 L
.29685 .01332 L
.29794 .01222 L
.29894 .0112 L
.30081 .01013 L
.30286 .01013 L
.31802 .01013 L
.33223 .01013 L
.36336 .01013 L
.39297 .01013 L
.42499 .01013 L
.43353 .01013 L
.4382 .01013 L
.44255 .01013 L
.44627 .01013 L
.44734 .01013 L
.44836 .01013 L
.45026 .01039 L
.45128 .01143 L
.45236 .01252 L
.45431 .0145 L
.45871 .01896 L
.49048 .05115 L
.54994 .11139 L
.61326 .17554 L
.67419 .23728 L
.73899 .30293 L
.8014 .36616 L
.86142 .42697 L
.9253 .49169 L
.9868 .554 L
s
.9868 .554 m
1 .56738 L
s
.25 .25 1 r
.015 w
.02042 .28735 Mdot
.02254 .2852 Mdot
.02468 .28303 Mdot
.02685 .28084 Mdot
.02903 .27862 Mdot
.03124 .27639 Mdot
.03347 .27413 Mdot
.03572 .27185 Mdot
.03799 .26955 Mdot
.04028 .26723 Mdot
.0426 .26488 Mdot
.04494 .26251 Mdot
.04729 .26012 Mdot
.04968 .25771 Mdot
.05208 .25527 Mdot
.05451 .25281 Mdot
.05696 .25033 Mdot
.05944 .24782 Mdot
.06194 .24528 Mdot
.06446 .24273 Mdot
.06701 .24015 Mdot
.06958 .23754 Mdot
.07218 .23491 Mdot
.0748 .23225 Mdot
.07745 .22957 Mdot
.08012 .22686 Mdot
.08282 .22413 Mdot
.08555 .22137 Mdot
.0883 .21858 Mdot
.09108 .21576 Mdot
.09388 .21292 Mdot
.09671 .21005 Mdot
.09957 .20716 Mdot
.10246 .20423 Mdot
.10537 .20128 Mdot
.10831 .1983 Mdot
.11128 .19529 Mdot
.11428 .19225 Mdot
.11731 .18918 Mdot
.12037 .18609 Mdot
.12345 .18296 Mdot
.12657 .1798 Mdot
.12972 .17661 Mdot
.13289 .1734 Mdot
.1361 .17015 Mdot
.13934 .16687 Mdot
.14261 .16355 Mdot
.14591 .16021 Mdot
.14924 .15683 Mdot
.15261 .15343 Mdot
.15601 .14999 Mdot
.15944 .14651 Mdot
.1629 .14301 Mdot
.16639 .13947 Mdot
.16992 .1359 Mdot
.17349 .1323 Mdot
.17709 .12867 Mdot
.18072 .125 Mdot
.18439 .1213 Mdot
.18809 .11758 Mdot
.19183 .11382 Mdot
.19561 .11004 Mdot
.19942 .10624 Mdot
.20327 .10241 Mdot
.20715 .09856 Mdot
.21107 .0947 Mdot
.21503 .09083 Mdot
.21903 .08696 Mdot
.22307 .08309 Mdot
.22715 .07922 Mdot
.23126 .07538 Mdot
.23542 .07156 Mdot
.23961 .06778 Mdot
.24385 .06404 Mdot
.24812 .06037 Mdot
.25244 .05677 Mdot
.2568 .05325 Mdot
.2612 .04983 Mdot
.26564 .04652 Mdot
.27013 .04333 Mdot
.27466 .04028 Mdot
.27923 .03738 Mdot
.28385 .03463 Mdot
.28851 .03205 Mdot
.29322 .02964 Mdot
.29797 .02741 Mdot
.30277 .02536 Mdot
.30761 .02349 Mdot
.3125 .02181 Mdot
.31744 .02031 Mdot
.32243 .01899 Mdot
.32746 .01784 Mdot
.33254 .01687 Mdot
.33767 .01607 Mdot
.34285 .01544 Mdot
.34808 .01498 Mdot
.35336 .01467 Mdot
.3587 .01453 Mdot
.36408 .01456 Mdot
.36951 .01475 Mdot
.375 .01512 Mdot
.38054 .01567 Mdot
.38613 .0164 Mdot
.39178 .01733 Mdot
.39748 .01847 Mdot
.40324 .01983 Mdot
.40905 .02143 Mdot
.41492 .02326 Mdot
.42084 .02536 Mdot
.42682 .02772 Mdot
.43286 .03035 Mdot
.43896 .03327 Mdot
.44512 .03647 Mdot
.45133 .03996 Mdot
.45761 .04375 Mdot
.46394 .04782 Mdot
.47034 .05218 Mdot
.4768 .05681 Mdot
.48332 .06172 Mdot
.4899 .06688 Mdot
.49655 .07229 Mdot
.50326 .07794 Mdot
.51004 .0838 Mdot
.51688 .08987 Mdot
.52378 .09614 Mdot
.53076 .10258 Mdot
.5378 .10919 Mdot
.54491 .11596 Mdot
.55208 .12287 Mdot
.55933 .12992 Mdot
.56665 .13709 Mdot
.57403 .14438 Mdot
.58149 .15178 Mdot
.58902 .15928 Mdot
.59662 .16688 Mdot
.6043 .17458 Mdot
.61205 .18237 Mdot
.61987 .19025 Mdot
.62777 .19821 Mdot
.63574 .20626 Mdot
.6438 .2144 Mdot
.65193 .22262 Mdot
.66013 .23092 Mdot
.66842 .23931 Mdot
.67679 .24778 Mdot
.68523 .25633 Mdot
.69376 .26497 Mdot
.70237 .27369 Mdot
.71107 .2825 Mdot
.71985 .29139 Mdot
.72871 .30037 Mdot
.73766 .30944 Mdot
.74669 .31859 Mdot
.75581 .32783 Mdot
.76502 .33716 Mdot
.77432 .34658 Mdot
.78371 .35609 Mdot
.79318 .36569 Mdot
.80275 .37539 Mdot
.81241 .38517 Mdot
.82217 .39506 Mdot
.83202 .40503 Mdot
.84196 .41511 Mdot
.852 .42528 Mdot
.86213 .43555 Mdot
.87237 .44592 Mdot
.8827 .45638 Mdot
.89313 .46695 Mdot
.90366 .47762 Mdot
.91429 .4884 Mdot
.92503 .49927 Mdot
.93587 .51026 Mdot
.94681 .52134 Mdot
.95786 .53254 Mdot
.96902 .54384 Mdot
.98028 .55525 Mdot
.99165 .56677 Mdot
0 1 0 r
.5 Mabswid
0 .30804 m
.04948 .25791 L
.11328 .19331 L
.17469 .1322 L
.20599 .10313 L
.23997 .07533 L
.25584 .06423 L
.27267 .05405 L
.28843 .04611 L
.30286 .04027 L
.31768 .03571 L
.32586 .03384 L
.33363 .03247 L
.33709 .032 L
.34077 .03158 L
.34425 .03126 L
.34741 .03105 L
.34934 .03095 L
.35113 .03088 L
.35308 .03083 L
.35515 .0308 L
.35695 .03079 L
.35863 .03081 L
.36047 .03085 L
.36245 .03092 L
.36437 .03101 L
.36648 .03113 L
.37077 .03147 L
.37474 .0319 L
.37847 .03238 L
.38686 .03378 L
.3959 .03577 L
.41243 .04064 L
.42759 .04644 L
.4574 .06124 L
.49 .08192 L
.55388 .13251 L
.61538 .18895 L
.68074 .25283 L
.74371 .31588 L
.8043 .37704 L
.86874 .44227 L
.9308 .50513 L
.99047 .56558 L
s
.99047 .56558 m
1 .57523 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{387.688, 239.563},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000630000kb000`400?l00000o`00003oo`3ooon4
0?ooo`00F@3oool3@0000080oooo00=000000?ooo`3oool0>P3oool2@00000@0oooo00=000000?oo
o`3oool0>P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo03H0oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0<`3oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool05P3oool005X0oooo00I000000?ooo`3ooom000000?oood00
000k0?ooo`03@000003ooom000000080oooo00=000000?oood000000>P3oool00d000000oooo@000
00020?ooo`03@000003ooom0000003T0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood000000=P3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oo
od0000005`3oool005P0oooo14000000103ooom000000?oood00000k0?ooo`03@000003ooom00000
0080oooo00=000000?oood000000>P3oool00d000000oooo@00000020?ooo`03@000003ooom00000
03T0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000=P3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000G0?ooo`00
F03oool00d000000oooo@00000020?ooo`03@000003ooom0000003/0oooo0T0000030?ooo`03@000
003ooom0000003/0oooo00M000000?ooo`3oool0oooo@000003ooom0000003T0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood000000=P3oool00d000000oooo0?oo
o`020?ooo`07@000003oool0oooo0?oood000000oooo@000000G0?ooo`00F@3oool2@0000080oooo
00=000000?oood000000>`3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000003X0oooo
00=000000?oood0000000P3oool00d000000oooo@000000i0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000020?ooo`03@000003ooom0000003H0oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood0000005`3oool005X0oooo00E000000?ooo`3oool0oooo@000
000m0?ooo`9000000`3oool00d000000oooo0?ooo`0j0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool0=`3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`0d0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01H0oooo003o
0?oooh@0oooo003o0?oooh@0oooo003o0?oooh@0oooo000J0?ooo`030000003oool0oooo0?l0oooo
I`3oool001X0oooo00<000000?ooo`3oool0o`3ooomE0?ooo`=000003`3oool001X0oooo00<00000
0?ooo`3oool0o`3ooomE0?ooo`03@000003ooom0000000l0oooo000J0?ooool00000C@0000000d00
0000oooo0?ooo`0:0?ooo`03@000003oool0oooo00d0oooo000J0?ooo`030000003oool0oooo00d0
oooo00=000000?ooo`3oool03P3oool00d000000oooo0?ooo`0=0?ooo`03@000003oool0oooo00h0
oooo00<000000?ooo`3oool03P3oool00d000000oooo0?ooo`0<0?ooo`800000403oool014000000
?coo03loo`0o?ol=0?ooo`030000003oool0oooo00d0oooo00=000000000003oool03P3oool00d00
0000oooo0?ooo`0=0?ooo`03@000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00d00
0000oooo0?ooo`0=0?ooo`03@000003oool0oooo00h0oooo00=000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0=0?ooo`03@000003oool0oooo00h0oooo00=000000?ooo`3oool03@3oool00d00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00T0oooo00=000000?ooo`3oool03P3oool001X0
oooo00<000000?ooo`3oool0?`3oool00d000000oooo0?ooo`0M0?ooo`030000003oool0oooo00L0
oooo5`0o?ol20?ooo`03@000003oool0oooo00l0oooo00<000000?ooo`3oool0;@3oool00d000000
oooo0?ooo`100?ooo`03@000003oool0oooo03l0oooo00=000000?ooo`3oool0203oool00d000000
oooo@000000?0?ooo`006P3oool00`000000oooo0?ooo`1M0?ooo`8000001@3ooolP03looa40oooo
00<000000?ooo`3oool0_03oool3@00000l0oooo000J0?ooo`030000003oool0oooo05`0oooo00<0
00000?ooo`3oool00P3oool:03loo`030?ooo`0o?ol0oooo0080?coo00<0oooo03loo`3oool00P3o
ool203loo`070?ooo`0o?ol0oooo03loo`3oool0?coo0?ooo`0:03loo`h0oooo00<000000?ooo`3o
ool0c@3oool001X0oooo00<000000?ooo`3oool0F`3oool010000000oooo0?ooo`3oool703loo`03
0?ooo`0o?ol0?coo01L0oooo00<0?coo0?ooo`0o?ol01`0o?ol=0?ooo`030000003oool0oooo0<`0
oooo000J0?ooo`030000003oool0oooo05X0oooo00@000000?ooo`3oool0oooo1P0o?olP0?ooo`03
03loo`3oool0?coo00D0?coo303oool00`000000oooo0?ooo`3;0?ooo`006P3oool00`0000100000
0?ooo`1I0?ooo`030000003oool0?coo00D0?coo303oool?003o00`0oooo1P0o?ol;0?ooo`030000
003oool0oooo0<X0oooo000J0?ooo`030000003oool0oooo05P0oooo00<0000003loo`0o?ol01@0o
?ol80?ooo`D00?l03`3oool3003o00/0oooo1P0o?ol:0?ooo`030000003oool0oooo0<T0oooo000J
0?ooo`030000003oool0oooo05L0oooo1`0o?ol60?ooo`@00?l05`3oool4003o00T0oooo1P0o?ol9
0?ooo`030000003oool0oooo0<P0oooo000J0?ooo`030000003oool0oooo05H0oooo1@0o?ol50?oo
o`@00?l07`3oool5003o00H0oooo1P0o?ol80?ooo`030000003oool0oooo0<L0oooo000J0?ooo`03
0000003oool0oooo05@0oooo1@0o?ol50?ooo`800?l0:03oool2003o00H0oooo1P0o?ol70?ooo`03
0000003oool0oooo0<H0oooo000J0?ooo`030000003oool0oooo05<0oooo1@0o?ol40?ooo`800?l0
;03oool2003o00H0oooo100o?ol80?ooo`030000003oool0oooo0<D0oooo000J0?ooo`030000003o
ool0oooo0540oooo1@0o?ol40?ooo`800?l0<03oool2003o00H0oooo100o?ol70?ooo`030000003o
ool0oooo0<@0oooo000J0?ooo`03000004000000oooo0500oooo1@0o?ol30?ooo`800?l0=03oool2
003o00D0oooo1@0o?ol60?ooo`030000003oool0oooo0<<0oooo000J0?ooo`030000003oool0oooo
0500oooo0`0o?ol40?ooo`03003o003oool0oooo03H0oooo0P00o`040?ooo`@0?coo1`3oool00`00
0000oooo0?ooo`320?ooo`006P3oool00`000000oooo0?ooo`1?0?ooo`<0?coo0`3oool2003o03/0
oooo0P00o`040?ooo`@0?coo1P3oool00`000000oooo0?ooo`310?ooo`006P3oool00`000000oooo
0?ooo`1=0?ooo`D0?coo00<0oooo003o0000o`00?`3oool2003o00<0oooo1@0o?ol50?ooo`030000
003oool0oooo0<00oooo000J0?ooo`030000003oool0oooo04`0oooo1@0o?ol00`3oool00?l00?oo
o`120?ooo`800?l00P3oool403loo`H0oooo00<000000?ooo`3oool0_`3oool001X0oooo00<00000
0?ooo`3oool0BP3oool503loo`030?ooo`00o`000?l004H0oooo00@00?l00?ooo`3oool0oooo100o
?ol50?ooo`030000003oool0oooo0;h0oooo000J0?ooo`03000004000000oooo04T0oooo1@0o?ol0
0`3oool00?l00?ooo`180?ooo`04003o003oool0oooo0?ooo`<0?coo1P3oool00`000000oooo0?oo
o`2m0?ooo`006P3oool00`000000oooo0?ooo`190?ooo`<0?coo00<0oooo003o0000o`00B`3oool2
003o0080oooo00<0?coo0?ooo`0o?ol00P0o?ol40?ooo`030000003oool0oooo0;`0oooo000J0?oo
o`030000003oool0oooo04L0oooo100o?ol00`3oool00?l00?ooo`1>0?ooo`04003o003oool0oooo
0?ooo`<0?coo1@3oool00`000000oooo0?ooo`2k0?ooo`006P3oool00`000000oooo0?ooo`160?oo
o`@0?coo00<0oooo003o003oool0D03oool2003o0080oooo100o?ol40?ooo`030000003oool0oooo
0;X0oooo000J0?ooo`030000003oool0oooo04D0oooo100o?ol2003o05@0oooo00<00?l00?ooo`3o
ool00`0o?ol50?ooo`030000003oool0oooo0;T0oooo000J0?ooo`030000003oool0oooo04D0oooo
0`0o?ol00`00o`00oooo0?ooo`1E0?ooo`03003o003oool0oooo00@0?coo0`3oool00`000000oooo
0?ooo`2i0?ooo`006P3oool00`000000oooo0?ooo`130?ooo`@0?coo00<00?l00?ooo`3oool0E`3o
ool2003o00040?ooo`0o?ol0?coo03loo`@0oooo00<000000?ooo`3oool0^03oool001X0oooo00<0
0000@000003oool0@P3oool403loo`03003o003oool0oooo05X0oooo00<00?l00?ooo`0o?ol00`0o
?ol30?ooo`030000003oool0oooo0;L0oooo000J0?ooo`030000003oool0oooo0440oooo100o?ol0
0`00o`00oooo0?ooo`1L0?ooo`03003o003oool0?coo0080?coo103oool00`000000oooo0?ooo`2f
0?ooo`006P3oool00`000000oooo0?ooo`0o0?ooo`@0?coo0P00o`1P0?ooo`800?l000<0?coo0?oo
o`0o?ol00P0o?ol20?ooo`030000003oool0oooo0;D0oooo000J0?ooo`030000003oool0oooo03l0
oooo0`0o?ol00`00o`00oooo0?ooo`1R0?ooo`03003o003oool0?coo0080?coo0`3oool00`000000
oooo0?ooo`2d0?ooo`006P3oool00`000000oooo0?ooo`0n0?ooo`<0?coo00<00?l00?ooo`3oool0
I03oool00`00o`00oooo03loo`0303loo`80oooo00<000000?ooo`3oool0/`3oool000/0oooo1D00
00020?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool0?@3oool303loo`03003o0000
0000oooo06H0oooo00<00?l00?ooo`0o?ol00P0o?ol30?ooo`030000003oool0oooo0;80oooo000=
0?ooo`07@000003oool0oooo0?oood000000oooo@00000060?ooo`030000003oool0oooo03`0oooo
0`0o?ol00`00o`0000000?ooo`1X0?ooo`800?l0100o?ol20?ooo`030000003oool0oooo0;40oooo
000=0?ooo`07@000003oool0oooo0?oood000000oooo@00000060?ooo`80000000=000000?ooo`3o
ool0>P3oool203loo`03003o00000000oooo06/0oooo00@00?l003loo`0o?ol0?coo0`3oool00`00
0000oooo0?ooo`2`0?ooo`003@3oool01d000000oooo0?ooo`3ooom000000?oood0000001P3oool0
0`000000oooo0?ooo`0j0?ooo`<0?coo00<00?l00000003oool0K@3oool00`00o`00?coo0?ooo`03
03loo`030?ooo`000000oooo0;00oooo000=0?ooo`07@000003oool0oooo0?oood000000oooo@000
00060?ooo`030000003oool0oooo03T0oooo0`0o?ol00`00o`0000000?ooo`1_0?ooo`800?l00`0o
?ol20?ooo`030000003oool0oooo0:h0oooo000<0?ooo`900000103oool00d000000oooo0?ooo`05
0?ooo`030000003oool0oooo03P0oooo0`0o?ol00`00o`0000000?ooo`1b0?ooo`03003o000o?ol0
oooo00<0oooo00<000000?ooo`3oool0[@3oool001X0oooo00<000000?ooo`3oool0=`3oool303lo
o`03003o00000000oooo07@0oooo00@00?l003loo`0o?ol0?coo0P3oool00`000000oooo0?ooo`2/
0?ooo`006P3oool00`000000oooo0?ooo`0e0?ooo`@0?coo00<00?l00000003oool0MP3oool2003o
000503loo`3oool0oooo0?ooo`000000[@3oool001X0oooo00<000000?ooo`3oool0=@3oool303lo
o`03003o00000000oooo07P0oooo00<0?coo003o000o?ol00P0o?ol00`3oool000000?ooo`2[0?oo
o`006P3oool00`00001000000?ooo`0d0?ooo`<0?coo00<00?l00000003oool0N`3oool00`00o`00
?coo03loo`020?ooo`030000003oool0oooo0:T0oooo000J0?ooo`030000003oool0oooo03<0oooo
0`0o?ol00`00o`0000000?ooo`1m0?ooo`06003o000o?ol0?coo03loo`3oool00000ZP3oool001X0
oooo00<000000?ooo`3oool0<P3oool303loo`03003o00000000oooo07l0oooo00<00?l003loo`0o
?ol00P3oool00`000000oooo0?ooo`2W0?ooo`006P3oool00`000000oooo0?ooo`0a0?ooo`<0?coo
00<00?l00000003oool0P@3oool00`00o`00oooo0?ooo`020?ooo`030000003oool0oooo0:H0oooo
000J0?ooo`030000003oool0oooo0300oooo0`0o?ol00`00o`0000000?ooo`230?ooo`03003o000o
?ol0?coo0080oooo00<000000?ooo`3oool0Y@3oool001X0oooo00<000000?ooo`3oool0<03oool2
03loo`03003o00000000oooo08@0oooo00<0?coo003o000o?ol00`3oool00`000000oooo0?ooo`2T
0?ooo`006P3oool00`00001000000?ooo`0^0?ooo`<0?coo00<00?l00000003oool0QP3oool00`0o
?ol00?l003loo`0203loo`030?ooo`000000oooo0:@0oooo000J0?ooo`030000003oool0oooo02d0
oooo0`0o?ol00`00o`0000000?ooo`290?ooo`03003o000o?ol0?coo0080oooo00<000000?ooo`3o
ool0XP3oool001X0oooo00<000000?ooo`3oool0;03oool303loo`03003o00000000oooo08/0oooo
00<00?l00?ooo`3oool00P3oool00`000000oooo0?ooo`2Q0?ooo`006P3oool00`000000oooo0?oo
o`0[0?ooo`<0?coo00<00?l00000003oool0S@3oool00`00o`00?coo03loo`020?ooo`030000003o
ool0oooo0:00oooo000J0?ooo`030000003oool0oooo02X0oooo0P0o?ol2003o00030000003oool0
oooo08d0oooo00<0?coo003o0000o`000`3oool00`000000oooo0?ooo`2O0?ooo`006P3oool00`00
0000oooo0?ooo`0Y0?ooo`80?coo00<00?l003loo`000000T@3oool00`0o?ol0oooo003o000203lo
o`030?ooo`000000oooo09l0oooo000J0?ooo`030000003oool0oooo02P0oooo0P0o?ol00`00o`00
?coo0000002D0?ooo`0303loo`00o`00?coo0080oooo00<000000?ooo`3oool0W@3oool001X0oooo
00<00000@000003oool09`3oool203loo`03003o000o?ol0000009H0oooo00<0?coo003o003oool0
0P3oool00`000000oooo0?ooo`2L0?ooo`006P3oool00`000000oooo0?ooo`0V0?ooo`80?coo00<0
0?l003loo`000000V@3oool01@00o`00?coo03loo`3oool0000009d0oooo000J0?ooo`030000003o
ool0oooo02D0oooo0P0o?ol00`00o`00?coo0000002J0?ooo`0303loo`00o`00?coo0080oooo00<0
00000?ooo`3oool0VP3oool001X0oooo00<000000?ooo`3oool0903oool203loo`03003o000o?ol0
000009`0oooo00H0?coo003o000o?ol0?coo0?ooo`00002K0?ooo`006P3oool00`000000oooo0?oo
o`0T0?ooo`0403loo`00o`00?coo000009h0oooo00<0?coo003o000o?ol00P3oool00`000000oooo
0?ooo`2H0?ooo`006P3oool00`000000oooo0?ooo`0S0?ooo`0403loo`00o`00?coo00000:00oooo
00<0?coo003o003oool00P3oool00`000000oooo0?ooo`2G0?ooo`006P3oool00`000000oooo0?oo
o`0R0?ooo`0403loo`00o`00?coo03looj<0oooo00D00?l003loo`0o?ol0oooo0000002H0?ooo`00
6P3oool00`00001000000?ooo`0Q0?ooo`0403loo`00o`00?coo03looj@0oooo00<0?coo003o000o
?ol00P3oool00`000000oooo0?ooo`2E0?ooo`006P3oool00`000000oooo0?ooo`0P0?ooo`0403lo
o`00o`00?coo03loojH0oooo00<0?coo003o003oool00P3oool00`000000oooo0?ooo`2D0?ooo`00
6P3oool00`000000oooo0?ooo`0O0?ooo`0403loo`00o`00?coo03loojP0oooo00<0?coo003o000o
?ol00P3oool00`000000oooo0?ooo`2C0?ooo`006P3oool00`000000oooo0?ooo`0N0?ooo`0403lo
o`00o`00?coo03loojT0oooo0P0o?ol01@00o`00oooo0?ooo`3oool0000009@0oooo000<0?ooo`=0
00000`3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo01d0oooo00@0?coo003o000o
?ol0?cooZ`3oool00`0o?ol0oooo003o000203loo`030?ooo`000000oooo0980oooo000<0?ooo`03
@000003oool0oooo0080oooo00=000000?oood0000001P3oool00`000000oooo0?ooo`0K0?ooo`80
?coo00<00?l003loo`0o?ol0[P3oool00`0o?ol00?l003loo`020?ooo`030000003oool0oooo0900
oooo000=0?ooo`07@000003oool0oooo0?oood000000oooo@00000060?ooo`80000000=000000?oo
o`3oool0603oool203loo`03003o000o?ol0?coo0;00oooo00<0?coo003o003oool00P3oool00`00
0000oooo0?ooo`2?0?ooo`003@3oool01d000000oooo0?ooo`3ooom000000?oood0000001P3oool0
0`000000oooo0?ooo`0I0?ooo`80?coo00<00?l003loo`0o?ol0/`3oool01@00o`00?coo03loo`3o
ool000000900oooo000<0?ooo`03@000003ooom000000080oooo00=000000?oood0000001P3oool0
0`000000oooo0?ooo`0H0?ooo`80?coo00<00?l003loo`000000]03oool00`0o?ol00?l003loo`02
0?ooo`030000003oool0oooo08d0oooo000=0?ooo`03@000003oool0oooo0080oooo00=000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0G0?ooo`80?coo00<00?l003loo`000000]P3oool00`0o
?ol00?l00?ooo`020?ooo`030000003oool0oooo08`0oooo000J0?ooo`030000003oool0oooo01H0
oooo0P0o?ol00`00o`00?coo0000002h0?ooo`0303loo`00o`000?l00080oooo00<000000?ooo`3o
ool0R`3oool001X0oooo00<000000?ooo`3oool05@3oool203loo`03003o000o?ol000000;T0oooo
0`0o?ol01000o`00oooo0?ooo`00002<0?ooo`006P3oool00`000000oooo0?ooo`0D0?ooo`80?coo
00<00?l003loo`000000^`3oool01`0o?ol0oooo03loo`00o`00?coo0?ooo`000000R`3oool001X0
oooo00<00000@000003oool04`3oool203loo`03003o000o?ol000000;h0oooo0P0o?ol01000o`00
oooo0?ooo`00002:0?ooo`006P3oool00`000000oooo0?ooo`0C0?ooo`0403loo`00o`00?coo0000
0<00oooo00<0?coo0?ooo`00o`000P3oool00`000000oooo0?ooo`270?ooo`006P3oool00`000000
oooo0?ooo`0A0?ooo`80?coo00<00?l003loo`0o?ol0``3oool01@0o?ol00?l003loo`3oool00000
08P0oooo000J0?ooo`030000003oool0oooo0100oooo0P0o?ol00`00o`00?coo03loo`340?ooo`80
?coo00@00?l00?ooo`3oool00000Q`3oool001X0oooo00<000000?ooo`3oool03`3oool203loo`03
003o000o?ol0?coo0<H0oooo00<0?coo0?ooo`00o`000P3oool00`000000oooo0?ooo`240?ooo`00
6P3oool00`000000oooo0?ooo`0>0?ooo`80?coo00<00?l003loo`000000b@3oool01@0o?ol00?l0
03loo`3oool0000008D0oooo000J0?ooo`030000003oool0oooo00h0oooo00@0?coo003o000o?ol0
0000bP3oool203loo`04003o003oool0oooo000008@0oooo000J0?ooo`03000004000000oooo00d0
oooo00@0?coo003o000o?ol0?cooc03oool00`0o?ol0oooo003o00020?ooo`030000003oool0oooo
0840oooo000J0?ooo`030000003oool0oooo00/0oooo0P0o?ol00`00o`00?coo03loo`3>0?ooo`80
?coo00@00?l00?ooo`3oool00000PP3oool001X0oooo00<000000?ooo`3oool02P3oool203loo`03
003o000o?ol0?coo0<l0oooo0`0o?ol01000o`00oooo0?ooo`0000210?ooo`006P3oool00`000000
oooo0?ooo`0:0?ooo`0403loo`00o`00?coo03loom40oooo00@0?coo0?ooo`3oool00?l00P3oool0
0`000000oooo0?ooo`1n0?ooo`006P3oool00`000000oooo0?ooo`090?ooo`0403loo`00o`00?coo
03loom@0oooo0P0o?ol01000o`00oooo0?ooo`00001o0?ooo`006P3oool00`000000oooo0?ooo`07
0?ooo`80?coo00<00?l003loo`0o?ol0e@3oool303loo`04003o003oool0oooo000007h0oooo000J
0?ooo`030000003oool0oooo00H0oooo0P0o?ol00`00o`00?coo03loo`3G0?ooo`0403loo`3oool0
oooo003o0080oooo00<000000?ooo`3oool0N`3oool001X0oooo00<00000@000003oool01P3oool0
100o?ol00?l003loo`0o?ooJ0?ooo`80?coo00@00?l00?ooo`3oool00000O03oool001X0oooo00<0
00000?ooo`3oool0103oool203loo`03003o000o?ol0?coo0=/0oooo0`0o?ol01000o`00oooo0?oo
o`00001k0?ooo`006P3oool00`000000oooo0?ooo`040?ooo`0403loo`00o`00?coo03loomd0oooo
00@0?coo0?ooo`3oool00?l00P3oool00`000000oooo0?ooo`1h0?ooo`006P3oool00`000000oooo
0?ooo`020?ooo`<0?coo00<00?l003loo`3oool0g`3oool203loo`04003o003oool0oooo000007T0
oooo000J0?ooo`040000003oool0oooo0?ooo`<0?coo00<00?l003loo`3oool0h03oool303loo`04
003o003oool0oooo000007P0oooo000J0?ooo`040000003oool0oooo0?ooo`80?coo00<00?l003lo
o`000000hP3oool0100o?ol0oooo0?ooo`00o`020?ooo`030000003oool0oooo07D0oooo000J0?oo
o`03000004000000oooo0080oooo00<00?l00?ooo`000000i@3oool203loo`04003o003oool0oooo
000007H0oooo000J0?ooo`070000003oool0oooo0?ooo`00o`00oooo0000003V0?ooo`<0?coo00@0
0?l00?ooo`3oool00000M@3oool001X0oooo00H000000?ooo`3oool00?l00?ooo`00003X0?ooo`04
03loo`3oool0oooo003o0080oooo00<000000?ooo`3oool0LP3oool001X0oooo00D000000?ooo`00
o`00oooo0000003[0?ooo`80?coo00@00?l00?ooo`3oool00000L`3oool001X0oooo00@00000003o
003oool00000k03oool303loo`04003o003oool0oooo00000780oooo000<0?ooo`900000103oool0
0d000000oooo0?ooo`050?ooo`03003o003oool000000>h0oooo00@0?coo0?ooo`3oool00?l00P3o
ool00`000000oooo0?ooo`1_0?ooo`003P3oool01T000000oooo0?oood000000oooo@00000H0oooo
0P00003a0?ooo`80?coo00@00?l00?ooo`3oool00000L03oool000d0oooo00M000000?ooo`3oool0
oooo@000003ooom0000000H0oooo0P0000000d000000oooo0?ooo`3^0?ooo`<0?coo00@00?l00?oo
o`3oool00000K`3oool000h0oooo00I000000?ooo`3ooom000000?oood0000060?ooo`030000003o
ool0oooo0?40oooo00@0?coo0?ooo`3oool00?l00P3oool00`000000oooo0?ooo`1/0?ooo`00303o
ool00d000000oooo@00000020?ooo`03@000003ooom0000000H0oooo00<000000?ooo`3oool0l`3o
ool203loo`04003o003oool0oooo000006d0oooo000=0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`3c0?ooo`<0?coo00@00?l00?ooo`3oool00000
K03oool001X0oooo00<000000?ooo`3oool0m03oool0100o?ol0oooo0?ooo`00o`020?ooo`030000
003oool0oooo06T0oooo000J0?ooo`030000003oool0oooo0?H0oooo0P0o?ol01000o`00oooo0?oo
o`00001Z0?ooo`006P3oool00`000000oooo0?ooo`3f0?ooo`<0?coo00@00?l00?ooo`3oool00000
J@3oool001X0oooo00<00000@000003oool0m`3oool0100o?ol0oooo0?ooo`00o`020?ooo`030000
003oool0oooo06H0oooo000J0?ooo`030000003oool0oooo0?T0oooo0P0o?ol01000o`00oooo0?oo
o`00001W0?ooo`006P3oool00`000000oooo0?ooo`3i0?ooo`<0?coo00@00?l00?ooo`3oool00000
IP3oool001X0oooo00<000000?ooo`3oool0nP3oool0100o?ol0oooo0?ooo`00o`020?ooo`030000
003oool0oooo06<0oooo000J0?ooo`030000003oool0oooo0?`0oooo0P0o?ol01000o`00oooo0?oo
o`00001T0?ooo`006P3oool00`000000oooo0?ooo`3l0?ooo`<0?coo00@00?l00?ooo`3oool00000
H`3oool001X0oooo00<000000?ooo`3oool0o@3oool0100o?ol0oooo0?ooo`00o`020?ooo`030000
003oool0oooo0600oooo000J0?ooo`03000004000000oooo0?l0oooo0P0o?ol01000o`00oooo0?oo
o`00001Q0?ooo`006P3oool00`000000oooo0?ooo`3o0?ooo`<0?coo00@00?l00?ooo`3oool00000
H03oool001X0oooo00<000000?ooo`3oool0o`3oool10?ooo`0403loo`3oool0oooo003o0080oooo
00<000000?ooo`3oool0G@3oool001X0oooo00<000000?ooo`3oool0o`3oool30?ooo`80?coo00@0
0?l00?ooo`3oool00000GP3oool001X0oooo00<000000?ooo`3oool0o`3oool30?ooo`<0?coo00@0
0?l00?ooo`3oool00000G@3oool001X0oooo00<000000?ooo`3oool0o`3oool40?ooo`0403loo`3o
ool0oooo003o0080oooo00<000000?ooo`3oool0FP3oool001X0oooo00<00000@000003oool0o`3o
ool60?ooo`80?coo00@00?l00?ooo`3oool00000F`3oool001X0oooo00<000000?ooo`3oool0o`3o
ool60?ooo`<0?coo00@00?l00?ooo`3oool00000FP3oool001X0oooo00<000000?ooo`3oool0o`3o
ool70?ooo`0403loo`3oool0oooo003o0080oooo00<000000?ooo`3oool0E`3oool001X0oooo00<0
00000?ooo`3oool0o`3oool;0?ooo`04003o003oool0oooo000005P0oooo000J0?ooo`030000003o
ool0oooo0?l0oooo2P3oool203loo`04003o003oool0oooo000005L0oooo000J0?ooo`030000003o
ool0oooo0?l0oooo2P3oool303loo`04003o003oool0oooo000005H0oooo000J0?ooo`030000003o
ool0oooo0?l0oooo2`3oool0100o?ol0oooo0?ooo`00o`020?ooo`030000003oool0oooo05<0oooo
000J0?ooo`03000004000000oooo0?l0oooo3@3oool203loo`04003o003oool0oooo000005@0oooo
000J0?ooo`030000003oool0oooo0?l0oooo3@3oool303loo`03003o003oool0000005@0oooo000J
0?ooo`030000003oool0oooo0?l0oooo3P3oool01P0o?ol0oooo0?ooo`00o`00oooo000005<0oooo
000J0?ooo`030000003oool0oooo0?l0oooo403oool203loo`03003o003oool000000580oooo000J
0?ooo`030000003oool0oooo0?l0oooo403oool303loo`03003o003oool000000540oooo000=0?oo
o`=000000P3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo4@3oool01P0o
?ol0oooo0?ooo`00o`00oooo00000500oooo000>0?ooo`06@000003oool0oooo@000003ooom00000
1P3oool00`000000oooo0?ooo`3o0?oooa@0oooo00@00?l00?ooo`3oool00000C`3oool000`0oooo
14000000103ooom000000?oood0000060?ooo`80000000=000000?ooo`3oool0o`3ooolB0?ooo`05
03loo`00o`00?coo0?ooo`000000CP3oool000`0oooo00=000000?oood0000000P3oool00d000000
oooo@00000060?ooo`030000003oool0oooo0?l0oooo503oool203loo`04003o003oool0oooo0000
04d0oooo000=0?ooo`9000000P3oool00d000000oooo@00000060?ooo`030000003oool0oooo0?l0
oooo5@3oool00`0o?ol0oooo003o00020?ooo`030000003oool0oooo04X0oooo000>0?ooo`05@000
003oool0oooo0?oood0000001`3oool00`000000oooo0?ooo`3o0?oooaL0oooo00D0?coo003o000o
?ol0oooo0000001;0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooaL0oooo0P0o?ol01000o`00
oooo0?ooo`00001:0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooaP0oooo00<0?coo0?ooo`00
o`000P3oool00`000000oooo0?ooo`170?ooo`006P3oool00`000000oooo0?ooo`3o0?oooaX0oooo
00D0?coo003o000o?ol0oooo000000180?ooo`006P3oool00`00001000000?ooo`3o0?oooaX0oooo
0P0o?ol01000o`00oooo0?ooo`0000170?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa/0oooo
00<0?coo0?ooo`00o`000P3oool00`000000oooo0?ooo`140?ooo`006P3oool00`000000oooo0?oo
o`3o0?oooah0oooo00@00?l00?ooo`3oool00000A@3oool001X0oooo00<000000?ooo`3oool0o`3o
oolN0?ooo`0503loo`00o`00?coo0?ooo`000000A03oool001X0oooo00<000000?ooo`3oool0o`3o
oolN0?ooo`80?coo00@00?l00?ooo`3oool00000@`3oool001X0oooo00<000000?ooo`3oool0o`3o
oolO0?ooo`0303loo`3oool00?l00080oooo00<000000?ooo`3oool0@03oool001X0oooo00<00000
@000003oool0o`3ooolQ0?ooo`0503loo`00o`00?coo0?ooo`000000@@3oool001X0oooo00<00000
0?ooo`3oool0o`3ooolQ0?ooo`80?coo00@00?l00?ooo`3oool00000@03oool001X0oooo00<00000
0?ooo`3oool0o`3ooolR0?ooo`0303loo`3oool00?l00080oooo00<000000?ooo`3oool0?@3oool0
01X0oooo00<000000?ooo`3oool0o`3ooolU0?ooo`04003o003oool0oooo000003h0oooo000J0?oo
o`030000003oool0oooo0?l0oooo9@3oool01@0o?ol00?l003loo`3oool0000003d0oooo000J0?oo
o`030000003oool0oooo0?l0oooo9@3oool203loo`04003o003oool0oooo000003`0oooo000J0?oo
o`030000003oool0oooo0?l0oooo9P3oool00`0o?ol0oooo003o00020?ooo`030000003oool0oooo
03T0oooo000J0?ooo`03000004000000oooo0?l0oooo:03oool01@0o?ol00?l003loo`3oool00000
03X0oooo000J0?ooo`030000003oool0oooo0?l0oooo:03oool203loo`04003o003oool0oooo0000
03T0oooo000J0?ooo`030000003oool0oooo0?l0oooo:@3oool00`0o?ol0oooo003o00020?ooo`03
0000003oool0oooo03H0oooo000J0?ooo`030000003oool0oooo0?l0oooo;03oool01000o`00oooo
0?ooo`00000g0?ooo`006P3oool00`000000oooo0?ooo`3o0?ooob`0oooo00D0?coo003o000o?ol0
oooo0000000f0?ooo`006P3oool00`000000oooo0?ooo`3o0?ooob`0oooo0P0o?ol01000o`00oooo
0?ooo`00000e0?ooo`006P3oool00`000000oooo0?ooo`3o0?ooobd0oooo00<0?coo0?ooo`00o`00
0P3oool00`000000oooo0?ooo`0b0?ooo`006P3oool00`00001000000?ooo`3o0?oooc00oooo00@0
0?l00?ooo`3oool00000<`3oool001X0oooo00<000000?ooo`3oool0o`3oool_0?ooo`80?coo00@0
0?l00?ooo`3oool00000<P3oool001X0oooo00<000000?ooo`3oool0o`3oool_0?ooo`<0?coo00@0
0?l00?ooo`3oool00000<@3oool001X0oooo00<000000?ooo`3oool0o`3oool`0?ooo`0403loo`3o
ool0oooo003o0080oooo00<000000?ooo`3oool0;P3oool001X0oooo00<000000?ooo`3oool0o`3o
oolc0?ooo`0503loo`00o`00?coo0?ooo`000000;`3oool000d0oooo00=000000?ooo`3oool00P3o
ool00d000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo<`3oool203loo`04003o003o
ool0oooo000002h0oooo000<0?ooo`03@000003ooom000000080oooo00=000000?oood0000001P3o
ool00`000000oooo0?ooo`3o0?oooc@0oooo00<0?coo0?ooo`00o`000P3oool00`000000oooo0?oo
o`0[0?ooo`003P3oool01T000000oooo0?oood000000oooo@00000H0oooo0P0000000d000000oooo
0?ooo`3o0?ooocD0oooo00@00?l00?ooo`3oool00000;03oool000`0oooo0T0000030?ooo`03@000
003ooom0000000H0oooo00<000000?ooo`3oool0o`3ooolf0?ooo`80?coo00@00?l00?ooo`3oool0
0000:`3oool000`0oooo00=000000?ooo`3oool00P3oool00d000000oooo@00000060?ooo`030000
003oool0oooo0?l0oooo=P3oool303loo`04003o003oool0oooo000002X0oooo000<0?ooo`=00000
0`3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo=`3oool0100o?ol0oooo
0?ooo`00o`020?ooo`030000003oool0oooo02L0oooo000J0?ooo`030000003oool0oooo0?l0oooo
>`3oool01000o`00oooo0?ooo`00000X0?ooo`006P3oool00`000000oooo0?ooo`3o0?ooocX0oooo
0P0o?ol01000o`00oooo0?ooo`00000W0?ooo`006P3oool00`00001000000?ooo`3o0?ooocX0oooo
0`0o?ol01000o`00oooo0?ooo`00000V0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooc/0oooo
00@0?coo0?ooo`3oool00?l00P3oool00`000000oooo0?ooo`0S0?ooo`006P3oool00`000000oooo
0?ooo`3o0?oooch0oooo00D0?coo003o000o?ol0oooo0000000T0?ooo`006P3oool00`000000oooo
0?ooo`3o0?oooch0oooo0P0o?ol01000o`00oooo0?ooo`00000S0?ooo`006P3oool00`000000oooo
0?ooo`3o0?ooocl0oooo00<0?coo0?ooo`00o`000P3oool00`000000oooo0?ooo`0P0?ooo`006P3o
ool00`000000oooo0?ooo`3o0?oood80oooo00@00?l00?ooo`3oool000008@3oool001X0oooo00<0
00000?ooo`3oool0o`3ooom10?ooo`80?coo00@00?l00?ooo`3oool00000803oool001X0oooo00<0
0000@000003oool0o`3ooom10?ooo`<0?coo00@00?l00?ooo`3oool000007`3oool001X0oooo00<0
00000?ooo`3oool0o`3ooom20?ooo`0403loo`3oool0oooo003o0080oooo00<000000?ooo`3oool0
703oool001X0oooo00<000000?ooo`3oool0o`3ooom60?ooo`04003o003oool0oooo000001d0oooo
000J0?ooo`030000003oool0oooo0?l0ooooA@3oool203loo`04003o003oool0oooo@00001`0oooo
000J0?ooo`030000003oool0oooo0?l0ooooA@3oool303loo`03003o003oool0oooo01`0oooo000J
0?ooo`030000003oool0oooo0?l0ooooAP3oool0100o?ol0oooo0?ooo`00o`0M0?ooo`006P3oool0
0`000000oooo0?ooo`3o0?ooodX0oooo00<00?l00?ooo`3oool06P3oool001X0oooo00<00000@000
003oool0o`3ooomW0?ooo`006P3oool00`000000oooo0?ooo`3o0?ooofL0oooo000J0?ooo`030000
003oool0oooo0?l0ooooI`3oool001X0oooo00<000000?ooo`3oool0o`3ooomW0?ooo`006P3oool0
0`000000oooo0?ooo`3o0?ooofL0oooo000J0?ooo`030000003oool0oooo0?l0ooooI`3oool001X0
oooo00<00000@000003oool0o`3ooomW0?ooo`006P3oool00`000000oooo0?ooo`3o0?ooofL0oooo
000J0?ooo`030000003oool0oooo0?l0ooooI`3oool001X0oooo00<000000?ooo`3oool0o`3ooomW
0?ooo`006P3oool00`000000oooo0?ooo`3o0?ooofL0oooo000<0?ooo`900000103oool00d000000
oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooI`3oool000`0oooo00=000000?oood000000
0P3oool00d000000oooo@00000060?ooo`030000003oool0oooo0?l0ooooI`3oool000`0oooo00=0
00000?oood0000000P3oool00d000000oooo@00000060?ooo`03@0000000001000000?l0ooooI`3o
ool000`0oooo0T0000030?ooo`03@000003ooom000000?l0ooooL03oool000`0oooo00=000000?oo
o`3oool00P3oool00d000000oooo@000003o0?ooog00oooo000=0?ooo`9000000`3oool00d000000
oooo0?ooo`3o0?ooofl0oooo003o0?oooh@0oooo003o0?oooh@0oooo003o0?oooh@0oooo003o0?oo
oh@0oooo003o0?oooh@0oooo003o0?oooh@0oooo003o0?oooh@0oooo003o0?oooh@0oooo003o0?oo
oh@0oooo003o0?oooh@0oooo000H0?ooo`900000o`3ooomZ0?ooo`005`3oool00d000000oooo@000
003o0?ooofX0oooo000G0?ooo`03@000003ooom000000?l0ooooJP3oool001L0oooo00A000000?oo
o`3ooom00000o`3ooomY0?ooo`005P3oool01D000000oooo0?ooo`3ooom000000?l0ooooJ@3oool0
01H0oooo0T0000000`3ooom00000@000003o0?ooofT0oooo003o0?oooh@0oooo003o0?oooh@0oooo
003o0?oooh@0oooo003o0?oooh@0oooo0000\
\>"],
  ImageRangeCache->{{{0, 386.688}, {238.563, 0}} -> {12.1662, -3.90626, 
  0.300801, 0.296891}}]
}, Open  ]],

Cell[TextData[
"\"Err - rozdiel medzi explicitn\[YAcute]m rie\.9aen\[IAcute]m a na\.9aim v\
\[YAcute]sledkom\ntr1: tabu\:017eka chyby pribli\.9en\[EAcute]ho \
rie\.9aenia\""], "Text"],

Cell["\<\
Err[i_,sgm_]:=BoughtStrangle[xs[[i]],X1,X2,sgm,r,DD,t]-ys[[i]];
tr1:=Table[{xs[[i]],Err[i,sigma]},{i,2m+1}];\
\>", "Input"],

Cell["\"Maximov\[AAcute] chyba\"", "Text"],

Cell["\<\
Print[\"m = \",m,\" n = \",n,\" trans = \",trans,\" Max.chyba = \
\",Max[Table[Abs[Err[i,str]],{i,2m+1}]]]\
\>", "Input"],

Cell["\"Graf chyby pri delen\[IAcute] m=100 , n=100\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=ListPlot[tr1,PlotStyle->{PointSize[0.02],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->All]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.140244 0.0074429 0.25643 92.8222 [
[.15747 .24393 -6 -9 ]
[.15747 .24393 6 0 ]
[.30633 .24393 -6 -9 ]
[.30633 .24393 6 0 ]
[.45519 .24393 -6 -9 ]
[.45519 .24393 6 0 ]
[.60405 .24393 -9 -9 ]
[.60405 .24393 9 0 ]
[.7529 .24393 -9 -9 ]
[.7529 .24393 9 0 ]
[.90176 .24393 -9 -9 ]
[.90176 .24393 9 0 ]
[-0.00389 .07079 -36 -4.5 ]
[-0.00389 .07079 0 4.5 ]
[-0.00389 .16361 -36 -4.5 ]
[-0.00389 .16361 0 4.5 ]
[-0.00389 .34925 -30 -4.5 ]
[-0.00389 .34925 0 4.5 ]
[-0.00389 .44207 -30 -4.5 ]
[-0.00389 .44207 0 4.5 ]
[-0.00389 .5349 -30 -4.5 ]
[-0.00389 .5349 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.15747 .25643 m
.15747 .26268 L
s
[(40)] .15747 .24393 0 1 Mshowa
.30633 .25643 m
.30633 .26268 L
s
[(60)] .30633 .24393 0 1 Mshowa
.45519 .25643 m
.45519 .26268 L
s
[(80)] .45519 .24393 0 1 Mshowa
.60405 .25643 m
.60405 .26268 L
s
[(100)] .60405 .24393 0 1 Mshowa
.7529 .25643 m
.7529 .26268 L
s
[(120)] .7529 .24393 0 1 Mshowa
.90176 .25643 m
.90176 .26268 L
s
[(140)] .90176 .24393 0 1 Mshowa
.125 Mabswid
.04583 .25643 m
.04583 .26018 L
s
.08304 .25643 m
.08304 .26018 L
s
.12026 .25643 m
.12026 .26018 L
s
.19469 .25643 m
.19469 .26018 L
s
.2319 .25643 m
.2319 .26018 L
s
.26912 .25643 m
.26912 .26018 L
s
.34354 .25643 m
.34354 .26018 L
s
.38076 .25643 m
.38076 .26018 L
s
.41797 .25643 m
.41797 .26018 L
s
.4924 .25643 m
.4924 .26018 L
s
.52962 .25643 m
.52962 .26018 L
s
.56683 .25643 m
.56683 .26018 L
s
.64126 .25643 m
.64126 .26018 L
s
.67847 .25643 m
.67847 .26018 L
s
.71569 .25643 m
.71569 .26018 L
s
.79012 .25643 m
.79012 .26018 L
s
.82733 .25643 m
.82733 .26018 L
s
.86455 .25643 m
.86455 .26018 L
s
.93898 .25643 m
.93898 .26018 L
s
.97619 .25643 m
.97619 .26018 L
s
.25 Mabswid
0 .25643 m
1 .25643 L
s
.00861 .07079 m
.01486 .07079 L
s
[(-0.002)] -0.00389 .07079 1 0 Mshowa
.00861 .16361 m
.01486 .16361 L
s
[(-0.001)] -0.00389 .16361 1 0 Mshowa
.00861 .34925 m
.01486 .34925 L
s
[(0.001)] -0.00389 .34925 1 0 Mshowa
.00861 .44207 m
.01486 .44207 L
s
[(0.002)] -0.00389 .44207 1 0 Mshowa
.00861 .5349 m
.01486 .5349 L
s
[(0.003)] -0.00389 .5349 1 0 Mshowa
.125 Mabswid
.00861 .08935 m
.01236 .08935 L
s
.00861 .10791 m
.01236 .10791 L
s
.00861 .12648 m
.01236 .12648 L
s
.00861 .14504 m
.01236 .14504 L
s
.00861 .18217 m
.01236 .18217 L
s
.00861 .20074 m
.01236 .20074 L
s
.00861 .2193 m
.01236 .2193 L
s
.00861 .23787 m
.01236 .23787 L
s
.00861 .27499 m
.01236 .27499 L
s
.00861 .29356 m
.01236 .29356 L
s
.00861 .31212 m
.01236 .31212 L
s
.00861 .33069 m
.01236 .33069 L
s
.00861 .36782 m
.01236 .36782 L
s
.00861 .38638 m
.01236 .38638 L
s
.00861 .40495 m
.01236 .40495 L
s
.00861 .42351 m
.01236 .42351 L
s
.00861 .46064 m
.01236 .46064 L
s
.00861 .4792 m
.01236 .4792 L
s
.00861 .49777 m
.01236 .49777 L
s
.00861 .51633 m
.01236 .51633 L
s
.00861 .05222 m
.01236 .05222 L
s
.00861 .03366 m
.01236 .03366 L
s
.00861 .01509 m
.01236 .01509 L
s
.00861 .55346 m
.01236 .55346 L
s
.00861 .57203 m
.01236 .57203 L
s
.00861 .59059 m
.01236 .59059 L
s
.00861 .60915 m
.01236 .60915 L
s
.25 Mabswid
.00861 0 m
.00861 .61803 L
s
.25 .25 1 r
.02 w
.02381 .25645 Mdot
.02539 .2566 Mdot
.02699 .25674 Mdot
.0286 .25687 Mdot
.03022 .25698 Mdot
.03187 .25709 Mdot
.03352 .25718 Mdot
.0352 .25725 Mdot
.03689 .25731 Mdot
.0386 .25735 Mdot
.04032 .25738 Mdot
.04206 .25738 Mdot
.04381 .25735 Mdot
.04559 .25729 Mdot
.04738 .25721 Mdot
.04919 .25708 Mdot
.05101 .2569 Mdot
.05285 .25667 Mdot
.05471 .25638 Mdot
.05659 .25601 Mdot
.05849 .25555 Mdot
.0604 .255 Mdot
.06234 .25432 Mdot
.06429 .25351 Mdot
.06626 .25255 Mdot
.06825 .2514 Mdot
.07026 .25005 Mdot
.07229 .24847 Mdot
.07433 .24662 Mdot
.0764 .24448 Mdot
.07849 .24202 Mdot
.0806 .2392 Mdot
.08272 .23597 Mdot
.08487 .23232 Mdot
.08704 .2282 Mdot
.08923 .22357 Mdot
.09144 .21841 Mdot
.09367 .21269 Mdot
.09593 .20639 Mdot
.0982 .19948 Mdot
.1005 .19196 Mdot
.10282 .18383 Mdot
.10516 .1751 Mdot
.10753 .16579 Mdot
.10991 .15593 Mdot
.11232 .14559 Mdot
.11476 .13482 Mdot
.11721 .12372 Mdot
.11969 .11238 Mdot
.1222 .10093 Mdot
.12473 .0895 Mdot
.12728 .07824 Mdot
.12986 .06732 Mdot
.13246 .05692 Mdot
.13509 .04723 Mdot
.13774 .03844 Mdot
.14042 .03076 Mdot
.14312 .02436 Mdot
.14585 .01944 Mdot
.14861 .01618 Mdot
.15139 .01472 Mdot
.1542 .01519 Mdot
.15704 .01769 Mdot
.1599 .0223 Mdot
.16279 .02904 Mdot
.16571 .0379 Mdot
.16866 .04881 Mdot
.17164 .06168 Mdot
.17464 .07636 Mdot
.17768 .09266 Mdot
.18074 .11034 Mdot
.18383 .12913 Mdot
.18695 .14874 Mdot
.19011 .16886 Mdot
.19329 .18913 Mdot
.1965 .20924 Mdot
.19975 .22884 Mdot
.20302 .24762 Mdot
.20633 .26529 Mdot
.20967 .28162 Mdot
.21304 .29638 Mdot
.21644 .30943 Mdot
.21988 .32069 Mdot
.22335 .33012 Mdot
.22685 .33777 Mdot
.23039 .34376 Mdot
.23396 .34824 Mdot
.23757 .35145 Mdot
.24121 .35366 Mdot
.24488 .35521 Mdot
.24859 .35643 Mdot
.25234 .35769 Mdot
.25612 .35935 Mdot
.25994 .36177 Mdot
.2638 .36527 Mdot
.26769 .37013 Mdot
.27162 .37657 Mdot
.27559 .38476 Mdot
.27959 .39479 Mdot
.28364 .40665 Mdot
.28772 .42028 Mdot
.29185 .4355 Mdot
.29601 .45208 Mdot
.30021 .46971 Mdot
.30446 .48798 Mdot
.30874 .50648 Mdot
.31307 .52471 Mdot
.31743 .54217 Mdot
.32184 .55835 Mdot
.32629 .57274 Mdot
.33079 .58484 Mdot
.33533 .59423 Mdot
.33991 .60049 Mdot
.34454 .60332 Mdot
.34921 .60246 Mdot
.35392 .59775 Mdot
.35868 .58911 Mdot
.36349 .57658 Mdot
.36834 .56025 Mdot
.37324 .54034 Mdot
.37819 .51712 Mdot
.38319 .49096 Mdot
.38823 .46225 Mdot
.39332 .43148 Mdot
.39846 .39915 Mdot
.40365 .36578 Mdot
.40889 .3319 Mdot
.41418 .29805 Mdot
.41952 .26474 Mdot
.42492 .23245 Mdot
.43036 .20162 Mdot
.43586 .17264 Mdot
.44141 .14585 Mdot
.44701 .12153 Mdot
.45267 .09989 Mdot
.45839 .08108 Mdot
.46415 .06519 Mdot
.46998 .05224 Mdot
.47586 .04221 Mdot
.48179 .03501 Mdot
.48778 .03052 Mdot
.49383 .02857 Mdot
.49994 .02896 Mdot
.50611 .03149 Mdot
.51234 .03591 Mdot
.51863 .04196 Mdot
.52497 .04942 Mdot
.53138 .05801 Mdot
.53785 .06751 Mdot
.54439 .07768 Mdot
.55098 .08831 Mdot
.55764 .09921 Mdot
.56437 .11018 Mdot
.57116 .12109 Mdot
.57801 .13178 Mdot
.58493 .14216 Mdot
.59192 .15212 Mdot
.59897 .16159 Mdot
.60609 .17053 Mdot
.61328 .17888 Mdot
.62054 .18664 Mdot
.62787 .19378 Mdot
.63527 .20031 Mdot
.64275 .20625 Mdot
.65029 .21162 Mdot
.65791 .21643 Mdot
.6656 .22073 Mdot
.67336 .22454 Mdot
.6812 .2279 Mdot
.68911 .23085 Mdot
.6971 .23343 Mdot
.70517 .23566 Mdot
.71332 .2376 Mdot
.72154 .23927 Mdot
.72984 .2407 Mdot
.73823 .24193 Mdot
.74669 .24298 Mdot
.75524 .24388 Mdot
.76386 .24464 Mdot
.77257 .24531 Mdot
.78137 .24588 Mdot
.79025 .24638 Mdot
.79921 .24683 Mdot
.80826 .24723 Mdot
.8174 .24761 Mdot
.82663 .24797 Mdot
.83595 .24832 Mdot
.84535 .24867 Mdot
.85485 .24903 Mdot
.86443 .24941 Mdot
.87411 .24981 Mdot
.88389 .25025 Mdot
.89375 .25072 Mdot
.90372 .25123 Mdot
.91377 .25179 Mdot
.92393 .2524 Mdot
.93418 .25307 Mdot
.94453 .25381 Mdot
.95498 .25461 Mdot
.96554 .25549 Mdot
.97619 .25644 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`00
9`3oool00`000000oooo0?ooo`0N0?ooo`@0?cooe03oool002L0oooo00<000000?ooo`3oool07P3o
ool603loom80oooo000W0?ooo`03000004000000oooo01d0oooo1`0o?ooB0?ooo`009`3oool00`00
0000oooo0?ooo`0L0?ooo`P0?coodP3oool002L0oooo00<000000?ooo`3oool0703oool903loodd0
oooo1`0o?omm0?ooo`009`3oool00`000000oooo0?ooo`0L0?ooo`@0?coo00<0oooo03loo`0o?ol0
0P0o?om=0?ooo`T0?cooN`3oool002L0oooo00<00000@000003oool06`3oool503loo`030?ooo`0o
?ol0?coo00<0?cooB`3oool<03loogT0oooo000W0?ooo`030000003oool0oooo01/0oooo100o?ol3
0?ooo`@0?cooB@3oool?03loogP0oooo000W0?ooo`030000003oool0oooo01/0oooo100o?ol30?oo
o`@0?cooB@3oool603loo`<0oooo1P0o?omh0?ooo`009`3oool00`000000oooo0?ooo`0J0?ooo`@0
?coo1@3oool403loodP0oooo1@0o?ol60?ooo`H0?cooMP3oool002L0oooo00<000000?ooo`3oool0
6P3oool403loo`D0oooo100o?om70?ooo`@0?coo2@3oool503loogH0oooo000W0?ooo`0300000400
0000oooo01X0oooo100o?ol50?ooo`@0?cooA`3oool403loo`X0oooo1@0o?ome0?ooo`009`3oool0
0`000000oooo0?ooo`0J0?ooo`@0?coo1@3oool403loodL0oooo100o?ol;0?ooo`@0?cooM@3oool0
00d0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo
0080oooo00A000000?ooo`3oool0oooo0d0000040?ooo`030000003oool0oooo01X0oooo100o?ol5
0?ooo`@0?cooAP3oool403loo``0oooo100o?ome0?ooo`00303oool00d000000oooo@00000070?oo
o`03@000003ooom000000080oooo00=000000?oood0000000P3oool00d000000oooo0?ooo`040?oo
o`030000003oool0oooo01T0oooo100o?ol60?ooo`@0?cooAP3oool403loo`d0oooo1@0o?omc0?oo
o`001`3oool3@0000080oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03
@000003ooom0000000<0oooo00=000000?ooo`3oool00`3oool00`00001000000?ooo`0I0?ooo`@0
?coo1`3oool203loodL0oooo100o?ol>0?ooo`@0?cooL`3oool000`0oooo00=000000?oood000000
1`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0H0?ooo`D0?coo1`3oool403loodH0oooo0P0o?ol?0?ooo`H0?coo
L@3oool000`0oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003o
oom000000080oooo00=000000?oood000000103oool00`000000oooo0?ooo`0H0?ooo`@0?coo203o
ool403lood<0oooo100o?olA0?ooo`D0?cooL@3oool000d0oooo00=000000?ooo`3oool01`3oool0
0d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0H0?ooo`@0?coo203oool403lood<0oooo100o?olB0?ooo`@0?cooL@3oool0
02L0oooo00<000000?ooo`3oool0603oool403loo`T0oooo0P0o?om40?ooo`@0?coo4`3oool403lo
og00oooo000W0?ooo`03000004000000oooo01P0oooo100o?ol90?ooo`@0?coo@`3oool203looa@0
oooo100o?om`0?ooo`009`3oool00`000000oooo0?ooo`0H0?ooo`@0?coo2@3oool403looeT0oooo
100o?om`0?ooo`009`3oool00`000000oooo0?ooo`0G0?ooo`@0?coo2P3oool403lood40oooo100o
?olE0?ooo`D0?cooKP3oool002L0oooo00<000000?ooo`3oool05`3oool403loo`/0oooo0P0o?om2
0?ooo`@0?coo5P3oool403loofh0oooo000W0?ooo`030000003oool0oooo01L0oooo100o?ol;0?oo
o`@0?coo@03oool403looaH0oooo1P0o?om/0?ooo`009`3oool00`00001000000?ooo`0F0?ooo`@0
?coo303oool403lood40oooo0P0o?olH0?ooo`D0?cooK03oool002L0oooo00<000000?ooo`3oool0
5P3oool403loo``0oooo100o?omL0?ooo`@0?cooK03oool002L0oooo00<000000?ooo`3oool05P3o
ool403loo`d0oooo0P0o?olo0?ooo`@0?coo6`3oool403loof/0oooo000W0?ooo`030000003oool0
oooo01H0oooo100o?om>0?ooo`@0?coo6`3oool403loof/0oooo000W0?ooo`03000004000000oooo
01H0oooo100o?ol<0?ooo`@0?coo?P3oool403looa/0oooo100o?om[0?ooo`009`3oool00`000000
oooo0?ooo`0E0?ooo`D0?coo303oool403loocl0oooo0P0o?olM0?ooo`D0?cooJ@3oool002L0oooo
00<000000?ooo`3oool05@3oool403loo`d0oooo100o?omO0?ooo`@0?cooJ@3oool002L0oooo00<0
00000?ooo`3oool05@3oool403loo`h0oooo0P0o?omP0?ooo`H0?cooI`3oool002L0oooo00<00000
0?ooo`3oool05@3oool403loodh0oooo100o?olO0?ooo`D0?cooI`3oool002L0oooo00<00000@000
003oool05@3oool403loo`h0oooo100o?oll0?ooo`@0?coo803oool403loofL0oooo000W0?ooo`03
0000003oool0oooo01D0oooo100o?ol>0?ooo`@0?coo?03oool403loob40oooo100o?omV0?ooo`00
9`3oool00`000000oooo0?ooo`0D0?ooo`@0?coo3`3oool403loocd0oooo0P0o?olR0?ooo`@0?coo
IP3oool000d0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003o
ool0oooo0080oooo00=000000?ooo`3oool01D0000030?ooo`030000003oool0oooo01@0oooo100o
?ol@0?ooo`80?cooHP3oool603loof@0oooo000<0?ooo`03@000003ooom0000000L0oooo00=00000
0?oood0000000P3oool00d000000oooo@00000030?ooo`03@000003oool0oooo00<0oooo00<00000
0?ooo`3oool04`3oool503loogD0oooo1@0o?omT0?ooo`001`3oool3@0000080oooo00=000000?oo
od0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0oooo00=000000?oo
o`3oool00`3oool00`00001000000?ooo`0C0?ooo`@0?coo4@3oool403loof80oooo1P0o?omR0?oo
o`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood00
00000`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo100o?olA0?ooo`@0
?coo>@3oool403loobH0oooo1@0o?omR0?ooo`00303oool00d000000oooo@00000070?ooo`03@000
003ooom000000080oooo00=000000?oood0000000`3oool00d000000oooo0?ooo`030?ooo`030000
003oool0oooo01<0oooo100o?olA0?ooo`@0?coo>@3oool403loobL0oooo1P0o?omP0?ooo`003@3o
ool00d000000oooo0?ooo`070?ooo`03@000003oool0oooo0080oooo00A000000?ooo`3oool0oooo
0T0000050?ooo`030000003oool0oooo01<0oooo100o?olB0?ooo`80?coo>P3oool403loobP0oooo
1@0o?omP0?ooo`009`3oool00`00001000000?ooo`0B0?ooo`D0?cooC`3oool203loobX0oooo1P0o
?omN0?ooo`009`3oool00`000000oooo0?ooo`0B0?ooo`@0?coo4`3oool403loofH0oooo1@0o?omN
0?ooo`009`3oool00`000000oooo0?ooo`0B0?ooo`@0?coo4`3oool403loofL0oooo1@0o?omM0?oo
o`009`3oool00`000000oooo0?ooo`0B0?ooo`@0?coo4`3oool403loofP0oooo100o?omM0?ooo`00
9`3oool00`000000oooo0?ooo`0A0?ooo`D0?coo503oool203loocP0oooo100o?ol]0?ooo`H0?coo
F`3oool002L0oooo00<00000@000003oool0403oool503loodl0oooo100o?ol^0?ooo`L0?cooF@3o
ool002L0oooo00<000000?ooo`3oool0403oool503looaD0oooo100o?olf0?ooo`@0?coo;`3oool6
03looeT0oooo000W0?ooo`030000003oool0oooo0100oooo100o?olF0?ooo`@0?coo=`3oool203lo
oc40oooo1`0o?omG0?ooo`009`3oool00`000000oooo0?ooo`0?0?ooo`D0?coo2`3oool3@0000080
oooo00=000000?ooo`3oool00`3oool403looaD0oooo0T0000040?ooo`03@000003oool0oooo01d0
oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0I0?ooo`E000000P3oool00d000000
oooo0?ooo`020?ooo`04@000003oool0oooo0?ooo`L0?coo3P3oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool05P3oool5@0000080oooo0d0000020?ooo`03@000003oool0
oooo01<0oooo000W0?ooo`030000003oool0oooo00l0oooo1@0o?ol<0?ooo`06@000003oool0oooo
@000003ooom000001@3oool203looaH0oooo00=000000?oood0000000P3oool00d000000oooo@000
000M0?ooo`03@000003ooom000000080oooo00=000000?oood000000703oool01d000000oooo0?oo
o`3ooom000000?oood0000000P3oool00d000000oooo@00000030?ooo`P0?coo3P3oool01D000000
oooo0?ooo`3ooom0000000@0oooo00=000000?oood0000006@3oool00d000000oooo0?ooo`030?oo
o`06@000003oool0oooo@000003ooom00000503oool002L0oooo00<00000@000003oool03`3oool4
03loo`/0oooo14000000103ooom000000?oood00000M0?ooo`03@000003ooom000000080oooo00=0
00000?oood0000007@3oool00d000000oooo@00000020?ooo`03@000003ooom0000001`0oooo00M0
00000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000103oool903loo``0
oooo00=000000?ooo`3oool00P3oool01d000000oooo0?ooo`3ooom000000?oood0000006@3oool0
14000000oooo0?ooo`3oool4@00000040?oood000000oooo@00001@0oooo000W0?ooo`030000003o
ool0oooo00h0oooo1@0o?ol;0?ooo`03@000003ooom000000080oooo00=000000?oood000000103o
ool403looaD0oooo0T0000030?ooo`03@000003ooom0000001h0oooo00M000000?ooo`3oool0oooo
@000003ooom0000001`0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=00000
0?oood0000001P3oool;03loo`P0oooo00=000000?ooo`3oool00P3oool01d000000oooo0?ooo`3o
oom000000?oood0000006@3oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d00
0000oooo@000000D0?ooo`009`3oool00`000000oooo0?ooo`0>0?ooo`D0?coo303oool2@0000080
oooo00=000000?oood000000103oool403looaD0oooo00=000000?ooo`3oool00P3oool00d000000
oooo@000000H0?ooo`@0?coo00@0oooo@000003ooom000000P3oool00d000000oooo@000000L0?oo
o`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom0000000P0oooo2`0o
?ol60?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom0000001T0
oooo00=000000?ooo`3oool00P3oool2@0000080oooo00=000000?oood000000503oool002L0oooo
00<000000?ooo`3oool03@3oool503loo`h0oooo00E000000?ooo`3oool0oooo@00000050?ooo`@0
?coo5P3oool2@00000<0oooo00=000000?ooo`3oool05`3oool403loo`80oooo00=000000?ooo`3o
ool00P3oool00d000000oooo0?ooo`0J0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo00T0oooo3@0o?ol00`3ooom00000@00000040?ooo`03@000003oool0oooo0080
oooo00=000000?ooo`3oool05`3oool2@00000D0oooo00E000000?ooo`3oool0oooo@000000E0?oo
o`009`3oool00`00001000000?ooo`0<0?ooo`H0?coo6@3oool203loocH0oooo100o?olm0?oooa40
?coo@@3oool002L0oooo00<000000?ooo`3oool02`3oool603looe<0oooo0P0o?om20?oooa`0?coo
<P3oool002L0oooo00<000000?ooo`3oool02P3oool703looaX0oooo100o?omk0?oooc80?coo6P3o
ool002L0oooo00<000000?ooo`3oool0203oool803looa/0oooo100o?omo0?ooocd0?coo2`3oool0
02L0oooo00<0000003loo`0o?ol03`0o?olL0?ooo`@0?cooQ@3oool603loo`030?ooo`0o?ol0?coo
03@0?coo1@3oool002@0oooo1000000@03looah000000P0o?onF000000P0?coo00<0000003loo`0o
?ol00P0o?ol00`000000?coo03loo`0403loo`030000000o?ol0?coo01H0?coo10000001@0000000
9`3oool00`000000?coo03loo`0=03loo`80oooo00=000000?ooo`3oool01`3oool00d000000oooo
0?ooo`060?ooo`03@000003oool0oooo00H0oooo00=0000003loo`0o?ol00P0o?ol40?ooo`03@000
003oool0oooo00L0oooo00=000000?ooo`3oool01P3oool00d000000oooo0?ooo`060?ooo`03@000
003oool0oooo00L0oooo00=000000?ooo`3oool0103oool403loo`L0oooo00=000000?ooo`3oool0
1`3oool00d000000oooo0?ooo`060?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool0
1`3oool00d000000oooo0?ooo`060?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool0
1P3oool00d000000oooo0?ooo`070?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool0
1P3oool00d000000oooo0?ooo`070?ooo`03@000003oool0oooo00D0oooo0P0o?ol00`3oool0?coo
03loo`0203loo`040?ooo`0o?ol0?coo@00000/0?coo1@3oool002L0oooo00<000000?ooo`0o?ol0
2`0o?olQ0?ooo`@0?coo<@3oool403loohH0oooo0P0o?ol00`3oool0?coo03loo`060?ooo`009`3o
ool00`000000oooo0?ooo`0/0?ooo`@0?coo<@3oool403looi40oooo000W0?ooo`030000003oool0
oooo02d0oooo0P0o?olc0?ooo`80?cooTP3oool002L0oooo00<00000@000003oool0;@3oool403lo
olD0oooo000W0?ooo`030000003oool0oooo02d0oooo100o?oo50?ooo`009`3oool00`000000oooo
0?ooo`0]0?ooo`@0?cooa@3oool002L0oooo00<000000?ooo`3oool0;P3oool203loolH0oooo000W
0?ooo`03000004000000oooo02h0oooo100o?ol^0?ooo`@0?cooTP3oool002L0oooo00<000000?oo
o`3oool0;P3oool403loobh0oooo100o?onB0?ooo`009`3oool00`000000oooo0?ooo`0^0?ooo`@0
?coo;P3oool403looi80oooo000W0?ooo`030000003oool0oooo02l0oooo100o?ol^0?ooo`80?coo
T`3oool002L0oooo00<000000?ooo`3oool0;`3oool403lool<0oooo000W0?ooo`03000004000000
oooo02l0oooo100o?oo30?ooo`009`3oool00`000000oooo0?ooo`0_0?ooo`@0?coo``3oool002L0
oooo00<000000?ooo`3oool0;`3oool403lool<0oooo000W0?ooo`030000003oool0oooo02l0oooo
1@0o?oo20?ooo`009`3oool00`00001000000?ooo`0`0?ooo`@0?coo:`3oool403looi<0oooo000W
0?ooo`030000003oool0oooo0300oooo1@0o?olZ0?ooo`@0?cooT`3oool002L0oooo00<000000?oo
o`3oool0<@3oool403loobX0oooo100o?onC0?ooo`003@3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`05@00000<0
oooo00<000000?ooo`3oool0<@3oool503loobX0oooo0P0o?onD0?ooo`00303oool00d000000oooo
@00000070?ooo`03@000003ooom000000080oooo00=000000?oood0000000`3oool00d000000oooo
0?ooo`030?ooo`030000003oool0oooo0380oooo1@0o?ono0?ooo`00303oool00d000000oooo@000
00070?ooo`03@000003ooom000000080oooo00=000000?oood0000000`3oool00d000000oooo0?oo
o`030?ooo`03000004000000oooo0380oooo1`0o?onm0?ooo`00303oool00d000000oooo@0000007
0?ooo`03@000003ooom000000080oooo00=000000?oood0000000`3oool00d000000oooo0?ooo`03
0?ooo`030000003oool0oooo03<0oooo2@0o?onj0?ooo`00303oool00d000000oooo@00000070?oo
o`03@000003ooom000000080oooo00=000000?oood0000000`3oool00d000000oooo0?ooo`030?oo
o`030000003oool0oooo03@0oooo2@0o?oni0?ooo`003@3oool00d000000oooo0?ooo`070?ooo`03
@000003oool0oooo0080oooo00A000000?ooo`3oool0oooo0T0000050?ooo`030000003oool0oooo
03D0oooo2@0o?olO0?ooo`@0?cooU@3oool002L0oooo00<000000?ooo`3oool0=`3oool803looah0
oooo100o?onE0?ooo`009`3oool00`00001000000?ooo`0j0?ooo`D0?coo7P3oool403looiD0oooo
000W0?ooo`030000003oool0oooo03/0oooo1@0o?olN0?ooo`80?cooUP3oool002L0oooo00<00000
0?ooo`3oool0?03oool403lookH0oooo000W0?ooo`030000003oool0oooo03`0oooo1@0o?one0?oo
o`009`3oool00`00001000000?ooo`0m0?ooo`@0?coo]@3oool002L0oooo00<000000?ooo`3oool0
?@3oool503look@0oooo000W0?ooo`030000003oool0oooo03h0oooo100o?ond0?ooo`009`3oool0
0`000000oooo0?ooo`0n0?ooo`@0?coo6P3oool403looiH0oooo000W0?ooo`030000003oool0oooo
03l0oooo100o?olI0?ooo`@0?cooUP3oool002L0oooo00<00000@000003oool0?`3oool403looaT0
oooo100o?onF0?ooo`009`3oool00`000000oooo0?ooo`0o0?ooo`@0?coo6P3oool203looiL0oooo
000W0?ooo`030000003oool0oooo0400oooo0P0o?ond0?ooo`009`3oool00`000000oooo0?ooo`10
0?ooo`@0?coo/P3oool002L0oooo00<000000?ooo`3oool0@03oool403look80oooo000W0?ooo`03
000004000000oooo0400oooo100o?onb0?ooo`009`3oool00`000000oooo0?ooo`110?ooo`80?coo
603oool403looiL0oooo000=0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3o
ool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo0?ooo`=00000103oool00`000000oooo
0?ooo`110?ooo`@0?coo5P3oool403looiL0oooo000<0?ooo`03@000003ooom0000000L0oooo00=0
00000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003oool0oooo00@0oooo00<0
00000?ooo`3oool0@@3oool403looaH0oooo100o?onG0?ooo`00303oool00d000000oooo@0000007
0?ooo`03@000003ooom000000080oooo00=000000?oood0000000`3oool00d000000oooo0?ooo`03
0?ooo`03000004000000oooo0440oooo100o?olG0?ooo`80?cooV03oool000`0oooo00=000000?oo
od0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0oooo00=000000?oo
o`3oool00`3oool00`000000oooo0?ooo`120?ooo`80?coo/P3oool000`0oooo00=000000?oood00
00001`3oool00d000000oooo@00000020?ooo`03@000003ooom000000080oooo00=000000?oood00
0000103oool00`000000oooo0?ooo`120?ooo`@0?coo/03oool000d0oooo00=000000?ooo`3oool0
1`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`120?ooo`@0?coo/03oool002L0oooo00<000000?ooo`3oool0@P3o
ool403looa@0oooo100o?onH0?ooo`009`3oool00`00001000000?ooo`130?ooo`80?coo5@3oool4
03looiP0oooo000W0?ooo`030000003oool0oooo04@0oooo100o?olB0?ooo`@0?cooV03oool002L0
oooo00<000000?ooo`3oool0A03oool403looa<0oooo0P0o?onI0?ooo`009`3oool00`000000oooo
0?ooo`140?ooo`@0?coo[P3oool002L0oooo00<000000?ooo`3oool0A@3oool203loojl0oooo000W
0?ooo`03000004000000oooo0?H0oooo000W0?ooo`030000003oool0oooo04D0oooo100o?on]0?oo
o`009`3oool00`000000oooo0?ooo`150?ooo`@0?coo3`3oool403looiX0oooo000W0?ooo`030000
003oool0oooo04D0oooo100o?ol?0?ooo`@0?cooVP3oool002L0oooo00<00000@000003oool0AP3o
ool203looa00oooo100o?onJ0?ooo`009`3oool00`000000oooo0?ooo`160?ooo`@0?coo3`3oool2
03looi/0oooo000W0?ooo`030000003oool0oooo04H0oooo100o?on/0?ooo`009`3oool00`000000
oooo0?ooo`160?ooo`@0?coo[03oool002L0oooo00<000000?ooo`3oool0A`3oool203loo`h0oooo
100o?onK0?ooo`009`3oool00`00001000000?ooo`1G0?ooo`@0?cooV`3oool002L0oooo00<00000
0?ooo`3oool0A`3oool403loo``0oooo100o?onK0?ooo`009`3oool00`000000oooo0?ooo`170?oo
o`@0?coo3@3oool203looi`0oooo000=0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3o
ool00P3oool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo0?ooo`9000001@3oool00`00
0000oooo0?ooo`170?ooo`@0?cooZ`3oool000`0oooo00=000000?oood0000001`3oool00d000000
oooo@00000020?ooo`03@000003ooom0000000@0oooo00=000000?ooo`3oool00P3oool00`000000
oooo0?ooo`180?ooo`80?coo[03oool000`0oooo00=000000?oood0000001`3oool00d000000oooo
@00000020?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3oool00`3oool00`0000100000
0?ooo`180?ooo`@0?coo2P3oool403looi`0oooo000<0?ooo`03@000003ooom0000000L0oooo00=0
00000?oood0000000P3oool00d000000oooo@00000040?ooo`03@000003oool0oooo0080oooo00<0
00000?ooo`3oool0B03oool403loo`X0oooo100o?onL0?ooo`00303oool00d000000oooo@0000007
0?ooo`03@000003ooom000000080oooo00=000000?oood0000000P3oool00d000000oooo@0000004
0?ooo`030000003oool0oooo04P0oooo100o?ol:0?ooo`@0?cooW03oool000d0oooo00=000000?oo
o`3oool01`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?oo
o`3oool00`3oool00`000000oooo0?ooo`190?ooo`80?coo303oool203looid0oooo000W0?ooo`03
000004000000oooo04T0oooo100o?onY0?ooo`009`3oool00`000000oooo0?ooo`190?ooo`@0?coo
203oool403looid0oooo000W0?ooo`030000003oool0oooo04T0oooo100o?ol80?ooo`@0?cooW@3o
ool002L0oooo00<000000?ooo`3oool0BP3oool203loo`T0oooo100o?onM0?ooo`009`3oool00`00
0000oooo0?ooo`1:0?ooo`@0?coo203oool203looih0oooo000W0?ooo`03000004000000oooo04X0
oooo100o?ol50?ooo`@0?cooW`3oool002L0oooo00<000000?ooo`3oool0BP3oool403loo`D0oooo
100o?onO0?ooo`009`3oool00`000000oooo0?ooo`1;0?ooo`@0?coo103oool403looil0oooo000W
0?ooo`030000003oool0oooo04/0oooo100o?ol30?ooo`@0?cooX03oool002L0oooo00<00000@000
003oool0B`3oool503loo`80oooo100o?onP0?ooo`009`3oool00`000000oooo0?ooo`1<0?ooo`@0
?coo00<0oooo03loo`0o?ol00`0o?onP0?ooo`009`3oool00`000000oooo0?ooo`1<0?ooo`T0?coo
X@3oool002L0oooo00<000000?ooo`3oool0C@3oool803looj40oooo000W0?ooo`030000003oool0
oooo04d0oooo1`0o?onR0?ooo`009`3oool00`00001000000?ooo`1>0?ooo`D0?cooX`3oool002L0
oooo00<000000?ooo`3oool0D03oool203looj@0oooo000W0?ooo`03@000003oool0oooo0?H0oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.02604, -0.0032455, 
  0.537371, 4.30889*^-05}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{451, 303},
WindowMargins->{{24, Automatic}, {Automatic, 42}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 54, 0, 30, "Input"],
Cell[1766, 51, 124, 4, 71, "Text"],
Cell[1893, 57, 1406, 56, 1074, "Input"],
Cell[3302, 115, 44, 0, 33, "Text"],
Cell[3349, 117, 122, 12, 210, "Input"],
Cell[3474, 131, 47, 0, 33, "Text"],
Cell[3524, 133, 73, 0, 48, "Input"],
Cell[3600, 135, 70, 0, 30, "Input"],
Cell[3673, 137, 50, 0, 33, "Text"],
Cell[3726, 139, 142, 3, 66, "Input"],
Cell[3871, 144, 34, 0, 33, "Text"],
Cell[3908, 146, 63, 0, 30, "Input"],
Cell[3974, 148, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[4023, 152, 475, 12, 246, "Input"],
Cell[4501, 166, 34666, 883, 248, 9434, 567, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[39182, 1052, 183, 3, 52, "Text"],
Cell[39368, 1057, 133, 3, 66, "Input"],
Cell[39504, 1062, 42, 0, 33, "Text"],
Cell[39549, 1064, 131, 3, 48, "Input"],
Cell[39683, 1069, 63, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[39771, 1073, 178, 5, 102, "Input"],
Cell[39952, 1080, 24524, 673, 186, 7328, 456, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

