(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     64216,       1815]*)
(*NotebookOutlinePosition[     64912,       1840]*)
(*  CellTagsIndexPosition[     64868,       1836]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
<<c:\\math\\kniz\\linearal\\tridiago.m
<<c:\\math\\kniz\\options\\optvalue.m\
\>", "Input"],

Cell["\"Butterfly = Bullish + Bearish vertical spread\"", "Text"],

Cell["\<\
ButterflyImpl[X1_,X2_,X3_,X4_,sigma_,r_,D_,t_,m_,n_,trans_,time_]:=
Module[
{doldiag,diag,hordiag},

X=(X1+X2+X3+X4)/4;
xright=Log[Slarge/X];

k1=N[r/(0.5*sigma^2)];
k2=N[(r-D)/(0.5*sigma^2)];
k3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
k4=N[0.25*(k2^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

TransfButterflyPayoff[x_]:=N[Exp[0.5*(k2-1)*x]*(Max[Exp[x]-X1/X,0]-Max[Exp[x]-\
X2/X,0]-Max[Exp[x]-X3/X,0]+Max[Exp[x]-X4/X,0])];
Do[u[i,0]=TransfButterflyPayoff[i*h],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
  Do[
      grad=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      kriv=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
ClenAbs[i]=Abs[N[k4*u[i,j-1]-k2*grad+kriv]],{i,-m+1,m-1}];

op1=0;
op2=0;

ps = Join[{u[-m+1,j-1]-k3*k*ClenAbs[-m+1]-a*op1},
          Table[u[i,j-1]-k3*k*ClenAbs[i],{i,-m+2,m-2}],
          {u[m-1,j-1]-k3*k*ClenAbs[m-1]-c*op2}];

hordiag=Table[c,{i,-m+1,m-2}];
diag=Table[b,{i,-m+1,m-1}];
doldiag=Table[a,{i,-m+2,m-1}];

riesenie=TridiagonalSolve[N[doldiag],N[diag],N[hordiag],N[ps]];
 
u[-m,j]=op1;
Do[u[i,j]=riesenie[[i+m]],{i,-m+1,m-1}];
u[m,j]=op2;

xs=Table[X*Exp[i*h],{i,-m,m}];
ys=Table[X*Exp[-0.5*(k2-1)*i*h-(0.25*(k2-1)^2+k1)*j*k]*u[i,j],{i,-m,m}];
graf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
{j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X1=45;
X2=55;
X3=55;
X4=65;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=100;
n=100;
Slarge=150;
trans=0.02;
time=0.03;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["ButterflyImpl[X1,X2,X3,X4,sigma,r,DD,t,m,n,trans,time]", "Input"],

Cell["\"Explicitn\[EAcute] rie\.9aenie\"", "Text"],

Cell["\<\
Butterfly[S_,X1_,X2_,X3_,X4_,sigma_,r_,DD_,t_]:=
N[EuropeanCallDiv[S,X1,sigma,r,DD,t]-EuropeanCallDiv[S,X2,sigma,r,DD,t]-\
EuropeanCallDiv[S,X3,sigma,r,DD,t]+EuropeanCallDiv[S,X4,sigma,r,DD,t]];\
\>", "Input"],

Cell["\"Payoff diagram\"", "Text"],

Cell["\<\
Payoff[S_,X1_,X2_,X3_,X4_]:=N[Max[S-X1,0]-Max[S-X2,0]-Max[S-X3,0]+Max[S-X4,0]]\
\
\>", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[Butterfly[S,X1,X2,X3,X4,sigma,r,DD,t],{S,0,150},PlotRange->All,\
PlotStyle->RGBColor[0,1,0], DisplayFunction->Identity];
g1=ListPlot[graf[n],PlotStyle->{PointSize[0.015],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];
g2=Plot[Payoff[S,X1,X2,X3,X4],{S,0,150},PlotRange->All, \
DisplayFunction->Identity];

Show[g2,g1,g,AxesLabel -> \
{\"S\",\"V\"},DisplayFunction->$DisplayFunction,PlotRange->{{20,100},{0,15}}]
\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.25 0.0125 0 0.0412023 [
[.125 -0.0125 -6 -9 ]
[.125 -0.0125 6 0 ]
[.25 -0.0125 -6 -9 ]
[.25 -0.0125 6 0 ]
[.375 -0.0125 -6 -9 ]
[.375 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.625 -0.0125 -6 -9 ]
[.625 -0.0125 6 0 ]
[.75 -0.0125 -6 -9 ]
[.75 -0.0125 6 0 ]
[.875 -0.0125 -6 -9 ]
[.875 -0.0125 6 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .0824 -6 -4.5 ]
[-0.0125 .0824 0 4.5 ]
[-0.0125 .16481 -6 -4.5 ]
[-0.0125 .16481 0 4.5 ]
[-0.0125 .24721 -6 -4.5 ]
[-0.0125 .24721 0 4.5 ]
[-0.0125 .32962 -6 -4.5 ]
[-0.0125 .32962 0 4.5 ]
[-0.0125 .41202 -12 -4.5 ]
[-0.0125 .41202 0 4.5 ]
[-0.0125 .49443 -12 -4.5 ]
[-0.0125 .49443 0 4.5 ]
[-0.0125 .57683 -12 -4.5 ]
[-0.0125 .57683 0 4.5 ]
[0 .64303 -5.5 0 ]
[0 .64303 5.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.125 0 m
.125 .00625 L
s
[(30)] .125 -0.0125 0 1 Mshowa
.25 0 m
.25 .00625 L
s
[(40)] .25 -0.0125 0 1 Mshowa
.375 0 m
.375 .00625 L
s
[(50)] .375 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(60)] .5 -0.0125 0 1 Mshowa
.625 0 m
.625 .00625 L
s
[(70)] .625 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(80)] .75 -0.0125 0 1 Mshowa
.875 0 m
.875 .00625 L
s
[(90)] .875 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(100)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.025 0 m
.025 .00375 L
s
.05 0 m
.05 .00375 L
s
.075 0 m
.075 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.175 0 m
.175 .00375 L
s
.2 0 m
.2 .00375 L
s
.225 0 m
.225 .00375 L
s
.275 0 m
.275 .00375 L
s
.3 0 m
.3 .00375 L
s
.325 0 m
.325 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.425 0 m
.425 .00375 L
s
.45 0 m
.45 .00375 L
s
.475 0 m
.475 .00375 L
s
.525 0 m
.525 .00375 L
s
.55 0 m
.55 .00375 L
s
.575 0 m
.575 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.675 0 m
.675 .00375 L
s
.7 0 m
.7 .00375 L
s
.725 0 m
.725 .00375 L
s
.775 0 m
.775 .00375 L
s
.8 0 m
.8 .00375 L
s
.825 0 m
.825 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.925 0 m
.925 .00375 L
s
.95 0 m
.95 .00375 L
s
.975 0 m
.975 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .0824 m
.00625 .0824 L
s
[(2)] -0.0125 .0824 1 0 Mshowa
0 .16481 m
.00625 .16481 L
s
[(4)] -0.0125 .16481 1 0 Mshowa
0 .24721 m
.00625 .24721 L
s
[(6)] -0.0125 .24721 1 0 Mshowa
0 .32962 m
.00625 .32962 L
s
[(8)] -0.0125 .32962 1 0 Mshowa
0 .41202 m
.00625 .41202 L
s
[(10)] -0.0125 .41202 1 0 Mshowa
0 .49443 m
.00625 .49443 L
s
[(12)] -0.0125 .49443 1 0 Mshowa
0 .57683 m
.00625 .57683 L
s
[(14)] -0.0125 .57683 1 0 Mshowa
.125 Mabswid
0 .0206 m
.00375 .0206 L
s
0 .0412 m
.00375 .0412 L
s
0 .0618 m
.00375 .0618 L
s
0 .10301 m
.00375 .10301 L
s
0 .12361 m
.00375 .12361 L
s
0 .14421 m
.00375 .14421 L
s
0 .18541 m
.00375 .18541 L
s
0 .20601 m
.00375 .20601 L
s
0 .22661 m
.00375 .22661 L
s
0 .26781 m
.00375 .26781 L
s
0 .28842 m
.00375 .28842 L
s
0 .30902 m
.00375 .30902 L
s
0 .35022 m
.00375 .35022 L
s
0 .37082 m
.00375 .37082 L
s
0 .39142 m
.00375 .39142 L
s
0 .43262 m
.00375 .43262 L
s
0 .45322 m
.00375 .45322 L
s
0 .47383 m
.00375 .47383 L
s
0 .51503 m
.00375 .51503 L
s
0 .53563 m
.00375 .53563 L
s
0 .55623 m
.00375 .55623 L
s
0 .59743 m
.00375 .59743 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(V) show
69.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.06185 0 m
.1416 0 L
.21837 0 L
.25749 0 L
.27811 0 L
.28939 0 L
.29996 0 L
.30477 0 L
.30933 0 L
.31185 0 L
.31327 .00255 L
.3146 .00691 L
.31941 .02279 L
.34084 .0934 L
.37857 .21779 L
.39938 .28637 L
.41898 .35097 L
.42753 .37917 L
.43221 .39458 L
.43449 .40211 L
.43657 .40897 L
.43886 .40755 L
.4413 .39949 L
.44649 .38239 L
.45561 .35233 L
.49636 .21802 L
.53406 .09376 L
.54314 .06382 L
.55293 .03155 L
.55743 .01671 L
.55989 .00862 L
.56217 .00109 L
.56413 0 L
.56622 0 L
.57065 0 L
.58912 0 L
.60952 0 L
.69122 0 L
.76993 0 L
.84566 0 L
.92622 0 L
s
.25 .25 1 r
.015 w
.00208 0 Mdot
.00463 0 Mdot
.00719 0 Mdot
.00979 0 Mdot
.01241 0 Mdot
.01505 0 Mdot
.01772 0 Mdot
.02042 0 Mdot
.02315 0 Mdot
.02591 0 Mdot
.02869 0 Mdot
.0315 0 Mdot
.03434 0 Mdot
.0372 0 Mdot
.0401 0 Mdot
.04302 0 Mdot
.04598 0 Mdot
.04896 0 Mdot
.05198 0 Mdot
.05502 0 Mdot
.0581 0 Mdot
.06121 0 Mdot
.06434 0 Mdot
.06751 0 Mdot
.07071 0 Mdot
.07395 0 Mdot
.07722 0 Mdot
.08051 0 Mdot
.08385 0 Mdot
.08721 0 Mdot
.09061 0 Mdot
.09405 0 Mdot
.09752 0 Mdot
.10102 0 Mdot
.10456 0 Mdot
.10814 0 Mdot
.11175 0 Mdot
.1154 0 Mdot
.11908 0 Mdot
.1228 0 Mdot
.12656 0 Mdot
.13036 0 Mdot
.13419 1e-005 Mdot
.13807 1e-005 Mdot
.14198 1e-005 Mdot
.14593 2e-005 Mdot
.14993 2e-005 Mdot
.15396 3e-005 Mdot
.15803 5e-005 Mdot
.16215 6e-005 Mdot
.1663 9e-005 Mdot
.1705 .00012 Mdot
.17474 .00016 Mdot
.17902 .00022 Mdot
.18335 .0003 Mdot
.18772 .0004 Mdot
.19213 .00053 Mdot
.19659 .0007 Mdot
.20109 .00092 Mdot
.20564 .0012 Mdot
.21024 .00155 Mdot
.21488 .00199 Mdot
.21957 .00254 Mdot
.2243 .00322 Mdot
.22908 .00405 Mdot
.23391 .00506 Mdot
.23879 .00627 Mdot
.24372 .00771 Mdot
.2487 .00941 Mdot
.25373 .01139 Mdot
.25881 .01367 Mdot
.26394 .01627 Mdot
.26912 .0192 Mdot
.27436 .02246 Mdot
.27964 .02603 Mdot
.28498 .0299 Mdot
.29038 .034 Mdot
.29583 .0383 Mdot
.30133 .04269 Mdot
.30689 .04712 Mdot
.31251 .05156 Mdot
.31818 .05598 Mdot
.32391 .06036 Mdot
.32969 .06467 Mdot
.33554 .0689 Mdot
.34144 .073 Mdot
.34741 .07696 Mdot
.35343 .08075 Mdot
.35952 .08435 Mdot
.36566 .08772 Mdot
.37187 .09085 Mdot
.37814 .09371 Mdot
.38447 .09629 Mdot
.39087 .09856 Mdot
.39733 .10051 Mdot
.40386 .10212 Mdot
.41046 .10338 Mdot
.41712 .10427 Mdot
.42384 .1048 Mdot
.43064 .10494 Mdot
.4375 .10471 Mdot
.44443 .1041 Mdot
.45143 .1031 Mdot
.45851 .10174 Mdot
.46565 .10001 Mdot
.47287 .09792 Mdot
.48016 .09549 Mdot
.48752 .09273 Mdot
.49496 .08966 Mdot
.50247 .0863 Mdot
.51006 .08266 Mdot
.51772 .07878 Mdot
.52546 .07467 Mdot
.53328 .07036 Mdot
.54118 .06588 Mdot
.54916 .06125 Mdot
.55722 .0565 Mdot
.56535 .05166 Mdot
.57358 .04676 Mdot
.58188 .04188 Mdot
.59027 .03712 Mdot
.59874 .03258 Mdot
.6073 .02832 Mdot
.61594 .02438 Mdot
.62468 .0208 Mdot
.6335 .01759 Mdot
.64241 .01474 Mdot
.6514 .01224 Mdot
.66049 .01009 Mdot
.66967 .00824 Mdot
.67895 .00668 Mdot
.68831 .00537 Mdot
.69778 .00428 Mdot
.70733 .00339 Mdot
.71699 .00267 Mdot
.72674 .00208 Mdot
.73659 .00161 Mdot
.74653 .00124 Mdot
.75658 .00095 Mdot
.76673 .00072 Mdot
.77699 .00054 Mdot
.78734 .00041 Mdot
.7978 .0003 Mdot
.80837 .00022 Mdot
.81904 .00016 Mdot
.82982 .00012 Mdot
.84071 9e-005 Mdot
.8517 6e-005 Mdot
.86281 5e-005 Mdot
.87403 3e-005 Mdot
.88537 2e-005 Mdot
.89682 2e-005 Mdot
.90838 1e-005 Mdot
.92006 1e-005 Mdot
.93186 1e-005 Mdot
.94378 0 Mdot
.95582 0 Mdot
.96797 0 Mdot
.98026 0 Mdot
.99266 0 Mdot
0 1 0 r
.5 Mabswid
0 0 m
.00102 0 L
.00307 0 L
.00532 0 L
.00775 0 L
.01018 0 L
.01284 0 L
.01562 0 L
.0182 0 L
.02063 0 L
.02284 0 L
.02538 0 L
.02778 0 L
.03217 0 L
.03438 0 L
.03681 0 L
.03888 0 L
.0411 0 L
.04512 0 L
.04753 0 L
.05016 0 L
.05248 0 L
.05494 0 L
.05959 1e-005 L
.0639 1e-005 L
.06857 1e-005 L
.0735 2e-005 L
.07771 3e-005 L
.08231 4e-005 L
.08729 5e-005 L
.0926 7e-005 L
.09762 .0001 L
.10218 .00014 L
.1068 .00018 L
.11105 .00023 L
.11573 .0003 L
.12068 .0004 L
.129 .00062 L
.13373 .00078 L
.13815 .00097 L
.14794 .00152 L
.15347 .00193 L
.15861 .0024 L
.16802 .00348 L
.17805 .00504 L
.1879 .00705 L
.19718 .00947 L
.21453 .01558 L
.23377 .02512 L
.25408 .03857 L
Mistroke
.29046 .07031 L
.3296 .10971 L
.36526 .14172 L
.37472 .14856 L
.385 .15496 L
.39389 .15955 L
.4037 .16355 L
.40905 .16524 L
.41408 .16652 L
.41938 .16754 L
.42236 .16796 L
.4251 .16825 L
.42748 .16843 L
.4297 .16854 L
.43214 .1686 L
.43474 .16858 L
.43605 .16854 L
.43747 .16848 L
.44005 .1683 L
.44257 .16806 L
.44488 .16777 L
.4497 .167 L
.4541 .16607 L
.46399 .1633 L
.47315 .15992 L
.48185 .15607 L
.5225 .13197 L
.59783 .0791 L
.63991 .05412 L
.67799 .0366 L
.69712 .02961 L
.71777 .02331 L
.75517 .01473 L
.77395 .01157 L
.79453 .0088 L
.81602 .00656 L
.83604 .00496 L
.85669 .00368 L
.87622 .00277 L
.89375 .00213 L
.91278 .00159 L
.93136 .0012 L
.95182 .00087 L
.97319 .00062 L
.99321 .00045 L
Mfstroke
.99321 .00045 m
1 .00041 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{440, 271.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006h00013b000`400?l00000o`00003oo`3oooni
0?ooo`00B03oool2@00000@0oooo00=000000?ooo`3oool09`3oool3@0000080oooo00=000000?oo
o`3oool0:03oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo02H0oooo0T0000040?oo
o`03@000003oool0oooo02L0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0W0?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool09P3oool2@00000@0oooo00=000000?oo
o`3oool08P3oool5@0000080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0K0?oo
o`00BP3oool01T000000oooo0?oood000000oooo@00002T0oooo00I000000?ooo`3ooom000000?oo
od00000X0?ooo`03@000003ooom000000080oooo00=000000?oood0000009`3oool00d000000oooo
@00000020?ooo`03@000003ooom0000002P0oooo00M000000?ooo`3oool0oooo@000003ooom00000
02L0oooo00=000000?oood0000000P3oool00d000000oooo@000000Y0?ooo`06@000003oool0oooo
@000003ooom000009@3oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000
oooo@000000L0?ooo`00B@3oool01d000000oooo0?ooo`3ooom000000?oood0000009`3oool4@000
00040?oood000000oooo@00002X0oooo00I000000?ooo`3ooom000000?oood00000W0?ooo`03@000
003ooom000000080oooo00=000000?oood000000:03oool01d000000oooo0?ooo`3ooom000000?oo
od0000009`3oool00d000000oooo@00000020?ooo`03@000003ooom0000002P0oooo0T0000020?oo
o`03@000003ooom0000002D0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=0
00000?oood000000703oool004X0oooo00I000000?ooo`3ooom000000?oood00000W0?ooo`03@000
003ooom000000080oooo00=000000?oood000000:03oool2@00000<0oooo00=000000?oood000000
9`3oool2@00000<0oooo00=000000?oood000000:@3oool01T000000oooo0?oood000000oooo@000
02P0oooo00M000000?ooo`3oool0oooo@000003ooom0000002L0oooo00=000000?oood0000000P3o
ool00d000000oooo@000000U0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03
@000003ooom0000001`0oooo00180?ooo`03@000003ooom000000080oooo00=000000?oood000000
:03oool2@0000080oooo00=000000?oood000000:03oool00d000000oooo0?ooo`020?ooo`03@000
003ooom0000002L0oooo00=000000?ooo`3oool00P3oool00d000000oooo@000000W0?ooo`03@000
003ooom000000080oooo00=000000?oood0000009`3oool00d000000oooo@00000020?ooo`03@000
003ooom0000002L0oooo00=000000?oood0000000P3oool00d000000oooo@000000U0?ooo`07@000
003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom0000001`0oooo00190?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool0:03oool01D000000oooo0?ooo`3ooom00000
02T0oooo0d0000030?ooo`03@000003oool0oooo02L0oooo0T0000030?ooo`03@000003oool0oooo
02H0oooo0d0000030?ooo`03@000003oool0oooo02L0oooo00=000000?ooo`3oool00P3oool00d00
0000oooo0?ooo`0W0?ooo`9000000`3oool00d000000oooo0?ooo`0S0?ooo`900000103oool00d00
0000oooo0?ooo`020?ooo`03@000003oool0oooo01/0oooo003o0?oookT0oooo003o0?oookT0oooo
003o0?oookT0oooo003o0?oookT0oooo003o0?oooj<0oooo0d00000C0?ooo`00o`3ooonS0?ooo`03
@000003ooom0000001<0oooo000L0?ooo`0303loo`00o`000?l002h00?l08`0o?onm00000280?coo
00<0000003loo`0o?ol05P0o?ol00`000000?coo03loo`0:03loo`030000000o?ol0?coo00H0?coo
00<0000003loo`0o?ol01P0o?ol00`000000?coo03loo`0603loo`L00?l03@3oool00d000000oooo
0?ooo`0A0?ooo`00703ooola03loo`h00?l0700o?ol40?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool00`3oool]03loo`030?ooo`0o?ol0?coo0180?coo;000o`000`3oool0?coo03lo
o`0203loo`030?ooo`000000oooo00/0oooo00=000000?ooo`3oool04P3oool001`0oooo?`0o?ol7
003o01T0?coo00<000000?ooo`3oool01`3oool00d000000oooo0?ooo`060?ooo`03@000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo@00000080?ooo`03@000003oool0oooo00L0oooo00<0
00000?ooo`3oool01P3oool00d000000oooo0?ooo`060?ooo`03@000003oool0oooo00L0oooo00=0
00000?ooo`3oool01P3oool00d000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00=0
00000?ooo`3oool01P3oool00d000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00=0
00000?ooo`3oool01P3oool00d000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00=0
00000?ooo`3oool01P3ooold03loo`030?ooo`0o?ol0?coo00<0?coo3`00o`0403loo`030?ooo`0o
?ol0?coo00X0?coo00<0oooo03loo`0o?ol01P0o?ol00`3oool0?coo03loo`0603loo`030?ooo`0o
?ol0?coo00H0?coo00<0oooo03loo`0o?ol00P0o?ol00`3oool000000?ooo`0:0?ooo`03@000003o
oom0000001<0oooo000M0?ooodD0?coo1000o`0G03looaL0oooo00<000000?ooo`3oool0503oool0
0d000000oooo0?ooo`0/0?ooo`03@000003oool0oooo01<0oooo00<000000?ooo`3oool05P3oool0
0d000000oooo0?ooo`080?oooaT0?coo00@0oooo03loo`0o?ol0oooo0P0o?ol20?ooo`80?coo00@0
oooo@000000o?ol0?coo0P3oool203loo`80oooo0P0o?ol20?ooo`80?coo0P3oool203loo`030?oo
o`0o?ol0?coo00L00?l00P0o?ol20?ooo`80?coo0P3oool203loo`80oooo0P0o?ol20?ooo`80?coo
00=000000?ooo`3oool00P0o?ol20?ooo`80?coo0P3oool203loo`<0oooo0P0o?ol20?ooo`80?coo
0`3oool203loo`80oooo0P0o?ol30?ooo`80?coo0P3oool203loo`<0oooo0P0o?ol20?ooo`03@000
003oool0oooo00T0oooo0d00000C0?ooo`007@3oool00`000000oooo0?ooo`160?ooo`@00?l01@3o
ool@03looaD0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0M0?oooa80?coo00@0
oooo03loo`0o?ol0oooo0P0o?ol20?ooo`80?coo6P3oool8003o06X0oooo000M0?ooo`030000003o
ool0oooo04X0oooo0`00o`090?ooo`X0?coo5@3oool00`000000oooo0?ooo`1H0?ooo`030000003o
ool0oooo01X0oooo3P0o?ol0103oool0?coo03loo`3oool203looad0oooo2000o`1b0?ooo`007@3o
ool00`000000oooo0?ooo`1=0?ooo`800?l02`3oool803looa<0oooo00<000000?ooo`3oool0E`3o
ool00`000000oooo0?ooo`0H0?ooo`X0?coo00@0oooo03loo`0o?ol0oooo0P0o?olN0?ooo`H00?l0
NP3oool001d0oooo00<000000?ooo`3oool0C`3oool2003o00/0oooo200o?olA0?ooo`030000003o
ool0oooo05L0oooo00<000000?ooo`3oool0503oool=03loob40oooo1000o`200?ooo`007@3oool2
00000003@000003oool0oooo04l0oooo0P00o`0:0?ooo`T0?coo403oool00`000000oooo0?ooo`1F
0?ooo`030000003oool0oooo01@0oooo2P0o?olO0?ooo`D00?l0Q03oool001d0oooo00<000000?oo
o`3oool0D`3oool2003o00X0oooo2@0o?ol>0?ooo`030000003oool0oooo05H0oooo00<000000?oo
o`3oool04@3oool703loo`030?ooo`0o?ol0?coo01h0oooo1000o`290?ooo`007@3oool00`000000
oooo0?ooo`1E0?ooo`03003o003oool0oooo00T0oooo1`0o?ol>0?ooo`030000003oool0oooo05D0
oooo00<000000?ooo`3oool03`3oool903looah0oooo1000o`2=0?ooo`007@3oool00`000000oooo
0?ooo`1F0?ooo`800?l02`3oool703loo`d0oooo00<000000?ooo`3oool0E03oool00`000000oooo
0?ooo`0?0?ooo`L0?coo703oool4003o0940oooo000M0?ooo`030000003oool0oooo05P0oooo00<0
0?l00?ooo`3oool02P3oool703loo`/0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?oo
o`0<0?ooo`T0?coo6`3oool2003o09D0oooo000M0?ooo`030000003oool0oooo05T0oooo0P00o`0;
0?ooo`H0?coo2`3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo00`0oooo1P0o?olL
0?ooo`800?l0U`3oool001d0oooo00<000000?ooo`3oool0F`3oool2003o00X0oooo1`0o?ol:0?oo
o`030000003oool0oooo0580oooo00<000000?ooo`3oool02@3oool803looa/0oooo0`00o`2I0?oo
o`007@3oool00`000000oooo0?ooo`1M0?ooo`03003o003oool0oooo00T0oooo1@0o?ol:0?ooo`03
0000003oool0oooo0580oooo00<000000?ooo`3oool01P3oool703loo`030?ooo`0o?ol0?coo01X0
oooo0P00o`2L0?ooo`007@3oool200000003@000003oool0oooo05`0oooo00<00?l00?ooo`3oool0
2@3oool603loo`P0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`060?ooo`L0?coo
6`3oool2003o09h0oooo000M0?ooo`030000003oool0oooo05l0oooo00<00?l00?ooo`3oool02@3o
ool803loo`D0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`040?ooo`T0?coo6P3o
ool2003o0:00oooo000M0?ooo`030000003oool0oooo0600oooo0P00o`0:0?ooo`L0?coo1P3oool0
0`000000oooo0?ooo`1@0?ooo`030000003oool0oooo00@0oooo1P0o?olK0?ooo`800?l0XP3oool0
01d0oooo00<000000?ooo`3oool0HP3oool00`00o`00oooo0?ooo`080?ooo`P0?coo103oool00`00
0000oooo0?ooo`1@0?ooo`040000003oool0oooo0?ooo`L0?coo6`3oool2003o0:@0oooo000M0?oo
o`030000003oool0oooo06<0oooo00<00?l00?ooo`3oool02P3oool503loo`@0oooo00<000000?oo
o`3oool0C`3oool00`000000oooo0?ooo`020?ooo`H0?coo6P3oool2003o0:H0oooo000M0?ooo`03
0000003oool0oooo06@0oooo00<00?l00?ooo`3oool02P3oool603loo`<0oooo00<000000?ooo`3o
ool0CP3oool00`000000oooo03loo`0603looaX0oooo0P00o`2X0?ooo`007@3oool00`000000oooo
0?ooo`1U0?ooo`03003o003oool0oooo00X0oooo1`0o?ol00`3oool000000?ooo`1?0?ooo`030000
003oool0?coo00D0?coo6@3oool2003o0:X0oooo000M0?ooo`030000003oool0oooo06H0oooo00<0
0?l00?ooo`3oool02P3oool603loo`030?ooo`000000oooo04h0oooo1`0o?olI0?ooo`800?l0[03o
ool001d0oooo0P0000000d000000oooo0?ooo`1U0?ooo`800?l02`3oool703loo`030000003oool0
oooo04T0oooo2@0o?olH0?ooo`800?l0[P3oool001d0oooo00<000000?ooo`3oool0J@3oool00`00
o`00oooo0?ooo`0:0?ooo`D0?coo00<000000?ooo`3oool0B@3oool703looaT0oooo00<00?l00?oo
o`3oool0[P3oool001d0oooo00<000000?ooo`3oool0JP3oool00`00o`00oooo0?ooo`0:0?ooo`H0
?cooA`3oool903looaP0oooo0P00o`2a0?ooo`007@3oool00`000000oooo0?ooo`1[0?ooo`03003o
003oool0oooo00X0oooo200o?om40?ooo`H0?coo6@3oool2003o0;<0oooo000M0?ooo`030000003o
ool0oooo06`0oooo00<00?l00?ooo`3oool02P3oool703lood40oooo1`0o?ol00`3oool000000?oo
o`0F0?ooo`800?l0]@3oool001D0oooo0d0000050?ooo`030000003oool0oooo06d0oooo00<00?l0
0?ooo`3oool02P3oool803looc`0oooo2@0o?ol00`3oool000000?ooo`0E0?ooo`800?l0]`3oool0
01D0oooo00=000000?ooo`3oool01@3oool00`000000oooo0?ooo`1^0?ooo`03003o003oool0oooo
00/0oooo00<0000003loo`0o?ol01@0o?olj0?ooo`L0?coo0`3oool00`000000oooo0?ooo`0C0?oo
o`03003o003oool0oooo0;L0oooo000F0?ooo`03@000003oool0oooo00@0oooo0`0000000d000000
oooo0?ooo`1/0?ooo`03003o003oool0oooo00/0oooo00<0000003loo`0o?ol01P0o?ole0?ooo`T0
?coo103oool00`000000oooo0?ooo`0A0?ooo`800?l0^P3oool001H0oooo00=000000?ooo`3oool0
103oool00`000000oooo0?ooo`1`0?ooo`03003o003oool0oooo00X0oooo00<000000?ooo`0o?ol0
1P0o?olb0?ooo`T0?coo1P3oool00`000000oooo0?ooo`0A0?ooo`03003o003oool0oooo0;X0oooo
000E0?ooo`03@000003ooom0000000D0oooo00<000000?ooo`3oool0L@3oool00`00o`00oooo0?oo
o`090?ooo`040000003oool0oooo0?ooo`P0?coo;03oool:03loo`P0oooo00<000000?ooo`3oool0
403oool00`00o`00oooo0?ooo`2k0?ooo`005P3oool00d000000oooo0?ooo`040?ooo`030000003o
ool0oooo0780oooo00<00?l00?ooo`3oool02@3oool00`000000oooo0?ooo`020?ooo`P0?coo:P3o
ool903loo`T0oooo00<000000?ooo`3oool03P3oool2003o0;h0oooo000M0?ooo`030000003oool0
oooo0780oooo00<00?l00?ooo`3oool02@3oool00`000000oooo0?ooo`040?ooo`P0?coo9P3oool8
03loo`/0oooo00<000000?ooo`3oool03P3oool00`00o`00oooo0?ooo`2n0?ooo`007@3oool00`00
0000oooo0?ooo`1c0?ooo`03003o003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool:03lo
oad0oooo2`0o?ol>0?ooo`030000003oool0oooo00`0oooo0P00o`310?ooo`007@3oool00`000000
oooo0?ooo`1d0?ooo`03003o003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool=03looaD0
oooo3@0o?ol?0?ooo`030000003oool0oooo00/0oooo00<00?l00?ooo`3oool0`@3oool001d0oooo
00<000000?ooo`3oool0M@3oool00`00o`00oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo
3@0o?ol>0?oooa40?coo3`3oool00`000000oooo0?ooo`0;0?ooo`03003o003oool0oooo0<80oooo
000M0?ooo`80000000=000000?ooo`3oool0M03oool00`00o`00oooo0?ooo`060?ooo`030000003o
ool0oooo00/0oooo8`0o?ol00`3oool0?coo03loo`0B0?ooo`030000003oool0oooo00T0oooo0P00
o`350?ooo`007@3oool00`000000oooo0?ooo`1g0?ooo`03003o003oool0oooo00D0oooo00<00000
0?ooo`3oool03@3oool203loo`030?ooo`0o?ol0?coo01T0?coo603oool00`000000oooo0?ooo`08
0?ooo`03003o003oool0oooo0<D0oooo000M0?ooo`030000003oool0oooo07P0oooo00<00?l00?oo
o`3oool01@3oool00`000000oooo0?ooo`0A0?oooa@0?coo00<0oooo03loo`0o?ol06@3oool00`00
0000oooo0?ooo`070?ooo`800?l0b03oool001d0oooo00<000000?ooo`3oool0N@3oool00`00o`00
oooo0?ooo`040?ooo`030000003oool0oooo01@0oooo100o?ol00`3oool0?coo03loo`0203loo`03
0?ooo`0o?ol0?coo0080?coo7`3oool00`000000oooo0?ooo`060?ooo`03003o003oool0oooo0<P0
oooo000M0?ooo`030000003oool0oooo07X0oooo00<00?l00?ooo`3oool00`3oool00`000000oooo
0?ooo`110?ooo`030000003oool0oooo00D0oooo00<00?l00?ooo`3oool0b@3oool001d0oooo00<0
00000?ooo`3oool0N`3oool00`00o`00oooo0?ooo`030?ooo`030000003oool0oooo0400oooo00<0
00000?ooo`3oool00`3oool2003o0<`0oooo000M0?ooo`030000003oool0oooo07`0oooo0P00o`03
0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool00`3oool00`00o`00oooo0?ooo`3<
0?ooo`007@3oool00`000000oooo0?ooo`1n0?ooo`04003o003oool0oooo00000440oooo00@00000
0?ooo`3oool0oooo0P00o`3?0?ooo`007@3oool200000003@000003oool0oooo07d0oooo00@00?l0
0?ooo`3oool00000@03oool010000000oooo0?ooo`00o`3A0?ooo`007@3oool00`000000oooo0?oo
o`200?ooo`03003o003oool0000003l0oooo00@000000?ooo`3oool00?l0dP3oool001d0oooo00<0
00000?ooo`3oool0P@3oool00`00o`0000000?ooo`0n0?ooo`0300000000o`000?l00=<0oooo000M
0?ooo`030000003oool0oooo0880oooo00<00?l00?ooo`3oool0?@3oool00`00o`00oooo0?ooo`3C
0?ooo`007@3oool00`000000oooo0?ooo`230?ooo`800?l0>`3oool2003o0=H0oooo000M0?ooo`03
0000003oool0oooo08<0oooo00<000000?ooo`00o`00>03oool2003o00030?ooo`000000oooo0=D0
oooo000M0?ooo`030000003oool0oooo08<0oooo00@000000?ooo`3oool00?l0=P3oool01@00o`00
oooo0?ooo`3oool000000=H0oooo000M0?ooo`030000003oool0oooo08@0oooo00@000000?ooo`3o
ool00?l0<`3oool2003o00@0oooo00<000000?ooo`3oool0e03oool001d0oooo0P0000000d000000
oooo0?ooo`220?ooo`040000003oool0oooo0?ooo`800?l0;`3oool2003o00D0oooo00<000000?oo
o`3oool0e@3oool001d0oooo00<000000?ooo`3oool0Q03oool00`000000oooo0?ooo`030?ooo`03
003o003oool0oooo02/0oooo00<00?l00?ooo`3oool01@3oool00`000000oooo0?ooo`3E0?ooo`00
7@3oool00`000000oooo0?ooo`250?ooo`030000003oool0oooo00<0oooo00<00?l00?ooo`3oool0
:03oool2003o00P0oooo00<000000?ooo`3oool0e@3oool001d0oooo00<000000?ooo`3oool0Q@3o
ool00`000000oooo0?ooo`040?ooo`800?l09P3oool2003o00T0oooo00<000000?ooo`3oool0eP3o
ool001d0oooo00<000000?ooo`3oool0Q@3oool00`000000oooo0?ooo`060?ooo`800?l08`3oool0
0`00o`00oooo0?ooo`090?ooo`030000003oool0oooo0=H0oooo000F0?ooo`=00000103oool00`00
0000oooo0?ooo`250?ooo`030000003oool0oooo00P0oooo0`00o`0N0?ooo`800?l0303oool00`00
0000oooo0?ooo`3F0?ooo`005`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo08H0
oooo00<000000?ooo`3oool02P3oool2003o01X0oooo0P00o`0=0?ooo`030000003oool0oooo0=L0
oooo000E0?ooo`A00000103oool300000003@000003oool0oooo08<0oooo00<000000?ooo`3oool0
303oool00`00o`00oooo0?ooo`0C0?ooo`@00?l03`3oool00`000000oooo0?ooo`3G0?ooo`005@3o
ool00d000000oooo@00000050?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool03@3o
ool6003o00T0oooo1P00o`0C0?ooo`030000003oool0oooo0=L0oooo000F0?ooo`9000001@3oool0
0`000000oooo0?ooo`270?ooo`030000003oool0oooo0180oooo2@00o`0H0?ooo`030000003oool0
oooo0=P0oooo000G0?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0Q`3oool00`00
0000oooo0?ooo`0c0?ooo`030000003oool0oooo0=P0oooo000M0?ooo`030000003oool0oooo08L0
oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`3H0?ooo`007@3oool00`000000oooo
0?ooo`280?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0f03oool001d0oooo00<0
00000?ooo`3oool0R03oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0=T0oooo000M
0?ooo`030000003oool0oooo08P0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`3I
0?ooo`007@3oool200000003@000003oool0oooo08H0oooo00<000000?ooo`3oool0<@3oool00`00
0000oooo0?ooo`3I0?ooo`007@3oool00`000000oooo0?ooo`290?ooo`030000003oool0oooo02l0
oooo00<000000?ooo`3oool0fP3oool001d0oooo00<000000?ooo`3oool0R@3oool00`000000oooo
0?ooo`0_0?ooo`030000003oool0oooo0=X0oooo000M0?ooo`030000003oool0oooo08T0oooo00<0
00000?ooo`3oool0;`3oool00`000000oooo0?ooo`3J0?ooo`007@3oool00`000000oooo0?ooo`2:
0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0f`3oool001d0oooo00<000000?oo
o`3oool0RP3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0=/0oooo000M0?ooo`03
0000003oool0oooo08X0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`3K0?ooo`00
7@3oool00`000000oooo0?ooo`2;0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0
f`3oool001d0oooo0P0000000d000000oooo0?ooo`290?ooo`030000003oool0oooo02/0oooo00<0
00000?ooo`3oool0g03oool001d0oooo00<000000?ooo`3oool0R`3oool00`000000oooo0?ooo`0[
0?ooo`030000003oool0oooo0=`0oooo000M0?ooo`030000003oool0oooo08/0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`3L0?ooo`007@3oool00`000000oooo0?ooo`2<0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool0g@3oool001d0oooo00<000000?ooo`3oool0
S03oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0=d0oooo000M0?ooo`030000003o
ool0oooo08`0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`3M0?ooo`007@3oool0
0`000000oooo0?ooo`2=0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0gP3oool0
01d0oooo00<000000?ooo`3oool0S@3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
0=h0oooo000M0?ooo`80000000=000000?ooo`3oool0R`3oool00`000000oooo0?ooo`0W0?ooo`03
0000003oool0oooo0=h0oooo000M0?ooo`030000003oool0oooo08h0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`3N0?ooo`007@3oool00`000000oooo0?ooo`2>0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool0g`3oool001d0oooo00<000000?ooo`3oool0SP3oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0=l0oooo000M0?ooo`030000003oool0oooo
08h0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`3O0?ooo`005@3oool2@00000H0
oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0>00
oooo000E0?ooo`03@000003ooom0000000D0oooo00<000000?ooo`3oool0S`3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo0>00oooo000E0?ooo`03@000003ooom0000000D0oooo0`00
00000d000000oooo0?ooo`2<0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0h03o
ool001D0oooo0T0000060?ooo`030000003oool0oooo0900oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`3Q0?ooo`005@3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo
0900oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`3Q0?ooo`005P3oool2@00000D0
oooo00<000000?ooo`3oool0T03oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0>40
oooo000M0?ooo`030000003oool0oooo0940oooo00<000000?ooo`3oool0803oool00`000000oooo
0?ooo`3Q0?ooo`007@3oool00`000000oooo0?ooo`2A0?ooo`030000003oool0oooo01l0oooo00<0
00000?ooo`3oool0hP3oool001d0oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo0>80oooo000M0?ooo`030000003oool0oooo0980oooo00<000000?oo
o`3oool07P3oool00`000000oooo0?ooo`3R0?ooo`007@3oool200000003@000003oool0oooo0900
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`3S0?ooo`007@3oool00`000000oooo
0?ooo`2B0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0h`3oool001d0oooo00<0
00000?ooo`3oool0TP3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0><0oooo000M
0?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`3S
0?ooo`007@3oool00`000000oooo0?ooo`2C0?ooo`030000003oool0oooo01/0oooo00<000000?oo
o`3oool0i03oool001d0oooo00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0>@0oooo000M0?ooo`030000003oool0oooo09@0oooo00<000000?ooo`3oool0
6P3oool00`000000oooo0?ooo`3T0?ooo`007@3oool00`000000oooo0?ooo`2D0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0i@3oool001d0oooo0P0000000d000000oooo0?ooo`2B
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0i@3oool001d0oooo00<000000?oo
o`3oool0U@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0>D0oooo000M0?ooo`03
0000003oool0oooo09D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`3V0?ooo`00
7@3oool00`000000oooo0?ooo`2E0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
iP3oool001d0oooo00<000000?ooo`3oool0U@3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo0>H0oooo000M0?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3oool05P3oool0
0`000000oooo0?ooo`3V0?ooo`007@3oool00`000000oooo0?ooo`2F0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0i`3oool001d0oooo00<000000?ooo`3oool0UP3oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo0>L0oooo000M0?ooo`80000000=000000?ooo`3oool0
U@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0>L0oooo000M0?ooo`030000003o
ool0oooo09L0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`3X0?ooo`007@3oool0
0`000000oooo0?ooo`2G0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0j03oool0
01d0oooo00<000000?ooo`3oool0V03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
0>P0oooo000M0?ooo`030000003oool0oooo09P0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`3X0?ooo`005P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo09P0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`3Y0?ooo`005@3oool00d000000oooo@000
00050?ooo`030000003oool0oooo09P0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`3Y0?ooo`005@3oool00d000000oooo@00000050?ooo`<0000000=000000?ooo`3oool0UP3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0>T0oooo000F0?ooo`03@000003oool0oooo
00@0oooo00<000000?ooo`3oool0V@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
0>X0oooo000E0?ooo`03@000003ooom0000000D0oooo00<000000?ooo`3oool0V@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo0>X0oooo000F0?ooo`03@000003oool0oooo00@0oooo
00<000000?ooo`3oool0VP3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0>X0oooo
000M0?ooo`030000003oool0oooo09X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`3[0?ooo`007@3oool00`000000oooo0?ooo`2J0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0j`3oool001d0oooo00<000000?ooo`3oool0VP3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo0>/0oooo000M0?ooo`030000003oool0oooo09/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`3[0?ooo`007@3oool200000003@000003oool0oooo09T0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3/0?ooo`007@3oool00`000000oooo0?oo
o`2K0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0k03oool001d0oooo00<00000
0?ooo`3oool0W03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0>`0oooo000M0?oo
o`030000003oool0oooo09`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`3]0?oo
o`007@3oool00`000000oooo0?ooo`2L0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0k@3oool001d0oooo00<000000?ooo`3oool0W03oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo0>d0oooo000M0?ooo`030000003oool0oooo09d0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`3^0?ooo`007@3oool00`000000oooo0?ooo`2M0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0kP3oool001d0oooo0P0000000d000000oooo0?ooo`2K0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0k`3oool001d0oooo00<000000?ooo`3o
ool0W@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0>l0oooo000M0?ooo`030000
003oool0oooo09h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3_0?ooo`007@3o
ool00`000000oooo0?ooo`2N0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0l03o
ool001d0oooo00<000000?ooo`3oool0WP3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo0?00oooo000M0?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`3`0?ooo`007@3oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0l03oool001d0oooo00<000000?ooo`3oool0W`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0?00oooo000M0?ooo`80000000=000000?ooo`3oool0WP3o
ool01@000000oooo0?ooo`3oool000000?<0oooo000M0?ooo`030000003oool0oooo0:00oooo00D0
00000?ooo`3oool0oooo0000003c0?ooo`007@3oool00`000000oooo0?ooo`2P0?ooo`050000003o
ool0oooo0?ooo`000000l`3oool001d0oooo00<000000?ooo`3oool0X@3oool010000000oooo0?oo
o`00003c0?ooo`007@3oool00`000000oooo0?ooo`2Q0?ooo`040000003oool0oooo00000?<0oooo
000?0?ooo`E000000P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo0:80oooo0P00
003d0?ooo`004@3oool01d000000oooo0?ooo`3ooom000000?oood0000001@3oool00`000000oooo
0?ooo`2R0?ooo`800000m03oool00140oooo00M000000?ooo`3oool0oooo@000003ooom0000000D0
oooo0`0000000d000000oooo0?ooo`3o0?oooiH0oooo000A0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000050?ooo`030000003oool0oooo0?l0ooooV@3oool00140oooo00M000000?ooo`3o
ool0oooo@000003ooom0000000D0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`00403oool2@000
00@0oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?ooo`03
0000003oool0oooo0?l0ooooV@3oool001d0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`007@3o
ool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?ooo`030000003oool0oooo0?l0ooooV@3oool0
01d0oooo0P0000000d000000oooo0?ooo`3o0?oooiL0oooo000M0?ooo`030000003oool0oooo0?l0
ooooV@3oool001d0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`007@3oool00`000000oooo0?oo
o`3o0?oooiT0oooo000M0?ooo`030000003oool0oooo0?l0ooooV@3oool001d0oooo00<000000?oo
o`3oool0o`3ooonI0?ooo`007@3oool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?ooo`030000
003oool0oooo0?l0ooooV@3oool001d0oooo0P0000000d000000oooo0?ooo`3o0?oooiL0oooo000M
0?ooo`030000003oool0oooo0?l0ooooV@3oool001d0oooo00<000000?ooo`3oool0o`3ooonI0?oo
o`007@3oool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?ooo`030000003oool0oooo0?l0oooo
V@3oool001d0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`007@3oool00`000000oooo0?ooo`3o
0?oooiT0oooo000M0?ooo`030000003oool0oooo0?l0ooooV@3oool001d0oooo0P0000000d000000
oooo0?ooo`3o0?oooiL0oooo000M0?ooo`030000003oool0oooo0?l0ooooV@3oool001d0oooo00<0
00000?ooo`3oool0o`3ooonI0?ooo`007@3oool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?oo
o`030000003oool0oooo0?l0ooooV@3oool001d0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`00
3`3oool5@00000040?oood0000100000@00000D0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`00
4@3oool01D000000oooo0?ooo`3ooom0000000L0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`00
4@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00@0oooo0`0000000d000000oooo
0?ooo`3o0?oooiH0oooo000A0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0103o
ool00`000000oooo0?ooo`3o0?oooiT0oooo000A0?ooo`07@000003oool0oooo0?oood000000oooo
@00000050?ooo`030000003oool0oooo0?l0ooooV@3oool00100oooo0T0000040?ooo`03@000003o
ool0oooo00@0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`007@3oool00`000000oooo0?ooo`3o
0?oooiT0oooo000M0?ooo`030000003oool0oooo0?l0ooooV@3oool001d0oooo00<000000?ooo`3o
ool0o`3ooonI0?ooo`007@3oool200000003@000003oool0oooo0?l0ooooU`3oool001d0oooo00<0
00000?ooo`3oool0o`3ooonI0?ooo`007@3oool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?oo
o`030000003oool0oooo0?l0ooooV@3oool001d0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`00
7@3oool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?ooo`030000003oool0oooo0?l0ooooV@3o
ool001d0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`007@3oool200000003@000003oool0oooo
0?l0ooooU`3oool001d0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`007@3oool00`000000oooo
0?ooo`3o0?oooiT0oooo000M0?ooo`030000003oool0oooo0?l0ooooV@3oool001d0oooo00<00000
0?ooo`3oool0o`3ooonI0?ooo`007@3oool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?ooo`03
0000003oool0oooo0?l0ooooV@3oool001d0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`007@3o
ool200000003@000003oool0oooo0?l0ooooU`3oool001d0oooo00<000000?ooo`3oool0o`3ooonI
0?ooo`007@3oool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?ooo`030000003oool0oooo0?l0
ooooV@3oool001d0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`007@3oool00`000000oooo0?oo
o`3o0?oooiT0oooo000?0?ooo`E000000P3oool3@00000@0oooo00<000000?ooo`3oool0o`3ooonI
0?ooo`004@3oool00d000000oooo0?ooo`030?ooo`03@000003oool0oooo00<0oooo00<000000?oo
o`3oool0o`3ooonI0?ooo`004@3oool014000000oooo0?ooo`3oool4@00000@0oooo0`0000000d00
0000oooo0?ooo`3o0?oooiH0oooo000A0?ooo`07@000003oool0oooo0?oood000000oooo@0000005
0?ooo`030000003oool0oooo0?l0ooooV@3oool00140oooo00=000000?ooo`3oool00P3oool2@000
00D0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`00403oool2@00000D0oooo00=000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?ooo`030000003oool0oooo0?l0oooo
V@3oool001d0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`007@3oool00`000000oooo0?ooo`3o
0?oooiT0oooo000M0?ooo`80000000=000000?ooo`3oool0o`3ooonG0?ooo`007@3oool00`000000
oooo0?ooo`3o0?oooiT0oooo000M0?ooo`030000003oool0oooo0?l0ooooV@3oool001d0oooo00<0
00000?ooo`3oool0o`3ooonI0?ooo`007@3oool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?oo
o`030000003oool0oooo0?l0ooooV@3oool001d0oooo00<000000?ooo`3oool0o`3ooonI0?ooo`00
7@3oool00`000000oooo0?ooo`3o0?oooiT0oooo000M0?ooo`03@000003oool0oooo0?l0ooooV@3o
ool00?l0oooo^@3oool00?l0oooo^@3oool00?l0oooo^@3oool00?l0oooo^@3oool00?l0oooo^@3o
ool00?l0oooo^@3oool00?l0oooo^@3oool00?l0oooo^@3oool00?l0oooo^@3oool00?l0oooo^@3o
ool00?l0oooo^@3oool00?l0oooo^@3oool00?l0oooo^@3oool00?l0oooo^@3oool001`0oooo0T00
003o0?oooi/0oooo000K0?ooo`03@000003ooom000000?l0ooooV`3oool001/0oooo00=000000?oo
od000000o`3ooonK0?ooo`006`3oool014000000oooo0?oood00003o0?oooiX0oooo000J0?ooo`05
@000003oool0oooo0?oood000000o`3ooonJ0?ooo`006P3oool2@00000030?oood00001000000?l0
ooooVP3oool00?l0oooo^@3oool00?l0oooo^@3oool00?l0oooo^@3oool00?l0oooo^@3oool00001
\
\>"],
  ImageRangeCache->{{{0, 439}, {270.938, 0}} -> {13.6717, -0.883331, 0.212373,
   0.06443}}]
}, Open  ]],

Cell[TextData[
"\"Err - rozdiel medzi explicitn\[YAcute]m rie\.9aen\[IAcute]m a na\.9aim v\
\[YAcute]sledkom\ntr1: tabu\:017eka chyby pribli\.9en\[EAcute]ho \
rie\.9aenia\""], "Text"],

Cell["\<\
Err[i_,sgm_]:=Butterfly[xs[[i]],X1,X2,X3,X4,sgm,r,DD,t]-ys[[i]];
tr1:=Table[{xs[[i]],Err[i,sigma]},{i,2m+1}];\
\>", "Input"],

Cell["\"Maximov\[AAcute] chyba\"", "Text"],

Cell["\<\
Print[\"m = \",m,\" n = \",n,\" trans = \",trans,\" Max.chyba = \
\",Max[Table[Abs[Err[i,str]],{i,2m+1}]]]\
\>", "Input"],

Cell["\"Graf chyby pri delen\[IAcute] m = 100, n=100\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=ListPlot[tr1,PlotStyle->{PointSize[0.02],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->All]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.124121 0.00733541 0.399981 28.6737 [
[.1693 .38748 -6 -9 ]
[.1693 .38748 6 0 ]
[.316 .38748 -6 -9 ]
[.316 .38748 6 0 ]
[.46271 .38748 -6 -9 ]
[.46271 .38748 6 0 ]
[.60942 .38748 -9 -9 ]
[.60942 .38748 9 0 ]
[.75613 .38748 -9 -9 ]
[.75613 .38748 9 0 ]
[.90284 .38748 -9 -9 ]
[.90284 .38748 9 0 ]
[.01009 .11324 -30 -4.5 ]
[.01009 .11324 0 4.5 ]
[.01009 .25661 -36 -4.5 ]
[.01009 .25661 0 4.5 ]
[.01009 .54335 -30 -4.5 ]
[.01009 .54335 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.1693 .39998 m
.1693 .40623 L
s
[(40)] .1693 .38748 0 1 Mshowa
.316 .39998 m
.316 .40623 L
s
[(60)] .316 .38748 0 1 Mshowa
.46271 .39998 m
.46271 .40623 L
s
[(80)] .46271 .38748 0 1 Mshowa
.60942 .39998 m
.60942 .40623 L
s
[(100)] .60942 .38748 0 1 Mshowa
.75613 .39998 m
.75613 .40623 L
s
[(120)] .75613 .38748 0 1 Mshowa
.90284 .39998 m
.90284 .40623 L
s
[(140)] .90284 .38748 0 1 Mshowa
.125 Mabswid
.05926 .39998 m
.05926 .40373 L
s
.09594 .39998 m
.09594 .40373 L
s
.13262 .39998 m
.13262 .40373 L
s
.20597 .39998 m
.20597 .40373 L
s
.24265 .39998 m
.24265 .40373 L
s
.27933 .39998 m
.27933 .40373 L
s
.35268 .39998 m
.35268 .40373 L
s
.38936 .39998 m
.38936 .40373 L
s
.42603 .39998 m
.42603 .40373 L
s
.49939 .39998 m
.49939 .40373 L
s
.53607 .39998 m
.53607 .40373 L
s
.57274 .39998 m
.57274 .40373 L
s
.6461 .39998 m
.6461 .40373 L
s
.68277 .39998 m
.68277 .40373 L
s
.71945 .39998 m
.71945 .40373 L
s
.79281 .39998 m
.79281 .40373 L
s
.82948 .39998 m
.82948 .40373 L
s
.86616 .39998 m
.86616 .40373 L
s
.93951 .39998 m
.93951 .40373 L
s
.97619 .39998 m
.97619 .40373 L
s
.25 Mabswid
0 .39998 m
1 .39998 L
s
.02259 .11324 m
.02884 .11324 L
s
[(-0.01)] .01009 .11324 1 0 Mshowa
.02259 .25661 m
.02884 .25661 L
s
[(-0.005)] .01009 .25661 1 0 Mshowa
.02259 .54335 m
.02884 .54335 L
s
[(0.005)] .01009 .54335 1 0 Mshowa
.125 Mabswid
.02259 .14192 m
.02634 .14192 L
s
.02259 .17059 m
.02634 .17059 L
s
.02259 .19927 m
.02634 .19927 L
s
.02259 .22794 m
.02634 .22794 L
s
.02259 .28529 m
.02634 .28529 L
s
.02259 .31396 m
.02634 .31396 L
s
.02259 .34263 m
.02634 .34263 L
s
.02259 .37131 m
.02634 .37131 L
s
.02259 .42865 m
.02634 .42865 L
s
.02259 .45733 m
.02634 .45733 L
s
.02259 .486 m
.02634 .486 L
s
.02259 .51468 m
.02634 .51468 L
s
.02259 .08457 m
.02634 .08457 L
s
.02259 .0559 m
.02634 .0559 L
s
.02259 .02722 m
.02634 .02722 L
s
.02259 .57202 m
.02634 .57202 L
s
.02259 .6007 m
.02634 .6007 L
s
.25 Mabswid
.02259 0 m
.02259 .61803 L
s
.25 .25 1 r
.02 w
.02381 .39999 Mdot
.0253 .39998 Mdot
.02681 .39997 Mdot
.02833 .39996 Mdot
.02987 .39996 Mdot
.03142 .39995 Mdot
.03299 .39993 Mdot
.03457 .39992 Mdot
.03617 .3999 Mdot
.03779 .39987 Mdot
.03942 .39984 Mdot
.04107 .39981 Mdot
.04274 .39976 Mdot
.04442 .3997 Mdot
.04612 .39963 Mdot
.04783 .39955 Mdot
.04957 .39944 Mdot
.05132 .39932 Mdot
.05309 .39916 Mdot
.05488 .39898 Mdot
.05668 .39876 Mdot
.0585 .3985 Mdot
.06035 .39819 Mdot
.06221 .39783 Mdot
.06408 .3974 Mdot
.06598 .39691 Mdot
.0679 .39634 Mdot
.06984 .39568 Mdot
.07179 .39493 Mdot
.07377 .39407 Mdot
.07576 .39311 Mdot
.07778 .39203 Mdot
.07981 .39083 Mdot
.08187 .38951 Mdot
.08395 .38807 Mdot
.08605 .3865 Mdot
.08816 .38482 Mdot
.09031 .38304 Mdot
.09247 .38117 Mdot
.09465 .37924 Mdot
.09686 .37727 Mdot
.09909 .3753 Mdot
.10134 .37337 Mdot
.10361 .37153 Mdot
.10591 .36985 Mdot
.10823 .36838 Mdot
.11057 .36721 Mdot
.11293 .36641 Mdot
.11533 .36608 Mdot
.11774 .3663 Mdot
.12018 .36718 Mdot
.12264 .3688 Mdot
.12513 .37126 Mdot
.12764 .37466 Mdot
.13018 .37907 Mdot
.13275 .38457 Mdot
.13534 .3912 Mdot
.13795 .39901 Mdot
.1406 .40802 Mdot
.14326 .4182 Mdot
.14596 .42952 Mdot
.14868 .4419 Mdot
.15144 .45523 Mdot
.15421 .46936 Mdot
.15702 .48411 Mdot
.15986 .49926 Mdot
.16272 .51454 Mdot
.16561 .52968 Mdot
.16853 .54433 Mdot
.17148 .55817 Mdot
.17446 .57081 Mdot
.17747 .5819 Mdot
.18052 .59106 Mdot
.18359 .5979 Mdot
.18669 .6021 Mdot
.18982 .60332 Mdot
.19299 .60128 Mdot
.19619 .59575 Mdot
.19942 .58656 Mdot
.20268 .5736 Mdot
.20598 .55684 Mdot
.2093 .53634 Mdot
.21267 .51224 Mdot
.21606 .48477 Mdot
.21949 .45423 Mdot
.22296 .42105 Mdot
.22646 .38568 Mdot
.22999 .34869 Mdot
.23356 .31068 Mdot
.23717 .27231 Mdot
.24081 .23428 Mdot
.24449 .19729 Mdot
.24821 .16205 Mdot
.25196 .12926 Mdot
.25576 .09957 Mdot
.25959 .07358 Mdot
.26346 .05183 Mdot
.26736 .03476 Mdot
.27131 .02274 Mdot
.2753 .01601 Mdot
.27933 .01472 Mdot
.28339 .01886 Mdot
.2875 .02835 Mdot
.29165 .04298 Mdot
.29585 .06241 Mdot
.30008 .08622 Mdot
.30436 .1139 Mdot
.30868 .14485 Mdot
.31304 .17843 Mdot
.31745 .21394 Mdot
.3219 .25067 Mdot
.3264 .28789 Mdot
.33094 .32491 Mdot
.33553 .36104 Mdot
.34017 .39564 Mdot
.34485 .42815 Mdot
.34958 .45807 Mdot
.35436 .48497 Mdot
.35918 .50853 Mdot
.36405 .5285 Mdot
.36898 .54475 Mdot
.37395 .5572 Mdot
.37897 .56589 Mdot
.38404 .57094 Mdot
.38917 .57252 Mdot
.39434 .57089 Mdot
.39957 .56635 Mdot
.40485 .55922 Mdot
.41019 .54989 Mdot
.41557 .53873 Mdot
.42102 .52614 Mdot
.42651 .51251 Mdot
.43207 .49821 Mdot
.43767 .48359 Mdot
.44334 .46898 Mdot
.44906 .45467 Mdot
.45484 .4409 Mdot
.46068 .42789 Mdot
.46657 .41581 Mdot
.47253 .4048 Mdot
.47855 .39494 Mdot
.48462 .38628 Mdot
.49076 .37886 Mdot
.49696 .37265 Mdot
.50323 .36763 Mdot
.50955 .36373 Mdot
.51594 .36089 Mdot
.5224 .35901 Mdot
.52891 .35799 Mdot
.5355 .35774 Mdot
.54215 .35815 Mdot
.54887 .35912 Mdot
.55566 .36054 Mdot
.56251 .36232 Mdot
.56943 .36438 Mdot
.57643 .36663 Mdot
.58349 .369 Mdot
.59063 .37143 Mdot
.59783 .37387 Mdot
.60511 .37627 Mdot
.61247 .37859 Mdot
.61989 .38081 Mdot
.6274 .38291 Mdot
.63497 .38488 Mdot
.64263 .38669 Mdot
.65036 .38835 Mdot
.65817 .38986 Mdot
.66606 .39123 Mdot
.67403 .39245 Mdot
.68207 .39353 Mdot
.6902 .39448 Mdot
.69841 .39532 Mdot
.70671 .39605 Mdot
.71509 .39668 Mdot
.72355 .39722 Mdot
.7321 .39769 Mdot
.74073 .39808 Mdot
.74945 .39842 Mdot
.75826 .3987 Mdot
.76716 .39893 Mdot
.77614 .39913 Mdot
.78522 .39929 Mdot
.79439 .39942 Mdot
.80365 .39953 Mdot
.81301 .39962 Mdot
.82246 .3997 Mdot
.832 .39976 Mdot
.84164 .3998 Mdot
.85138 .39984 Mdot
.86122 .39987 Mdot
.87115 .3999 Mdot
.88119 .39991 Mdot
.89133 .39993 Mdot
.90157 .39994 Mdot
.91191 .39995 Mdot
.92235 .39996 Mdot
.93291 .39997 Mdot
.94357 .39997 Mdot
.95433 .39998 Mdot
.96521 .39998 Mdot
.97619 .39998 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`009`3oool0
0`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000
oooo0?ooo`0l0?ooo`@0?coo]P3oool002L0oooo00<000000?ooo`3oool0>`3oool603lookD0oooo
000W0?ooo`030000003oool0oooo03X0oooo1`0o?one0?ooo`009`3oool00`000000oooo0?ooo`0j
0?ooo`L0?coo]@3oool002L0oooo00<000000?ooo`3oool0>P3oool803look@0oooo000W0?ooo`03
000004000000oooo03T0oooo100o?ol00`3oool0?coo03loo`0203look@0oooo000W0?ooo`030000
003oool0oooo03T0oooo100o?ol00`3oool0?coo03loo`0203look@0oooo000W0?ooo`030000003o
ool0oooo03T0oooo100o?ol20?ooo`80?coo]@3oool002L0oooo00<000000?ooo`3oool0>P3oool2
03loo`<0oooo100o?onc0?ooo`009`3oool00`000000oooo0?ooo`0o0?ooo`@0?coo/`3oool002L0
oooo00<000000?ooo`3oool0>03oool403loo`<0oooo100o?onc0?ooo`009`3oool00`000000oooo
0?ooo`0h0?ooo`@0?coo103oool203look@0oooo000W0?ooo`03000004000000oooo03P0oooo100o
?onj0?ooo`009`3oool00`000000oooo0?ooo`0i0?ooo`80?coo1@3oool403look80oooo000W0?oo
o`030000003oool0oooo0400oooo100o?onb0?ooo`009`3oool00`000000oooo0?ooo`0g0?ooo`@0
?coo1@3oool403look80oooo000W0?ooo`030000003oool0oooo03L0oooo100o?ol60?ooo`80?coo
/`3oool002L0oooo00<000000?ooo`3oool0=`3oool403look/0oooo000W0?ooo`030000003oool0
oooo03P0oooo0P0o?onl0?ooo`009`3oool00`00001000000?ooo`110?ooo`@0?coo/@3oool002L0
oooo00<000000?ooo`3oool0@@3oool403look40oooo000W0?ooo`030000003oool0oooo0440oooo
100o?ona0?ooo`009`3oool00`000000oooo0?ooo`0f0?ooo`@0?coo203oool203look80oooo000W
0?ooo`030000003oool0oooo03H0oooo100o?onl0?ooo`004P3oool00d000000oooo0?ooo`020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool01D0000030?ooo`030000003oool0oooo
03H0oooo100o?onl0?ooo`004@3oool00d000000oooo@00000070?ooo`03@000003ooom0000000<0
oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`0g0?ooo`80?coo_@3oool000`0oooo
0d0000020?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000`3oool00d000000oooo
0?ooo`030?ooo`03000004000000oooo0480oooo100o?on`0?ooo`004@3oool00d000000oooo@000
00070?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3oool00`3oool00`000000oooo0?oo
o`120?ooo`@0?coo/03oool00140oooo00=000000?oood0000001`3oool00d000000oooo@0000003
0?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0@P3oool403look00oooo000B0?oo
o`03@000003oool0oooo00L0oooo00A000000?ooo`3oool0oooo0T0000050?ooo`030000003oool0
oooo03D0oooo100o?ol:0?ooo`80?coo/@3oool002L0oooo00<000000?ooo`3oool0=@3oool403lo
okd0oooo000W0?ooo`030000003oool0oooo03D0oooo100o?onm0?ooo`009`3oool00`000000oooo
0?ooo`0f0?ooo`80?coo_P3oool002L0oooo00<000000?ooo`3oool0@`3oool403loojl0oooo000W
0?ooo`03000004000000oooo04<0oooo100o?on_0?ooo`009`3oool00`000000oooo0?ooo`130?oo
o`@0?coo[`3oool002L0oooo00<000000?ooo`3oool0A03oool203look00oooo000W0?ooo`030000
003oool0oooo0?H0oooo000W0?ooo`030000003oool0oooo03@0oooo100o?onn0?ooo`009`3oool0
0`000000oooo0?ooo`0d0?ooo`@0?coo_P3oool002L0oooo00<000000?ooo`3oool0=03oool403lo
okh0oooo000W0?ooo`03000004000000oooo03D0oooo0P0o?ono0?ooo`009`3oool00`000000oooo
0?ooo`140?ooo`@0?coo[P3oool002L0oooo00<000000?ooo`3oool0A03oool403loojh0oooo000W
0?ooo`030000003oool0oooo04@0oooo100o?on^0?ooo`009`3oool00`000000oooo0?ooo`150?oo
o`80?coo[`3oool002L0oooo00<000000?ooo`3oool0mP3oool002L0oooo00<000000?ooo`3oool0
<`3oool403lookl0oooo000W0?ooo`03000004000000oooo03<0oooo100o?ono0?ooo`009`3oool0
0`000000oooo0?ooo`0c0?ooo`@0?coo_`3oool002L0oooo00<000000?ooo`3oool0=03oool203lo
ol00oooo000W0?ooo`030000003oool0oooo04D0oooo100o?on]0?ooo`009`3oool00`000000oooo
0?ooo`150?ooo`@0?coo[@3oool002L0oooo00<000000?ooo`3oool0A@3oool403loojd0oooo000W
0?ooo`030000003oool0oooo04H0oooo0P0o?on^0?ooo`009`3oool00`00001000000?ooo`3f0?oo
o`009`3oool00`000000oooo0?ooo`0b0?ooo`@0?coo`03oool002L0oooo00<000000?ooo`3oool0
<P3oool403lool00oooo000W0?ooo`030000003oool0oooo0380oooo100o?oo00?ooo`009`3oool0
0`000000oooo0?ooo`0c0?ooo`80?coo`@3oool002L0oooo00<000000?ooo`3oool0A`3oool403lo
oj/0oooo000=0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000
oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00`3oool00`000000
oooo0?ooo`170?ooo`@0?cooZ`3oool000`0oooo00=000000?oood0000001`3oool00d000000oooo
@00000020?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool00`000000oooo
0?ooo`170?ooo`@0?cooZ`3oool000L0oooo0d0000020?ooo`03@000003ooom0000000L0oooo00=0
00000?oood0000000P3oool00d000000oooo@00000040?ooo`03@000003oool0oooo0080oooo00<0
0000@000003oool0B03oool203looj`0oooo000<0?ooo`03@000003ooom0000000L0oooo00=00000
0?oood0000000P3oool00d000000oooo@00000020?ooo`9000001@3oool00`000000oooo0?ooo`3f
0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oo
od0000000P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo0?H0oooo000=0?ooo`03
@000003oool0oooo00L0oooo00=000000?ooo`3oool00P3oool014000000oooo0?ooo`3oool3@000
00@0oooo00<000000?ooo`3oool0<@3oool403lool40oooo000W0?ooo`030000003oool0oooo0340
oooo100o?oo10?ooo`009`3oool00`000000oooo0?ooo`0a0?ooo`@0?coo`@3oool002L0oooo00<0
00000?ooo`3oool0<P3oool203lool80oooo000W0?ooo`03000004000000oooo04P0oooo100o?onZ
0?ooo`009`3oool00`000000oooo0?ooo`180?ooo`@0?cooZP3oool002L0oooo00<000000?ooo`3o
ool0B03oool403loojX0oooo000W0?ooo`030000003oool0oooo04T0oooo0P0o?on[0?ooo`009`3o
ool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`0`0?ooo`@0?coo`P3oool0
02L0oooo00<000000?ooo`3oool0<03oool403lool80oooo000W0?ooo`03000004000000oooo0300
oooo100o?oo20?ooo`009`3oool00`000000oooo0?ooo`0a0?ooo`80?coo``3oool002L0oooo00<0
00000?ooo`3oool0B@3oool403loojT0oooo000W0?ooo`030000003oool0oooo04T0oooo100o?onY
0?ooo`009`3oool00`000000oooo0?ooo`190?ooo`@0?cooZ@3oool002L0oooo00<000000?ooo`3o
ool0BP3oool203loojX0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W0?ooo`030000003o
ool0oooo0?H0oooo000W0?ooo`03000004000000oooo02l0oooo100o?oo30?ooo`009`3oool00`00
0000oooo0?ooo`0_0?ooo`@0?coo``3oool002L0oooo00<000000?ooo`3oool0;`3oool403loodP0
oooo1`0o?omd0?ooo`009`3oool00`000000oooo0?ooo`0O0?ooo`=000000P3oool00d000000oooo
0?ooo`090?ooo`80?coo4@3oool2@00000@0oooo00=0000003loo`0o?ol00P0o?olK0?ooo`03@000
003oool0oooo0080oooo00=000000?ooo`3oool01`3oool>03loo`@0oooo1D0000020?ooo`03@000
003oool0oooo0080oooo00=000000?ooo`3oool05P3oool5@00000040?oood0000100000@00000<0
oooo00=000000?ooo`3oool05P3oool5@0000080oooo0d0000020?ooo`03@000003oool0oooo01<0
oooo000W0?ooo`030000003oool0oooo0180oooo100o?ol:0?ooo`06@000003oool0oooo@000003o
oom000007@3oool00d000000oooo@00000020?ooo`03@000003oool0?coo00<0?coo6P3oool00d00
0000oooo@00000020?ooo`03@000003ooom0000000H0oooo4`0o?ol30?ooo`07@000003oool0oooo
0?oood000000oooo@00000020?ooo`03@000003ooom0000001T0oooo00E000000?ooo`3oool0oooo
@00000040?ooo`03@000003ooom0000001T0oooo00=000000?ooo`3oool00`3oool01T000000oooo
0?oood000000oooo@00001@0oooo000W0?ooo`030000003oool0oooo0100oooo200o?ol60?ooo`A0
000000@0oooo@000003ooom000007@3oool00d000000oooo@00000020?ooo`03@000003oool0?coo
00<0?coo6P3oool00d000000oooo@00000020?ooo`03@000003ooom0000000D0oooo600o?ol30?oo
o`03@000003ooom000000080oooo00=000000?oood0000006@3oool00d000000oooo0?ooo`020?oo
o`07@000003oool0oooo0?oood000000oooo@000000I0?ooo`04@000003oool0oooo0?ooo`A00000
00@0oooo@000003ooom00000503oool002L0oooo00<000000?ooo`3oool03`3oool:03loo`D0oooo
00=000000?oood0000000P3oool00d000000oooo@000000M0?ooo`9000000`3oool00d000000oooo
@000000203looa`0oooo00M000000?ooo`3oool0oooo@000003ooom0000000<0oooo2@0o?ol50?oo
oa00?coo00L0oooo@000003oool0oooo@000003ooom0000001T0oooo00=000000?ooo`3oool00P3o
ool01d000000oooo0?ooo`3ooom000000?oood0000006@3oool01d000000oooo0?ooo`3ooom00000
0?oood0000000P3oool00d000000oooo@000000D0?ooo`009`3oool00`00001000000?ooo`0>0?oo
o`/0?coo1P3oool2@0000080oooo00=000000?oood0000007@3oool00d000000oooo0?ooo`020?oo
o`03@000003ooom0000001d0oooo00=000000?oood0000000P3oool00d000000oooo@00000030?oo
o`H0?coo303oool=03loo`06@000003oool0oooo@000003ooom000006@3oool01d000000oooo0?oo
o`3ooom000000?oood0000000P3oool00d000000oooo@000000I0?ooo`03@000003oool0oooo0080
oooo0T0000020?ooo`03@000003ooom0000001@0oooo000W0?ooo`030000003oool0oooo00`0oooo
3P0o?ol60?ooo`05@000003oool0oooo0?oood0000007`3oool2@00000<0oooo00=000000?ooo`3o
ool07@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00L0?coo403oool>03loo`03
@000003oool0oooo01L0oooo0T0000040?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3o
ool05`3oool2@00000D0oooo00E000000?ooo`3oool0oooo@000000E0?ooo`009`3oool00`000000
oooo0?ooo`0;0?ooo`L0?coo0`3oool603looa<0oooo100o?olo0?ooo`D0?coo5P3oool>03looe`0
oooo000W0?ooo`030000003oool0oooo00X0oooo1`0o?ol50?ooo`D0?coo4`3oool403looch0oooo
1@0o?olJ0?ooo`l0?cooF03oool002L0oooo00<000000?ooo`3oool0203oool803loo`L0oooo100o
?olC0?ooo`@0?coo?P3oool403looad0oooo5@0o?om@0?ooo`009`3oool00`000000oooo0?ooo`05
0?ooo`X0?coo203oool403looa@0oooo0P0o?olJ0?ooo`@0?coo7`3oool603loob40oooo6`0o?om6
0?ooo`009@3ooolC03loo`T0oooo1@0o?ol_0?ooo`@0?coo7`3oool503loobH0ooooE`0o?ol60?oo
o`008@3oool400000140?coo3000000403loobl00000100o?olN000000D0?coo:`00001C03loo`D0
00000D00000002D0oooo400o?ol40?ooo`03@000003oool0oooo00H0oooo1@0o?ol50?ooo`030000
003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool00d000000oooo0?ooo`070?ooo`03@000
003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool203loo`80oooo00=000000?ooo`3oool0
1`3oool00d000000oooo0?ooo`060?ooo`03@000003oool0oooo00H0oooo00<0000003loo`0o?ol0
0P0o?ol50?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool00d000000oooo
0?ooo`060?ooo`030000003oool0oooo00L0oooo00=000000?ooo`3oool01P3oool00d000000?coo
03loo`1903loo`H0oooo000V0?ooo``0?coo4@3oool403loo`D0oooo00=000000?ooo`3oool08P3o
ool00d000000oooo0?ooo`0R0?ooo`03@000000o?ol0?coo0080?coo803oool00d000000oooo0?oo
o`0L0?ooo`X0?coo00<0oooo03loo`0o?ol0100o?ol00`3oool0?coo03loo`0403loo`030?ooo`0o
?ol0?coo0080?coo00<0oooo03loo`0o?ol00P0o?ol00`3oool0?coo03loo`0203loo`040?ooo`0o
?ol0?coo0?ooo`@0?coo00<0oooo03loo`0o?ol00P0o?ol0103oool0?coo03loo`3oool203loo`03
0?ooo`0o?ol0?coo0080?coo1`3oool002L0oooo00<000000?ooo`3oool06@3oool403loodh0oooo
1@0o?on60?ooo`009`3oool00`000000oooo0?ooo`0I0?ooo`@0?coo403oool403loocX0oooo100o
?on70?ooo`009`3oool00`000000oooo0?ooo`0I0?ooo`@0?coo403oool403loocX0oooo100o?on7
0?ooo`009`3oool00`000000oooo0?ooo`0I0?ooo`@0?coo403oool403looa/0oooo100o?olJ0?oo
o`@0?cooR03oool002L0oooo00<00000@000003oool06P3oool403looa00oooo0P0o?olL0?ooo`@0
?coo6P3oool403loohP0oooo000W0?ooo`030000003oool0oooo01X0oooo100o?ol^0?ooo`@0?coo
6P3oool403loohP0oooo000W0?ooo`030000003oool0oooo01X0oooo100o?ol_0?ooo`80?coo6@3o
ool503loohT0oooo000W0?ooo`030000003oool0oooo01/0oooo100o?om90?ooo`@0?cooRP3oool0
02L0oooo00<000000?ooo`3oool06`3oool403loodT0oooo100o?on:0?ooo`009`3oool00`000000
oooo0?ooo`0K0?ooo`@0?cooBP3oool203looh/0oooo000W0?ooo`030000003oool0oooo01/0oooo
100o?ol>0?ooo`@0?coo=P3oool403looh/0oooo000W0?ooo`030000003oool0oooo01/0oooo100o
?ol>0?ooo`@0?coo7@3oool403looaD0oooo100o?on;0?ooo`009`3oool00`00001000000?ooo`0K
0?ooo`@0?coo3P3oool403looad0oooo100o?olE0?ooo`@0?cooR`3oool002L0oooo00<000000?oo
o`3oool0703oool203looa00oooo0P0o?olN0?ooo`@0?coo5P3oool203looh`0oooo000W0?ooo`03
0000003oool0oooo01`0oooo100o?ol_0?ooo`80?coo503oool403loohd0oooo000W0?ooo`030000
003oool0oooo01`0oooo100o?om50?ooo`@0?cooS@3oool002L0oooo00<000000?ooo`3oool0703o
ool403loodD0oooo100o?on=0?ooo`009`3oool00`000000oooo0?ooo`0M0?ooo`@0?coo@`3oool4
03loohh0oooo000W0?ooo`030000003oool0oooo01d0oooo100o?ol;0?ooo`@0?coo7`3oool403lo
oa40oooo100o?on>0?ooo`009`3oool00`00001000000?ooo`0M0?ooo`@0?coo2`3oool403looal0
oooo100o?olA0?ooo`@0?cooSP3oool002L0oooo00<000000?ooo`3oool07P3oool203loo``0oooo
100o?olO0?ooo`@0?coo4P3oool203loohl0oooo000W0?ooo`030000003oool0oooo01d0oooo100o
?ol<0?ooo`80?coo8@3oool203looa00oooo100o?on@0?ooo`009`3oool00`000000oooo0?ooo`0M
0?ooo`@0?coo@@3oool403looi00oooo000W0?ooo`030000003oool0oooo01d0oooo100o?om10?oo
o`@0?cooT03oool002L0oooo00<000000?ooo`3oool07P3oool203looc00oooo100o?ol?0?ooo`80
?cooT@3oool002L0oooo00<000000?ooo`3oool07P3oool403loo`T0oooo100o?olQ0?ooo`@0?coo
3@3oool403looi40oooo000W0?ooo`03000004000000oooo01h0oooo100o?ol90?ooo`@0?coo8@3o
ool403loo`d0oooo100o?onA0?ooo`009`3oool00`000000oooo0?ooo`0N0?ooo`@0?coo2@3oool4
03loob80oooo0P0o?ol>0?ooo`@0?cooT@3oool002L0oooo00<000000?ooo`3oool07`3oool203lo
o`/0oooo0P0o?olb0?ooo`@0?cooTP3oool002L0oooo00<000000?ooo`3oool07`3oool403loobh0
oooo100o?ol;0?ooo`@0?cooTP3oool002L0oooo00<000000?ooo`3oool07`3oool403loobh0oooo
100o?ol;0?ooo`@0?cooTP3oool000d0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`030?ooo`030000003oool0oooo01l0oooo100o?ol70?ooo`@0?coo8`3oool403loo`T0oooo1@0o
?onC0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=00000
0?oood0000000P3oool00d000000oooo@00000040?ooo`030000003oool0oooo0200oooo0P0o?ol8
0?ooo`@0?coo903oool203loo`X0oooo100o?onD0?ooo`00303oool00d000000oooo@00000070?oo
o`03@000003ooom000000080oooo00=000000?oood000000103oool00d000000oooo0?ooo`020?oo
o`03000004000000oooo0200oooo100o?ol60?ooo`@0?coo9@3oool403loo`L0oooo100o?onD0?oo
o`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood00
00000P3oool2@00000D0oooo00<000000?ooo`3oool0803oool403loo`L0oooo0P0o?olV0?ooo`@0
?coo1P3oool403looiD0oooo000<0?ooo`03@000003ooom0000000L0oooo00=000000?oood000000
0P3oool00d000000oooo@00000020?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0
803oool403loobl0oooo100o?ol60?ooo`@0?cooU@3oool000d0oooo00=000000?ooo`3oool01`3o
ool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo0?ooo`=00000103oool00`000000oooo
0?ooo`0P0?ooo`@0?coo1@3oool403loobL0oooo100o?ol40?ooo`D0?cooU@3oool002L0oooo00<0
00000?ooo`3oool0803oool403loo`D0oooo100o?olW0?ooo`@0?coo103oool403looiH0oooo000W
0?ooo`030000003oool0oooo0200oooo100o?ol50?ooo`@0?coo9`3oool503loo`030?ooo`0o?ol0
?coo00@0?cooUP3oool002L0oooo00<000000?ooo`3oool08@3oool403loo`D0oooo0P0o?olY0?oo
o`X0?cooU`3oool002L0oooo00<000000?ooo`3oool08@3oool403loo`<0oooo100o?olY0?ooo`T0
?cooV03oool002L0oooo00<00000@000003oool08@3oool403loo`<0oooo100o?olZ0?ooo`L0?coo
V@3oool002L0oooo00<000000?ooo`3oool08P3oool403loo`80oooo100o?ol[0?ooo`D0?cooVP3o
ool002L0oooo00<000000?ooo`3oool08P3oool403loo`80oooo100o?ol]0?ooo`80?cooV`3oool0
02L0oooo00<000000?ooo`3oool08P3oool403loo`80oooo100o?oo:0?ooo`009`3oool00`000000
oooo0?ooo`0S0?ooo`@0?coo00<0oooo03loo`0o?ol00P0o?oo:0?ooo`009`3oool00`000000oooo
0?ooo`0S0?ooo`P0?coob`3oool002L0oooo00<000000?ooo`3oool08`3oool803lool/0oooo000W
0?ooo`03000004000000oooo02<0oooo200o?oo;0?ooo`009`3oool00`000000oooo0?ooo`0T0?oo
o`H0?cooc03oool002L0oooo00<000000?ooo`3oool09@3oool403loold0oooo000W0?ooo`030000
003oool0oooo02H0oooo0P0o?oo>0?ooo`009`3oool00d000000oooo0?ooo`3f0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.05986, -0.0153408, 
  0.537653, 0.000137544}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{503, 367},
WindowMargins->{{18, Automatic}, {30, Automatic}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 101, 3, 48, "Input"],
Cell[1813, 54, 65, 0, 33, "Text"],
Cell[1881, 56, 1261, 53, 1020, "Input"],
Cell[3145, 111, 44, 0, 33, "Text"],
Cell[3192, 113, 136, 14, 246, "Input"],
Cell[3331, 129, 47, 0, 33, "Text"],
Cell[3381, 131, 73, 0, 30, "Input"],
Cell[3457, 133, 71, 0, 30, "Input"],
Cell[3531, 135, 50, 0, 33, "Text"],
Cell[3584, 137, 219, 4, 84, "Input"],
Cell[3806, 143, 34, 0, 33, "Text"],
Cell[3843, 145, 105, 3, 48, "Input"],
Cell[3951, 150, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[4000, 154, 448, 11, 210, "Input"],
Cell[4451, 167, 37356, 1012, 280, 10143, 671, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[41822, 1182, 183, 3, 52, "Text"],
Cell[42008, 1187, 134, 3, 66, "Input"],
Cell[42145, 1192, 42, 0, 33, "Text"],
Cell[42190, 1194, 131, 3, 48, "Input"],
Cell[42324, 1199, 64, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[42413, 1203, 178, 5, 84, "Input"],
Cell[42594, 1210, 21606, 602, 186, 6708, 414, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

